/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.guiutil;

import com.aastra.oamp.guiutil.GuiUtilButton;
import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilTabbedPane;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import java.awt.Dimension;

public class GuiUtilButtonBar
extends AastraPanel {
    private static final long serialVersionUID = 1L;
    public AastraButton buttonOK = null;
    public AastraButton buttonCancel = null;
    public AastraButton buttonUpdate = null;
    public AastraButton buttonRestart = null;
    public AastraButton buttonOptional = null;
    private String buttonOptionalText = null;
    public AastraLabel labelInfo = null;
    public GuiUtilChangeHandler utilChangeHandler = null;
    private int xPosButtonOK = 0;
    private int xPosButtonCancel = 0;
    private int xPosButtonUpdate = 0;
    private int xPosbuttonRestartOptional = 0;
    private int buttonSpace = 0;
    private int infoPositionX = 400;
    private GuiUtilTabbedPane tabbedPane = null;

    public GuiUtilButtonBar(int n) {
        this.initialize(n, false, false, false);
        this.utilChangeHandler = new GuiUtilChangeHandler(this.buttonOK, this.buttonCancel);
    }

    public GuiUtilButtonBar(int n, GuiUtilTabbedPane guiUtilTabbedPane) {
        this.initialize(n, false, false, false);
        this.tabbedPane = guiUtilTabbedPane;
        this.utilChangeHandler = new GuiUtilChangeHandler(this.buttonOK, this.buttonCancel, this.tabbedPane);
    }

    public GuiUtilButtonBar(int n, GuiUtilTabbedPane guiUtilTabbedPane, boolean bl, boolean bl2) {
        this.initialize(n, bl, bl2, false);
        this.tabbedPane = guiUtilTabbedPane;
        this.utilChangeHandler = new GuiUtilChangeHandler(this.buttonOK, this.buttonCancel, this.tabbedPane);
    }

    public GuiUtilButtonBar(int n, GuiUtilTabbedPane guiUtilTabbedPane, String string) {
        if (string != null) {
            this.buttonOptionalText = string;
            this.initialize(n, false, false, true);
        } else {
            this.initialize(n, false, false, false);
        }
        this.tabbedPane = guiUtilTabbedPane;
        this.utilChangeHandler = new GuiUtilChangeHandler(this.buttonOK, this.buttonCancel, this.tabbedPane);
    }

    private void initialize(int n, boolean bl, boolean bl2, boolean bl3) {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(n, 55));
        this.setMaximumSize(new Dimension(n, 55));
        this.setAlignmentX(0.0f);
        if (bl || bl2 || bl3) {
            this.xPosButtonOK = this.buttonSpace = 55;
            this.xPosButtonCancel = this.xPosButtonOK + 90 + this.buttonSpace;
            this.xPosButtonUpdate = this.xPosButtonCancel + 90 + this.buttonSpace;
            this.xPosbuttonRestartOptional = this.xPosButtonUpdate + 90 + this.buttonSpace;
        } else {
            this.buttonSpace = 70;
            this.xPosButtonOK = (n - 180 - this.buttonSpace) / 2;
            this.xPosButtonCancel = this.xPosButtonOK + 90 + this.buttonSpace;
        }
        this.add(this.getButtonOK());
        this.add(this.getButtonCancel());
        if (bl) {
            this.add(this.getButtonUpdate());
            this.add(this.getButtonRestart());
        }
        if (bl3) {
            this.add(this.getButtonOptional());
        }
        if (bl2) {
            this.add(this.getLabelInfo());
        }
    }

    private AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = GuiUtilButton.ButtonOK(this.xPosButtonOK, 15);
            this.buttonOK.setEnabled(false);
        }
        return this.buttonOK;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = GuiUtilButton.ButtonCancel(this.xPosButtonCancel, 15);
            this.buttonCancel.setEnabled(false);
        }
        return this.buttonCancel;
    }

    private AastraButton getButtonUpdate() {
        if (this.buttonUpdate == null) {
            this.buttonUpdate = GuiUtilButton.ButtonOptional(this.xPosButtonUpdate, 15, UtilLocale.getString("TXT_UPDATE"));
            this.buttonUpdate.setToolTipText(UtilLocale.getString("TXT_REQUEST_IMMEDIATE_RFP_SOFTWARE_AND_CONFIG_FILE_UPDATE"));
        }
        return this.buttonUpdate;
    }

    private AastraButton getButtonRestart() {
        if (this.buttonRestart == null) {
            this.buttonRestart = GuiUtilButton.ButtonOptional(this.xPosbuttonRestartOptional, 15, UtilLocale.getString("TXT_RESTART"));
            this.buttonRestart.setToolTipText(UtilLocale.getString("TXT_REQUEST_OMM_RESTART"));
        }
        return this.buttonRestart;
    }

    private AastraLabel getLabelInfo() {
        if (this.labelInfo == null) {
            this.labelInfo = new AastraLabel();
            this.labelInfo.setBounds(this.infoPositionX, 10, 280, 47);
            this.labelInfo.setTextHtml(UtilLocale.getString("TXT_INFO_OMM_RESET_CHANGE_SETTINGS"));
            this.labelInfo.setIcon(GuiUtilIcon.getIconInfo(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
        }
        return this.labelInfo;
    }

    private AastraButton getButtonOptional() {
        if (this.buttonOptional == null) {
            this.buttonOptional = GuiUtilButton.ButtonOptional(this.xPosbuttonRestartOptional, 15, this.buttonOptionalText);
        }
        return this.buttonOptional;
    }
}

