/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.guiutil;

import com.aastra.oamp.guiutil.GuiUtilTabbedPane;
import com.aastra.style.AastraButton;
import java.util.LinkedList;
import javax.swing.JRootPane;

public class GuiUtilChangeHandler {
    private AastraButton buttonOK = null;
    private AastraButton buttonCancel = null;
    private JRootPane rootPane = null;
    private boolean enableCancelButton = true;
    private GuiUtilTabbedPane tabbedPane = null;
    private boolean activated = false;
    private LinkedList<GuiUtilChangeHandlerActivatedInterface> listenerList = new LinkedList();

    public void registerActivatedListener(GuiUtilChangeHandlerActivatedInterface guiUtilChangeHandlerActivatedInterface) {
        this.listenerList.add(guiUtilChangeHandlerActivatedInterface);
    }

    public void deregisterActivatedListener(GuiUtilChangeHandlerActivatedInterface guiUtilChangeHandlerActivatedInterface) {
        this.listenerList.remove(guiUtilChangeHandlerActivatedInterface);
    }

    private void ActivatedNotification() {
        for (GuiUtilChangeHandlerActivatedInterface guiUtilChangeHandlerActivatedInterface : this.listenerList) {
            if (guiUtilChangeHandlerActivatedInterface == null) continue;
            guiUtilChangeHandlerActivatedInterface.isActivated(this.activated);
        }
    }

    public GuiUtilChangeHandler(AastraButton aastraButton, AastraButton aastraButton2) {
        this.buttonOK = aastraButton;
        this.buttonCancel = aastraButton2;
    }

    public GuiUtilChangeHandler(AastraButton aastraButton, AastraButton aastraButton2, GuiUtilTabbedPane guiUtilTabbedPane) {
        this.buttonOK = aastraButton;
        this.buttonCancel = aastraButton2;
        this.tabbedPane = guiUtilTabbedPane;
    }

    public GuiUtilChangeHandler(AastraButton aastraButton, AastraButton aastraButton2, boolean bl) {
        this.buttonOK = aastraButton;
        this.buttonCancel = aastraButton2;
        this.enableCancelButton = bl;
    }

    public void initRootPane(JRootPane jRootPane) {
        if (jRootPane != null) {
            this.rootPane = jRootPane;
        }
    }

    public boolean isActivated() {
        return this.activated;
    }

    private void changeActivated(boolean bl) {
        this.activated = bl;
        this.ActivatedNotification();
    }

    public void activate() {
        this.changeActivated(true);
        this.buttonOK.setEnabled(true);
        if (this.enableCancelButton) {
            this.buttonCancel.setEnabled(true);
        }
        if (this.rootPane != null) {
            this.rootPane.setDefaultButton(this.buttonOK);
        }
        if (this.tabbedPane != null) {
            this.tabbedPane.setCurrentTabChanged(true);
        }
    }

    public void activateOnError() {
        this.buttonCancel.setEnabled(true);
        if (this.rootPane != null) {
            this.rootPane.setDefaultButton(this.buttonCancel);
        }
        if (this.tabbedPane != null) {
            this.tabbedPane.setCurrentTabChanged(true);
        }
    }

    public void deactivate() {
        this.changeActivated(false);
        this.buttonOK.setEnabled(false);
        if (this.enableCancelButton) {
            this.buttonCancel.setEnabled(false);
        }
        if (this.rootPane != null) {
            this.rootPane.setDefaultButton(this.buttonCancel);
        }
        if (this.tabbedPane != null) {
            this.tabbedPane.setCurrentTabChanged(false);
        }
    }

    public static interface GuiUtilChangeHandlerActivatedInterface {
        public void isActivated(boolean var1);
    }
}

