/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.guiutil;

import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilTableColSelect;
import com.aastra.oamp.util.UtilGeneralBooleanSettings;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCheckBox;
import com.aastra.style.AastraDialog;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.BitSet;

public class GuiUtilTableConfigDlgDefault
extends AastraDialog {
    private static final long serialVersionUID = 1L;
    private AastraPanel tableConfigPanel = null;
    private AastraButton buttonOK = null;
    private AastraButton buttonCancel = null;
    private AastraScrollPane itemlistScrollPanel = null;
    private ConfiguratorTable table = null;
    private int[] allColumnsArraySorted = null;
    protected AastraCheckBox[] checkBoxActiveArray;
    private UtilPreferences.TableColSelectKeyTypeEnum key = null;
    private AastraPanel itemListPanel = null;
    private String title = null;
    private int selectedColumnNum = 0;
    private String[] columnNamesArray = null;
    private String[] colHeaderToolTipsArray = null;
    private boolean isSorted;
    private AastraCheckBox checkBoxDefault = null;
    private GuiUtilTableColSelect[] tableCol = null;
    private int sizeCol;

    public GuiUtilTableConfigDlgDefault(ConfiguratorTable configuratorTable, GuiUtilTableColSelect[] guiUtilTableColSelectArray, UtilPreferences.TableColSelectKeyTypeEnum tableColSelectKeyTypeEnum) {
        super(GuiMain.getGuiMainObject());
        this.table = configuratorTable;
        this.columnNamesArray = this.table.getColumnNamesArr();
        this.tableCol = guiUtilTableColSelectArray;
        this.key = tableColSelectKeyTypeEnum;
        this.sizeCol = this.tableCol.length;
        this.initialize();
    }

    public GuiUtilTableConfigDlgDefault(ConfiguratorTable configuratorTable, GuiUtilTableColSelect[] guiUtilTableColSelectArray, UtilPreferences.TableColSelectKeyTypeEnum tableColSelectKeyTypeEnum, String[] stringArray) {
        super(GuiMain.getGuiMainObject());
        this.table = configuratorTable;
        this.columnNamesArray = this.table.getColumnNamesArr();
        this.tableCol = guiUtilTableColSelectArray;
        this.key = tableColSelectKeyTypeEnum;
        this.colHeaderToolTipsArray = stringArray;
        this.sizeCol = this.tableCol.length;
        this.initialize();
    }

    private void initialize() {
        this.isSorted = UtilGeneralBooleanSettings.getSingleId(UtilGeneralBooleanSettings.SettingIdsEnum.TABLE_COL_SELECTION_SORTED_ALPHABETICALLY);
        this.setSize(290, 490);
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setLocationRelativeTo(null);
        if (this.title != null) {
            this.setTitle(this.title);
        } else {
            this.setTitle(UtilLocale.getString("TXT_SELECT_COLUMNS"));
        }
        this.setContentPane(this.getTableConfigPanel());
        this.getRootPane().setDefaultButton(this.getButtonOK());
    }

    private AastraPanel getTableConfigPanel() {
        if (this.tableConfigPanel == null) {
            this.tableConfigPanel = new AastraPanel();
            this.tableConfigPanel.setLayout(null);
            this.tableConfigPanel.add(this.getItemListScrollPanel());
            this.tableConfigPanel.add(this.getCheckBoxDefault());
            this.tableConfigPanel.add(this.getButtonOK());
            this.tableConfigPanel.add(this.getButtonCancel());
        }
        return this.tableConfigPanel;
    }

    private AastraCheckBox getCheckBoxDefault() {
        if (this.checkBoxDefault == null) {
            this.checkBoxDefault = new AastraCheckBox();
            this.checkBoxDefault.setBounds(40, 370, 180, 22);
            this.checkBoxDefault.setText(UtilLocale.getString("TXT_SET_DEFAULT_SELECTION"));
            if (this.isDefaultSet()) {
                this.checkBoxDefault.setSelected(true);
                this.checkBoxDefault.setEnabled(false);
            } else {
                this.checkBoxDefault.setSelected(false);
                this.checkBoxDefault.setEnabled(true);
            }
            this.checkBoxDefault.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (GuiUtilTableConfigDlgDefault.this.checkBoxDefault.isSelected()) {
                        GuiUtilTableConfigDlgDefault.this.setDefault();
                        GuiUtilTableConfigDlgDefault.this.checkBoxDefault.setEnabled(false);
                    }
                }
            });
        }
        return this.checkBoxDefault;
    }

    private boolean isDefaultSet() {
        for (int i = 0; i < this.sizeCol; ++i) {
            if (this.checkBoxActiveArray[i].isSelected() == this.tableCol[this.getAllColumnsArrayIdx((int)i)].isDefault) continue;
            return false;
        }
        return true;
    }

    private void setDefault() {
        for (int i = 0; i < this.sizeCol; ++i) {
            this.checkBoxActiveArray[i].setSelected(this.tableCol[this.getAllColumnsArrayIdx((int)i)].isDefault);
        }
    }

    protected AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            this.buttonOK.setBounds(43, 415, 76, 26);
            this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiUtilTableConfigDlgDefault.this.setAndSaveActiveColumns();
                    GuiUtilTableConfigDlgDefault.this.setVisible(false);
                }
            });
        }
        return this.buttonOK;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            this.buttonCancel.setBounds(162, 415, 76, 26);
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiUtilTableConfigDlgDefault.this.setVisible(false);
                }
            });
        }
        return this.buttonCancel;
    }

    private AastraScrollPane getItemListScrollPanel() {
        if (this.itemlistScrollPanel == null) {
            this.itemlistScrollPanel = new AastraScrollPane(this.getItemListPanel());
            this.itemlistScrollPanel.setBounds(9, 9, 268, 345);
        }
        return this.itemlistScrollPanel;
    }

    private AastraPanel getItemListPanel() {
        if (this.itemListPanel == null) {
            this.itemListPanel = new AastraPanel();
            this.itemListPanel.setLayout(null);
            this.buildCheckBoxes();
        }
        return this.itemListPanel;
    }

    protected void buildCheckBoxes() {
        BitSet bitSet = UtilPreferences.getTableColumnsSelection(this.key);
        if (bitSet == null) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, GuiUtilTableConfigDlgDefault.class, "Pref key '" + (Object)((Object)this.key) + "' not found");
        }
        this.itemListPanel.setPreferredSize(new Dimension(1, this.sizeCol * 27));
        this.checkBoxActiveArray = new AastraCheckBox[this.sizeCol];
        for (int i = 0; i < this.sizeCol; ++i) {
            this.checkBoxActiveArray[i] = new AastraCheckBox();
            this.checkBoxActiveArray[i].setBounds(30, 20 + i * 25, 180, 22);
            this.checkBoxActiveArray[i].setText(this.getColumnName(i));
            if (bitSet != null) {
                if (bitSet.get(this.getAllColumnsArrayIdx(i))) {
                    this.checkBoxActiveArray[i].setSelected(true);
                    ++this.selectedColumnNum;
                } else {
                    this.checkBoxActiveArray[i].setSelected(false);
                }
            }
            this.checkBoxActiveArray[i].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        GuiUtilTableConfigDlgDefault.this.selectedColumnNum++;
                    } else {
                        GuiUtilTableConfigDlgDefault.this.selectedColumnNum--;
                    }
                    if (GuiUtilTableConfigDlgDefault.this.selectedColumnNum > 0) {
                        GuiUtilTableConfigDlgDefault.this.getButtonOK().setEnabled(true);
                    } else {
                        GuiUtilTableConfigDlgDefault.this.getButtonOK().setEnabled(false);
                    }
                    if (!GuiUtilTableConfigDlgDefault.this.checkBoxDefault.isEnabled()) {
                        GuiUtilTableConfigDlgDefault.this.checkBoxDefault.setSelected(false);
                        GuiUtilTableConfigDlgDefault.this.checkBoxDefault.setEnabled(true);
                    }
                }
            });
            this.itemListPanel.add(this.checkBoxActiveArray[i]);
        }
    }

    protected void setAndSaveActiveColumns() {
        BitSet bitSet = new BitSet();
        if (this.table != null) {
            int n = 0;
            for (int i = 0; i < this.sizeCol; ++i) {
                if (!this.checkBoxActiveArray[i].isSelected()) continue;
                ++n;
            }
            int[] nArray = new int[n];
            n = 0;
            for (int i = 0; i < this.sizeCol; ++i) {
                if (!this.checkBoxActiveArray[i].isSelected()) continue;
                bitSet.set(this.getAllColumnsArrayIdx(i));
                nArray[n++] = this.tableCol[this.getAllColumnsArrayIdx((int)i)].idxCol;
            }
            if (this.isSorted) {
                Arrays.sort(nArray);
            }
            this.table.setColumnArr(nArray, n);
            if (this.colHeaderToolTipsArray != null) {
                this.table.setColumnHeaderToolTips(this.colHeaderToolTipsArray);
            }
        } else {
            for (int i = 0; i < this.sizeCol; ++i) {
                if (!this.checkBoxActiveArray[i].isSelected()) continue;
                bitSet.set(this.getAllColumnsArrayIdx(i));
            }
        }
        UtilPreferences.setTableColumnsSelection(this.key, bitSet);
    }

    private String getColumnName(int n) {
        if (this.isSorted) {
            if (this.allColumnsArraySorted == null) {
                this.sortColumnNames();
            }
            return this.columnNamesArray[this.allColumnsArraySorted[n]];
        }
        return this.columnNamesArray[this.tableCol[n].idxCol];
    }

    private int getAllColumnsArrayIdx(int n) {
        if (this.isSorted) {
            int n2;
            for (n2 = 0; n2 < this.sizeCol && this.tableCol[n2].idxCol != this.allColumnsArraySorted[n]; ++n2) {
            }
            return n2;
        }
        return n;
    }

    private void sortColumnNames() {
        Object[] objectArray = (String[])this.columnNamesArray.clone();
        Arrays.sort(objectArray);
        this.allColumnsArraySorted = new int[this.sizeCol];
        int n = 0;
        block0: for (int i = 0; n < this.allColumnsArraySorted.length && i < objectArray.length; ++i) {
            for (int j = 0; j < this.sizeCol; ++j) {
                if (!((String)objectArray[i]).equals(this.columnNamesArray[this.tableCol[j].idxCol])) continue;
                this.allColumnsArraySorted[n++] = this.tableCol[j].idxCol;
                continue block0;
            }
        }
    }
}

