/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.guiutil;

import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraTextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class GuiUtilTextField
extends AastraTextField
implements KeyListener {
    private static final long serialVersionUID = 1L;
    private GuiUtilChangeHandler utilChangeHandler = null;
    private String currentText = "";
    private String initialText;
    private boolean changed = false;

    public GuiUtilTextField() {
    }

    public GuiUtilTextField(GuiUtilChangeHandler guiUtilChangeHandler) {
        if (guiUtilChangeHandler != null) {
            this.utilChangeHandler = guiUtilChangeHandler;
            this.addKeyListener(this);
        }
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        if (this.utilChangeHandler != null) {
            this.initialText = this.currentText = string;
        }
    }

    @Override
    public String getText() {
        if (this.utilChangeHandler != null) {
            this.initialText = this.currentText = super.getText();
            return this.currentText;
        }
        return super.getText();
    }

    public void setChanged() {
        if (this.utilChangeHandler != null) {
            this.changed = true;
        }
    }

    public boolean isSet() {
        return this.currentText.length() > 0;
    }

    public boolean isChange() {
        if (this.utilChangeHandler != null) {
            if (this.changed) {
                this.changed = false;
                return true;
            }
            return !this.initialText.equals(this.currentText);
        }
        return false;
    }

    public boolean isNotTristate() {
        return !this.getText().equals(AastraCommon.AastraTriStateText);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        String string = super.getText();
        if (this.utilChangeHandler != null && !this.utilChangeHandler.isActivated() && string != null) {
            if (this.currentText == null) {
                if (string.length() > 0) {
                    this.utilChangeHandler.activate();
                }
            } else if (!this.currentText.equals(string)) {
                this.utilChangeHandler.activate();
            }
        }
        this.currentText = string;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

