/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.pp;

import com.aastra.oamp.util.UtilFileHandling;
import com.aastra.omilib.PpEventEnum;
import com.aastra.util.UtilSpy;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class PpActivityLogFile {
    private static Writer ppLog = null;
    private static SimpleDateFormat sdfEvent = null;
    private static boolean loggingActive = false;
    private static boolean firstStart = true;

    public static void SetLog(boolean bl) {
        loggingActive = bl;
        if (loggingActive) {
            PpActivityLogFile.openLog();
        } else {
            PpActivityLogFile.closeLog();
        }
    }

    public static boolean IsLogActive() {
        return loggingActive;
    }

    private static void openLog() {
        if (ppLog == null) {
            try {
                File file = new File(UtilFileHandling.getWorkingDirectory() + File.separator + "pp_event.log");
                if (firstStart) {
                    firstStart = false;
                    if (file.exists()) {
                        file.delete();
                    }
                }
                ppLog = new BufferedWriter(new FileWriter(file, true));
                PpActivityLogFile.writeHeader(true);
                ppLog.flush();
                sdfEvent = new SimpleDateFormat("dd.MM.yy HH:mm:ss");
            }
            catch (FileNotFoundException fileNotFoundException) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, PpActivityLogFile.class, "Opening file 'pp_event.log' failed");
            }
            catch (IOException iOException) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, PpActivityLogFile.class, "Opening file 'pp_event.log' failed");
            }
        }
    }

    private static void closeLog() {
        try {
            if (ppLog != null) {
                PpActivityLogFile.writeHeader(false);
                ppLog.flush();
                ppLog.close();
                ppLog = null;
            }
        }
        catch (IOException iOException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, PpActivityLogFile.class, "Closing 'pp_event.log' failed");
        }
    }

    private static void writeHeader(boolean bl) throws IOException {
        ppLog.write("\n#######################################\n");
        if (bl) {
            ppLog.write("###   OMP PP event log started     ###\n");
        } else {
            ppLog.write("###    OMP PP event log closed     ###\n");
        }
        Calendar calendar = Calendar.getInstance();
        ppLog.write(String.format("###         date: %s          ###\n", new SimpleDateFormat("dd.MM.yy").format(calendar.getTime())));
        ppLog.write(String.format("###         time: %s          ###\n", new SimpleDateFormat("HH:mm:ss").format(calendar.getTime())));
        if (bl) {
            ppLog.write("#######################################\n");
            ppLog.write("# Format:                             #\n");
            ppLog.write("# x DD T PP[....] FP[....]            #\n");
            ppLog.write("#                                     #\n");
            ppLog.write("# x - Event type:                     #\n");
            ppLog.write("#     L   - Link establish            #\n");
            ppLog.write("#     C   - Connect                   #\n");
            ppLog.write("#     H   - Handover                  #\n");
            ppLog.write("#     D   - Call release              #\n");
            ppLog.write("#     P   - Paging started            #\n");
            ppLog.write("#     J   - Setup Reject              #\n");
            ppLog.write("#     B   - Release from PP           #\n");
            ppLog.write("#     N   - PP not found              #\n");
            ppLog.write("#     U   - Location registration     #\n");
            ppLog.write("#     A   - Detach                    #\n");
            ppLog.write("#     SC  - SS establish              #\n");
            ppLog.write("#     SD  - SS release                #\n");
            ppLog.write("#     SF  - SS facility               #\n");
            ppLog.write("#     COC - COMS establish            #\n");
            ppLog.write("#     COD - COMS release              #\n");
            ppLog.write("#                                     #\n");
            ppLog.write("# DD - Date (dd.mm.yy)                #\n");
            ppLog.write("# T  - Time (hh:mm:ss)                #\n");
            ppLog.write("# PP - Portable part                  #\n");
            ppLog.write("# FP - Radio fixed part               #\n");
        }
        ppLog.write("#######################################\n\n");
    }

    public static void writeLog(PpEventEnum ppEventEnum, int n, int n2) {
        if (ppLog != null) {
            Calendar calendar = Calendar.getInstance();
            String string = "";
            if (n2 != -1) {
                string = String.format("FP[%4d]", n2);
            }
            String string2 = String.format("%-3s %s PP[%4d] %s\n", PpEventEnum.toString(ppEventEnum), sdfEvent.format(calendar.getTime()), n, string);
            try {
                ppLog.write(string2);
                ppLog.flush();
            }
            catch (IOException iOException) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, PpActivityLogFile.class, "Writing to file 'pp_event.log' failed");
            }
        }
    }
}

