/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.pp;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.gui.GuiProgressDlgCancel;
import com.aastra.oamp.gui.GuiStatusBar;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilMainPanel;
import com.aastra.oamp.guiutil.GuiUtilTableColSelect;
import com.aastra.oamp.pp.PpConfigDetailPanel;
import com.aastra.oamp.pp.PpConfigTaskPanel;
import com.aastra.oamp.pp.PpUtil;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilFilterTable;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.oamp.util.UtilPrint;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.DatabaseChangeEvent;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.PpDataHandler;
import com.aastra.omilib.PpDataNotificationInterface;
import com.aastra.omilib.PpDataRecord;
import com.aastra.omilib.PpDevDataRecord;
import com.aastra.omilib.PpEventEnum;
import com.aastra.omilib.PpUserByNumberHandler;
import com.aastra.omilib.PpUserDataRecord;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.HashMap;

public class PpConfigMainPanel
extends GuiUtilMainPanel
implements ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface,
DataHandler.DataHandlerSendBulkInterface,
GuiProgressDlgCancel.GuiProgressDlgCancelInterface {
    private static final long serialVersionUID = 1L;
    protected static final int xSizeDetailPanelSurcharge = 300;
    protected static final int ySizeDetailPanelSurcharge = 180;
    protected static final int ySizeDetailPanel = 390;
    private CommonDataHandler commonDataHandler = null;
    private PpDataHandler ppDataHandler = null;
    private PpUserByNumberHandler ppUserByNumberHandler;
    private NotificationHandlerClass ppUserHandler = null;
    private NotificationHandlerClass ppDevHandler = null;
    private GuiUtilDetailSplitPanel ppDetailSplitPane = null;
    private AastraScrollPane ppTablePane = null;
    private PpConfigDetailPanel ppDetailPanel = null;
    private PpConfigTaskPanel ppTaskPanel = null;
    private GuiStatusBar guiStatusBar = null;
    private boolean detailPanelPending = false;
    private HashMap<Integer, Boolean> pendingUid = new HashMap();
    private HashMap<Integer, Boolean> pendingPpn = new HashMap();
    private int dividerLocation = 0;
    private int cntNotificationsToReceive = 0;
    private OmiManagement omiManagement = null;
    private int cntPPSendBulkTotal;
    private int cntPPToChange;
    private DataHandler.SendBulkActionType sendBulkAction = null;
    private GuiProgressDlgCancel guiProgressDlg = null;
    private UtilErrorComp utilErrorComp = null;
    private GuiUtilTableColSelect[] tableColSel = null;

    public PpConfigMainPanel(CommonDataHandler commonDataHandler, PpDataHandler ppDataHandler, PpUserByNumberHandler ppUserByNumberHandler) {
        this.guiStatusBar = GuiMain.getGuiStatusBarObject();
        this.commonDataHandler = commonDataHandler;
        this.ppDataHandler = ppDataHandler;
        PpUtil.initOmiHandler(this.ppDataHandler.getOmiHandler());
        this.ppUserHandler = new NotificationHandlerClass();
        this.ppUserHandler.notificationType = NotificationTypeEnum.USER_NOTIFICATION;
        this.ppDataHandler.registerUserDataNotificationListener(this.ppUserHandler);
        this.ppDevHandler = new NotificationHandlerClass();
        this.ppDevHandler.notificationType = NotificationTypeEnum.DEVICE_NOTIFICATION;
        this.ppDataHandler.registerDevDataNotificationListener(this.ppDevHandler);
        this.omiManagement = GuiMain.getOmiManagementObject();
        this.ppUserByNumberHandler = ppUserByNumberHandler;
        this.ppUserByNumberHandler.registerDataNotificationListener(new ppUserByNumberNotificationClass());
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPpDetailSplitPane(), "Center");
        this.add((Component)this.getPpTaskPanel(), "East");
        this.utilErrorComp = new UtilErrorComp();
    }

    protected GuiUtilTableColSelect[] getTableColumnsSelection() {
        if (this.tableColSel == null) {
            GuiUtilTableColSelect[] guiUtilTableColSelectArray = new GuiUtilTableColSelect[]{new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_PPN), true), new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_IPEI), true), new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_AC), false), new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ENCRYPT), false, GuiUtilIcon.getIconArrayErrorActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_NAME, true), new GuiUtilTableColSelect(PpUserDataRecord.IDX_NUM, true), new GuiUtilTableColSelect(PpUserDataRecord.IDX_HIERARCHY1, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_HIERARCHY2, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_ADD_ID, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_SOS_NUM, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_MAN_DOWN_NUM, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_TRACKING_ACTIVE, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_LOCATABLE, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_LOC_RIGHT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_MSG_RIGHT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_SEND_VCARD_RIGHT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_RECV_VCARD_RIGHT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_VIP, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_SIP_REGISTER_CHECK, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_HOT_DESKING_SUPPORT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_AUTO_LOGOUT_ON_CHARGE, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_AUTHENTICATE_LOGOUT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_FIXED_SIP_PORT, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_CALCULATED_SIP_PORT, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_USE_SIP_USER_NAME, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_USE_SIP_USER_AUTH, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_SERVICE_USER_NAME, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_SERVICE_AUTH_NAME, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_KEY_LOCK_ENABLE, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_KEY_LOCK_TIME, false)};
            int n = 0;
            int n2 = guiUtilTableColSelectArray.length;
            n = this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices) ? (n += 4) : ++n;
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVoiceboxNumber)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveExternalUserData)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveMOM)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                n += 5;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync)) {
                ++n;
            }
            this.tableColSel = Arrays.copyOf(guiUtilTableColSelectArray, n2 + n);
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_UID, true);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_REL_TYPE, true);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_GUI_ATTRIB1, true, GuiUtilIcon.getIconArrayErrorActive());
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_KEEP_LOCAL_PB, false, GuiUtilIcon.getIconArrayInactiveActive());
            } else {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SUBSCRIBED), true, GuiUtilIcon.getIconArrayErrorErrorActive());
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVoiceboxNumber)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_VOICEBOX_NUM, false);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveExternalUserData)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_EXTERNAL, false, GuiUtilIcon.getIconArrayInactiveActive());
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveMOM)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_PERMANENT, false, GuiUtilIcon.getIconArrayInactiveActive());
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_ALLOW_VIDEO_STREAM, false, GuiUtilIcon.getIconArrayInactiveActive());
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_SIP_AUTH_ID, false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_AUTO_ANSWER, false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_MICROPHONE_MUTE, false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_WARNING_TONE, false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_ALLOW_BARGE_IN, false);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_CONFERENCE_SERVER_TYPE, false);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_MONITORING, false);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_CONFIG_DATA_PROFILE_ID, false);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SUBSCRIBE_TO_PARI_ONLY), false, GuiUtilIcon.getIconArrayInactiveActive());
            }
        }
        return this.tableColSel;
    }

    void processUserDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP user notification: " + dataNotificationEnum.toString() + ",uid=" + n);
        switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                break;
            }
            case NEW_DATA: {
                if (!this.detailPanelPending) break;
                this.removePpDetailPanel();
                break;
            }
            case DATA_CHANGED: 
            case DATA_DELETED: {
                if (!this.detailPanelPending) break;
                if (this.pendingUid.containsKey(n) && this.cntNotificationsToReceive > 0) {
                    --this.cntNotificationsToReceive;
                }
                this.pendingUid.remove(n);
                if (!this.pendingUid.isEmpty() || !this.pendingPpn.isEmpty()) break;
                this.removePpDetailPanel();
                this.cntNotificationsToReceive = 0;
                break;
            }
        }
    }

    void processDevDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP device notification: " + dataNotificationEnum.toString() + ",ppn=" + n);
        if (this.detailPanelPending && dataNotificationEnum == DataNotificationEnum.DATA_CHANGED) {
            if (this.pendingPpn.containsKey(n)) {
                this.pendingPpn.remove(n);
                if (this.cntNotificationsToReceive > 0) {
                    --this.cntNotificationsToReceive;
                }
            }
            if (this.pendingPpn.isEmpty() && this.pendingUid.isEmpty()) {
                this.removePpDetailPanel();
                this.cntNotificationsToReceive = 0;
            }
        }
    }

    private void processError(NotificationTypeEnum notificationTypeEnum, int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        OmiMessage.errorCodes errorCodes2 = null;
        String string4 = null;
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP error notification: " + dataNotificationEnum.toString() + ",type=" + notificationTypeEnum.toString() + ",id=" + String.valueOf(n) + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP error notification: unknown errorCode=" + string);
        }
        if (this.detailPanelPending) {
            if (string2 != null) {
                this.ppDetailPanel.markErrorComponent(string2);
            }
            String string5 = this.ppDetailPanel.getErrorLabelText(string2);
            if (errorCodes2 != null) {
                string4 = errorCodes2.equals((Object)OmiMessage.errorCodes.ENoMem) && string2 != null && string2.equals(OmiMessage.PPUserType.permanent.name()) ? UtilLocale.getString("TXT_MAX_NUMBER_OF_PERMANENT_USERS_ALREADY_CONFIGURED_!") : UtilErrorHandling.getErrorMessage(errorCodes2, string5, string3);
            }
            if ((notificationTypeEnum == NotificationTypeEnum.USER_NOTIFICATION && this.pendingUid.containsKey(n) || notificationTypeEnum == NotificationTypeEnum.DEVICE_NOTIFICATION && this.pendingPpn.containsKey(n)) && this.cntNotificationsToReceive > 0) {
                --this.cntNotificationsToReceive;
            }
            if (dataNotificationEnum == DataNotificationEnum.DATA_CHANGED) {
                Integer n2;
                Integer n3;
                PpUserDataRecord[] ppUserDataRecordArray = null;
                PpDevDataRecord[] ppDevDataRecordArray = null;
                int n4 = 0;
                if (notificationTypeEnum == NotificationTypeEnum.USER_NOTIFICATION) {
                    n3 = n;
                    if (!this.pendingUid.containsKey(n3)) {
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "uid=" + String.valueOf(n3) + " does not exist in send map anymore");
                        return;
                    }
                    this.pendingUid.put(n3, true);
                    for (Integer n5 : this.pendingUid.keySet()) {
                        if (!this.pendingUid.get(n5).booleanValue()) continue;
                        ++n4;
                    }
                    ppUserDataRecordArray = new PpUserDataRecord[n4];
                    ppDevDataRecordArray = new PpDevDataRecord[n4];
                    n4 = 0;
                    for (Integer n5 : this.pendingUid.keySet()) {
                        if (!this.pendingUid.get(n5).booleanValue()) continue;
                        ppUserDataRecordArray[n4] = this.ppDataHandler.getPpUserData(n5);
                        if (ppUserDataRecordArray != null && (n2 = (Integer)ppUserDataRecordArray[n4].getField(PpUserDataRecord.IDX_PPN)) != null) {
                            ppDevDataRecordArray[n4] = this.ppDataHandler.getPpDevData(n2);
                        }
                        ++n4;
                    }
                }
                if (notificationTypeEnum == NotificationTypeEnum.DEVICE_NOTIFICATION) {
                    n2 = n;
                    if (!this.pendingPpn.containsKey(n)) {
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "ppn=" + String.valueOf(n) + " does not exist in send map anymore");
                        return;
                    }
                    this.pendingPpn.put(n, true);
                    n4 = 0;
                    for (Integer n5 : this.pendingPpn.keySet()) {
                        if (!this.pendingPpn.get(n5).booleanValue()) continue;
                        ++n4;
                    }
                    ppUserDataRecordArray = new PpUserDataRecord[n4];
                    ppDevDataRecordArray = new PpDevDataRecord[n4];
                    n4 = 0;
                    for (Integer n5 : this.pendingPpn.keySet()) {
                        if (!this.pendingPpn.get(n5).booleanValue()) continue;
                        ppDevDataRecordArray[n4] = this.ppDataHandler.getPpDevData(n5);
                        if (ppDevDataRecordArray != null && (n3 = (Integer)ppDevDataRecordArray[n4].getField(PpDevDataRecord.IDX_UID)) != null) {
                            ppUserDataRecordArray[n4] = this.ppDataHandler.getPpUserData(n3);
                        }
                        ++n4;
                    }
                }
                this.ppDetailPanel.setPpUserDetailData(ppUserDataRecordArray);
                this.ppDetailPanel.setPpDevDetailData(ppDevDataRecordArray);
            }
        } else if (errorCodes2 != null) {
            string4 = UtilErrorHandling.getErrorMessage(errorCodes2, string2, string3);
        }
        if (this.componentActivated) {
            if (string4 != null) {
                GuiInfoConsole.showError(string4);
            } else {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
            }
            if (this.cntNotificationsToReceive == 0) {
                this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
            }
        }
    }

    public void setDetailPanelPending() {
        this.detailPanelPending = true;
    }

    private void clearDetailPanelPending() {
        this.detailPanelPending = false;
        this.pendingUid.clear();
        this.pendingPpn.clear();
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent();
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        int n = this.table.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        DataRecord[] dataRecordArray = new DataRecord[n];
        int[] nArray = this.table.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2 = this.table.convertRowIndexToModel(nArray[i]);
            dataRecordArray[i] = this.ppDataHandler.getDatabase().getRecordByIdx(n2).clone();
        }
        this.createPpDetailPanel(dataRecordArray);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent();
    }

    private void processTableEvent() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = this.table.getSelectedRowCount();
        DataRecord[] dataRecordArray = null;
        int[] nArray = null;
        if (n > 0) {
            bl = true;
            bl3 = true;
            nArray = this.table.getSelectedRows();
            dataRecordArray = new DataRecord[n];
            for (int i = 0; i < n; ++i) {
                int n2 = this.table.convertRowIndexToModel(nArray[i]);
                dataRecordArray[i] = this.ppDataHandler.getDatabase().getRecordByIdx(n2).clone();
            }
            Object object = UtilMisc.getRecordsFieldObject(dataRecordArray, PpUserDataRecord.IDX_REL_TYPE, (Object)OmiMessage.PPRelTypeType.Unbound);
            Object object2 = UtilMisc.getRecordsFieldObject(dataRecordArray, PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SUBSCRIBED), (Object)OmiMessage.DECTSubscriptionStateType.No);
            bl2 = OmiMessage.PPRelTypeType.class == object.getClass() && ((OmiMessage.PPRelTypeType)((Object)object) == OmiMessage.PPRelTypeType.Fixed || (OmiMessage.PPRelTypeType)((Object)object) == OmiMessage.PPRelTypeType.Dynamic) && OmiMessage.DECTSubscriptionStateType.class == object2.getClass() && (OmiMessage.DECTSubscriptionStateType)((Object)object2) != OmiMessage.DECTSubscriptionStateType.No;
        }
        if (this.ppDetailSplitPane.getBottomComponent() != null) {
            if (n > 0) {
                this.createPpDetailPanel(dataRecordArray);
            } else {
                this.removePpDetailPanel();
            }
            bl = false;
            bl2 = false;
        }
        this.ppTaskPanel.setTaskButtonConfigure(bl);
        this.ppTaskPanel.setTaskButtonChangeRelationType(bl2);
        this.ppTaskPanel.setTaskButtonDelete(bl3);
        this.updateTableInfo();
    }

    public void configurePp() {
        int n = this.table.getSelectedRowCount();
        DataRecord[] dataRecordArray = new DataRecord[n];
        int[] nArray = this.table.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2 = this.table.convertRowIndexToModel(nArray[i]);
            dataRecordArray[i] = this.ppDataHandler.getDatabase().getRecordByIdx(n2).clone();
        }
        if (n > 0) {
            this.createPpDetailPanel(dataRecordArray);
        }
    }

    public void changeRelationType() {
        int n = this.table.getSelectedRowCount();
        int[] nArray = this.table.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2 = this.table.convertRowIndexToModel(nArray[i]);
            PpDataRecord ppDataRecord = this.ppDataHandler.getDatabase().getRecordByIdx(n2);
            int n3 = (Integer)((DataRecord)ppDataRecord).getField(PpUserDataRecord.IDX_UID);
            OmiMessage.PPRelTypeType pPRelTypeType = (OmiMessage.PPRelTypeType)((Object)((DataRecord)ppDataRecord).getField(PpUserDataRecord.IDX_REL_TYPE));
            if (pPRelTypeType == OmiMessage.PPRelTypeType.Fixed) {
                this.ppDataHandler.sendSetPPUserDevRelation(n3, OmiMessage.PPRelTypeType.Dynamic);
                continue;
            }
            this.ppDataHandler.sendSetPPUserDevRelation(n3, OmiMessage.PPRelTypeType.Fixed);
        }
    }

    protected void sendGetPpUserByNumber() {
        int n = this.table.getSelectedRowCount();
        int[] nArray = this.table.getSelectedRows();
        if (n == 0) {
            this.ppUserByNumberHandler.sendGetPPUserByNumber("999999999");
        } else {
            for (int i = 0; i < n; ++i) {
                int n2 = this.table.convertRowIndexToModel(nArray[i]);
                PpDataRecord ppDataRecord = this.ppDataHandler.getDatabase().getRecordByIdx(n2);
                this.ppUserByNumberHandler.sendGetPPUserByNumber((String)((DataRecord)ppDataRecord).getField(PpUserDataRecord.IDX_NUM));
            }
        }
    }

    private GuiUtilDetailSplitPanel getPpDetailSplitPane() {
        if (this.ppDetailSplitPane == null) {
            this.ppDetailSplitPane = new GuiUtilDetailSplitPanel(390);
            this.ppDetailSplitPane.setTopComponent(this.getPpTablePane());
            this.ppDetailSplitPane.setBottomComponent(null);
        }
        return this.ppDetailSplitPane;
    }

    private GuiUtilConfiguratorTable getPpTable() {
        if (this.table == null) {
            this.table = new GuiUtilConfiguratorTable((Object)this, (Database)this.ppDataHandler.getDatabase(), this.getTableColumnsSelection(), this.getActiveTableColumns(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectPpConfig, this.getTableColumnsSelection(), true), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthPpConfig);
            this.table.setType(DatabaseChangeEvent.DatabaseChangeType.ALL);
            this.table.setPasswordColum(PpUserDataRecord.IDX_PIN);
            this.table.setPasswordColum(PpUserDataRecord.IDX_SIP_PW);
            this.table.setColumnFormatString(PpUserDataRecord.IDX_UID, "0x%03X");
            this.table.setColumnFormatString(PpUserDataRecord.IDX_PPN, "0x%03X");
            this.table.setColumnFormatString(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_PPN), "0x%03X");
            this.table.setColumnFormatString(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_UID), "0x%03X");
            this.table.setZeroIntAsInvalid(PpUserDataRecord.IDX_KEY_LOCK_TIME);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_UID, 20);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_REL_TYPE, 35);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_GUI_ATTRIB1, 20);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_EXTERNAL, 20);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_HOT_DESKING_SUPPORT, 20);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_AUTO_LOGOUT_ON_CHARGE, 20);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_AUTHENTICATE_LOGOUT, 20);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_PERMANENT, 20);
            this.table.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_PPN), 20);
            this.table.applyPreferredColumnWidthSettings();
        }
        return this.table;
    }

    private AastraScrollPane getPpTablePane() {
        if (this.ppTablePane == null) {
            this.ppTablePane = new AastraScrollPane(this.getPpTable());
            this.dividerLocation = this.ppDetailSplitPane.getHeight() - 390;
            this.ppTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.ppTablePane;
    }

    private void enableTableAccess() {
        this.table.setActive(true);
        this.ppTaskPanel.setTaskButtonCreate(true);
        this.ppTaskPanel.setTaskButtonConfigureTable(true);
        this.ppTaskPanel.setTaskButtonFilter(true);
    }

    private void disableTableAccess() {
        this.table.setActive(false);
        this.ppTaskPanel.setTaskButtonCreate(false);
        this.ppTaskPanel.setTaskButtonConfigure(false);
        this.ppTaskPanel.setTaskButtonChangeRelationType(false);
        this.ppTaskPanel.setTaskButtonDelete(false);
        this.ppTaskPanel.setTaskButtonConfigureTable(false);
        this.ppTaskPanel.setTaskButtonFilter(false);
    }

    protected void configureTableFilter() {
        boolean bl = UtilFilterTable.setFilterItems(this.table, UtilPreferences.getTableFilterValues(UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesPpConfig));
        this.ppTaskPanel.setTaskButtonFilterState(bl, null);
    }

    private AastraPanel getPpDetailPanel() {
        if (this.ppDetailPanel == null) {
            this.ppDetailPanel = new PpConfigDetailPanel(this, this.utilErrorComp);
        }
        return this.ppDetailPanel;
    }

    private AastraPanel getPpTaskPanel() {
        if (this.ppTaskPanel == null) {
            this.ppTaskPanel = new PpConfigTaskPanel(this, this.commonDataHandler, this.getPpTable());
        }
        return this.ppTaskPanel;
    }

    public void StartPpCreation() {
        this.table.removeRowSelectionAll();
        this.createPpDetailPanel(null);
    }

    private void createPpDetailPanel(DataRecord[] dataRecordArray) {
        if (this.ppDetailSplitPane.getBottomComponent() != null) {
            this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
            this.utilErrorComp.clearComponents();
            this.dividerLocation = this.ppDetailSplitPane.getDividerLocation();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating PP config detail panel");
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating PP config detail panel");
            this.ppDetailSplitPane.setBottomComponent(this.getPpDetailPanel());
            this.ppDetailPanel.setDefaultTab();
        }
        if (dataRecordArray != null) {
            DataRecord[] dataRecordArray2 = new DataRecord[dataRecordArray.length];
            DataRecord[] dataRecordArray3 = new DataRecord[dataRecordArray.length];
            for (int i = 0; i < dataRecordArray.length; ++i) {
                PpDataRecord ppDataRecord = (PpDataRecord)dataRecordArray[i];
                dataRecordArray2[i] = ppDataRecord.ppUser;
                dataRecordArray3[i] = ppDataRecord.ppDev;
                Integer n = (Integer)dataRecordArray2[i].getField(PpUserDataRecord.IDX_UID);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading PP user[" + n + "]:");
                UtilPrint.printPpUserDataRecordString((PpUserDataRecord)dataRecordArray2[i], this);
                Integer n2 = (Integer)dataRecordArray3[i].getField(PpDevDataRecord.IDX_PPN);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading PP device[" + n2 + "]:");
                UtilPrint.printPpDevDataRecordString((PpDevDataRecord)dataRecordArray3[i], this);
            }
            this.ppDetailPanel.setPpUserDetailData(dataRecordArray2);
            this.ppDetailPanel.setPpDevDetailData(dataRecordArray3);
        } else {
            this.ppDetailPanel.setPpUserDetailData(null);
            this.ppDetailPanel.setPpDevDetailData(null);
        }
        this.ppDetailPanel.requestDefaultFocusInWindow();
        this.ppDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.ppDetailSplitPane.validate();
        this.ppTaskPanel.setTaskButtonConfigure(false);
        this.ppTaskPanel.setTaskButtonChangeRelationType(false);
    }

    public void removePpDetailPanel() {
        int n = this.table.getSelectedRowCount();
        DataRecord[] dataRecordArray = null;
        int[] nArray = null;
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing PP config detail panel");
        this.clearDetailPanelPending();
        this.utilErrorComp.clearComponents();
        this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
        this.dividerLocation = this.ppDetailSplitPane.getDividerLocation();
        this.ppDetailSplitPane.setBottomComponent(null);
        if (n >= 0) {
            this.ppTaskPanel.setTaskButtonConfigure(true);
            this.ppTaskPanel.setTaskButtonDelete(true);
        } else {
            this.ppTaskPanel.setTaskButtonDelete(false);
        }
        if (n > 0) {
            nArray = this.table.getSelectedRows();
            dataRecordArray = new DataRecord[n];
            for (int i = 0; i < n; ++i) {
                int n2 = this.table.convertRowIndexToModel(nArray[i]);
                dataRecordArray[i] = this.ppDataHandler.getDatabase().getRecordByIdx(n2).clone();
            }
            Object object = UtilMisc.getRecordsFieldObject(dataRecordArray, PpUserDataRecord.IDX_REL_TYPE, (Object)OmiMessage.PPRelTypeType.Unbound);
            if (OmiMessage.PPRelTypeType.class == object.getClass() && (OmiMessage.PPRelTypeType)((Object)object) == OmiMessage.PPRelTypeType.Fixed || (OmiMessage.PPRelTypeType)((Object)object) == OmiMessage.PPRelTypeType.Dynamic) {
                this.ppTaskPanel.setTaskButtonChangeRelationType(true);
            } else {
                this.ppTaskPanel.setTaskButtonChangeRelationType(false);
            }
        }
    }

    public void createPp() {
        PpUserDataRecord[] ppUserDataRecordArray = (PpUserDataRecord[])this.ppDetailPanel.getPpUserDetailData();
        PpDevDataRecord[] ppDevDataRecordArray = (PpDevDataRecord[])this.ppDetailPanel.getPpDevDetailData();
        if (ppUserDataRecordArray == null) {
            return;
        }
        this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_BUSY, null);
        PpUserDataRecord ppUserDataRecord = ppUserDataRecordArray[0];
        PpDevDataRecord ppDevDataRecord = ppDevDataRecordArray[0];
        ppUserDataRecord.setField(PpUserDataRecord.IDX_REL_TYPE, (Object)OmiMessage.PPRelTypeType.Fixed);
        ppDevDataRecord.setField(PpDevDataRecord.IDX_REL_TYPE, (Object)OmiMessage.PPRelTypeType.Fixed);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating PP user:");
        UtilPrint.printPpUserDataRecordString(ppUserDataRecord, this);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating PP device:");
        UtilPrint.printPpDevDataRecordString(ppDevDataRecord, this);
        PpDataRecord ppDataRecord = new PpDataRecord(ppUserDataRecord, ppDevDataRecord);
        this.ppDataHandler.sendCreatePp(ppDataRecord);
        this.setDetailPanelPending();
    }

    public void changePp() {
        int n;
        DataRecord[] dataRecordArray = null;
        PpUserDataRecord[] ppUserDataRecordArray = (PpUserDataRecord[])this.ppDetailPanel.getPpUserDetailData();
        PpDevDataRecord[] ppDevDataRecordArray = (PpDevDataRecord[])this.ppDetailPanel.getPpDevDetailData();
        if (ppUserDataRecordArray == null || ppDevDataRecordArray == null) {
            return;
        }
        this.cntPPSendBulkTotal = 0;
        this.cntPPToChange = 0;
        for (n = 0; n < ppUserDataRecordArray.length; ++n) {
            boolean bl = false;
            if (ppUserDataRecordArray[n].getRecordChanged()) {
                this.ppDataHandler.getUserDatabase().updateTransientFields(ppUserDataRecordArray[n]);
                ++this.cntPPSendBulkTotal;
                ++this.cntNotificationsToReceive;
                bl = true;
                this.pendingUid.put((Integer)ppUserDataRecordArray[n].getField(PpUserDataRecord.IDX_UID), false);
            }
            if (ppDevDataRecordArray[n].getRecordChanged()) {
                this.ppDataHandler.getDevDatabase().updateTransientFields(ppDevDataRecordArray[n]);
                ++this.cntPPSendBulkTotal;
                ++this.cntNotificationsToReceive;
                bl = true;
                this.pendingPpn.put((Integer)ppDevDataRecordArray[n].getField(PpDevDataRecord.IDX_PPN), false);
            }
            if (!bl) continue;
            ++this.cntPPToChange;
        }
        if (this.cntPPSendBulkTotal > 0) {
            n = 0;
            dataRecordArray = new DataRecord[this.cntPPSendBulkTotal];
            for (int i = 0; i < ppUserDataRecordArray.length; ++i) {
                if (ppUserDataRecordArray[i].getRecordChanged()) {
                    dataRecordArray[n++] = ppUserDataRecordArray[i];
                }
                if (!ppDevDataRecordArray[i].getRecordChanged()) continue;
                dataRecordArray[n++] = ppDevDataRecordArray[i];
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, String.format("Changing %d PP(s)\n", this.cntPPToChange));
            this.sendBulkAction = DataHandler.SendBulkActionType.Change;
            this.ppDataHandler.sendChangeDeletePPs(this.sendBulkAction, dataRecordArray, this);
            this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_BUSY, null);
            this.setDetailPanelPending();
            if (this.cntPPSendBulkTotal > 1) {
                this.guiProgressDlg = new GuiProgressDlgCancel(UtilLocale.getString("TXT_CHANGING_PPS_IN_PROGRESS"), false, true, this);
                this.guiProgressDlg.setValue(0);
                this.guiProgressDlg.setVisible(true);
            }
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Change PP(s): OMILIB told us there is nothing to do (all PP user and device attributes are unchanged)");
            this.removePpDetailPanel();
        }
    }

    public void deletePp() {
        GuiUtilDialog guiUtilDialog;
        DataRecord[] dataRecordArray = null;
        int n = this.table.getSelectedRowCount();
        if (n > 0 && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_DELETE_SELECTED_PORTABLE_PARTS_?"), true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            DataRecord dataRecord;
            int n2;
            int n3;
            int[] nArray = this.table.getSelectedRows();
            int n4 = 0;
            this.cntNotificationsToReceive = nArray.length;
            this.cntPPSendBulkTotal = nArray.length;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = this.table.convertRowIndexToModel(nArray[n3]);
                dataRecord = this.ppDataHandler.getDatabase().getRecordByIdx(n2);
                if (((PpDataRecord)dataRecord).getField(PpUserDataRecord.IDX_REL_TYPE) != OmiMessage.PPRelTypeType.Dynamic) continue;
                ++this.cntPPSendBulkTotal;
            }
            dataRecordArray = new DataRecord[this.cntPPSendBulkTotal];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = this.table.convertRowIndexToModel(nArray[n3]);
                dataRecord = this.ppDataHandler.getDatabase().getRecordByIdx((int)n2).ppUser;
                int n5 = (Integer)((PpUserDataRecord)dataRecord).getField(PpUserDataRecord.IDX_UID);
                dataRecordArray[n4++] = dataRecord;
                if (((PpUserDataRecord)dataRecord).getField(PpUserDataRecord.IDX_REL_TYPE) == OmiMessage.PPRelTypeType.Dynamic) {
                    dataRecordArray[n4++] = this.ppDataHandler.getDatabase().getRecordByIdx((int)n2).ppDev;
                }
                if (this.ppDetailSplitPane.getBottomComponent() == null || this.ppDetailPanel.getSelectedPpUser() != n5) continue;
                this.setDetailPanelPending();
                this.pendingUid.put(n5, false);
            }
            this.sendBulkAction = DataHandler.SendBulkActionType.Delete;
            this.ppDataHandler.sendChangeDeletePPs(this.sendBulkAction, dataRecordArray, this);
            if (this.cntPPSendBulkTotal > 1) {
                this.guiProgressDlg = new GuiProgressDlgCancel(UtilLocale.getString("TXT_DELETING_PPS_IN_PROGRESS"), false, true, this);
                this.guiProgressDlg.setValue(0);
                this.guiProgressDlg.setVisible(true);
            }
        }
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        if (this.ppDetailSplitPane.getBottomComponent() != null) {
            this.createPpDetailPanel(dataRecordArray);
        }
    }

    @Override
    protected void componentActivateAction() {
        this.configureTableFilter();
        this.table.updateAllSelectedBox();
    }

    @Override
    public void notifyProgress(int n, boolean bl) {
        if (bl || n == this.cntPPSendBulkTotal) {
            if (this.guiProgressDlg != null) {
                this.guiProgressDlg.dispose();
            }
            GuiMain.getGuiStatusBarObject().showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
            if (bl) {
                if (this.sendBulkAction == DataHandler.SendBulkActionType.Change) {
                    GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_CHANGING_PPS_CANCELED_AFTER_*_OF_*_REQUESTS"), n, this.cntPPSendBulkTotal));
                } else {
                    GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_DELETING_PPS_CANCELED_AFTER_*_OF_*_REQUESTS"), n, this.cntPPSendBulkTotal));
                }
            }
        } else {
            this.guiProgressDlg.setValue(100 * n / this.cntPPSendBulkTotal);
        }
    }

    @Override
    public void timeout(int n) {
        if (this.guiProgressDlg != null) {
            this.guiProgressDlg.dispose();
        }
        GuiMain.getGuiStatusBarObject().showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
        if (this.sendBulkAction == DataHandler.SendBulkActionType.Change) {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_CHANGING_PPS_CANCELED_BY_TIMEOUT_AFTER_*_OF_*_REQUESTS"), n, this.cntPPSendBulkTotal));
        } else {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_DELETING_PPS_CANCELED_BY_TIMEOUT_AFTER_*_OF_*_REQUESTS"), n, this.cntPPSendBulkTotal));
        }
    }

    @Override
    public void canceled() {
        this.ppDataHandler.cancelChangeDeletePPs();
    }

    private class ppUserByNumberNotificationClass
    implements PpUserByNumberHandler.PpUserByNumberNotificationInterface {
        private ppUserByNumberNotificationClass() {
        }

        @Override
        public void processPpUserByNumberNotification(PpUserDataRecord ppUserDataRecord) {
            System.out.printf("processPpUserByNumberNotification: number='%s' uid=0x%03x name='%s'\n\n", ppUserDataRecord.getField(PpUserDataRecord.IDX_NUM), ppUserDataRecord.getField(PpUserDataRecord.IDX_UID), ppUserDataRecord.getField(PpUserDataRecord.IDX_NAME));
        }

        @Override
        public void processPpUserByNumberErrorNotification(String string, OmiMessage omiMessage) {
            System.out.printf("processPpUserByNumberErrorNotification: seq=%02d number='%s' error='%s'\n\n", omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name()), string, omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name()));
            System.out.println();
        }
    }

    class NotificationHandlerClass
    implements PpDataNotificationInterface {
        public NotificationTypeEnum notificationType = NotificationTypeEnum.USER_NOTIFICATION;

        NotificationHandlerClass() {
        }

        @Override
        public void processDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
            if (PpConfigMainPanel.this.table.getSelectedRow() == -1) {
                PpConfigMainPanel.this.ppTaskPanel.setTaskButtonConfigure(false);
                PpConfigMainPanel.this.ppTaskPanel.setTaskButtonChangeRelationType(false);
                PpConfigMainPanel.this.ppTaskPanel.setTaskButtonDelete(false);
            }
            if (this.notificationType == NotificationTypeEnum.USER_NOTIFICATION) {
                PpConfigMainPanel.this.processUserDataNotification(n, dataNotificationEnum);
            } else {
                PpConfigMainPanel.this.processDevDataNotification(n, dataNotificationEnum);
            }
        }

        @Override
        public void processErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
            PpConfigMainPanel.this.processError(this.notificationType, n, dataNotificationEnum, omiMessage);
        }

        @Override
        public void processStatusEvent(int n, int n2, PpEventEnum ppEventEnum, Object[] objectArray) {
        }
    }

    private static enum NotificationTypeEnum {
        USER_NOTIFICATION,
        DEVICE_NOTIFICATION;

    }
}

