/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.pp;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.gui.GuiProgressDlgCancel;
import com.aastra.oamp.gui.GuiStatusBar;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilMainPanel;
import com.aastra.oamp.guiutil.GuiUtilTableColSelect;
import com.aastra.oamp.pp.PpDevConfigDetailPanel;
import com.aastra.oamp.pp.PpDevConfigTaskPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilFilterTable;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.oamp.util.UtilPrint;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.DatabaseChangeEvent;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.PpDataHandler;
import com.aastra.omilib.PpDataNotificationInterface;
import com.aastra.omilib.PpDevDataRecord;
import com.aastra.omilib.PpEventEnum;
import com.aastra.omilib.PpUserDataRecord;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.HashMap;

public class PpDevConfigMainPanel
extends GuiUtilMainPanel
implements PpDataNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface,
DataHandler.DataHandlerSendBulkInterface,
GuiProgressDlgCancel.GuiProgressDlgCancelInterface {
    private static final long serialVersionUID = 1L;
    private PpDataHandler ppDataHandler = null;
    private OmiManagement omiManagement = null;
    private GuiStatusBar guiStatusBar = null;
    private CommonDataHandler commonDataHandler = null;
    private GuiUtilDetailSplitPanel ppDevDetailSplitPane = null;
    private AastraScrollPane ppDevTablePane = null;
    private PpDevConfigDetailPanel ppDevDetailPanel = null;
    private PpDevConfigTaskPanel ppDevTaskPanel = null;
    private boolean detailPanelPending = false;
    private HashMap<Integer, Boolean> pendingPpn = new HashMap();
    private int dividerLocation = 0;
    private int cntNotificationsToReceive = 0;
    private int cntPPSendBulkTotal;
    private DataHandler.SendBulkActionType sendBulkAction = null;
    private GuiProgressDlgCancel guiProgressDlg = null;
    private UtilErrorComp utilErrorComp = null;
    private GuiUtilTableColSelect[] tableColSel = null;

    public PpDevConfigMainPanel(CommonDataHandler commonDataHandler, PpDataHandler ppDataHandler) {
        this.commonDataHandler = commonDataHandler;
        this.ppDataHandler = ppDataHandler;
        this.omiManagement = GuiMain.getOmiManagementObject();
        this.guiStatusBar = GuiMain.getGuiStatusBarObject();
        this.ppDataHandler.registerDevDataNotificationListener(this);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPpDevDetailSplitPane(), "Center");
        this.add((Component)this.getPpDevTaskPanel(), "East");
        this.ppDevTaskPanel.initPpDevConfigPanelObject(this, this.getPpDevTable());
        this.utilErrorComp = new UtilErrorComp();
    }

    protected GuiUtilTableColSelect[] getTableColumnsSelection() {
        if (this.tableColSel == null) {
            GuiUtilTableColSelect[] guiUtilTableColSelectArray = new GuiUtilTableColSelect[]{new GuiUtilTableColSelect(PpDevDataRecord.IDX_PPN, true), new GuiUtilTableColSelect(PpDevDataRecord.IDX_TIME_STAMP, false), new GuiUtilTableColSelect(PpDevDataRecord.IDX_IPEI, true), new GuiUtilTableColSelect(PpDevDataRecord.IDX_AC, true), new GuiUtilTableColSelect(PpDevDataRecord.IDX_ENCRYPT, true, GuiUtilIcon.getIconArrayErrorActive()), new GuiUtilTableColSelect(PpDevDataRecord.IDX_REL_TYPE, true), new GuiUtilTableColSelect(PpDevDataRecord.IDX_UID, true), new GuiUtilTableColSelect(PpDevDataRecord.IDX_SUBSCRIBED, true, GuiUtilIcon.getIconArrayErrorErrorActive())};
            int n = 0;
            int n2 = guiUtilTableColSelectArray.length;
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync)) {
                ++n;
            }
            this.tableColSel = Arrays.copyOf(guiUtilTableColSelectArray, n2 + n);
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDevDataRecord.IDX_SUBSCRIBE_TO_PARI_ONLY, false, GuiUtilIcon.getIconArrayInactiveActive());
            }
        }
        return this.tableColSel;
    }

    private void updateAttrib1(int n) {
        int n2 = 0;
        OmiMessage.DECTSubscriptionStateType dECTSubscriptionStateType = OmiMessage.DECTSubscriptionStateType.No;
        PpDevDataRecord ppDevDataRecord = this.ppDataHandler.getPpDevData(n);
        if (ppDevDataRecord != null) {
            OmiMessage.PPRelTypeType pPRelTypeType = (OmiMessage.PPRelTypeType)((Object)ppDevDataRecord.getField(PpDevDataRecord.IDX_REL_TYPE));
            if (pPRelTypeType != OmiMessage.PPRelTypeType.Unbound) {
                n2 = (Integer)ppDevDataRecord.getField(PpDevDataRecord.IDX_UID);
                dECTSubscriptionStateType = (OmiMessage.DECTSubscriptionStateType)((Object)ppDevDataRecord.getField(PpDevDataRecord.IDX_SUBSCRIBED));
            }
            if (pPRelTypeType != OmiMessage.PPRelTypeType.Unbound && dECTSubscriptionStateType == OmiMessage.DECTSubscriptionStateType.Yes) {
                this.ppDataHandler.setPpUserInternalAttrib(n2, PpUserDataRecord.IDX_GUI_ATTRIB1, (Object)PpUserDataRecord.PpUserActiveTypeEnum.PP_USER_ACTIVE);
            } else {
                this.ppDataHandler.setPpUserInternalAttrib(n2, PpUserDataRecord.IDX_GUI_ATTRIB1, (Object)PpUserDataRecord.PpUserActiveTypeEnum.PP_USER_INACTIVE);
            }
        }
    }

    private void processTableEvent() {
        boolean bl = false;
        boolean bl2 = false;
        int n = this.table.getSelectedRowCount();
        if (n > 0) {
            bl = true;
            bl2 = true;
        }
        if (this.ppDevDetailSplitPane.getBottomComponent() != null) {
            if (n > 0) {
                DataRecord[] dataRecordArray = new DataRecord[n];
                int[] nArray = this.table.getSelectedRows();
                for (int i = 0; i < n; ++i) {
                    int n2 = this.table.convertRowIndexToModel(nArray[i]);
                    dataRecordArray[i] = this.ppDataHandler.getDevDatabase().getRecordByIdx(n2);
                }
                this.createPpDevDetailPanel(dataRecordArray);
            } else {
                this.removePpDevDetailPanel();
            }
            bl = false;
        }
        this.ppDevTaskPanel.setTaskButtonConfigure(bl);
        this.ppDevTaskPanel.setTaskButtonDelete(bl2);
        this.updateTableInfo();
    }

    public void configurePpDev() {
        int n = this.table.getSelectedRowCount();
        DataRecord[] dataRecordArray = new DataRecord[n];
        int[] nArray = this.table.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2 = this.table.convertRowIndexToModel(nArray[i]);
            dataRecordArray[i] = this.ppDataHandler.getDevDatabase().getRecordByIdx(n2);
        }
        if (n > 0) {
            this.createPpDevDetailPanel(dataRecordArray);
        }
    }

    private GuiUtilDetailSplitPanel getPpDevDetailSplitPane() {
        if (this.ppDevDetailSplitPane == null) {
            this.ppDevDetailSplitPane = new GuiUtilDetailSplitPanel(390);
            this.ppDevDetailSplitPane.setTopComponent(this.getPpDevTablePane());
            this.ppDevDetailSplitPane.setBottomComponent(null);
        }
        return this.ppDevDetailSplitPane;
    }

    private GuiUtilConfiguratorTable getPpDevTable() {
        if (this.table == null) {
            this.table = new GuiUtilConfiguratorTable((Object)this, (Database)this.ppDataHandler.getDevDatabase(), this.getTableColumnsSelection(), this.getActiveTableColumns(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectPpDevConfig, this.getTableColumnsSelection(), true), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthPpDevConfig);
            this.table.setType(DatabaseChangeEvent.DatabaseChangeType.PP_DEV);
            this.table.setColumnFormatString(PpDevDataRecord.IDX_PPN, "0x%03X");
            this.table.setColumnFormatString(PpDevDataRecord.IDX_UID, "0x%03X");
            this.table.setNegativeIntAsInvalid(PpDevDataRecord.IDX_UID);
            this.table.setPreferredColumnWidth(PpDevDataRecord.IDX_PPN, 20);
            this.table.setPreferredColumnWidth(PpDevDataRecord.IDX_AC, 35);
            this.table.setPreferredColumnWidth(PpDevDataRecord.IDX_ENCRYPT, 20);
            this.table.setPreferredColumnWidth(PpDevDataRecord.IDX_REL_TYPE, 35);
            this.table.setPreferredColumnWidth(PpDevDataRecord.IDX_UID, 30);
            this.table.setPreferredColumnWidth(PpDevDataRecord.IDX_SUBSCRIBED, 20);
            this.table.applyPreferredColumnWidthSettings();
        }
        return this.table;
    }

    private void enableTableAccess() {
        this.table.setActive(true);
        this.ppDevTaskPanel.setTaskButtonConfigureTable(true);
        this.ppDevTaskPanel.setTaskButtonFilter(true);
    }

    private void disableTableAccess() {
        this.table.setActive(false);
        this.ppDevTaskPanel.setTaskButtonConfigure(false);
        this.ppDevTaskPanel.setTaskButtonDelete(false);
        this.ppDevTaskPanel.setTaskButtonConfigureTable(false);
        this.ppDevTaskPanel.setTaskButtonFilter(false);
    }

    protected void configureTableFilter() {
        boolean bl = UtilFilterTable.setFilterItems(this.table, UtilPreferences.getTableFilterValues(UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesPpDevConfig));
        this.ppDevTaskPanel.setTaskButtonFilterState(bl, null);
    }

    private AastraScrollPane getPpDevTablePane() {
        if (this.ppDevTablePane == null) {
            this.ppDevTablePane = new AastraScrollPane(this.getPpDevTable());
            this.dividerLocation = this.ppDevDetailSplitPane.getHeight() - 390;
            this.ppDevTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.ppDevTablePane;
    }

    private AastraPanel getPpDevDetailPanel() {
        if (this.ppDevDetailPanel == null) {
            this.ppDevDetailPanel = new PpDevConfigDetailPanel(this, this.utilErrorComp);
        }
        return this.ppDevDetailPanel;
    }

    private AastraPanel getPpDevTaskPanel() {
        if (this.ppDevTaskPanel == null) {
            this.ppDevTaskPanel = new PpDevConfigTaskPanel(this, this.table, this.commonDataHandler);
        }
        return this.ppDevTaskPanel;
    }

    public void createPpDevDetailPanel(DataRecord[] dataRecordArray) {
        if (this.ppDevDetailSplitPane.getBottomComponent() != null) {
            this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
            this.utilErrorComp.clearComponents();
            this.dividerLocation = this.ppDevDetailSplitPane.getDividerLocation();
            if (dataRecordArray == null) {
                this.ppDevDetailPanel.setDefaultTab();
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating PP device config detail panel");
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating PP device config detail panel");
            this.ppDevDetailSplitPane.setBottomComponent(this.getPpDevDetailPanel());
            this.ppDevDetailPanel.setDefaultTab();
        }
        if (dataRecordArray != null) {
            for (int i = 0; i < dataRecordArray.length; ++i) {
                Integer n = (Integer)dataRecordArray[i].getField(PpDevDataRecord.IDX_PPN);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading PP device[" + n + "]:");
                UtilPrint.printPpDevDataRecordString((PpDevDataRecord)dataRecordArray[i], this);
            }
            this.ppDevDetailPanel.setPpDevDetailData(dataRecordArray);
        } else {
            this.ppDevDetailPanel.setPpDevDetailData(null);
        }
        this.ppDevDetailPanel.requestDefaultFocusInWindow();
        this.ppDevDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.ppDevDetailSplitPane.validate();
        this.ppDevTaskPanel.setTaskButtonConfigure(false);
    }

    public void removePpDevDetailPanel() {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing PP device config detail panel");
        this.clearDetailPanelPending();
        this.utilErrorComp.clearComponents();
        this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
        this.dividerLocation = this.ppDevDetailSplitPane.getDividerLocation();
        this.ppDevDetailSplitPane.setBottomComponent(null);
        if (this.table.getSelectedRow() >= 0) {
            this.ppDevTaskPanel.setTaskButtonConfigure(true);
            this.ppDevTaskPanel.setTaskButtonDelete(true);
        } else {
            this.ppDevTaskPanel.setTaskButtonDelete(false);
        }
    }

    public void setDetailPanelPending() {
        this.detailPanelPending = true;
    }

    private void clearDetailPanelPending() {
        this.detailPanelPending = false;
        this.pendingPpn.clear();
    }

    public void changePpDev() {
        int n;
        DataRecord[] dataRecordArray = null;
        PpDevDataRecord[] ppDevDataRecordArray = (PpDevDataRecord[])this.ppDevDetailPanel.getPpDevDetailData();
        if (ppDevDataRecordArray == null) {
            return;
        }
        this.cntPPSendBulkTotal = 0;
        for (n = 0; n < ppDevDataRecordArray.length; ++n) {
            if (!ppDevDataRecordArray[n].getRecordChanged()) continue;
            this.ppDataHandler.getDevDatabase().updateTransientFields(ppDevDataRecordArray[n]);
            ++this.cntPPSendBulkTotal;
            ++this.cntNotificationsToReceive;
            this.pendingPpn.put((Integer)ppDevDataRecordArray[n].getField(PpDevDataRecord.IDX_PPN), false);
        }
        if (this.cntPPSendBulkTotal > 0) {
            n = 0;
            dataRecordArray = new DataRecord[this.cntPPSendBulkTotal];
            for (int i = 0; i < ppDevDataRecordArray.length; ++i) {
                if (!ppDevDataRecordArray[i].getRecordChanged()) continue;
                dataRecordArray[n++] = ppDevDataRecordArray[i];
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, String.format("Changing %d PP device(s)\n", this.cntPPSendBulkTotal));
            this.sendBulkAction = DataHandler.SendBulkActionType.Change;
            this.ppDataHandler.sendChangeDeletePPs(this.sendBulkAction, dataRecordArray, this);
            this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_BUSY, null);
            this.setDetailPanelPending();
            if (this.cntPPSendBulkTotal > 1) {
                this.guiProgressDlg = new GuiProgressDlgCancel(UtilLocale.getString("TXT_CHANGING_PP_DEVICES_IN_PROGRESS"), false, true, this);
                this.guiProgressDlg.setValue(0);
                this.guiProgressDlg.setVisible(true);
            }
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Change PP devices(s): OMILIB told us there is nothing to do (all PP device attributes are unchanged)");
            this.removePpDevDetailPanel();
        }
    }

    public void deletePpDev() {
        GuiUtilDialog guiUtilDialog;
        DataRecord[] dataRecordArray = null;
        int n = this.table.getSelectedRowCount();
        if (n > 0 && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_DELETE_SELECTED_PP_DEVICES_?"), true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            int[] nArray = this.table.getSelectedRows();
            int n2 = 0;
            this.cntNotificationsToReceive = nArray.length;
            this.cntPPSendBulkTotal = nArray.length;
            dataRecordArray = new DataRecord[this.cntPPSendBulkTotal];
            for (int i = 0; i < this.cntPPSendBulkTotal; ++i) {
                int n3 = this.table.convertRowIndexToModel(nArray[i]);
                PpDevDataRecord ppDevDataRecord = this.ppDataHandler.getPpDevDataByIdx(n3);
                int n4 = (Integer)ppDevDataRecord.getField(PpDevDataRecord.IDX_PPN);
                dataRecordArray[n2++] = ppDevDataRecord;
                if (this.ppDevDetailSplitPane.getBottomComponent() == null || this.ppDevDetailPanel.getSelectedPpDev() != n4) continue;
                this.pendingPpn.put(n4, false);
            }
            this.sendBulkAction = DataHandler.SendBulkActionType.Delete;
            this.ppDataHandler.sendChangeDeletePPs(this.sendBulkAction, dataRecordArray, this);
            if (this.cntPPSendBulkTotal > 1) {
                this.guiProgressDlg = new GuiProgressDlgCancel(UtilLocale.getString("TXT_DELETING_PP_DEVICES_IN_PROGRESS"), false, true, this);
                this.guiProgressDlg.setValue(0);
                this.guiProgressDlg.setVisible(true);
            }
        }
    }

    @Override
    public void processDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP device notification: " + dataNotificationEnum.toString() + ",ppn=" + n);
        if (this.table.getSelectedRow() == -1) {
            this.ppDevTaskPanel.setTaskButtonConfigure(false);
            this.ppDevTaskPanel.setTaskButtonDelete(false);
        }
        switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                break;
            }
            case NEW_DATA: {
                if (this.detailPanelPending) {
                    this.removePpDevDetailPanel();
                }
                this.updateAttrib1(n);
                break;
            }
            case DATA_CHANGED: {
                if (this.detailPanelPending) {
                    if (this.pendingPpn.containsKey(n) && this.cntNotificationsToReceive > 0) {
                        --this.cntNotificationsToReceive;
                    }
                    this.pendingPpn.remove(n);
                    if (this.pendingPpn.isEmpty()) {
                        this.removePpDevDetailPanel();
                        this.cntNotificationsToReceive = 0;
                    }
                }
                this.updateAttrib1(n);
                break;
            }
            case DATA_DELETED: {
                if (!this.detailPanelPending) break;
                if (this.pendingPpn.containsKey(n) && this.cntNotificationsToReceive > 0) {
                    --this.cntNotificationsToReceive;
                }
                this.pendingPpn.remove(n);
                if (!this.pendingPpn.isEmpty()) break;
                this.removePpDevDetailPanel();
                this.cntNotificationsToReceive = 0;
                break;
            }
        }
    }

    @Override
    public void processErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        String string4 = null;
        OmiMessage.errorCodes errorCodes2 = null;
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP device error notification: " + dataNotificationEnum.toString() + ",ppn=" + String.valueOf(n) + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP device error notification: Unknown errorCode=" + string);
        }
        if (this.detailPanelPending) {
            if (string2 != null) {
                this.ppDevDetailPanel.markErrorComponent(string2);
            }
            String string5 = this.ppDevDetailPanel.getErrorLabelText(string2);
            if (errorCodes2 != null) {
                string4 = UtilErrorHandling.getErrorMessage(errorCodes2, string5, string3);
            }
            if (this.pendingPpn.containsKey(n) && this.cntNotificationsToReceive > 0) {
                --this.cntNotificationsToReceive;
            }
            if (dataNotificationEnum == DataNotificationEnum.DATA_CHANGED) {
                if (!this.pendingPpn.containsKey(n)) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "ppn=" + String.valueOf(n) + " does not exist in send map anymore");
                    return;
                }
                this.pendingPpn.put(n, true);
                int n2 = 0;
                for (Integer object2 : this.pendingPpn.keySet()) {
                    if (!this.pendingPpn.get(object2).booleanValue()) continue;
                    ++n2;
                }
                PpDevDataRecord[] ppDevDataRecordArray = new PpDevDataRecord[n2];
                n2 = 0;
                for (Integer n3 : this.pendingPpn.keySet()) {
                    if (!this.pendingPpn.get(n3).booleanValue()) continue;
                    ppDevDataRecordArray[n2] = this.ppDataHandler.getPpDevData(n3);
                    ++n2;
                }
                this.ppDevDetailPanel.setPpDevDetailData(ppDevDataRecordArray);
            }
        } else if (errorCodes2 != null) {
            string4 = UtilErrorHandling.getErrorMessage(errorCodes2, string2, string3);
        }
        if (this.componentActivated) {
            if (string4 != null) {
                GuiInfoConsole.showError(string4);
            } else {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
            }
            if (this.cntNotificationsToReceive == 0) {
                this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
            }
        }
    }

    @Override
    public void processStatusEvent(int n, int n2, PpEventEnum ppEventEnum, Object[] objectArray) {
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent();
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        int n = this.table.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        DataRecord[] dataRecordArray = new DataRecord[n];
        int[] nArray = this.table.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2 = this.table.convertRowIndexToModel(nArray[i]);
            dataRecordArray[i] = this.ppDataHandler.getDevDatabase().getRecordByIdx(n2);
        }
        this.createPpDevDetailPanel(dataRecordArray);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent();
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        int[] nArray;
        if (this.ppDevDetailSplitPane.getBottomComponent() != null && (nArray = this.table.getSelectedRows()).length > 0) {
            DataRecord[] dataRecordArray2 = new DataRecord[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n = this.table.convertRowIndexToModel(nArray[i]);
                dataRecordArray2[i] = this.ppDataHandler.getDevDatabase().getRecordByIdx(n);
            }
            this.createPpDevDetailPanel(dataRecordArray2);
        }
    }

    @Override
    protected void componentActivateAction() {
        this.configureTableFilter();
    }

    @Override
    public void notifyProgress(int n, boolean bl) {
        if (bl || n == this.cntPPSendBulkTotal) {
            if (this.guiProgressDlg != null) {
                this.guiProgressDlg.dispose();
            }
            GuiMain.getGuiStatusBarObject().showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
            if (bl) {
                if (this.sendBulkAction == DataHandler.SendBulkActionType.Change) {
                    GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_CHANGING_CANCELED_AFTER_*_OF_*_PP_DEVICES"), n, this.cntPPSendBulkTotal));
                } else {
                    GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_DELETING_CANCELED_AFTER_*_OF_*_PP_DEVICES"), n, this.cntPPSendBulkTotal));
                }
            }
        } else {
            this.guiProgressDlg.setValue(100 * n / this.cntPPSendBulkTotal);
        }
    }

    @Override
    public void timeout(int n) {
        if (this.guiProgressDlg != null) {
            this.guiProgressDlg.dispose();
        }
        GuiMain.getGuiStatusBarObject().showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
        if (this.sendBulkAction == DataHandler.SendBulkActionType.Change) {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_CHANGING_CANCELED_BY_TIMEOUT_AFTER_*_OF_*_PP_DEVICES"), n, this.cntPPSendBulkTotal));
        } else {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_DELETING_CANCELED_BY_TIMEOUT_AFTER_*_OF_*_PP_DEVICES"), n, this.cntPPSendBulkTotal));
        }
    }

    @Override
    public void canceled() {
        this.ppDataHandler.cancelChangeDeletePPs();
    }
}

