/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.pp;

import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.pp.PpDetailPanel;
import com.aastra.oamp.pp.PpDevMonitorMainPanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.PpDevDataRecord;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraTextField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class PpDevMonitorDetailPanel
extends PpDetailPanel {
    private static final long serialVersionUID = 1L;
    private PpDevMonitorMainPanel ppDevMainPanel = null;
    private AastraPanel tabStatus = null;
    private AastraPanel tabFirmwareDownload = null;
    private AastraLabel labelHWType = null;
    private AastraTextField textFieldHWType = null;
    private AastraLabel labelSWVersion = null;
    private AastraTextField textFieldSWVersion = null;
    private AastraLabel labelCurrentVersion = null;
    private AastraTextField textFieldCurrentVersion = null;
    private AastraLabel labelBytesToLoad = null;
    private AastraTextField textFieldBytesToLoad = null;
    private AastraLabel labelState = null;
    private AastraLabel labelStateValue = null;
    private OmiMessage.PermissionType[] permissionArray = null;

    public PpDevMonitorDetailPanel(PpDevMonitorMainPanel ppDevMonitorMainPanel, OmiMessage.PermissionType[] permissionTypeArray) {
        this.ppDevMainPanel = ppDevMonitorMainPanel;
        this.permissionArray = permissionTypeArray;
        this.initialize();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.headerBar.add(this.labelDevice);
        this.panelTabbed.addTab(UtilLocale.getString("TXT_STATUS"), this.getTabStatus());
        UtilSetPanelEditable.setDisabled(this.tabStatus);
        if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring) && this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.havePPFirmwareUpdate)) {
            this.panelTabbed.addTab(UtilLocale.getString("TXT_FIRMWARE_DOWNLOAD"), this.getTabFirmwareDownload());
            UtilSetPanelEditable.setDisabled(this.tabFirmwareDownload);
        }
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
            this.panelTabbed.addTab(UtilLocale.getString("TXT_CONFIGURATION_DATA"), this.getTabConfigurationData(false, true));
            UtilSetPanelEditable.setDisabled(this.tabConfigurationData);
        }
        this.panelButtonBar.add(this.getButtonCancel());
    }

    private AastraPanel getTabStatus() {
        int n = 15;
        this.labelHWType = new AastraLabel();
        this.labelHWType.setBounds(30, n, 140, 16);
        this.labelHWType.setText(UtilLocale.getString("TXT_HARDWARE_TYPE"));
        if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
            this.labelSWVersion = new AastraLabel();
            this.labelSWVersion.setText(UtilLocale.getString("TXT_SOFTWARE_VERSION"));
            this.labelSWVersion.setBounds(30, n += 30, 140, 16);
        }
        n = 15;
        this.tabStatus = new AastraPanel();
        this.tabStatus.setLayout(null);
        this.tabStatus.add((Component)this.labelHWType, null);
        this.tabStatus.add((Component)this.getTextFieldHWType(n), null);
        if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
            this.tabStatus.add((Component)this.labelSWVersion, null);
            this.tabStatus.add((Component)this.getTextFieldSWVersion(n += 30), null);
        }
        return this.tabStatus;
    }

    private AastraTextField getTextFieldHWType(int n) {
        if (this.textFieldHWType == null) {
            this.textFieldHWType = new AastraTextField();
            this.textFieldHWType.setBounds(180, n, 75, 18);
        }
        return this.textFieldHWType;
    }

    private AastraTextField getTextFieldSWVersion(int n) {
        if (this.textFieldSWVersion == null) {
            this.textFieldSWVersion = new AastraTextField();
            this.textFieldSWVersion.setBounds(180, n, 75, 18);
        }
        return this.textFieldSWVersion;
    }

    private AastraPanel getTabFirmwareDownload() {
        if (this.tabFirmwareDownload == null) {
            this.labelState = new AastraLabel();
            this.labelState.setBounds(30, 15, 140, 16);
            this.labelState.setText(UtilLocale.getString("TXT_STATE"));
            this.labelStateValue = new AastraLabel();
            this.labelStateValue.setBounds(180, 15, 250, 16);
            this.labelStateValue.setIconTextGap(13);
            this.labelCurrentVersion = new AastraLabel();
            this.labelCurrentVersion.setText(UtilLocale.getString("TXT_CURRENT_VERSION"));
            this.labelCurrentVersion.setBounds(30, 45, 140, 16);
            this.labelBytesToLoad = new AastraLabel();
            this.labelBytesToLoad.setBounds(30, 75, 140, 16);
            this.labelBytesToLoad.setText(UtilLocale.getString("TXT_BYTES_TO_LOAD"));
            this.tabFirmwareDownload = new AastraPanel();
            this.tabFirmwareDownload.setLayout(null);
            this.tabFirmwareDownload.add((Component)this.labelCurrentVersion, null);
            this.tabFirmwareDownload.add((Component)this.getTextFieldCurrentVersion(), null);
            this.tabFirmwareDownload.add((Component)this.labelState, null);
            this.tabFirmwareDownload.add((Component)this.labelStateValue, null);
            this.tabFirmwareDownload.add((Component)this.labelBytesToLoad, null);
            this.tabFirmwareDownload.add((Component)this.getTextFieldBytesToLoad(), null);
        }
        return this.tabFirmwareDownload;
    }

    private AastraTextField getTextFieldCurrentVersion() {
        if (this.textFieldCurrentVersion == null) {
            this.textFieldCurrentVersion = new AastraTextField();
            this.textFieldCurrentVersion.setBounds(180, 45, 75, 18);
        }
        return this.textFieldCurrentVersion;
    }

    private AastraTextField getTextFieldBytesToLoad() {
        if (this.textFieldBytesToLoad == null) {
            this.textFieldBytesToLoad = new AastraTextField();
            this.textFieldBytesToLoad.setBounds(180, 75, 75, 18);
        }
        return this.textFieldBytesToLoad;
    }

    public void setPpDevDetailData(PpDevDataRecord ppDevDataRecord) {
        if (ppDevDataRecord != null) {
            String string;
            this.labelDevice.setText(String.format("%s #0x%03X", UtilLocale.getString("TXT_PP_DEVICE"), (Integer)ppDevDataRecord.getField(PpDevDataRecord.IDX_PPN)));
            this.textFieldHWType.setText(ppDevDataRecord.getField(PpDevDataRecord.IDX_HW_TYPE).toString());
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
                string = (String)ppDevDataRecord.getField(PpDevDataRecord.IDX_ST_SW_VERSION);
                if (string != null && string.length() > 0) {
                    this.textFieldSWVersion.setText(string);
                } else {
                    this.textFieldSWVersion.setText("-");
                }
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
                if (((Boolean)ppDevDataRecord.getField(PpDevDataRecord.IDX_DEF_PROFILE_LOADED)).booleanValue()) {
                    this.labelDefaultProfileLoadedStatus.setIcon(GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                } else {
                    this.labelDefaultProfileLoadedStatus.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                }
            }
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring) && this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.havePPFirmwareUpdate)) {
                string = (String)ppDevDataRecord.getField(PpDevDataRecord.IDX_FW_VERSION);
                if (string != null && string.length() > 0) {
                    this.textFieldCurrentVersion.setText(string);
                } else {
                    this.textFieldCurrentVersion.setText("-");
                }
                OmiMessage.PPFirmwareUpdateStatusStateType pPFirmwareUpdateStatusStateType = (OmiMessage.PPFirmwareUpdateStatusStateType)((Object)ppDevDataRecord.getField(PpDevDataRecord.IDX_FW_UPDATE_STATE));
                switch (pPFirmwareUpdateStatusStateType) {
                    case ready: {
                        this.labelStateValue.setText(UtilLocale.getString("TXT_ALREADY_UPDATED"));
                        this.labelStateValue.setToolTipText(null);
                        this.labelStateValue.setIcon(GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        break;
                    }
                    case pending: {
                        this.labelStateValue.setText(UtilLocale.getString("TXT_WAITING_FOR_DOWNLOAD"));
                        this.labelStateValue.setToolTipText(null);
                        this.labelStateValue.setIcon(GuiUtilIcon.getIconWait(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        break;
                    }
                    case active: {
                        this.labelStateValue.setText(UtilLocale.getString("TXT_DOWNLOADING"));
                        this.labelStateValue.setToolTipText(null);
                        this.labelStateValue.setIcon(GuiUtilIcon.getIconDownload(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        break;
                    }
                    case barred: {
                        this.labelStateValue.setText(UtilLocale.getString("TXT_BARRED"));
                        this.labelStateValue.setToolTipText(null);
                        this.labelStateValue.setIcon(GuiUtilIcon.getIconBlocked(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        break;
                    }
                    case error: {
                        this.labelStateValue.setText(null);
                        this.labelStateValue.setToolTipText(UtilLocale.getString("TXT_ERROR"));
                        this.labelStateValue.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        break;
                    }
                    case notReachable: {
                        this.labelStateValue.setText(UtilLocale.getString("TXT_UNREACHABLE"));
                        this.labelStateValue.setToolTipText(null);
                        this.labelStateValue.setIcon(GuiUtilIcon.getIconSearch(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        break;
                    }
                    case detached: {
                        this.labelStateValue.setText(UtilLocale.getString("TXT_DETACHED"));
                        this.labelStateValue.setToolTipText(null);
                        this.labelStateValue.setIcon(GuiUtilIcon.getIconDisconnected(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        break;
                    }
                    default: {
                        this.labelStateValue.setText(UtilLocale.getString("TXT_NONE"));
                        this.labelStateValue.setToolTipText(null);
                        this.labelStateValue.setIcon(null);
                    }
                }
                OmiMessage.PPFirmwareUpdateStatusCauseType pPFirmwareUpdateStatusCauseType = (OmiMessage.PPFirmwareUpdateStatusCauseType)((Object)ppDevDataRecord.getField(PpDevDataRecord.IDX_FW_UPDATE_CAUSE));
                if (pPFirmwareUpdateStatusCauseType != null) {
                    switch (pPFirmwareUpdateStatusCauseType) {
                        case busy: {
                            this.labelStateValue.setToolTipText(UtilLocale.getString("TXT_DEVICE_IS_BUSY"));
                            break;
                        }
                        case battery: {
                            this.labelStateValue.setToolTipText(UtilLocale.getString("TXT_BATTERY_IS_TOO_LOW"));
                            break;
                        }
                        case barred: {
                            this.labelStateValue.setToolTipText(UtilLocale.getString("TXT_DOWNLOAD_DEACTIVATED_IN_DEVICE"));
                            break;
                        }
                        case noMaster: {
                            this.labelStateValue.setToolTipText(UtilLocale.getString("TXT_OTHER_MASTER_DOWNLOAD_SYSTEM"));
                            break;
                        }
                        case crc: {
                            this.labelStateValue.setToolTipText(UtilLocale.getString("TXT_CHECKSUM_ERROR"));
                            break;
                        }
                        case noMem: {
                            this.labelStateValue.setToolTipText(UtilLocale.getString("TXT_FILE_SYSTEM_FULL"));
                            break;
                        }
                        case flash: {
                            this.labelStateValue.setToolTipText(UtilLocale.getString("TXT_ERROR_WHEN_WRITING_FIRMWARE_TO_FLASH"));
                            break;
                        }
                        case system: {
                            this.labelStateValue.setToolTipText(UtilLocale.getString("TXT_FILE_SYSTEM_ERROR"));
                            break;
                        }
                        case version: {
                            this.labelStateValue.setToolTipText(UtilLocale.getString("TXT_DOWNLOADED_CONTAINER_HAS_NOT_DEVICE_DESCRIPTION_FILE_VERSION"));
                            break;
                        }
                        case file: {
                            this.labelStateValue.setToolTipText(UtilLocale.getString("TXT_INVALID_FILE_RECEIVED"));
                            break;
                        }
                        case container: {
                            this.labelStateValue.setToolTipText(UtilLocale.getString("TXT_ERROR_WHEN_EXPANDING_CONTAINER"));
                            break;
                        }
                    }
                }
                if (pPFirmwareUpdateStatusStateType == OmiMessage.PPFirmwareUpdateStatusStateType.active) {
                    this.textFieldBytesToLoad.setText(((Integer)ppDevDataRecord.getField(PpDevDataRecord.IDX_FW_UPDATE_BYTES)).toString());
                } else {
                    this.textFieldBytesToLoad.setText("-");
                }
            }
        } else {
            this.labelDevice.setText(UtilLocale.getString("TXT_RECORD_INVALID"));
            this.textFieldHWType.setText("-");
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
                this.textFieldSWVersion.setText("-");
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
                this.labelDefaultProfileLoadedStatus.setIcon(null);
            }
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring) && this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.havePPFirmwareUpdate)) {
                this.textFieldCurrentVersion.setText("-");
                this.textFieldBytesToLoad.setText("-");
                this.labelStateValue.setIcon(null);
                this.labelStateValue.setText(UtilLocale.getString("TXT_NONE"));
                this.labelStateValue.setToolTipText(null);
            }
        }
        if (this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(this.getButtonCancel());
            this.getButtonCancel().requestFocusInWindow();
        }
    }

    @Override
    protected AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            super.getButtonCancel();
            this.buttonCancel.setBounds(230, 15, 90, 25);
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PpDevMonitorDetailPanel.this.ppDevMainPanel.removePpDevDetailPanel();
                }
            });
        }
        return this.buttonCancel;
    }
}

