/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.pp;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilTableConfigDlgDefault;
import com.aastra.oamp.guiutil.GuiUtilTableFilterDlg;
import com.aastra.oamp.guiutil.GuiUtilTaskPanel;
import com.aastra.oamp.pp.PpActivityLogFile;
import com.aastra.oamp.pp.PpDevMonitorMainPanel;
import com.aastra.oamp.util.UtilFileHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.style.AastraLinkButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class PpDevMonitorTaskPanel
extends GuiUtilTaskPanel {
    private static final long serialVersionUID = 1L;
    private ConfiguratorTable ppDevTable = null;
    private PpDevMonitorMainPanel ppDevMainPanel = null;
    private AastraLinkButton buttonShowDetails = null;
    private AastraLinkButton buttonActivatePpEventLog = null;
    private AastraLinkButton buttonFilterPpDevTable = null;
    private AastraLinkButton buttonConfigurePpDevTable = null;
    private GuiUtilTableFilterDlg ppTableFilterDlg = null;

    public PpDevMonitorTaskPanel(PpDevMonitorMainPanel ppDevMonitorMainPanel, ConfiguratorTable configuratorTable) {
        this.ppDevMainPanel = ppDevMonitorMainPanel;
        this.ppDevTable = configuratorTable;
        this.initialize();
    }

    private void initialize() {
        this.add((Component)this.getButtonShowDetails(), null);
        this.add((Component)this.getButtonFilterPpTable(), null);
        this.add((Component)this.getButtonActivatePpEventLog(), null);
        this.add((Component)this.getButtonConfigurePpDevTable(), null);
    }

    private AastraLinkButton getButtonShowDetails() {
        if (this.buttonShowDetails == null) {
            this.buttonShowDetails = this.createTaskButtonDisabled(UtilLocale.getString("TXT_SHOW_DETAILS_20"));
            this.buttonShowDetails.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PpDevMonitorTaskPanel.this.ppDevMainPanel.showPpDevDetails();
                }
            });
        }
        return this.buttonShowDetails;
    }

    private AastraLinkButton getButtonFilterPpTable() {
        if (this.buttonFilterPpDevTable == null) {
            this.buttonFilterPpDevTable = this.createTaskButtonDisabled(UtilLocale.getString("TXT_FILTER_20"), GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            this.buttonFilterPpDevTable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PpDevMonitorTaskPanel.this.getPpTableFilterDlg().setVisible(true);
                    PpDevMonitorTaskPanel.this.ppDevMainPanel.configureTableFilter();
                }
            });
        }
        return this.buttonFilterPpDevTable;
    }

    private GuiUtilTableFilterDlg getPpTableFilterDlg() {
        if (this.ppTableFilterDlg == null) {
            this.ppTableFilterDlg = new GuiUtilTableFilterDlg(this.ppDevTable, UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesPpDevMonitor);
        }
        return this.ppTableFilterDlg;
    }

    private AastraLinkButton getButtonActivatePpEventLog() {
        if (this.buttonActivatePpEventLog == null) {
            this.buttonActivatePpEventLog = this.createTaskButtonDisabled(UtilLocale.getString("TXT_LOG_EVENTS_20"), UtilLocale.getString("TXT_LOGGING_PP_DEVICE_ACTIVITY_EVENTS"), PpActivityLogFile.IsLogActive() ? GuiUtilIcon.getIconActive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall) : GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            this.buttonActivatePpEventLog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (PpActivityLogFile.IsLogActive()) {
                        PpDevMonitorTaskPanel.this.buttonActivatePpEventLog.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                        PpActivityLogFile.SetLog(false);
                    } else {
                        PpDevMonitorTaskPanel.this.buttonActivatePpEventLog.setIcon(GuiUtilIcon.getIconActive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                        PpActivityLogFile.SetLog(true);
                        GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_EVENTS_WILL_BE_WRITTEN_TO_*"), UtilFileHandling.getWorkingDirectory() + File.separator + "pp_event.log"));
                    }
                }
            });
        }
        return this.buttonActivatePpEventLog;
    }

    private AastraLinkButton getButtonConfigurePpDevTable() {
        if (this.buttonConfigurePpDevTable == null) {
            this.buttonConfigurePpDevTable = this.createTaskButtonDisabled(UtilLocale.getString("TXT_SELECT_COLUMNS_20"));
            this.buttonConfigurePpDevTable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiUtilTableConfigDlgDefault guiUtilTableConfigDlgDefault = new GuiUtilTableConfigDlgDefault(PpDevMonitorTaskPanel.this.ppDevTable, PpDevMonitorTaskPanel.this.ppDevMainPanel.getTableColumnsSelection(), UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectPpDevMonitor);
                    guiUtilTableConfigDlgDefault.setVisible(true);
                }
            });
        }
        return this.buttonConfigurePpDevTable;
    }

    public void setTaskButtonShowDetails(boolean bl) {
        this.buttonShowDetails.setEnabled(bl);
    }

    public void setTaskButtonActivateEventLog(Boolean bl, Boolean bl2) {
        if (bl != null) {
            this.buttonActivatePpEventLog.setEnabled(bl);
        }
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                this.buttonActivatePpEventLog.setIcon(GuiUtilIcon.getIconActive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            } else {
                this.buttonActivatePpEventLog.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            }
        }
    }

    public void setTaskButtonFilter(boolean bl) {
        this.buttonFilterPpDevTable.setEnabled(bl);
    }

    public void setTaskButtonFilterState(Boolean bl, String string) {
        if (bl != null) {
            if (bl.booleanValue()) {
                this.buttonFilterPpDevTable.setIcon(GuiUtilIcon.getIconActive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            } else {
                this.buttonFilterPpDevTable.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            }
        }
        this.buttonFilterPpDevTable.setToolTipText(string);
    }

    public void setTaskButtonConfigureTable(boolean bl) {
        this.buttonConfigurePpDevTable.setEnabled(bl);
    }
}

