/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.pp;

import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilMainPanel;
import com.aastra.oamp.guiutil.GuiUtilTableColSelect;
import com.aastra.oamp.pp.PpActivityLogFile;
import com.aastra.oamp.pp.PpMonitorDetailPanel;
import com.aastra.oamp.pp.PpMonitorTaskPanel;
import com.aastra.oamp.util.UtilFilterTable;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.oamp.util.UtilPrint;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.PpDataHandler;
import com.aastra.omilib.PpDataNotificationInterface;
import com.aastra.omilib.PpDataRecord;
import com.aastra.omilib.PpDevDataRecord;
import com.aastra.omilib.PpEventEnum;
import com.aastra.omilib.PpUserDataRecord;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;

public class PpMonitorMainPanel
extends GuiUtilMainPanel
implements ConfiguratorTableEventInterface {
    private static final long serialVersionUID = 1L;
    private static boolean ppDevMonitoringState = false;
    private OmiMessage.PermissionType[] permissionArray = null;
    private GuiUtilDetailSplitPanel ppDetailSplitPane = null;
    private AastraScrollPane ppTablePane = null;
    private PpMonitorDetailPanel ppDetailPanel = null;
    private PpMonitorTaskPanel ppTaskPanel = null;
    private int currentPpn = -1;
    private int currentUid = -1;
    private PpDataHandler ppDataHandler = null;
    private NotificationHandlerClass ppUserHandler = null;
    private NotificationHandlerClass ppDevHandler = null;
    private int dividerLocation = 0;
    private boolean tableActive = false;
    private OmiManagement omiManagement = null;
    private GuiUtilTableColSelect[] tableColSel = null;

    public PpMonitorMainPanel(PpDataHandler ppDataHandler) {
        this.ppDataHandler = ppDataHandler;
        this.ppUserHandler = new NotificationHandlerClass();
        this.ppUserHandler.notificationType = NotificationTypeEnum.USER_NOTIFICATION;
        this.ppDataHandler.registerUserDataNotificationListener(this.ppUserHandler);
        this.ppDevHandler = new NotificationHandlerClass();
        this.ppDevHandler.notificationType = NotificationTypeEnum.DEVICE_NOTIFICATION;
        this.ppDataHandler.registerDevDataNotificationListener(this.ppDevHandler);
        this.omiManagement = GuiMain.getOmiManagementObject();
        this.permissionArray = this.omiManagement.getOmmPermissions();
        if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
            this.ppDataHandler.subscribeEventPPDevState();
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                this.ppDataHandler.subscribeEventPPSipState();
            }
        }
        this.initialize();
    }

    public void deregisterNotificationListener() {
        this.ppDataHandler.deregisterUserDataNotificationListener(this.ppUserHandler);
        this.ppDataHandler.deregisterDevDataNotificationListener(this.ppDevHandler);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPpDetailSplitPane(), "Center");
        this.add((Component)this.getPpTaskPanel(), "East");
    }

    protected GuiUtilTableColSelect[] getTableColumnsSelection() {
        if (this.tableColSel == null) {
            GuiUtilTableColSelect[] guiUtilTableColSelectArray = new GuiUtilTableColSelect[]{new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_PPN), true), new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_TIME_STAMP), false), new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_IPEI), true), new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_AC), false), new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ENCRYPT), false, GuiUtilIcon.getIconArrayErrorActive()), new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SUBSCRIBED), true, GuiUtilIcon.getIconArrayErrorErrorActive()), new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_HW_TYPE), false), new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_AUTO_CREATE), false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_NAME, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_NUM, true), new GuiUtilTableColSelect(PpUserDataRecord.IDX_HIERARCHY1, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_HIERARCHY2, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_ADD_ID, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_SOS_NUM, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_MAN_DOWN_NUM, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_MSG_RIGHT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_SEND_VCARD_RIGHT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_RECV_VCARD_RIGHT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_TRACKING_ACTIVE, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_LOCATABLE, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_LOC_RIGHT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_VIP, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_SIP_REGISTER_CHECK, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_HOT_DESKING_SUPPORT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_AUTO_LOGOUT_ON_CHARGE, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_AUTHENTICATE_LOGOUT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_FIXED_SIP_PORT, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_CALCULATED_SIP_PORT, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_USE_SIP_USER_NAME, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_USE_SIP_USER_AUTH, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_SERVICE_USER_NAME, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_SERVICE_AUTH_NAME, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_KEY_LOCK_ENABLE, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_KEY_LOCK_TIME, false)};
            int n = 0;
            int n2 = guiUtilTableColSelectArray.length;
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVoiceboxNumber)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) {
                n += 3;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveExternalUserData)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveMOM)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                n += 11;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync)) {
                n += 8;
            }
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
                n = this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP) ? (n += 12) : (n += 8);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
                n += 3;
            }
            this.tableColSel = Arrays.copyOf(guiUtilTableColSelectArray, n2 + n);
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVoiceboxNumber)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_VOICEBOX_NUM, false);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_UID, false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_REL_TYPE, false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_KEEP_LOCAL_PB, false, GuiUtilIcon.getIconArrayInactiveActive());
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveExternalUserData)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_EXTERNAL, false, GuiUtilIcon.getIconArrayInactiveActive());
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveMOM)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_PERMANENT, false, GuiUtilIcon.getIconArrayInactiveActive());
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_ALLOW_VIDEO_STREAM, false, GuiUtilIcon.getIconArrayInactiveActive());
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_SIP_AUTH_ID, false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_FORWARD_STATE, false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_FORWARD_TIME, false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_FORWARD_DEST, false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_LANG, false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_HOLD_RING_BACK_TIME, false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_CALL_WAITING_DISABLED, false, GuiUtilIcon.getIconArrayInactiveActive());
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_AUTO_ANSWER, false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_MICROPHONE_MUTE, false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_WARNING_TONE, false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_ALLOW_BARGE_IN, false);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_CONFERENCE_SERVER_TYPE, false);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SUBSCRIBE_TO_PARI_ONLY), false, GuiUtilIcon.getIconArrayInactiveActive());
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_OMM_ID), false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_OMM_ID_ACK), false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ROAMING_STATE), false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_MODIC_TYPE), false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_LOCATION_DATA), false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_DECT_IE_FIXED_ID), false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SUBSCRIPTION_ID), false);
            }
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ST_SW_VERSION), false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_LAST_ACTION_TIME), true);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_RFP), true);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_CC_ACTIVE), true, GuiUtilIcon.getIconArraySpacerActive());
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SS_ACTIVE), false, GuiUtilIcon.getIconArraySpacerActive());
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_MM_ACTIVE), true, GuiUtilIcon.getIconArraySpacerActive());
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_COMS_ACTIVE), false, GuiUtilIcon.getIconArraySpacerActive());
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ACTIVITIES), true);
                if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                    this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ST_REGISTERED), false, GuiUtilIcon.getIconArrayInactiveActive());
                    this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ST_REG_SERVER_TYPE), false);
                    this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ST_REG_SERVER_ADDR), false);
                    this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ST_REG_SERVER_PORT), false);
                }
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_MONITORING, false);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_CONFIG_DATA_PROFILE_ID, false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_CONFIG_DATA_LOADED, false, GuiUtilIcon.getIconArrayInactiveActive());
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_DEF_PROFILE_LOADED), false, GuiUtilIcon.getIconArrayInactiveActive());
            }
        }
        return this.tableColSel;
    }

    public void processDevStatusEvent(int n, int n2, PpEventEnum ppEventEnum, Object[] objectArray) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP device status event: " + ppEventEnum.toString() + ",ppn=" + n + ",rfpId=" + n2);
        if (PpActivityLogFile.IsLogActive()) {
            PpActivityLogFile.writeLog(ppEventEnum, n, n2);
        }
    }

    void processUserDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP user notification: " + dataNotificationEnum.toString() + ",uid=" + n);
        switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                this.checkPpTransactionStart();
                break;
            }
            case DATA_CHANGED: {
                Object object;
                if (this.currentUid != n) break;
                PpUserDataRecord ppUserDataRecord = this.ppDataHandler.getPpUserData(n);
                PpDevDataRecord ppDevDataRecord = null;
                if (ppUserDataRecord != null && (object = (Integer)ppUserDataRecord.getField(PpUserDataRecord.IDX_PPN)) != null) {
                    ppDevDataRecord = this.ppDataHandler.getPpDevData((Integer)object);
                }
                object = new PpDataRecord(ppUserDataRecord, ppDevDataRecord);
                this.createPpDetailPanel((DataRecord)object);
                break;
            }
        }
    }

    void processDevDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP device notification: " + dataNotificationEnum.toString() + ",ppn=" + n);
        switch (dataNotificationEnum) {
            case DATA_CHANGED: {
                if (this.currentPpn != n) break;
                PpDevDataRecord ppDevDataRecord = this.ppDataHandler.getPpDevData(n);
                PpUserDataRecord ppUserDataRecord = null;
                if (ppDevDataRecord != null) {
                    Integer n2 = (Integer)ppDevDataRecord.getField(PpDevDataRecord.IDX_UID);
                    OmiMessage.PPRelTypeType pPRelTypeType = (OmiMessage.PPRelTypeType)((Object)ppDevDataRecord.getField(PpDevDataRecord.IDX_REL_TYPE));
                    if (pPRelTypeType == OmiMessage.PPRelTypeType.Unbound) {
                        this.removePpDetailPanel();
                        break;
                    }
                    if (n2 != null) {
                        ppUserDataRecord = this.ppDataHandler.getPpUserData(n2);
                    }
                    PpDataRecord ppDataRecord = new PpDataRecord(ppUserDataRecord, ppDevDataRecord);
                    this.createPpDetailPanel(ppDataRecord);
                    break;
                }
                PpDataRecord ppDataRecord = new PpDataRecord(ppUserDataRecord, ppDevDataRecord);
                this.createPpDetailPanel(ppDataRecord);
                break;
            }
        }
    }

    private void processTableEvent(DataRecord dataRecord) {
        if (this.ppDetailSplitPane.getBottomComponent() != null) {
            if (dataRecord != null) {
                this.createPpDetailPanel(dataRecord);
            } else {
                this.removePpDetailPanel();
            }
        } else if (this.table.getSelectedRowCount() == 1) {
            this.ppTaskPanel.setTaskButtonShowDetails(true);
        } else {
            this.ppTaskPanel.setTaskButtonShowDetails(false);
        }
        this.updateTableInfo();
    }

    public void showPpDetails() {
        int n = this.table.getSelectedRow();
        if (n >= 0) {
            int n2 = this.table.convertRowIndexToModel(n);
            PpDataRecord ppDataRecord = this.ppDataHandler.getDatabase().getRecordByIdx(n2);
            if (ppDataRecord != null) {
                this.createPpDetailPanel(ppDataRecord);
            }
        }
    }

    private GuiUtilDetailSplitPanel getPpDetailSplitPane() {
        if (this.ppDetailSplitPane == null) {
            this.ppDetailSplitPane = new GuiUtilDetailSplitPanel(390);
            this.ppDetailSplitPane.setTopComponent(this.getPpTablePane());
            this.ppDetailSplitPane.setBottomComponent(null);
        }
        return this.ppDetailSplitPane;
    }

    private GuiUtilConfiguratorTable getPpTable() {
        if (this.table == null) {
            this.table = new GuiUtilConfiguratorTable((Object)this, (Database)this.ppDataHandler.getDatabase(), this.getTableColumnsSelection(), this.getActiveTableColumns(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectPpMonitor, this.getTableColumnsSelection(), true), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthPpMonitor, 0);
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                this.table.setNegativeIntAsInvalid(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ST_REG_SERVER_PORT));
            }
            this.table.setColumnFormatString(PpUserDataRecord.IDX_UID, "0x%03X");
            this.table.setColumnFormatString(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_PPN), "0x%03X");
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
                this.table.setColumnFormatString(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_RFP), "0x%03X");
                this.table.setNegativeIntAsInvalid(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_RFP));
            }
            this.table.setZeroIntAsInvalid(PpUserDataRecord.IDX_KEY_LOCK_TIME);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_UID, 20);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_REL_TYPE, 35);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_EXTERNAL, 20);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_PERMANENT, 20);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_HOT_DESKING_SUPPORT, 20);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_AUTO_LOGOUT_ON_CHARGE, 20);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_AUTHENTICATE_LOGOUT, 20);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_NUM, 40);
            this.table.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_PPN), 20);
            this.table.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_IPEI), 55);
            this.table.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_CC_ACTIVE), 10);
            this.table.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SS_ACTIVE), 10);
            this.table.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_MM_ACTIVE), 10);
            this.table.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_COMS_ACTIVE), 10);
            this.table.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ST_REGISTERED), 20);
            this.table.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SUBSCRIBED), 23);
            this.table.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_RFP), 27);
            this.table.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_LAST_ACTION_TIME), 40);
            this.table.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_FW_VERSION), 25);
            this.table.applyPreferredColumnWidthSettings();
        }
        return this.table;
    }

    private AastraScrollPane getPpTablePane() {
        if (this.ppTablePane == null) {
            this.ppTablePane = new AastraScrollPane(this.getPpTable());
            this.dividerLocation = this.ppDetailSplitPane.getHeight() - 390;
            this.ppTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.ppTablePane;
    }

    private void enableTableAccess() {
        this.table.setActive(true);
        this.ppTaskPanel.setTaskButtonConfigureTable(true);
        this.ppTaskPanel.setTaskButtonFilter(true);
        this.ppTaskPanel.setTaskButtonActivateEventLog(true, null);
        this.tableActive = true;
    }

    private void disableTableAccess() {
        this.tableActive = false;
        this.table.setActive(false);
        this.ppTaskPanel.setTaskButtonShowDetails(false);
        this.ppTaskPanel.setTaskButtonConfigureTable(false);
        this.ppTaskPanel.setTaskButtonFilter(false);
        this.ppTaskPanel.setTaskButtonActivateEventLog(false, null);
    }

    protected void configureTableFilter() {
        boolean bl = UtilFilterTable.setFilterItems(this.table, UtilPreferences.getTableFilterValues(UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesPpMonitor));
        this.ppTaskPanel.setTaskButtonFilterState(bl, null);
    }

    private AastraPanel getPpDetailPanel() {
        if (this.ppDetailPanel == null) {
            this.ppDetailPanel = new PpMonitorDetailPanel(this, this.permissionArray);
        }
        return this.ppDetailPanel;
    }

    private AastraPanel getPpTaskPanel() {
        if (this.ppTaskPanel == null) {
            this.ppTaskPanel = new PpMonitorTaskPanel(this, this.table);
        }
        return this.ppTaskPanel;
    }

    public void createPpDetailPanel(DataRecord dataRecord) {
        if (this.ppDetailSplitPane.getBottomComponent() != null) {
            this.dividerLocation = this.ppDetailSplitPane.getDividerLocation();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating PP monitor detail panel");
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating PP monitor detail panel");
            this.ppDetailSplitPane.setBottomComponent(this.getPpDetailPanel());
            this.ppDetailPanel.setDefaultTab();
        }
        if (dataRecord != null) {
            PpDataRecord ppDataRecord = (PpDataRecord)dataRecord;
            PpUserDataRecord ppUserDataRecord = ppDataRecord.ppUser;
            PpDevDataRecord ppDevDataRecord = ppDataRecord.ppDev;
            Integer n = (Integer)ppUserDataRecord.getField(PpUserDataRecord.IDX_UID);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading PP user[" + n + "]:");
            UtilPrint.printPpUserDataRecordString(ppUserDataRecord, this);
            Integer n2 = (Integer)ppDevDataRecord.getField(PpDevDataRecord.IDX_PPN);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading PP device[" + n2 + "]:");
            UtilPrint.printPpDevDataRecordString(ppDevDataRecord, this);
            this.ppDetailPanel.setPpUserDetailData(ppUserDataRecord);
            this.ppDetailPanel.setPpDevDetailData(ppDevDataRecord);
            this.currentUid = n;
            this.currentPpn = n2;
        } else {
            this.ppDetailPanel.setPpUserDetailData(null);
            this.ppDetailPanel.setPpDevDetailData(null);
        }
        this.ppDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.ppDetailSplitPane.validate();
        this.ppTaskPanel.setTaskButtonShowDetails(false);
    }

    public void removePpDetailPanel() {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing PP monitor detail panel");
        this.dividerLocation = this.ppDetailSplitPane.getDividerLocation();
        this.ppDetailSplitPane.setBottomComponent(null);
        this.currentUid = -1;
        this.currentPpn = -1;
        if (this.table.getSelectedRowCount() == 1) {
            this.ppTaskPanel.setTaskButtonShowDetails(true);
        }
    }

    public static boolean getPPDevMonitoringState() {
        return ppDevMonitoringState;
    }

    public static void setPPDevMonitoringState(boolean bl) {
        ppDevMonitoringState = bl;
    }

    private void checkPpTransactionStart() {
        if ((UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring) || UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Locating)) && this.tableActive && this.componentActivated && !PpMonitorMainPanel.getPPDevMonitoringState()) {
            PpMonitorMainPanel.setPPDevMonitoringState(true);
            this.ppDataHandler.subscribeEventPPTransaction();
            this.ppDataHandler.updateLastPpDevAction();
            this.ppDataHandler.updateActivePpDev();
        }
    }

    @Override
    protected void componentActivateAction() {
        this.checkPpTransactionStart();
        this.ppTaskPanel.setTaskButtonActivateEventLog(null, PpActivityLogFile.IsLogActive());
        this.configureTableFilter();
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        this.createPpDetailPanel(dataRecord);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    class NotificationHandlerClass
    implements PpDataNotificationInterface {
        public NotificationTypeEnum notificationType = NotificationTypeEnum.USER_NOTIFICATION;

        NotificationHandlerClass() {
        }

        @Override
        public void processDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
            if (this.notificationType == NotificationTypeEnum.USER_NOTIFICATION) {
                PpMonitorMainPanel.this.processUserDataNotification(n, dataNotificationEnum);
            } else {
                PpMonitorMainPanel.this.processDevDataNotification(n, dataNotificationEnum);
            }
        }

        @Override
        public void processErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        }

        @Override
        public void processStatusEvent(int n, int n2, PpEventEnum ppEventEnum, Object[] objectArray) {
            PpMonitorMainPanel.this.processDevStatusEvent(n, n2, ppEventEnum, objectArray);
        }
    }

    private static enum NotificationTypeEnum {
        USER_NOTIFICATION,
        DEVICE_NOTIFICATION;

    }
}

