/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.pp;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.gui.GuiProgressDlgCancel;
import com.aastra.oamp.gui.GuiStatusBar;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilMainPanel;
import com.aastra.oamp.guiutil.GuiUtilTableColSelect;
import com.aastra.oamp.pp.PpUserConfigDetailPanel;
import com.aastra.oamp.pp.PpUserConfigTaskPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilFilterTable;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.oamp.util.UtilPrint;
import com.aastra.omilib.DataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.DatabaseChangeEvent;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.PpDataHandler;
import com.aastra.omilib.PpDataNotificationInterface;
import com.aastra.omilib.PpDevDataRecord;
import com.aastra.omilib.PpEventEnum;
import com.aastra.omilib.PpUserDataRecord;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.HashMap;

public class PpUserConfigMainPanel
extends GuiUtilMainPanel
implements PpDataNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface,
DataHandler.DataHandlerSendBulkInterface,
GuiProgressDlgCancel.GuiProgressDlgCancelInterface {
    private static final long serialVersionUID = 1L;
    private GuiStatusBar guiStatusBar = null;
    private GuiUtilDetailSplitPanel ppUserDetailSplitPane = null;
    private AastraScrollPane ppUserTablePane = null;
    private PpUserConfigDetailPanel ppUserDetailPanel = null;
    private PpUserConfigTaskPanel ppUserTaskPanel = null;
    private boolean detailPanelPending = false;
    private HashMap<Integer, Boolean> pendingUid = new HashMap();
    private PpDataHandler ppDataHandler = null;
    private int dividerLocation = 0;
    private int cntNotificationsToReceive = 0;
    private OmiManagement omiManagement = null;
    private int cntPPSendBulkTotal;
    private DataHandler.SendBulkActionType sendBulkAction = null;
    private GuiProgressDlgCancel guiProgressDlg = null;
    private UtilErrorComp utilErrorComp = null;
    private GuiUtilTableColSelect[] tableColSel = null;

    public PpUserConfigMainPanel(PpDataHandler ppDataHandler) {
        this.ppDataHandler = ppDataHandler;
        this.guiStatusBar = GuiMain.getGuiStatusBarObject();
        this.omiManagement = GuiMain.getOmiManagementObject();
        this.ppDataHandler.registerUserDataNotificationListener(this);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPpUserDetailSplitPane(), "Center");
        this.add((Component)this.getPpUserTaskPanel(), "East");
        this.ppUserTaskPanel.initPpUserConfigPanelObject(this, this.getPpUserTable());
        this.utilErrorComp = new UtilErrorComp();
    }

    protected GuiUtilTableColSelect[] getTableColumnsSelection() {
        if (this.tableColSel == null) {
            GuiUtilTableColSelect[] guiUtilTableColSelectArray = new GuiUtilTableColSelect[]{new GuiUtilTableColSelect(PpUserDataRecord.IDX_UID, true), new GuiUtilTableColSelect(PpUserDataRecord.IDX_TIME_STAMP, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_NAME, true), new GuiUtilTableColSelect(PpUserDataRecord.IDX_NUM, true), new GuiUtilTableColSelect(PpUserDataRecord.IDX_HIERARCHY1, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_HIERARCHY2, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_ADD_ID, true), new GuiUtilTableColSelect(PpUserDataRecord.IDX_SOS_NUM, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_MAN_DOWN_NUM, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_SIP_AUTH_ID, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_REL_TYPE, true), new GuiUtilTableColSelect(PpUserDataRecord.IDX_PPN, true), new GuiUtilTableColSelect(PpUserDataRecord.IDX_MSG_RIGHT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_SEND_VCARD_RIGHT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_RECV_VCARD_RIGHT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_TRACKING_ACTIVE, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_LOCATABLE, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_LOC_RIGHT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_KEEP_LOCAL_PB, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_VIP, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_SIP_REGISTER_CHECK, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_HOT_DESKING_SUPPORT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_AUTO_LOGOUT_ON_CHARGE, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_AUTHENTICATE_LOGOUT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_FIXED_SIP_PORT, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_CALCULATED_SIP_PORT, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_GUI_ATTRIB1, true, GuiUtilIcon.getIconArrayErrorActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_USE_SIP_USER_NAME, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_USE_SIP_USER_AUTH, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_SERVICE_USER_NAME, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_SERVICE_AUTH_NAME, false), new GuiUtilTableColSelect(PpUserDataRecord.IDX_KEY_LOCK_ENABLE, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(PpUserDataRecord.IDX_KEY_LOCK_TIME, false)};
            int n = 0;
            int n2 = guiUtilTableColSelectArray.length;
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVoiceboxNumber)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                n += 4;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveExternalUserData)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveMOM)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
                ++n;
            }
            this.tableColSel = Arrays.copyOf(guiUtilTableColSelectArray, n2 + n);
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVoiceboxNumber)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_VOICEBOX_NUM, false);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_AUTO_ANSWER, false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_MICROPHONE_MUTE, false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_WARNING_TONE, false);
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_ALLOW_BARGE_IN, false);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveExternalUserData)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_EXTERNAL, false, GuiUtilIcon.getIconArrayInactiveActive());
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveMOM)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_PERMANENT, false, GuiUtilIcon.getIconArrayInactiveActive());
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_ALLOW_VIDEO_STREAM, false, GuiUtilIcon.getIconArrayInactiveActive());
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_MONITORING, false);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_CONFERENCE_SERVER_TYPE, false);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(PpUserDataRecord.IDX_CONFIG_DATA_PROFILE_ID, false);
            }
        }
        return this.tableColSel;
    }

    private void updateAttrib1(int n) {
        OmiMessage.DECTSubscriptionStateType dECTSubscriptionStateType = OmiMessage.DECTSubscriptionStateType.No;
        PpUserDataRecord ppUserDataRecord = this.ppDataHandler.getPpUserData(n);
        int n2 = 0;
        if (ppUserDataRecord != null) {
            OmiMessage.PPRelTypeType pPRelTypeType = (OmiMessage.PPRelTypeType)((Object)ppUserDataRecord.getField(PpUserDataRecord.IDX_REL_TYPE));
            if (pPRelTypeType != OmiMessage.PPRelTypeType.Unbound) {
                try {
                    n2 = (Integer)ppUserDataRecord.getField(PpUserDataRecord.IDX_PPN);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading ppn for uid=" + n + " failed");
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading ppn for uid=" + n + " failed");
                    return;
                }
                PpDevDataRecord ppDevDataRecord = this.ppDataHandler.getPpDevData(n2);
                if (ppDevDataRecord != null) {
                    dECTSubscriptionStateType = (OmiMessage.DECTSubscriptionStateType)((Object)ppDevDataRecord.getField(PpDevDataRecord.IDX_SUBSCRIBED));
                }
            }
            if (pPRelTypeType != OmiMessage.PPRelTypeType.Unbound && dECTSubscriptionStateType == OmiMessage.DECTSubscriptionStateType.Yes) {
                this.ppDataHandler.setPpUserInternalAttrib(n, PpUserDataRecord.IDX_GUI_ATTRIB1, (Object)PpUserDataRecord.PpUserActiveTypeEnum.PP_USER_ACTIVE);
            } else {
                this.ppDataHandler.setPpUserInternalAttrib(n, PpUserDataRecord.IDX_GUI_ATTRIB1, (Object)PpUserDataRecord.PpUserActiveTypeEnum.PP_USER_INACTIVE);
            }
        }
    }

    private void processTableEvent() {
        boolean bl = false;
        boolean bl2 = false;
        int n = this.table.getSelectedRowCount();
        if (n > 0) {
            bl = true;
            bl2 = true;
        }
        if (this.ppUserDetailSplitPane.getBottomComponent() != null) {
            if (n > 0) {
                DataRecord[] dataRecordArray = new DataRecord[n];
                int[] nArray = this.table.getSelectedRows();
                for (int i = 0; i < n; ++i) {
                    int n2 = this.table.convertRowIndexToModel(nArray[i]);
                    dataRecordArray[i] = this.ppDataHandler.getUserDatabase().getRecordByIdx(n2);
                }
                this.createPpUserDetailPanel(dataRecordArray);
            } else {
                this.removePpUserDetailPanel();
            }
            bl = false;
        }
        this.ppUserTaskPanel.setTaskButtonConfigure(bl);
        this.ppUserTaskPanel.setTaskButtonDelete(bl2);
        this.updateTableInfo();
    }

    public void configurePpUser() {
        int n = this.table.getSelectedRowCount();
        DataRecord[] dataRecordArray = new DataRecord[n];
        int[] nArray = this.table.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2 = this.table.convertRowIndexToModel(nArray[i]);
            dataRecordArray[i] = this.ppDataHandler.getUserDatabase().getRecordByIdx(n2);
        }
        this.createPpUserDetailPanel(dataRecordArray);
    }

    private GuiUtilDetailSplitPanel getPpUserDetailSplitPane() {
        if (this.ppUserDetailSplitPane == null) {
            this.ppUserDetailSplitPane = new GuiUtilDetailSplitPanel(390);
            this.ppUserDetailSplitPane.setTopComponent(this.getPpUserTablePane());
            this.ppUserDetailSplitPane.setBottomComponent(null);
        }
        return this.ppUserDetailSplitPane;
    }

    private GuiUtilConfiguratorTable getPpUserTable() {
        if (this.table == null) {
            this.table = new GuiUtilConfiguratorTable((Object)this, (Database)this.ppDataHandler.getUserDatabase(), this.getTableColumnsSelection(), this.getActiveTableColumns(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectPpUserConfig, this.getTableColumnsSelection(), true), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthPpUserConfig);
            this.table.setType(DatabaseChangeEvent.DatabaseChangeType.PP_USER);
            this.table.setPasswordColum(PpUserDataRecord.IDX_PIN);
            this.table.setPasswordColum(PpUserDataRecord.IDX_SIP_PW);
            this.table.setColumnFormatString(PpUserDataRecord.IDX_UID, "0x%03X");
            this.table.setColumnFormatString(PpUserDataRecord.IDX_PPN, "0x%03X");
            this.table.setNegativeIntAsInvalid(PpUserDataRecord.IDX_PPN);
            this.table.setZeroIntAsInvalid(PpUserDataRecord.IDX_KEY_LOCK_TIME);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_UID, 25);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_REL_TYPE, 45);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_PPN, 35);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_GUI_ATTRIB1, 20);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_EXTERNAL, 20);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_HOT_DESKING_SUPPORT, 20);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_AUTO_LOGOUT_ON_CHARGE, 20);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_AUTHENTICATE_LOGOUT, 20);
            this.table.setPreferredColumnWidth(PpUserDataRecord.IDX_PERMANENT, 20);
            this.table.applyPreferredColumnWidthSettings();
        }
        return this.table;
    }

    private void enableTableAccess() {
        this.table.setActive(true);
        this.ppUserTaskPanel.setTaskButtonCreate(true);
        this.ppUserTaskPanel.setTaskButtonConfigureTable(true);
        this.ppUserTaskPanel.setTaskButtonFilter(true);
    }

    private void disableTableAccess() {
        this.table.setActive(false);
        this.ppUserTaskPanel.setTaskButtonCreate(false);
        this.ppUserTaskPanel.setTaskButtonConfigure(false);
        this.ppUserTaskPanel.setTaskButtonDelete(false);
        this.ppUserTaskPanel.setTaskButtonConfigureTable(false);
        this.ppUserTaskPanel.setTaskButtonFilter(false);
    }

    protected void configureTableFilter() {
        boolean bl = UtilFilterTable.setFilterItems(this.table, UtilPreferences.getTableFilterValues(UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesPpUserConfig));
        this.ppUserTaskPanel.setTaskButtonFilterState(bl, null);
    }

    private AastraScrollPane getPpUserTablePane() {
        if (this.ppUserTablePane == null) {
            this.ppUserTablePane = new AastraScrollPane(this.getPpUserTable());
            this.dividerLocation = this.ppUserDetailSplitPane.getHeight() - 390;
            this.ppUserTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.ppUserTablePane;
    }

    public void startCreatePpUser() {
        this.table.removeRowSelectionAll();
        this.createPpUserDetailPanel(null);
    }

    private void createPpUserDetailPanel(DataRecord[] dataRecordArray) {
        if (this.ppUserDetailSplitPane.getBottomComponent() != null) {
            this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
            this.utilErrorComp.clearComponents();
            this.dividerLocation = this.ppUserDetailSplitPane.getDividerLocation();
            if (dataRecordArray == null) {
                this.ppUserDetailPanel.setDefaultTab();
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating PP user config detail panel");
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating PP user config detail panel");
            this.ppUserDetailSplitPane.setBottomComponent(this.getPpUserDetailPanel());
            this.ppUserDetailPanel.setDefaultTab();
        }
        if (dataRecordArray != null) {
            for (int i = 0; i < dataRecordArray.length; ++i) {
                Integer n = (Integer)dataRecordArray[i].getField(PpUserDataRecord.IDX_UID);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading PP user[" + n + "]:");
                UtilPrint.printPpUserDataRecordString((PpUserDataRecord)dataRecordArray[i], this);
            }
            this.ppUserDetailPanel.setPpUserDetailData(dataRecordArray);
        } else {
            this.ppUserDetailPanel.setPpUserDetailData(null);
        }
        this.ppUserDetailPanel.requestDefaultFocusInWindow();
        this.ppUserDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.ppUserDetailSplitPane.validate();
        this.ppUserTaskPanel.setTaskButtonConfigure(false);
    }

    private AastraPanel getPpUserDetailPanel() {
        if (this.ppUserDetailPanel == null) {
            this.ppUserDetailPanel = new PpUserConfigDetailPanel(this, this.utilErrorComp);
        }
        return this.ppUserDetailPanel;
    }

    public void removePpUserDetailPanel() {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing PP user config detail panel");
        this.clearDetailPanelPending();
        this.utilErrorComp.clearComponents();
        this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
        this.dividerLocation = this.ppUserDetailSplitPane.getDividerLocation();
        this.ppUserDetailSplitPane.setBottomComponent(null);
        if (this.table.getSelectedRow() >= 0) {
            this.ppUserTaskPanel.setTaskButtonConfigure(true);
            this.ppUserTaskPanel.setTaskButtonDelete(true);
        } else {
            this.ppUserTaskPanel.setTaskButtonDelete(false);
        }
    }

    private AastraPanel getPpUserTaskPanel() {
        if (this.ppUserTaskPanel == null) {
            this.ppUserTaskPanel = new PpUserConfigTaskPanel(this, this.getPpUserTable());
        }
        return this.ppUserTaskPanel;
    }

    public void setDetailPanelPending() {
        this.detailPanelPending = true;
    }

    private void clearDetailPanelPending() {
        this.detailPanelPending = false;
        this.pendingUid.clear();
    }

    public void createPpUser() {
        PpUserDataRecord[] ppUserDataRecordArray = (PpUserDataRecord[])this.ppUserDetailPanel.getPpUserDetailData();
        if (ppUserDataRecordArray == null) {
            return;
        }
        PpUserDataRecord ppUserDataRecord = ppUserDataRecordArray[0];
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating PP user:");
        UtilPrint.printPpUserDataRecordString(ppUserDataRecord, this);
        this.ppDataHandler.sendCreatePpUser(ppUserDataRecord);
        this.setDetailPanelPending();
    }

    public void changePpUser() {
        int n;
        DataRecord[] dataRecordArray = null;
        PpUserDataRecord[] ppUserDataRecordArray = (PpUserDataRecord[])this.ppUserDetailPanel.getPpUserDetailData();
        if (ppUserDataRecordArray == null) {
            return;
        }
        this.cntPPSendBulkTotal = 0;
        for (n = 0; n < ppUserDataRecordArray.length; ++n) {
            if (!ppUserDataRecordArray[n].getRecordChanged()) continue;
            this.ppDataHandler.getUserDatabase().updateTransientFields(ppUserDataRecordArray[n]);
            ++this.cntPPSendBulkTotal;
            ++this.cntNotificationsToReceive;
            this.pendingUid.put((Integer)ppUserDataRecordArray[n].getField(PpUserDataRecord.IDX_UID), false);
        }
        if (this.cntPPSendBulkTotal > 0) {
            n = 0;
            dataRecordArray = new DataRecord[this.cntPPSendBulkTotal];
            for (int i = 0; i < ppUserDataRecordArray.length; ++i) {
                if (!ppUserDataRecordArray[i].getRecordChanged()) continue;
                dataRecordArray[n++] = ppUserDataRecordArray[i];
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, String.format("Changing %d PP(s)\n", this.cntPPSendBulkTotal));
            this.sendBulkAction = DataHandler.SendBulkActionType.Change;
            this.ppDataHandler.sendChangeDeletePPs(this.sendBulkAction, dataRecordArray, this);
            this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_BUSY, null);
            this.setDetailPanelPending();
            if (this.cntPPSendBulkTotal > 1) {
                this.guiProgressDlg = new GuiProgressDlgCancel(UtilLocale.getString("TXT_CHANGING_PP_USERS_IN_PROGRESS"), false, true, this);
                this.guiProgressDlg.setValue(0);
                this.guiProgressDlg.setVisible(true);
            }
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Change PP(s): OMILIB told us there is nothing to do (all PP user attributes are unchanged)");
            this.removePpUserDetailPanel();
        }
    }

    public void deletePpUser() {
        GuiUtilDialog guiUtilDialog;
        DataRecord[] dataRecordArray = null;
        int n = this.table.getSelectedRowCount();
        if (n > 0 && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_DELETE_SELECTED_USERS_?"), true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            int[] nArray = this.table.getSelectedRows();
            int n2 = 0;
            this.cntNotificationsToReceive = nArray.length;
            this.cntPPSendBulkTotal = nArray.length;
            dataRecordArray = new DataRecord[this.cntPPSendBulkTotal];
            for (int i = 0; i < this.cntPPSendBulkTotal; ++i) {
                int n3 = this.table.convertRowIndexToModel(nArray[i]);
                PpUserDataRecord ppUserDataRecord = this.ppDataHandler.getPpUserDataByIdx(n3);
                int n4 = (Integer)ppUserDataRecord.getField(PpUserDataRecord.IDX_UID);
                dataRecordArray[n2++] = ppUserDataRecord;
                if (this.ppUserDetailSplitPane.getBottomComponent() == null || this.ppUserDetailPanel.getSelectedPpUser() != n4) continue;
                this.pendingUid.put(n4, false);
            }
            this.sendBulkAction = DataHandler.SendBulkActionType.Delete;
            this.ppDataHandler.sendChangeDeletePPs(this.sendBulkAction, dataRecordArray, this);
            if (this.cntPPSendBulkTotal > 1) {
                this.guiProgressDlg = new GuiProgressDlgCancel(UtilLocale.getString("TXT_DELETING_PP_USERS_IN_PROGRESS"), false, true, this);
                this.guiProgressDlg.setValue(0);
                this.guiProgressDlg.setVisible(true);
            }
        }
    }

    @Override
    public void processDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP user notification: " + dataNotificationEnum.toString() + ",uid=" + n);
        if (this.table.getSelectedRow() == -1) {
            this.ppUserTaskPanel.setTaskButtonConfigure(false);
            this.ppUserTaskPanel.setTaskButtonDelete(false);
        }
        switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                break;
            }
            case NEW_DATA: {
                if (this.detailPanelPending) {
                    this.removePpUserDetailPanel();
                }
                this.updateAttrib1(n);
                break;
            }
            case DATA_CHANGED: {
                if (this.detailPanelPending) {
                    if (this.pendingUid.containsKey(n) && this.cntNotificationsToReceive > 0) {
                        --this.cntNotificationsToReceive;
                    }
                    this.pendingUid.remove(n);
                    if (this.pendingUid.isEmpty()) {
                        this.removePpUserDetailPanel();
                        this.cntNotificationsToReceive = 0;
                    }
                }
                this.updateAttrib1(n);
                break;
            }
            case DATA_DELETED: {
                if (!this.detailPanelPending) break;
                if (this.pendingUid.containsKey(n) && this.cntNotificationsToReceive > 0) {
                    --this.cntNotificationsToReceive;
                }
                this.pendingUid.remove(n);
                if (!this.pendingUid.isEmpty()) break;
                this.removePpUserDetailPanel();
                this.cntNotificationsToReceive = 0;
                break;
            }
        }
    }

    @Override
    public void processErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        OmiMessage.errorCodes errorCodes2 = null;
        String string4 = null;
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP user error notification: " + dataNotificationEnum.toString() + ",uid=" + String.valueOf(n) + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP user error notification: Unknown errorCode=" + string);
        }
        if (this.detailPanelPending) {
            if (string2 != null) {
                this.ppUserDetailPanel.markErrorComponent(string2);
            }
            String string5 = this.ppUserDetailPanel.getErrorLabelText(string2);
            if (errorCodes2 != null) {
                string4 = errorCodes2.equals((Object)OmiMessage.errorCodes.ENoMem) && string2 != null && string2.equals(OmiMessage.PPUserType.permanent.name()) ? UtilLocale.getString("TXT_MAX_NUMBER_OF_PERMANENT_USERS_ALREADY_CONFIGURED_!") : UtilErrorHandling.getErrorMessage(errorCodes2, string5, string3);
            }
            if (this.pendingUid.containsKey(n) && this.cntNotificationsToReceive > 0) {
                --this.cntNotificationsToReceive;
            }
            if (dataNotificationEnum == DataNotificationEnum.DATA_CHANGED) {
                if (!this.pendingUid.containsKey(n)) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "uid=" + String.valueOf(n) + " does not exist in send map anymore");
                    return;
                }
                this.pendingUid.put(n, true);
                int n2 = 0;
                for (Integer object2 : this.pendingUid.keySet()) {
                    if (!this.pendingUid.get(object2).booleanValue()) continue;
                    ++n2;
                }
                PpUserDataRecord[] ppUserDataRecordArray = new PpUserDataRecord[n2];
                n2 = 0;
                for (Integer n3 : this.pendingUid.keySet()) {
                    if (!this.pendingUid.get(n3).booleanValue()) continue;
                    ppUserDataRecordArray[n2] = this.ppDataHandler.getPpUserData(n3);
                    ++n2;
                }
                this.ppUserDetailPanel.setPpUserDetailData(ppUserDataRecordArray);
            }
        } else if (errorCodes2 != null) {
            string4 = UtilErrorHandling.getErrorMessage(errorCodes2, string2, string3);
        }
        if (this.componentActivated) {
            if (string4 != null) {
                GuiInfoConsole.showError(string4);
            } else {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
            }
            if (this.cntNotificationsToReceive == 0) {
                this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
            }
        }
    }

    @Override
    public void processStatusEvent(int n, int n2, PpEventEnum ppEventEnum, Object[] objectArray) {
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent();
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        int n = this.table.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        DataRecord[] dataRecordArray = new DataRecord[n];
        int[] nArray = this.table.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2 = this.table.convertRowIndexToModel(nArray[i]);
            dataRecordArray[i] = this.ppDataHandler.getUserDatabase().getRecordByIdx(n2);
        }
        this.createPpUserDetailPanel(dataRecordArray);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent();
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        if (this.ppUserDetailSplitPane.getBottomComponent() != null) {
            this.createPpUserDetailPanel(dataRecordArray);
        }
    }

    @Override
    protected void componentActivateAction() {
        this.configureTableFilter();
    }

    @Override
    public void notifyProgress(int n, boolean bl) {
        if (bl || n == this.cntPPSendBulkTotal) {
            if (this.guiProgressDlg != null) {
                this.guiProgressDlg.dispose();
            }
            GuiMain.getGuiStatusBarObject().showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
            if (bl) {
                if (this.sendBulkAction == DataHandler.SendBulkActionType.Change) {
                    GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_CHANGING_CANCELED_AFTER_*_OF_*_PP_USERS"), n, this.cntPPSendBulkTotal));
                } else {
                    GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_DELETING_CANCELED_AFTER_*_OF_*_PP_USERS"), n, this.cntPPSendBulkTotal));
                }
            }
        } else {
            this.guiProgressDlg.setValue(100 * n / this.cntPPSendBulkTotal);
        }
    }

    @Override
    public void timeout(int n) {
        if (this.guiProgressDlg != null) {
            this.guiProgressDlg.dispose();
        }
        GuiMain.getGuiStatusBarObject().showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
        if (this.sendBulkAction == DataHandler.SendBulkActionType.Change) {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_CHANGING_CANCELED_BY_TIMEOUT_AFTER_*_OF_*_PP_USERS"), n, this.cntPPSendBulkTotal));
        } else {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_DELETING_CANCELED_BY_TIMEOUT_AFTER_*_OF_*_PP_USERS"), n, this.cntPPSendBulkTotal));
        }
    }

    @Override
    public void canceled() {
        this.ppDataHandler.cancelChangeDeletePPs();
    }
}

