/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.guiutil.GuiUtilComboBox;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilTristateCheckBox;
import com.aastra.oamp.rfp.RfpConfigMainPanel;
import com.aastra.oamp.rfp.RfpDetailPanel;
import com.aastra.oamp.rfp.RfpTreeNode;
import com.aastra.oamp.rfp.RfpTreeView;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.RfpDataRecord;
import com.aastra.omilib.SiteDataHandler;
import com.aastra.omilib.WLANProfileHandler;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.util.UtilSpy;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;

public class RfpConfigDetailPanel
extends RfpDetailPanel
implements SiteDataHandler.SiteDataNotificationInterface,
CommonDataHandler.CommonDataNotificationInterface {
    private static final long serialVersionUID = 1L;
    private static final int UNDEFINED_PA = -2;
    private SiteDataHandler siteDataHandler = null;
    private CommonDataHandler commonDataHandler = null;
    private WLANProfileHandler.WLANProfileDatabase wlanProfileDatabase = null;
    private RfpConfigMainPanel rfpMainPanel = null;
    private RfpTreeView rfpTreeView = null;
    private RfpDataRecord[] rfpDataRecords = null;
    private RfpTreeNode nodeRootHierarchy = null;
    private UtilErrorComp utilErrorComp = null;
    private AastraLabel labelDECTActiveInfo = null;
    private AastraLabel labelWLANActiveInfo = null;
    private boolean actionListenerPAActive = false;
    private boolean actionListenerDECTOnActive = false;
    private boolean actionListenerSiteActive = false;
    private boolean actionListenerWLANProfile = false;
    private boolean actionListenerAntennaDiversityActive = false;
    private boolean actionListenerComboBoxHwType = false;
    private boolean actionListenerHighThroughput = false;
    private boolean allowReconfigureBuilding = false;
    private boolean allowReconfigureFloor = false;
    private int parkLengthIdentifier = 0;
    private int pagingAreaSize = 0;
    private int numberPagingArea = 0;
    private int selectedRfp = -1;
    private ActionModeEnum actionMode;
    private static final int TAB_NONE = -1;
    private static final int TAB_GENERAL = 0;
    private static final int TAB_DECT = 1;
    private static final int TAB_WLAN = 2;
    private int errorTab = -1;

    public RfpConfigDetailPanel(RfpConfigMainPanel rfpConfigMainPanel, SiteDataHandler siteDataHandler, CommonDataHandler commonDataHandler, RfpTreeView rfpTreeView, WLANProfileHandler.WLANProfileDatabase wLANProfileDatabase, UtilErrorComp utilErrorComp) {
        this.rfpMainPanel = rfpConfigMainPanel;
        this.siteDataHandler = siteDataHandler;
        this.siteDataHandler.registerDataNotificationListener(this);
        this.commonDataHandler = commonDataHandler;
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.PARK, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.PagingAreaSize, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.DECTRegDomain, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.WLANRegDomain, this);
        this.rfpTreeView = rfpTreeView;
        this.wlanProfileDatabase = wLANProfileDatabase;
        this.utilErrorComp = utilErrorComp;
        this.initialize();
    }

    private void initialize() {
        this.utilChangeHandler = new GuiUtilChangeHandler(this.getButtonOK(), this.getButtonCancel(), false);
        this.panelTabbed.addTab(UtilLocale.getString("TXT_GENERAL"), this.getTabGeneral());
        this.panelTabbed.addTab("DECT", this.getTabDECT());
        this.panelTabbed.addTab("WLAN", this.getTabWLAN());
        this.panelTabbed.addTab(UtilLocale.getString("TXT_HARDWARE"), this.getTabHardwareSet());
        this.panelButtonBar.add(this.getButtonOK());
        this.panelButtonBar.add(this.getButtonCancel());
    }

    public void setRfpDetailData(DataRecord[] dataRecordArray) {
        if (dataRecordArray != null) {
            int n;
            this.rfpDataRecords = new RfpDataRecord[dataRecordArray.length];
            for (n = 0; n < this.rfpDataRecords.length; ++n) {
                this.rfpDataRecords[n] = (RfpDataRecord)dataRecordArray[n].clone();
            }
            this.selectedRfp = (Integer)dataRecordArray[0].getField(RfpDataRecord.IDX_RFP_ID);
            if (dataRecordArray.length == 1) {
                this.labelHeaderBar.setText(String.format(UtilLocale.getString("TXT_RADIO_FIXED_PART") + " #0x%03X", (Integer)dataRecordArray[0].getField(RfpDataRecord.IDX_RFP_ID)));
                this.textFieldName.setText((String)dataRecordArray[0].getField(RfpDataRecord.IDX_NAME));
                this.textFieldName.setEditable(true);
                this.textFieldMACAddress.setText((String)dataRecordArray[0].getField(RfpDataRecord.IDX_ETH_ADDR));
                if (((Boolean)dataRecordArray[0].getField(RfpDataRecord.IDX_LICENSE_RFP)).booleanValue() || ((Boolean)dataRecordArray[0].getField(RfpDataRecord.IDX_OMM_RUNNING)).booleanValue() || ((Boolean)dataRecordArray[0].getField(RfpDataRecord.IDX_OMM_STB_RUNNING)).booleanValue()) {
                    this.textFieldMACAddress.setEditable(false);
                } else {
                    this.textFieldMACAddress.setEditable(true);
                }
            } else {
                String string = " ";
                for (int i = 0; i < dataRecordArray.length; ++i) {
                    string = string + String.format("#0x%03X ", (Integer)dataRecordArray[i].getField(RfpDataRecord.IDX_RFP_ID));
                    if (i <= 3) continue;
                    string = string + " ...";
                    break;
                }
                this.labelHeaderBar.setText(UtilLocale.getString("TXT_RADIO_FIXED_PARTS_20") + string);
                this.textFieldName.setText(AastraCommon.AastraTriStateText);
                this.textFieldName.setEditable(false);
                this.textFieldMACAddress.setText(AastraCommon.AastraTriStateText);
                this.textFieldMACAddress.setEditable(false);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference) && this.updateCheckBoxConferenceChannels()) {
                this.checkBoxConferenceChannels.setState(UtilMisc.getRecordsFieldState(dataRecordArray, RfpDataRecord.IDX_CONFERENCE_CHANNELS));
            }
            this.actionListenerSiteActive = false;
            n = (Integer)UtilMisc.getRecordsFieldObject(dataRecordArray, RfpDataRecord.IDX_SITE);
            if (n == 0) {
                this.comboBoxSite.setEditable(true);
                this.comboBoxSite.setSelectedItem(AastraCommon.AastraTriStateText);
                this.comboBoxSite.setEditable(false);
            } else {
                this.comboBoxSite.setSelectedItem(this.siteDataHandler.getSiteBySiteId(n));
            }
            this.buildHierarchyStructure();
            this.setRfpHierarchy(dataRecordArray);
            this.actionListenerSiteActive = true;
            this.checkBoxPreferredSync.setState(UtilMisc.getRecordsFieldState(dataRecordArray, RfpDataRecord.IDX_PREFERRED_SYNC));
            this.checkBoxReflectiveEnv.setState(UtilMisc.getRecordsFieldState(dataRecordArray, RfpDataRecord.IDX_REFLECTIVE_ENV));
            Integer n2 = (Integer)UtilMisc.getRecordsFieldObject(dataRecordArray, RfpDataRecord.IDX_CLUSTER);
            if (n2 != null && n2 != 0) {
                this.textFieldCluster.setText(n2.toString());
            } else {
                this.textFieldCluster.setText(AastraCommon.AastraTriStateText);
            }
            this.setComboBoxPagingArea((Integer)UtilMisc.getRecordsFieldObject(dataRecordArray, RfpDataRecord.IDX_PAGING_AREA, new Integer(-2)));
            this.configureTabDECTElements();
            this.checkBoxWLANActive.setState(UtilMisc.getRecordsFieldState(dataRecordArray, RfpDataRecord.IDX_WLAN_ON));
            this.updateComboBoxWLANProfile();
            this.comboBoxWLANProfile.setEditable(true);
            this.comboBoxWLANProfile.setSelectedItem(UtilMisc.getRecordsFieldObject(dataRecordArray, RfpDataRecord.IDX_WLAN_PROFILE, AastraCommon.AastraTriStateText));
            this.comboBoxWLANProfile.setEditable(false);
            this.actionListenerAntennaDiversityActive = false;
            this.checkBoxAntennaDiversity.setState(UtilMisc.getRecordsFieldState(dataRecordArray, RfpDataRecord.IDX_WLAN_ANTENNA_DIV));
            this.actionListenerAntennaDiversityActive = true;
            this.comboBoxAntenna.setSelectedIndex((Integer)UtilMisc.getRecordsFieldObject(dataRecordArray, RfpDataRecord.IDX_WLAN_ANTENNA) - 1);
            this.updateComboBoxChannel();
            this.comboBoxChannel.setEditable(true);
            this.comboBoxChannel.setSelectedItem(UtilMisc.getRecordsFieldObject(this.rfpDataRecords, RfpDataRecord.IDX_WLAN_CHANNEL, AastraCommon.AastraTriStateText));
            this.comboBoxChannel.setEditable(false);
            switch ((Integer)UtilMisc.getRecordsFieldObject(dataRecordArray, RfpDataRecord.IDX_WLAN_POWER)) {
                default: {
                    this.comboBoxPower.setSelectedIndex(0);
                    break;
                }
                case 50: {
                    this.comboBoxPower.setSelectedIndex(1);
                    break;
                }
                case 25: {
                    this.comboBoxPower.setSelectedIndex(2);
                    break;
                }
                case 12: {
                    this.comboBoxPower.setSelectedIndex(3);
                    break;
                }
                case 6: {
                    this.comboBoxPower.setSelectedIndex(4);
                }
            }
            this.actionListenerHighThroughput = false;
            this.checkBoxHighThroughput.setState(UtilMisc.getRecordsFieldState(dataRecordArray, RfpDataRecord.IDX_WLAN_HIGH_THROUGHPUT));
            this.actionListenerHighThroughput = true;
            this.setRfpHierarchy(dataRecordArray);
            String string = UtilMisc.getRecordsFieldObject(dataRecordArray, RfpDataRecord.IDX_HWTYPE_TEXT).toString();
            Boolean bl = false;
            for (int i = 0; i < dataRecordArray.length; ++i) {
                if (!((Boolean)dataRecordArray[i].getField(RfpDataRecord.IDX_HWTYPE_LOCKED)).booleanValue()) continue;
                bl = true;
                break;
            }
            this.actionListenerComboBoxHwType = false;
            this.comboBoxHwType.setEditable(true);
            this.comboBoxHwType.setSelectedItem(string);
            this.comboBoxHwType.setEditable(false);
            this.actionListenerComboBoxHwType = true;
            if (!bl.booleanValue()) {
                this.comboBoxHwType.setEnabled(true);
            } else {
                this.comboBoxHwType.setEnabled(false);
            }
            this.actionMode = ActionModeEnum.CHANGE;
        } else {
            this.rfpDataRecords = new RfpDataRecord[1];
            this.rfpDataRecords[0] = new RfpDataRecord();
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_NEW_RADIO_FIXED_PART"));
            this.textFieldName.setEditable(true);
            this.textFieldName.setText("");
            this.textFieldMACAddress.setEditable(true);
            this.textFieldMACAddress.setText("");
            this.actionListenerSiteActive = false;
            this.comboBoxSite.setSelectedIndex(0);
            this.buildHierarchyStructure();
            this.setEmptyRfpHierarchy();
            this.actionListenerSiteActive = true;
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                this.checkBoxConferenceChannels.setSelected(false);
            }
            this.textFieldCluster.setText("1");
            this.checkBoxPreferredSync.setSelected(false);
            this.checkBoxReflectiveEnv.setSelected(false);
            this.setComboBoxPagingArea(-1);
            this.configureTabDECTElements();
            this.checkBoxWLANActive.setSelected(false);
            this.rfpDataRecords[0].setField(RfpDataRecord.IDX_WLAN_PROFILE, (Object)1);
            this.actionListenerWLANProfile = false;
            this.comboBoxWLANProfile.setEditable(true);
            this.comboBoxWLANProfile.removeAllItems();
            this.comboBoxWLANProfile.setSelectedItem("1");
            this.comboBoxWLANProfile.setEditable(false);
            this.actionListenerWLANProfile = true;
            this.rfpDataRecords[0].setField(RfpDataRecord.IDX_WLAN_ANTENNA_DIV, (Object)true);
            this.checkBoxAntennaDiversity.setSelected(true);
            this.comboBoxAntenna.setSelectedIndex(0);
            this.comboBoxChannel.setEditable(true);
            this.comboBoxChannel.setSelectedItem("1");
            this.comboBoxChannel.setEditable(false);
            this.comboBoxPower.setSelectedIndex(0);
            this.rfpDataRecords[0].setField(RfpDataRecord.IDX_HWTYPE, (Object)OmiMessage.RFPHwTypeType.UNKNOWN);
            this.actionListenerComboBoxHwType = false;
            this.comboBoxHwType.setSelectedItem(OmiMessage.RFPHwTypeType.UNKNOWN.strPreselect);
            this.comboBoxHwType.setEnabled(true);
            this.actionListenerComboBoxHwType = true;
            this.actionMode = ActionModeEnum.CREATE;
        }
        this.configureTabWLANElements();
        this.utilChangeHandler.initRootPane(this.getRootPane());
        this.utilChangeHandler.deactivate();
    }

    public DataRecord[] getRfpDetailData() {
        Object object;
        boolean bl = true;
        if (this.rfpDataRecords.length == 1) {
            if (this.textFieldName.isEnabled()) {
                this.rfpDataRecords[0].setField(RfpDataRecord.IDX_NAME, (Object)this.textFieldName.getText());
            }
            if (this.textFieldMACAddress.isEnabled()) {
                object = this.textFieldMACAddress.getText();
                if (UtilMisc.validateMACAddress((String)object)) {
                    this.rfpDataRecords[0].setField(RfpDataRecord.IDX_ETH_ADDR, object);
                } else {
                    GuiInfoConsole.showError(UtilLocale.getString("TXT_MAC_ADDRESS_FORMAT_INVALID"));
                    this.indicateWrongInput(this.textFieldMACAddress, 0);
                    bl = false;
                }
            }
        }
        object = null;
        if (!this.comboBoxSite.getSelectedItem().equals(AastraCommon.AastraTriStateText)) {
            object = ((SiteDataHandler.Site)this.comboBoxSite.getSelectedItem()).id;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        bl2 = this.comboBoxBuilding.isChange();
        String string = (String)this.comboBoxBuilding.getEditor().getItem();
        if (!string.equals(AastraCommon.AastraTriStateText)) {
            if (bl2) {
                bl3 = true;
                bl4 = true;
            }
            if (this.comboBoxFloor.isChange()) {
                bl3 = true;
                bl4 = true;
            }
            if (this.comboBoxRoom.isChange()) {
                bl4 = true;
            }
        }
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (bl2 && (string = (String)this.comboBoxBuilding.getEditor().getItem()) != null) {
            string2 = string;
        }
        if (bl3 && (string = (String)this.comboBoxFloor.getEditor().getItem()) != null) {
            string3 = string;
        }
        if (bl4 && (string = (String)this.comboBoxRoom.getEditor().getItem()) != null) {
            string4 = string;
        }
        for (int i = 0; i < this.rfpDataRecords.length; ++i) {
            if (object != null) {
                this.rfpDataRecords[i].setField(RfpDataRecord.IDX_SITE, object);
            }
            if (bl2) {
                this.rfpDataRecords[i].setField(RfpDataRecord.IDX_HIERARCHY1, (Object)string2);
            }
            if (bl3) {
                this.rfpDataRecords[i].setField(RfpDataRecord.IDX_HIERARCHY2, (Object)string3);
            }
            if (bl4) {
                this.rfpDataRecords[i].setField(RfpDataRecord.IDX_HIERARCHY3, (Object)string4);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                UtilMisc.setRecordFromTristateCheckbox(this.rfpDataRecords[i], this.checkBoxConferenceChannels, RfpDataRecord.IDX_CONFERENCE_CHANNELS);
            }
            UtilMisc.setRecordFromTristateCheckbox(this.rfpDataRecords[i], this.checkBoxPreferredSync, RfpDataRecord.IDX_PREFERRED_SYNC);
            UtilMisc.setRecordFromTristateCheckbox(this.rfpDataRecords[i], this.checkBoxReflectiveEnv, RfpDataRecord.IDX_REFLECTIVE_ENV);
            if (this.textFieldCluster.isNotTristate()) {
                int n = UtilMisc.getIntFromTextField(this.textFieldCluster, UtilLocale.getString("TXT_DECT_CLUSTER"), this.utilErrorComp, 10);
                if (n == -1) {
                    this.setErrorTab(1);
                    bl = false;
                    break;
                }
                this.rfpDataRecords[i].setField(RfpDataRecord.IDX_CLUSTER, (Object)n);
            }
            UtilMisc.setRecordFromTristateCheckbox(this.rfpDataRecords[i], this.checkBoxWLANActive, RfpDataRecord.IDX_WLAN_ON);
            if (!((Boolean)this.rfpDataRecords[i].getField(RfpDataRecord.IDX_WLAN_ANTENNA_DIV)).booleanValue()) {
                this.rfpDataRecords[i].setField(RfpDataRecord.IDX_WLAN_ANTENNA, (Object)(this.comboBoxAntenna.getSelectedIndex() + 1));
            }
            this.rfpDataRecords[i].setField(RfpDataRecord.IDX_WLAN_CHANNEL, this.comboBoxChannel.getSelectedItem());
            switch (this.comboBoxPower.getSelectedIndex()) {
                default: {
                    this.rfpDataRecords[i].setField(RfpDataRecord.IDX_WLAN_POWER, (Object)100);
                    break;
                }
                case 1: {
                    this.rfpDataRecords[i].setField(RfpDataRecord.IDX_WLAN_POWER, (Object)50);
                    break;
                }
                case 2: {
                    this.rfpDataRecords[i].setField(RfpDataRecord.IDX_WLAN_POWER, (Object)25);
                    break;
                }
                case 3: {
                    this.rfpDataRecords[i].setField(RfpDataRecord.IDX_WLAN_POWER, (Object)12);
                    break;
                }
                case 4: {
                    this.rfpDataRecords[i].setField(RfpDataRecord.IDX_WLAN_POWER, (Object)6);
                }
            }
            UtilMisc.setRecordFromTristateCheckbox(this.rfpDataRecords[i], this.checkBoxHighThroughput, RfpDataRecord.IDX_WLAN_HIGH_THROUGHPUT, true);
        }
        if (bl) {
            return this.rfpDataRecords;
        }
        return null;
    }

    private void reconfigureBuilding(boolean bl) {
        this.utilChangeHandler.activate();
        RfpTreeNode rfpTreeNode = this.nodeRootHierarchy;
        String string = null;
        RfpTreeNode rfpTreeNode2 = null;
        string = bl ? (String)this.comboBoxBuilding.getEditor().getItem() : (String)this.comboBoxBuilding.getSelectedItem();
        if (rfpTreeNode != null) {
            RfpTreeNode rfpTreeNode3 = null;
            int n = rfpTreeNode.getNumberOfChilds();
            for (int i = 0; i < n; ++i) {
                rfpTreeNode3 = rfpTreeNode.getChild(i);
                String string2 = rfpTreeNode3.getName();
                if (string2.compareTo(string) != 0) continue;
                rfpTreeNode2 = rfpTreeNode3;
                break;
            }
        }
        if (rfpTreeNode2 != null) {
            this.allowReconfigureFloor = false;
            this.comboBoxFloor.removeAllItems();
            this.addComboBoxFloorItems("", rfpTreeNode2);
            this.comboBoxFloor.setSelectedItem("");
            this.allowReconfigureFloor = true;
        } else {
            this.allowReconfigureFloor = false;
            this.comboBoxFloor.removeAllItems();
            this.allowReconfigureFloor = true;
            if (string.length() > 0) {
                this.activateComboBoxFloor();
            } else {
                this.deactivateComboBoxFloor();
                this.comboBoxBuilding.setSelectedItem("");
            }
        }
        this.comboBoxRoom.removeAllItems();
        this.comboBoxRoom.setSelectedItem("");
        this.deactivateComboBoxRoom();
    }

    private void reconfigureFloor(boolean bl) {
        this.utilChangeHandler.activate();
        RfpTreeNode rfpTreeNode = this.nodeRootHierarchy;
        RfpTreeNode rfpTreeNode2 = null;
        RfpTreeNode rfpTreeNode3 = null;
        String string = null;
        int n = 0;
        String string2 = (String)this.comboBoxBuilding.getSelectedItem();
        if (rfpTreeNode != null) {
            n = rfpTreeNode.getNumberOfChilds();
            for (int i = 0; i < n; ++i) {
                rfpTreeNode3 = rfpTreeNode.getChild(i);
                String string3 = rfpTreeNode3.getName();
                if (string3.compareTo(string2) != 0) continue;
                rfpTreeNode2 = rfpTreeNode3;
                break;
            }
        }
        string = bl ? (String)this.comboBoxFloor.getEditor().getItem() : (String)this.comboBoxFloor.getSelectedItem();
        if (rfpTreeNode2 != null) {
            RfpTreeNode rfpTreeNode4 = null;
            n = rfpTreeNode2.getNumberOfChilds();
            for (int i = 0; i < n; ++i) {
                rfpTreeNode3 = rfpTreeNode2.getChild(i);
                String string4 = rfpTreeNode3.getName();
                if (string4.compareTo(string) != 0) continue;
                rfpTreeNode4 = rfpTreeNode3;
                break;
            }
            if (rfpTreeNode4 != null) {
                this.comboBoxRoom.removeAllItems();
                this.addComboBoxRoomItems(rfpTreeNode4);
                this.comboBoxRoom.setSelectedItem("");
            } else {
                this.comboBoxRoom.removeAllItems();
                if (string.length() > 0) {
                    this.activateComboBoxRoom();
                } else {
                    this.deactivateComboBoxRoom();
                    this.comboBoxFloor.setSelectedItem("");
                }
            }
        } else {
            this.comboBoxRoom.removeAllItems();
            this.comboBoxRoom.setSelectedItem("");
            if (string != null) {
                if (string.length() > 0) {
                    this.activateComboBoxRoom();
                } else {
                    this.deactivateComboBoxRoom();
                    this.comboBoxFloor.setSelectedItem("");
                }
            } else {
                this.deactivateComboBoxRoom();
                this.comboBoxFloor.setSelectedItem("");
            }
        }
    }

    private void buildHierarchyStructure() {
        RfpTreeNode rfpTreeNode;
        if (this.comboBoxSite.getSelectedItem().equals(AastraCommon.AastraTriStateText)) {
            return;
        }
        int n = ((SiteDataHandler.Site)this.comboBoxSite.getSelectedItem()).id;
        this.nodeRootHierarchy = new RfpTreeNode(RfpTreeNode.NodeTypeEnum.NODE_ROOT_UNASSIGNED);
        RfpTreeNode rfpTreeNode2 = this.rfpTreeView.getUnassignedRfpsNode();
        if (rfpTreeNode2 != null && (rfpTreeNode = this.getNodeSite(rfpTreeNode2, n)) != null) {
            this.getBuildings(rfpTreeNode);
        }
        for (int i = 0; i < this.numberPagingArea; ++i) {
            rfpTreeNode2 = this.rfpTreeView.getPagingAreaNode(i);
            rfpTreeNode = this.getNodeSite(rfpTreeNode2, n);
            if (rfpTreeNode == null) continue;
            this.getBuildings(rfpTreeNode);
        }
    }

    private void getBuildings(RfpTreeNode rfpTreeNode) {
        int n = rfpTreeNode.getNumberOfChilds();
        for (int i = 0; i < n; ++i) {
            RfpTreeNode rfpTreeNode2 = rfpTreeNode.getChild(i);
            String string = rfpTreeNode2.getName(RfpTreeNode.NodeTypeEnum.NODE_BUILDING);
            if (string == null) continue;
            boolean bl = false;
            for (int j = 0; j < this.nodeRootHierarchy.getNumberOfChilds(); ++j) {
                if (!this.nodeRootHierarchy.getChild(j).getName().equals(string)) continue;
                this.getFloors(this.nodeRootHierarchy.getChild(j), rfpTreeNode2);
                bl = true;
                break;
            }
            if (bl) continue;
            RfpTreeNode rfpTreeNode3 = this.nodeRootHierarchy.createChild(RfpTreeNode.NodeTypeEnum.NODE_BUILDING, rfpTreeNode2.getName());
            this.getFloors(rfpTreeNode3, rfpTreeNode2);
        }
    }

    private void getFloors(RfpTreeNode rfpTreeNode, RfpTreeNode rfpTreeNode2) {
        int n = rfpTreeNode2.getNumberOfChilds();
        for (int i = 0; i < n; ++i) {
            RfpTreeNode rfpTreeNode3 = rfpTreeNode2.getChild(i);
            String string = rfpTreeNode3.getName(RfpTreeNode.NodeTypeEnum.NODE_FLOOR);
            if (string == null) continue;
            boolean bl = false;
            for (int j = 0; j < rfpTreeNode.getNumberOfChilds(); ++j) {
                if (!rfpTreeNode.getChild(j).getName().equals(string)) continue;
                this.getRooms(rfpTreeNode.getChild(j), rfpTreeNode3);
                bl = true;
                break;
            }
            if (bl) continue;
            RfpTreeNode rfpTreeNode4 = rfpTreeNode.createChild(RfpTreeNode.NodeTypeEnum.NODE_FLOOR, rfpTreeNode3.name);
            this.getRooms(rfpTreeNode4, rfpTreeNode3);
        }
    }

    private void getRooms(RfpTreeNode rfpTreeNode, RfpTreeNode rfpTreeNode2) {
        int n = rfpTreeNode2.getNumberOfChilds();
        for (int i = 0; i < n; ++i) {
            RfpTreeNode rfpTreeNode3 = rfpTreeNode2.getChild(i);
            String string = rfpTreeNode3.getName(RfpTreeNode.NodeTypeEnum.NODE_ROOM);
            if (string == null) continue;
            boolean bl = false;
            for (int j = 0; j < rfpTreeNode.getNumberOfChilds(); ++j) {
                if (!rfpTreeNode.getChild(j).getName().equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            rfpTreeNode.createChild(RfpTreeNode.NodeTypeEnum.NODE_ROOM, rfpTreeNode3.name);
        }
    }

    private void setRfpHierarchy(DataRecord[] dataRecordArray) {
        RfpTreeNode rfpTreeNode;
        this.comboBoxRoom.deactivateActionListener();
        this.allowReconfigureBuilding = false;
        this.allowReconfigureFloor = false;
        this.comboBoxBuilding.removeAllItems();
        this.comboBoxFloor.removeAllItems();
        this.deactivateComboBoxFloor();
        this.comboBoxRoom.removeAllItems();
        this.deactivateComboBoxRoom();
        String string = (String)UtilMisc.getRecordsFieldObject(dataRecordArray, RfpDataRecord.IDX_HIERARCHY1);
        RfpTreeNode rfpTreeNode2 = this.nodeRootHierarchy;
        if (rfpTreeNode2 != null && (rfpTreeNode = this.setComboBoxBuilding(string, rfpTreeNode2)) != null && string.length() > 0) {
            String string2 = (String)UtilMisc.getRecordsFieldObject(dataRecordArray, RfpDataRecord.IDX_HIERARCHY2);
            RfpTreeNode rfpTreeNode3 = this.addComboBoxFloorItems(string2, rfpTreeNode);
            this.comboBoxFloor.setDefaultItem(string2);
            if (rfpTreeNode3 != null) {
                this.addComboBoxRoomItems(rfpTreeNode3);
                String string3 = (String)UtilMisc.getRecordsFieldObject(dataRecordArray, RfpDataRecord.IDX_HIERARCHY3);
                this.comboBoxRoom.setDefaultItem(string3);
            }
        }
        this.comboBoxBuilding.setDefaultItem(string);
        this.allowReconfigureBuilding = true;
        this.allowReconfigureFloor = true;
        this.comboBoxRoom.activateActionListener();
    }

    private void setEmptyRfpHierarchy() {
        this.allowReconfigureBuilding = false;
        this.allowReconfigureFloor = false;
        this.comboBoxBuilding.removeAllItems();
        this.comboBoxFloor.removeAllItems();
        this.deactivateComboBoxFloor();
        this.comboBoxRoom.removeAllItems();
        this.deactivateComboBoxRoom();
        RfpTreeNode rfpTreeNode = null;
        RfpTreeNode rfpTreeNode2 = this.nodeRootHierarchy;
        if (rfpTreeNode2 != null) {
            int n = rfpTreeNode2.getNumberOfChilds();
            for (int i = 0; i < n; ++i) {
                rfpTreeNode = rfpTreeNode2.getChild(i);
                String string = rfpTreeNode.getName(RfpTreeNode.NodeTypeEnum.NODE_BUILDING);
                if (string == null) continue;
                this.comboBoxBuilding.addItem(string);
            }
        }
        this.comboBoxBuilding.setSelectedItem("");
        this.allowReconfigureBuilding = true;
        this.allowReconfigureFloor = true;
    }

    private RfpTreeNode setComboBoxBuilding(String string, RfpTreeNode rfpTreeNode) {
        RfpTreeNode rfpTreeNode2 = null;
        RfpTreeNode rfpTreeNode3 = null;
        int n = rfpTreeNode.getNumberOfChilds();
        for (int i = 0; i < n; ++i) {
            rfpTreeNode3 = rfpTreeNode.getChild(i);
            String string2 = rfpTreeNode3.getName(RfpTreeNode.NodeTypeEnum.NODE_BUILDING);
            if (string2 == null) continue;
            this.comboBoxBuilding.addItem(string2);
            if (string2.compareTo(string) != 0) continue;
            rfpTreeNode2 = rfpTreeNode3;
        }
        return rfpTreeNode2;
    }

    private RfpTreeNode addComboBoxFloorItems(String string, RfpTreeNode rfpTreeNode) {
        RfpTreeNode rfpTreeNode2 = null;
        RfpTreeNode rfpTreeNode3 = null;
        this.activateComboBoxFloor();
        int n = rfpTreeNode.getNumberOfChilds();
        for (int i = 0; i < n; ++i) {
            rfpTreeNode3 = rfpTreeNode.getChild(i);
            String string2 = rfpTreeNode3.getName(RfpTreeNode.NodeTypeEnum.NODE_FLOOR);
            if (string2 == null) continue;
            this.comboBoxFloor.addItem(string2);
            if (string2.compareTo(string) != 0) continue;
            rfpTreeNode2 = rfpTreeNode3;
        }
        return rfpTreeNode2;
    }

    private void addComboBoxRoomItems(RfpTreeNode rfpTreeNode) {
        RfpTreeNode rfpTreeNode2 = null;
        this.activateComboBoxRoom();
        int n = rfpTreeNode.getNumberOfChilds();
        for (int i = 0; i < n; ++i) {
            rfpTreeNode2 = rfpTreeNode.getChild(i);
            String string = rfpTreeNode2.getName(RfpTreeNode.NodeTypeEnum.NODE_ROOM);
            if (string == null) continue;
            this.comboBoxRoom.addItem(string);
        }
    }

    private RfpTreeNode getNodeSite(RfpTreeNode rfpTreeNode, int n) {
        int n2 = rfpTreeNode.getNumberOfChilds();
        for (int i = 0; i < n2; ++i) {
            RfpTreeNode rfpTreeNode2 = rfpTreeNode.getChild(i);
            String string = rfpTreeNode2.getName();
            int n3 = Integer.valueOf(string.substring(0, string.indexOf(" ")));
            if (n != n3) continue;
            return rfpTreeNode2;
        }
        return null;
    }

    private void activateComboBoxFloor() {
        this.comboBoxFloor.setEnabled(true);
        this.comboBoxFloor.setEditable(true);
    }

    private void deactivateComboBoxFloor() {
        this.comboBoxFloor.setEnabled(false);
        this.comboBoxFloor.setEditable(false);
    }

    private void activateComboBoxRoom() {
        this.comboBoxRoom.setEnabled(true);
        this.comboBoxRoom.setEditable(true);
    }

    private void deactivateComboBoxRoom() {
        this.comboBoxRoom.setEnabled(false);
        this.comboBoxRoom.setEditable(false);
    }

    private void configureComboBoxPagingArea() {
        int n = 0;
        String string = null;
        this.actionListenerPAActive = false;
        try {
            string = (String)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.PARK);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PARK.toString() + "='" + string + "'");
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PARK.toString() + " failed");
            string = null;
        }
        if (string != null && string.length() == 10) {
            this.parkLengthIdentifier = Integer.parseInt(string.substring(0, 2), 16);
        }
        try {
            this.pagingAreaSize = (Integer)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.PagingAreaSize);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PagingAreaSize.toString() + "=" + this.pagingAreaSize);
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PagingAreaSize.toString() + " failed");
            this.pagingAreaSize = 0;
        }
        if (this.parkLengthIdentifier != 0) {
            n = 1 << 39 - this.parkLengthIdentifier;
        }
        this.numberPagingArea = this.pagingAreaSize > 0 ? n / this.pagingAreaSize : 0;
        this.comboBoxPagingArea.removeAllItems();
        this.comboBoxPagingArea.addItem(UtilLocale.getString("TXT_UNASSIGNED"));
        if (this.numberPagingArea == 0) {
            this.comboBoxPagingArea.setEnabled(false);
        } else {
            this.comboBoxPagingArea.setEnabled(true);
            for (int i = 0; i < this.numberPagingArea; ++i) {
                this.comboBoxPagingArea.addItem("" + i);
            }
        }
        this.actionListenerPAActive = true;
    }

    private void setComboBoxPagingArea(int n) {
        this.actionListenerPAActive = false;
        int n2 = this.comboBoxPagingArea.getItemCount();
        if (n == -2) {
            this.comboBoxPagingArea.setEditable(true);
            this.comboBoxPagingArea.setSelectedItem(AastraCommon.AastraTriStateText);
            this.comboBoxPagingArea.setEditable(false);
        } else if (n == -1) {
            if (n2 > 0) {
                this.comboBoxPagingArea.setSelectedIndex(0);
                this.comboBoxPagingArea.setDefaultItem(0);
            }
        } else if (n2 > n + 1) {
            this.comboBoxPagingArea.setSelectedIndex(n + 1);
            this.comboBoxPagingArea.setDefaultItem(n + 1);
        } else {
            this.comboBoxPagingArea.setSelectedIndex(-1);
            this.comboBoxPagingArea.setDefaultItem(null);
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Setting comboBoxPagingArea failed");
        }
        this.actionListenerPAActive = true;
    }

    public void markErrorComponent(String string) {
        JComponent jComponent = this.utilErrorComp.getField(string);
        if (jComponent != null) {
            this.panelTabbed.setSelectedIndex(this.utilErrorComp.getTab(string));
            this.utilErrorComp.markComponent(jComponent);
        }
    }

    public String getErrorLabelText(String string) {
        if (string == null) {
            return null;
        }
        return this.utilErrorComp.getLabelText(string);
    }

    private void indicateWrongInput(JComponent jComponent, int n) {
        if (jComponent != null) {
            this.utilErrorComp.markComponent(jComponent);
            if (this.errorTab == -1) {
                this.errorTab = n;
            }
        }
    }

    private void setErrorTab(int n) {
        if (this.errorTab == -1) {
            this.errorTab = n;
        }
    }

    private void activateErrorTab() {
        if (this.errorTab != -1) {
            this.panelTabbed.setSelectedIndex(this.errorTab);
            this.errorTab = -1;
        }
    }

    public void requestDefaultFocusInWindow() {
        this.textFieldName.requestFocusInWindow();
    }

    public int getSelectedRfp() {
        return this.selectedRfp;
    }

    private boolean isDECTRegDomainSet() {
        OmiMessage.DECTRegDomainType dECTRegDomainType = null;
        try {
            dECTRegDomainType = (OmiMessage.DECTRegDomainType)((Object)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.DECTRegDomain));
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTRegDomain.toString() + "=" + (Object)((Object)dECTRegDomainType));
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTRegDomain.toString() + " failed");
            return false;
        }
        return dECTRegDomainType != OmiMessage.DECTRegDomainType.None;
    }

    private boolean isPARKset() {
        try {
            String string = (String)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.PARK);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PARK.toString() + "= '" + string + "'");
            if (string.length() == 0) {
                return false;
            }
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PARK.toString() + " failed");
            return false;
        }
        return true;
    }

    private void getComboBoxPagingAreaValue() {
        if (this.comboBoxPagingArea.isChange() && this.comboBoxPagingArea.getSelectedItem() != null && ((String)this.comboBoxPagingArea.getSelectedItem()).length() > 0) {
            int n = this.comboBoxPagingArea.getSelectedIndex();
            for (int i = 0; i < this.rfpDataRecords.length; ++i) {
                if (n == 0) {
                    this.rfpDataRecords[i].setField(RfpDataRecord.IDX_PAGING_AREA, (Object)-1);
                    RfpConfigMainPanel.setDectInfoHierarchy4(this.rfpDataRecords[i]);
                    continue;
                }
                this.rfpDataRecords[i].setField(RfpDataRecord.IDX_PAGING_AREA, (Object)(n - 1));
                RfpConfigMainPanel.resetDectInfoHierarchy4(this.rfpDataRecords[i]);
            }
            this.configureTabDECTElements();
        }
    }

    private boolean updateCheckBoxConferenceChannels() {
        boolean bl = true;
        if (this.tabGeneral != null) {
            if (this.rfpDataRecords != null) {
                OmiMessage.RFPHwTypeType rFPHwTypeType;
                for (int i = 0; i < this.rfpDataRecords.length && (rFPHwTypeType = (OmiMessage.RFPHwTypeType)((Object)this.rfpDataRecords[i].getField(RfpDataRecord.IDX_HWTYPE))) != null; ++i) {
                    String string = rFPHwTypeType.strPreselect;
                    if (string.equals(OmiMessage.RFPHwTypeType.RFP35.strPreselect) || string.equals(OmiMessage.RFPHwTypeType.RFP43.strPreselect)) continue;
                    bl = false;
                    break;
                }
            }
            this.checkBoxConferenceChannels.setSelected(bl);
            this.checkBoxConferenceChannels.setEnabled(bl);
        }
        return bl;
    }

    private void configureTabDECTElements() {
        if (this.tabDECT != null) {
            boolean bl = true;
            if (this.isDECTRegDomainSet() && this.isPARKset()) {
                this.textFieldCluster.setEnabled(true);
                this.comboBoxPagingArea.setEnabled(true);
                this.checkBoxPreferredSync.setEnabled(true);
                this.checkBoxReflectiveEnv.setEnabled(true);
                this.labelDECTActiveInfo.setVisible(false);
                if (this.rfpDataRecords != null) {
                    for (int i = 0; i < this.rfpDataRecords.length; ++i) {
                        if ((Integer)this.rfpDataRecords[i].getField(RfpDataRecord.IDX_PAGING_AREA) != -1) continue;
                        bl = false;
                        break;
                    }
                }
                this.actionListenerDECTOnActive = false;
                if (bl) {
                    this.checkBoxDECTActive.setEnabled(true);
                    this.checkBoxDECTActive.setState(UtilMisc.getRecordsFieldState(this.rfpDataRecords, RfpDataRecord.IDX_DECT_ON));
                } else {
                    this.checkBoxDECTActive.setSelected(false);
                    this.checkBoxDECTActive.setEnabled(false);
                }
                this.actionListenerDECTOnActive = true;
            } else {
                this.checkBoxDECTActive.setEnabled(false);
                this.textFieldCluster.setEnabled(false);
                this.comboBoxPagingArea.setEnabled(false);
                this.checkBoxPreferredSync.setEnabled(false);
                this.checkBoxReflectiveEnv.setEnabled(false);
                this.labelDECTActiveInfo.setVisible(true);
            }
        }
    }

    private void configureTabWLANElements() {
        CommonDataHandler.WLANRegDomainElem wLANRegDomainElem = null;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        if (this.tabWLAN != null) {
            try {
                wLANRegDomainElem = (CommonDataHandler.WLANRegDomainElem)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.WLANRegDomain);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.WLANRegDomain.toString() + "=" + wLANRegDomainElem);
            }
            catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.WLANRegDomain.toString() + " failed");
                wLANRegDomainElem = new CommonDataHandler.WLANRegDomainElem();
                wLANRegDomainElem.domain = OmiMessage.WlanRegDomainInvalidType.None.axi;
            }
            if (this.rfpDataRecords != null) {
                for (int i = 0; i < this.rfpDataRecords.length; ++i) {
                    OmiMessage.RFPHwTypeType rFPHwTypeType = (OmiMessage.RFPHwTypeType)((Object)this.rfpDataRecords[i].getField(RfpDataRecord.IDX_HWTYPE));
                    boolean bl6 = (Boolean)this.rfpDataRecords[i].getField(RfpDataRecord.IDX_WLAN_ANTENNA_DIV);
                    int n = (Integer)this.rfpDataRecords[i].getField(RfpDataRecord.IDX_WLAN_PROFILE);
                    WLANProfileHandler.WLANProfile wLANProfile = this.wlanProfileDatabase.getRecordById(n);
                    if (wLANProfile != null && wLANProfile.mode != OmiMessage.WLANModeType.N) {
                        bl5 = false;
                    }
                    if (bl6) {
                        bl4 = false;
                    }
                    if (rFPHwTypeType == null) {
                        bl = false;
                        break;
                    }
                    String string = rFPHwTypeType.strPreselect;
                    if (string.equals(OmiMessage.RFPHwTypeType.UNKNOWN.strPreselect) || string.equals(OmiMessage.RFPHwTypeType.RFP31.strPreselect) || string.equals(OmiMessage.RFPHwTypeType.RFP35.strPreselect)) {
                        bl = false;
                        break;
                    }
                    if (string.equals(OmiMessage.RFPHwTypeType.RFP43.strPreselect) || string.equals(OmiMessage.RFPHwTypeType.RFPL43.strPreselect)) {
                        bl2 = false;
                        continue;
                    }
                    bl3 = false;
                }
            } else {
                bl = false;
            }
            if (OmiMessage.WlanRegDomainInvalidType.isInvalidDomain(wLANRegDomainElem.domain)) {
                bl = false;
                this.labelWLANActiveInfo.setVisible(true);
            } else {
                this.labelWLANActiveInfo.setVisible(false);
            }
            if (this.comboBoxWLANProfile.getItemCount() == 0) {
                bl = false;
            }
            this.checkBoxWLANActive.setEnabled(bl);
            this.comboBoxWLANProfile.setEnabled(bl);
            this.checkBoxAntennaDiversity.setEnabled(bl & bl2);
            this.comboBoxAntenna.setEnabled(bl & bl2 & bl4);
            this.comboBoxChannel.setEnabled(bl);
            this.comboBoxPower.setEnabled(bl);
            this.checkBoxHighThroughput.setEnabled(bl & bl3 & bl5);
        }
    }

    public void updateComboBoxWLANProfile() {
        String string = UtilMisc.getRecordsFieldObject(this.rfpDataRecords, RfpDataRecord.IDX_HWTYPE).toString();
        this.actionListenerWLANProfile = false;
        this.comboBoxWLANProfile.removeAllItems();
        if (!string.equals(AastraCommon.AastraTriStateText)) {
            int n = this.wlanProfileDatabase.getRecordNumber();
            String string2 = OmiMessage.RFPHwTypeType.valueOf((String)string).strPreselect;
            for (int i = 0; i < n; ++i) {
                WLANProfileHandler.WLANProfile wLANProfile = (WLANProfileHandler.WLANProfile)this.wlanProfileDatabase.getRecordByIdx(i);
                if (wLANProfile.profileType == OmiMessage.WLANProfileRFPType.RFP42 && (string2.equals(OmiMessage.RFPHwTypeType.RFP42.strPreselect) || string2.equals(OmiMessage.RFPHwTypeType.RFPL42.strPreselect))) {
                    this.comboBoxWLANProfile.addItem(wLANProfile.id);
                }
                if (wLANProfile.profileType != OmiMessage.WLANProfileRFPType.RFP43 || !string2.equals(OmiMessage.RFPHwTypeType.RFP43.strPreselect)) continue;
                this.comboBoxWLANProfile.addItem(wLANProfile.id);
            }
        } else {
            this.comboBoxWLANProfile.addItem(AastraCommon.AastraTriStateText);
        }
        this.actionListenerWLANProfile = true;
    }

    private void updateCheckBoxWLANHighThroughput() {
        WLANProfileHandler.WLANProfile wLANProfile;
        Integer n = (Integer)this.rfpDataRecords[0].getField(RfpDataRecord.IDX_WLAN_PROFILE);
        if (n > 0 && (wLANProfile = this.wlanProfileDatabase.getRecordById(n)) != null) {
            this.actionListenerHighThroughput = false;
            if (wLANProfile.mode == OmiMessage.WLANModeType.N) {
                this.checkBoxHighThroughput.setState(UtilMisc.getRecordsFieldState(this.rfpDataRecords, RfpDataRecord.IDX_WLAN_HIGH_THROUGHPUT));
            } else {
                this.checkBoxHighThroughput.setSelected(false);
            }
            this.actionListenerHighThroughput = true;
        }
    }

    private void updateComboBoxChannel() {
        CommonDataHandler.WLANRegDomainElem wLANRegDomainElem = null;
        try {
            wLANRegDomainElem = (CommonDataHandler.WLANRegDomainElem)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.WLANRegDomain);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.WLANRegDomain.toString() + "=" + wLANRegDomainElem);
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.WLANRegDomain.toString() + " failed");
            wLANRegDomainElem = new CommonDataHandler.WLANRegDomainElem(OmiMessage.WlanRegDomainInvalidType.None.axi);
        }
        if (!OmiMessage.WlanRegDomainInvalidType.isInvalidDomain(wLANRegDomainElem.domain)) {
            WLANProfileHandler.WLANProfile wLANProfile;
            Integer n = (Integer)UtilMisc.getRecordsFieldObject(this.rfpDataRecords, RfpDataRecord.IDX_WLAN_PROFILE);
            Object object = this.comboBoxChannel.getSelectedItem();
            this.comboBoxChannel.removeAllItems();
            if (n > 0 && (wLANProfile = this.wlanProfileDatabase.getRecordById(n)) != null) {
                int n2;
                for (n2 = 0; n2 < wLANRegDomainElem.channels2_4G.length; ++n2) {
                    this.comboBoxChannel.addItem(Integer.toString(wLANRegDomainElem.channels2_4G[n2]));
                }
                if (wLANProfile.mode == OmiMessage.WLANModeType.ABG || wLANProfile.mode == OmiMessage.WLANModeType.N) {
                    for (n2 = 0; n2 < wLANRegDomainElem.channels5G.length; ++n2) {
                        this.comboBoxChannel.addItem(Integer.toString(wLANRegDomainElem.channels5G[n2]));
                    }
                }
            }
            this.comboBoxChannel.setEditable(true);
            this.comboBoxChannel.setSelectedItem(object);
            this.comboBoxChannel.setEditable(false);
        }
    }

    @Override
    protected AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            super.getButtonOK();
            this.buttonOK.setBounds(70, 15, 90, 25);
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpConfigDetailPanel.this.utilChangeHandler.deactivate();
                    RfpConfigDetailPanel.this.utilErrorComp.clearComponents();
                    if (RfpConfigDetailPanel.this.actionMode == ActionModeEnum.CHANGE) {
                        if (!RfpConfigDetailPanel.this.rfpMainPanel.changeRfp()) {
                            RfpConfigDetailPanel.this.activateErrorTab();
                        }
                    } else if (!RfpConfigDetailPanel.this.rfpMainPanel.createRfp()) {
                        RfpConfigDetailPanel.this.activateErrorTab();
                    }
                }
            });
        }
        return this.buttonOK;
    }

    @Override
    protected AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            super.getButtonCancel();
            this.buttonCancel.setBounds(230, 15, 90, 25);
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpConfigDetailPanel.this.utilChangeHandler.deactivate();
                    RfpConfigDetailPanel.this.rfpMainPanel.removeRfpDetailPanel();
                }
            });
        }
        return this.buttonCancel;
    }

    @Override
    protected AastraPanel getTabDECT() {
        if (this.tabDECT == null) {
            super.getTabDECT();
            this.labelDECTActiveInfo = new AastraLabel();
            this.labelDECTActiveInfo.setBounds(300, 30, 320, 48);
            this.labelDECTActiveInfo.setText("<html>" + UtilLocale.getString("TXT_INFO_NO_PARK_AND_DECT_REGULATORY_DOMAIN") + "</html>");
            this.labelDECTActiveInfo.setIcon(GuiUtilIcon.getIconInfo(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
            this.tabDECT.add((Component)this.getComboBoxPagingArea(), null);
            this.tabDECT.add(this.labelDECTActiveInfo);
            this.utilErrorComp.putWithTab(OmiMessage.RFPType.cluster.toString(), this.labelCluster, this.textFieldCluster, 1);
            this.utilErrorComp.putWithTab(OmiMessage.RFPType.pagingArea.toString(), this.labelPagingArea, this.comboBoxPagingArea, 1);
            this.utilErrorComp.putWithTab(OmiMessage.RFPType.reflectiveEnv.toString(), this.labelReflectiveEnv, this.checkBoxReflectiveEnv, 1);
        }
        return this.tabDECT;
    }

    @Override
    protected GuiUtilComboBox getComboBoxPagingArea() {
        if (this.comboBoxPagingArea == null) {
            super.getComboBoxPagingArea();
            this.comboBoxPagingArea.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (RfpConfigDetailPanel.this.actionListenerPAActive) {
                        RfpConfigDetailPanel.this.getComboBoxPagingAreaValue();
                        RfpConfigDetailPanel.this.utilChangeHandler.activate();
                    }
                }
            });
            this.actionListenerPAActive = true;
            this.configureComboBoxPagingArea();
        }
        return this.comboBoxPagingArea;
    }

    @Override
    protected AastraPanel getTabWLAN() {
        if (this.tabWLAN == null) {
            super.getTabWLAN();
            this.labelWLANActiveInfo = new AastraLabel();
            this.labelWLANActiveInfo.setBounds(300, 30, 330, 32);
            this.labelWLANActiveInfo.setText("<html>" + UtilLocale.getString("TXT_INFO_NO_WLAN_REGULATORY_DOMAIN") + "</html>");
            this.labelWLANActiveInfo.setIcon(GuiUtilIcon.getIconInfo(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
            this.tabWLAN.add(this.labelWLANActiveInfo);
            this.utilErrorComp.putWithTab(OmiMessage.RFPType.wlanProfile.toString(), this.labelWLANProfile, this.comboBoxWLANProfile, 2);
            this.utilErrorComp.putWithTab(OmiMessage.RFPType.wlanChannel.toString(), this.labelChannel, this.comboBoxChannel, 2);
            this.utilErrorComp.putWithTab(OmiMessage.RFPType.wlanHighThroughput.toString(), this.labelHighThroughput, this.checkBoxHighThroughput, 2);
        }
        return this.tabWLAN;
    }

    @Override
    protected GuiUtilComboBox getComboBoxProfile() {
        if (this.comboBoxWLANProfile == null) {
            super.getComboBoxProfile();
            this.comboBoxWLANProfile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (RfpConfigDetailPanel.this.actionListenerWLANProfile) {
                        RfpConfigDetailPanel.this.utilChangeHandler.activate();
                        String string = RfpConfigDetailPanel.this.comboBoxWLANProfile.getSelectedItem().toString();
                        for (int i = 0; i < RfpConfigDetailPanel.this.rfpDataRecords.length; ++i) {
                            if (string.isEmpty()) {
                                RfpConfigDetailPanel.this.rfpDataRecords[i].setField(RfpDataRecord.IDX_WLAN_PROFILE, (Object)0);
                                continue;
                            }
                            try {
                                RfpConfigDetailPanel.this.rfpDataRecords[i].setField(RfpDataRecord.IDX_WLAN_PROFILE, (Object)Integer.valueOf(string));
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                return;
                            }
                        }
                        RfpConfigDetailPanel.this.updateComboBoxChannel();
                        RfpConfigDetailPanel.this.updateCheckBoxWLANHighThroughput();
                        RfpConfigDetailPanel.this.configureTabWLANElements();
                    }
                }
            });
            this.actionListenerWLANProfile = true;
        }
        return this.comboBoxWLANProfile;
    }

    @Override
    protected GuiUtilTristateCheckBox getCheckBoxAntennaDiversity() {
        if (this.checkBoxAntennaDiversity == null) {
            super.getCheckBoxAntennaDiversity();
            this.checkBoxAntennaDiversity.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (RfpConfigDetailPanel.this.actionListenerAntennaDiversityActive) {
                        RfpConfigDetailPanel.this.utilChangeHandler.activate();
                        for (int i = 0; i < RfpConfigDetailPanel.this.rfpDataRecords.length; ++i) {
                            UtilMisc.setRecordFromTristateCheckbox(RfpConfigDetailPanel.this.rfpDataRecords[i], RfpConfigDetailPanel.this.checkBoxAntennaDiversity, RfpDataRecord.IDX_WLAN_ANTENNA_DIV);
                        }
                        RfpConfigDetailPanel.this.comboBoxAntenna.setEnabled(!RfpConfigDetailPanel.this.checkBoxAntennaDiversity.isSelected());
                    }
                }
            });
            this.actionListenerAntennaDiversityActive = true;
        }
        return this.checkBoxAntennaDiversity;
    }

    @Override
    protected GuiUtilComboBox getComboBoxAntenna() {
        if (this.comboBoxAntenna == null) {
            super.getComboBoxAntenna();
            this.comboBoxAntenna.activateActionListener();
        }
        return this.comboBoxAntenna;
    }

    @Override
    protected GuiUtilComboBox getComboBoxChannel() {
        if (this.comboBoxChannel == null) {
            super.getComboBoxChannel();
            this.comboBoxChannel.activateActionListener();
        }
        return this.comboBoxChannel;
    }

    @Override
    protected GuiUtilComboBox getComboBoxPower() {
        if (this.comboBoxPower == null) {
            super.getComboBoxPower();
            this.comboBoxPower.activateActionListener();
        }
        return this.comboBoxPower;
    }

    @Override
    protected GuiUtilTristateCheckBox getCheckBoxHighThroughput() {
        if (this.checkBoxHighThroughput == null) {
            super.getCheckBoxHighThroughput();
            this.checkBoxHighThroughput.setEnabled(false);
            this.checkBoxHighThroughput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (RfpConfigDetailPanel.this.actionListenerHighThroughput) {
                        RfpConfigDetailPanel.this.utilChangeHandler.activate();
                        for (int i = 0; i < RfpConfigDetailPanel.this.rfpDataRecords.length; ++i) {
                            UtilMisc.setRecordFromTristateCheckbox(RfpConfigDetailPanel.this.rfpDataRecords[i], RfpConfigDetailPanel.this.checkBoxHighThroughput, RfpDataRecord.IDX_WLAN_HIGH_THROUGHPUT);
                        }
                    }
                }
            });
            this.actionListenerHighThroughput = true;
        }
        return this.checkBoxHighThroughput;
    }

    @Override
    protected AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            super.getTabGeneral();
            this.utilErrorComp.putWithTab(OmiMessage.RFPType.name.toString(), this.labelName, this.textFieldName, 0);
            this.utilErrorComp.putWithTab(OmiMessage.RFPType.ethAddr.toString(), this.labelMACAddress, this.textFieldMACAddress, 0);
            this.utilErrorComp.putWithTab(OmiMessage.RFPType.hierarchy1.toString(), this.labelBuilding, this.comboBoxBuilding, 0);
            this.utilErrorComp.putWithTab(OmiMessage.RFPType.hierarchy2.toString(), this.labelFloor, this.comboBoxFloor, 0);
            this.utilErrorComp.putWithTab(OmiMessage.RFPType.hierarchy3.toString(), this.labelRoom, this.comboBoxRoom, 0);
        }
        return this.tabGeneral;
    }

    @Override
    protected GuiUtilComboBox getComboBoxSite() {
        if (this.comboBoxSite == null) {
            super.getComboBoxSite();
            int n = this.siteDataHandler.getNumberOfSites();
            for (int i = 0; i < n; ++i) {
                this.comboBoxSite.addItem(this.siteDataHandler.getSiteByTableIdx(i));
            }
            this.comboBoxSite.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (RfpConfigDetailPanel.this.actionListenerSiteActive) {
                        RfpConfigDetailPanel.this.buildHierarchyStructure();
                        RfpConfigDetailPanel.this.setEmptyRfpHierarchy();
                        RfpConfigDetailPanel.this.utilChangeHandler.activate();
                    }
                }
            });
            this.actionListenerSiteActive = false;
        }
        return this.comboBoxSite;
    }

    @Override
    protected GuiUtilComboBox getComboBoxBuilding() {
        if (this.comboBoxBuilding == null) {
            super.getComboBoxBuilding();
            this.comboBoxBuilding.setEditable(true);
            this.comboBoxBuilding.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (RfpConfigDetailPanel.this.allowReconfigureBuilding) {
                        RfpConfigDetailPanel.this.reconfigureBuilding(false);
                    }
                }
            });
            this.comboBoxBuilding.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    RfpConfigDetailPanel.this.reconfigureBuilding(true);
                }
            });
        }
        return this.comboBoxBuilding;
    }

    @Override
    protected GuiUtilComboBox getComboBoxFloor() {
        if (this.comboBoxFloor == null) {
            super.getComboBoxFloor();
            this.comboBoxFloor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (RfpConfigDetailPanel.this.allowReconfigureFloor) {
                        RfpConfigDetailPanel.this.reconfigureFloor(false);
                    }
                }
            });
            this.comboBoxFloor.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    RfpConfigDetailPanel.this.reconfigureFloor(true);
                }
            });
        }
        return this.comboBoxFloor;
    }

    @Override
    protected GuiUtilComboBox getComboBoxRoom() {
        if (this.comboBoxRoom == null) {
            super.getComboBoxRoom();
            this.comboBoxRoom.activateActionListener();
            this.comboBoxRoom.activateEditorKeyListener();
        }
        return this.comboBoxRoom;
    }

    @Override
    protected GuiUtilTristateCheckBox getCheckBoxDECTActive() {
        if (this.checkBoxDECTActive == null) {
            super.getCheckBoxDECTActive();
            this.checkBoxDECTActive.setEnabled(false);
            this.checkBoxDECTActive.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (RfpConfigDetailPanel.this.actionListenerDECTOnActive) {
                        RfpConfigDetailPanel.this.utilChangeHandler.activate();
                        for (int i = 0; i < RfpConfigDetailPanel.this.rfpDataRecords.length; ++i) {
                            UtilMisc.setRecordFromTristateCheckbox(RfpConfigDetailPanel.this.rfpDataRecords[i], RfpConfigDetailPanel.this.checkBoxDECTActive, RfpDataRecord.IDX_DECT_ON);
                        }
                    }
                }
            });
            this.actionListenerDECTOnActive = true;
        }
        return this.checkBoxDECTActive;
    }

    @Override
    protected GuiUtilComboBox getComboBoxHwType() {
        if (this.comboBoxHwType == null) {
            super.getComboBoxHwType();
            this.comboBoxHwType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (RfpConfigDetailPanel.this.actionListenerComboBoxHwType) {
                        RfpConfigDetailPanel.this.utilChangeHandler.activate();
                        OmiMessage.RFPHwTypeType rFPHwTypeType = OmiMessage.RFPHwTypeType.getTypeFromStrPreselect(RfpConfigDetailPanel.this.comboBoxHwType.getSelectedItem().toString());
                        for (int i = 0; i < RfpConfigDetailPanel.this.rfpDataRecords.length; ++i) {
                            RfpConfigDetailPanel.this.rfpDataRecords[i].setField(RfpDataRecord.IDX_HWTYPE, (Object)rFPHwTypeType);
                        }
                        RfpConfigDetailPanel.this.updateComboBoxWLANProfile();
                        RfpConfigDetailPanel.this.configureTabWLANElements();
                    }
                }
            });
            this.actionListenerComboBoxHwType = true;
        }
        return this.comboBoxHwType;
    }

    @Override
    public void processSiteDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (dataNotificationEnum != DataNotificationEnum.DATA_SITE_CHANGED_OTHER) {
            this.actionListenerSiteActive = false;
            this.comboBoxSite.removeAllItems();
            int n2 = this.siteDataHandler.getNumberOfSites();
            for (int i = 0; i < n2; ++i) {
                this.comboBoxSite.addItem(this.siteDataHandler.getSiteByTableIdx(i));
            }
            this.actionListenerSiteActive = true;
        }
    }

    @Override
    public void processSiteDataErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
    }

    @Override
    public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
    }

    @Override
    public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
        switch (commonDataItemEnum) {
            case PARK: 
            case PagingAreaSize: {
                this.configureComboBoxPagingArea();
                break;
            }
            case DECTRegDomain: {
                this.configureTabDECTElements();
                break;
            }
            case WLANRegDomain: {
                this.updateComboBoxChannel();
                break;
            }
        }
    }

    private static enum ActionModeEnum {
        CREATE,
        CHANGE;

    }
}

