/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilTableConfigDlgDefault;
import com.aastra.oamp.guiutil.GuiUtilTableFilterDlg;
import com.aastra.oamp.guiutil.GuiUtilTaskPanel;
import com.aastra.oamp.rfp.RfpConfigMainPanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.style.AastraLinkButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class RfpConfigTaskPanel
extends GuiUtilTaskPanel {
    private static final long serialVersionUID = 1L;
    private RfpConfigMainPanel rfpMainPanel = null;
    private ConfiguratorTable rfpTable = null;
    private AastraLinkButton buttonConfigureRfpTable = null;
    private AastraLinkButton buttonConfigureRfp = null;
    private AastraLinkButton buttonCreateRfp = null;
    private AastraLinkButton buttonDeleteRfp = null;
    private AastraLinkButton buttonFilterRfpTable = null;
    private GuiUtilTableFilterDlg rfpTableFilterDlg = null;

    public RfpConfigTaskPanel(RfpConfigMainPanel rfpConfigMainPanel, ConfiguratorTable configuratorTable) {
        this.rfpMainPanel = rfpConfigMainPanel;
        this.rfpTable = configuratorTable;
        this.initialize();
    }

    private void initialize() {
        this.add((Component)this.getButtonCreateRfp(), null);
        this.add((Component)this.getButtonConfigureRfp(), null);
        this.add((Component)this.getButtonDeleteRfp(), null);
        this.add((Component)this.getButtonFilterRfpTable(), null);
        this.add((Component)this.getButtonConfigureRfpTable(), null);
    }

    private AastraLinkButton getButtonCreateRfp() {
        if (this.buttonCreateRfp == null) {
            this.buttonCreateRfp = this.createTaskButtonDisabled(UtilLocale.getString("TXT_CREATE_20"));
            this.buttonCreateRfp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpConfigTaskPanel.this.rfpMainPanel.startRfpCreation();
                }
            });
        }
        return this.buttonCreateRfp;
    }

    private AastraLinkButton getButtonConfigureRfp() {
        if (this.buttonConfigureRfp == null) {
            this.buttonConfigureRfp = this.createTaskButtonDisabled(UtilLocale.getString("TXT_CONFIGURE_20"));
            this.buttonConfigureRfp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpConfigTaskPanel.this.rfpMainPanel.configureRfp();
                }
            });
        }
        return this.buttonConfigureRfp;
    }

    private AastraLinkButton getButtonDeleteRfp() {
        if (this.buttonDeleteRfp == null) {
            this.buttonDeleteRfp = this.createTaskButtonDisabled(UtilLocale.getString("TXT_DELETE_20"), UtilLocale.getString("TXT_DELETE_SELECTED_RFPS"));
            this.buttonDeleteRfp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpConfigTaskPanel.this.rfpMainPanel.deleteRfp();
                }
            });
        }
        return this.buttonDeleteRfp;
    }

    private AastraLinkButton getButtonFilterRfpTable() {
        if (this.buttonFilterRfpTable == null) {
            this.buttonFilterRfpTable = this.createTaskButtonDisabled(UtilLocale.getString("TXT_FILTER_20"), GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            this.buttonFilterRfpTable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpConfigTaskPanel.this.getRfpTableFilterDlg().setVisible(true);
                    RfpConfigTaskPanel.this.rfpMainPanel.configureTableFilter();
                }
            });
        }
        return this.buttonFilterRfpTable;
    }

    private AastraLinkButton getButtonConfigureRfpTable() {
        if (this.buttonConfigureRfpTable == null) {
            this.buttonConfigureRfpTable = this.createTaskButtonDisabled(UtilLocale.getString("TXT_SELECT_COLUMNS_20"));
            this.buttonConfigureRfpTable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiUtilTableConfigDlgDefault guiUtilTableConfigDlgDefault = new GuiUtilTableConfigDlgDefault(RfpConfigTaskPanel.this.rfpTable, RfpConfigTaskPanel.this.rfpMainPanel.getTableColumnsSelection(), UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpConfig);
                    guiUtilTableConfigDlgDefault.setVisible(true);
                }
            });
        }
        return this.buttonConfigureRfpTable;
    }

    public void setTaskButtonCreate(boolean bl) {
        this.buttonCreateRfp.setEnabled(bl);
    }

    public void setTaskButtonConfigure(boolean bl) {
        this.buttonConfigureRfp.setEnabled(bl);
    }

    public void setTaskButtonDelete(boolean bl) {
        this.buttonDeleteRfp.setEnabled(bl);
    }

    public void setTaskButtonConfigureTable(boolean bl) {
        this.buttonConfigureRfpTable.setEnabled(bl);
    }

    public void setTaskButtonFilter(boolean bl) {
        this.buttonFilterRfpTable.setEnabled(bl);
    }

    public void setTaskButtonFilterState(Boolean bl, String string) {
        if (bl != null) {
            if (bl.booleanValue()) {
                this.buttonFilterRfpTable.setIcon(GuiUtilIcon.getIconActive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            } else {
                this.buttonFilterRfpTable.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            }
        }
        this.buttonFilterRfpTable.setToolTipText(string);
    }

    private GuiUtilTableFilterDlg getRfpTableFilterDlg() {
        if (this.rfpTableFilterDlg == null) {
            this.rfpTableFilterDlg = new GuiUtilTableFilterDlg(this.rfpTable, UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesRfpConfig);
        }
        return this.rfpTableFilterDlg;
    }
}

