/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.guiutil.GuiUtilDetailPanel;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.rfp.RfpImportPanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.RfpDataRecord;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraTextField;
import com.aastra.util.UtilSpy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class RfpImportDetailPanel
extends GuiUtilDetailPanel {
    private static final long serialVersionUID = 1L;
    private RfpImportPanel rfpImportPanel = null;
    private AastraPanel panelStatus = null;
    private AastraButton buttonCancel = null;
    private AastraLabel labelStatus = null;
    private AastraTextField textFieldStatus = null;
    private AastraLabel labelStatusIcon = null;
    private AastraLabel labelError = null;
    private AastraTextField textFieldError = null;

    public RfpImportDetailPanel(RfpImportPanel rfpImportPanel) {
        super(285, 0);
        this.rfpImportPanel = rfpImportPanel;
        this.initialize();
    }

    private void initialize() {
        this.panelTabbed.addTab(UtilLocale.getString("TXT_STATUS"), this.getPanelStatus());
        this.panelButtonBar.add(this.getButtonCancel());
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            this.buttonCancel.setBounds(120, 15, 90, 25);
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (RfpImportDetailPanel.this.rfpImportPanel != null) {
                        RfpImportDetailPanel.this.rfpImportPanel.removeRfpStatusPanel();
                    }
                }
            });
        }
        return this.buttonCancel;
    }

    private AastraPanel getPanelStatus() {
        if (this.panelStatus == null) {
            this.panelStatus = new AastraPanel();
            this.panelStatus.setLayout(null);
            this.labelStatus = new AastraLabel();
            this.labelStatus.setBounds(15, 15, 125, 16);
            this.labelStatus.setText(UtilLocale.getString("TXT_ENROLMENT_STATUS"));
            this.labelStatusIcon = new AastraLabel();
            this.labelStatusIcon.setBounds(155, 15, 16, 16);
            this.textFieldStatus = new AastraTextField();
            this.textFieldStatus.setBounds(185, 15, 100, 18);
            this.textFieldStatus.setEditable(false);
            this.labelError = new AastraLabel();
            this.labelError.setBounds(15, 45, 100, 16);
            this.labelError.setText(UtilLocale.getString("TXT_ERROR"));
            this.labelError.setVisible(false);
            this.textFieldError = new AastraTextField();
            this.textFieldError.setBounds(185, 45, 400, 18);
            this.textFieldError.setEditable(false);
            this.textFieldError.setVisible(false);
            this.panelStatus.add(this.labelStatus);
            this.panelStatus.add(this.labelStatusIcon);
            this.panelStatus.add(this.textFieldStatus);
            this.panelStatus.add(this.labelError);
            this.panelStatus.add(this.textFieldError);
        }
        return this.panelStatus;
    }

    public void setData(RfpDataRecord rfpDataRecord) {
        this.labelHeaderBar.setText(String.format("%s %s: %s", UtilLocale.getString("TXT_RADIO_FIXED_PART"), UtilLocale.getString("TXT_MAC_ADDRESS"), (String)rfpDataRecord.getField(RfpDataRecord.IDX_ETH_ADDR)));
        switch ((RfpImportPanel.RfpImportStatusTypeEnum)((Object)rfpDataRecord.getField(RfpDataRecord.IDX_GUI_ATTRIB2))) {
            case RFP_NOT_IMPORTED: {
                this.labelStatusIcon.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                this.textFieldStatus.setText(UtilLocale.getString("TXT_NOT_ENROLED_YET"));
                this.labelError.setVisible(false);
                this.textFieldError.setVisible(false);
                break;
            }
            case RFP_IMPORT_OK: {
                this.labelStatusIcon.setIcon(GuiUtilIcon.getIconActive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                this.textFieldStatus.setText(UtilLocale.getString("TXT_OK"));
                this.labelError.setVisible(false);
                this.textFieldError.setVisible(false);
                break;
            }
            case RFP_IMPORT_FAILED: {
                this.labelStatusIcon.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                this.textFieldStatus.setText(UtilLocale.getString("TXT_FAILED"));
                this.labelError.setVisible(true);
                this.textFieldError.setText((String)rfpDataRecord.getField(RfpDataRecord.IDX_ERROR_MSG));
                this.textFieldError.setVisible(true);
            }
        }
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading RFP[" + (String)rfpDataRecord.getField(RfpDataRecord.IDX_ETH_ADDR) + "]:");
    }
}

