/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.gui.GuiProgressDlgCancel;
import com.aastra.oamp.gui.GuiStatusBar;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilFileChooser;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilMainPanel;
import com.aastra.oamp.guiutil.GuiUtilTableColSelect;
import com.aastra.oamp.guiutil.GuiUtilTableConfigDlgDefault;
import com.aastra.oamp.rfp.RfpImportDetailPanel;
import com.aastra.oamp.rfp.RfpImportLogDlg;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilFileHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.DataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.DatabaseChangeEvent;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.RfpDataHandler;
import com.aastra.omilib.RfpDataNotificationInterface;
import com.aastra.omilib.RfpDataRecord;
import com.aastra.omilib.RfpDatabase;
import com.aastra.omilib.SiteDataHandler;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.opsb.OpsbPreStorageBase;
import com.aastra.opsb.OpsbRfpField;
import com.aastra.opsb.OpsbRfpStorageBase;
import com.aastra.opsb.OpsbText;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraHeaderBar;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraLinkButton;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.style.AastraTextField;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.border.TitledBorder;

public class RfpImportPanel
extends GuiUtilMainPanel
implements ConfiguratorTableEventInterface,
RfpDataNotificationInterface,
GuiComponentActivationInterface,
ConfiguratorTable.MultiSelectionNotificationInterface,
DataHandler.DataHandlerSendBulkInterface,
GuiProgressDlgCancel.GuiProgressDlgCancelInterface {
    private static final long serialVersionUID = 1L;
    private static final int ySpaceBetweenTaskButtons = 30;
    protected static final int xSizeDetailPanelSurcharge = 285;
    protected static final int ySizeDetailPanelSurcharge = 0;
    private static final int ySizeDetailPanel = 210;
    private RfpDataHandler rfpDataHandler = null;
    private SiteDataHandler siteDataHandler = null;
    private GuiStatusBar guiStatusBar = null;
    private OpsbPreStorageBase opsbRfpStorageBase = null;
    private GuiUtilConfiguratorTable rfpImportTable = null;
    private RfpDatabase rfpImportDb = null;
    private HashMap<String, String> mapErrorCode = null;
    private AastraPanel northPanel = null;
    private AastraPanel filePanel = null;
    private GuiUtilDetailSplitPanel dataSplitPanel = null;
    private AastraPanel dataPanel = null;
    private AastraPanel emptyPanel = null;
    private AastraScrollPane tablePanel = null;
    private AastraPanel taskPanel = null;
    private RfpImportDetailPanel rfpImportDetailPanel = null;
    private AastraTextField textFieldFileChooser = null;
    private String rfpImportFileName = null;
    private String logFileName = null;
    private String logFilePath = null;
    private AastraButton buttonFileChooser = null;
    private AastraButton buttonLog = null;
    private AastraHeaderBar headerBarTasks = null;
    private AastraLabel labelTasks = null;
    private AastraLinkButton buttonAddRfp = null;
    private AastraLinkButton buttonAddAllRfp = null;
    private AastraLinkButton buttonDeleteRfp = null;
    private AastraLinkButton buttonDeleteAllRfp = null;
    private AastraLinkButton buttonStatusRfp = null;
    private AastraLinkButton buttonConfigureRfpTable = null;
    private int dividerLocation = 0;
    private boolean allImported = false;
    private int yPosTaskButton = 45;
    private Integer[] rfpIdArray = null;
    private int idxEnrol;
    private GuiProgressDlgCancel guiProgressDlg = null;
    private int cntRfpsSendBulkTotal = 0;
    private DataHandler.SendBulkActionType sendBulkAction = null;
    private GuiUtilFileChooser fileChooser = null;
    private boolean enrolRfpsAtOmmStarted = false;
    private int cntCreateRfpReq;
    private int cntCreateRfpResp;
    private String currentStatusPanelMacAddress = null;
    private ArrayList<Integer> listGetRfpRespId = new ArrayList();
    public static final GuiUtilTableColSelect[] tableColSel = new GuiUtilTableColSelect[]{new GuiUtilTableColSelect(RfpDataRecord.IDX_ETH_ADDR, true), new GuiUtilTableColSelect(RfpDataRecord.IDX_NAME, true), new GuiUtilTableColSelect(RfpDataRecord.IDX_DECT_ON, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_CLUSTER, true), new GuiUtilTableColSelect(RfpDataRecord.IDX_PAGING_AREA, true), new GuiUtilTableColSelect(RfpDataRecord.IDX_PREFERRED_SYNC, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_REFLECTIVE_ENV, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_SITE, true), new GuiUtilTableColSelect(RfpDataRecord.IDX_HIERARCHY1, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_HIERARCHY2, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_HIERARCHY3, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_WLAN_PROFILE, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_WLAN_ANTENNA_DIV, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_WLAN_ANTENNA, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_WLAN_CHANNEL, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_WLAN_POWER, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_WLAN_ON, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_HWTYPE_TEXT, true), new GuiUtilTableColSelect(RfpDataRecord.IDX_WLAN_HIGH_THROUGHPUT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_CONFERENCE_CHANNELS, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_GUI_ATTRIB2, true, GuiUtilIcon.getIconInactiveOKError())};

    public RfpImportPanel(RfpDataHandler rfpDataHandler, SiteDataHandler siteDataHandler) {
        this.rfpDataHandler = rfpDataHandler;
        this.siteDataHandler = siteDataHandler;
        this.guiStatusBar = GuiMain.getGuiStatusBarObject();
        this.rfpDataHandler.registerDataNotificationListener(this);
        this.initialize();
    }

    private void initialize() {
        this.getMapErrorCode();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getNorthPanel(), "North");
        this.add((Component)this.getEmptyPanel(), "Center");
    }

    private AastraPanel getNorthPanel() {
        this.northPanel = new AastraPanel();
        this.northPanel.setLayout(new BoxLayout(this.northPanel, 1));
        this.northPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        this.northPanel.add(this.getFilePanel());
        this.northPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        return this.northPanel;
    }

    private AastraPanel getFilePanel() {
        if (this.filePanel == null) {
            this.filePanel = new AastraPanel();
            this.filePanel.setLayout(null);
            this.filePanel.setAlignmentX(0.0f);
            Dimension dimension = new Dimension(650, 130);
            this.filePanel.setPreferredSize(dimension);
            this.filePanel.setMaximumSize(dimension);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_SELECT_RFP_ENROLMENT_IMPORT_FILE"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.filePanel.setBorder(titledBorder);
            this.filePanel.add(this.getTextFieldFileChooser());
            this.filePanel.add(this.getButtonFileChooser());
            this.filePanel.add(this.getButtonLog());
        }
        return this.filePanel;
    }

    private AastraButton getButtonFileChooser() {
        if (this.buttonFileChooser == null) {
            this.buttonFileChooser = new AastraButton(GuiUtilIcon.getIconDocumentAdd());
            this.buttonFileChooser.setText(UtilLocale.getString("TXT_FILE"));
            this.buttonFileChooser.setBounds(30, 30, 106, 25);
            this.buttonFileChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    File file = RfpImportPanel.this.getFileChooser(RfpImportPanel.this.filePanel).fileChooser();
                    if (file != null) {
                        RfpImportPanel.this.rfpImportFileName = file.getAbsolutePath();
                        RfpImportPanel.this.activateDataPanel();
                        RfpImportPanel.this.importRfpFile();
                    } else {
                        RfpImportPanel.this.rfpImportFileName = null;
                    }
                    RfpImportPanel.this.textFieldFileChooser.setText(RfpImportPanel.this.rfpImportFileName);
                }
            });
        }
        return this.buttonFileChooser;
    }

    private AastraButton getButtonLog() {
        if (this.buttonLog == null) {
            this.buttonLog = new AastraButton();
            this.buttonLog.setBounds(30, 75, 160, 25);
            this.buttonLog.setText(UtilLocale.getString("TXT_SHOW_LOG_FILE_20"));
            this.buttonLog.setEnabled(false);
            this.buttonLog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpImportPanel.this.getDlgLogFile(RfpImportPanel.this.logFilePath);
                }
            });
        }
        return this.buttonLog;
    }

    private AastraTextField getTextFieldFileChooser() {
        if (this.textFieldFileChooser == null) {
            this.textFieldFileChooser = new AastraTextField();
            this.textFieldFileChooser.setBounds(150, 30, 480, 18);
            this.textFieldFileChooser.setText(this.rfpImportFileName);
            this.textFieldFileChooser.setEditable(false);
        }
        return this.textFieldFileChooser;
    }

    private void activateDataPanel() {
        if (this.emptyPanel != null) {
            this.remove(this.emptyPanel);
        }
        this.add((Component)this.getDataPanel(), "Center");
        this.updateUI();
    }

    private void deactivateDataPanel() {
        if (this.dataPanel != null) {
            this.remove(this.dataPanel);
        }
        this.add((Component)this.getEmptyPanel(), "Center");
        this.updateUI();
    }

    private AastraPanel getEmptyPanel() {
        if (this.emptyPanel == null) {
            this.emptyPanel = new AastraPanel();
        }
        return this.emptyPanel;
    }

    private AastraPanel getDataPanel() {
        if (this.dataPanel == null) {
            this.dataPanel = new AastraPanel();
            this.dataPanel.setLayout(new BorderLayout());
            this.dataPanel.setPreferredSize(new Dimension(500, 300));
            this.dataPanel.add((Component)this.getDataSplitPanel(), "Center");
            this.dataPanel.add((Component)this.getTaskPanel(), "East");
        }
        return this.dataPanel;
    }

    private GuiUtilDetailSplitPanel getDataSplitPanel() {
        if (this.dataSplitPanel == null) {
            this.dataSplitPanel = new GuiUtilDetailSplitPanel(210);
            this.dataSplitPanel.setTopComponent(this.getTablePanel());
            this.dataSplitPanel.setBottomComponent(null);
        }
        return this.dataSplitPanel;
    }

    private AastraScrollPane getTablePanel() {
        if (this.tablePanel == null) {
            this.tablePanel = new AastraScrollPane(null);
            this.tablePanel.setPreferredSize(new Dimension(400, 300));
            this.tablePanel.setBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderDetailPanel));
            this.dividerLocation = this.dataSplitPanel.getHeight() - 210;
            this.tablePanel.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.tablePanel;
    }

    private GuiUtilConfiguratorTable getRfpImportTable() {
        this.rfpImportTable = new GuiUtilConfiguratorTable((Object)this, (Database)this.rfpImportDb, tableColSel, this.getActiveTableColumns(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpImport, tableColSel), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthRfpImport, true);
        this.rfpImportTable.setNegativeIntAsInvalid(RfpDataRecord.IDX_PAGING_AREA);
        return this.rfpImportTable;
    }

    private AastraPanel getTaskPanel() {
        if (this.taskPanel == null) {
            this.taskPanel = new AastraPanel();
            this.taskPanel.setPreferredSize(new Dimension(185, 0));
            this.taskPanel.setLayout(null);
            this.taskPanel.add(this.getHeaderBarTasks());
            this.taskPanel.add(this.getButtonAddAllRfp());
            this.taskPanel.add(this.getButtonAddRfp());
            this.taskPanel.add(this.getButtonDeleteAllRfp());
            this.taskPanel.add(this.getButtonDeleteRfp());
            this.taskPanel.add(this.getButtonStatusRfp());
            this.taskPanel.add(this.getButtonConfigureRfpTable());
        }
        return this.taskPanel;
    }

    private AastraHeaderBar getHeaderBarTasks() {
        if (this.headerBarTasks == null) {
            this.labelTasks = new AastraLabel();
            this.labelTasks.setText(UtilLocale.getString("TXT_TASKS_20"));
            this.labelTasks.setFont(AastraCommon.AastraFontHeader);
            this.headerBarTasks = new AastraHeaderBar();
            this.headerBarTasks.setBounds(0, 0, 185, 30);
            this.headerBarTasks.setPreferredSize(new Dimension(185, 30));
            this.headerBarTasks.add(this.labelTasks);
        }
        return this.headerBarTasks;
    }

    private AastraLinkButton getButtonAddAllRfp() {
        if (this.buttonAddAllRfp == null) {
            this.buttonAddAllRfp = new AastraLinkButton();
            this.buttonAddAllRfp.setBounds(5, this.yPosTaskButton, 160, 20);
            this.buttonAddAllRfp.setText(UtilLocale.getString("TXT_ADD_ALL_20"));
            this.buttonAddAllRfp.setToolTipText(UtilLocale.getString("TXT_ENROL_ALL_RFPS_AT_OMM"));
            this.buttonAddAllRfp.setEnabled(false);
            this.buttonAddAllRfp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = RfpImportPanel.this.rfpImportDb.getRecordNumber();
                    RfpImportPanel.access$902(RfpImportPanel.this, new Integer[n]);
                    RfpImportPanel.this.cntRfpsSendBulkTotal = 0;
                    for (int i = 0; i < n; ++i) {
                        RfpDataRecord rfpDataRecord = RfpImportPanel.this.rfpImportDb.getRecordByIdx(i);
                        if (rfpDataRecord.getField(RfpDataRecord.IDX_GUI_ATTRIB2) == RfpImportStatusTypeEnum.RFP_IMPORT_OK) continue;
                        ((RfpImportPanel)RfpImportPanel.this).rfpIdArray[((RfpImportPanel)RfpImportPanel.this).cntRfpsSendBulkTotal++] = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID);
                    }
                    RfpImportPanel.this.startEnrolRfp();
                }
            });
            this.yPosTaskButton += 30;
        }
        return this.buttonAddAllRfp;
    }

    private AastraLinkButton getButtonAddRfp() {
        if (this.buttonAddRfp == null) {
            this.buttonAddRfp = new AastraLinkButton();
            this.buttonAddRfp.setBounds(5, this.yPosTaskButton, 160, 20);
            this.buttonAddRfp.setText(UtilLocale.getString("TXT_ADD_SELECTED_20"));
            this.buttonAddRfp.setToolTipText(UtilLocale.getString("TXT_ENROL_SELECTED_RFPS_AT_OMM"));
            this.buttonAddRfp.setEnabled(false);
            this.buttonAddRfp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = RfpImportPanel.this.rfpImportTable.getSelectedRows();
                    RfpImportPanel.access$902(RfpImportPanel.this, new Integer[nArray.length]);
                    RfpImportPanel.this.cntRfpsSendBulkTotal = 0;
                    for (int i = 0; i < nArray.length; ++i) {
                        int n = RfpImportPanel.this.rfpImportTable.convertRowIndexToModel(nArray[i]);
                        RfpDataRecord rfpDataRecord = RfpImportPanel.this.rfpImportDb.getRecordByIdx(n);
                        if (rfpDataRecord.getField(RfpDataRecord.IDX_GUI_ATTRIB2) == RfpImportStatusTypeEnum.RFP_IMPORT_OK) continue;
                        ((RfpImportPanel)RfpImportPanel.this).rfpIdArray[((RfpImportPanel)RfpImportPanel.this).cntRfpsSendBulkTotal++] = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID);
                    }
                    RfpImportPanel.this.startEnrolRfp();
                }
            });
            this.yPosTaskButton += 30;
        }
        return this.buttonAddRfp;
    }

    private void startEnrolRfp() {
        this.idxEnrol = 0;
        if (this.cntRfpsSendBulkTotal > 0) {
            RfpDataRecord[] rfpDataRecordArray = new RfpDataRecord[this.cntRfpsSendBulkTotal];
            for (int i = 0; i < this.cntRfpsSendBulkTotal; ++i) {
                RfpDataRecord rfpDataRecord = (RfpDataRecord)this.rfpImportDb.getRfpByRfpId(this.rfpIdArray[this.idxEnrol++]).clone();
                rfpDataRecord.setField(RfpDataRecord.IDX_RFP_ID, (Object)-1);
                rfpDataRecordArray[i] = rfpDataRecord;
            }
            this.enrolRfpsAtOmmStarted = true;
            this.cntCreateRfpReq = this.cntRfpsSendBulkTotal;
            this.cntCreateRfpResp = 0;
            this.listGetRfpRespId.clear();
            this.sendBulkAction = DataHandler.SendBulkActionType.Create;
            this.rfpDataHandler.sendChangeDeleteRfps(this.sendBulkAction, rfpDataRecordArray, this);
            this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_BUSY, null);
            if (this.cntRfpsSendBulkTotal > 1) {
                this.guiProgressDlg = new GuiProgressDlgCancel(UtilLocale.getString("TXT_ADDING_RFPS_IN_PROGRESS"), false, true, this);
                this.guiProgressDlg.setValue(0);
                this.guiProgressDlg.setVisible(true);
            }
        }
    }

    private AastraLinkButton getButtonDeleteAllRfp() {
        if (this.buttonDeleteAllRfp == null) {
            this.buttonDeleteAllRfp = new AastraLinkButton();
            this.buttonDeleteAllRfp.setBounds(5, this.yPosTaskButton, 160, 20);
            this.buttonDeleteAllRfp.setText(UtilLocale.getString("TXT_REMOVE_ALL_20"));
            this.buttonDeleteAllRfp.setToolTipText(UtilLocale.getString("TXT_REMOVE_ALL_RFPS_FROM_IMPORT_LIST"));
            this.buttonDeleteAllRfp.setEnabled(false);
            this.buttonDeleteAllRfp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiUtilDialog guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_REMOVE_ALL_RFPS_FROM_IMPORT_LIST_?") + "<br>" + UtilLocale.getString("TXT_TABLE_VIEW_WILL_BE_REMOVED"), true);
                    if (guiUtilDialog.getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
                        RfpImportPanel.this.clearAllEntries();
                    }
                }
            });
            this.yPosTaskButton += 30;
        }
        return this.buttonDeleteAllRfp;
    }

    private AastraLinkButton getButtonDeleteRfp() {
        if (this.buttonDeleteRfp == null) {
            this.buttonDeleteRfp = new AastraLinkButton();
            this.buttonDeleteRfp.setBounds(5, this.yPosTaskButton, 160, 20);
            this.buttonDeleteRfp.setText(UtilLocale.getString("TXT_REMOVE_SELECTED_20"));
            this.buttonDeleteRfp.setToolTipText(UtilLocale.getString("TXT_REMOVE_SELECTED_RFPS_FROM_IMPORT_LIST"));
            this.buttonDeleteRfp.setEnabled(false);
            this.buttonDeleteRfp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiUtilDialog guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_REMOVE_SELECTED_RFPS_FROM_IMPORT_LIST_?") + "<br>" + UtilLocale.getString("TXT_IF_THERE_ARE_NO_ENTRIES_LEFT_TABLE_VIEW_WILL_BE_REMOVED"), true);
                    if (guiUtilDialog.getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
                        int n = RfpImportPanel.this.rfpImportTable.getRowCount();
                        int n2 = RfpImportPanel.this.rfpImportTable.getSelectedRowCount();
                        int[] nArray = RfpImportPanel.this.rfpImportTable.getSelectedRows();
                        if (n == n2) {
                            RfpImportPanel.this.clearAllEntries();
                        } else {
                            int n3;
                            Integer[] integerArray = new Integer[n2];
                            for (n3 = 0; n3 < n2; ++n3) {
                                int n4 = RfpImportPanel.this.rfpImportTable.convertRowIndexToModel(nArray[n3]);
                                RfpDataRecord rfpDataRecord = RfpImportPanel.this.rfpImportDb.getRecordByIdx(n4);
                                integerArray[n3] = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID);
                            }
                            for (n3 = 0; n3 < n2; ++n3) {
                                RfpImportPanel.this.rfpImportDb.deleteRfp(integerArray[n3]);
                            }
                        }
                    }
                }
            });
            this.yPosTaskButton += 30;
        }
        return this.buttonDeleteRfp;
    }

    private void clearAllEntries() {
        this.buttonAddAllRfp.setEnabled(false);
        this.buttonDeleteAllRfp.setEnabled(false);
        this.rfpImportDb.clearAll();
        this.rfpImportFileName = null;
        this.textFieldFileChooser.setText(null);
        this.deactivateDataPanel();
    }

    private AastraLinkButton getButtonStatusRfp() {
        if (this.buttonStatusRfp == null) {
            this.buttonStatusRfp = new AastraLinkButton();
            this.buttonStatusRfp.setBounds(5, this.yPosTaskButton, 160, 20);
            this.buttonStatusRfp.setText(UtilLocale.getString("TXT_SHOW_STATUS_20"));
            this.buttonStatusRfp.setToolTipText(UtilLocale.getString("TXT_SHOW_ENROLMENT_STATUS_OF_SELECTED_RFP"));
            this.buttonStatusRfp.setEnabled(false);
            this.buttonStatusRfp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = RfpImportPanel.this.rfpImportTable.getSelectedRow();
                    if (n >= 0) {
                        int n2 = RfpImportPanel.this.rfpImportTable.convertRowIndexToModel(n);
                        RfpDataRecord rfpDataRecord = RfpImportPanel.this.rfpImportDb.getRecordByIdx(n2);
                        if (rfpDataRecord != null) {
                            RfpImportPanel.this.createRfpStatusPanel(rfpDataRecord);
                        }
                    }
                }
            });
            this.yPosTaskButton += 30;
        }
        return this.buttonStatusRfp;
    }

    private AastraLinkButton getButtonConfigureRfpTable() {
        if (this.buttonConfigureRfpTable == null) {
            this.buttonConfigureRfpTable = new AastraLinkButton();
            this.buttonConfigureRfpTable.setBounds(5, this.yPosTaskButton, 160, 20);
            this.buttonConfigureRfpTable.setText(UtilLocale.getString("TXT_SELECT_COLUMNS_20"));
            this.buttonConfigureRfpTable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpImportTableConfigDlg rfpImportTableConfigDlg = new RfpImportTableConfigDlg();
                    rfpImportTableConfigDlg.setVisible(true);
                }
            });
            this.yPosTaskButton += 30;
        }
        return this.buttonConfigureRfpTable;
    }

    private void importRfpFile() {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Starting RFP enrolment data import from file '" + this.rfpImportFileName + "'");
        this.initOpsbRfpStorageBase();
        this.logFileName = this.opsbRfpStorageBase.getInstrProtFileName();
        this.logFilePath = UtilFileHandling.getWorkingDirectory() + File.separator + this.logFileName;
        this.buttonLog.setToolTipText(UtilLocale.getString("TXT_SHOW_IMPORT_LOG_FILE") + ": '" + this.logFilePath + "'");
        this.buttonLog.setEnabled(true);
        if (this.opsbRfpStorageBase.opsb_rfp_read_conf_file()) {
            this.rfpImportDb = new RfpDatabase();
            this.tablePanel.setViewportView(this.getRfpImportTable());
            this.allImported = false;
            int n = this.importOpsbRfpRecords();
            if (n > 0) {
                this.buttonAddAllRfp.setEnabled(true);
                this.buttonDeleteAllRfp.setEnabled(true);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "" + n + " RFP datasets imported");
                GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_RFP_ENROLMENT_FILE_*_WITH_*_VALID_ENTRIES_IMPORTED_SUCCESSFULLY"), this.rfpImportFileName, n));
            } else {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "RFP enrolment file contains no data");
                GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_RFP_ENROLMENT_FILE_*_CONTAINS_NO_VALID_ENTRIES"), this.rfpImportFileName));
            }
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Reading RFP enrolment file failed");
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_IMPORT_OF_RFP_ENROLMENT_FILE_*_FAILED"), this.rfpImportFileName) + " " + String.format(UtilLocale.getString("TXT_SEE_FILE_*_FOR_DETAILS"), this.logFileName));
        }
    }

    private OpsbPreStorageBase initOpsbRfpStorageBase() {
        int n;
        this.opsbRfpStorageBase = new OpsbRfpStorageBase(this.rfpImportFileName, UtilFileHandling.getWorkingDirectory() + File.separator);
        switch (UtilLocale.LanguageType.valueOf(UtilPreferences.getLocale().getLanguage())) {
            case de: {
                n = UtilLocale.German;
                break;
            }
            case fr: {
                n = UtilLocale.French;
                break;
            }
            case es: {
                n = UtilLocale.Spanish;
                break;
            }
            default: {
                n = UtilLocale.English;
            }
        }
        this.opsbRfpStorageBase.setLanguage(n);
        this.opsbLanguageTranslator();
        return this.opsbRfpStorageBase;
    }

    private void opsbLanguageTranslator() {
        for (int i = 0; i < OpsbText.textKeys.length; ++i) {
            String string = "TXT_OPSB_" + OpsbText.textKeys[i].toUpperCase();
            for (int j = 0; j < UtilLocale.languages.length; ++j) {
                String string2 = UtilLocale.getStringLanguage(string, UtilLocale.languages[j].getLocale());
                OpsbRfpStorageBase.text.setExternLanguage(OpsbText.textKeys[i], j, string2);
            }
        }
    }

    private int importOpsbRfpRecords() {
        String string;
        int n = 0;
        while ((string = this.opsbRfpStorageBase.getField(n, OpsbRfpField.MAC.ordinal())) != null && string.length() > 0) {
            RfpDataRecord rfpDataRecord = new RfpDataRecord();
            String string2 = this.opsbRfpStorageBase.getField(n, OpsbRfpField.HW_TYPE.ordinal());
            rfpDataRecord.setField(RfpDataRecord.IDX_HWTYPE_TEXT, (Object)OmiMessage.RFPHwTypeType.getStrPreselectFromStrExport(string2));
            rfpDataRecord.setField(RfpDataRecord.IDX_HWTYPE, (Object)OmiMessage.RFPHwTypeType.getTypeFromStrPreselect(rfpDataRecord.getField(RfpDataRecord.IDX_HWTYPE_TEXT).toString()));
            rfpDataRecord.setField(RfpDataRecord.IDX_RFP_ID, (Object)n);
            rfpDataRecord.setField(RfpDataRecord.IDX_ETH_ADDR, (Object)string);
            rfpDataRecord.setField(RfpDataRecord.IDX_NAME, (Object)this.opsbRfpStorageBase.getField(n, OpsbRfpField.LOCATION.ordinal()));
            rfpDataRecord.setField(RfpDataRecord.IDX_DECT_ON, (Object)this.strToBool(this.opsbRfpStorageBase.getField(n, OpsbRfpField.ACTIVE.ordinal())));
            int n2 = 0;
            String string3 = this.opsbRfpStorageBase.getField(n, OpsbRfpField.CLUSTER.ordinal());
            if (string3.length() > 0) {
                n2 = Integer.valueOf(string3);
            }
            rfpDataRecord.setField(RfpDataRecord.IDX_CLUSTER, (Object)n2);
            int n3 = -1;
            string3 = this.opsbRfpStorageBase.getField(n, OpsbRfpField.PAGING_AREA.ordinal());
            if (string3.length() > 0 && string3.compareToIgnoreCase("unassigned") != 0) {
                n3 = Integer.valueOf(string3);
            }
            rfpDataRecord.setField(RfpDataRecord.IDX_PAGING_AREA, (Object)n3);
            rfpDataRecord.setField(RfpDataRecord.IDX_PREFERRED_SYNC, (Object)this.strToBool(this.opsbRfpStorageBase.getField(n, OpsbRfpField.SYNC_SOURCE.ordinal())));
            rfpDataRecord.setField(RfpDataRecord.IDX_REFLECTIVE_ENV, (Object)this.strToBool(this.opsbRfpStorageBase.getField(n, OpsbRfpField.REFL_ENV.ordinal())));
            string3 = this.opsbRfpStorageBase.getField(n, OpsbRfpField.SITE.ordinal());
            int n4 = string3.length() > 0 ? Integer.valueOf(string3) : this.siteDataHandler.getSiteByTableIdx((int)0).id;
            rfpDataRecord.setField(RfpDataRecord.IDX_SITE, (Object)n4);
            rfpDataRecord.setField(RfpDataRecord.IDX_HIERARCHY1, (Object)this.opsbRfpStorageBase.getField(n, OpsbRfpField.BUILDING.ordinal()));
            rfpDataRecord.setField(RfpDataRecord.IDX_HIERARCHY2, (Object)this.opsbRfpStorageBase.getField(n, OpsbRfpField.FLOOR.ordinal()));
            rfpDataRecord.setField(RfpDataRecord.IDX_HIERARCHY3, (Object)this.opsbRfpStorageBase.getField(n, OpsbRfpField.ROOM.ordinal()));
            if (rfpDataRecord.getField(RfpDataRecord.IDX_HWTYPE_TEXT).equals(OmiMessage.RFPHwTypeType.RFP43.strPreselect)) {
                rfpDataRecord.setField(RfpDataRecord.IDX_CONFERENCE_CHANNELS, (Object)this.strToBool(this.opsbRfpStorageBase.getField(n, OpsbRfpField.CONFERENCE_CHANNELS.ordinal())));
            }
            if (rfpDataRecord.getField(RfpDataRecord.IDX_HWTYPE_TEXT).equals(OmiMessage.RFPHwTypeType.RFP41.strPreselect) || rfpDataRecord.getField(RfpDataRecord.IDX_HWTYPE_TEXT).equals(OmiMessage.RFPHwTypeType.RFP43.strPreselect)) {
                int n5 = 0;
                string3 = this.opsbRfpStorageBase.getField(n, OpsbRfpField.PROFILE.ordinal());
                if (string3.length() > 0) {
                    n5 = Integer.valueOf(string3);
                }
                rfpDataRecord.setField(RfpDataRecord.IDX_WLAN_PROFILE, (Object)n5);
                int n6 = 1;
                string3 = this.opsbRfpStorageBase.getField(n, OpsbRfpField.CHANNEL_BG.ordinal());
                if (string3.length() > 0) {
                    n6 = Integer.parseInt(string3);
                }
                rfpDataRecord.setField(RfpDataRecord.IDX_WLAN_CHANNEL, (Object)n6);
                int n7 = 100;
                string3 = this.opsbRfpStorageBase.getField(n, OpsbRfpField.POWER.ordinal());
                if (string3.length() > 0) {
                    n7 = Integer.parseInt(string3);
                }
                rfpDataRecord.setField(RfpDataRecord.IDX_WLAN_POWER, (Object)n7);
                rfpDataRecord.setField(RfpDataRecord.IDX_WLAN_ON, (Object)this.strToBool(this.opsbRfpStorageBase.getField(n, OpsbRfpField.WLAN_ACTIVE.ordinal())));
                if (rfpDataRecord.getField(RfpDataRecord.IDX_HWTYPE_TEXT).equals(OmiMessage.RFPHwTypeType.RFP41.strPreselect)) {
                    int n8 = 1;
                    string3 = this.opsbRfpStorageBase.getField(n, OpsbRfpField.ANTENNA.ordinal());
                    if (string3.length() > 0) {
                        n8 = Integer.parseInt(string3);
                    }
                    switch (n8) {
                        case 0: {
                            rfpDataRecord.setField(RfpDataRecord.IDX_WLAN_ANTENNA_DIV, (Object)true);
                            rfpDataRecord.setField(RfpDataRecord.IDX_WLAN_ANTENNA, (Object)1);
                            break;
                        }
                        case 1: 
                        case 2: {
                            rfpDataRecord.setField(RfpDataRecord.IDX_WLAN_ANTENNA_DIV, (Object)false);
                            rfpDataRecord.setField(RfpDataRecord.IDX_WLAN_ANTENNA, (Object)n8);
                        }
                    }
                } else {
                    rfpDataRecord.setField(RfpDataRecord.IDX_WLAN_HIGH_THROUGHPUT, (Object)this.strToBool(this.opsbRfpStorageBase.getField(n, OpsbRfpField.WLAN_HT40.ordinal())));
                }
            }
            rfpDataRecord.setField(RfpDataRecord.IDX_GUI_ATTRIB2, (Object)RfpImportStatusTypeEnum.RFP_NOT_IMPORTED);
            this.rfpImportDb.createRfp(rfpDataRecord);
            ++n;
        }
        return n;
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        if (dataRecord != null) {
            this.createRfpStatusPanel((RfpDataRecord)dataRecord);
        }
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    private void processTableEvent(DataRecord dataRecord) {
        if (this.dataSplitPanel.getBottomComponent() != null) {
            if (dataRecord != null) {
                this.createRfpStatusPanel((RfpDataRecord)dataRecord);
            } else {
                this.removeRfpStatusPanel();
            }
        } else if (this.rfpImportTable.getSelectedRow() == -1) {
            this.buttonAddRfp.setEnabled(false);
            this.buttonDeleteRfp.setEnabled(false);
            this.buttonStatusRfp.setEnabled(false);
        } else {
            if (this.allImported) {
                this.buttonAddRfp.setEnabled(false);
            } else {
                this.buttonAddRfp.setEnabled(true);
            }
            this.buttonDeleteRfp.setEnabled(true);
            if (this.rfpImportTable.getSelectedRowCount() == 1) {
                this.buttonStatusRfp.setEnabled(true);
            } else {
                this.buttonStatusRfp.setEnabled(false);
            }
        }
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        if (this.dataSplitPanel.getBottomComponent() != null && this.rfpImportTable.getSelectedRowCount() > 1) {
            this.removeRfpStatusPanel();
        }
        this.buttonStatusRfp.setEnabled(false);
    }

    @Override
    public void processRfpDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "RFP notification: " + dataNotificationEnum.toString() + ",rfpId=" + n);
        if (this.enrolRfpsAtOmmStarted && dataNotificationEnum == DataNotificationEnum.NEW_DATA) {
            int n2;
            if (this.listGetRfpRespId.contains(n)) {
                this.listGetRfpRespId.remove((Object)n);
                return;
            }
            if (++this.cntCreateRfpResp == this.cntCreateRfpReq) {
                this.enrolRfpsAtOmmStarted = false;
            }
            if (this.rfpImportDb != null && (n2 = this.rfpImportDb.getRecordNumber()) > 0) {
                RfpDataRecord rfpDataRecord = this.rfpDataHandler.getRfpData(n);
                String string = (String)rfpDataRecord.getField(RfpDataRecord.IDX_ETH_ADDR);
                for (int i = 0; i < n2; ++i) {
                    RfpDataRecord rfpDataRecord2 = this.rfpImportDb.getRecordByIdx(i);
                    String string2 = (String)rfpDataRecord2.getField(RfpDataRecord.IDX_ETH_ADDR);
                    if (string2.compareToIgnoreCase(string) != 0 || rfpDataRecord2.getField(RfpDataRecord.IDX_GUI_ATTRIB2) == RfpImportStatusTypeEnum.RFP_IMPORT_OK) continue;
                    rfpDataRecord2.setField(RfpDataRecord.IDX_GUI_ATTRIB2, (Object)RfpImportStatusTypeEnum.RFP_IMPORT_OK);
                    this.rfpImportDb.updateIndex(new DatabaseChangeEvent(Database.DatabaseChangeEnum.RECORD_CHANGED, i, DatabaseChangeEvent.DatabaseChangeType.RFP));
                    this.updateRfpStatusPanel(rfpDataRecord2);
                    this.rfpDataHandler.sendRfpReq(n, true, true);
                    this.listGetRfpRespId.add(n);
                    if (this.checkAllImported()) {
                        this.allImported = true;
                        this.buttonAddAllRfp.setEnabled(false);
                        this.buttonAddRfp.setEnabled(false);
                    }
                    return;
                }
            }
        }
    }

    private boolean checkAllImported() {
        int n = this.rfpImportDb.getRecordNumber();
        for (int i = 0; i < n; ++i) {
            RfpDataRecord rfpDataRecord = this.rfpImportDb.getRecordByIdx(i);
            if (rfpDataRecord.getField(RfpDataRecord.IDX_GUI_ATTRIB2) == RfpImportStatusTypeEnum.RFP_IMPORT_OK) continue;
            return false;
        }
        return true;
    }

    @Override
    public void processRfpErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.enrolRfpsAtOmmStarted) {
            int n2 = this.rfpIdArray[this.cntCreateRfpResp];
            if (++this.cntCreateRfpResp == this.cntCreateRfpReq) {
                this.enrolRfpsAtOmmStarted = false;
            }
            String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
            String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
            String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
            OmiMessage.errorCodes errorCodes2 = null;
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "RFP error notification: " + dataNotificationEnum.toString() + ",rfpId=" + String.valueOf(n) + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
            try {
                errorCodes2 = OmiMessage.errorCodes.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                errorCodes2 = null;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "RFP error notification: Unknown errorCode=" + string);
            }
            String string4 = "";
            RfpDataRecord rfpDataRecord = this.rfpImportDb.getRfpByRfpId(n2);
            if (rfpDataRecord != null) {
                rfpDataRecord.setField(RfpDataRecord.IDX_GUI_ATTRIB2, (Object)RfpImportStatusTypeEnum.RFP_IMPORT_FAILED);
                this.rfpImportDb.updateIndex(new DatabaseChangeEvent(Database.DatabaseChangeEnum.RECORD_CHANGED, n2, DatabaseChangeEvent.DatabaseChangeType.RFP));
                if (errorCodes2 != null) {
                    string4 = UtilErrorHandling.getErrorMessage(errorCodes2, this.getErrorCodeTranslation(string2), string3);
                    rfpDataRecord.setField(RfpDataRecord.IDX_ERROR_MSG, (Object)string4);
                } else {
                    rfpDataRecord.setField(RfpDataRecord.IDX_ERROR_MSG, (Object)UtilLocale.getString("TXT_UNKNOWN_ERROR"));
                }
                this.updateRfpStatusPanel(rfpDataRecord);
            } else {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "rfpId=" + n + " does not exist in import database anymore");
            }
        }
    }

    private void getMapErrorCode() {
        this.mapErrorCode = new HashMap();
        this.mapErrorCode.put(OmiMessage.RFPType.name.toString(), UtilLocale.getString("TXT_NAME"));
        this.mapErrorCode.put(OmiMessage.RFPType.ethAddr.toString(), UtilLocale.getString("TXT_MAC_ADDRESS"));
        this.mapErrorCode.put(OmiMessage.RFPType.site.toString(), UtilLocale.getString("TXT_SITE"));
        this.mapErrorCode.put(OmiMessage.RFPType.hierarchy1.toString(), UtilLocale.getString("TXT_ROOM"));
        this.mapErrorCode.put(OmiMessage.RFPType.hierarchy2.toString(), UtilLocale.getString("TXT_FLOOR"));
        this.mapErrorCode.put(OmiMessage.RFPType.hierarchy3.toString(), UtilLocale.getString("TXT_BUILDING"));
        this.mapErrorCode.put(OmiMessage.RFPType.cluster.toString(), UtilLocale.getString("TXT_DECT_CLUSTER"));
        this.mapErrorCode.put(OmiMessage.RFPType.pagingArea.toString(), UtilLocale.getString("TXT_PAGING_AREA"));
        this.mapErrorCode.put(OmiMessage.RFPType.wlanProfile.toString(), UtilLocale.getString("TXT_WLAN_PROFILE"));
        this.mapErrorCode.put(OmiMessage.RFPType.wlanAntenna.toString(), UtilLocale.getString("TXT_ANTENNA"));
        this.mapErrorCode.put(OmiMessage.RFPType.wlanChannel.toString(), UtilLocale.getString("TXT_CHANNEL"));
        this.mapErrorCode.put(OmiMessage.RFPType.wlanPower.toString(), UtilLocale.getString("TXT_OUTPUT_POWER_LEVEL"));
    }

    private String getErrorCodeTranslation(String string) {
        if (string == null) {
            return null;
        }
        return this.mapErrorCode.get(string);
    }

    private void getDlgLogFile(String string) {
        RfpImportLogDlg rfpImportLogDlg = new RfpImportLogDlg(string);
        rfpImportLogDlg.setLogtext();
        rfpImportLogDlg.setVisible(true);
    }

    private void createRfpStatusPanel(RfpDataRecord rfpDataRecord) {
        if (this.dataSplitPanel.getBottomComponent() != null) {
            this.dividerLocation = this.dataSplitPanel.getDividerLocation();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating RFP import detail panel");
        } else {
            this.dataSplitPanel.setBottomComponent(this.getRfpImportDetailPanel());
            this.buttonStatusRfp.setEnabled(false);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating RFP import detail panel");
        }
        this.rfpImportDetailPanel.setData(rfpDataRecord);
        this.currentStatusPanelMacAddress = (String)rfpDataRecord.getField(RfpDataRecord.IDX_ETH_ADDR);
        this.dataSplitPanel.setDividerLocation(this.dividerLocation);
        this.dataSplitPanel.validate();
    }

    private void updateRfpStatusPanel(RfpDataRecord rfpDataRecord) {
        if ((String)rfpDataRecord.getField(RfpDataRecord.IDX_ETH_ADDR) == this.currentStatusPanelMacAddress) {
            this.rfpImportDetailPanel.setData(rfpDataRecord);
        }
    }

    public void removeRfpStatusPanel() {
        this.dividerLocation = this.dataSplitPanel.getDividerLocation();
        this.dataSplitPanel.setBottomComponent(null);
        this.currentStatusPanelMacAddress = null;
        if (this.rfpImportTable.getSelectedRow() >= 0) {
            this.buttonStatusRfp.setEnabled(true);
        }
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing RFP import detail panel");
    }

    private RfpImportDetailPanel getRfpImportDetailPanel() {
        if (this.rfpImportDetailPanel == null) {
            this.rfpImportDetailPanel = new RfpImportDetailPanel(this);
        }
        return this.rfpImportDetailPanel;
    }

    private boolean strToBool(String string) {
        return string.equals("1") || string.equalsIgnoreCase("true");
    }

    private GuiUtilFileChooser getFileChooser(AastraPanel aastraPanel) {
        if (this.fileChooser == null) {
            this.fileChooser = new GuiUtilFileChooser(aastraPanel);
        }
        return this.fileChooser;
    }

    @Override
    public void componentActivated(Component component) {
        this.getButtonFileChooser().requestFocusInWindow();
        this.getRootPane().setDefaultButton(this.getButtonFileChooser());
    }

    @Override
    public void componentDeactivated() {
    }

    @Override
    public void notifyProgress(int n, boolean bl) {
        if (bl || n == this.cntRfpsSendBulkTotal) {
            if (this.guiProgressDlg != null) {
                this.guiProgressDlg.dispose();
            }
            GuiMain.getGuiStatusBarObject().showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
            if (bl) {
                this.cntCreateRfpReq = n;
                GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_CREATING_CANCELED_AFTER_*_OF_*_RFPS"), n, this.cntRfpsSendBulkTotal));
            }
        } else {
            this.guiProgressDlg.setValue(100 * n / this.cntRfpsSendBulkTotal);
        }
    }

    @Override
    public void timeout(int n) {
        if (this.guiProgressDlg != null) {
            this.guiProgressDlg.dispose();
        }
        this.enrolRfpsAtOmmStarted = false;
        GuiMain.getGuiStatusBarObject().showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
        GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_CREATING_CANCELED_BY_TIMEOUT_AFTER_*_OF_*_RFPS"), n, this.cntRfpsSendBulkTotal));
    }

    @Override
    public void canceled() {
        this.rfpDataHandler.cancelChangeDeleteRfps();
    }

    static /* synthetic */ Integer[] access$902(RfpImportPanel rfpImportPanel, Integer[] integerArray) {
        rfpImportPanel.rfpIdArray = integerArray;
        return integerArray;
    }

    private class RfpImportTableConfigDlg
    extends GuiUtilTableConfigDlgDefault {
        private static final long serialVersionUID = 1L;

        public RfpImportTableConfigDlg() {
            super(RfpImportPanel.this.rfpImportTable, tableColSel, UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpImport);
        }

        @Override
        protected void buildCheckBoxes() {
            super.buildCheckBoxes();
            this.checkBoxActiveArray[tableColSel.length - 1].setEnabled(false);
        }
    }

    public static enum RfpImportStatusTypeEnum {
        RFP_NOT_IMPORTED,
        RFP_IMPORT_OK,
        RFP_IMPORT_FAILED;

    }
}

