/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.rfp.RfpDetailPanel;
import com.aastra.oamp.rfp.RfpMonitorMainPanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.RfpDataRecord;
import com.aastra.omilib.SiteDataHandler;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraTextField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;

public class RfpMonitorDetailPanel
extends RfpDetailPanel {
    private static final long serialVersionUID = 1L;
    private SiteDataHandler siteDataHandler = null;
    private SiteDataHandler.SiteDatabase siteDatabase = null;
    private RfpMonitorMainPanel rfpMainPanel = null;
    private AastraLabel labelDECTRunning = null;
    private AastraLabel labelDECTRunningStatus = null;
    private AastraLabel labelSyncState = null;
    private AastraLabel labelSyncStateStatus = null;
    private AastraLabel labelHasWLAN = null;
    private AastraLabel labelHasWLANStatus = null;
    private AastraLabel labelWLANRunning = null;
    private AastraLabel labelWLANRunningStatus = null;
    private AastraLabel labelWLANLink = null;
    private AastraLabel labelWLANLinkStatus = null;
    private AastraLabel labelChannelUsed = null;
    private AastraTextField textFieldChannelUsed = null;
    private AastraLabel labelPowerUsed = null;
    private AastraTextField textFieldPowerUsed = null;
    private AastraLabel labeldBm = null;
    private AastraLabel labelHighThroughputTypeUsed = null;
    private AastraTextField textFieldHighThroughputTypeUsed = null;

    public RfpMonitorDetailPanel(RfpMonitorMainPanel rfpMonitorMainPanel, SiteDataHandler siteDataHandler) {
        this.rfpMainPanel = rfpMonitorMainPanel;
        this.siteDataHandler = siteDataHandler;
        this.initialize();
    }

    private void initialize() {
        this.panelTabbed.addTab(UtilLocale.getString("TXT_STATUS"), this.getTabStatus());
        this.panelTabbed.addTab(UtilLocale.getString("TXT_GENERAL"), this.getTabGeneral());
        this.panelTabbed.addTab("DECT", this.getTabDECT());
        this.panelTabbed.addTab("WLAN", this.getTabWLAN());
        this.panelTabbed.addTab(UtilLocale.getString("TXT_HARDWARE"), this.getTabHardware());
        this.panelButtonBar.add(this.getButtonCancel());
    }

    public void setRfpDetailData(RfpDataRecord rfpDataRecord) {
        if (rfpDataRecord != null) {
            SiteDataHandler.Site site;
            ImageIcon imageIcon;
            this.labelHeaderBar.setText(String.format(UtilLocale.getString("TXT_RADIO_FIXED_PART") + " #0x%03X", (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID)));
            if (((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_CONNECTED)).booleanValue()) {
                this.labelConnectedStatus.setIcon(GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            } else {
                this.labelConnectedStatus.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            }
            if (((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_DECT_RUNNING)).booleanValue()) {
                this.labelDECTRunningStatus.setIcon(GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            } else {
                this.labelDECTRunningStatus.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            }
            OmiMessage.RFPSyncStateType rFPSyncStateType = (OmiMessage.RFPSyncStateType)((Object)rfpDataRecord.getField(RfpDataRecord.IDX_SYNC_STATE));
            String string = null;
            switch (rFPSyncStateType) {
                case Inactive: {
                    string = UtilLocale.getString("TXT_INACTIVE_20");
                    imageIcon = GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall);
                    break;
                }
                case NotSynced: {
                    string = UtilLocale.getString("TXT_NOT_SYNCED_20");
                    imageIcon = GuiUtilIcon.getIconSearch(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall);
                    break;
                }
                case Searching: {
                    string = UtilLocale.getString("TXT_SEARCHING_20");
                    imageIcon = GuiUtilIcon.getIconSearch(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall);
                    break;
                }
                case Synced: {
                    string = UtilLocale.getString("TXT_SYNCED_20");
                    imageIcon = GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall);
                    break;
                }
                default: {
                    string = "";
                    imageIcon = null;
                }
            }
            this.labelSyncStateStatus.setIcon(imageIcon);
            this.labelSyncStateStatus.setToolTipText(string);
            this.setIconStatusOkInactive((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_OMM_RUNNING), this.labelOMMRunningStatus);
            this.setIconStatusWarning((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_BRANDING_MISMATCH), this.labelBrandingMismatchStatus);
            this.setIconStatusWarning((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_VERSION_MISMATCH), this.labelVersionMismatchStatus);
            this.setIconStatusWarning((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_STANDBY_OMM_MISMATCH), this.labelStandbyOMMMismatchStatus);
            this.setIconStatusOkInactive((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_NEW_SW_REQUEST), this.labelNewSWRequestStatus);
            this.labelEncryptionStatus.setIcon(this.getIconFromRfpCapabilityState((OmiMessage.RfpCapabilityStateType)((Object)rfpDataRecord.getField(RfpDataRecord.IDX_ENCRYPTION_STATE))));
            this.labelAdvancedFeaturesStatus.setIcon(this.getIconFromRfpCapabilityState((OmiMessage.RfpCapabilityStateType)((Object)rfpDataRecord.getField(RfpDataRecord.IDX_ADVANCED_FEATURES_STATE))));
            this.setIconStatusWarning((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_SUPPL_CERT_MISMATCH), this.labelSupplConfMismatchStatus);
            this.setIconStatusOkInactive((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_HAS_WLAN), this.labelHasWLANStatus);
            this.setIconStatusOkError((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_WLAN_RUNNING), this.labelWLANRunningStatus);
            this.setIconStatusWarning((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_WLAN_LINK_NOK), this.labelWLANLinkStatus);
            this.textFieldChannelUsed.setText(String.valueOf((Integer)rfpDataRecord.getField(RfpDataRecord.IDX_WLAN_CHANNEL_USED)));
            this.textFieldPowerUsed.setText(String.valueOf((Integer)rfpDataRecord.getField(RfpDataRecord.IDX_WLAN_POWER_USED)));
            this.textFieldHighThroughputTypeUsed.setText(((OmiMessage.RFPWlanHTUsedType)((Object)rfpDataRecord.getField(RfpDataRecord.IDX_WLAN_HIGH_THROUGHPUT_TYPE_USED))).toString());
            String string2 = (String)rfpDataRecord.getField(RfpDataRecord.IDX_IP_ADDR);
            if (string2 != null) {
                this.textFieldIPAddressStatus.setText(string2);
            } else {
                this.textFieldIPAddressStatus.setText("");
            }
            string2 = (String)rfpDataRecord.getField(RfpDataRecord.IDX_SW_VERSION);
            if (string2 != null) {
                this.textFieldSWVersion.setText(string2);
                this.textFieldSWVersion.setCaretPosition(0);
            } else {
                this.textFieldSWVersion.setText("");
            }
            this.textFieldName.setText((String)rfpDataRecord.getField(RfpDataRecord.IDX_NAME));
            this.textFieldMACAddress.setText((String)rfpDataRecord.getField(RfpDataRecord.IDX_ETH_ADDR));
            this.comboBoxSite.removeAllItems();
            if (this.siteDataHandler != null) {
                site = this.siteDataHandler.getSiteBySiteId((Integer)rfpDataRecord.getField(RfpDataRecord.IDX_SITE));
                this.comboBoxSite.addItem((String)site.getField(1));
            } else if (this.siteDatabase != null) {
                site = this.siteDatabase.getRecordById((Integer)rfpDataRecord.getField(RfpDataRecord.IDX_SITE));
                this.comboBoxSite.addItem((String)site.getField(1));
            }
            this.comboBoxBuilding.removeAllItems();
            this.comboBoxBuilding.addItem((String)rfpDataRecord.getField(RfpDataRecord.IDX_HIERARCHY1));
            this.comboBoxFloor.removeAllItems();
            this.comboBoxFloor.addItem((String)rfpDataRecord.getField(RfpDataRecord.IDX_HIERARCHY2));
            this.comboBoxRoom.removeAllItems();
            this.comboBoxRoom.addItem((String)rfpDataRecord.getField(RfpDataRecord.IDX_HIERARCHY3));
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                this.checkBoxConferenceChannels.setSelected((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_CONFERENCE_CHANNELS));
            }
            this.checkBoxDECTActive.setSelected((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_DECT_ON));
            this.checkBoxPreferredSync.setSelected((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_PREFERRED_SYNC));
            this.checkBoxReflectiveEnv.setSelected((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_REFLECTIVE_ENV));
            this.textFieldCluster.setText(((Integer)rfpDataRecord.getField(RfpDataRecord.IDX_CLUSTER)).toString());
            int n = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_PAGING_AREA);
            if (n == -1) {
                this.comboBoxPagingArea.setEditable(true);
                this.comboBoxPagingArea.setSelectedItem(UtilLocale.getString("TXT_UNASSIGNED"));
                this.comboBoxPagingArea.setEditable(false);
            } else {
                this.comboBoxPagingArea.setEditable(true);
                this.comboBoxPagingArea.setSelectedItem("" + n);
                this.comboBoxPagingArea.setEditable(false);
            }
            this.checkBoxWLANActive.setSelected((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_WLAN_ON));
            this.comboBoxWLANProfile.setEditable(true);
            this.comboBoxWLANProfile.setSelectedItem(rfpDataRecord.getField(RfpDataRecord.IDX_WLAN_PROFILE).toString());
            this.comboBoxWLANProfile.setEditable(false);
            this.checkBoxAntennaDiversity.setSelected((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_WLAN_ANTENNA_DIV));
            this.comboBoxAntenna.setSelectedIndex((Integer)rfpDataRecord.getField(RfpDataRecord.IDX_WLAN_ANTENNA) - 1);
            this.comboBoxChannel.setEditable(true);
            this.comboBoxChannel.setSelectedItem((Integer)rfpDataRecord.getField(RfpDataRecord.IDX_WLAN_CHANNEL));
            this.comboBoxChannel.setEditable(false);
            switch ((Integer)rfpDataRecord.getField(RfpDataRecord.IDX_WLAN_POWER)) {
                default: {
                    this.comboBoxPower.setSelectedIndex(0);
                    break;
                }
                case 50: {
                    this.comboBoxPower.setSelectedIndex(1);
                    break;
                }
                case 25: {
                    this.comboBoxPower.setSelectedIndex(2);
                    break;
                }
                case 12: {
                    this.comboBoxPower.setSelectedIndex(3);
                    break;
                }
                case 6: {
                    this.comboBoxPower.setSelectedIndex(4);
                }
            }
            this.checkBoxHighThroughput.setSelected((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_WLAN_HIGH_THROUGHPUT));
            Object object = rfpDataRecord.getField(RfpDataRecord.IDX_HWTYPE_TEXT);
            if (object != null) {
                this.comboBoxHwType.setEditable(true);
                this.comboBoxHwType.setSelectedItem(object.toString());
                this.comboBoxHwType.setEditable(false);
            } else {
                this.comboBoxHwType.setEditable(true);
                this.comboBoxHwType.setSelectedItem("-");
                this.comboBoxHwType.setEditable(false);
            }
            OmiMessage.RFPRadioTypeType rFPRadioTypeType = (OmiMessage.RFPRadioTypeType)((Object)rfpDataRecord.getField(RfpDataRecord.IDX_RADIO_TYPE));
            if (rFPRadioTypeType != null) {
                this.textFieldRadioType.setText(rFPRadioTypeType.toString());
            } else {
                this.textFieldRadioType.setText("-");
            }
            Boolean bl = (Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_OUTDOOR_TYPE);
            if (bl != null) {
                if (bl.booleanValue()) {
                    this.labelOutdoorTypeStatus.setIcon(GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                } else {
                    this.labelOutdoorTypeStatus.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                }
            } else {
                this.labelOutdoorTypeStatus.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            }
            Boolean bl2 = (Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_HAS_FREQ_SHIFT);
            if (bl2 != null) {
                if (bl2.booleanValue()) {
                    this.labelFrequencyShiftStatus.setIcon(GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                } else {
                    this.labelFrequencyShiftStatus.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                }
            } else {
                this.labelFrequencyShiftStatus.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            }
        } else {
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_RECORD_INVALID"));
            this.textFieldName.setText("");
            this.textFieldMACAddress.setText("");
            this.textFieldCluster.setText("");
            this.comboBoxPagingArea.setEditable(true);
            this.comboBoxPagingArea.setSelectedItem("");
            this.comboBoxPagingArea.setEditable(false);
            this.comboBoxWLANProfile.setEditable(true);
            this.comboBoxWLANProfile.setSelectedItem("");
            this.comboBoxWLANProfile.setEditable(false);
        }
        if (this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(this.getButtonCancel());
            this.getButtonCancel().requestFocusInWindow();
        }
    }

    @Override
    protected AastraPanel getTabWLAN() {
        if (this.tabWLAN == null) {
            super.getTabWLAN();
            this.labelHasWLAN = new AastraLabel();
            this.labelHasWLAN.setBounds(320, 30, 180, 16);
            this.labelHasWLAN.setText(UtilLocale.getString("TXT_WLAN_SUPPORTED"));
            this.labelHasWLANStatus = new AastraLabel();
            this.labelHasWLANStatus.setBounds(500, 30, 30, 16);
            this.labelWLANRunning = new AastraLabel();
            this.labelWLANRunning.setBounds(320, 60, 180, 16);
            this.labelWLANRunning.setText(UtilLocale.getString("TXT_WLAN_RUNNING"));
            this.labelWLANRunningStatus = new AastraLabel();
            this.labelWLANRunningStatus.setBounds(500, 60, 30, 16);
            this.labelWLANLink = new AastraLabel();
            this.labelWLANLink.setBounds(320, 90, 180, 16);
            this.labelWLANLink.setText(UtilLocale.getString("TXT_WLAN_LINK_NOK"));
            this.labelWLANLink.setToolTipText(UtilLocale.getString("TXT_WRONG_ETHERNET_LINK_SPEED"));
            this.labelWLANLinkStatus = new AastraLabel();
            this.labelWLANLinkStatus.setBounds(500, 90, 30, 16);
            this.labelChannelUsed = new AastraLabel();
            this.labelChannelUsed.setBounds(320, 150, 180, 16);
            this.labelChannelUsed.setText(UtilLocale.getString("TXT_CHANNEL_USED"));
            this.textFieldChannelUsed = new AastraTextField();
            this.textFieldChannelUsed.setBounds(500, 150, 50, 18);
            this.labelPowerUsed = new AastraLabel();
            this.labelPowerUsed.setBounds(320, 180, 180, 16);
            this.labelPowerUsed.setText(UtilLocale.getString("TXT_OUTPUT_POWER_USED"));
            this.textFieldPowerUsed = new AastraTextField();
            this.textFieldPowerUsed.setBounds(500, 180, 50, 18);
            this.labeldBm = new AastraLabel();
            this.labeldBm.setBounds(560, 180, 50, 16);
            this.labeldBm.setText(UtilLocale.getString("TXT_DBM"));
            this.labelHighThroughputTypeUsed = new AastraLabel();
            this.labelHighThroughputTypeUsed.setBounds(320, 210, 180, 30);
            this.labelHighThroughputTypeUsed.setText("<html>" + UtilLocale.getString("TXT_HIGH_THROUGHPUT_MODE_USED") + "</html>");
            this.textFieldHighThroughputTypeUsed = new AastraTextField();
            this.textFieldHighThroughputTypeUsed.setBounds(500, 210, 50, 18);
            this.tabWLAN.add(this.labelHasWLAN);
            this.tabWLAN.add(this.labelHasWLANStatus);
            this.tabWLAN.add(this.labelWLANRunning);
            this.tabWLAN.add(this.labelWLANRunningStatus);
            this.tabWLAN.add(this.labelWLANLink);
            this.tabWLAN.add(this.labelWLANLinkStatus);
            this.tabWLAN.add(this.labelChannelUsed);
            this.tabWLAN.add(this.textFieldChannelUsed);
            this.tabWLAN.add(this.labelPowerUsed);
            this.tabWLAN.add(this.textFieldPowerUsed);
            this.tabWLAN.add(this.labeldBm);
            this.tabWLAN.add(this.labelHighThroughputTypeUsed);
            this.tabWLAN.add(this.textFieldHighThroughputTypeUsed);
            UtilSetPanelEditable.setDisabled(this.tabWLAN);
        }
        return this.tabWLAN;
    }

    @Override
    protected AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            super.getTabGeneral();
            UtilSetPanelEditable.setDisabled(this.tabGeneral);
        }
        return this.tabGeneral;
    }

    @Override
    protected AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            super.getButtonCancel();
            this.buttonCancel.setBounds(120, 15, 90, 25);
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (RfpMonitorDetailPanel.this.rfpMainPanel != null) {
                        RfpMonitorDetailPanel.this.rfpMainPanel.removeRfpDetailPanel();
                    }
                }
            });
        }
        return this.buttonCancel;
    }

    @Override
    protected AastraPanel getTabDECT() {
        if (this.tabDECT == null) {
            super.getTabDECT();
            this.tabDECT.add((Component)this.getComboBoxPagingArea(), null);
            this.labelDECTRunning = new AastraLabel();
            this.labelDECTRunning.setBounds(320, 30, 180, 16);
            this.labelDECTRunning.setText(UtilLocale.getString("TXT_DECT_RUNNING"));
            this.labelDECTRunningStatus = new AastraLabel();
            this.labelDECTRunningStatus.setBounds(500, 30, 30, 16);
            this.labelSyncState = new AastraLabel();
            this.labelSyncState.setBounds(320, 60, 180, 16);
            this.labelSyncState.setText(UtilLocale.getString("TXT_SYNCHRONIZATION_STATE"));
            this.labelSyncStateStatus = new AastraLabel();
            this.labelSyncStateStatus.setBounds(500, 60, 30, 16);
            this.tabDECT.add(this.labelDECTRunning);
            this.tabDECT.add(this.labelDECTRunningStatus);
            this.tabDECT.add(this.labelSyncState);
            this.tabDECT.add(this.labelSyncStateStatus);
            UtilSetPanelEditable.setDisabled(this.tabDECT);
        }
        return this.tabDECT;
    }

    private void setIconStatusWarning(Boolean bl, AastraLabel aastraLabel) {
        ImageIcon imageIcon = null;
        if (bl != null) {
            imageIcon = bl != false ? GuiUtilIcon.getIconWarning(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall) : GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall);
        }
        aastraLabel.setIcon(imageIcon);
    }

    private void setIconStatusOkInactive(Boolean bl, AastraLabel aastraLabel) {
        ImageIcon imageIcon = null;
        if (bl != null) {
            imageIcon = bl != false ? GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall) : GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall);
        }
        aastraLabel.setIcon(imageIcon);
    }

    private void setIconStatusOkError(Boolean bl, AastraLabel aastraLabel) {
        ImageIcon imageIcon = null;
        if (bl != null) {
            imageIcon = bl != false ? GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall) : GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall);
        }
        aastraLabel.setIcon(imageIcon);
    }

    private ImageIcon getIconFromRfpCapabilityState(OmiMessage.RfpCapabilityStateType rfpCapabilityStateType) {
        switch (rfpCapabilityStateType) {
            default: {
                return GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall);
            }
            case SupportedInactive: {
                return GuiUtilIcon.getIconOKInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall);
            }
            case NotSupportedError: {
                return GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall);
            }
            case SupportedActive: 
        }
        return GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall);
    }
}

