/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.gui.GuiNavigationPanel;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilMainPanel;
import com.aastra.oamp.guiutil.GuiUtilTableColSelect;
import com.aastra.oamp.rfp.RfpMonitorDetailPanel;
import com.aastra.oamp.rfp.RfpMonitorTaskPanel;
import com.aastra.oamp.rfp.RfpSyncView;
import com.aastra.oamp.util.UtilFilterTable;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.oamp.util.UtilPrint;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.RfpDataHandler;
import com.aastra.omilib.RfpDataNotificationInterface;
import com.aastra.omilib.RfpDataRecord;
import com.aastra.omilib.SiteDataHandler;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;

public class RfpMonitorMainPanel
extends GuiUtilMainPanel
implements RfpDataNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface {
    private static final long serialVersionUID = 1L;
    private RfpDataHandler rfpDataHandler = null;
    private SiteDataHandler siteDataHandler = null;
    private GuiUtilDetailSplitPanel rfpDetailSplitPane = null;
    private AastraScrollPane rfpTablePane = null;
    private RfpMonitorDetailPanel rfpDetailPanel = null;
    private RfpMonitorTaskPanel rfpTaskPanel = null;
    private RfpSyncView syncView = null;
    private GuiNavigationPanel naviBar = null;
    private int currentRfpDetailPanel = -1;
    private int dividerLocation = 0;
    private OmiMessage.PermissionType[] permissionArray = null;
    private OmiManagement omiManagement = null;
    private GuiUtilTableColSelect[] tableColSel = null;

    public RfpMonitorMainPanel(RfpDataHandler rfpDataHandler, SiteDataHandler siteDataHandler) {
        this.rfpDataHandler = rfpDataHandler;
        this.rfpDataHandler.registerDataNotificationListener(this);
        this.siteDataHandler = siteDataHandler;
        this.omiManagement = GuiMain.getOmiManagementObject();
        this.permissionArray = this.omiManagement.getOmmPermissions();
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getRfpDetailSplitPane(), "Center");
        this.add((Component)this.getRfpMonitorTaskPanel(), "East");
    }

    protected GuiUtilTableColSelect[] getTableColumnsSelection() {
        if (this.tableColSel == null) {
            GuiUtilTableColSelect[] guiUtilTableColSelectArray = new GuiUtilTableColSelect[]{new GuiUtilTableColSelect(RfpDataRecord.IDX_RFP_ID, true), new GuiUtilTableColSelect(RfpDataRecord.IDX_ETH_ADDR, true), new GuiUtilTableColSelect(RfpDataRecord.IDX_IP_ADDR, true), new GuiUtilTableColSelect(RfpDataRecord.IDX_NAME, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_SITE, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_SITE_TEXT, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_HIERARCHY1, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_HIERARCHY2, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_HIERARCHY3, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_CLUSTER, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_PAGING_AREA, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_RPN, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_DECT_ON, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_DECT_RUNNING, true, GuiUtilIcon.getIconArrayErrorActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_SYNC_STATE, true, GuiUtilIcon.getIconArrayErrorSearchSearchActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_OMM_RUNNING, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_LICENSE_RFP, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_HWTYPE_TEXT, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_RADIO_TYPE, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_OUTDOOR_TYPE, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_ENCRYPTION_STATE, false, GuiUtilIcon.getIconArray_Inactive_OKInactive_Error_OK()), new GuiUtilTableColSelect(RfpDataRecord.IDX_ADVANCED_FEATURES_STATE, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_HAS_FREQ_SHIFT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_PREFERRED_SYNC, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_REFLECTIVE_ENV, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_CONNECTED, true, GuiUtilIcon.getIconArrayErrorActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_BRANDING_MISMATCH, false, GuiUtilIcon.getIconArrayInactiveWarning()), new GuiUtilTableColSelect(RfpDataRecord.IDX_VERSION_MISMATCH, false, GuiUtilIcon.getIconArrayInactiveWarning()), new GuiUtilTableColSelect(RfpDataRecord.IDX_STANDBY_OMM_MISMATCH, false, GuiUtilIcon.getIconArrayInactiveWarning()), new GuiUtilTableColSelect(RfpDataRecord.IDX_SW_VERSION, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_NEW_SW_REQUEST, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_SUPPL_CERT_MISMATCH, false, GuiUtilIcon.getIconArrayInactiveWarning()), new GuiUtilTableColSelect(RfpDataRecord.IDX_HAS_WLAN, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_WLAN_ON, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_WLAN_RUNNING, false, GuiUtilIcon.getIconArrayErrorActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_WLAN_LINK_NOK, false, GuiUtilIcon.getIconArrayInactiveWarning()), new GuiUtilTableColSelect(RfpDataRecord.IDX_WLAN_PROFILE, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_WLAN_CHANNEL, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_WLAN_CHANNEL_USED, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_WLAN_POWER, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_WLAN_POWER_USED, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_WLAN_ANTENNA_DIV, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_WLAN_ANTENNA, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_WLAN_HIGH_THROUGHPUT, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_WLAN_HIGH_THROUGHPUT_TYPE_USED, false)};
            int n = 0;
            int n2 = guiUtilTableColSelectArray.length;
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                ++n;
            }
            this.tableColSel = Arrays.copyOf(guiUtilTableColSelectArray, n2 + n);
            if (n > 0 && this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(RfpDataRecord.IDX_CONFERENCE_CHANNELS, false, GuiUtilIcon.getIconArrayInactiveActive());
            }
        }
        return this.tableColSel;
    }

    public void showRfpDetails() {
        int n;
        RfpDataRecord rfpDataRecord;
        int n2 = this.table.getSelectedRow();
        if (n2 >= 0 && (rfpDataRecord = this.rfpDataHandler.getRfpDataByIdx(n = this.table.convertRowIndexToModel(n2))) != null) {
            this.createRfpDetailPanel(rfpDataRecord);
        }
    }

    private GuiUtilDetailSplitPanel getRfpDetailSplitPane() {
        if (this.rfpDetailSplitPane == null) {
            this.rfpDetailSplitPane = new GuiUtilDetailSplitPanel(400);
            this.rfpDetailSplitPane.setTopComponent(this.getRfpTablePane());
            this.rfpDetailSplitPane.setBottomComponent(null);
        }
        return this.rfpDetailSplitPane;
    }

    private GuiUtilConfiguratorTable getRfpTable() {
        if (this.table == null) {
            this.table = new GuiUtilConfiguratorTable((Object)this, (Database)this.rfpDataHandler.getDatabase(), this.getTableColumnsSelection(), this.getActiveTableColumns(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpMonitor, this.getTableColumnsSelection(), true), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthRfpMonitor);
            this.table.setColumnFormatString(RfpDataRecord.IDX_RFP_ID, "0x%03X");
            this.table.setColumnFormatString(RfpDataRecord.IDX_RPN, "0x%03X");
            this.table.setNegativeIntAsInvalid(RfpDataRecord.IDX_RPN);
            this.table.setNegativeIntAsInvalid(RfpDataRecord.IDX_PAGING_AREA);
        }
        return this.table;
    }

    private AastraScrollPane getRfpTablePane() {
        if (this.rfpTablePane == null) {
            this.rfpTablePane = new AastraScrollPane(this.getRfpTable());
            this.dividerLocation = this.rfpDetailSplitPane.getHeight() - 400;
            this.rfpTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.rfpTablePane;
    }

    private void enableTableAccess() {
        this.table.setActive(true);
        this.rfpTaskPanel.setTaskButtonConfigureTable(true);
        this.rfpTaskPanel.setTaskButtonFilter(true);
    }

    private void disableTableAccess() {
        this.table.setActive(false);
        this.rfpTaskPanel.setTaskButtonShowDetails(false);
        this.rfpTaskPanel.setTaskButtonShowSync(false);
        this.rfpTaskPanel.setTaskButtonConfigureTable(false);
        this.rfpTaskPanel.setTaskButtonFilter(false);
    }

    protected void configureTableFilter() {
        boolean bl = UtilFilterTable.setFilterItems(this.table, UtilPreferences.getTableFilterValues(UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesRfpMonitor));
        this.rfpTaskPanel.setTaskButtonFilterState(bl, null);
    }

    private AastraPanel getRfpMonitorDetailPanel() {
        if (this.rfpDetailPanel == null) {
            this.rfpDetailPanel = new RfpMonitorDetailPanel(this, this.siteDataHandler);
        }
        return this.rfpDetailPanel;
    }

    private AastraPanel getRfpMonitorTaskPanel() {
        if (this.rfpTaskPanel == null) {
            this.rfpTaskPanel = new RfpMonitorTaskPanel(this, this.getRfpTable(), this.permissionArray);
        }
        return this.rfpTaskPanel;
    }

    public void createRfpDetailPanel(DataRecord dataRecord) {
        if (this.rfpDetailSplitPane.getBottomComponent() != null) {
            this.dividerLocation = this.rfpDetailSplitPane.getDividerLocation();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating RFP monitor detail panel");
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating RFP monitor detail panel");
            this.rfpDetailSplitPane.setBottomComponent(this.getRfpMonitorDetailPanel());
            this.rfpDetailPanel.setDefaultTab();
        }
        if (dataRecord != null) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading RFP[" + (Integer)dataRecord.getField(RfpDataRecord.IDX_RFP_ID) + "]:");
            UtilPrint.printRfpDataRecordString((RfpDataRecord)dataRecord, this);
            this.currentRfpDetailPanel = (Integer)dataRecord.getField(RfpDataRecord.IDX_RFP_ID);
            this.rfpDetailPanel.setRfpDetailData((RfpDataRecord)dataRecord);
        } else {
            this.rfpDetailPanel.setRfpDetailData(null);
        }
        this.rfpDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.rfpDetailSplitPane.validate();
        this.rfpTaskPanel.setTaskButtonShowDetails(false);
    }

    public void removeRfpDetailPanel() {
        this.currentRfpDetailPanel = -1;
        this.dividerLocation = this.rfpDetailSplitPane.getDividerLocation();
        this.rfpDetailSplitPane.setBottomComponent(null);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing RFP monitor detail panel");
        if (this.table.getSelectedRow() >= 0) {
            this.rfpTaskPanel.setTaskButtonShowDetails(true);
        }
    }

    public void taskBarActionShowSync() {
        int n;
        if (this.syncView != null && (n = this.table.getSelectedRowCount()) > 0) {
            int[] nArray = this.table.getSelectedRows();
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = this.table.convertRowIndexToModel(nArray[i]);
                RfpDataRecord rfpDataRecord = this.rfpDataHandler.getRfpDataByIdx(n2);
                nArray2[i] = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID);
            }
            this.syncView.getSyncViewPanel().setSelectedRfpArray(nArray2);
            if (this.naviBar != null) {
                this.naviBar.activateComponent(this.syncView);
            }
        }
    }

    public void setSyncView(RfpSyncView rfpSyncView) {
        this.syncView = rfpSyncView;
    }

    public void setNaviBar(GuiNavigationPanel guiNavigationPanel) {
        this.naviBar = guiNavigationPanel;
    }

    @Override
    protected void componentActivateAction() {
        this.configureTableFilter();
    }

    @Override
    public void processRfpDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "RFP notification: " + dataNotificationEnum.toString() + ",rfpId=" + n);
        switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                break;
            }
            default: {
                RfpDataRecord rfpDataRecord;
                if (this.table.getSelectedRow() == -1) {
                    this.rfpTaskPanel.setTaskButtonShowDetails(false);
                    this.rfpTaskPanel.setTaskButtonShowSync(false);
                }
                if (this.currentRfpDetailPanel != n || (rfpDataRecord = this.rfpDataHandler.getRfpData(n)) == null) break;
                this.rfpDetailPanel.setRfpDetailData(rfpDataRecord);
            }
        }
    }

    @Override
    public void processRfpErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.updateTableInfo();
        if (this.rfpDetailSplitPane.getBottomComponent() != null) {
            if (dataRecord != null) {
                this.createRfpDetailPanel(dataRecord);
            } else {
                this.removeRfpDetailPanel();
            }
        } else {
            this.rfpTaskPanel.setTaskButtonShowDetails(true);
            this.rfpTaskPanel.setTaskButtonShowSync(false);
        }
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        this.createRfpDetailPanel(dataRecord);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        int n;
        this.updateTableInfo();
        if (this.rfpDetailSplitPane.getBottomComponent() != null) {
            if (dataRecord != null) {
                this.createRfpDetailPanel(dataRecord);
            } else {
                this.removeRfpDetailPanel();
            }
        }
        if ((n = this.table.getSelectedRowCount()) == 1) {
            this.rfpTaskPanel.setTaskButtonShowDetails(true);
            this.rfpTaskPanel.setTaskButtonShowSync(false);
        } else {
            this.rfpTaskPanel.setTaskButtonShowDetails(false);
            if (n > 1) {
                this.rfpTaskPanel.setTaskButtonShowSync(true);
            } else {
                this.rfpTaskPanel.setTaskButtonShowSync(false);
            }
        }
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        int n = this.table.getSelectedRowCount();
        if (n == 1) {
            this.rfpTaskPanel.setTaskButtonShowDetails(true);
            this.rfpTaskPanel.setTaskButtonShowSync(false);
        } else {
            this.rfpTaskPanel.setTaskButtonShowDetails(false);
            if (n > 1) {
                this.rfpTaskPanel.setTaskButtonShowSync(true);
                if (this.rfpDetailSplitPane.getBottomComponent() != null) {
                    this.removeRfpDetailPanel();
                }
            } else {
                this.rfpTaskPanel.setTaskButtonShowSync(false);
            }
        }
    }
}

