/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.gui.GuiNavigationPanel;
import com.aastra.oamp.gui.GuiProgressDlg;
import com.aastra.oamp.gui.GuiStatusBar;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.rfp.RfpPlacementImgMgmtTaskPanel;
import com.aastra.oamp.rfp.RfpPlacementViewPanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.RfpDataRecord;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraFileChooser;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;

public class RfpPlacementImgMgmtPanel
extends AastraPanel
implements ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface,
GuiComponentActivationInterface {
    private static final long serialVersionUID = 1L;
    private AastraScrollPane tablePane = null;
    private RfpPlacementImgMgmtTaskPanel taskPanel = null;
    private RfpPlacementViewPanel imagePanel = null;
    private ConfiguratorTable table = null;
    private GuiNavigationPanel naviBar = null;
    private GuiStatusBar guiStatusBar = GuiMain.getGuiStatusBarObject();
    private boolean imageProcessingInProgress = false;
    public static int[] rfpTablePlacementIdxArrayDefault = new int[]{0, 1};

    public RfpPlacementImgMgmtPanel(RfpPlacementViewPanel rfpPlacementViewPanel) {
        this.imagePanel = rfpPlacementViewPanel;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getTablePane(), "Center");
        this.add((Component)this.getTaskPanel(), "East");
        this.taskPanel.initializeRfpMonitorMainPanelObject(this, this.getImgTable());
    }

    private void updateTaskbar() {
        int n = this.table.getSelectedRowCount();
        this.taskPanel.setTaskButtonShowImage(n == 1);
        this.taskPanel.setTaskButtonScaleView(n == 1);
        this.taskPanel.setTaskButtonSetDefaultZoom(n >= 1);
        this.taskPanel.setTaskButtonRemoveImage(n >= 1);
        if (!this.imageProcessingInProgress) {
            this.taskPanel.setTaskButtonGenerate(n >= 1);
        } else {
            this.taskPanel.setTaskButtonGenerate(false);
        }
        this.taskPanel.setTaskButtonImportProject(true);
        this.taskPanel.setTaskButtonExportProject(this.imagePanel.getProjectFileRead());
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.updateTaskbar();
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        RfpPlacementViewPanel.PositioningImage positioningImage = (RfpPlacementViewPanel.PositioningImage)dataRecord;
        this.imagePanel.setActiveImage(positioningImage.id);
        if (this.naviBar != null) {
            this.naviBar.activateComponent(this.imagePanel);
        }
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.updateTaskbar();
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        this.updateTaskbar();
    }

    private ConfiguratorTable getImgTable() {
        if (this.table == null) {
            this.table = new ConfiguratorTable(this.imagePanel.getImageDb());
            this.table.registerEventListener(this);
            int[] nArray = rfpTablePlacementIdxArrayDefault;
            this.table.setColumnArr(nArray, nArray.length);
            TableColumn tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setMinWidth(50);
            tableColumn.setMaxWidth(50);
            this.table.registerMultiSelectListener(this);
            this.table.setActive(true);
        }
        return this.table;
    }

    private AastraScrollPane getTablePane() {
        if (this.tablePane == null) {
            RfpPlacementViewPanel.PositioningImage.setTableHeaderText(0, UtilLocale.getString("TXT_ID"));
            RfpPlacementViewPanel.PositioningImage.setTableHeaderText(1, UtilLocale.getString("TXT_NAME_20"));
            this.tablePane = new AastraScrollPane(this.getImgTable());
        }
        return this.tablePane;
    }

    private AastraPanel getTaskPanel() {
        if (this.taskPanel == null) {
            this.taskPanel = new RfpPlacementImgMgmtTaskPanel();
            this.taskPanel.setTaskButtonAddImage(true);
            this.taskPanel.setTaskButtonRemoveImage(false);
            this.taskPanel.setTaskButtonGenerate(false);
            this.taskPanel.setTaskButtonShowImage(false);
            this.taskPanel.setTaskButtonScaleView(false);
            this.taskPanel.setTaskButtonSetDefaultZoom(false);
        }
        return this.taskPanel;
    }

    public void taskBarActionShowPlacement() {
        int n;
        if (this.imagePanel != null && (n = this.table.getSelectedRowCount()) == 1) {
            int[] nArray = this.table.getSelectedRows();
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = this.table.convertRowIndexToModel(nArray[i]);
                RfpPlacementViewPanel.PositioningImage positioningImage = (RfpPlacementViewPanel.PositioningImage)this.imagePanel.getImageDb().getRecordByIdx(n2);
                nArray2[i] = (Integer)positioningImage.getField(RfpDataRecord.IDX_RFP_ID);
            }
            this.imagePanel.setActiveImage(nArray2[0]);
            if (this.naviBar != null) {
                this.naviBar.activateComponent(this.imagePanel);
            }
        }
    }

    public void taskBarActionShowScaleView() {
        int n;
        if (this.imagePanel != null && (n = this.table.getSelectedRowCount()) == 1) {
            int[] nArray = this.table.getSelectedRows();
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = this.table.convertRowIndexToModel(nArray[i]);
                RfpPlacementViewPanel.PositioningImage positioningImage = (RfpPlacementViewPanel.PositioningImage)this.imagePanel.getImageDb().getRecordByIdx(n2);
                nArray2[i] = (Integer)positioningImage.getField(0);
            }
            this.imagePanel.setActiveImage(nArray2[0]);
            this.imagePanel.setImageScalingMode(true);
            if (this.naviBar != null) {
                this.naviBar.activateComponent(this.imagePanel);
            }
        }
    }

    public void taskBarActionSetDefaultZoom(double d) {
        GuiUtilDialog guiUtilDialog;
        int n = this.table.getSelectedRowCount();
        if (n >= 1 && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_SET_DEFAULT_SIZE_FOR_SELECTED_IMAGES_?"), true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            int[] nArray = this.table.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = this.table.convertRowIndexToModel(nArray[i]);
                RfpPlacementViewPanel.PositioningImage positioningImage = (RfpPlacementViewPanel.PositioningImage)this.imagePanel.getImageDb().getRecordByIdx(n2);
                positioningImage.zoomScale = d;
            }
            this.imagePanel.writeProjectFile(null, true);
        }
    }

    public void taskBarActionImportProject() {
        AastraFileChooser aastraFileChooser = new AastraFileChooser(0, UtilLocale.getString("TXT_SELECT_FILE"));
        aastraFileChooser.addChoosableFileFilter(new ProjectFileFilter());
        if (aastraFileChooser.showOpenDialog(this) == 0) {
            File file = aastraFileChooser.getCurrentDirectory();
            this.imagePanel.clearProject();
            this.imagePanel.readProjectFile(file.getAbsolutePath(), aastraFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private boolean copyFile(String string, String string2) {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        boolean bl = false;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Copying " + string + " to " + string2 + " failed");
            return false;
        }
        if (fileInputStream != null) {
            try {
                fileOutputStream = new FileOutputStream(string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Copying " + string + " to " + string2 + " failed");
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
            if (fileOutputStream != null) {
                byte[] byArray = new byte[1024];
                int n = 0;
                try {
                    while ((n = fileInputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                catch (IOException iOException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Copying " + string + " to " + string2 + " failed");
                }
                bl = true;
            }
        }
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public void taskBarActionExportProject() {
        AastraFileChooser aastraFileChooser = new AastraFileChooser(1, UtilLocale.getString("TXT_SELECT_FILE"));
        if (aastraFileChooser.showOpenDialog(this) == 0) {
            File file = aastraFileChooser.getSelectedFile();
            GuiProgressDlg guiProgressDlg = new GuiProgressDlg(UtilLocale.getString("TXT_EXPORTING_PROJECT_IN_PROGRESS"), false, true);
            this.imageProcessingInProgress = true;
            this.updateTaskbar();
            ProjectExporter projectExporter = new ProjectExporter(file.getAbsolutePath(), guiProgressDlg);
            this.imagePanel.writeProjectFile(file.getAbsolutePath(), false);
            int n = this.imagePanel.getImageDb().noOfImages;
            if (n > 1) {
                projectExporter.execute();
                guiProgressDlg.setVisible(true);
                if (this.imageProcessingInProgress) {
                    projectExporter.stop = true;
                }
            } else {
                projectExporter.doInBackground();
                projectExporter.done();
            }
        }
    }

    public void taskBarActionAddImage() {
        File file;
        AastraFileChooser aastraFileChooser = new AastraFileChooser(0, UtilLocale.getString("TXT_SELECT_FILE"));
        aastraFileChooser.addChoosableFileFilter(new ImageFileFilter());
        if (this.imagePanel.getImageSoureDir() != null && (file = new File(this.imagePanel.getImageSoureDir())).exists()) {
            aastraFileChooser.setCurrentDirectory(file);
        }
        aastraFileChooser.setMultiSelectionEnabled(true);
        if (aastraFileChooser.showOpenDialog(this) == 0) {
            file = aastraFileChooser.getCurrentDirectory();
            this.imagePanel.setImageSoureDir(file.getAbsolutePath());
            File[] fileArray = aastraFileChooser.getSelectedFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getAbsolutePath();
                if (!fileArray[i].isFile()) {
                    GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_FILE_*_NOT_FOUND"), fileArray[i]));
                    continue;
                }
                if (this.imagePanel.addImage(string, false)) continue;
                GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_IMAGE_*_TOO_BIG"), fileArray[i]));
            }
            this.imagePanel.showActImage();
        }
    }

    public void taskBarActionRemoveImage() {
        GuiUtilDialog guiUtilDialog;
        int n = this.table.getSelectedRowCount();
        if (n > 0 && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_REMOVE_SELECTED_IMAGES_?"), true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            int n2;
            int[] nArray = this.table.getSelectedRows();
            int n3 = nArray.length;
            Integer[] integerArray = new Integer[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = this.table.convertRowIndexToModel(nArray[n2]);
                RfpPlacementViewPanel.PositioningImage positioningImage = (RfpPlacementViewPanel.PositioningImage)this.imagePanel.getImageDb().getRecordByIdx(n4);
                integerArray[n2] = (Integer)positioningImage.getField(0);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.imagePanel.removeImage(integerArray[n2]);
            }
        }
    }

    public void taskBarActionGenerateLocatingData() {
        this.imagePanel.writeProjectFile(null, true);
        int n = this.table.getSelectedRowCount();
        if (n > 0) {
            File file;
            AastraFileChooser aastraFileChooser = new AastraFileChooser(1, UtilLocale.getString("TXT_SELECT_FILE"));
            if (this.imagePanel.getImageOutputDir() != null && (file = new File(this.imagePanel.getImageOutputDir())).exists()) {
                aastraFileChooser.setSelectedFile(file);
            }
            if (aastraFileChooser.showOpenDialog(this) == 0) {
                Object object;
                file = aastraFileChooser.getSelectedFile();
                this.imagePanel.setImageOutputDir(file.getAbsolutePath());
                int[] nArray = this.table.getSelectedRows();
                int n2 = nArray.length;
                this.imagePanel.writeProjectFile(file.getAbsolutePath(), false);
                Integer[] integerArray = new Integer[n2];
                for (int i = 0; i < n2; ++i) {
                    int n3 = this.table.convertRowIndexToModel(nArray[i]);
                    object = (RfpPlacementViewPanel.PositioningImage)this.imagePanel.getImageDb().getRecordByIdx(n3);
                    integerArray[i] = (Integer)((RfpPlacementViewPanel.PositioningImage)object).getField(0);
                }
                GuiProgressDlg guiProgressDlg = new GuiProgressDlg(UtilLocale.getString("TXT_GENERATING_LOCATING_IMAGES_IN_PROGRESS"), false, true);
                this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_BUSY, UtilLocale.getString("TXT_GENERATING_LOCATING_IMAGES_IN_PROGRESS"));
                this.imageProcessingInProgress = true;
                this.updateTaskbar();
                object = new ImageGenerator(integerArray, file.getAbsolutePath(), guiProgressDlg);
                ((SwingWorker)object).execute();
                guiProgressDlg.setVisible(true);
                if (this.imageProcessingInProgress) {
                    ((ImageGenerator)object).stop = true;
                }
            }
        }
    }

    public void setNaviBar(GuiNavigationPanel guiNavigationPanel) {
        this.naviBar = guiNavigationPanel;
    }

    @Override
    public void componentActivated(Component component) {
        this.imagePanel.triggerProjectFileRead();
        this.updateTaskbar();
    }

    @Override
    public void componentDeactivated() {
    }

    class ImageGenerator
    extends SwingWorker<Long, Object> {
        public Integer[] idArr;
        public String path;
        public GuiProgressDlg progress = null;
        public boolean stop = false;
        public String error = null;

        ImageGenerator(Integer[] integerArray, String string, GuiProgressDlg guiProgressDlg) {
            this.idArr = integerArray;
            this.path = string;
            this.progress = guiProgressDlg;
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("progress".equals(propertyChangeEvent.getPropertyName())) {
                        ImageGenerator.this.progress.setValue((Integer)propertyChangeEvent.getNewValue());
                    }
                }
            });
        }

        @Override
        public Long doInBackground() {
            for (int i = 0; i < this.idArr.length; ++i) {
                if (!RfpPlacementImgMgmtPanel.this.imagePanel.generateLocatingImages(this.idArr[i], this.path)) {
                    RfpPlacementViewPanel.PositioningImage positioningImage = RfpPlacementImgMgmtPanel.this.imagePanel.getImageDb().getRecordById(this.idArr[i]);
                    this.error = UtilLocale.getString("TXT_FILE_ACCESS_FAILED") + " (" + positioningImage.fileName + ")";
                    return 0L;
                }
                if (this.stop) {
                    return 0L;
                }
                if (this.progress == null) continue;
                this.setProgress((i + 1) * 100 / this.idArr.length);
            }
            return 0L;
        }

        @Override
        protected void done() {
            try {
                if (this.error != null) {
                    GuiInfoConsole.showError(this.error);
                } else {
                    GuiInfoConsole.showInfo(UtilLocale.getString("TXT_GENERATING_LOCATING_IMAGES_SUCCESSFUL"));
                }
                if (this.progress != null) {
                    this.progress.setVisible(false);
                }
                RfpPlacementImgMgmtPanel.this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
                RfpPlacementImgMgmtPanel.this.imageProcessingInProgress = false;
                RfpPlacementImgMgmtPanel.this.updateTaskbar();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ImageFileFilter
    extends FileFilter {
        ImageFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName().toLowerCase();
            return string.endsWith(".png") || string.endsWith(".jpg") || string.endsWith(".jpeg");
        }

        @Override
        public String getDescription() {
            return "*.png;*.jpg;*.jpeg";
        }
    }

    class ProjectExporter
    extends SwingWorker<Long, Object> {
        public String path;
        public GuiProgressDlg progress = null;
        public boolean stop = false;
        public String error = null;

        ProjectExporter(String string, GuiProgressDlg guiProgressDlg) {
            this.path = string;
            this.progress = guiProgressDlg;
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("progress".equals(propertyChangeEvent.getPropertyName())) {
                        ProjectExporter.this.progress.setValue((Integer)propertyChangeEvent.getNewValue());
                    }
                }
            });
        }

        @Override
        public Long doInBackground() {
            int n = ((RfpPlacementImgMgmtPanel)RfpPlacementImgMgmtPanel.this).imagePanel.getImageDb().noOfImages;
            for (int i = 0; i < n; ++i) {
                RfpPlacementViewPanel.PositioningImage positioningImage = (RfpPlacementViewPanel.PositioningImage)RfpPlacementImgMgmtPanel.this.imagePanel.getImageDb().getRecordByIdx(i);
                if (positioningImage != null) {
                    String string = positioningImage.fileName;
                    String[] stringArray = string.split(Pattern.quote(File.separator));
                    String string2 = this.path + File.separator + stringArray[stringArray.length - 1];
                    if (!string.equals(string2) && !RfpPlacementImgMgmtPanel.this.copyFile(string, string2)) {
                        this.error = String.format(UtilLocale.getString("TXT_FILE_*_NOT_FOUND"), string);
                        break;
                    }
                }
                if (this.progress != null) {
                    this.setProgress((i + 1) * 100 / n);
                }
                if (!this.stop) continue;
                return 0L;
            }
            return 0L;
        }

        @Override
        protected void done() {
            try {
                if (this.error != null) {
                    GuiInfoConsole.showError(this.error);
                } else {
                    GuiInfoConsole.showInfo(UtilLocale.getString("TXT_PROJECT_EXPORT_SUCCESSFUL"));
                }
                if (this.progress != null) {
                    this.progress.setVisible(false);
                }
                RfpPlacementImgMgmtPanel.this.imageProcessingInProgress = false;
                RfpPlacementImgMgmtPanel.this.updateTaskbar();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ProjectFileFilter
    extends FileFilter {
        ProjectFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return string.equals("locating_project.xml");
        }

        @Override
        public String getDescription() {
            return "locating_project.xml";
        }
    }
}

