/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.guiutil.GuiUtilTaskPanel;
import com.aastra.oamp.rfp.RfpPlacementImgMgmtPanel;
import com.aastra.oamp.rfp.RfpPlacementViewPanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraLinkButton;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraSlider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RfpPlacementImgMgmtTaskPanel
extends GuiUtilTaskPanel {
    private static final long serialVersionUID = 1L;
    private AastraPanel imgMgmtPanel = null;
    private ConfiguratorTable imgTable = null;
    private AastraLinkButton buttonShowImage = null;
    private AastraLinkButton buttonAddImage = null;
    private AastraLinkButton buttonRemoveImage = null;
    private AastraLinkButton buttonImageScaleView = null;
    private AastraLinkButton buttonSetDefaultZoom = null;
    private AastraLinkButton buttonGenerateLocatingImages = null;
    private AastraLinkButton buttonExportProject = null;
    private AastraLinkButton buttonImportProject = null;
    private AastraSlider sliderDefaultZoom = null;
    private AastraLabel labelDefaultZoom = null;
    private AastraLabel labelDefaultZoomValue = null;
    private double defaultZoom = 2.0;

    public RfpPlacementImgMgmtTaskPanel() {
        this.initialize();
    }

    private void initialize() {
        this.add(this.getButtonShowImage());
        this.add(this.getButtonAddImage());
        this.add(this.getButtonRemoveImage());
        this.add(this.getButtonGenerateLocatingData());
        this.add(this.getButtonImportProject());
        this.add(this.getButtonExportProject());
        this.add(this.getButtonImageScaleView());
        this.add(this.getButtonSetDefaultZoom());
        this.add(this.getSliderDefaultZoom());
        this.labelDefaultZoomValue = new AastraLabel();
        this.labelDefaultZoomValue.setBounds(65, 290, 100, 16);
        this.labelDefaultZoomValue.setText(UtilLocale.getString("TXT_DEFAULT_20"));
        this.add(this.labelDefaultZoomValue);
        this.labelDefaultZoom = new AastraLabel();
        this.labelDefaultZoom.setBounds(25, 330, 146, 16);
        this.labelDefaultZoom.setText(UtilLocale.getString("TXT_OVERVIEW_SIZE_20"));
        this.add(this.labelDefaultZoom);
        this.setDefaultZoom();
    }

    public void initializeRfpMonitorMainPanelObject(AastraPanel aastraPanel, ConfiguratorTable configuratorTable) {
        if (this.imgMgmtPanel == null) {
            this.imgMgmtPanel = aastraPanel;
        }
        if (this.imgTable == null) {
            this.imgTable = configuratorTable;
        }
    }

    private AastraLinkButton getButtonShowImage() {
        if (this.buttonShowImage == null) {
            this.buttonShowImage = this.createTaskButtonDisabled(UtilLocale.getString("TXT_SHOW_IMAGE_20"));
            this.buttonShowImage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((RfpPlacementImgMgmtPanel)RfpPlacementImgMgmtTaskPanel.this.imgMgmtPanel).taskBarActionShowPlacement();
                }
            });
        }
        return this.buttonShowImage;
    }

    private AastraLinkButton getButtonImageScaleView() {
        if (this.buttonImageScaleView == null) {
            this.buttonImageScaleView = this.createTaskButtonDisabled(UtilLocale.getString("TXT_ADJUST_OVERVIEW_SIZE_20"));
            this.buttonImageScaleView.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((RfpPlacementImgMgmtPanel)RfpPlacementImgMgmtTaskPanel.this.imgMgmtPanel).taskBarActionShowScaleView();
                }
            });
        }
        return this.buttonImageScaleView;
    }

    private AastraLinkButton getButtonSetDefaultZoom() {
        if (this.buttonSetDefaultZoom == null) {
            this.buttonSetDefaultZoom = this.createTaskButtonDisabled(UtilLocale.getString("TXT_SET_OVERVIEW_SIZE_20"));
            this.buttonSetDefaultZoom.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((RfpPlacementImgMgmtPanel)RfpPlacementImgMgmtTaskPanel.this.imgMgmtPanel).taskBarActionSetDefaultZoom(RfpPlacementViewPanel.defaultZoom);
                }
            });
        }
        return this.buttonSetDefaultZoom;
    }

    private void setDefaultZoom() {
        this.labelDefaultZoomValue.setText(String.format("%5.2fx", RfpPlacementViewPanel.defaultZoom));
    }

    public double getDefaultZoom() {
        return RfpPlacementViewPanel.defaultZoom;
    }

    public void updateDefaultZoomSlider() {
        this.sliderDefaultZoom.setValue((int)(RfpPlacementViewPanel.defaultZoom * 10.0));
        this.setDefaultZoom();
    }

    private AastraSlider getSliderDefaultZoom() {
        if (this.sliderDefaultZoom == null) {
            this.sliderDefaultZoom = new AastraSlider();
            this.sliderDefaultZoom.setBounds(19, 306, 146, 16);
            this.sliderDefaultZoom.setMaximum(50);
            this.sliderDefaultZoom.setMinimum(10);
            this.sliderDefaultZoom.setValue((int)(RfpPlacementViewPanel.defaultZoom * 10.0));
            this.sliderDefaultZoom.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    AastraSlider aastraSlider = (AastraSlider)changeEvent.getSource();
                    RfpPlacementViewPanel.defaultZoom = 1.0 * (double)aastraSlider.getValue() / 10.0;
                    RfpPlacementImgMgmtTaskPanel.this.setDefaultZoom();
                }
            });
        }
        return this.sliderDefaultZoom;
    }

    private AastraLinkButton getButtonExportProject() {
        if (this.buttonExportProject == null) {
            this.buttonExportProject = this.createTaskButtonDisabled(UtilLocale.getString("TXT_EXPORT_PROJECT_20"));
            this.buttonExportProject.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((RfpPlacementImgMgmtPanel)RfpPlacementImgMgmtTaskPanel.this.imgMgmtPanel).taskBarActionExportProject();
                }
            });
        }
        return this.buttonExportProject;
    }

    private AastraLinkButton getButtonImportProject() {
        if (this.buttonImportProject == null) {
            this.buttonImportProject = this.createTaskButtonDisabled(UtilLocale.getString("TXT_IMPORT_PROJECT_20"));
            this.buttonImportProject.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((RfpPlacementImgMgmtPanel)RfpPlacementImgMgmtTaskPanel.this.imgMgmtPanel).taskBarActionImportProject();
                }
            });
        }
        return this.buttonImportProject;
    }

    public void setTaskButtonShowImage(boolean bl) {
        this.buttonShowImage.setEnabled(bl);
    }

    public void setTaskButtonAddImage(boolean bl) {
        this.buttonAddImage.setEnabled(bl);
    }

    public void setTaskButtonRemoveImage(boolean bl) {
        this.buttonRemoveImage.setEnabled(bl);
    }

    public void setTaskButtonGenerate(boolean bl) {
        this.buttonGenerateLocatingImages.setEnabled(bl);
    }

    public void setTaskButtonScaleView(boolean bl) {
        this.buttonImageScaleView.setEnabled(bl);
    }

    public void setTaskButtonSetDefaultZoom(boolean bl) {
        this.buttonSetDefaultZoom.setEnabled(bl);
    }

    public void setTaskButtonExportProject(boolean bl) {
        this.buttonExportProject.setEnabled(bl);
    }

    public void setTaskButtonImportProject(boolean bl) {
        this.buttonImportProject.setEnabled(bl);
    }

    private AastraLinkButton getButtonAddImage() {
        if (this.buttonAddImage == null) {
            this.buttonAddImage = this.createTaskButtonDisabled(UtilLocale.getString("TXT_ADD_IMAGE_20"));
            this.buttonAddImage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((RfpPlacementImgMgmtPanel)RfpPlacementImgMgmtTaskPanel.this.imgMgmtPanel).taskBarActionAddImage();
                }
            });
        }
        return this.buttonAddImage;
    }

    private AastraLinkButton getButtonRemoveImage() {
        if (this.buttonRemoveImage == null) {
            this.buttonRemoveImage = this.createTaskButtonDisabled(UtilLocale.getString("TXT_REMOVE_IMAGE_20"));
            this.buttonRemoveImage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((RfpPlacementImgMgmtPanel)RfpPlacementImgMgmtTaskPanel.this.imgMgmtPanel).taskBarActionRemoveImage();
                }
            });
        }
        return this.buttonRemoveImage;
    }

    private AastraLinkButton getButtonGenerateLocatingData() {
        if (this.buttonGenerateLocatingImages == null) {
            this.buttonGenerateLocatingImages = this.createTaskButtonDisabled(UtilLocale.getString("TXT_GENERATE_20"), UtilLocale.getString("TXT_GENERATE_LOCATING_IMAGES"));
            this.buttonGenerateLocatingImages.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((RfpPlacementImgMgmtPanel)RfpPlacementImgMgmtTaskPanel.this.imgMgmtPanel).taskBarActionGenerateLocatingData();
                }
            });
        }
        return this.buttonGenerateLocatingImages;
    }
}

