/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.gui.GuiNavigationPanel;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilMainPanel;
import com.aastra.oamp.guiutil.GuiUtilTableColSelect;
import com.aastra.oamp.guiutil.GuiUtilTableConfigDlgDefault;
import com.aastra.oamp.rfp.DevicePositionPanel;
import com.aastra.oamp.rfp.RfpPlacementTaskPanel;
import com.aastra.oamp.rfp.RfpPlacementViewPanel;
import com.aastra.oamp.util.UtilFilterTable;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.RfpDataHandler;
import com.aastra.omilib.RfpDataNotificationInterface;
import com.aastra.omilib.RfpDataRecord;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;

public class RfpPlacementTablePanel
extends GuiUtilMainPanel
implements RfpDataNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface,
GuiComponentActivationInterface {
    private static final long serialVersionUID = 1L;
    private RfpDataHandler rfpDataHandler = null;
    private AastraScrollPane tablePane = null;
    private RfpPlacementTaskPanel taskPanel = null;
    private GuiUtilConfiguratorTable table = null;
    private RfpPlacementViewPanel placementView = null;
    private GuiNavigationPanel naviBar = null;
    private OmiMessage.PermissionType[] permissionArray = null;
    private UtilPreferences.TableFilterValuesKeyTypeEnum key = null;
    private static final GuiUtilTableColSelect[] tableColSel = new GuiUtilTableColSelect[]{new GuiUtilTableColSelect(RfpDataRecord.IDX_RFP_ID, true), new GuiUtilTableColSelect(RfpDataRecord.IDX_ETH_ADDR, true), new GuiUtilTableColSelect(RfpDataRecord.IDX_IP_ADDR, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_NAME, true), new GuiUtilTableColSelect(RfpDataRecord.IDX_SITE, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_SITE_TEXT, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_HIERARCHY1, true), new GuiUtilTableColSelect(RfpDataRecord.IDX_HIERARCHY2, true), new GuiUtilTableColSelect(RfpDataRecord.IDX_HIERARCHY3, true), new GuiUtilTableColSelect(RfpDataRecord.IDX_CLUSTER, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_PAGING_AREA, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_RPN, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_LICENSE_RFP, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_HWTYPE_TEXT, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_RADIO_TYPE, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_OUTDOOR_TYPE, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_PREFERRED_SYNC, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_REFLECTIVE_ENV, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_CONNECTED, false, GuiUtilIcon.getIconArrayErrorActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_SW_VERSION, false), new GuiUtilTableColSelect(RfpDataRecord.IDX_NEW_SW_REQUEST, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_HAS_WLAN, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_WLAN_ON, false, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(RfpDataRecord.IDX_POSITIONED, true, GuiUtilIcon.getIconArrayInactiveActive())};

    public RfpPlacementTablePanel(Object object) {
        this.rfpDataHandler = (RfpDataHandler)object;
        this.rfpDataHandler.registerDataNotificationListener(this);
        this.key = UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesRfpPlacement;
        this.permissionArray = GuiMain.getOmiManagementObject().getOmmPermissions();
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getTablePane(), "Center");
        this.add((Component)this.getRfpMonitorTaskPanel(), "East");
        this.taskPanel.initializeRfpMonitorMainPanelObject(this, this.getTable());
    }

    @Override
    public void processRfpDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "RFP notification: " + dataNotificationEnum.toString() + ",rfpId=" + n);
        switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                break;
            }
            default: {
                if (this.table.getSelectedRow() != -1) break;
                this.taskPanel.setTaskButtonShowImage(false);
            }
        }
    }

    @Override
    public void processRfpErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
    }

    private void updateTaskbar() {
        int n = this.table.getSelectedRowCount();
        this.taskPanel.setTaskButtonShowImage(n >= 1);
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.updateTaskbar();
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        int n = -1;
        n = ((RfpDataRecord)dataRecord).locatingImageId;
        if (n != -1) {
            this.placementView.setActiveImage(n);
            if (this.naviBar != null) {
                this.naviBar.activateComponent(this.placementView);
            }
        }
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.updateTaskbar();
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        this.updateTaskbar();
    }

    private GuiUtilConfiguratorTable getTable() {
        if (this.table == null) {
            this.table = new GuiUtilConfiguratorTable((Object)this, (Database)this.rfpDataHandler.getDatabase(), tableColSel, this.getActiveTableColumns(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpPlacement, tableColSel), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthRfpPlacement);
            this.table.setColumnFormatString(RfpDataRecord.IDX_RFP_ID, "0x%03X");
            this.table.setColumnFormatString(RfpDataRecord.IDX_RPN, "0x%03X");
            this.table.setNegativeIntAsInvalid(RfpDataRecord.IDX_RPN);
            this.table.setNegativeIntAsInvalid(RfpDataRecord.IDX_PAGING_AREA);
        }
        return this.table;
    }

    private AastraScrollPane getTablePane() {
        if (this.tablePane == null) {
            this.tablePane = new AastraScrollPane(this.getTable());
        }
        return this.tablePane;
    }

    private void enableTableAccess() {
        this.table.setActive(true);
        this.taskPanel.setTaskButtonConfigureTable(true);
        this.taskPanel.setTaskButtonFilter(true);
    }

    private void disableTableAccess() {
        this.table.setActive(false);
        this.taskPanel.setTaskButtonShowImage(false);
        this.taskPanel.setTaskButtonConfigureTable(false);
        this.taskPanel.setTaskButtonFilter(false);
    }

    protected void configureTableFilter() {
        boolean bl = UtilFilterTable.setFilterItems(this.table, UtilPreferences.getTableFilterValues(this.key));
        this.taskPanel.setTaskButtonFilter(bl, null);
    }

    private AastraPanel getRfpMonitorTaskPanel() {
        if (this.taskPanel == null) {
            this.taskPanel = new RfpPlacementTaskPanel(this.permissionArray);
        }
        return this.taskPanel;
    }

    public void taskBarActionShowPlacement() {
        if (this.placementView != null) {
            if (!this.placementView.imageLoaded()) {
                return;
            }
            int n = this.placementView.getActImageId();
            int n2 = this.table.getSelectedRowCount();
            if (n2 > 0) {
                int n3;
                boolean bl = false;
                int[] nArray = this.table.getSelectedRows();
                int[] nArray2 = new int[nArray.length];
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    Object object;
                    int n4 = this.table.convertRowIndexToModel(nArray[n3]);
                    boolean bl2 = false;
                    DevicePositionPanel.DeviceType deviceType = null;
                    int n5 = -1;
                    RfpDataRecord rfpDataRecord = null;
                    rfpDataRecord = this.rfpDataHandler.getRfpDataByIdx(n4);
                    nArray2[n3] = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID);
                    bl2 = (Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_POSITIONED);
                    deviceType = DevicePositionPanel.DeviceType.RFP;
                    n5 = rfpDataRecord.locatingImageId;
                    if (!bl2) continue;
                    if (n == n5) {
                        bl2 = false;
                        continue;
                    }
                    if (!bl) {
                        object = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_REASSIGN_RFPS_TO_NEW_IMAGE_?"), true);
                        if (((GuiUtilDialog)object).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionNo) {
                            return;
                        }
                        bl = true;
                    }
                    if ((object = this.placementView.getImageDb().getRecordById(n5)) != null) {
                        ((RfpPlacementViewPanel.PositioningImage)object).removeDevice(nArray2[n3], deviceType);
                    }
                    rfpDataRecord.locatingXPos = 0;
                    rfpDataRecord.locatingYPos = 0;
                }
                for (n3 = 0; n3 < nArray2.length; ++n3) {
                    RfpDataRecord rfpDataRecord = this.rfpDataHandler.getRfpData(nArray2[n3]);
                    rfpDataRecord.setField(RfpDataRecord.IDX_POSITIONED, (Object)true);
                }
                this.placementView.setSelectedRfpArray(nArray2);
                if (this.naviBar != null) {
                    this.naviBar.activateComponent(this.placementView);
                }
            }
        }
    }

    public void setPlacementView(RfpPlacementViewPanel rfpPlacementViewPanel) {
        this.placementView = rfpPlacementViewPanel;
    }

    public void setNaviBar(GuiNavigationPanel guiNavigationPanel) {
        this.naviBar = guiNavigationPanel;
    }

    @Override
    public void componentActivated(Component component) {
        this.configureTableFilter();
        this.placementView.triggerProjectFileRead();
    }

    @Override
    public void componentDeactivated() {
    }

    public void taskBarActionConfigureTable() {
        GuiUtilTableConfigDlgDefault guiUtilTableConfigDlgDefault = new GuiUtilTableConfigDlgDefault(this.table, tableColSel, UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpPlacement);
        guiUtilTableConfigDlgDefault.setVisible(true);
    }
}

