/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.rfp.RfpSyncView;
import com.aastra.oamp.rfp.RfpSyncViewPanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCheckBox;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraFileChooser;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraSlider;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RfpSyncViewConfigPanel
extends AastraPanel {
    private static final long serialVersionUID = 1L;
    private AastraCheckBox checkBoxShowAllRfp = null;
    private AastraCheckBox checkBoxSelectionMode = null;
    private AastraButton buttonRefreshRSSI = null;
    private AastraButton buttonClose = null;
    private RfpSyncView rfpSyncView = null;
    private RfpSyncViewPanel rfpSyncViewPanel = null;
    private AastraButton buttonResetZoom = null;
    private AastraButton buttonLoadImage = null;
    private AastraButton buttonResetMonitoring = null;
    private RfpSyncViewConfigPanel rfpSyncViewConfigPanel;
    private AastraSlider sliderRSSIThreshold = null;
    private AastraLabel labelThreshold = null;
    private AastraLabel labelThresholdValue = null;

    public RfpSyncViewConfigPanel(RfpSyncView rfpSyncView) {
        this.rfpSyncView = rfpSyncView;
        this.rfpSyncViewConfigPanel = this;
        this.initialize();
    }

    private void initialize() {
        this.labelThresholdValue = new AastraLabel();
        this.labelThresholdValue.setBounds(55, 306, 61, 19);
        this.labelThresholdValue.setText("-100 dBm");
        this.labelThreshold = new AastraLabel();
        this.labelThreshold.setBounds(45, 290, 100, 20);
        this.labelThreshold.setText(UtilLocale.getString("TXT_RSSI_THRESHOLD_20"));
        this.setSize(180, 400);
        this.setLayout(null);
        this.setPreferredSize(new Dimension(180, 0));
        this.setBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderCommon));
        this.add(this.getCheckBoxShowAllRfps());
        this.add(this.getButtonRefreshRSSI());
        this.add(this.getButtonClose());
        this.add(this.getButtonResetZoom());
        this.add(this.getCheckBoxSelectionMode());
        this.add(this.getButtonLoadImage());
        this.add(this.getButtonResetMonitoring());
        this.add(this.getSliderRSSIThreshold());
        this.add(this.labelThreshold);
        this.add(this.labelThresholdValue);
    }

    private AastraCheckBox getCheckBoxShowAllRfps() {
        if (this.checkBoxShowAllRfp == null) {
            this.checkBoxShowAllRfp = new AastraCheckBox();
            this.checkBoxShowAllRfp.setBounds(19, 41, 117, 22);
            this.checkBoxShowAllRfp.setText("<html>" + UtilLocale.getString("TXT_SHOW_ALL_RADIO_FIXED_PARTS_20") + "</html>");
            this.checkBoxShowAllRfp.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (RfpSyncViewConfigPanel.this.checkBoxShowAllRfp.isSelected()) {
                        RfpSyncViewConfigPanel.this.rfpSyncViewPanel.setShowAllRfp(true);
                    } else {
                        RfpSyncViewConfigPanel.this.rfpSyncViewPanel.setShowAllRfp(false);
                    }
                }
            });
        }
        return this.checkBoxShowAllRfp;
    }

    private AastraButton getButtonRefreshRSSI() {
        if (this.buttonRefreshRSSI == null) {
            this.buttonRefreshRSSI = new AastraButton();
            this.buttonRefreshRSSI.setBounds(19, 239, 146, 27);
            this.buttonRefreshRSSI.setText(UtilLocale.getString("TXT_REFRESH_RSSI_20"));
            this.buttonRefreshRSSI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpSyncViewConfigPanel.this.rfpSyncViewPanel.refreshRssi();
                }
            });
        }
        return this.buttonRefreshRSSI;
    }

    private AastraButton getButtonClose() {
        if (this.buttonClose == null) {
            this.buttonClose = new AastraButton();
            this.buttonClose.setBounds(160, 0, 20, 20);
            this.buttonClose.setIcon(GuiUtilIcon.getIconArrowRightWhite());
            this.buttonClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpSyncViewConfigPanel.this.rfpSyncView.configPanelClose();
                }
            });
        }
        return this.buttonClose;
    }

    public void setSyncViewPanel(RfpSyncViewPanel rfpSyncViewPanel) {
        this.rfpSyncViewPanel = rfpSyncViewPanel;
    }

    private AastraButton getButtonResetZoom() {
        if (this.buttonResetZoom == null) {
            this.buttonResetZoom = new AastraButton();
            this.buttonResetZoom.setBounds(19, 198, 146, 27);
            this.buttonResetZoom.setText(UtilLocale.getString("TXT_RESET_VIEW_20"));
            this.buttonResetZoom.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpSyncViewConfigPanel.this.rfpSyncViewPanel.resetZoomAndShift();
                }
            });
        }
        return this.buttonResetZoom;
    }

    private AastraCheckBox getCheckBoxSelectionMode() {
        if (this.checkBoxSelectionMode == null) {
            this.checkBoxSelectionMode = new AastraCheckBox();
            this.checkBoxSelectionMode.setBounds(19, 80, 138, 22);
            this.checkBoxSelectionMode.setText(UtilLocale.getString("TXT_RADIO_FIXED_PART_POSITIONING_20"));
            this.checkBoxSelectionMode.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (RfpSyncViewConfigPanel.this.checkBoxSelectionMode.isSelected()) {
                        RfpSyncViewConfigPanel.this.rfpSyncViewPanel.setPositionEditMode(true);
                    } else {
                        RfpSyncViewConfigPanel.this.rfpSyncViewPanel.setPositionEditMode(false);
                    }
                }
            });
        }
        return this.checkBoxSelectionMode;
    }

    private AastraButton getButtonLoadImage() {
        if (this.buttonLoadImage == null) {
            this.buttonLoadImage = new AastraButton(GuiUtilIcon.getIconDocumentAdd());
            this.buttonLoadImage.setBounds(19, 157, 146, 27);
            this.buttonLoadImage.setText(UtilLocale.getString("TXT_IMAGE_20"));
            this.buttonLoadImage.setToolTipText(UtilLocale.getString("TXT_LOAD_BACKGROUND_IMAGE"));
            this.buttonLoadImage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AastraFileChooser aastraFileChooser = new AastraFileChooser(0, UtilLocale.getString("TXT_SELECT_FILE"));
                    if (aastraFileChooser.showOpenDialog(RfpSyncViewConfigPanel.this.rfpSyncViewConfigPanel) == 0) {
                        File file = aastraFileChooser.getSelectedFile();
                        String string = file.getAbsolutePath();
                        if (!file.isFile()) {
                            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_FILE_*_NOT_FOUND"), file));
                        } else if (RfpSyncViewConfigPanel.this.rfpSyncViewPanel.setBackgroundImage(string)) {
                            UtilPreferences.setSyncViewImagePath(string);
                        }
                    }
                }
            });
        }
        return this.buttonLoadImage;
    }

    private AastraButton getButtonResetMonitoring() {
        if (this.buttonResetMonitoring == null) {
            this.buttonResetMonitoring = new AastraButton();
            this.buttonResetMonitoring.setBounds(19, 116, 146, 27);
            this.buttonResetMonitoring.setText(UtilLocale.getString("TXT_RESET_MONITORING_20"));
            this.buttonResetMonitoring.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpSyncViewConfigPanel.this.rfpSyncViewPanel.resetMonitoring();
                }
            });
        }
        return this.buttonResetMonitoring;
    }

    private AastraSlider getSliderRSSIThreshold() {
        if (this.sliderRSSIThreshold == null) {
            this.sliderRSSIThreshold = new AastraSlider();
            this.sliderRSSIThreshold.setBounds(19, 325, 146, 45);
            this.sliderRSSIThreshold.setMinimum(-100);
            this.sliderRSSIThreshold.setMaximum(-50);
            this.sliderRSSIThreshold.setValue(-100);
            this.sliderRSSIThreshold.setMajorTickSpacing(25);
            this.sliderRSSIThreshold.setMinorTickSpacing(5);
            this.sliderRSSIThreshold.setPaintTicks(true);
            this.sliderRSSIThreshold.setFont(AastraCommon.AastraFontCommon);
            this.sliderRSSIThreshold.setPaintLabels(true);
            this.sliderRSSIThreshold.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    AastraSlider aastraSlider = (AastraSlider)changeEvent.getSource();
                    if (!aastraSlider.getValueIsAdjusting()) {
                        RfpSyncViewConfigPanel.this.rfpSyncViewPanel.setRSSIThreshold(aastraSlider.getValue() + 100);
                        RfpSyncViewConfigPanel.this.labelThresholdValue.setText("" + aastraSlider.getValue() + " dBm");
                    }
                }
            });
        }
        return this.sliderRSSIThreshold;
    }
}

