/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.rfp.RfpTreeNode;
import com.aastra.oamp.rfp.TreeDropTarget;
import com.aastra.omilib.RfpDataRecord;
import com.aastra.omilib.RfpDatabase;
import com.aastra.omilib.SiteDataHandler;
import com.aastra.style.AastraCommon;
import com.aastra.util.UtilSpy;
import java.awt.Dimension;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class RfpTree
extends JTree {
    private static final long serialVersionUID = 1L;
    private RfpTreeNode root;
    private RfpTreeNode[] rfpNodeArray = new RfpTreeNode[RfpDatabase.maxRfp];
    private RfpDatabase rfpDb;
    private SiteDataHandler siteDataHandler = null;
    private DefaultTreeCellRenderer renderer = null;
    private boolean scrollCheck = false;
    private scrollStatus scrollStat = scrollStatus.NOT_ALLOWED;
    private Timer scrollTimer = null;
    private final int scrollDelay = 500;
    private final int scrollPeriod = 1000;

    public RfpTree(DefaultTreeModel defaultTreeModel, RfpDatabase rfpDatabase, SiteDataHandler siteDataHandler) {
        super(defaultTreeModel);
        this.treeModel = defaultTreeModel;
        this.root = (RfpTreeNode)defaultTreeModel.getRoot();
        if (this.root.nodeType != RfpTreeNode.NodeTypeEnum.NODE_ROOT_UNASSIGNED && this.root.nodeType != RfpTreeNode.NodeTypeEnum.NODE_ROOT_PAGING_AREA) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "RFP tree constructor:  nodeType != ROOT");
        }
        this.rfpDb = rfpDatabase;
        this.siteDataHandler = siteDataHandler;
        this.initialize();
    }

    public RfpTree(RfpTreeNode rfpTreeNode, RfpDatabase rfpDatabase, SiteDataHandler siteDataHandler) {
        super(rfpTreeNode);
        if (this.root.nodeType != RfpTreeNode.NodeTypeEnum.NODE_ROOT_UNASSIGNED && this.root.nodeType != RfpTreeNode.NodeTypeEnum.NODE_ROOT_PAGING_AREA) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "RFP tree constructor:  nodeType != ROOT");
        }
        this.root = rfpTreeNode;
        this.rfpDb = rfpDatabase;
        this.siteDataHandler = siteDataHandler;
        this.initialize();
    }

    private void initialize() {
        this.setBackground(AastraCommon.AastraColorCommon);
        this.renderer = new DefaultTreeCellRenderer();
        this.renderer.setLeafIcon(GuiUtilIcon.getLeafIcon());
        this.renderer.setFont(AastraCommon.AastraFontMenuItem);
        this.renderer.setBackgroundNonSelectionColor(AastraCommon.AastraColorCommon);
        this.renderer.setBackgroundSelectionColor(AastraCommon.AastraColorTableRowBgSel);
        this.renderer.setPreferredSize(new Dimension(250, 20));
        this.setCellRenderer(this.renderer);
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        this.setSelectionModel(defaultTreeSelectionModel);
    }

    private static RfpTreeNode checkForAttrib(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        try {
            for (RfpTreeNode rfpTreeNode = (RfpTreeNode)defaultMutableTreeNode.getFirstChild(); rfpTreeNode != null; rfpTreeNode = (RfpTreeNode)rfpTreeNode.getNextSibling()) {
                if (!rfpTreeNode.name.equals(string)) continue;
                return rfpTreeNode;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    private RfpTreeNode addRfpAtNode(RfpTreeNode rfpTreeNode, RfpDataRecord rfpDataRecord) {
        int n = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID);
        RfpTreeNode rfpTreeNode2 = rfpTreeNode;
        RfpTreeNode rfpTreeNode3 = null;
        class TypeAndName {
            String name;
            RfpTreeNode.NodeTypeEnum type;

            TypeAndName(String string, RfpTreeNode.NodeTypeEnum nodeTypeEnum) {
                this.name = string;
                this.type = nodeTypeEnum;
            }
        }
        TypeAndName[] typeAndNameArray = new TypeAndName[5];
        if (this.rfpNodeArray[n] != null) {
            this.removeRfpNode(this.rfpNodeArray[n]);
        }
        int n2 = 0;
        String string = "" + rfpDataRecord.getField(RfpDataRecord.IDX_SITE);
        if (string != null && !string.equals("")) {
            String string2 = this.siteDataHandler.getSiteBySiteId((Integer)rfpDataRecord.getField(RfpDataRecord.IDX_SITE)).toString();
            if (!string2.equals("")) {
                string2 = String.format(" \"%s\"", string2);
            }
            string = String.format("%s%s", string, string2);
            typeAndNameArray[n2++] = new TypeAndName(string, RfpTreeNode.NodeTypeEnum.NODE_SITE);
        }
        if ((string = (String)rfpDataRecord.getField(RfpDataRecord.IDX_HIERARCHY1)) != null && !string.equals("")) {
            typeAndNameArray[n2++] = new TypeAndName(string, RfpTreeNode.NodeTypeEnum.NODE_BUILDING);
        }
        if ((string = (String)rfpDataRecord.getField(RfpDataRecord.IDX_HIERARCHY2)) != null && !string.equals("")) {
            typeAndNameArray[n2++] = new TypeAndName(string, RfpTreeNode.NodeTypeEnum.NODE_FLOOR);
        }
        if ((string = (String)rfpDataRecord.getField(RfpDataRecord.IDX_HIERARCHY3)) != null && !string.equals("")) {
            typeAndNameArray[n2++] = new TypeAndName(string, RfpTreeNode.NodeTypeEnum.NODE_ROOM);
        }
        if (!(string = (String)rfpDataRecord.getField(RfpDataRecord.IDX_NAME)).equals("")) {
            string = String.format(" \"%s\"", string);
        }
        typeAndNameArray[n2++] = new TypeAndName(String.format("0x%03X%s", n, string), RfpTreeNode.NodeTypeEnum.NODE_RFP);
        for (int i = 0; i < n2; ++i) {
            rfpTreeNode3 = RfpTree.checkForAttrib(rfpTreeNode2, typeAndNameArray[i].name);
            if (rfpTreeNode3 == null) {
                for (int j = i; j < n2; ++j) {
                    rfpTreeNode3 = rfpTreeNode2.createChild(typeAndNameArray[j].type, typeAndNameArray[j].name);
                    if (typeAndNameArray[j].type == RfpTreeNode.NodeTypeEnum.NODE_RFP) {
                        rfpTreeNode3.setRfpId((Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID));
                        this.rfpNodeArray[n] = rfpTreeNode3;
                    }
                    if (this.root.nodeType == RfpTreeNode.NodeTypeEnum.NODE_ROOT_UNASSIGNED) {
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Adding RFP node UA:  rfp " + n + " nodeType " + (Object)((Object)rfpTreeNode3.nodeType) + " " + rfpTreeNode3.name);
                    }
                    if (this.root.nodeType == RfpTreeNode.NodeTypeEnum.NODE_ROOT_PAGING_AREA) {
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Adding RFP node PA:  rfp " + n + " nodeType " + (Object)((Object)rfpTreeNode3.nodeType) + " " + rfpTreeNode3.name);
                    }
                    rfpTreeNode2 = rfpTreeNode3;
                }
                return rfpTreeNode3;
            }
            rfpTreeNode2 = rfpTreeNode3;
        }
        return rfpTreeNode3;
    }

    private RfpTreeNode addRfpAtNode(RfpTreeNode rfpTreeNode, int n) {
        RfpDataRecord rfpDataRecord = this.rfpDb.getRfpByRfpId(n);
        return this.addRfpAtNode(rfpTreeNode, rfpDataRecord);
    }

    public RfpTreeNode addRfp(int n) {
        return this.addRfpAtNode(this.root, n);
    }

    public RfpTreeNode addRfp(RfpTreeNode rfpTreeNode, int n) {
        return this.addRfpAtNode(rfpTreeNode, n);
    }

    public void removeRfpNode(RfpTreeNode rfpTreeNode) {
        int n = rfpTreeNode.getRfpId();
        if (n == -1) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Removing RFP node failed: RFP ID invalid");
            return;
        }
        TreeNode[] treeNodeArray = rfpTreeNode.getPath();
        for (int i = treeNodeArray.length - 1; i >= 0; --i) {
            RfpTreeNode rfpTreeNode2 = (RfpTreeNode)treeNodeArray[i];
            if (rfpTreeNode2.getChildCount() != 0 || rfpTreeNode2.nodeType.ordinal() <= RfpTreeNode.NodeTypeEnum.NODE_PAGING_AREA.ordinal()) continue;
            if (this.root.nodeType == RfpTreeNode.NodeTypeEnum.NODE_ROOT_UNASSIGNED) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Removing RFP node UA: rfp " + n + " nodeType " + (Object)((Object)rfpTreeNode2.nodeType) + " " + rfpTreeNode2.name);
            }
            if (this.root.nodeType == RfpTreeNode.NodeTypeEnum.NODE_ROOT_PAGING_AREA) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Removing RFP node PA: rfp " + n + " nodeType " + (Object)((Object)rfpTreeNode2.nodeType) + " " + rfpTreeNode2.name);
            }
            rfpTreeNode2.removeFromParent();
        }
    }

    public void removeRfp(int n) {
        RfpTreeNode rfpTreeNode = this.rfpNodeArray[n];
        if (rfpTreeNode == null) {
            return;
        }
        this.removeRfpNode(rfpTreeNode);
        this.rfpNodeArray[n] = null;
    }

    public boolean searchRfp(int n) {
        return this.rfpNodeArray[n] != null;
    }

    public void expandRecursive(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode.getNextNode();
        do {
            this.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
        } while ((defaultMutableTreeNode2 = defaultMutableTreeNode2.getNextNode()) != null);
        this.updateUI();
    }

    public void expandAll(boolean bl) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
        this.updateUI();
    }

    public void setScrollCheck(boolean bl) {
        this.scrollCheck = bl;
    }

    public void evaluateScrollStatus(dragAndDropEvent dragAndDropEvent2, final TreeDropTarget treeDropTarget) {
        if (this.scrollCheck) {
            switch (this.scrollStat) {
                case INACTIVE: {
                    if (dragAndDropEvent2 == dragAndDropEvent.DRAG_EXIT) {
                        this.scrollStat = scrollStatus.ACTIVE;
                        this.scrollTimer = new Timer("Oamp_RfpTreeScrollTimer");
                        this.scrollTimer.scheduleAtFixedRate(new TimerTask(){

                            @Override
                            public void run() {
                                if (treeDropTarget != null) {
                                    treeDropTarget.scrollView();
                                }
                            }
                        }, 500L, 1000L);
                        break;
                    }
                    if (dragAndDropEvent2 != dragAndDropEvent.DRAG_DROP_END) break;
                    this.scrollStat = scrollStatus.NOT_ALLOWED;
                    break;
                }
                case ACTIVE: {
                    if (dragAndDropEvent2 != dragAndDropEvent.DRAG_ENTER && dragAndDropEvent2 != dragAndDropEvent.DRAG_DROP_END) break;
                    this.scrollStat = scrollStatus.INACTIVE;
                    if (this.scrollTimer == null) break;
                    this.scrollTimer.cancel();
                    break;
                }
                case NOT_ALLOWED: {
                    if (dragAndDropEvent2 != dragAndDropEvent.DRAG_ENTER) break;
                    this.scrollStat = scrollStatus.INACTIVE;
                }
            }
        }
    }

    public static enum dragAndDropEvent {
        DRAG_EXIT,
        DRAG_ENTER,
        DRAG_DROP_END;

    }

    private static enum scrollStatus {
        INACTIVE,
        ACTIVE,
        NOT_ALLOWED;

    }
}

