/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.rfp.RfpTreeNode;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilWarnings;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCheckBox;
import com.aastra.style.AastraDialog;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class RfpTreeDropWarningDlg
extends AastraDialog {
    private static final long serialVersionUID = 1L;
    private AastraPanel panel = null;
    private AastraLabel labelInfo = null;
    private AastraLabel labelCheckBox = null;
    private AastraCheckBox checkBox = null;
    private AastraButton buttonOk = null;
    private AastraButton buttonCancel = null;
    private boolean drop = false;
    private RfpTreeNode.NodeTypeEnum nodeType;

    public RfpTreeDropWarningDlg(RfpTreeNode.NodeTypeEnum nodeTypeEnum) {
        super(GuiMain.getGuiMainObject());
        this.nodeType = nodeTypeEnum;
        this.initialize();
    }

    private void initialize() {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setSize(330, 180);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setTitle(UtilLocale.getString("TXT_WARNING"));
        this.setContentPane(this.getPanel());
        this.addWindowListener(new WindowAction());
        this.getRootPane().setDefaultButton(this.getButtonOk());
    }

    public boolean getDrop() {
        return this.drop;
    }

    public boolean getDialogActive() {
        return UtilWarnings.getSingleId(UtilWarnings.WarningIdEnum.RFP_DROP);
    }

    private AastraPanel getPanel() {
        if (this.panel == null) {
            this.panel = new AastraPanel();
            this.panel.setLayout(null);
            this.panel.add(this.getLabelInfo());
            this.panel.add(this.getLabelCheckBox());
            this.panel.add(this.getCheckBox());
            this.panel.add(this.getButtonOk());
            this.panel.add(this.getButtonCancel());
        }
        return this.panel;
    }

    private AastraLabel getLabelInfo() {
        if (this.labelInfo == null) {
            this.labelInfo = new AastraLabel();
            this.labelInfo.setBounds(30, 7, 260, 64);
            this.labelInfo.setHorizontalTextPosition(0);
            if (this.nodeType == RfpTreeNode.NodeTypeEnum.NODE_ROOT_PAGING_AREA) {
                this.labelInfo.setText("<html>" + UtilLocale.getString("TXT_CONTINUE_WITH_CHANGING_PAGING_AREA_?") + "</html>");
            } else {
                this.labelInfo.setText("<html>" + UtilLocale.getString("TXT_CONTINUE_WITH_MOVING_TO_PA_UNASSIGNED_?") + "</html>");
            }
        }
        return this.labelInfo;
    }

    private AastraButton getButtonOk() {
        if (this.buttonOk == null) {
            this.buttonOk = new AastraButton();
            this.buttonOk.setBounds(45, 75, 76, 26);
            this.buttonOk.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpTreeDropWarningDlg.this.buttonAction(true);
                }
            });
        }
        return this.buttonOk;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            this.buttonCancel.setBounds(195, 75, 76, 26);
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpTreeDropWarningDlg.this.buttonAction(false);
                }
            });
        }
        return this.buttonCancel;
    }

    private void buttonAction(boolean bl) {
        this.drop = bl;
        UtilWarnings.setSingleId(UtilWarnings.WarningIdEnum.RFP_DROP, !this.checkBox.isSelected());
        this.setVisible(false);
    }

    private AastraCheckBox getCheckBox() {
        if (this.checkBox == null) {
            this.checkBox = new AastraCheckBox(25, 117);
        }
        return this.checkBox;
    }

    private AastraLabel getLabelCheckBox() {
        if (this.labelCheckBox == null) {
            this.labelCheckBox = new AastraLabel();
            this.labelCheckBox.setBounds(55, 120, 180, 30);
            this.labelCheckBox.setHorizontalTextPosition(11);
            this.labelCheckBox.setText("<html>" + UtilLocale.getString("TXT_DONT_WARN_AGAIN") + "</html>");
        }
        return this.labelCheckBox;
    }

    class WindowAction
    extends WindowAdapter {
        WindowAction() {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            RfpTreeDropWarningDlg.this.checkBox.setSelected(!UtilWarnings.getSingleId(UtilWarnings.WarningIdEnum.RFP_DROP));
        }
    }
}

