/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraDialog;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class RfpTreePagingAreaErrorDlg
extends AastraDialog {
    private static final long serialVersionUID = 1L;
    private AastraPanel panel = null;
    private AastraLabel labelInfo = null;
    private AastraLabel labelContinue = null;
    private AastraButton buttonOk = null;
    private AastraButton buttonCancel = null;
    private int pagingAreaSize;
    private int cntRfpPA;
    private boolean allowDrop = false;
    private boolean doDrop = false;

    public RfpTreePagingAreaErrorDlg() {
        super(GuiMain.getGuiMainObject());
        this.initialize();
    }

    public void setParams(int n, int n2, int n3) {
        this.cntRfpPA = n2;
        this.pagingAreaSize = n3;
        this.setText();
    }

    public boolean getDrop() {
        return this.doDrop;
    }

    private void initialize() {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setSize(400, 180);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setTitle(UtilLocale.getString("TXT_ERROR"));
        this.setContentPane(this.getPanel());
        this.addWindowListener(new WindowAction());
        this.getRootPane().setDefaultButton(this.getButtonOk());
    }

    private AastraPanel getPanel() {
        if (this.panel == null) {
            this.panel = new AastraPanel();
            this.panel.setLayout(null);
            this.panel.add(this.getLabelInfo());
            this.panel.add(this.getLabelContinue());
            this.panel.add(this.getButtonOk());
            this.panel.add(this.getButtonCancel());
        }
        return this.panel;
    }

    private AastraLabel getLabelInfo() {
        if (this.labelInfo == null) {
            this.labelInfo = new AastraLabel();
            this.labelInfo.setBounds(20, 11, 350, 45);
            this.labelInfo.setHorizontalTextPosition(0);
        }
        return this.labelInfo;
    }

    private AastraLabel getLabelContinue() {
        if (this.labelContinue == null) {
            this.labelContinue = new AastraLabel();
            this.labelContinue.setBounds(20, 59, 350, 29);
            this.labelContinue.setHorizontalTextPosition(0);
        }
        return this.labelContinue;
    }

    private AastraButton getButtonOk() {
        if (this.buttonOk == null) {
            this.buttonOk = new AastraButton();
            this.buttonOk.setBounds(50, 110, 76, 26);
            this.buttonOk.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOk.setVisible(false);
            this.buttonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (RfpTreePagingAreaErrorDlg.this.allowDrop) {
                        RfpTreePagingAreaErrorDlg.this.doDrop = true;
                    }
                    RfpTreePagingAreaErrorDlg.this.setVisible(false);
                }
            });
        }
        return this.buttonOk;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            this.buttonCancel.setBounds(274, 110, 76, 26);
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.setVisible(false);
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpTreePagingAreaErrorDlg.this.setVisible(false);
                }
            });
        }
        return this.buttonCancel;
    }

    private void setText() {
        String string = null;
        String string2 = null;
        int n = this.pagingAreaSize - this.cntRfpPA;
        if (n <= 0) {
            string = String.format("<html>" + UtilLocale.getString("TXT_CANNOT_DROP_SELECTED_RFPS_INTO_PA") + " " + UtilLocale.getString("TXT_PAGING_AREA_COMPLETELY_CONFIGURED") + " " + String.format("(%s: %d)", UtilLocale.getString("TXT_PAGING_AREA_SIZE"), this.pagingAreaSize) + "</html>", new Object[0]);
            string2 = "";
            this.allowDrop = false;
            this.buttonOk.setVisible(true);
            this.buttonCancel.setVisible(false);
        } else {
            string = "<html>" + UtilLocale.getString("TXT_CANNOT_DROP_ALL_SELECTED_RFPS_INTO_PA") + " " + String.format(UtilLocale.getString("TXT_ONLY_*_SPACES_LEFT"), n) + " " + String.format("(%s: %d)", UtilLocale.getString("TXT_PAGING_AREA_SIZE"), this.pagingAreaSize) + "</html>";
            string2 = "<html>" + String.format(UtilLocale.getString("TXT_CONTINUE_WITH_MOVING_*_RFPS_INTO_PA_?"), n) + "</html>";
            this.allowDrop = true;
            this.buttonOk.setVisible(true);
            this.buttonCancel.setVisible(true);
        }
        this.labelInfo.setText(string);
        this.labelContinue.setText(string2);
    }

    class WindowAction
    extends WindowAdapter {
        WindowAction() {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            RfpTreePagingAreaErrorDlg.this.doDrop = false;
        }
    }
}

