/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.rfp.RfpConfigMainPanel;
import com.aastra.oamp.rfp.RfpTree;
import com.aastra.oamp.rfp.RfpTreeDropWarningDlg;
import com.aastra.oamp.rfp.RfpTreeNode;
import com.aastra.oamp.rfp.RfpTreePagingAreaErrorDlg;
import com.aastra.oamp.rfp.TreeDragSource;
import com.aastra.oamp.rfp.TreeDropTarget;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.RfpDataHandler;
import com.aastra.omilib.RfpDataNotificationInterface;
import com.aastra.omilib.RfpDataRecord;
import com.aastra.omilib.RfpDatabase;
import com.aastra.omilib.SiteDataHandler;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraSplitPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class RfpTreeView
extends AastraPanel
implements RfpDataNotificationInterface,
CommonDataHandler.CommonDataNotificationInterface,
SiteDataHandler.SiteDataNotificationInterface {
    public static final int MAX_PAGING_AREAS = 256;
    private static final long serialVersionUID = 1L;
    private CommonDataHandler commonDataHandler = null;
    private RfpDataHandler rfpDataHandler = null;
    private RfpDatabase db = null;
    private SiteDataHandler siteDataHandler = null;
    private AastraSplitPane jSplitPane = null;
    private RfpTree pagingAreaTree = null;
    private RfpTree unassignedTree = null;
    private RfpTreeNode unassignedTreeRoot = null;
    private RfpTreeNode[] pagingAreas = new RfpTreeNode[256];
    private RfpTreeNode pagingAreaTreeRoot = null;
    private JScrollPane unassignedTreeScrollPane = null;
    private JScrollPane pagingAreaScrollPane = null;
    private DragSourceDragEvent dsde = null;
    private int parkLengthIdentifier = 0;
    private int pagingAreaSize = 0;
    private int numberPagingArea = 0;
    private boolean[] rfpReqArray = new boolean[RfpDatabase.maxRfp];
    private RfpTreeDropWarningDlg dropWarningDlg = null;
    private RfpTreePagingAreaErrorDlg pagingAreaErrorDlg = null;

    public RfpTreeView(RfpDataHandler rfpDataHandler, CommonDataHandler commonDataHandler, SiteDataHandler siteDataHandler) {
        this.rfpDataHandler = rfpDataHandler;
        this.rfpDataHandler.registerDataNotificationListener(this);
        this.db = this.rfpDataHandler.getDatabase();
        this.siteDataHandler = siteDataHandler;
        this.siteDataHandler.registerDataNotificationListener(this);
        this.commonDataHandler = commonDataHandler;
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.PARK, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.PagingAreaSize, this);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJSplitPane(), "Center");
        RfpTreeNode.NodeTypeEnum.NODE_ROOT_UNASSIGNED.setTypeName(UtilLocale.getString("TXT_UNASSIGNED"));
        RfpTreeNode.NodeTypeEnum.NODE_ROOT_PAGING_AREA.setTypeName(UtilLocale.getString("TXT_PAGING_AREAS_20"));
        RfpTreeNode.NodeTypeEnum.NODE_PAGING_AREA.setTypeName(UtilLocale.getString("TXT_PAGING_AREA_20"));
        RfpTreeNode.NodeTypeEnum.NODE_SITE.setTypeName(UtilLocale.getString("TXT_SITE_20"));
        RfpTreeNode.NodeTypeEnum.NODE_BUILDING.setTypeName(UtilLocale.getString("TXT_BUILDING_20"));
        RfpTreeNode.NodeTypeEnum.NODE_FLOOR.setTypeName(UtilLocale.getString("TXT_FLOOR_20"));
        RfpTreeNode.NodeTypeEnum.NODE_ROOM.setTypeName(UtilLocale.getString("TXT_ROOM_20"));
        RfpTreeNode.NodeTypeEnum.NODE_RFP.setTypeName(UtilLocale.getString("TXT_RFP_ID_20"));
    }

    private RfpTree getUnassignedTree() {
        if (this.unassignedTree == null) {
            this.unassignedTreeRoot = new RfpTreeNode(RfpTreeNode.NodeTypeEnum.NODE_ROOT_UNASSIGNED);
            this.unassignedTree = new RfpTree(new DefaultTreeModel(this.unassignedTreeRoot), this.db, this.siteDataHandler);
            this.unassignedTree.setEnabled(false);
            new TreeDragSource(this.unassignedTree, 3, 1, this);
            new TreeDropTarget(this.unassignedTree, false, this);
            ((DefaultTreeModel)this.unassignedTree.getModel()).addTreeModelListener(new RfpTreeModelListener(this.unassignedTree));
        }
        return this.unassignedTree;
    }

    private AastraSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new AastraSplitPane();
            this.jSplitPane.setLeftComponent(this.getUnassignedRfpTreeScrollPane());
            this.jSplitPane.setRightComponent(this.getPagingAreaScrollPane());
            this.jSplitPane.setDividerLocation(350);
        }
        return this.jSplitPane;
    }

    public RfpTree getPagingAreaTree() {
        if (this.pagingAreaTree == null) {
            this.pagingAreaTreeRoot = new RfpTreeNode(RfpTreeNode.NodeTypeEnum.NODE_ROOT_PAGING_AREA);
            this.pagingAreaTree = new RfpTree(new DefaultTreeModel(this.pagingAreaTreeRoot), this.db, this.siteDataHandler);
            this.pagingAreaTree.setEnabled(false);
            new TreeDragSource(this.pagingAreaTree, 3, 2, this);
            new TreeDropTarget(this.pagingAreaTree, true, this);
            ((DefaultTreeModel)this.pagingAreaTree.getModel()).addTreeModelListener(new RfpTreeModelListener(this.pagingAreaTree));
        }
        return this.pagingAreaTree;
    }

    public void initializeRfpTrees() {
        for (int i = 0; i < 256; ++i) {
            this.pagingAreas[i] = null;
        }
        this.unassignedTree = null;
        this.unassignedTreeRoot = null;
        this.pagingAreaTree = null;
        this.pagingAreaTreeRoot = null;
        this.getUnassignedRfpTreeScrollPane().setViewportView(this.getUnassignedTree());
        this.getPagingAreaScrollPane().setViewportView(this.getPagingAreaTree());
    }

    private JScrollPane getUnassignedRfpTreeScrollPane() {
        if (this.unassignedTreeScrollPane == null) {
            this.unassignedTreeScrollPane = new JScrollPane();
        }
        return this.unassignedTreeScrollPane;
    }

    private JScrollPane getPagingAreaScrollPane() {
        if (this.pagingAreaScrollPane == null) {
            this.pagingAreaScrollPane = new JScrollPane();
            this.pagingAreaScrollPane.setLayout(new ScrollPaneLayout());
        }
        return this.pagingAreaScrollPane;
    }

    @Override
    public void processRfpDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        RfpDataRecord rfpDataRecord = null;
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "RFP notification: " + dataNotificationEnum.toString() + ",rfpId=" + n);
        switch (dataNotificationEnum) {
            case DATA_BULK_READY: {
                this.unassignedTree.setEnabled(true);
                this.pagingAreaTree.setEnabled(true);
                this.refreshBothTrees();
                break;
            }
            case NEW_DATA: {
                rfpDataRecord = this.db.getRfpByRfpId(n);
                if (rfpDataRecord == null) break;
                int n2 = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_PAGING_AREA);
                this.addRfpToTree(n, n2);
                this.refreshActiveTree(n2);
                break;
            }
            case DATA_RFP_CHANGED_CNF: {
                rfpDataRecord = this.db.getRfpByRfpId(n);
                if (rfpDataRecord == null || !rfpDataRecord.getFieldChanged(RfpDataRecord.IDX_PAGING_AREA) && !rfpDataRecord.getFieldChanged(RfpDataRecord.IDX_SITE) && !rfpDataRecord.getFieldChanged(RfpDataRecord.IDX_HIERARCHY1) && !rfpDataRecord.getFieldChanged(RfpDataRecord.IDX_HIERARCHY2) && !rfpDataRecord.getFieldChanged(RfpDataRecord.IDX_HIERARCHY3) && !rfpDataRecord.getFieldChanged(RfpDataRecord.IDX_NAME)) break;
                int n3 = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_PAGING_AREA);
                this.changeRfpAtTree(n, n3);
                this.refreshBothTrees();
                break;
            }
            case DATA_RFP_CHANGED_RESP: {
                if (this.unassignedTree.isFocusOwner() || this.pagingAreaTree.isFocusOwner()) {
                    if (!this.rfpReqArray[n]) break;
                    this.rfpReqArray[n] = false;
                }
                if ((rfpDataRecord = this.db.getRfpByRfpId(n)) == null) break;
                int n4 = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_PAGING_AREA);
                this.changeRfpAtTree(n, n4);
                this.refreshBothTrees();
                break;
            }
            case DATA_DELETED: {
                this.unassignedTree.removeRfp(n);
                this.pagingAreaTree.removeRfp(n);
                this.refreshBothTrees();
                break;
            }
        }
    }

    @Override
    public void processRfpErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        OmiMessage.errorCodes errorCodes2 = null;
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "RFP error notification: " + dataNotificationEnum.toString() + ",rfpId=" + String.valueOf(n) + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "RFP error notification: Unknown errorCode=" + string);
        }
        if ((this.unassignedTree.isFocusOwner() || this.pagingAreaTree.isFocusOwner()) && errorCodes2 != null) {
            if (errorCodes2 == OmiMessage.errorCodes.EAreaFull) {
                if (this.rfpDataHandler.sendRfpReq(n, true, true)) {
                    this.rfpReqArray[n] = true;
                } else {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Single RFP request for rfpId=" + String.valueOf(n) + " has not been sent, because bulk request is still active");
                }
            }
            String string4 = UtilErrorHandling.getErrorMessage(errorCodes2, string2, string3);
            GuiInfoConsole.showError(string4);
        }
    }

    private void addRfpToTree(int n, int n2) {
        if (n2 == -1) {
            this.unassignedTree.addRfp(n);
        } else {
            if (this.pagingAreas[n2] == null) {
                this.pagingAreas[n2] = this.pagingAreaTreeRoot.createChild(RfpTreeNode.NodeTypeEnum.NODE_PAGING_AREA, String.format("%03d", n2));
            }
            this.pagingAreaTree.addRfp(this.pagingAreas[n2], n);
        }
    }

    private void changeRfpAtTree(int n, int n2) {
        if (n2 == -1) {
            this.unassignedTree.addRfp(n);
            if (this.pagingAreaTree.searchRfp(n)) {
                this.pagingAreaTree.removeRfp(n);
            }
        } else {
            if (this.pagingAreas[n2] == null) {
                this.pagingAreas[n2] = this.pagingAreaTreeRoot.createChild(RfpTreeNode.NodeTypeEnum.NODE_PAGING_AREA, String.format("%03d", n2));
            }
            this.pagingAreaTree.addRfp(this.pagingAreas[n2], n);
            if (this.unassignedTree.searchRfp(n)) {
                this.unassignedTree.removeRfp(n);
            }
        }
    }

    public RfpTreeNode getUnassignedRfpsNode() {
        return this.unassignedTreeRoot;
    }

    public RfpTreeNode getPagingAreaNode(int n) {
        if (this.pagingAreas[n] == null) {
            return null;
        }
        return this.pagingAreas[n];
    }

    public void dragSourceDragOver(DragSourceDragEvent dragSourceDragEvent) {
        this.dsde = dragSourceDragEvent;
    }

    public void dropTargetDragEnter(boolean bl) {
        if (this.dsde != null) {
            if (bl) {
                this.dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
            } else {
                this.dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
            }
        }
    }

    public void removeRfpInSpecialTree(RfpTreeNode.NodeTypeEnum nodeTypeEnum, int n) {
        if (nodeTypeEnum == RfpTreeNode.NodeTypeEnum.NODE_ROOT_PAGING_AREA) {
            this.pagingAreaTree.removeRfp(n);
        } else if (nodeTypeEnum == RfpTreeNode.NodeTypeEnum.NODE_ROOT_UNASSIGNED) {
            this.unassignedTree.removeRfp(n);
        }
    }

    public void updateRfpDataRecord(RfpTreeNode rfpTreeNode, int n) {
        RfpDataRecord rfpDataRecord = this.db.getRfpByRfpId(n);
        int n2 = -1;
        if (rfpTreeNode != this.unassignedTreeRoot) {
            for (int i = 0; i < 256; ++i) {
                if (rfpTreeNode != this.pagingAreas[i]) continue;
                n2 = i;
                RfpConfigMainPanel.resetDectInfoHierarchy4(rfpDataRecord);
                break;
            }
        } else {
            RfpConfigMainPanel.setDectInfoHierarchy4(rfpDataRecord);
        }
        rfpDataRecord.setField(RfpDataRecord.IDX_PAGING_AREA, (Object)n2);
        this.rfpDataHandler.sendSetRfp(rfpDataRecord);
    }

    @Override
    public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
        String string = null;
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Common data notification: " + dataNotificationEnum.toString() + "," + commonDataItemEnum.toString());
        if (commonDataItemEnum == CommonDataHandler.CommonDataItemEnum.PARK) {
            try {
                string = (String)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.PARK);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PARK.toString() + "='" + string + "'");
            }
            catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PARK.toString() + " failed");
                return;
            }
            if (string != null && string.length() == 10) {
                this.parkLengthIdentifier = Integer.parseInt(string.substring(0, 2), 16);
            }
            this.updateNumberPagingArea();
        } else if (commonDataItemEnum == CommonDataHandler.CommonDataItemEnum.PagingAreaSize) {
            try {
                this.pagingAreaSize = (Integer)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.PagingAreaSize);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PagingAreaSize.toString() + "=" + this.pagingAreaSize);
            }
            catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PagingAreaSize.toString() + " failed");
                return;
            }
            this.updateNumberPagingArea();
        }
    }

    @Override
    public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
    }

    private void updateNumberPagingArea() {
        int n;
        int n2 = 0;
        if (this.parkLengthIdentifier == 0 || this.pagingAreaSize == 0) {
            return;
        }
        n2 = 1 << 39 - this.parkLengthIdentifier;
        this.numberPagingArea = n2 / this.pagingAreaSize;
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Calculated number of paging areas = " + this.numberPagingArea);
        for (n = 0; n < this.numberPagingArea; ++n) {
            if (this.pagingAreas[n] != null) continue;
            this.pagingAreas[n] = this.pagingAreaTreeRoot.createChild(RfpTreeNode.NodeTypeEnum.NODE_PAGING_AREA, String.format("%03d", n));
        }
        for (n = this.numberPagingArea; n < 256 && this.pagingAreas[n] != null; ++n) {
            this.pagingAreaTreeRoot.remove(this.pagingAreas[n]);
            this.pagingAreas[n] = null;
        }
        this.pagingAreaTree.expandPath(new TreePath(this.pagingAreaTreeRoot));
        this.pagingAreaTree.updateUI();
    }

    public void expandTree(RfpTreeNode rfpTreeNode, RfpTreeNode rfpTreeNode2) {
        TreePath treePath = new TreePath(((RfpTreeNode)rfpTreeNode2.getParent()).getPath());
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "New node path='" + treePath + "'");
        RfpTreeNode rfpTreeNode3 = (RfpTreeNode)rfpTreeNode2.getRoot();
        if (rfpTreeNode3.nodeType == RfpTreeNode.NodeTypeEnum.NODE_ROOT_PAGING_AREA) {
            this.pagingAreaTree.expandPath(treePath);
            this.pagingAreaTree.updateUI();
        } else if (rfpTreeNode3.nodeType == RfpTreeNode.NodeTypeEnum.NODE_ROOT_UNASSIGNED) {
            this.unassignedTree.expandPath(treePath);
            this.unassignedTree.updateUI();
        }
    }

    @Override
    public void processSiteDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (dataNotificationEnum == DataNotificationEnum.DATA_SITE_CHANGED_NAME) {
            int n2 = this.db.getRecordNumber();
            for (int i = 0; i < n2; ++i) {
                RfpDataRecord rfpDataRecord = this.db.getRecordByIdx(i);
                if (rfpDataRecord == null || (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_SITE) != n) continue;
                int n3 = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID);
                int n4 = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_PAGING_AREA);
                if (n4 == -1) {
                    this.unassignedTree.addRfp(n3);
                    continue;
                }
                this.pagingAreaTree.addRfp(this.pagingAreas[n4], n3);
            }
            this.refreshBothTrees();
        }
    }

    @Override
    public void processSiteDataErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int checkRfpCnt(boolean bl, int n, int n2) {
        if (n + n2 > this.pagingAreaSize) {
            if (!this.createPagingAreaErrorDlg(n, n2)) return 0;
            if (!bl) return this.pagingAreaSize - n2;
            if (!this.createDropWarningDialog(RfpTreeNode.NodeTypeEnum.NODE_ROOT_PAGING_AREA)) return 0;
            return this.pagingAreaSize - n2;
        }
        if (!bl) return -1;
        if (!this.createDropWarningDialog(RfpTreeNode.NodeTypeEnum.NODE_ROOT_PAGING_AREA)) return 0;
        return -1;
    }

    private boolean createPagingAreaErrorDlg(int n, int n2) {
        this.pagingAreaErrorDlg = new RfpTreePagingAreaErrorDlg();
        this.pagingAreaErrorDlg.setParams(n, n2, this.pagingAreaSize);
        this.pagingAreaErrorDlg.setVisible(true);
        return this.pagingAreaErrorDlg.getDrop();
    }

    public boolean createDropWarningDialog(RfpTreeNode.NodeTypeEnum nodeTypeEnum) {
        this.dropWarningDlg = new RfpTreeDropWarningDlg(nodeTypeEnum);
        if (this.dropWarningDlg.getDialogActive()) {
            this.dropWarningDlg.setVisible(true);
            return this.dropWarningDlg.getDrop();
        }
        return true;
    }

    public void refreshBothTrees() {
        if (this.unassignedTree.isEnabled()) {
            ((DefaultTreeModel)this.unassignedTree.getModel()).nodeStructureChanged(this.unassignedTreeRoot);
        }
        if (this.pagingAreaTree.isEnabled()) {
            ((DefaultTreeModel)this.pagingAreaTree.getModel()).nodeStructureChanged(this.pagingAreaTreeRoot);
        }
    }

    public void refreshActiveTree(int n) {
        if (n == -1) {
            if (this.unassignedTree.isEnabled()) {
                ((DefaultTreeModel)this.unassignedTree.getModel()).nodeStructureChanged(this.unassignedTreeRoot);
            }
        } else if (this.pagingAreaTree.isEnabled()) {
            ((DefaultTreeModel)this.pagingAreaTree.getModel()).nodeStructureChanged(this.pagingAreaTreeRoot);
        }
    }

    public boolean isRfpDECTRunning(int n) {
        RfpDataRecord rfpDataRecord = this.db.getRfpByRfpId(n);
        return rfpDataRecord != null && (Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_DECT_RUNNING) != false;
    }

    class RfpTreeModelListener
    implements TreeModelListener {
        RfpTree tree = null;

        public RfpTreeModelListener(RfpTree rfpTree) {
            this.tree = rfpTree;
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            RfpTreeNode rfpTreeNode = (RfpTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Tree nodes changed: " + (Object)((Object)rfpTreeNode.nodeType));
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            RfpTreeNode rfpTreeNode = (RfpTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Tree nodes inserted: " + (Object)((Object)rfpTreeNode.nodeType));
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            RfpTreeNode rfpTreeNode = (RfpTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Tree nodes removed: " + (Object)((Object)rfpTreeNode.nodeType));
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            RfpTreeNode rfpTreeNode = (RfpTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Tree structure changed: " + (Object)((Object)rfpTreeNode.nodeType));
        }
    }
}

