/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.rfp.RfpTree;
import com.aastra.oamp.rfp.RfpTreeView;
import com.aastra.oamp.rfp.TransferableTreeNode;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.tree.TreePath;

class TreeDragSource
implements DragSourceListener,
DragGestureListener {
    private DragSource source;
    private TransferableTreeNode transferable;
    private RfpTree tree = null;
    private RfpTreeView rfpTreeView = null;
    private int level = 0;

    public TreeDragSource(RfpTree rfpTree, int n, int n2, RfpTreeView rfpTreeView) {
        this.tree = rfpTree;
        this.source = new DragSource();
        this.level = n2;
        this.rfpTreeView = rfpTreeView;
        this.source.createDefaultDragGestureRecognizer(this.tree, n, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        if (treePath.getPathCount() <= this.level) {
            return;
        }
        this.transferable = new TransferableTreeNode(treePath);
        this.source.startDrag(dragGestureEvent, DragSource.DefaultMoveNoDrop, this.transferable, this);
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        this.rfpTreeView.dragSourceDragOver(dragSourceDragEvent);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.tree.evaluateScrollStatus(RfpTree.dragAndDropEvent.DRAG_DROP_END, null);
        if (!dragSourceDropEvent.getDropSuccess() || dragSourceDropEvent.getDropAction() == 2) {
            // empty if block
        }
    }
}

