/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfpquality;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilMainPanel;
import com.aastra.oamp.guiutil.GuiUtilTableColSelect;
import com.aastra.oamp.guiutil.GuiUtilTableConfigDlgDefault;
import com.aastra.oamp.guiutil.GuiUtilTaskPanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.RfpQualityHandler;
import com.aastra.style.AastraLinkButton;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class RfpIpQualityPanel
extends GuiUtilMainPanel
implements GuiComponentActivationInterface,
CommonDataHandler.CommonDataNotificationInterface {
    private static final long serialVersionUID = 1L;
    private RfpQualityHandler rfpQualityHandler = null;
    private CommonDataHandler commonDataHandler = null;
    private RfpIpQualityTaskPanel rfpIpQualityTaskPanel = null;
    private GuiUtilConfiguratorTable rfpQualityTable = null;
    private AastraScrollPane rfpQualityTablePane = null;
    private static final GuiUtilTableColSelect[] tableColSel = new GuiUtilTableColSelect[]{new GuiUtilTableColSelect(0, true), new GuiUtilTableColSelect(9, true), new GuiUtilTableColSelect(10, true), new GuiUtilTableColSelect(11, true), new GuiUtilTableColSelect(12, true), new GuiUtilTableColSelect(13, true), new GuiUtilTableColSelect(14, true), new GuiUtilTableColSelect(15, true), new GuiUtilTableColSelect(16, true), new GuiUtilTableColSelect(17, true)};

    public RfpIpQualityPanel(RfpQualityHandler rfpQualityHandler, CommonDataHandler commonDataHandler) {
        this.rfpQualityHandler = rfpQualityHandler;
        this.commonDataHandler = commonDataHandler;
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.Limits, this);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getRfpQualityTablePane(), "Center");
        this.add((Component)this.getRfpIpQualityTaskPanel(), "East");
    }

    private AastraScrollPane getRfpQualityTablePane() {
        if (this.rfpQualityTablePane == null) {
            this.rfpQualityTablePane = new AastraScrollPane(this.getRfpQualityTable());
        }
        return this.rfpQualityTablePane;
    }

    private GuiUtilConfiguratorTable getRfpQualityTable() {
        if (this.rfpQualityTable == null) {
            this.rfpQualityTable = new GuiUtilConfiguratorTable(null, this.rfpQualityHandler.getRfpQualityDb(), tableColSel, this.getActiveTableColumns(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpQualityIp, tableColSel), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthRfpQualityIp, true);
            this.rfpQualityTable.setColumnFormatString(0, "0x%03X");
        }
        return this.rfpQualityTable;
    }

    private RfpIpQualityTaskPanel getRfpIpQualityTaskPanel() {
        if (this.rfpIpQualityTaskPanel == null) {
            this.rfpIpQualityTaskPanel = new RfpIpQualityTaskPanel();
        }
        return this.rfpIpQualityTaskPanel;
    }

    @Override
    public void componentActivated(Component component) {
        this.rfpQualityHandler.startRfpIpQuality();
    }

    @Override
    public void componentDeactivated() {
        this.rfpQualityHandler.stopRfpIpQuality();
    }

    @Override
    public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
        if (commonDataItemEnum == CommonDataHandler.CommonDataItemEnum.Limits) {
            try {
                CommonDataHandler.LimitsClass limitsClass = (CommonDataHandler.LimitsClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.Limits);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.Limits.toString() + "='" + limitsClass + "'");
                RfpQualityHandler.RfpQualityRecord.setTableHeaderText(13, String.format("< %d " + UtilLocale.getString("TXT_UNIT_MILLISECOND"), limitsClass.limitRTT1));
                RfpQualityHandler.RfpQualityRecord.setTableHeaderText(14, String.format("< %d " + UtilLocale.getString("TXT_UNIT_MILLISECOND"), limitsClass.limitRTT2));
                RfpQualityHandler.RfpQualityRecord.setTableHeaderText(15, String.format("< %d " + UtilLocale.getString("TXT_UNIT_MILLISECOND"), limitsClass.limitRTT3));
                RfpQualityHandler.RfpQualityRecord.setTableHeaderText(16, String.format("< %d " + UtilLocale.getString("TXT_UNIT_MILLISECOND"), limitsClass.limitRTT4));
                RfpQualityHandler.RfpQualityRecord.setTableHeaderText(17, String.format(">= %d " + UtilLocale.getString("TXT_UNIT_MILLISECOND"), limitsClass.limitRTT4));
                this.rfpQualityTable.tableStructureChange();
            }
            catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.Limits.toString() + " failed");
            }
        }
    }

    @Override
    public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
    }

    private final class RfpIpQualityTaskPanel
    extends GuiUtilTaskPanel {
        private static final long serialVersionUID = 1L;
        private AastraLinkButton buttonConfigureRfpTable = null;

        private RfpIpQualityTaskPanel() {
            this.initialize();
        }

        private void initialize() {
            this.add(this.getButtonConfigureRfpTable());
        }

        private AastraLinkButton getButtonConfigureRfpTable() {
            if (this.buttonConfigureRfpTable == null) {
                this.buttonConfigureRfpTable = this.createTaskButtonEnabled(UtilLocale.getString("TXT_SELECT_COLUMNS_20"));
                this.buttonConfigureRfpTable.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        GuiUtilTableConfigDlgDefault guiUtilTableConfigDlgDefault = new GuiUtilTableConfigDlgDefault(RfpIpQualityPanel.this.rfpQualityTable, tableColSel, UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpQualityIp);
                        guiUtilTableConfigDlgDefault.setVisible(true);
                    }
                });
            }
            return this.buttonConfigureRfpTable;
        }
    }
}

