/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfpstatistic;

import com.aastra.oamp.rfpstatistic.RfpStatisticRecord;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.RfpDatabase;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableModel;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class RfpStatisticVectorDatabase
extends Database {
    private RfpStatisticRecord[] dataArray = new RfpStatisticRecord[RfpDatabase.maxRfp];
    private int[] idxArray = new int[RfpDatabase.maxRfp];
    private int numRecords = 0;
    private int maxRfpId = 0;
    private String[] fieldNames = null;
    private LinkedList<ConfiguratorTable> tableList = new LinkedList();

    public void registerTable(ConfiguratorTable configuratorTable) {
        this.tableList.add(configuratorTable);
    }

    @Override
    public int getRecordNumber() {
        return this.numRecords;
    }

    @Override
    public DataRecord getRecordByIdx(int n) {
        if (n >= 0 && n < this.numRecords) {
            return this.dataArray[this.idxArray[n]];
        }
        if (this.numRecords > 0) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_STAT, this, "getRecordByIdx: idx=" + n + " out of range");
        }
        return null;
    }

    public RfpStatisticRecord getRecordByRfpId(int n) {
        if (n >= 0 && n < RfpDatabase.maxRfp) {
            return this.dataArray[n];
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_STAT, this, "getRecordByRfpId: rfpId=" + n + " out of range");
        return null;
    }

    @Override
    public void updateIndex() {
        this.numRecords = 0;
        for (int i = 0; i <= this.maxRfpId; ++i) {
            if (this.dataArray[i] == null) continue;
            this.idxArray[this.numRecords++] = i;
        }
    }

    private void notifyTables() {
        if (this.tableList.size() != 0) {
            for (ConfiguratorTable configuratorTable : this.tableList) {
                if (configuratorTable == null) continue;
                ((ConfiguratorTableModel)configuratorTable.getModel()).fireTableDataChanged();
            }
        }
    }

    public void createRecord(RfpStatisticRecord rfpStatisticRecord) {
        if (rfpStatisticRecord.rfpId >= 0 && rfpStatisticRecord.rfpId < RfpDatabase.maxRfp) {
            this.dataArray[rfpStatisticRecord.rfpId] = rfpStatisticRecord;
            if (rfpStatisticRecord.rfpId > this.maxRfpId) {
                this.maxRfpId = rfpStatisticRecord.rfpId;
            }
            this.updateIndex();
            this.notifyTables();
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_STAT, this, "createRecord: rfpId=" + rfpStatisticRecord.rfpId + " out of range");
        }
    }

    public void deleteRecord(int n) {
        if (n >= 0 && n < RfpDatabase.maxRfp) {
            if (this.dataArray[n] == null) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_STAT, this, "deleteRecord: Record for rfpId=" + n + " does not exist");
            }
            this.dataArray[n] = null;
            this.updateIndex();
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_STAT, this, "deleteRecord: rfpId=" + n + " out of range");
        }
    }

    public void setFieldNames(String[] stringArray) {
        this.fieldNames = stringArray;
        this.notifyTables();
    }

    @Override
    public String[] getFieldNames() {
        if (this.fieldNames != null) {
            return this.fieldNames;
        }
        return RfpStatisticRecord.getFieldNames();
    }

    public void clearAll() {
        for (int i = 0; i <= this.maxRfpId; ++i) {
            this.dataArray[i] = null;
        }
        this.maxRfpId = 0;
        this.numRecords = 0;
        this.notifyTables();
    }
}

