/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.site;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilMainPanel;
import com.aastra.oamp.guiutil.GuiUtilTableColSelect;
import com.aastra.oamp.site.SiteDetailPanel;
import com.aastra.oamp.site.SiteTaskPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.RfpDataHandler;
import com.aastra.omilib.SiteDataHandler;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;

public class SiteMainPanel
extends GuiUtilMainPanel
implements SiteDataHandler.SiteDataNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface {
    private static final long serialVersionUID = 1L;
    protected static final int xSizeDetailPanelSurcharge = 240;
    protected static final int ySizeDetailPanelSurcharge = 150;
    private static final int ySizeDetailPanel = 360;
    private RfpDataHandler rfpDataHandler = null;
    private SiteDataHandler siteDataHandler = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private OmiManagement omiManagement = null;
    private GuiUtilDetailSplitPanel siteDetailSplitPane = null;
    private AastraScrollPane siteTablePane = null;
    private SiteDetailPanel siteDetailPanel = null;
    private SiteTaskPanel siteTaskPanel = null;
    private boolean pendingSite = false;
    private int idPending = -1;
    private int idCurrentMonitorPanel = -1;
    private int dividerLocation = 0;
    private CommonDataHandler commonDataHandler = null;
    private boolean widebandAndVideoAllowed = false;
    private boolean srtpAllowed = false;
    private boolean dectSecurityAllowed = false;
    private UtilErrorComp utilErrorComp = null;
    private boolean isEditable = true;
    private GuiUtilTableColSelect[] tableColSel = null;

    public SiteMainPanel(GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, SiteDataHandler siteDataHandler, CommonDataHandler commonDataHandler, RfpDataHandler rfpDataHandler) {
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.siteDataHandler = siteDataHandler;
        this.commonDataHandler = commonDataHandler;
        this.rfpDataHandler = rfpDataHandler;
        this.omiManagement = GuiMain.getOmiManagementObject();
        this.siteDataHandler.registerDataNotificationListener(this);
        this.initialize();
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilErrorComp = new UtilErrorComp();
        } else {
            this.isEditable = false;
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.getSiteDetailSplitPane(), "Center");
        this.add((Component)this.getSiteTaskPanel(), "East");
    }

    private void processTableEvent(DataRecord dataRecord) {
        int n = this.table.getSelectedRowCount();
        int n2 = this.table.getRowCount();
        if (this.siteDetailSplitPane.getBottomComponent() != null) {
            if (dataRecord != null) {
                SiteDataHandler.Site site = (SiteDataHandler.Site)dataRecord;
                this.createSiteDetailPanel(site, false);
            } else {
                this.removeSiteDetailPanel();
            }
        } else if (n == 1) {
            this.siteTaskPanel.setTaskButtonConfigureShow(true);
        } else {
            this.siteTaskPanel.setTaskButtonConfigureShow(false);
        }
        if (this.isEditable) {
            if (n >= 1 && n < n2) {
                this.siteTaskPanel.setTaskButtonDelete(true);
            } else {
                this.siteTaskPanel.setTaskButtonDelete(false);
            }
        }
        this.updateTableInfo();
    }

    public void configureShowSite() {
        int n;
        SiteDataHandler.Site site;
        int n2 = this.table.getSelectedRow();
        if (n2 >= 0 && (site = this.siteDataHandler.getSiteByTableIdx(n = this.table.convertRowIndexToModel(n2))) != null) {
            this.createSiteDetailPanel(site, false);
        }
    }

    private GuiUtilDetailSplitPanel getSiteDetailSplitPane() {
        if (this.siteDetailSplitPane == null) {
            this.siteDetailSplitPane = new GuiUtilDetailSplitPanel(360);
            this.siteDetailSplitPane.setTopComponent(this.getSiteTablePane());
            this.siteDetailSplitPane.setBottomComponent(null);
        }
        return this.siteDetailSplitPane;
    }

    private GuiUtilConfiguratorTable getSiteTable() {
        if (this.table == null) {
            this.table = this.isEditable ? new GuiUtilConfiguratorTable((Object)this, this.siteDataHandler.getDb(), this.getTableColumnsSelection(), this.getActiveTableColumns(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectSiteConfig, this.getTableColumnsSelection(), true), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthSiteConfig) : new GuiUtilConfiguratorTable((Object)this, this.siteDataHandler.getDb(), this.getTableColumnsSelection(), this.getActiveTableColumns(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectSiteMonitor, this.getTableColumnsSelection(), true), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthSiteMonitor, 0);
        }
        return this.table;
    }

    private AastraScrollPane getSiteTablePane() {
        if (this.siteTablePane == null) {
            this.siteTablePane = new AastraScrollPane(this.getSiteTable());
            this.dividerLocation = this.siteDetailSplitPane.getHeight() - 360;
            this.siteTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.siteTablePane;
    }

    private void enableTableAccess() {
        this.table.setActive(true);
        if (this.isEditable) {
            this.siteTaskPanel.setTaskButtonCreate(true);
        }
        this.siteTaskPanel.setTaskButtonConfigureTable(true);
    }

    private void disableTableAccess() {
        this.table.setActive(false);
        this.siteTaskPanel.setTaskButtonConfigureShow(false);
        if (this.isEditable) {
            this.siteTaskPanel.setTaskButtonCreate(false);
            this.siteTaskPanel.setTaskButtonDelete(false);
        }
        this.siteTaskPanel.setTaskButtonConfigureTable(false);
    }

    private AastraPanel getSiteDetailPanel() {
        if (this.siteDetailPanel == null) {
            this.siteDetailPanel = new SiteDetailPanel(this, this.guiNavPanelType, this.utilErrorComp);
        }
        return this.siteDetailPanel;
    }

    private AastraPanel getSiteTaskPanel() {
        if (this.siteTaskPanel == null) {
            this.siteTaskPanel = new SiteTaskPanel(this, this.guiNavPanelType, this.table);
        }
        return this.siteTaskPanel;
    }

    public void createSiteDetailPanel(SiteDataHandler.Site site, boolean bl) {
        if (bl) {
            this.table.removeRowSelectionAll();
        }
        if (this.siteDetailSplitPane.getBottomComponent() != null) {
            if (this.isEditable) {
                this.pendingSite = false;
                this.idPending = -1;
                this.utilErrorComp.clearComponents();
            }
            this.dividerLocation = this.siteDetailSplitPane.getDividerLocation();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating site config detail panel");
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating site config detail panel");
            this.siteDetailSplitPane.setBottomComponent(this.getSiteDetailPanel());
        }
        if (this.isEditable) {
            if (site != null) {
                this.checkSiteFeaturesEnabled(site.id);
            } else {
                this.checkSiteFeaturesEnabled(0);
            }
        }
        if (site != null) {
            if (!this.isEditable) {
                this.idCurrentMonitorPanel = site.id;
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading site[" + site.id + "]: '" + site.name + "'," + site.nRFPs);
            this.siteDetailPanel.setSiteDetailData(site, this.widebandAndVideoAllowed, this.srtpAllowed, this.dectSecurityAllowed);
        } else {
            this.siteDetailPanel.setSiteDetailData(null, this.widebandAndVideoAllowed, this.srtpAllowed, this.dectSecurityAllowed);
        }
        this.siteDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.siteDetailSplitPane.validate();
        this.siteTaskPanel.setTaskButtonConfigureShow(false);
    }

    public void removeSiteDetailPanel() {
        if (this.siteDetailSplitPane.getBottomComponent() != null) {
            if (this.isEditable) {
                this.pendingSite = false;
                this.idPending = -1;
                this.utilErrorComp.clearComponents();
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing site config detail panel");
            } else {
                this.idCurrentMonitorPanel = -1;
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing site monitor detail panel");
            }
            this.dividerLocation = this.siteDetailSplitPane.getDividerLocation();
            this.siteDetailSplitPane.setBottomComponent(null);
            if (this.table.getSelectedRowCount() == 1) {
                this.siteTaskPanel.setTaskButtonConfigureShow(true);
            }
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Tried to remove site detail panel, but there is none");
        }
    }

    public void createSite() {
        SiteDataHandler.Site site = this.siteDetailPanel.getSiteDetailData();
        if (site != null) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating site[" + site.id + "]: '" + site.name + "'," + site.nRFPs);
            this.siteDataHandler.sendCreateSite(site);
            this.pendingSite = true;
            this.idPending = -1;
        }
    }

    public void changeSite() {
        SiteDataHandler.Site site = this.siteDetailPanel.getSiteDetailData();
        if (site != null) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Changing site[" + site.id + "]: '" + site.name + "'," + site.nRFPs);
            this.siteDataHandler.sendSetSite(site);
            this.pendingSite = true;
            this.idPending = site.id;
        }
    }

    public void deleteSite() {
        GuiUtilDialog guiUtilDialog;
        int n = this.table.getSelectedRowCount();
        if (n > 0 && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_DELETE_SELECTED_SITES_?"), true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            int[] nArray = this.table.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = this.table.convertRowIndexToModel(nArray[i]);
                SiteDataHandler.Site site = this.siteDataHandler.getSiteByTableIdx(n2);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Deleting site[" + site.id + "]");
                this.siteDataHandler.sendDeleteSite(site.id);
                if (this.siteDetailSplitPane.getBottomComponent() == null) continue;
                this.pendingSite = true;
                this.idPending = site.id;
            }
        }
    }

    protected GuiUtilTableColSelect[] getTableColumnsSelection() {
        if (this.tableColSel == null) {
            GuiUtilTableColSelect[] guiUtilTableColSelectArray = new GuiUtilTableColSelect[]{new GuiUtilTableColSelect(0, true), new GuiUtilTableColSelect(1, true), new GuiUtilTableColSelect(3, true, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(5, true, GuiUtilIcon.getIconArrayInactiveActive())};
            int n = guiUtilTableColSelectArray.length + 1;
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSRTP)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo)) {
                ++n;
            }
            this.tableColSel = Arrays.copyOf(guiUtilTableColSelectArray, n);
            int n2 = guiUtilTableColSelectArray.length;
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSRTP)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(4, true, GuiUtilIcon.getIconArray_Inactive_OKInactive_OK());
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo)) {
                this.tableColSel[n2++] = new GuiUtilTableColSelect(6, true, GuiUtilIcon.getIconArrayInactiveActive());
            }
            this.tableColSel[n2] = new GuiUtilTableColSelect(2, true);
        }
        return this.tableColSel;
    }

    private void checkSiteFeaturesEnabled(int n) {
        this.srtpAllowed = false;
        this.dectSecurityAllowed = false;
        this.widebandAndVideoAllowed = false;
        CommonDataHandler.LicenseClass licenseClass = null;
        Boolean bl = null;
        try {
            licenseClass = (CommonDataHandler.LicenseClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.License);
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.License.toString() + " failed");
            return;
        }
        if (licenseClass == null) {
            return;
        }
        try {
            bl = (Boolean)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.DECTEncryption);
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTEncryption.toString() + " failed");
            return;
        }
        int n2 = 0;
        if (n != 0) {
            n2 = this.rfpDataHandler.getDatabase().getRFPsNoAdvancedFeaturesInSite(n);
        }
        if (n2 == 0) {
            this.widebandAndVideoAllowed = true;
            this.srtpAllowed = true;
            if (bl.booleanValue()) {
                this.dectSecurityAllowed = true;
            }
        }
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        SiteDataHandler.Site site = (SiteDataHandler.Site)dataRecord;
        this.createSiteDetailPanel(site, false);
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        if (this.siteDetailSplitPane.getBottomComponent() != null && this.table.getSelectedRowCount() > 1) {
            this.removeSiteDetailPanel();
        }
        this.siteTaskPanel.setTaskButtonConfigureShow(false);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processSiteDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Site notification: " + dataNotificationEnum.toString() + ",id=" + String.valueOf(n));
        block0 : switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                break;
            }
            default: {
                if (this.isEditable) {
                    switch (dataNotificationEnum) {
                        case NEW_DATA: {
                            if (!this.pendingSite) break block0;
                            this.removeSiteDetailPanel();
                            break;
                        }
                        case DATA_CHANGED: 
                        case DATA_SITE_CHANGED_NAME: 
                        case DATA_SITE_CHANGED_OTHER: 
                        case DATA_DELETED: {
                            if (!this.pendingSite || n != this.idPending) break block0;
                            this.removeSiteDetailPanel();
                            break;
                        }
                    }
                    break;
                }
                if (n != this.idCurrentMonitorPanel) break;
                switch (dataNotificationEnum) {
                    case NEW_DATA: 
                    case DATA_CHANGED: 
                    case DATA_SITE_CHANGED_NAME: 
                    case DATA_SITE_CHANGED_OTHER: {
                        SiteDataHandler.Site site = this.siteDataHandler.getSiteBySiteId(n);
                        if (site == null) break block0;
                        this.createSiteDetailPanel(site, false);
                        break block0;
                    }
                    case DATA_DELETED: {
                        this.removeSiteDetailPanel();
                        break block0;
                    }
                }
            }
        }
    }

    @Override
    public void processSiteDataErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string4 = null;
        OmiMessage.errorCodes errorCodes2 = null;
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_MONITOR || string3 == null) {
            return;
        }
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Site error notification: " + dataNotificationEnum.toString() + ",id=" + String.valueOf(n) + ",errCode=" + string3 + ",bad=" + string + ",maxLen=" + string2);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Site error notification: Unknown errorCode=" + string3);
        }
        switch (dataNotificationEnum) {
            case NEW_DATA: 
            case DATA_CHANGED: {
                if (errorCodes2 != null) {
                    String string5 = this.siteDetailPanel.getErrorLabelText(string);
                    string4 = UtilErrorHandling.getErrorMessage(errorCodes2, string5, string2);
                    GuiInfoConsole.showError(string4);
                } else {
                    GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
                }
                if (string == null) break;
                this.siteDetailPanel.markErrorComponent(string);
                break;
            }
            case DATA_DELETED: {
                string4 = errorCodes2 != null ? (errorCodes2 == OmiMessage.errorCodes.EExist ? UtilLocale.getString("TXT_DELETING_SITES_FAILED") : UtilErrorHandling.getErrorMessage(errorCodes2, null, null)) : UtilLocale.getString("TXT_UNKNOWN_ERROR");
                GuiInfoConsole.showError(string4);
                break;
            }
        }
    }
}

