/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.system;

import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.system.SystemEventLogDetailPanel;
import com.aastra.oamp.system.SystemEventLogTaskPanel;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.EventLogMonitoringHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

public class SystemEventLogMainPanel
extends AastraPanel
implements EventLogMonitoringHandler.EventLogNotificationInterface,
ConfiguratorTableEventInterface {
    private static final long serialVersionUID = 1L;
    protected static final int xSizeDetailPanelSurcharge = 230;
    protected static final int ySizeDetailPanelSurcharge = 150;
    private static final int ySizeDetailPanel = 360;
    private EventLogMonitoringHandler eventLogHandler = null;
    private OmiManagement omiManagement = null;
    private OmiMessage.PermissionType[] permissionArray = null;
    private GuiUtilConfiguratorTable eventLogTable = null;
    private GuiUtilDetailSplitPanel eventLogDetailSplitPane = null;
    private AastraScrollPane eventLogTablePane = null;
    private SystemEventLogTaskPanel eventLogTaskPanel = null;
    private SystemEventLogDetailPanel eventLogDetailPanel = null;
    private int dividerLocation = 0;
    private int currentIdDetailPanel = -1;

    public SystemEventLogMainPanel(EventLogMonitoringHandler eventLogMonitoringHandler) {
        this.eventLogHandler = eventLogMonitoringHandler;
        this.eventLogHandler.registerDataNotificationListener(this);
        this.omiManagement = GuiMain.getOmiManagementObject();
        this.permissionArray = this.omiManagement.getOmmPermissions();
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getEventLogDetailSplitPane(), "Center");
        this.add((Component)this.getEventLogTaskPanel(), "East");
    }

    private GuiUtilDetailSplitPanel getEventLogDetailSplitPane() {
        if (this.eventLogDetailSplitPane == null) {
            this.eventLogDetailSplitPane = new GuiUtilDetailSplitPanel(360);
            this.eventLogDetailSplitPane.setTopComponent(this.getEventLogTablePane());
            this.eventLogDetailSplitPane.setBottomComponent(null);
        }
        return this.eventLogDetailSplitPane;
    }

    private GuiUtilConfiguratorTable getEventLogTable() {
        if (this.eventLogTable == null) {
            int[] nArray = new int[]{2, 3, 4, 1, 5};
            this.eventLogTable = new GuiUtilConfiguratorTable((Object)this, this.eventLogHandler.getDb(), nArray, UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthSystemEventLog, 0, true);
        }
        return this.eventLogTable;
    }

    private AastraScrollPane getEventLogTablePane() {
        if (this.eventLogTablePane == null) {
            this.eventLogTablePane = new AastraScrollPane(this.getEventLogTable());
            this.dividerLocation = this.eventLogDetailSplitPane.getHeight() - 360;
            this.eventLogTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.eventLogTablePane;
    }

    private AastraPanel getEventLogTaskPanel() {
        if (this.eventLogTaskPanel == null) {
            this.eventLogTaskPanel = new SystemEventLogTaskPanel(this);
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.AllCnfWrite)) {
                this.eventLogTaskPanel.setTaskButtonClear(true);
            } else {
                this.eventLogTaskPanel.setTaskButtonClear(false);
            }
        }
        return this.eventLogTaskPanel;
    }

    private void createEventLogDetailPanel(EventLogMonitoringHandler.EventLogEntry eventLogEntry) {
        if (this.eventLogDetailSplitPane.getBottomComponent() != null) {
            this.dividerLocation = this.eventLogDetailSplitPane.getDividerLocation();
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating event log detail panel");
            this.eventLogDetailSplitPane.setBottomComponent(this.getEventLogDetailPanel());
        }
        this.currentIdDetailPanel = eventLogEntry.id;
        this.eventLogDetailPanel.setDetailData(eventLogEntry);
        this.eventLogDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.eventLogDetailSplitPane.validate();
        this.eventLogTaskPanel.setTaskButtonShowEntry(false);
    }

    public void removeEventLogDetailPanel() {
        if (this.eventLogDetailSplitPane.getBottomComponent() != null) {
            this.currentIdDetailPanel = -1;
            this.dividerLocation = this.eventLogDetailSplitPane.getDividerLocation();
            this.eventLogDetailSplitPane.setBottomComponent(null);
            if (this.eventLogTable.getSelectedRowCount() > 0) {
                this.eventLogTaskPanel.setTaskButtonShowEntry(true);
            }
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Tried to remove event log detail panel, but there is none");
        }
    }

    private SystemEventLogDetailPanel getEventLogDetailPanel() {
        if (this.eventLogDetailPanel == null) {
            this.eventLogDetailPanel = new SystemEventLogDetailPanel(this);
        }
        return this.eventLogDetailPanel;
    }

    public void showEventLogEntry() {
        int n;
        EventLogMonitoringHandler.EventLogEntry eventLogEntry;
        int n2 = this.eventLogTable.getSelectedRow();
        if (n2 >= 0 && (eventLogEntry = this.eventLogHandler.getEventLogEntryByTableIdx(n = this.eventLogTable.convertRowIndexToModel(n2))) != null) {
            this.createEventLogDetailPanel(eventLogEntry);
        }
    }

    public void clearEventLogEntries() {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Clearing event log entries");
        this.eventLogHandler.sendDeleteEventLogBuffer();
    }

    private void processTableEvent(DataRecord dataRecord) {
        if (this.eventLogDetailSplitPane.getBottomComponent() != null) {
            if (dataRecord != null) {
                EventLogMonitoringHandler.EventLogEntry eventLogEntry = (EventLogMonitoringHandler.EventLogEntry)dataRecord;
                this.createEventLogDetailPanel(eventLogEntry);
            } else {
                this.removeEventLogDetailPanel();
            }
        } else {
            this.eventLogTaskPanel.setTaskButtonShowEntry(true);
        }
    }

    @Override
    public void processEventLogDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Event log notification: " + dataNotificationEnum.toString() + ", id=" + String.valueOf(n));
        switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                if (this.currentIdDetailPanel != -1) {
                    this.removeEventLogDetailPanel();
                }
                this.eventLogTaskPanel.setTaskButtonClear(false);
                break;
            }
            case NEW_DATA: {
                if (!UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.AllCnfWrite)) break;
                this.eventLogTaskPanel.setTaskButtonClear(true);
                break;
            }
            case DATA_CHANGED: {
                if (this.currentIdDetailPanel != n || this.eventLogDetailPanel == null) break;
                this.eventLogDetailPanel.setDetailData(this.eventLogHandler.getEventLogEntryById(n));
                break;
            }
        }
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        EventLogMonitoringHandler.EventLogEntry eventLogEntry = (EventLogMonitoringHandler.EventLogEntry)dataRecord;
        this.createEventLogDetailPanel(eventLogEntry);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }
}

