/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.system;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilFileChooser;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.OmiFileTransfer;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraDialog;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraTextField;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.border.TitledBorder;

public class SystemPARKDialog
extends AastraDialog
implements OmiMessageInterface {
    private static final long serialVersionUID = 1L;
    private AastraButton buttonPark;
    private SystemPARKDialog dlg = this;
    private static final int dlgWidth = 700;
    private static final int dlgHeight = 400;

    public SystemPARKDialog(Frame frame) {
        super(frame);
        Serializable serializable;
        this.setTitle("DECT PARK");
        int n = 300;
        int n2 = 200;
        if (frame != null) {
            serializable = frame.getBounds();
            n += ((Rectangle)serializable).x;
            n2 += ((Rectangle)serializable).y;
        }
        this.setBounds(n, n2, 700, 400);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        serializable = new AastraPanel();
        this.getContentPane().add((Component)serializable);
        Dimension dimension = new Dimension(700, 400);
        ((JComponent)serializable).setPreferredSize(dimension);
        ((JComponent)serializable).setMaximumSize(dimension);
        ((JComponent)serializable).setMinimumSize(dimension);
        ((Container)serializable).setLayout(new BoxLayout((Container)serializable, 1));
        AastraPanel aastraPanel = new AastraPanel();
        aastraPanel.setAlignmentX(0.0f);
        aastraPanel.setLayout(null);
        dimension = new Dimension(680, 60);
        aastraPanel.setPreferredSize(dimension);
        aastraPanel.setMaximumSize(dimension);
        aastraPanel.setMinimumSize(dimension);
        this.buttonPark = new AastraButton();
        this.buttonPark.setBounds(30, 15, 170, 25);
        this.buttonPark.setText(UtilLocale.getString("TXT_PARK_ONLINE_REQUEST"));
        this.buttonPark.setEnabled(true);
        this.buttonPark.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SystemPARKDialog.this.buttonPark.setEnabled(false);
                OmiMessage.elemIds.PARKFromServerResp.registerDataNotificationListener(SystemPARKDialog.this.dlg);
                SystemPARKDialog.this.sendPARKFromServer();
                SystemPARKDialog.this.setVisible(false);
                SystemPARKDialog.this.dispose();
            }
        });
        aastraPanel.add(this.buttonPark);
        AastraLabel aastraLabel = new AastraLabel();
        aastraLabel.setBounds(220, 19, 550, 31);
        aastraLabel.setText("<html>" + UtilLocale.getString("TXT_INFO_OMM_RESET_SET_PARK") + "</html>");
        aastraLabel.setIcon(GuiUtilIcon.getIconInfo(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
        aastraPanel.add(aastraLabel);
        ((Container)serializable).add(Box.createRigidArea(new Dimension(0, 10)));
        ((Container)serializable).add(aastraPanel);
        ((Container)serializable).add(new FileTransferPanel(680, UtilLocale.getString("TXT_PARK_REQUEST"), null, UtilLocale.getString("TXT_DOWNLOAD"), null, true, OmiFileTransfer.OmiFileTransferLogicalName.PARK.toString(), "request_park.xml"));
        ((Container)serializable).add(new FileTransferPanel(680, UtilLocale.getString("TXT_PARK_IMPORT"), UtilLocale.getString("TXT_SELECT_PARK_FILE_TO_IMPORT"), UtilLocale.getString("TXT_IMPORT_20"), UtilLocale.getString("TXT_INFO_OMM_RESET_IMPORT_PARK"), false, OmiFileTransfer.OmiFileTransferLogicalName.PARK.toString(), null));
        AastraPanel aastraPanel2 = new AastraPanel();
        aastraPanel2.setAlignmentX(0.0f);
        aastraPanel2.setLayout(null);
        dimension = new Dimension(680, 60);
        aastraPanel2.setPreferredSize(dimension);
        aastraPanel2.setMaximumSize(dimension);
        aastraPanel2.setMinimumSize(dimension);
        AastraButton aastraButton = new AastraButton();
        aastraButton.setText(UtilLocale.getString("TXT_CLOSE_20"));
        aastraButton.setBounds(297, 15, 106, 25);
        aastraButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SystemPARKDialog.this.setVisible(false);
                SystemPARKDialog.this.dispose();
            }
        });
        aastraPanel2.add(aastraButton);
        ((Container)serializable).add(aastraPanel2);
    }

    private void sendPARKFromServer() {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.PARKFromServer.name());
        GuiMain.getOmiManagementObject().getOmiHandler().sendOmiMessage(omiMessage);
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        if (string != null) {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_PARK_ONLINE_REQUEST") + " : " + UtilLocale.getString("TXT_ERROR") + ": " + string);
        } else {
            GuiInfoConsole.showInfo(UtilLocale.getString("TXT_PARK_REQUEST_STARTED"));
        }
        OmiMessage.elemIds.PARKFromServerResp.deregisterDataNotificationListener(this.dlg);
    }

    private static class FileTransferPanel
    extends AastraPanel
    implements OmiFileTransfer.FileTransferNotificationInterface {
        private static final long serialVersionUID = 1L;
        public String fileName = "";
        private AastraTextField textFieldFileName;
        private AastraButton buttonFileName;
        private AastraButton buttonFileTransfer;
        private FileTransferPanel fileTransferPanel = this;
        private GuiUtilFileChooser fileChooser;
        private String ommFileName;
        private boolean saveDialog;
        private String localFileName;
        private String txtTitle;

        private GuiUtilFileChooser getFileChooser(AastraPanel aastraPanel) {
            if (this.fileChooser == null) {
                this.fileChooser = new GuiUtilFileChooser(aastraPanel);
            }
            return this.fileChooser;
        }

        public FileTransferPanel(int n, String string, String string2, String string3, String string4, boolean bl, String string5, String string6) {
            this.ommFileName = string5;
            this.localFileName = string6;
            this.txtTitle = string;
            this.saveDialog = bl;
            this.setAlignmentX(0.0f);
            this.setLayout(null);
            Dimension dimension = new Dimension(n, 120);
            this.setPreferredSize(dimension);
            this.setMaximumSize(dimension);
            this.setMinimumSize(dimension);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), string);
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.setBorder(titledBorder);
            if (string4 != null) {
                AastraLabel aastraLabel = new AastraLabel();
                aastraLabel.setBounds(150, 80, 550, 31);
                aastraLabel.setText("<html>" + string4 + "</html>");
                aastraLabel.setIcon(GuiUtilIcon.getIconInfo(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                this.add(aastraLabel);
            }
            this.textFieldFileName = new AastraTextField();
            this.textFieldFileName.setBounds(150, 34, n - 170, 18);
            this.textFieldFileName.setText(this.fileName);
            this.textFieldFileName.setEditable(false);
            this.add(this.textFieldFileName);
            this.buttonFileName = new AastraButton(GuiUtilIcon.getIconDocumentAdd());
            if (this.saveDialog) {
                this.buttonFileName.setText(UtilLocale.getString("TXT_DIRECTORY"));
            } else {
                this.buttonFileName.setText(UtilLocale.getString("TXT_FILE"));
            }
            this.buttonFileName.setBounds(30, 30, 106, 25);
            if (string2 != null) {
                this.buttonFileName.setToolTipText(string2);
            }
            this.buttonFileName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (saveDialog) {
                        File file = this.getFileChooser(fileTransferPanel).directoryChooser();
                        if (file != null) {
                            fileName = file.getAbsolutePath() + "/" + localFileName;
                            textFieldFileName.setText(fileName);
                            buttonFileTransfer.setEnabled(true);
                        } else {
                            fileName = null;
                            buttonFileTransfer.setEnabled(false);
                        }
                    } else {
                        File file = this.getFileChooser(fileTransferPanel).fileChooser();
                        if (file != null) {
                            fileName = file.getAbsolutePath();
                            buttonFileTransfer.setEnabled(true);
                        } else {
                            fileName = null;
                            buttonFileTransfer.setEnabled(false);
                        }
                        textFieldFileName.setText(fileName);
                    }
                }
            });
            this.add(this.buttonFileName);
            this.buttonFileTransfer = new AastraButton();
            this.buttonFileTransfer.setBounds(30, 75, 106, 25);
            this.buttonFileTransfer.setText(string3);
            this.buttonFileTransfer.setEnabled(false);
            this.buttonFileTransfer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OmiFileTransfer.StartFileTransferReturnEnum startFileTransferReturnEnum = saveDialog ? OmiFileTransfer.startFileTransfer(OmiMessage.elemIds.GetFile, ommFileName, fileName, fileTransferPanel) : OmiFileTransfer.startFileTransfer(OmiMessage.elemIds.PutFile, ommFileName, fileName, fileTransferPanel);
                    switch (startFileTransferReturnEnum) {
                        case FILETRANSFER_START_OK: {
                            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, txtTitle + ": file transfer started successfully");
                            GuiInfoConsole.showInfo(UtilLocale.getString("TXT_PARK_TRANSFER_STARTED"));
                            buttonFileTransfer.setEnabled(false);
                            break;
                        }
                        case FILETRANSFER_ACTIVE: {
                            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, txtTitle + ": file transfer error: Another file transfer is still active");
                            break;
                        }
                        case WRONG_PARAM: {
                            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, txtTitle + ": file transfer error: Wrong parameters");
                            break;
                        }
                        case FILE_TRANSFER_NOT_INITIALIZED: {
                            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, txtTitle + ": file transfer error: File transfer not initialized");
                            break;
                        }
                        case LOCAL_FILE_ERROR: {
                            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, txtTitle + ": file transfer error: Local file access failed");
                            break;
                        }
                        case NO_LINK_TO_OMM: {
                            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, txtTitle + ": file transfer error: OMM link failed");
                            break;
                        }
                        default: {
                            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, txtTitle + ": file transfer error: Unknown");
                        }
                    }
                }
            });
            this.add((Component)this.buttonFileTransfer, null);
        }

        @Override
        public void omiFileTransferNotification(String string, OmiFileTransfer.OmiFileTransferEvents omiFileTransferEvents, OmiMessage omiMessage, int n) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, this.txtTitle + ": File transfer event: " + omiFileTransferEvents.toString());
            switch (omiFileTransferEvents) {
                case TRANSFER_COMPLETED: {
                    GuiInfoConsole.showInfo(this.txtTitle + ": " + UtilLocale.getString("TXT_PARK_FILE_TRANSFERRED_SUCCESSFULLY"));
                    break;
                }
                case TRANSFER_ERROR: {
                    if (omiMessage != null) {
                        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                        try {
                            OmiMessage.errorCodes errorCodes2 = OmiMessage.errorCodes.valueOf(string2);
                            GuiInfoConsole.showError(this.txtTitle + ": error: " + UtilErrorHandling.getErrorMessage(errorCodes2, null, null));
                            break;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "OMI file transfer notification: Unknown errorCode=" + string2);
                        }
                    }
                    GuiInfoConsole.showError(this.txtTitle + ": " + UtilLocale.getString("TXT_TRANSFER_ERROR"));
                    break;
                }
                case ERROR_NAME_CONFLICT: {
                    GuiInfoConsole.showError(this.txtTitle + ": " + UtilLocale.getString("TXT_FILE_NAME_CONFLICT"));
                    break;
                }
                case ERROR_OFFSET_MISMATCH: {
                    GuiInfoConsole.showError(this.txtTitle + ": " + UtilLocale.getString("TXT_FILE_OFFSET_MISMATCH"));
                    break;
                }
            }
        }
    }
}

