/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.system;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.gui.GuiStatusBar;
import com.aastra.oamp.guiutil.GuiUtilBorderPanel;
import com.aastra.oamp.guiutil.GuiUtilButtonBar;
import com.aastra.oamp.guiutil.GuiUtilCheckBox;
import com.aastra.oamp.guiutil.GuiUtilComboBox;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilElementCollection;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilTabbedPane;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.guiutil.GuiUtilTextFieldTime;
import com.aastra.oamp.system.SystemPARKDialog;
import com.aastra.oamp.system.SystemRestartDlg;
import com.aastra.oamp.system.SystemUtil;
import com.aastra.oamp.system.SystemUtilUrlBorderPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.SWManagementHandler;
import com.aastra.omilib.SiteSummaryHandler;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.util.UtilSpy;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;

public class SystemSettingsPanel
extends AastraPanel
implements OmiManagementEventInterface,
CommonDataHandler.CommonDataNotificationInterface,
GuiComponentActivationInterface,
SWManagementHandler.SWManagementDataNotificationInterface,
SiteSummaryHandler.SiteSummaryNotificationInterface {
    private static final long serialVersionUID = 1L;
    private static final int panelWidth = 800;
    private static final int panelHeight = 470;
    private static final int tabbedPaneWidth = 800;
    private static final int tabbedPaneHeight = 535;
    private CommonDataHandler commonDataHandler = null;
    private SiteSummaryHandler siteSummaryHandler = null;
    private SWManagementHandler swMgmtHandler = null;
    private GuiStatusBar guiStatusBar = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private UtilErrorComp utilErrorComp = null;
    private SystemUtil.ToolsSystemSettings toolsSystem = null;
    private CommonDataHandler.TimeZoneListClass tzoneList = null;
    private SysSetTabbedPane tabbedPaneSysSet = null;
    private boolean isEditable = true;
    private int parkLengthIdentifier = 0;
    private OmiManagement omiManagement = null;
    private static boolean sariSet = false;
    private AastraPanel tabGeneral = null;
    private AastraPanel panelGeneral = null;
    private AastraLabel labelSystemName = null;
    private GuiUtilTextField textFieldSystemName = null;
    private AastraLabel labelRemoteAccess = null;
    private GuiUtilCheckBox checkBoxRemoteAccess = null;
    private AastraLabel labelTZone = null;
    private GuiUtilComboBox comboBoxTZone = null;
    private AastraPanel panelSysLog = null;
    private GuiUtilCheckBox checkBoxSysLogActive = null;
    private GuiUtilTextField textFieldSysLogIPAddress = null;
    private GuiUtilTextField textFieldSysLogPort = null;
    private GuiUtilCheckBox checkBoxSysLogForward = null;
    private AastraLabel labelInfoSysLog = null;
    private AastraLabel labelToneScheme = null;
    private GuiUtilComboBox comboBoxToneScheme = null;
    private GuiUtilButtonBar panelGeneralButtonBar = null;
    private AastraPanel panelRfpSwUpdate = null;
    private GuiUtilComboBox comboBoxRfpSwUpdateMode = null;
    private GuiUtilCheckBox checkBoxTimedUpdate = null;
    private GuiUtilTextFieldTime.GuiUtilTextFieldHour textFieldUpdateHour = null;
    private GuiUtilTextFieldTime.GuiUtilTextFieldMinute textFieldUpdateMinute = null;
    private GuiUtilTextField textFieldUpdateMaxDelay = null;
    private GuiUtilTextFieldTime.GuiUtilTextFieldHour textFieldUpdateHourCalc = null;
    private GuiUtilTextFieldTime.GuiUtilTextFieldMinute textFieldUpdateMinuteCalc = null;
    private AastraPanel tabDECT = null;
    private AastraPanel panelDECT = null;
    private GuiUtilTextField textFieldPARK = null;
    private AastraButton buttonPARKDlg = null;
    private GuiUtilTextField textFieldSARI = null;
    private AastraButton buttonSARI = null;
    private GuiUtilCheckBox checkBoxDECTEncryption = null;
    private GuiUtilCheckBox checkBoxRestrictedSubscriptionDuration = null;
    private GuiUtilComboBox comboBoxDECTRegDomain = null;
    private GuiUtilTextField textFieldDECTAuthCode = null;
    private GuiUtilComboBox comboBoxPagingAreaSize = null;
    private GuiUtilCheckBox checkBoxPpDevAutoCreate = null;
    private GuiUtilComboBox comboBoxPPLoginType = null;
    private int[] pagingAreaSizeArray = new int[]{16, 32, 64, 128, 256};
    private GuiUtilButtonBar panelDECTButtonBar = null;
    private GuiUtilCheckBox checkBoxPreserveUserDeviceRelation = null;
    private GuiUtilCheckBox checkBoxDECTPowerLimit = null;
    private AastraPanel tabWLAN = null;
    private AastraPanel panelWLAN = null;
    private AastraLabel labelWLANRegDomain = null;
    private GuiUtilComboBox comboBoxWLANRegDomain = null;
    private AastraLabel labelInfoWLANRegDomain = null;
    private GuiUtilButtonBar panelWLANButtonBar = null;
    private UtilErrorComp utilErrorCompSoftwareImageURL = null;
    private AastraPanel tabSoftwareImageURL = null;
    private SystemUtilUrlBorderPanel panelSoftwareImageURL = null;
    private GuiUtilButtonBar panelSoftwareImageURLButtonBar = null;

    public SystemSettingsPanel(GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, CommonDataHandler commonDataHandler, SWManagementHandler sWManagementHandler, SiteSummaryHandler siteSummaryHandler) {
        this.commonDataHandler = commonDataHandler;
        this.swMgmtHandler = sWManagementHandler;
        this.siteSummaryHandler = siteSummaryHandler;
        this.omiManagement = GuiMain.getOmiManagementObject();
        this.guiStatusBar = GuiMain.getGuiStatusBarObject();
        this.omiManagement.registerManagementEventListener(this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.SystemName, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.RemoteAccess, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.SyslogCnf, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.ToneSchemeType, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.PARK, this);
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSARI)) {
            this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.SARI, this);
        }
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.DECTEncryption, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.DECTRegDomain, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.DECTPowerLimit, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.DECTAuthCode, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.PagingAreaSize, this);
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) {
            this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.PPDevAutoCreate, this);
            this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.PreserveUserDeviceRelation, this);
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.PPLoginVariant, this);
            }
        }
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.WLANRegDomainList, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.WLANRegDomain, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.RestrictedSubscriptionDuration, this);
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveTZones)) {
            this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.TimeZone, this);
            this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.TimeZoneList, this);
        }
        this.guiNavPanelType = guiNavPanelTypeEnum;
        if (this.swMgmtHandler != null) {
            this.swMgmtHandler.registerDataNotificationListener(this);
        }
        if (this.siteSummaryHandler != null) {
            this.siteSummaryHandler.registerSiteSummaryNotificationListener(this);
        }
        this.initialize();
        if (this.isEditable) {
            this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.ParkServerResult, this);
        }
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.setSize(new Dimension(800, 470));
        OmiMessage.DECTRegDomainType.None.setStrTranslated(UtilLocale.getString("TXT_NONE"));
        OmiMessage.WlanRegDomainInvalidType.None.setStrTranslated(UtilLocale.getString("TXT_NONE"));
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilErrorComp = new UtilErrorComp();
            this.toolsSystem = new SystemUtil.ToolsSystemSettings(this.utilErrorComp);
        } else {
            this.isEditable = false;
        }
        this.add(this.getTabbedPaneSysSet());
    }

    protected GuiUtilButtonBar getPanelGeneralButtonBar() {
        if (this.panelGeneralButtonBar == null) {
            this.panelGeneralButtonBar = new GuiUtilButtonBar(800, this.tabbedPaneSysSet, true, false);
            this.panelGeneralButtonBar.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SystemSettingsPanel)SystemSettingsPanel.this).panelGeneralButtonBar.utilChangeHandler.deactivate();
                    SystemSettingsPanel.this.utilErrorComp.clearComponents();
                    SystemSettingsPanel.this.changeGeneral();
                }
            });
            this.panelGeneralButtonBar.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SystemSettingsPanel)SystemSettingsPanel.this).panelGeneralButtonBar.utilChangeHandler.deactivate();
                    SystemSettingsPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.SystemName);
                    SystemSettingsPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.ToneSchemeType);
                    SystemSettingsPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.RemoteAccess);
                    SystemSettingsPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.SyslogCnf);
                    if (SystemSettingsPanel.this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveTZones)) {
                        SystemSettingsPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.TimeZone);
                    }
                    if (SystemSettingsPanel.this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveOMP)) {
                        SystemSettingsPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.OMP);
                    }
                    SystemSettingsPanel.this.swMgmtHandler.sendGetSoftwareUpdate();
                    SystemSettingsPanel.this.utilErrorComp.clearComponents();
                }
            });
            this.panelGeneralButtonBar.buttonUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SystemSettingsPanel.this.swMgmtHandler.sendSoftwareUpdate();
                    GuiInfoConsole.showInfo(UtilLocale.getString("TXT_PERFORMING_NEW_RFP_SW_SEARCH_IN_BACKGROUND"));
                }
            });
            this.panelGeneralButtonBar.buttonRestart.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SystemRestartDlg systemRestartDlg = new SystemRestartDlg(SystemSettingsPanel.this.swMgmtHandler);
                    systemRestartDlg.setVisible(true);
                }
            });
        }
        return this.panelGeneralButtonBar;
    }

    protected GuiUtilButtonBar getPanelDECTButtonBar() {
        if (this.panelDECTButtonBar == null) {
            this.panelDECTButtonBar = new GuiUtilButtonBar(800, this.tabbedPaneSysSet, false, true);
            this.panelDECTButtonBar.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SystemSettingsPanel)SystemSettingsPanel.this).panelDECTButtonBar.utilChangeHandler.deactivate();
                    SystemSettingsPanel.this.utilErrorComp.clearComponents();
                    SystemSettingsPanel.this.changeDECT();
                }
            });
            this.panelDECTButtonBar.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SystemSettingsPanel)SystemSettingsPanel.this).panelDECTButtonBar.utilChangeHandler.deactivate();
                    SystemSettingsPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.PARK);
                    SystemSettingsPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.DECTEncryption);
                    SystemSettingsPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.RestrictedSubscriptionDuration);
                    SystemSettingsPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.DECTRegDomain);
                    SystemSettingsPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.DECTPowerLimit);
                    SystemSettingsPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.DECTAuthCode);
                    SystemSettingsPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.PagingAreaSize);
                    if (SystemSettingsPanel.this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) {
                        SystemSettingsPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.PPDevAutoCreate);
                        SystemSettingsPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.PreserveUserDeviceRelation);
                        if (SystemSettingsPanel.this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                            SystemSettingsPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.PPLoginVariant);
                        }
                    }
                    if (SystemSettingsPanel.this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.havePPFirmwareUpdate)) {
                        SystemSettingsPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.PPFirmwareUpdate);
                    }
                    SystemSettingsPanel.this.utilErrorComp.clearComponents();
                }
            });
        }
        return this.panelDECTButtonBar;
    }

    protected GuiUtilButtonBar getPanelWLANButtonBar() {
        if (this.panelWLANButtonBar == null) {
            this.panelWLANButtonBar = new GuiUtilButtonBar(800, this.tabbedPaneSysSet);
            this.panelWLANButtonBar.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SystemSettingsPanel)SystemSettingsPanel.this).panelWLANButtonBar.utilChangeHandler.deactivate();
                    SystemSettingsPanel.this.utilErrorComp.clearComponents();
                    SystemSettingsPanel.this.changeWLAN();
                }
            });
            this.panelWLANButtonBar.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SystemSettingsPanel)SystemSettingsPanel.this).panelWLANButtonBar.utilChangeHandler.deactivate();
                    SystemSettingsPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.WLANRegDomain);
                    SystemSettingsPanel.this.utilErrorComp.clearComponents();
                }
            });
        }
        return this.panelWLANButtonBar;
    }

    private SysSetTabbedPane getTabbedPaneSysSet() {
        if (this.tabbedPaneSysSet == null) {
            this.tabbedPaneSysSet = new SysSetTabbedPane();
            this.tabbedPaneSysSet.setPreferredSize(new Dimension(800, 535));
            this.tabbedPaneSysSet.setMaximumSize(new Dimension(800, 535));
            this.tabbedPaneSysSet.setAlignmentX(0.0f);
            this.tabbedPaneSysSet.addTab(UtilLocale.getString("TXT_GENERAL"), this.getTabGeneral());
            this.tabbedPaneSysSet.addTab("DECT", this.getTabDECT());
            this.tabbedPaneSysSet.addTab("WLAN", this.getTabWLAN());
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSoftwareImageURL)) {
                this.tabbedPaneSysSet.addTab(UtilLocale.getString("TXT_SOFTWARE_UPDATE_URL"), this.getTabSoftwareImageURL());
            }
        }
        return this.tabbedPaneSysSet;
    }

    private AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            this.tabGeneral = new AastraPanel();
            this.tabGeneral.setLayout(new BoxLayout(this.tabGeneral, 1));
            this.getPanelGeneralButtonBar();
            this.tabGeneral.add(Box.createRigidArea(new Dimension(0, 10)));
            this.tabGeneral.add(this.getPanelGeneral());
            this.tabGeneral.add(Box.createRigidArea(new Dimension(0, 10)));
            this.tabGeneral.add(this.getPanelSysLog());
            this.tabGeneral.add(Box.createRigidArea(new Dimension(0, 10)));
            this.tabGeneral.add(this.getPanelRfpSwUpdate());
            if (this.isEditable) {
                if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveTZones)) {
                    this.tabGeneral.add(Box.createRigidArea(new Dimension(0, 15)));
                } else {
                    this.tabGeneral.add(Box.createRigidArea(new Dimension(0, 45)));
                }
                this.tabGeneral.add(this.panelGeneralButtonBar);
            }
        }
        return this.tabGeneral;
    }

    private AastraPanel getPanelGeneral() {
        if (this.panelGeneral == null) {
            int n = 125;
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveTZones)) {
                n += 30;
            }
            this.panelGeneral = new GuiUtilBorderPanel(n, UtilLocale.getString("TXT_GENERAL"));
            this.labelSystemName = new AastraLabel();
            this.labelSystemName.setBounds(30, 30, 120, 16);
            this.labelSystemName.setText(UtilLocale.getString("TXT_SYSTEM_NAME"));
            this.labelRemoteAccess = new AastraLabel();
            this.labelRemoteAccess.setBounds(30, 60, 120, 16);
            this.labelRemoteAccess.setText(UtilLocale.getString("TXT_REMOTE_ACCESS"));
            this.labelToneScheme = new AastraLabel();
            this.labelToneScheme.setBounds(30, 90, 130, 16);
            this.labelToneScheme.setText(UtilLocale.getString("TXT_TONE_SCHEME"));
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveTZones)) {
                this.labelTZone = new AastraLabel();
                this.labelTZone.setBounds(30, 120, 120, 16);
                this.labelTZone.setText(UtilLocale.getString("TXT_TIME_ZONE"));
            }
            this.panelGeneral.add(this.labelSystemName);
            this.panelGeneral.add(this.getTextFieldSystemName());
            this.panelGeneral.add(this.labelRemoteAccess);
            this.panelGeneral.add(this.getCheckBoxRemoteAccess());
            this.panelGeneral.add(this.labelToneScheme);
            this.panelGeneral.add(this.getComboBoxToneSchemeType());
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveTZones)) {
                this.panelGeneral.add(this.labelTZone);
                this.panelGeneral.add(this.getComboBoxTZone());
            }
            if (this.isEditable) {
                this.utilErrorComp.put(OmiMessage.attribIds.name.toString(), this.labelSystemName, this.textFieldSystemName, this.panelGeneralButtonBar);
            } else {
                UtilSetPanelEditable.setDisabled(this.panelGeneral);
            }
        }
        return this.panelGeneral;
    }

    private GuiUtilTextField getTextFieldSystemName() {
        if (this.textFieldSystemName == null) {
            this.textFieldSystemName = new GuiUtilTextField(this.panelGeneralButtonBar.utilChangeHandler);
            this.textFieldSystemName.setBounds(250, 30, 150, 18);
        }
        return this.textFieldSystemName;
    }

    private GuiUtilCheckBox getCheckBoxRemoteAccess() {
        if (this.checkBoxRemoteAccess == null) {
            this.checkBoxRemoteAccess = new GuiUtilCheckBox(this.panelGeneralButtonBar.utilChangeHandler, 245, 60);
        }
        return this.checkBoxRemoteAccess;
    }

    private GuiUtilComboBox getComboBoxTZone() {
        if (this.comboBoxTZone == null) {
            this.comboBoxTZone = new GuiUtilComboBox(this.panelGeneralButtonBar.utilChangeHandler);
            this.comboBoxTZone.setBounds(250, 120, 260, 20);
            this.comboBoxTZone.activateActionListener();
        }
        return this.comboBoxTZone;
    }

    private GuiUtilCheckBox getCheckBoxSysLogActive() {
        if (this.checkBoxSysLogActive == null) {
            this.checkBoxSysLogActive = new GuiUtilCheckBox(this.panelGeneralButtonBar.utilChangeHandler, 245, 30);
        }
        return this.checkBoxSysLogActive;
    }

    private GuiUtilComboBox getComboBoxToneSchemeType() {
        if (this.comboBoxToneScheme == null) {
            this.comboBoxToneScheme = new GuiUtilComboBox(this.panelGeneralButtonBar.utilChangeHandler);
            this.comboBoxToneScheme.setBounds(250, 90, 60, 20);
            for (int i = 0; i < OmiMessage.ToneSchemeType.values().length; ++i) {
                this.comboBoxToneScheme.addItem(OmiMessage.ToneSchemeType.values()[i]);
            }
            this.comboBoxToneScheme.activateActionListener();
        }
        return this.comboBoxToneScheme;
    }

    private AastraPanel getPanelSysLog() {
        if (this.panelSysLog == null) {
            this.panelSysLog = new GuiUtilBorderPanel(125, "SysLog");
            GuiUtilElementCollection.setChangeHandler(this.panelGeneralButtonBar.utilChangeHandler);
            GuiUtilElementCollection.GuiElement guiElement = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_ACTIVE"), 30, 130, GuiUtilCheckBox.class, 245, 45);
            this.checkBoxSysLogActive = guiElement.getCheckBox();
            GuiUtilElementCollection.GuiElement guiElement2 = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_IP_ADDRESS"), 30, 130, GuiUtilTextField.class, 250, 150);
            this.textFieldSysLogIPAddress = guiElement2.getTextField();
            GuiUtilElementCollection.GuiElement guiElement3 = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_PORT"), 30, 130, GuiUtilTextField.class, 250, 60);
            this.textFieldSysLogPort = guiElement3.getTextField();
            this.textFieldSysLogPort.setToolTipText(UtilLocale.getString("TXT_DEFAULT") + ": 514");
            GuiUtilElementCollection.GuiElement guiElement4 = new GuiUtilElementCollection.GuiElement("<html>" + UtilLocale.getString("TXT_INFO_SYSLOG") + "</html>", 440, 280, null, 0, 0);
            this.labelInfoSysLog = guiElement4.label;
            this.labelInfoSysLog.setIcon(GuiUtilIcon.getIconInfo(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
            guiElement4.labelYSize = 47;
            GuiUtilElementCollection.GuiElement guiElement5 = new GuiUtilElementCollection.GuiElement("<html>" + UtilLocale.getString("TXT_FORWARD_OMMLOG_TO_SYSLOG") + "</html>", 440, 180, GuiUtilCheckBox.class, 620, 45);
            this.checkBoxSysLogForward = guiElement5.getCheckBox();
            guiElement5.ySize = 25;
            guiElement5.labelYSize = 31;
            if (!this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveOmmLogForward)) {
                this.checkBoxSysLogForward.setVisible(false);
                this.labelInfoSysLog.setVisible(false);
                guiElement5.label.setVisible(false);
            }
            this.checkBoxSysLogForward.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (SystemSettingsPanel.this.checkBoxSysLogForward.isSelected()) {
                        SystemSettingsPanel.this.labelInfoSysLog.setText("<html>" + UtilLocale.getString("TXT_FORWARD_OMMLOG_WARNING") + "</html>");
                        SystemSettingsPanel.this.labelInfoSysLog.setIcon(GuiUtilIcon.getIconWarning(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                    } else {
                        SystemSettingsPanel.this.labelInfoSysLog.setText("<html>" + UtilLocale.getString("TXT_INFO_SYSLOG") + "</html>");
                        SystemSettingsPanel.this.labelInfoSysLog.setIcon(GuiUtilIcon.getIconInfo(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                    }
                }
            });
            GuiUtilElementCollection guiUtilElementCollection = new GuiUtilElementCollection();
            guiUtilElementCollection.addElement(guiElement);
            guiUtilElementCollection.addElement(guiElement5);
            guiUtilElementCollection.addElement(guiElement2);
            guiUtilElementCollection.addElement(guiElement4);
            guiUtilElementCollection.addElement(guiElement3);
            guiUtilElementCollection.addToPanel(this.panelSysLog);
            if (this.isEditable) {
                this.utilErrorComp.put(OmiMessage.SyslogCnfType.port.toString(), guiElement3.label, this.textFieldSysLogPort, this.panelGeneralButtonBar);
                this.utilErrorComp.put(OmiMessage.SyslogCnfType.ipAddr.toString(), guiElement2.label, this.textFieldSysLogIPAddress, this.panelGeneralButtonBar);
                this.utilErrorComp.put(OmiMessage.SyslogCnfType.forward.toString(), guiElement5.label, this.checkBoxSysLogForward, this.panelGeneralButtonBar);
            } else {
                UtilSetPanelEditable.setDisabled(this.panelSysLog);
            }
        }
        return this.panelSysLog;
    }

    private void setSyslogForward(boolean bl) {
        if (this.checkBoxSysLogForward != null && this.checkBoxSysLogForward.isVisible()) {
            this.checkBoxSysLogForward.setSelected(bl);
        }
    }

    private AastraPanel getPanelRfpSwUpdate() {
        if (this.panelRfpSwUpdate == null) {
            this.panelRfpSwUpdate = new GuiUtilBorderPanel(125, UtilLocale.getString("TXT_RFP_SW_UPDATE"));
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(30, 30, 220, 16);
            aastraLabel.setText(UtilLocale.getString("TXT_MODE"));
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setBounds(30, 60, 220, 16);
            aastraLabel2.setText(UtilLocale.getString("TXT_TIME_CONTROLLED"));
            AastraLabel aastraLabel3 = new AastraLabel();
            aastraLabel3.setBounds(350, 60, 150, 16);
            aastraLabel3.setText(UtilLocale.getString("TXT_UPDATE_TIME"));
            aastraLabel3.setHorizontalAlignment(4);
            AastraLabel aastraLabel4 = new AastraLabel();
            aastraLabel4.setBounds(538, 60, 10, 16);
            aastraLabel4.setText(":");
            AastraLabel aastraLabel5 = new AastraLabel();
            aastraLabel5.setBounds(30, 90, 150, 16);
            aastraLabel5.setText(UtilLocale.getString("TXT_MAXIMUM_DELAY"));
            AastraLabel aastraLabel6 = new AastraLabel();
            aastraLabel6.setBounds(290, 90, 50, 16);
            aastraLabel6.setText(UtilLocale.getString("TXT_UNIT_MINUTE"));
            AastraLabel aastraLabel7 = new AastraLabel();
            aastraLabel7.setBounds(350, 90, 150, 16);
            aastraLabel7.setText(UtilLocale.getString("TXT_CALCULATED_UPDATE_TIME"));
            aastraLabel7.setHorizontalAlignment(4);
            AastraLabel aastraLabel8 = new AastraLabel();
            aastraLabel8.setBounds(538, 90, 10, 16);
            aastraLabel8.setText(":");
            this.panelRfpSwUpdate.add(aastraLabel);
            this.panelRfpSwUpdate.add(this.getComboBoxRfpSwUpdateMode());
            this.panelRfpSwUpdate.add(aastraLabel2);
            this.panelRfpSwUpdate.add(this.getCheckBoxTimedUpdate());
            this.panelRfpSwUpdate.add(aastraLabel3);
            this.panelRfpSwUpdate.add(this.getTextFieldUpdateHour());
            this.panelRfpSwUpdate.add(aastraLabel4);
            this.panelRfpSwUpdate.add(this.getTextFieldUpdateMinute());
            this.panelRfpSwUpdate.add(aastraLabel5);
            this.panelRfpSwUpdate.add(this.getTextFieldUpdateMaxDelay());
            this.panelRfpSwUpdate.add(aastraLabel6);
            this.panelRfpSwUpdate.add(aastraLabel7);
            this.panelRfpSwUpdate.add(this.getTextFieldUpdateHourCalc());
            this.panelRfpSwUpdate.add(aastraLabel8);
            this.panelRfpSwUpdate.add(this.getTextFieldUpdateMinuteCalc());
            if (this.isEditable) {
                this.utilErrorComp.put(OmiMessage.SoftwareUpdateType.hour.name(), aastraLabel3, this.textFieldUpdateHour, this.panelGeneralButtonBar);
                this.utilErrorComp.put(OmiMessage.SoftwareUpdateType.minute.name(), aastraLabel3, this.textFieldUpdateMinute, this.panelGeneralButtonBar);
                this.utilErrorComp.put(OmiMessage.SoftwareUpdateType.maxDelay.name(), aastraLabel5, this.textFieldUpdateMaxDelay, this.panelGeneralButtonBar);
            } else {
                UtilSetPanelEditable.setDisabled(this.panelRfpSwUpdate);
            }
        }
        return this.panelRfpSwUpdate;
    }

    private GuiUtilComboBox getComboBoxRfpSwUpdateMode() {
        if (this.comboBoxRfpSwUpdateMode == null) {
            this.comboBoxRfpSwUpdateMode = new GuiUtilComboBox(this.panelGeneralButtonBar.utilChangeHandler);
            this.comboBoxRfpSwUpdateMode.setBounds(250, 30, 170, 20);
            this.comboBoxRfpSwUpdateMode.addItem(UtilLocale.getString("TXT_ONE_BY_ONE"));
            this.comboBoxRfpSwUpdateMode.addItem(UtilLocale.getString("TXT_ALL_AT_ONCE"));
            this.comboBoxRfpSwUpdateMode.activateActionListener();
        }
        return this.comboBoxRfpSwUpdateMode;
    }

    private GuiUtilCheckBox getCheckBoxTimedUpdate() {
        if (this.checkBoxTimedUpdate == null) {
            this.checkBoxTimedUpdate = new GuiUtilCheckBox(this.panelGeneralButtonBar.utilChangeHandler, 245, 60);
            this.checkBoxTimedUpdate.setToolTipText(UtilLocale.getString("TXT_RFP_TIMED_UPDATE_HELP"));
            if (this.isEditable) {
                this.checkBoxTimedUpdate.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        boolean bl = ((GuiUtilCheckBox)actionEvent.getSource()).isSelected();
                        SystemSettingsPanel.this.textFieldUpdateHour.setEditable(bl);
                        SystemSettingsPanel.this.textFieldUpdateMinute.setEditable(bl);
                        SystemSettingsPanel.this.textFieldUpdateMaxDelay.setEditable(bl);
                        if (!bl) {
                            SystemSettingsPanel.this.utilErrorComp.clearComponent(SystemSettingsPanel.this.textFieldUpdateHour);
                            SystemSettingsPanel.this.utilErrorComp.clearComponent(SystemSettingsPanel.this.textFieldUpdateMinute);
                            SystemSettingsPanel.this.utilErrorComp.clearComponent(SystemSettingsPanel.this.textFieldUpdateMaxDelay);
                        }
                    }
                });
            }
        }
        return this.checkBoxTimedUpdate;
    }

    private GuiUtilTextFieldTime.GuiUtilTextFieldHour getTextFieldUpdateHour() {
        if (this.textFieldUpdateHour == null) {
            GuiUtilTextFieldTime guiUtilTextFieldTime = new GuiUtilTextFieldTime();
            guiUtilTextFieldTime.getClass();
            this.textFieldUpdateHour = guiUtilTextFieldTime.new GuiUtilTextFieldTime.GuiUtilTextFieldHour(510, 60, this.panelGeneralButtonBar.utilChangeHandler);
        }
        return this.textFieldUpdateHour;
    }

    private GuiUtilTextFieldTime.GuiUtilTextFieldMinute getTextFieldUpdateMinute() {
        if (this.textFieldUpdateMinute == null) {
            GuiUtilTextFieldTime guiUtilTextFieldTime = new GuiUtilTextFieldTime();
            guiUtilTextFieldTime.getClass();
            this.textFieldUpdateMinute = guiUtilTextFieldTime.new GuiUtilTextFieldTime.GuiUtilTextFieldMinute(545, 60, this.panelGeneralButtonBar.utilChangeHandler);
        }
        return this.textFieldUpdateMinute;
    }

    private GuiUtilTextField getTextFieldUpdateMaxDelay() {
        if (this.textFieldUpdateMaxDelay == null) {
            this.textFieldUpdateMaxDelay = new GuiUtilTextField(this.panelGeneralButtonBar.utilChangeHandler);
            this.textFieldUpdateMaxDelay.setBounds(250, 90, 35, 18);
        }
        return this.textFieldUpdateMaxDelay;
    }

    private GuiUtilTextFieldTime.GuiUtilTextFieldHour getTextFieldUpdateHourCalc() {
        if (this.textFieldUpdateHourCalc == null) {
            GuiUtilTextFieldTime guiUtilTextFieldTime = new GuiUtilTextFieldTime();
            guiUtilTextFieldTime.getClass();
            this.textFieldUpdateHourCalc = guiUtilTextFieldTime.new GuiUtilTextFieldTime.GuiUtilTextFieldHour(510, 90);
        }
        return this.textFieldUpdateHourCalc;
    }

    private GuiUtilTextFieldTime.GuiUtilTextFieldMinute getTextFieldUpdateMinuteCalc() {
        if (this.textFieldUpdateMinuteCalc == null) {
            GuiUtilTextFieldTime guiUtilTextFieldTime = new GuiUtilTextFieldTime();
            guiUtilTextFieldTime.getClass();
            this.textFieldUpdateMinuteCalc = guiUtilTextFieldTime.new GuiUtilTextFieldTime.GuiUtilTextFieldMinute(545, 90);
        }
        return this.textFieldUpdateMinuteCalc;
    }

    private AastraPanel getTabDECT() {
        if (this.tabDECT == null) {
            this.tabDECT = new AastraPanel();
            this.getPanelDECTButtonBar();
            this.tabDECT.setLayout(new BoxLayout(this.tabDECT, 1));
            this.tabDECT.add(Box.createRigidArea(new Dimension(0, 10)));
            this.tabDECT.add(this.getPanelDECT());
            if (this.isEditable) {
                this.tabDECT.add(Box.createRigidArea(new Dimension(0, 10)));
                this.tabDECT.add(this.panelDECTButtonBar);
            }
        }
        return this.tabDECT;
    }

    private AastraPanel getPanelDECT() {
        if (this.panelDECT == null) {
            GuiUtilElementCollection.GuiElement guiElement = null;
            GuiUtilElementCollection.GuiElement guiElement2 = null;
            this.panelDECT = new GuiUtilBorderPanel(420);
            int n = 30;
            int n2 = 250;
            int n3 = 210;
            int n4 = 470;
            GuiUtilElementCollection.setChangeHandler(this.panelDECTButtonBar.utilChangeHandler);
            GuiUtilElementCollection.GuiElement guiElement3 = new GuiUtilElementCollection.GuiElement("PARK", n, n3, GuiUtilTextField.class, n2, 150);
            this.textFieldPARK = guiElement3.getTextField();
            this.textFieldPARK.setEditable(false);
            GuiUtilElementCollection.GuiElement guiElement4 = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_PARK_CONFIGURATION"), 0, 0, AastraButton.class, n4, 106);
            this.buttonPARKDlg = guiElement4.getButton();
            this.buttonPARKDlg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SystemPARKDialog systemPARKDialog = new SystemPARKDialog(GuiMain.getGuiMainObject());
                    systemPARKDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                    systemPARKDialog.setVisible(true);
                }
            });
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSARI)) {
                guiElement = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_SARI"), n, n3, GuiUtilTextField.class, n2, 150);
                this.textFieldSARI = guiElement.getTextField();
                this.textFieldSARI.setEditable(false);
                guiElement2 = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_GENERATE_SARI_20"), 0, 0, AastraButton.class, n4, 106);
                this.buttonSARI = guiElement2.getButton();
                this.buttonSARI.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SystemSettingsPanel.this.buttonSARI.setVisible(false);
                        SystemSettingsPanel.this.generateSARI();
                    }
                });
            }
            GuiUtilElementCollection.GuiElement guiElement5 = new GuiUtilElementCollection.GuiElement("<html>" + UtilLocale.getString("TXT_DECT_AUTHENTICATION_CODE") + "</html>", 30, n3, GuiUtilTextField.class, n2, 150);
            guiElement5.labelYSize = 31;
            this.textFieldDECTAuthCode = guiElement5.getTextField();
            GuiUtilElementCollection.GuiElement guiElement6 = new GuiUtilElementCollection.GuiElement("<html>" + UtilLocale.getString("TXT_REGULATORY_DOMAIN") + "</html>", 30, n3, GuiUtilComboBox.class, n2, 200);
            this.comboBoxDECTRegDomain = guiElement6.getComboBox();
            for (int i = 1; i < OmiMessage.DECTRegDomainType.values().length; ++i) {
                this.comboBoxDECTRegDomain.addItem(OmiMessage.DECTRegDomainType.values()[i].getStrTranslated());
            }
            this.comboBoxDECTRegDomain.activateActionListener();
            GuiUtilElementCollection.GuiElement guiElement7 = new GuiUtilElementCollection.GuiElement("<html>" + UtilLocale.getString("TXT_INFO_SET_DECT_REGULATORY_DOMAIN") + "</html>", n4, 300, null, 0, 0);
            guiElement7.label.setIcon(GuiUtilIcon.getIconInfo(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
            guiElement7.labelYSize = 47;
            GuiUtilElementCollection.GuiElement guiElement8 = new GuiUtilElementCollection.GuiElement("<html>" + UtilLocale.getString("TXT_PAGING_AREA_SIZE") + "</html>", 30, n3, GuiUtilComboBox.class, n2, 200);
            guiElement8.labelYSize = 31;
            this.comboBoxPagingAreaSize = guiElement8.getComboBox();
            for (int i = 0; i < this.pagingAreaSizeArray.length; ++i) {
                this.comboBoxPagingAreaSize.addItem(this.pagingAreaSizeArray[i] + " " + UtilLocale.getString("TXT_RFPS"));
            }
            this.comboBoxPagingAreaSize.setSelectedIndex(this.pagingAreaSizeArray.length - 1);
            this.comboBoxPagingAreaSize.activateActionListener();
            GuiUtilElementCollection.GuiElement guiElement9 = new GuiUtilElementCollection.GuiElement("<html>" + UtilLocale.getString("TXT_DECT_POWER_LIMIT_100MW") + "</html>", 30, n3, GuiUtilCheckBox.class, n2 - 5, 50);
            guiElement9.labelYSize = 31;
            this.checkBoxDECTPowerLimit = guiElement9.getCheckBox();
            GuiUtilElementCollection.GuiElement guiElement10 = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_ENCRYPTION"), 30, n3, GuiUtilCheckBox.class, n2 - 5, 50);
            this.checkBoxDECTEncryption = guiElement10.getCheckBox();
            GuiUtilElementCollection.GuiElement guiElement11 = new GuiUtilElementCollection.GuiElement("<html>" + UtilLocale.getString("TXT_RESTRICTED_SUBSCRIPTION_DURATION") + "</html>", 30, n3, GuiUtilCheckBox.class, n2 - 5, 50);
            guiElement11.labelYSize = 31;
            this.checkBoxRestrictedSubscriptionDuration = guiElement11.getCheckBox();
            GuiUtilElementCollection.GuiElement guiElement12 = null;
            GuiUtilElementCollection.GuiElement guiElement13 = null;
            GuiUtilElementCollection.GuiElement guiElement14 = null;
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) {
                guiElement12 = new GuiUtilElementCollection.GuiElement("<html>" + UtilLocale.getString("TXT_AUTO-CREATE_ON_SUBSCRIPTION") + "</html>", 30, n3, GuiUtilCheckBox.class, n2 - 5, 50);
                guiElement12.labelYSize = 31;
                this.checkBoxPpDevAutoCreate = guiElement12.getCheckBox();
                if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                    guiElement13 = new GuiUtilElementCollection.GuiElement("<html>" + UtilLocale.getString("TXT_PP_USER_LOGIN_TYPE") + "</html>", 30, n3, GuiUtilComboBox.class, n2, 200);
                    guiElement13.labelYSize = 31;
                    OmiMessage.PPLoginVariantType.NUMBER.setTxt(UtilLocale.getString("TXT_PHONE_NUMBER_/_SIP_USER_NAME_20"));
                    OmiMessage.PPLoginVariantType.ID.setTxt(UtilLocale.getString("TXT_LOGIN_ID"));
                    this.comboBoxPPLoginType = guiElement13.getComboBox();
                    this.comboBoxPPLoginType.addItem(OmiMessage.PPLoginVariantType.NUMBER.txt);
                    this.comboBoxPPLoginType.addItem(OmiMessage.PPLoginVariantType.ID.txt);
                    this.comboBoxPPLoginType.activateActionListener();
                }
                guiElement14 = new GuiUtilElementCollection.GuiElement("<html>" + UtilLocale.getString("TXT_PRESERVE_USER_DEV_RELS") + "</html>", 30, n3, GuiUtilCheckBox.class, n2 - 5, 50);
                guiElement14.labelYSize = 47;
                this.checkBoxPreserveUserDeviceRelation = guiElement14.getCheckBox();
            }
            GuiUtilElementCollection guiUtilElementCollection = new GuiUtilElementCollection();
            guiUtilElementCollection.addElement(guiElement3);
            if (this.isEditable) {
                guiUtilElementCollection.addElement(guiElement4);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSARI)) {
                guiUtilElementCollection.addElement(guiElement);
                if (this.isEditable) {
                    guiUtilElementCollection.addElement(guiElement2);
                }
            }
            guiUtilElementCollection.addElement(guiElement5);
            guiUtilElementCollection.addElement(guiElement6);
            if (this.isEditable) {
                guiUtilElementCollection.addElement(guiElement7);
            }
            guiUtilElementCollection.addElement(guiElement8);
            guiUtilElementCollection.addElement(guiElement9);
            guiUtilElementCollection.addElement(guiElement10);
            guiUtilElementCollection.addElement(guiElement11);
            if (guiElement12 != null) {
                guiUtilElementCollection.addElement(guiElement12);
            }
            if (guiElement13 != null) {
                guiUtilElementCollection.addElement(guiElement13);
            }
            if (guiElement14 != null) {
                guiUtilElementCollection.addElement(guiElement14);
            }
            guiUtilElementCollection.addToPanel(this.panelDECT);
            if (this.isEditable) {
                this.utilErrorComp.put(OmiMessage.attribIds.park.toString(), guiElement3.label, this.textFieldPARK, this.panelDECTButtonBar);
                if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSARI)) {
                    this.utilErrorComp.put(OmiMessage.attribIds.sari.toString(), guiElement.label, this.textFieldSARI, this.panelDECTButtonBar);
                }
                this.utilErrorComp.put(OmiMessage.attribIds.ac.toString(), guiElement5.label, this.textFieldDECTAuthCode, this.panelDECTButtonBar);
                this.utilErrorComp.put(OmiMessage.attribIds.enable.toString(), guiElement10.label, this.checkBoxDECTEncryption, this.panelDECTButtonBar);
            } else {
                UtilSetPanelEditable.setDisabled(this.panelDECT);
            }
        }
        return this.panelDECT;
    }

    private void enableCheckBoxDECTEncryption() {
        if (this.checkBoxDECTEncryption == null) {
            return;
        }
        if (this.checkBoxDECTEncryption.isSelected() && this.siteSummaryHandler.getSummary().dectSecuritySiteNum > 0) {
            this.checkBoxDECTEncryption.setEnabled(false);
            this.checkBoxDECTEncryption.setToolTipText(UtilLocale.getString("TXT_ENCRYPTION_TOOL_TIP"));
        } else {
            this.checkBoxDECTEncryption.setEnabled(true);
            this.checkBoxDECTEncryption.setToolTipText(null);
        }
    }

    private void generateSARI() {
        String string = this.textFieldPARK.getText();
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.SARI.toString() + "='" + string + "'");
        this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.SARI, string);
        this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.SARI);
    }

    private void buttonSARISetVisible() {
        if (this.buttonSARI != null) {
            if (this.textFieldPARK != null && this.textFieldSARI != null && !this.textFieldPARK.getText().isEmpty() && !SystemSettingsPanel.isSariSet()) {
                this.buttonSARI.setVisible(true);
                return;
            }
            this.buttonSARI.setVisible(false);
        }
    }

    private AastraPanel getTabWLAN() {
        if (this.tabWLAN == null) {
            this.tabWLAN = new AastraPanel();
            this.tabWLAN.setLayout(new BoxLayout(this.tabWLAN, 1));
            this.getPanelWLANButtonBar();
            this.tabWLAN.add(Box.createRigidArea(new Dimension(0, 10)));
            this.tabWLAN.add(this.getPanelWLAN());
            if (this.isEditable) {
                this.tabWLAN.add(Box.createRigidArea(new Dimension(0, 310)));
                this.tabWLAN.add(this.panelWLANButtonBar);
            }
        }
        return this.tabWLAN;
    }

    private AastraPanel getPanelWLAN() {
        if (this.panelWLAN == null) {
            this.panelWLAN = new GuiUtilBorderPanel(90);
            this.labelWLANRegDomain = new AastraLabel();
            this.labelWLANRegDomain.setBounds(30, 30, 121, 31);
            this.labelWLANRegDomain.setText("<html>" + UtilLocale.getString("TXT_REGULATORY_DOMAIN") + "</html>");
            this.labelInfoWLANRegDomain = new AastraLabel();
            this.labelInfoWLANRegDomain.setBounds(400, 25, 280, 47);
            this.labelInfoWLANRegDomain.setText("<html>" + UtilLocale.getString("TXT_INFO_SET_WLAN_REGULATORY_DOMAIN") + "</html>");
            this.labelInfoWLANRegDomain.setIcon(GuiUtilIcon.getIconInfo(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
            this.panelWLAN.add(this.labelWLANRegDomain);
            this.panelWLAN.add(this.getComboBoxWLANRegDomain());
            this.panelWLAN.add(this.labelInfoWLANRegDomain);
            if (!this.isEditable) {
                UtilSetPanelEditable.setDisabled(this.panelWLAN);
            }
        }
        return this.panelWLAN;
    }

    private GuiUtilComboBox getComboBoxWLANRegDomain() {
        if (this.comboBoxWLANRegDomain == null) {
            this.comboBoxWLANRegDomain = new GuiUtilComboBox(this.panelWLANButtonBar.utilChangeHandler);
            this.comboBoxWLANRegDomain.setBounds(165, 30, 150, 20);
            this.comboBoxWLANRegDomain.activateActionListener();
        }
        return this.comboBoxWLANRegDomain;
    }

    private void fillComboBoxWLANRegDomain() {
        this.getComboBoxWLANRegDomain();
        String[] stringArray = new String[]{};
        this.comboBoxWLANRegDomain.deactivateActionListener();
        try {
            stringArray = (String[])this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.WLANRegDomainList);
            this.comboBoxWLANRegDomain.removeAllItems();
            for (int i = 0; i < stringArray.length; ++i) {
                this.comboBoxWLANRegDomain.addItem(stringArray[i]);
            }
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.WLANRegDomainList.toString() + " failed");
        }
        this.comboBoxWLANRegDomain.activateActionListener();
    }

    private AastraPanel getTabSoftwareImageURL() {
        if (this.tabSoftwareImageURL == null) {
            this.tabSoftwareImageURL = new AastraPanel();
            this.tabSoftwareImageURL.setLayout(new BoxLayout(this.tabSoftwareImageURL, 1));
            this.getPanelSoftwareImageURLButtonBar();
            this.tabSoftwareImageURL.add(Box.createRigidArea(new Dimension(0, 10)));
            this.tabSoftwareImageURL.add(this.getPanelSoftwareImageURL());
            if (this.isEditable) {
                this.tabSoftwareImageURL.add(this.panelSoftwareImageURLButtonBar);
            }
        }
        return this.tabSoftwareImageURL;
    }

    protected GuiUtilButtonBar getPanelSoftwareImageURLButtonBar() {
        if (this.panelSoftwareImageURLButtonBar == null) {
            this.panelSoftwareImageURLButtonBar = new GuiUtilButtonBar(800, this.tabbedPaneSysSet);
            this.panelSoftwareImageURLButtonBar.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SystemSettingsPanel)SystemSettingsPanel.this).panelSoftwareImageURLButtonBar.utilChangeHandler.deactivate();
                    SystemSettingsPanel.this.utilErrorCompSoftwareImageURL.clearComponents();
                    SystemSettingsPanel.this.changeSoftwareImageURL();
                }
            });
            this.panelSoftwareImageURLButtonBar.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SystemSettingsPanel)SystemSettingsPanel.this).panelSoftwareImageURLButtonBar.utilChangeHandler.deactivate();
                    SystemSettingsPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.SoftwareImageUrl);
                    SystemSettingsPanel.this.utilErrorCompSoftwareImageURL.clearComponents();
                }
            });
        }
        return this.panelSoftwareImageURLButtonBar;
    }

    public void changeSoftwareImageURL() {
        boolean bl = true;
        CommonDataHandler.UrlClass urlClass = new CommonDataHandler.UrlClass();
        urlClass = this.panelSoftwareImageURL.getUrl();
        if (urlClass == null) {
            bl = false;
        }
        if (bl) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + urlClass.toString() + ":" + urlClass + "'");
            this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.SoftwareImageUrl, urlClass);
            this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.SoftwareImageUrl);
        } else {
            this.panelSoftwareImageURLButtonBar.utilChangeHandler.activateOnError();
        }
    }

    private AastraPanel getPanelSoftwareImageURL() {
        if (this.panelSoftwareImageURL == null) {
            if (this.isEditable) {
                this.utilErrorCompSoftwareImageURL = new UtilErrorComp();
            }
            int n = 16639;
            this.panelSoftwareImageURL = new SystemUtilUrlBorderPanel(UtilLocale.getString("TXT_SOFTWARE_UPDATE_URL"), this.panelSoftwareImageURLButtonBar, this.utilErrorCompSoftwareImageURL, this.isEditable, n, null, null, true, null);
            this.panelSoftwareImageURL.setFileName("/iprfp3G.dnld");
            AastraLabel aastraLabel = this.panelSoftwareImageURL.labelActive;
            aastraLabel.setText("<html>" + UtilLocale.getString("TXT_CONFIGURE_SPECIFIC_SOURCE") + "</html>");
            aastraLabel.setSize(aastraLabel.getWidth(), 25);
            if (!this.isEditable) {
                UtilSetPanelEditable.setDisabled(this.panelSoftwareImageURL);
            }
            class CommonDataNotificationHandler
            implements CommonDataHandler.CommonDataNotificationInterface {
                CommonDataNotificationHandler() {
                }

                @Override
                public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
                    CommonDataHandler.UrlClass urlClass = null;
                    try {
                        urlClass = (CommonDataHandler.UrlClass)SystemSettingsPanel.this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.SoftwareImageUrl);
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading" + CommonDataHandler.CommonDataItemEnum.SoftwareImageUrl.toString() + "= '" + urlClass + "'");
                    }
                    catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.SoftwareImageUrl.toString() + " failed");
                        return;
                    }
                    SystemSettingsPanel.this.panelSoftwareImageURL.setUrl(urlClass);
                }

                @Override
                public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
                    String string = SystemSettingsPanel.this.commonDataErrorNotificationHandler(dataNotificationEnum, commonDataItemEnum, omiMessage, SystemSettingsPanel.this.utilErrorCompSoftwareImageURL);
                    if (string != null && string.equals(OmiMessage.URLType.password.name())) {
                        SystemSettingsPanel.this.utilErrorCompSoftwareImageURL.markComponent(((SystemSettingsPanel)SystemSettingsPanel.this).panelSoftwareImageURL.passwordFieldUrlPasswordConfirm);
                    }
                }
            }
            this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.SoftwareImageUrl, new CommonDataNotificationHandler());
        }
        return this.panelSoftwareImageURL;
    }

    public void changeGeneral() {
        CommonDataHandler.SyslogCnfClass syslogCnfClass = null;
        boolean bl = true;
        String string = null;
        String string2 = this.textFieldSystemName.getText();
        boolean bl2 = this.checkBoxRemoteAccess.isSelected();
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveTZones)) {
            string = this.tzoneList.list[this.comboBoxTZone.getSelectedIndex()].id;
        }
        syslogCnfClass = new CommonDataHandler.SyslogCnfClass();
        syslogCnfClass.enable = this.checkBoxSysLogActive.isSelected();
        String string3 = this.textFieldSysLogIPAddress.getText();
        if (UtilMisc.validateIPAddress(string3)) {
            syslogCnfClass.ipAddr = string3;
        } else {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_IP_ADDRESS_FORMAT_INVALID"));
            this.utilErrorComp.markComponent(this.textFieldSysLogIPAddress);
            bl = false;
        }
        syslogCnfClass.port = this.toolsSystem.getUnsignedDecimalIntFromTextField(this.textFieldSysLogPort, UtilLocale.getString("TXT_PORT"));
        if (syslogCnfClass.port == -1) {
            bl = false;
        }
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveOmmLogForward)) {
            syslogCnfClass.forward = this.checkBoxSysLogForward.isSelected();
        }
        OmiMessage.ToneSchemeType toneSchemeType = (OmiMessage.ToneSchemeType)((Object)this.comboBoxToneScheme.getSelectedItem());
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.ToneSchemeType.toString() + "=" + (Object)((Object)toneSchemeType));
        SWManagementHandler.SoftwareUpdate softwareUpdate = this.swMgmtHandler.getSwUpdate();
        softwareUpdate.allAtOnce = this.comboBoxRfpSwUpdateMode.getSelectedIndex() == 1;
        softwareUpdate.timedUpdate = this.checkBoxTimedUpdate.isSelected();
        if (softwareUpdate.timedUpdate) {
            softwareUpdate.hour = this.toolsSystem.getHourFromTextField(this.textFieldUpdateHour, UtilLocale.getString("TXT_HOUR"));
            if (softwareUpdate.hour == -1) {
                bl = false;
            }
            if ((softwareUpdate.minute = this.toolsSystem.getMinuteFromTextField(this.textFieldUpdateMinute, UtilLocale.getString("TXT_MINUTE"))) == -1) {
                bl = false;
            }
            if ((softwareUpdate.maxDelay = this.toolsSystem.getUnsignedDecimalIntFromTextField(this.textFieldUpdateMaxDelay, UtilLocale.getString("TXT_MAXIMUM_DELAY"))) == -1) {
                bl = false;
            }
        }
        if (bl) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.SystemName.toString() + "='" + string2 + "'");
            this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.SystemName, string2);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.RemoteAccess.toString() + "=" + bl2);
            this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.RemoteAccess, bl2);
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveTZones)) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.TimeZone.toString() + "=" + string);
                this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.TimeZone, string);
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.SyslogCnf.toString() + ":" + syslogCnfClass.enable + ",'" + syslogCnfClass.ipAddr + "'," + syslogCnfClass.port);
            this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.SyslogCnf, syslogCnfClass);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.ToneSchemeType.toString() + ":" + (Object)((Object)toneSchemeType));
            this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.ToneSchemeType, (Object)toneSchemeType);
            this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.SystemName);
            this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.RemoteAccess);
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveTZones)) {
                this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.TimeZone);
            }
            this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.SyslogCnf);
            this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.ToneSchemeType);
            this.swMgmtHandler.sendSoftwareUpdate(softwareUpdate);
        } else {
            this.panelGeneralButtonBar.utilChangeHandler.activateOnError();
        }
    }

    public void changeDECT() {
        int n;
        GuiUtilDialog guiUtilDialog;
        boolean bl = false;
        OmiMessage.PPLoginVariantType pPLoginVariantType = null;
        boolean bl2 = true;
        String string = this.textFieldPARK.getText();
        boolean bl3 = this.checkBoxDECTEncryption.isSelected();
        boolean bl4 = this.checkBoxRestrictedSubscriptionDuration.isSelected();
        OmiMessage.DECTRegDomainType dECTRegDomainType = null;
        try {
            dECTRegDomainType = (OmiMessage.DECTRegDomainType)((Object)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.DECTRegDomain));
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTRegDomain.toString() + "=" + (Object)((Object)dECTRegDomainType));
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTRegDomain.toString() + " failed");
        }
        OmiMessage.DECTRegDomainType dECTRegDomainType2 = OmiMessage.DECTRegDomainType.getValFromStrTranslated(this.comboBoxDECTRegDomain.getSelectedItem().toString());
        if ((dECTRegDomainType == null || dECTRegDomainType != null && dECTRegDomainType != dECTRegDomainType2) && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, String.format(UtilLocale.getString("TXT_WARNING_SET_DECT_REGULATORY_DOMAIN_*"), dECTRegDomainType2.getStrTranslated()), true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionNo) {
            this.comboBoxDECTRegDomain.deactivateActionListener();
            this.comboBoxDECTRegDomain.setEditable(true);
            this.comboBoxDECTRegDomain.setSelectedItem(dECTRegDomainType.getStrTranslated());
            this.comboBoxDECTRegDomain.setEditable(false);
            this.comboBoxDECTRegDomain.activateActionListener();
            bl2 = false;
        }
        boolean bl5 = this.checkBoxDECTPowerLimit.isSelected();
        String string2 = this.textFieldDECTAuthCode.getText();
        int n2 = this.comboBoxPagingAreaSize.getSelectedIndex();
        switch (n2) {
            case 0: {
                n = 16;
                break;
            }
            case 1: {
                n = 32;
                break;
            }
            case 2: {
                n = 64;
                break;
            }
            case 3: {
                n = 128;
                break;
            }
            default: {
                n = 256;
            }
        }
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) {
            bl = this.checkBoxPpDevAutoCreate.isSelected();
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                pPLoginVariantType = OmiMessage.PPLoginVariantType.getValFromTxt((String)this.comboBoxPPLoginType.getSelectedItem());
            }
        }
        if (bl2) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.PARK.toString() + "='" + string + "'");
            this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.PARK, string);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.DECTEncryption.toString() + "=" + bl3);
            this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.DECTEncryption, bl3);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.RestrictedSubscriptionDuration.toString() + "=" + bl4);
            this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.RestrictedSubscriptionDuration, bl4);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.DECTRegDomain.toString() + "=" + (Object)((Object)dECTRegDomainType2));
            this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.DECTRegDomain, (Object)dECTRegDomainType2);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.DECTPowerLimit.toString() + "=" + bl5);
            this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.DECTPowerLimit, bl5);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.DECTAuthCode.toString() + "='" + string2 + "'");
            this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.DECTAuthCode, string2);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.PagingAreaSize.toString() + "=" + n);
            this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.PagingAreaSize, n);
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.PPDevAutoCreate.toString() + "=" + bl);
                this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.PPDevAutoCreate, bl);
                boolean bl6 = this.checkBoxPreserveUserDeviceRelation.isSelected();
                this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.PreserveUserDeviceRelation, bl6);
                if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.PPLoginVariant.toString() + "=" + (Object)((Object)pPLoginVariantType));
                    this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.PPLoginVariant, (Object)pPLoginVariantType);
                }
            }
            this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.DECTEncryption);
            this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.RestrictedSubscriptionDuration);
            this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.DECTRegDomain);
            this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.DECTPowerLimit);
            this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.DECTAuthCode);
            this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.PagingAreaSize);
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) {
                this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.PPDevAutoCreate);
                this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.PreserveUserDeviceRelation);
                if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                    this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.PPLoginVariant);
                }
            }
        } else {
            this.panelDECTButtonBar.buttonCancel.setEnabled(true);
        }
    }

    public void changeWLAN() {
        Object object;
        boolean bl = true;
        String string = null;
        String string2 = null;
        try {
            string2 = ((CommonDataHandler.WLANRegDomainElem)this.commonDataHandler.getData((CommonDataHandler.CommonDataItemEnum)CommonDataHandler.CommonDataItemEnum.WLANRegDomain)).domain;
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.WLANRegDomain.toString() + "=" + string2);
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.WLANRegDomain.toString() + " failed");
        }
        string = (String)this.comboBoxWLANRegDomain.getSelectedItem();
        if ((string2 == null || string2 != null && !string2.equals(string)) && ((GuiUtilDialog)(object = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, String.format(UtilLocale.getString("TXT_WARNING_SET_WLAN_REGULATORY_DOMAIN_*"), string), true))).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionNo) {
            this.comboBoxWLANRegDomain.deactivateActionListener();
            this.comboBoxWLANRegDomain.setEditable(true);
            this.comboBoxWLANRegDomain.setSelectedItem(string2);
            this.comboBoxWLANRegDomain.setEditable(false);
            this.comboBoxWLANRegDomain.activateActionListener();
            bl = false;
        }
        if (bl) {
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveWLAN)) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + (Object)((Object)CommonDataHandler.CommonDataItemEnum.WLANRegDomain) + "=" + string);
                object = new CommonDataHandler.WLANRegDomainElem(string);
                this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.WLANRegDomain, object);
            }
            this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.WLANRegDomain);
        }
    }

    private String commonDataErrorNotificationHandler(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage, UtilErrorComp utilErrorComp) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        String string4 = omiMessage.getAttribVal(OmiMessage.attribIds.info.name());
        OmiMessage.errorCodes errorCodes2 = null;
        if (!this.isEditable || string == null) {
            return null;
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data error notification: " + dataNotificationEnum.toString() + ",item=" + String.valueOf((Object)commonDataItemEnum) + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        if (string4 != null) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "   info=" + string4);
        }
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data error notification: Unknown errorCode=" + string);
        }
        if (string4 != null && string2.equals(OmiMessage.attribIds.text.name())) {
            if (string4.contains(OmiMessage.elemIds.bootTextHeadline.name())) {
                string2 = OmiMessage.elemIds.bootTextHeadline.name();
            } else if (string4.contains(OmiMessage.elemIds.bootTextStartup.name())) {
                string2 = OmiMessage.elemIds.bootTextStartup.name();
            }
        }
        String string5 = null;
        if (string2 != null) {
            string5 = utilErrorComp.getLabelText(string2);
        }
        if (errorCodes2 != null) {
            GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, string5, string3));
        } else {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
        }
        JComponent jComponent = null;
        GuiUtilButtonBar guiUtilButtonBar = null;
        if (string2 != null) {
            if (string2.equals(OmiMessage.attribIds.timeout.name())) {
                return null;
            }
            jComponent = utilErrorComp.getField(string2);
            if (jComponent != null) {
                utilErrorComp.markComponent(jComponent);
            }
            if ((guiUtilButtonBar = utilErrorComp.getButtonBar(string2)) != null) {
                guiUtilButtonBar.utilChangeHandler.activateOnError();
            }
        }
        return string2;
    }

    @Override
    public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
        this.commonDataErrorNotificationHandler(dataNotificationEnum, commonDataItemEnum, omiMessage, this.utilErrorComp);
    }

    @Override
    public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
        int n = 0;
        int n2 = 0;
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data notification: " + dataNotificationEnum.toString() + "," + commonDataItemEnum.toString());
        switch (commonDataItemEnum) {
            case WLANRegDomainList: {
                if (!this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveWLAN)) break;
                this.fillComboBoxWLANRegDomain();
                break;
            }
            case SystemName: {
                String string = null;
                try {
                    string = (String)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.SystemName);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.SystemName.toString() + "='" + string + "'");
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.SystemName.toString() + " failed");
                    return;
                }
                this.getTextFieldSystemName().setText(string);
                if (this.isEditable) {
                    this.utilErrorComp.clearComponent(this.textFieldSystemName);
                }
                UtilPreferences.setOmmSystemName(string);
                break;
            }
            case ToneSchemeType: {
                OmiMessage.ToneSchemeType toneSchemeType;
                try {
                    toneSchemeType = (OmiMessage.ToneSchemeType)((Object)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.ToneSchemeType));
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.ToneSchemeType.toString() + "='" + (Object)((Object)toneSchemeType) + "'");
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.ToneSchemeType.toString() + " failed");
                    return;
                }
                this.getComboBoxToneSchemeType().deactivateActionListener();
                this.getComboBoxToneSchemeType().setSelectedItem((Object)toneSchemeType);
                this.getComboBoxToneSchemeType().activateActionListener();
                break;
            }
            case RemoteAccess: {
                Boolean bl = null;
                try {
                    bl = (Boolean)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.RemoteAccess);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.RemoteAccess.toString() + "=" + bl);
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.RemoteAccess.toString() + " failed");
                    return;
                }
                this.getCheckBoxRemoteAccess().setSelected(bl);
                break;
            }
            case PARK: {
                String string = null;
                try {
                    string = (String)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.PARK);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PARK.toString() + "='" + string + "'");
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PARK.toString() + " failed");
                    return;
                }
                String string2 = null;
                try {
                    string2 = (String)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.InitialPARK);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.InitialPARK.toString() + "='" + string2 + "'");
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.InitialPARK.toString() + " failed");
                    return;
                }
                if (this.textFieldPARK != null) {
                    this.textFieldPARK.setText(string);
                }
                if (string.isEmpty()) {
                    this.buttonPARKDlg.setVisible(true);
                } else {
                    this.buttonPARKDlg.setVisible(false);
                }
                this.buttonSARISetVisible();
                if (this.isEditable) {
                    this.utilErrorComp.clearComponent(this.textFieldPARK);
                }
                if (this.guiStatusBar != null) {
                    this.guiStatusBar.showPARK(string2);
                }
                if (string == null || string.length() != 10) break;
                this.parkLengthIdentifier = Integer.parseInt(string.substring(0, 2), 16);
                break;
            }
            case SARI: {
                String string = null;
                try {
                    string = (String)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.SARI);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.SARI.toString() + "='" + string + "'");
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.SARI.toString() + " failed");
                    return;
                }
                if (!string.isEmpty()) {
                    sariSet = true;
                }
                this.textFieldSARI.setText(string);
                this.buttonSARISetVisible();
                break;
            }
            case DECTEncryption: {
                Boolean bl = null;
                try {
                    bl = (Boolean)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.DECTEncryption);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTEncryption.toString() + "=" + bl);
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTEncryption.toString() + " failed");
                    return;
                }
                if (this.checkBoxDECTEncryption != null) {
                    this.checkBoxDECTEncryption.setSelected(bl);
                }
                if (this.isEditable) {
                    this.enableCheckBoxDECTEncryption();
                }
                if (this.guiStatusBar == null) break;
                this.guiStatusBar.showEncryptionState(bl);
                break;
            }
            case DECTRegDomain: {
                OmiMessage.DECTRegDomainType dECTRegDomainType = null;
                try {
                    dECTRegDomainType = (OmiMessage.DECTRegDomainType)((Object)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.DECTRegDomain));
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTRegDomain.toString() + "=" + (Object)((Object)dECTRegDomainType));
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTRegDomain.toString() + " failed");
                    return;
                }
                if (this.comboBoxDECTRegDomain == null) break;
                this.comboBoxDECTRegDomain.deactivateActionListener();
                this.comboBoxDECTRegDomain.setEditable(true);
                this.comboBoxDECTRegDomain.setSelectedItem(dECTRegDomainType.getStrTranslated());
                this.comboBoxDECTRegDomain.setEditable(false);
                this.comboBoxDECTRegDomain.activateActionListener();
                break;
            }
            case DECTPowerLimit: {
                Boolean bl = null;
                try {
                    bl = (Boolean)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.DECTPowerLimit);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTPowerLimit.toString() + "=" + bl);
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTPowerLimit.toString() + " failed");
                    return;
                }
                if (this.checkBoxDECTPowerLimit == null) break;
                this.checkBoxDECTPowerLimit.setSelected(bl);
                break;
            }
            case DECTAuthCode: {
                String string = null;
                try {
                    string = (String)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.DECTAuthCode);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTAuthCode.toString() + "='" + string + "'");
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTAuthCode.toString() + " failed");
                    return;
                }
                if (this.textFieldDECTAuthCode != null) {
                    this.textFieldDECTAuthCode.setText(string);
                }
                if (!this.isEditable) break;
                this.utilErrorComp.clearComponent(this.textFieldDECTAuthCode);
                break;
            }
            case PagingAreaSize: {
                int n3 = 0;
                try {
                    n3 = (Integer)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.PagingAreaSize);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PagingAreaSize.toString() + "=" + n3);
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PagingAreaSize.toString() + " failed");
                    return;
                }
                if (this.comboBoxPagingAreaSize == null) break;
                this.comboBoxPagingAreaSize.deactivateActionListener();
                if (this.parkLengthIdentifier != 0) {
                    int n4 = 1 << 39 - this.parkLengthIdentifier;
                    this.comboBoxPagingAreaSize.removeAllItems();
                    for (n = 0; n < this.pagingAreaSizeArray.length; ++n) {
                        String string = this.pagingAreaSizeArray[n] + " " + UtilLocale.getString("TXT_RFPS") + " (" + n4 / this.pagingAreaSizeArray[n];
                        string = string + (n4 / this.pagingAreaSizeArray[n] > 1 ? " " + UtilLocale.getString("TXT_PAGING_AREAS_20") : " " + UtilLocale.getString("TXT_PAGING_AREA_20")) + ")";
                        this.comboBoxPagingAreaSize.addItem(string);
                    }
                }
                for (n = 0; n < this.pagingAreaSizeArray.length; ++n) {
                    if (n3 != this.pagingAreaSizeArray[n]) continue;
                    n2 = n;
                    break;
                }
                if (n == this.pagingAreaSizeArray.length) {
                    n2 = 0;
                }
                this.comboBoxPagingAreaSize.setSelectedIndex(n2);
                this.comboBoxPagingAreaSize.activateActionListener();
                break;
            }
            case PPDevAutoCreate: {
                if (!this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) break;
                Boolean bl = null;
                try {
                    bl = (Boolean)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.PPDevAutoCreate);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PPDevAutoCreate.toString() + "=" + bl);
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PPDevAutoCreate.toString() + " failed");
                    return;
                }
                this.checkBoxPpDevAutoCreate.setSelected(bl);
                if (this.guiStatusBar == null) break;
                this.guiStatusBar.showPpDevAutoCreateState(bl);
                break;
            }
            case PPLoginVariant: {
                if (!this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices) || !this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) break;
                OmiMessage.PPLoginVariantType pPLoginVariantType = null;
                try {
                    pPLoginVariantType = (OmiMessage.PPLoginVariantType)((Object)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.PPLoginVariant));
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PPLoginVariant.toString() + "=" + pPLoginVariantType.toString());
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PPLoginVariant.toString() + " failed");
                    return;
                }
                if (pPLoginVariantType == null) break;
                this.comboBoxPPLoginType.deactivateActionListener();
                this.comboBoxPPLoginType.setSelectedItem(pPLoginVariantType.txt);
                this.comboBoxPPLoginType.activateActionListener();
                break;
            }
            case WLANRegDomain: {
                if (!this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveWLAN)) break;
                String string = null;
                try {
                    string = ((CommonDataHandler.WLANRegDomainElem)this.commonDataHandler.getData((CommonDataHandler.CommonDataItemEnum)CommonDataHandler.CommonDataItemEnum.WLANRegDomain)).domain;
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.WLANRegDomain.toString() + "=" + string);
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.WLANRegDomain.toString() + " failed");
                    return;
                }
                this.comboBoxWLANRegDomain.deactivateActionListener();
                this.comboBoxWLANRegDomain.setEditable(true);
                this.comboBoxWLANRegDomain.setSelectedItem(string);
                this.comboBoxWLANRegDomain.setEditable(false);
                this.comboBoxWLANRegDomain.activateActionListener();
                break;
            }
            case DECTSubscriptMode: {
                CommonDataHandler.DECTSubscriptionMode dECTSubscriptionMode = null;
                try {
                    dECTSubscriptionMode = (CommonDataHandler.DECTSubscriptionMode)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode.toString() + "=" + dECTSubscriptionMode.mode.toString());
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode.toString() + " failed");
                    return;
                }
                if (this.guiStatusBar == null) break;
                if (dECTSubscriptionMode.mode != OmiMessage.DECTSubscriptionModeType.Off) {
                    this.guiStatusBar.showSubscriptionState(true);
                    break;
                }
                this.guiStatusBar.showSubscriptionState(false);
                break;
            }
            case SyslogCnf: {
                CommonDataHandler.SyslogCnfClass syslogCnfClass = null;
                try {
                    syslogCnfClass = (CommonDataHandler.SyslogCnfClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.SyslogCnf);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.SyslogCnf.toString() + ":" + syslogCnfClass.enable + "," + syslogCnfClass.ipAddr + "," + syslogCnfClass.port);
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.SyslogCnf.toString() + " failed");
                    return;
                }
                this.getCheckBoxSysLogActive().setSelected(syslogCnfClass.enable);
                if (this.textFieldSysLogIPAddress != null) {
                    this.textFieldSysLogIPAddress.setText(syslogCnfClass.ipAddr);
                }
                if (this.textFieldSysLogPort != null) {
                    this.textFieldSysLogPort.setText(String.valueOf(syslogCnfClass.port));
                }
                if (this.checkBoxSysLogForward != null) {
                    if (syslogCnfClass.forward != null) {
                        this.setSyslogForward(syslogCnfClass.forward);
                    } else {
                        this.setSyslogForward(false);
                    }
                }
                if (!this.isEditable) break;
                this.utilErrorComp.clearComponent(this.textFieldSysLogIPAddress);
                this.utilErrorComp.clearComponent(this.textFieldSysLogPort);
                this.utilErrorComp.clearComponent(this.checkBoxSysLogForward);
                break;
            }
            case TimeZone: {
                String string = null;
                try {
                    string = (String)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.TimeZone);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading" + CommonDataHandler.CommonDataItemEnum.TimeZone.toString() + "='" + string + "'");
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.TimeZone.toString() + " failed");
                    return;
                }
                if (this.tzoneList == null) break;
                for (n = 0; n < this.tzoneList.list.length && !this.tzoneList.list[n].id.equals(string); ++n) {
                }
                this.getComboBoxTZone().deactivateActionListener();
                if (n < this.tzoneList.list.length) {
                    this.getComboBoxTZone().setSelectedIndex(n);
                } else {
                    this.getComboBoxTZone().setSelectedIndex(0);
                }
                this.getComboBoxTZone().activateActionListener();
                break;
            }
            case TimeZoneList: {
                try {
                    this.tzoneList = (CommonDataHandler.TimeZoneListClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.TimeZoneList);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading" + CommonDataHandler.CommonDataItemEnum.TimeZoneList.toString() + "=" + this.tzoneList.list.length + " time zones");
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.TimeZoneList.toString() + " failed");
                    return;
                }
                this.getComboBoxTZone().deactivateActionListener();
                this.getComboBoxTZone().removeAllItems();
                for (n = 0; n < this.tzoneList.list.length; ++n) {
                    this.getComboBoxTZone().addItem(this.tzoneList.list[n].name);
                }
                try {
                    String string = (String)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.TimeZone);
                    for (n = 0; n < this.tzoneList.list.length && !this.tzoneList.list[n].id.equals(string); ++n) {
                    }
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    n = 0;
                }
                this.getComboBoxTZone().setSelectedIndex(n);
                this.getComboBoxTZone().activateActionListener();
                break;
            }
            case RestrictedSubscriptionDuration: {
                try {
                    boolean bl = (Boolean)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.RestrictedSubscriptionDuration);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.RestrictedSubscriptionDuration.name() + ": " + bl);
                    this.checkBoxRestrictedSubscriptionDuration.setSelected(bl);
                    break;
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.RestrictedSubscriptionDuration.name() + " failed");
                    return;
                }
            }
            case ParkServerResult: {
                try {
                    String string = (String)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.ParkServerResult);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading" + CommonDataHandler.CommonDataItemEnum.ParkServerResult.toString() + "= '" + string + "'");
                    OmiMessage.ParkServerResultType parkServerResultType = OmiMessage.ParkServerResultType.valueOf(string);
                    if (parkServerResultType != null) {
                        switch (parkServerResultType) {
                            case Success: {
                                GuiInfoConsole.showInfo(UtilLocale.getString("TXT_PARK_SUCCESSFUL_CONFIGURED"));
                                return;
                            }
                        }
                    }
                    GuiInfoConsole.showError(UtilLocale.getString("TXT_PARK_ONLINE_REQUEST") + " : " + UtilLocale.getString("TXT_ERROR") + ": " + string);
                    break;
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.ParkServerResult.toString() + " failed");
                    return;
                }
            }
            case PreserveUserDeviceRelation: {
                try {
                    boolean bl = (Boolean)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.PreserveUserDeviceRelation);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PreserveUserDeviceRelation.name() + ": " + bl);
                    if (this.checkBoxPreserveUserDeviceRelation == null) break;
                    this.checkBoxPreserveUserDeviceRelation.setSelected(bl);
                    break;
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PreserveUserDeviceRelation.name() + " failed");
                    return;
                }
            }
        }
    }

    @Override
    public void componentActivated(Component component) {
        if (this.isEditable) {
            this.siteSummaryHandler.activateRequest();
            this.getTextFieldSystemName().requestFocusInWindow();
            this.panelGeneralButtonBar.utilChangeHandler.initRootPane(this.getRootPane());
            this.getRootPane().setDefaultButton(this.panelGeneralButtonBar.buttonCancel);
        }
    }

    @Override
    public void componentDeactivated() {
        if (this.isEditable) {
            this.siteSummaryHandler.deactivateRequest();
        }
    }

    @Override
    public void processSiteSummaryNotification(SiteSummaryHandler.SiteSummaryClass siteSummaryClass) {
        this.enableCheckBoxDECTEncryption();
    }

    @Override
    public void processSiteSummaryErrorNotification(OmiMessage omiMessage) {
    }

    @Override
    public void processSWManagementDataNotification(DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "SW management data notification: " + dataNotificationEnum.toString());
        if (dataNotificationEnum == DataNotificationEnum.SOFTWARE_UPDATE) {
            SWManagementHandler.SoftwareUpdate softwareUpdate = this.swMgmtHandler.getSwUpdate();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, String.format("timedUpdate=%s, allAtOnce=%s, time=%02d:%02d, maxDelay=%d, calculated time=%02d:%02d", softwareUpdate.timedUpdate, softwareUpdate.allAtOnce, softwareUpdate.hour, softwareUpdate.minute, softwareUpdate.maxDelay, softwareUpdate.hourCalculated, softwareUpdate.minuteCalculated));
            this.comboBoxRfpSwUpdateMode.deactivateActionListener();
            if (softwareUpdate.allAtOnce) {
                this.comboBoxRfpSwUpdateMode.setSelectedIndex(1);
            } else {
                this.comboBoxRfpSwUpdateMode.setSelectedIndex(0);
            }
            this.comboBoxRfpSwUpdateMode.activateActionListener();
            this.checkBoxTimedUpdate.setSelected(softwareUpdate.timedUpdate);
            if (this.isEditable) {
                this.textFieldUpdateHour.setEditable(softwareUpdate.timedUpdate);
                this.textFieldUpdateMinute.setEditable(softwareUpdate.timedUpdate);
                this.textFieldUpdateMaxDelay.setEditable(softwareUpdate.timedUpdate);
            }
            this.textFieldUpdateHour.setVal(softwareUpdate.hour);
            this.textFieldUpdateMinute.setVal(softwareUpdate.minute);
            this.textFieldUpdateMaxDelay.setText(String.valueOf(softwareUpdate.maxDelay));
            this.textFieldUpdateHourCalc.setVal(softwareUpdate.hourCalculated);
            this.textFieldUpdateMinuteCalc.setVal(softwareUpdate.minuteCalculated);
        }
    }

    @Override
    public void processSWManagementErrorNotification(DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        OmiMessage.errorCodes errorCodes2 = null;
        if (!this.isEditable || string == null) {
            return;
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "SW management error notification: " + dataNotificationEnum.toString() + ",errCode=" + string + ",bad=" + string2);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "SW management error notification: Unknown errorCode=" + string);
        }
        String string4 = null;
        if (string2 != null) {
            string4 = this.utilErrorComp.getLabelText(string2);
        }
        if (errorCodes2 != null) {
            GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, string4, string3));
        } else {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
        }
        JComponent jComponent = null;
        GuiUtilButtonBar guiUtilButtonBar = null;
        if (string2 != null) {
            jComponent = this.utilErrorComp.getField(string2);
            if (jComponent != null) {
                this.utilErrorComp.markComponent(jComponent);
            }
            if ((guiUtilButtonBar = this.utilErrorComp.getButtonBar(string2)) != null) {
                guiUtilButtonBar.utilChangeHandler.activateOnError();
            }
        }
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY) {
            sariSet = false;
        }
    }

    public static boolean isSariSet() {
        return sariSet;
    }

    private final class SysSetTabbedPane
    extends GuiUtilTabbedPane {
        private static final long serialVersionUID = 1L;

        private SysSetTabbedPane() {
        }

        @Override
        public void showChangeDialog() {
            new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionOK, UtilLocale.getString("TXT_PLEASE_SAVE_OR_CANCEL_YOUR_CHANGES"), true);
        }
    }
}

