/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.system;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilBorderPanel;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.ConferenceRoomHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.PpDevSummaryHandler;
import com.aastra.omilib.PpUserSummaryHandler;
import com.aastra.omilib.RfpSummaryHandler;
import com.aastra.omilib.SiteSummaryHandler;
import com.aastra.omilib.VideoDevSummaryHandler;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraTabbedPane;
import com.aastra.style.AastraTextField;
import com.aastra.util.UtilSpy;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.border.TitledBorder;

public class SystemStatusPanel
extends AastraPanel
implements OmiManagementEventInterface,
CommonDataHandler.CommonDataNotificationInterface,
GuiComponentActivationInterface,
ConferenceRoomHandler.FreeConferenceChannelsDataNotificationInterface,
RfpSummaryHandler.RfpSummaryNotificationInterface,
PpDevSummaryHandler.PpDevSummaryNotificationInterface,
PpUserSummaryHandler.PpUserSummaryNotificationInterface,
SiteSummaryHandler.SiteSummaryNotificationInterface,
VideoDevSummaryHandler.VideoDevSummaryNotificationInterface {
    private static final long serialVersionUID = 1L;
    private static final int panelHeight = 540;
    private static final int panelWidth = 800;
    private static final int tabbedPaneHeight = 540;
    private static final int tabbedPaneWidth = 800;
    private static final Dimension dimensionHealthStatePanel = new Dimension(365, 45);
    private Map<OmiMessage.HealthComponentType, AastraLabel> mapLabel = null;
    private CommonDataHandler commonDataHandler = null;
    private RfpSummaryHandler rfpSummaryHandler = null;
    private PpUserSummaryHandler ppUserSummaryHandler = null;
    private PpDevSummaryHandler ppDevSummaryHandler = null;
    private SiteSummaryHandler siteSummaryHandler = null;
    private ConferenceRoomHandler conferenceRoomHandler = null;
    private VideoDevSummaryHandler videoDevSummaryHandler = null;
    private OmiManagement omiManagement = null;
    private OmiMessage.OmmStbStateType ommStbStateType = null;
    private CommonDataHandler.HealthStateClass healthState = null;
    private boolean ppFirmwareUpdateInitialized = false;
    private CommonDataHandler.PPFirmwareUpdateClass ppFirmwareUpdate = null;
    private AastraTabbedPane tabbedPaneStatus = null;
    private AastraPanel tabOverview = null;
    private AastraPanel tabRFP = null;
    private AastraPanel tabPPUser = null;
    private AastraPanel panelPPUser = null;
    private AastraPanel tabPPDevice = null;
    private AastraPanel panelPPDevice = null;
    private AastraPanel tabSite = null;
    private AastraPanel panelSite = null;
    private AastraPanel tabConference = null;
    private AastraPanel panelConference = null;
    private AastraPanel tabVideoDev = null;
    private AastraPanel panelVideoDevSummary = null;
    private Timer upTimer = null;
    private Integer uptimeSeconds = null;
    private String lastAutoDBExportMsg = null;
    private String lastManualDBExportMsg = null;
    private AastraPanel panelOverviewMain = null;
    private AastraPanel panelOverviewSystem = null;
    private AastraPanel panelOverviewFeatures = null;
    private AastraPanel panelUptime = null;
    private AastraLabel labelUptime = null;
    private AastraLabel labelUptimeDays = null;
    private AastraLabel labelUptimeHours = null;
    private AastraLabel labelUptimeMinutes = null;
    private AastraTextField textFieldUptimeDays = null;
    private AastraTextField textFieldUptimeHours = null;
    private AastraTextField textFieldUptimeMinutes = null;
    private HealthStatePanel panelStandbyState = null;
    private HealthStatePanel panelLicenseServerState = null;
    private HealthStatePanel panelSystemLicenseState = null;
    private HealthStatePanel panelSyncState = null;
    private HealthStatePanel panelRFPState = null;
    private HealthStatePanel panelSipCertState = null;
    private HealthStatePanel panelDOAState = null;
    private HealthStatePanel panelDBTransferState = null;
    private HealthStatePanel panelIMAState = null;
    private HealthStatePanel panelUDSState = null;
    private HealthStatePanel panelUMOState = null;
    private HealthStatePanel panelOmmCertState = null;
    private HealthStatePanel panelProvCertState = null;
    private HealthStatePanel panelSupplicantCertState = null;
    private HealthStatePanel panelSupplicantState = null;
    private HealthStatePanel panelVideoState = null;
    private boolean panelVideoDevHealthstateActive = false;
    private boolean panelSIPCertHealthstateActive = false;
    private HealthStatePanel panelAxiProvCmdProcessing = null;
    private HealthStatePanel panelProvisioningServer = null;
    private HealthStatePanel panelUserDeviceSyncState = null;
    private AastraPanel panelMOMConnectionState = null;
    private AastraPanel panelRFPGeneral = null;
    private AastraPanel panelRFPRight = null;
    private AastraPanel panelRFPMain = null;
    private AastraTextField textFieldTotalRFPs = null;
    private AastraTextField textFieldConnected = null;
    private AastraTextField textFieldBrandingMismatch = null;
    private AastraTextField textFieldStandbyMisconfigured = null;
    private AastraTextField textFieldSWVersionMismatch = null;
    private AastraTextField textFieldNewSWAvailable = null;
    private AastraTextField textFieldNoAdvancedFeatures = null;
    private AastraTextField textFieldNoEncryption = null;
    private AastraTextField textFieldUsbOverload = null;
    private AastraTextField textFieldWrongSupplicantCfg = null;
    private AastraPanel panelRFPDECT = null;
    private AastraLabel labelDECTActivated = null;
    private AastraTextField textFieldDECTActivated = null;
    private AastraLabel labelDECTCurrentlyActive = null;
    private AastraTextField textFieldDECTCurrentlyActive = null;
    private AastraLabel labelClusters = null;
    private AastraTextField textFieldClusters = null;
    private AastraLabel labelPagingAreas = null;
    private AastraTextField textFieldPagingAreas = null;
    private AastraPanel panelRFPWLAN = null;
    private AastraLabel labelWLANActivated = null;
    private AastraTextField textFieldWLANActivated = null;
    private AastraLabel labelWLANCurrentlyActive = null;
    private AastraTextField textFieldWLANCurrentlyActive = null;
    private AastraLabel labelProfiles = null;
    private AastraTextField textFieldProfiles = null;
    private AastraPanel panelPPUserGeneral = null;
    private AastraLabel labelTotalPPUsers = null;
    private AastraTextField textFieldTotalPPUsers = null;
    private AastraLabel labelSIPRegistered = null;
    private AastraTextField textFieldSIPRegistered = null;
    private AastraLabel labelDECTLocatable = null;
    private AastraTextField textFieldDECTLocatable = null;
    private AastraLabel labelSendingMessagesPermission = null;
    private AastraTextField textFieldSendingMessagesPermission = null;
    private AastraLabel labelMonitoredActive = null;
    private AastraTextField textFieldMonitoredActive = null;
    private AastraLabel labelMonitoredPassive = null;
    private AastraTextField textFieldMonitoredPassive = null;
    private AastraPanel panelPPUserMonitoring = null;
    private AastraLabel labelMonitoringStateWarning = null;
    private AastraTextField textFieldMonitoringStateWarning = null;
    private AastraLabel labelMonitoringStateUnavailable = null;
    private AastraTextField textFieldMonitoringStateUnavailable = null;
    private AastraLabel labelMonitoringStateEscalated = null;
    private AastraTextField textFieldMonitoringStateEscalated = null;
    private AastraPanel panelPPUserVisibilityCheck = null;
    private AastraTextField textFieldVisibilityCheckNumber = null;
    private AastraPanel panelPPDeviceGeneral = null;
    private AastraLabel labelTotalPPDevices = null;
    private AastraTextField textFieldTotalPPDevices = null;
    private AastraLabel labelSubscribed = null;
    private AastraTextField textFieldSubscribed = null;
    private AastraPanel panelPPDeviceFirmwareDownload = null;
    private AastraLabel labelFirmwareDownloadState = null;
    private AastraLabel labelFirmwareDownloadStateValue = null;
    private AastraLabel labelFirmwareDownloadSource = null;
    private AastraTextField textFieldFirmwareDownloadSource = null;
    private AastraLabel labelFirmwareVersion = null;
    private AastraTextField textFieldFirmwareVersion = null;
    private AastraLabel labelKnownPPDevices = null;
    private AastraTextField textFieldKnownPPDevices = null;
    private AastraLabel labelUpdatedPPDevices = null;
    private AastraTextField textFieldUpdatedPPDevices = null;
    private AastraLabel labelWaitingPPDevices = null;
    private AastraTextField textFieldWaitingPPDevices = null;
    private AastraLabel labelDownloadingPPDevices = null;
    private AastraTextField textFieldDownloadingPPDevices = null;
    private AastraLabel labelBarredPPDevices = null;
    private AastraTextField textFieldBarredPPDevices = null;
    private AastraLabel labelUnreachablePPDevices = null;
    private AastraTextField textFieldUnreachablePPDevices = null;
    private AastraLabel labelErroredPPDevices = null;
    private AastraTextField textFieldErroredPPDevices = null;
    private AastraLabel labelDetachedPPDevices = null;
    private AastraTextField textFieldDetachedPPDevices = null;
    private AastraPanel panelSiteGeneral = null;
    private AastraTextField textFieldSitesTotal = null;
    private AastraTextField textFieldSitesWithRfp = null;
    private AastraTextField textFieldSitesHiQAudio = null;
    private AastraTextField textFieldSitesEnhDECTSecure = null;
    private AastraTextField textFieldSitesSRTP = null;
    private AastraTextField textFieldSitesTerminalVideo = null;
    private AastraPanel panelConferenceChannels = null;
    private AastraLabel labelTotalConfChannels = null;
    private AastraTextField textFieldTotalConfChannels = null;
    private AastraLabel labelAvailableConfChannels = null;
    private AastraTextField textFieldAvailableConfChannels = null;
    private AastraPanel panelVideoDevSummaryGeneral = null;
    private AastraTextField textFieldVideoDevSumTotal = null;
    private AastraTextField textFieldVideoDevSumEnabled = null;
    private AastraPanel panelVideoDevSummaryState = null;
    private AastraTextField textFieldVideoDevSumStateUnplugged = null;
    private AastraTextField textFieldVideoDevSumStateInactive = null;
    private AastraTextField textFieldVideoDevSumStateStarted = null;
    private AastraTextField textFieldVideoDevSumStateFailed = null;
    private AastraLabel labelMOMConnectionStateValue = null;

    public SystemStatusPanel(CommonDataHandler commonDataHandler, RfpSummaryHandler rfpSummaryHandler, PpUserSummaryHandler ppUserSummaryHandler, PpDevSummaryHandler ppDevSummaryHandler, SiteSummaryHandler siteSummaryHandler, VideoDevSummaryHandler videoDevSummaryHandler, ConferenceRoomHandler conferenceRoomHandler) {
        this.commonDataHandler = commonDataHandler;
        this.omiManagement = GuiMain.getOmiManagementObject();
        this.rfpSummaryHandler = rfpSummaryHandler;
        this.ppUserSummaryHandler = ppUserSummaryHandler;
        this.ppDevSummaryHandler = ppDevSummaryHandler;
        this.siteSummaryHandler = siteSummaryHandler;
        this.videoDevSummaryHandler = videoDevSummaryHandler;
        this.conferenceRoomHandler = conferenceRoomHandler;
        this.omiManagement.registerManagementEventListener(this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.HealthState, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.PPFirmwareUpdate, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.PPFirmwareUpdateOverview, this);
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveExternalUserData)) {
            this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.UserDataServer, this);
        }
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.DbTransferState, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.BasicSIP, this);
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
            this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.SecureSIPCertificateServer, this);
        }
        this.rfpSummaryHandler.registerRfpSummaryNotificationListener(this);
        this.ppUserSummaryHandler.registerPpUserSummaryNotificationListener(this);
        this.ppDevSummaryHandler.registerPpDevSummaryNotificationListener(this);
        this.siteSummaryHandler.registerSiteSummaryNotificationListener(this);
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
            this.conferenceRoomHandler.registerDataNotificationListener(this);
        }
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo)) {
            this.videoDevSummaryHandler.registerVideoDevSummaryNotificationListener(this);
        }
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync)) {
            this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.UserDeviceSyncOMM, this);
        }
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveMOM)) {
            this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.MOMControlState, this);
        }
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.Supplicant, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.SupplicantCertificate, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.SecureOMMCertificateServer, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.SecurePROVCertificateServer, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.SupplicantCertificateServer, this);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.setSize(new Dimension(800, 540));
        this.mapLabel = new HashMap<OmiMessage.HealthComponentType, AastraLabel>();
        this.add(this.getTabbedPaneStatus());
        this.setHealthStateReasonTypeTranslations();
        this.startUpTimer();
    }

    private void startUpTimer() {
        this.uptimeSeconds = this.omiManagement.getOmmUptime();
        if (this.uptimeSeconds != null) {
            int n = this.showUptime();
            this.upTimer = new Timer("Oamp_UpTimer");
            this.upTimer.schedule((TimerTask)new UptimeTask(), (60 - n) * 1000, 60000L);
            this.uptimeSeconds = this.uptimeSeconds - n;
        } else {
            this.textFieldUptimeDays.setText("-");
            this.textFieldUptimeHours.setText("-");
            this.textFieldUptimeMinutes.setText("-");
        }
    }

    private void stopUpTimer() {
        this.uptimeSeconds = null;
        if (this.upTimer != null) {
            this.upTimer.cancel();
            this.upTimer = null;
        }
    }

    private int showUptime() {
        int n = this.uptimeSeconds / 86400;
        int n2 = this.uptimeSeconds - n * 86400;
        int n3 = n2 / 3600;
        int n4 = (n2 -= n3 * 3600) / 60;
        int n5 = n2 -= n4 * 60;
        this.textFieldUptimeDays.setText(Integer.toString(n));
        this.textFieldUptimeHours.setText(String.format("%02d", n3));
        this.textFieldUptimeMinutes.setText(String.format("%02d", n4));
        return n5;
    }

    private AastraTabbedPane getTabbedPaneStatus() {
        if (this.tabbedPaneStatus == null) {
            this.tabbedPaneStatus = new AastraTabbedPane();
            this.tabbedPaneStatus.setPreferredSize(new Dimension(800, 540));
            this.tabbedPaneStatus.setMaximumSize(new Dimension(800, 540));
            this.tabbedPaneStatus.setAlignmentX(0.0f);
            this.tabbedPaneStatus.addTab(UtilLocale.getString("TXT_OVERVIEW_20"), this.getTabOverview());
            this.tabbedPaneStatus.addTab(UtilLocale.getString("TXT_RADIO_FIXED_PARTS_20"), this.getTabRFP());
            this.tabbedPaneStatus.addTab(UtilLocale.getString("TXT_PP_USERS_20"), this.getTabPPUser());
            this.tabbedPaneStatus.addTab(UtilLocale.getString("TXT_PP_DEVICES_20"), this.getTabPPDevice());
            this.tabbedPaneStatus.addTab(UtilLocale.getString("TXT_SITES_20"), this.getTabSite());
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                this.tabbedPaneStatus.addTab(UtilLocale.getString("TXT_CONFERENCE"), this.getTabConference());
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo)) {
                this.tabbedPaneStatus.addTab(UtilLocale.getString("TXT_VIDEO_DEVICES_20"), this.getTabVideoDev());
            }
        }
        return this.tabbedPaneStatus;
    }

    private AastraPanel getTabOverview() {
        if (this.tabOverview == null) {
            this.tabOverview = new AastraPanel();
            this.tabOverview.setLayout(new BoxLayout(this.tabOverview, 1));
            this.tabOverview.add(Box.createRigidArea(new Dimension(0, 15)));
            this.tabOverview.add(this.getPanelOverviewMain());
        }
        return this.tabOverview;
    }

    private AastraPanel getPanelOverviewMain() {
        if (this.panelOverviewMain == null) {
            Dimension dimension = new Dimension(780, 485);
            this.panelOverviewMain = new AastraPanel();
            this.panelOverviewMain.setAlignmentX(0.0f);
            this.panelOverviewMain.setPreferredSize(dimension);
            this.panelOverviewMain.setMinimumSize(dimension);
            this.panelOverviewMain.setMaximumSize(dimension);
            this.panelOverviewMain.setLayout(new BoxLayout(this.panelOverviewMain, 0));
            this.panelOverviewMain.add(Box.createRigidArea(new Dimension(15, 0)));
            this.panelOverviewMain.add(this.getPanelOverviewSystem());
            this.panelOverviewMain.add(Box.createRigidArea(new Dimension(15, 0)));
            this.panelOverviewMain.add(this.getPanelOverviewFeatures());
        }
        return this.panelOverviewMain;
    }

    private AastraPanel getPanelOverviewSystem() {
        if (this.panelOverviewSystem == null) {
            this.panelOverviewSystem = new GuiUtilBorderPanel(375, 485, UtilLocale.getString("TXT_SYSTEM_20"));
            this.panelOverviewSystem.setLayout(new BoxLayout(this.panelOverviewSystem, 1));
            this.panelOverviewSystem.add(this.getPanelUptime());
            this.panelOverviewSystem.add(this.getPanelSystemLicenseState());
            this.panelOverviewSystem.add(this.getPanelStandbyState());
            this.panelOverviewSystem.add(this.getPanelSyncState());
            this.panelOverviewSystem.add(this.getPanelRFPState());
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                // empty if block
            }
            this.panelOverviewSystem.add(this.getPanelDBTransferState());
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.havePPFirmwareUpdate)) {
                this.panelOverviewSystem.add(this.getPanelDOAState());
            }
            this.panelOverviewSystem.add(this.getPanelProvisioningServer());
            this.panelOverviewSystem.add(this.getPanelAxiProvCmdProcessing());
        }
        return this.panelOverviewSystem;
    }

    private AastraPanel getPanelUptime() {
        if (this.panelUptime == null) {
            this.panelUptime = new AastraPanel();
            this.panelUptime.setLayout(null);
            this.panelUptime.setPreferredSize(dimensionHealthStatePanel);
            this.panelUptime.setMinimumSize(dimensionHealthStatePanel);
            this.panelUptime.setMaximumSize(dimensionHealthStatePanel);
            this.labelUptime = new AastraLabel();
            this.labelUptime.setText(UtilLocale.getString("TXT_UPTIME"));
            this.labelUptime.setBounds(20, 20, 140, 16);
            this.textFieldUptimeDays = new AastraTextField();
            this.textFieldUptimeDays.setBounds(170, 20, 40, 18);
            this.textFieldUptimeDays.setEditable(false);
            this.textFieldUptimeDays.setHorizontalAlignment(4);
            this.labelUptimeDays = new AastraLabel();
            this.labelUptimeDays.setBounds(215, 21, 40, 16);
            this.labelUptimeDays.setText(UtilLocale.getString("TXT_DAYS"));
            this.textFieldUptimeHours = new AastraTextField();
            this.textFieldUptimeHours.setBounds(260, 20, 25, 18);
            this.textFieldUptimeHours.setEditable(false);
            this.textFieldUptimeHours.setHorizontalAlignment(4);
            this.labelUptimeHours = new AastraLabel();
            this.labelUptimeHours.setBounds(290, 21, 10, 16);
            this.labelUptimeHours.setText(UtilLocale.getString("TXT_UNIT_HOUR"));
            this.textFieldUptimeMinutes = new AastraTextField();
            this.textFieldUptimeMinutes.setBounds(310, 20, 25, 18);
            this.textFieldUptimeMinutes.setEditable(false);
            this.textFieldUptimeMinutes.setHorizontalAlignment(4);
            this.labelUptimeMinutes = new AastraLabel();
            this.labelUptimeMinutes.setBounds(340, 21, 20, 16);
            this.labelUptimeMinutes.setText(UtilLocale.getString("TXT_UNIT_MINUTE"));
            this.panelUptime.add(this.labelUptime);
            this.panelUptime.add(this.textFieldUptimeDays);
            this.panelUptime.add(this.labelUptimeDays);
            this.panelUptime.add(this.textFieldUptimeHours);
            this.panelUptime.add(this.labelUptimeHours);
            this.panelUptime.add(this.textFieldUptimeMinutes);
            this.panelUptime.add(this.labelUptimeMinutes);
        }
        return this.panelUptime;
    }

    private HealthStatePanel getPanelLicenseServerState() {
        if (this.panelLicenseServerState == null) {
            this.panelLicenseServerState = new HealthStatePanel(UtilLocale.getString("TXT_LICENSE_SERVER"), OmiMessage.HealthComponentType.licenseServer);
        }
        return this.panelLicenseServerState;
    }

    private HealthStatePanel getPanelSystemLicenseState() {
        if (this.panelSystemLicenseState == null) {
            this.panelSystemLicenseState = new HealthStatePanel(UtilLocale.getString("TXT_LICENSES"), OmiMessage.HealthComponentType.license);
        }
        return this.panelSystemLicenseState;
    }

    private HealthStatePanel getPanelStandbyState() {
        if (this.panelStandbyState == null) {
            this.panelStandbyState = new HealthStatePanel(UtilLocale.getString("TXT_STANDBY_OMM"), OmiMessage.HealthComponentType.standby);
        }
        return this.panelStandbyState;
    }

    private HealthStatePanel getPanelSyncState() {
        if (this.panelSyncState == null) {
            this.panelSyncState = new HealthStatePanel(UtilLocale.getString("TXT_SYNCHRONIZATION_STATE"), OmiMessage.HealthComponentType.sync);
        }
        return this.panelSyncState;
    }

    private HealthStatePanel getPanelRFPState() {
        if (this.panelRFPState == null) {
            this.panelRFPState = new HealthStatePanel(UtilLocale.getString("TXT_RADIO_FIXED_PARTS_20"), OmiMessage.HealthComponentType.rfp);
        }
        return this.panelRFPState;
    }

    private HealthStatePanel getPanelDBTransferState() {
        if (this.panelDBTransferState == null) {
            this.panelDBTransferState = new HealthStatePanel(UtilLocale.getString("TXT_DB_IMPORT_EXPORT"), OmiMessage.HealthComponentType.dbTransfer);
        }
        return this.panelDBTransferState;
    }

    private HealthStatePanel getPanelDOAState() {
        if (this.panelDOAState == null) {
            this.panelDOAState = new HealthStatePanel(UtilLocale.getString("TXT_DOWNLOADING_NEW_FIRMWARE_TO_PORTABLE_PARTS"), OmiMessage.HealthComponentType.download);
        }
        return this.panelDOAState;
    }

    private HealthStatePanel getPanelAxiProvCmdProcessing() {
        if (this.panelAxiProvCmdProcessing == null) {
            this.panelAxiProvCmdProcessing = new HealthStatePanel(UtilLocale.getString("TXT_OMM_CONFIG_FILE_PROCESSING"), OmiMessage.HealthComponentType.axiProvisioningCommands);
        }
        return this.panelAxiProvCmdProcessing;
    }

    private HealthStatePanel getPanelProvisioningServer() {
        if (this.panelProvisioningServer == null) {
            this.panelProvisioningServer = new HealthStatePanel(UtilLocale.getString("TXT_PROVISIONING_SERVER"), OmiMessage.HealthComponentType.provisioningServer);
        }
        return this.panelProvisioningServer;
    }

    private AastraPanel getPanelOverviewFeatures() {
        if (this.panelOverviewFeatures == null) {
            this.panelOverviewFeatures = new GuiUtilBorderPanel(375, 485, UtilLocale.getString("TXT_FEATURES"));
            this.panelOverviewFeatures.setLayout(new BoxLayout(this.panelOverviewFeatures, 1));
            this.panelOverviewFeatures.add(this.getPanelIMAState());
            this.getPanelSipCertState();
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveExternalUserData)) {
                this.panelOverviewFeatures.add(this.getPanelUDSState());
            }
            this.getPanelUMOState();
            this.getPanelVideoState();
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync)) {
                this.panelOverviewFeatures.add(this.getPanelUserDeviceSyncState());
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveMOM)) {
                this.panelOverviewFeatures.add(this.getPanelMOMState());
            }
            this.panelOverviewFeatures.add(this.getPanelSupplicantState());
            this.panelOverviewFeatures.add(this.getPanelOmmCertState());
            this.panelOverviewFeatures.add(this.getPanelProvCertState());
            this.panelOverviewFeatures.add(this.getPanelSupplicantCertState());
        }
        return this.panelOverviewFeatures;
    }

    private HealthStatePanel getPanelIMAState() {
        if (this.panelIMAState == null) {
            this.panelIMAState = new HealthStatePanel("OM Integrated Messaging & Alerting service", OmiMessage.HealthComponentType.ima);
        }
        return this.panelIMAState;
    }

    private HealthStatePanel getPanelUDSState() {
        if (this.panelUDSState == null) {
            this.panelUDSState = new HealthStatePanel(UtilLocale.getString("TXT_USER_DATA_SERVER"), OmiMessage.HealthComponentType.uds);
        }
        return this.panelUDSState;
    }

    private HealthStatePanel getPanelSipCertState() {
        if (this.panelSipCertState == null) {
            this.panelSipCertState = new HealthStatePanel(UtilLocale.getString("TXT_SIP_CERTIFICATE_SERVER"), OmiMessage.HealthComponentType.sipCert);
        }
        return this.panelSipCertState;
    }

    private HealthStatePanel getPanelUMOState() {
        if (this.panelUMOState == null) {
            this.panelUMOState = new HealthStatePanel(UtilLocale.getString("TXT_USER_MONITORING"), OmiMessage.HealthComponentType.umo);
        }
        return this.panelUMOState;
    }

    private HealthStatePanel getPanelOmmCertState() {
        if (this.panelOmmCertState == null) {
            this.panelOmmCertState = new HealthStatePanel(UtilLocale.getString("TXT_OMM_CERTIFICATE_SERVER"), OmiMessage.HealthComponentType.ommCertServer);
        }
        return this.panelOmmCertState;
    }

    private HealthStatePanel getPanelProvCertState() {
        if (this.panelProvCertState == null) {
            this.panelProvCertState = new HealthStatePanel(UtilLocale.getString("TXT_PROVISIONING_CERTIFICATE_SERVER"), OmiMessage.HealthComponentType.provCertServer);
        }
        return this.panelProvCertState;
    }

    private HealthStatePanel getPanelSupplicantCertState() {
        if (this.panelSupplicantCertState == null) {
            this.panelSupplicantCertState = new HealthStatePanel(UtilLocale.getString("TXT_802_1X_CERTIFICATE_SERVER"), OmiMessage.HealthComponentType.supplicantCertServer);
        }
        return this.panelSupplicantCertState;
    }

    private HealthStatePanel getPanelSupplicantState() {
        if (this.panelSupplicantState == null) {
            this.panelSupplicantState = new HealthStatePanel(UtilLocale.getString("TXT_802_1X_STATE"), OmiMessage.HealthComponentType.supplicant);
        }
        return this.panelSupplicantState;
    }

    private HealthStatePanel getPanelVideoState() {
        if (this.panelVideoState == null) {
            this.panelVideoState = new HealthStatePanel(UtilLocale.getString("TXT_VIDEO"), OmiMessage.HealthComponentType.video);
        }
        return this.panelVideoState;
    }

    private HealthStatePanel getPanelUserDeviceSyncState() {
        if (this.panelUserDeviceSyncState == null) {
            this.panelUserDeviceSyncState = new HealthStatePanel(UtilLocale.getString("TXT_DECT_PHONES_SYNCHRONIZATION"), OmiMessage.HealthComponentType.userDeviceSync);
        }
        return this.panelUserDeviceSyncState;
    }

    private AastraPanel getPanelMOMState() {
        if (this.panelMOMConnectionState == null) {
            this.panelMOMConnectionState = new AastraPanel();
            this.panelMOMConnectionState.setLayout(null);
            this.panelMOMConnectionState.setPreferredSize(dimensionHealthStatePanel);
            this.panelMOMConnectionState.setMinimumSize(dimensionHealthStatePanel);
            this.panelMOMConnectionState.setMaximumSize(dimensionHealthStatePanel);
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(20, 20, 270, 31);
            aastraLabel.setTextHtml(UtilLocale.getString("TXT_MOM_CONTROL"));
            this.panelMOMConnectionState.add(aastraLabel);
            this.labelMOMConnectionStateValue = new AastraLabel();
            this.labelMOMConnectionStateValue.setBounds(305, 20, 20, 16);
            this.labelMOMConnectionStateValue.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
            this.labelMOMConnectionStateValue.setToolTipTextHtml(UtilLocale.getString("TXT_OMM_NOT_CONTROLLED_BY_MOM"));
            this.panelMOMConnectionState.add(this.labelMOMConnectionStateValue);
        }
        return this.panelMOMConnectionState;
    }

    private void processHealthState() {
        if (this.healthState != null) {
            block14: for (int i = 0; i < OmiMessage.HealthComponentType.values().length; ++i) {
                if (!this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveExternalUserData) && OmiMessage.HealthComponentType.values()[i] == OmiMessage.HealthComponentType.uds || !this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP) && OmiMessage.HealthComponentType.values()[i] == OmiMessage.HealthComponentType.sip || !this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveBluetooth) && OmiMessage.HealthComponentType.values()[i] == OmiMessage.HealthComponentType.bluetooth || !this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo) && OmiMessage.HealthComponentType.values()[i] == OmiMessage.HealthComponentType.video || !this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP) && OmiMessage.HealthComponentType.values()[i] == OmiMessage.HealthComponentType.sipCert || !this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync) && OmiMessage.HealthComponentType.values()[i] == OmiMessage.HealthComponentType.userDeviceSync) continue;
                switch (OmiMessage.HealthComponentType.values()[i]) {
                    case standby: {
                        this.processStandbyState();
                        continue block14;
                    }
                    case download: {
                        this.processDOAState(i);
                        continue block14;
                    }
                    case umo: {
                        this.processUMOState(i);
                        continue block14;
                    }
                    case rfp: {
                        this.processRFPState(i);
                        continue block14;
                    }
                    case dbTransfer: {
                        this.processDBTransferState(i);
                        continue block14;
                    }
                    case sipCert: {
                        this.processSipCertState();
                        continue block14;
                    }
                    case ommCertServer: {
                        this.processOmmCertState();
                        continue block14;
                    }
                    case provCertServer: {
                        this.processProvisioningCertState();
                        continue block14;
                    }
                    case supplicantCertServer: {
                        this.processSupplicantCertState();
                        continue block14;
                    }
                    case supplicant: {
                        this.processSuplicantCertificate();
                        continue block14;
                    }
                    case license: 
                    case licenseServer: {
                        this.processCombinedLicenseAndLicenseServerState();
                        continue block14;
                    }
                    case userDeviceSync: {
                        this.processUserDeviceSyncState();
                        continue block14;
                    }
                    default: {
                        this.processDefaultState(i);
                    }
                }
            }
        }
    }

    private void processCombinedLicenseAndLicenseServerState() {
        AastraLabel aastraLabel;
        if ((this.healthState.severity[OmiMessage.HealthComponentType.license.ordinal()] == OmiMessage.SeverityType.Unknown || this.healthState.severity[OmiMessage.HealthComponentType.license.ordinal()] == OmiMessage.SeverityType.OK) && this.healthState.severity[OmiMessage.HealthComponentType.licenseServer.ordinal()] == OmiMessage.SeverityType.Warning && (aastraLabel = this.mapLabel.get((Object)OmiMessage.HealthComponentType.values()[OmiMessage.HealthComponentType.license.ordinal()])) != null) {
            aastraLabel.setIcon(GuiUtilIcon.getIconWarning(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
            int n = OmiMessage.HealthComponentType.licenseServer.ordinal();
            if (this.healthState.reasonCode[n] > 0 && this.healthState.reasonCode[n] < OmiMessage.HealthStateReasonType.values().length) {
                String string = OmiMessage.HealthStateReasonType.values()[this.healthState.reasonCode[n]].getTranslatedString();
                if (string.isEmpty()) {
                    string = this.healthState.reason[n];
                }
                aastraLabel.setToolTipTextHtml(string);
            } else {
                aastraLabel.setToolTipText(null);
            }
            return;
        }
        this.processDefaultState(OmiMessage.HealthComponentType.license.ordinal());
    }

    private void processStandbyState() {
        if (this.ommStbStateType != null && this.healthState != null) {
            switch (this.ommStbStateType) {
                case Unknown: {
                    this.panelStandbyState.labelStateValue.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                    this.panelStandbyState.labelStateValue.setToolTipText(UtilLocale.getString("TXT_STANDBY_UNKNOWN_STATE"));
                    break;
                }
                case NotSynchronized: {
                    this.panelStandbyState.labelStateValue.setIcon(GuiUtilIcon.getIconWarning(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                    this.panelStandbyState.labelStateValue.setToolTipText(UtilLocale.getString("TXT_STANDBY_OMM_UNREACHABLE"));
                    break;
                }
                case DifferentOMMTypes: {
                    this.panelStandbyState.labelStateValue.setIcon(GuiUtilIcon.getIconWarning(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                    this.panelStandbyState.labelStateValue.setToolTipText(UtilLocale.getString("TXT_STANDBY_OMM_ACTIVE_BUT_DIFFERENT_OMM_TYPES"));
                    break;
                }
                case DifferentOMMVersions: {
                    this.panelStandbyState.labelStateValue.setIcon(GuiUtilIcon.getIconWarning(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                    this.panelStandbyState.labelStateValue.setToolTipText(UtilLocale.getString("TXT_STANDBY_OMM_ACTIVE_BUT_DIFFERENT_OMM_VERSIONS"));
                    break;
                }
                case None: {
                    this.panelStandbyState.labelStateValue.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                    this.panelStandbyState.labelStateValue.setToolTipText(UtilLocale.getString("TXT_STANDBY_NOT_CONFIGURED"));
                    break;
                }
                default: {
                    this.processDefaultState(OmiMessage.HealthComponentType.standby.ordinal());
                }
            }
        }
    }

    private void processDOAState(int n) {
        if (this.healthState != null && this.ppFirmwareUpdateInitialized) {
            if (this.ppFirmwareUpdate.enable) {
                if (this.healthState.severity[n] == OmiMessage.SeverityType.Warning && this.healthState.reasonCode[n] == OmiMessage.HealthStateReasonType.downloadWarningStartUp.ordinal()) {
                    this.panelDOAState.labelStateValue.setIcon(GuiUtilIcon.getIconWait(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                    String string = OmiMessage.HealthStateReasonType.values()[this.healthState.reasonCode[n]].getTranslatedString();
                    if (string.isEmpty()) {
                        string = this.healthState.reason[n];
                    }
                    this.panelDOAState.labelStateValue.setToolTipTextHtml(string);
                } else {
                    this.processDefaultState(n);
                }
            } else {
                this.panelDOAState.labelStateValue.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                this.panelDOAState.labelStateValue.setToolTipText(UtilLocale.getString("TXT_INACTIVE_20"));
            }
        }
    }

    private void processUMOState(int n) {
        if (this.healthState.severity[n] == OmiMessage.SeverityType.Warning && this.healthState.reasonCode[n] == OmiMessage.HealthStateReasonType.umoWarningStartUp.ordinal()) {
            this.panelUMOState.labelStateValue.setIcon(GuiUtilIcon.getIconWait(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
            String string = OmiMessage.HealthStateReasonType.values()[this.healthState.reasonCode[n]].getTranslatedString();
            if (string.isEmpty()) {
                string = this.healthState.reason[n];
            }
            this.panelUMOState.labelStateValue.setToolTipTextHtml(string);
        } else {
            this.processDefaultState(n);
        }
    }

    private void processRFPState(int n) {
        if (this.healthState.severity[n] == OmiMessage.SeverityType.Warning && this.healthState.reasonCode[n] == OmiMessage.HealthStateReasonType.rfpWarningNoAdvancedFeatures.ordinal()) {
            this.panelRFPState.labelStateValue.setIcon(GuiUtilIcon.getIconWarning(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
            String string = OmiMessage.HealthStateReasonType.values()[this.healthState.reasonCode[n]].getTranslatedString();
            if (string.isEmpty()) {
                string = this.healthState.reason[n];
            }
            this.panelRFPState.labelStateValue.setToolTipTextHtml(string);
        } else {
            this.processDefaultState(n);
        }
    }

    private void processDBTransferState(int n) {
        if (this.healthState.severity[n] == OmiMessage.SeverityType.OK) {
            this.panelDBTransferState.labelStateValue.setIcon(GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
            this.setDbTransferToolTipText();
        } else {
            this.processDefaultState(n);
        }
    }

    private void setDbTransferToolTipText() {
        String string = null;
        if (this.lastAutoDBExportMsg != null || this.lastManualDBExportMsg != null) {
            string = "<html>";
            if (this.lastAutoDBExportMsg != null) {
                string = string.concat(this.lastAutoDBExportMsg);
                if (this.lastManualDBExportMsg != null) {
                    string = string.concat("<br>");
                }
            }
            if (this.lastManualDBExportMsg != null) {
                string = string.concat(this.lastManualDBExportMsg);
            }
            string = string.concat("</html>");
        }
        this.panelDBTransferState.labelStateValue.setToolTipText(string);
    }

    private void processSipCertState() {
        this.processCertificateServerState(CommonDataHandler.CommonDataItemEnum.SecureSIPCertificateServer, OmiMessage.HealthComponentType.sipCert, this.panelSipCertState);
    }

    private void processOmmCertState() {
        this.processCertificateServerState(CommonDataHandler.CommonDataItemEnum.SecureOMMCertificateServer, OmiMessage.HealthComponentType.ommCertServer, this.panelOmmCertState);
    }

    private void processProvisioningCertState() {
        this.processCertificateServerState(CommonDataHandler.CommonDataItemEnum.SecurePROVCertificateServer, OmiMessage.HealthComponentType.provCertServer, this.panelProvCertState);
    }

    private void processSupplicantCertState() {
        this.processCertificateServerState(CommonDataHandler.CommonDataItemEnum.SupplicantCertificateServer, OmiMessage.HealthComponentType.supplicantCertServer, this.panelSupplicantCertState);
    }

    private void processCertificateServerState(CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage.HealthComponentType healthComponentType, HealthStatePanel healthStatePanel) {
        CommonDataHandler.CertificateServer certificateServer = null;
        try {
            certificateServer = (CommonDataHandler.CertificateServer)this.commonDataHandler.getData(commonDataItemEnum);
            if (certificateServer != null && certificateServer.url.enable.booleanValue()) {
                this.processDefaultState(healthComponentType.ordinal());
            } else {
                healthStatePanel.labelStateValue.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                healthStatePanel.labelStateValue.setToolTipText(UtilLocale.getString("TXT_NOT_ACTIVATED"));
            }
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            // empty catch block
        }
    }

    private void processUserDeviceSyncState() {
        CommonDataHandler.UserDeviceSyncOMMClass userDeviceSyncOMMClass = null;
        try {
            userDeviceSyncOMMClass = (CommonDataHandler.UserDeviceSyncOMMClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.UserDeviceSyncOMM);
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            // empty catch block
        }
        if (userDeviceSyncOMMClass != null && userDeviceSyncOMMClass.enable) {
            this.processDefaultState(OmiMessage.HealthComponentType.userDeviceSync.ordinal());
        } else if (this.panelUserDeviceSyncState != null) {
            this.panelUserDeviceSyncState.labelStateValue.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
            this.panelUserDeviceSyncState.labelStateValue.setToolTipText(UtilLocale.getString("TXT_NOT_ACTIVATED"));
        }
    }

    private void processMOMConnectionState() {
        try {
            String string = (String)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.MOMControlState);
            try {
                switch (OmiMessage.MOMControlStateType.valueOf(string)) {
                    case Connected: {
                        this.labelMOMConnectionStateValue.setIcon(GuiUtilIcon.getIconActive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        this.labelMOMConnectionStateValue.setToolTipTextHtml(UtilLocale.getString("TXT_OMM_CONTROLLED_BY_MOM_CONNECTED"));
                        break;
                    }
                    case Disconnected: {
                        this.labelMOMConnectionStateValue.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        this.labelMOMConnectionStateValue.setToolTipTextHtml(UtilLocale.getString("TXT_OMM_CONTROLLED_BY_MOM_NOT_CONNECTED"));
                        break;
                    }
                    case NoMOMControl: {
                        this.labelMOMConnectionStateValue.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        this.labelMOMConnectionStateValue.setToolTipTextHtml(UtilLocale.getString("TXT_OMM_NOT_CONTROLLED_BY_MOM"));
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Received invalid MOM connection state: '" + string + "'");
            }
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "MOM connection state empty");
        }
    }

    private void processDefaultState(int n) {
        AastraLabel aastraLabel = this.mapLabel.get((Object)OmiMessage.HealthComponentType.values()[n]);
        if (aastraLabel == null) {
            return;
        }
        switch (this.healthState.severity[n]) {
            case OK: {
                aastraLabel.setIcon(GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                break;
            }
            case Warning: {
                aastraLabel.setIcon(GuiUtilIcon.getIconWarning(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                break;
            }
            case Error: {
                aastraLabel.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                break;
            }
            default: {
                aastraLabel.setIcon(null);
            }
        }
        if (this.healthState.reasonCode[n] > 0 && this.healthState.reasonCode[n] < OmiMessage.HealthStateReasonType.values().length) {
            String string = OmiMessage.HealthStateReasonType.values()[this.healthState.reasonCode[n]].getTranslatedString();
            if (string.isEmpty()) {
                string = this.healthState.reason[n];
            }
            aastraLabel.setToolTipTextHtml(string);
        } else {
            aastraLabel.setToolTipText(null);
        }
    }

    private void setHealthStateReasonTypeTranslations() {
        OmiMessage.HealthStateReasonType.licenseServerErrorNotStarted.setTranslatedString(UtilLocale.getString("TXT_LICENSE_SERVER_NOT_STARTED"));
        OmiMessage.HealthStateReasonType.licenseServerErrorClientNotConnected.setTranslatedString(UtilLocale.getString("TXT_LICENSE_CLIENT_NOT_CONNECTED"));
        OmiMessage.HealthStateReasonType.licenseServerErrorParsingFile.setTranslatedString(UtilLocale.getString("TXT_LICENSE_FILE_INVALID"));
        OmiMessage.HealthStateReasonType.licenseServerErrorNoLicenseReceived.setTranslatedString(UtilLocale.getString("TXT_LICENSE_FROM_SERVER_NOT_RECEIVED"));
        OmiMessage.HealthStateReasonType.licenseServerWarningErrorStandbyMissing.setTranslatedString(UtilLocale.getString("TXT_STANDBY_LICENSE_SERVERS_MISSING"));
        OmiMessage.HealthStateReasonType.licenseServerErrorInstallationIDInvalid.setTranslatedString(UtilLocale.getString("TXT_INSTALLATION_ID_INVALID"));
        OmiMessage.HealthStateReasonType.licenseWarningNoRedundancy.setTranslatedString(UtilLocale.getString("TXT_ONE_LICENSE_RFP_IS_NOT_CONNECTED"));
        OmiMessage.HealthStateReasonType.licenseErrorBlocked.setTranslatedString(UtilLocale.getString("TXT_LICENSE_IS_VIOLATED_BY_CONFIGURATION"));
        OmiMessage.HealthStateReasonType.licenseErrorInactive.setTranslatedString(UtilLocale.getString("TXT_INSUFFICIENT_NUMBER_OF_LICENSE_RFPS_CONNECTED"));
        OmiMessage.HealthStateReasonType.licenseErrorMissing.setTranslatedString(UtilLocale.getString("TXT_LICENSE_IS_MISSING"));
        OmiMessage.HealthStateReasonType.licenseErrorGracePeriodExpired.setTranslatedString(UtilLocale.getString("TXT_GRACE_PERIOD_EXPIRED"));
        OmiMessage.HealthStateReasonType.standbyWarningConnectionLost.setTranslatedString(UtilLocale.getString("TXT_STANDBY_OMM_CONNECTION_LOST"));
        OmiMessage.HealthStateReasonType.rfpWarningClusterSyncLost.setTranslatedString(UtilLocale.getString("TXT_SYNCHRONIZATION_OF_CLUSTER_LOST"));
        OmiMessage.HealthStateReasonType.rfpWarningUsbOverloadDetected.setTranslatedString(UtilLocale.getString("TXT_RFPS_WITH_USB_OVERLOAD_DETECTED"));
        OmiMessage.HealthStateReasonType.rfpWarningBrandingMismatch.setTranslatedString(UtilLocale.getString("TXT_RFPS_WITH_WRONG_BRANDING_DETECTED"));
        OmiMessage.HealthStateReasonType.rfpWarningNoAdvancedFeatures.setTranslatedString(UtilLocale.getString("TXT_RFPS_NOT_SUPPORTING_ADVANCED_FEATURES_DETECTED"));
        OmiMessage.HealthStateReasonType.rfpWarningNoEncryption.setTranslatedString(UtilLocale.getString("TXT_RFPS_NOT_SUPPORTING_DECT_ENCRYPTION_DETECTED"));
        OmiMessage.HealthStateReasonType.rfpWarningProtocolMismatch.setTranslatedString(UtilLocale.getString("TXT_RFPS_WITH_UNSUPPORTED_SOFTWARE_VERSION_DETECTED"));
        OmiMessage.HealthStateReasonType.rfpWarningStandbyMismatch.setTranslatedString(UtilLocale.getString("TXT_RFPS_WITH_WRONG_OMM_STANDBY_CONFIGURATION_DETECTED"));
        OmiMessage.HealthStateReasonType.rfpWarningSupplicantConfigMismatch.setTranslatedString(UtilLocale.getString("TXT_RFPS_WITH_WRONG_802_1X_CONFIGURATION_DETECTED"));
        OmiMessage.HealthStateReasonType.dbTransferWarningManualDBImportFailed.setTranslatedString(UtilLocale.getString("TXT_DB_IMPORT_MANUAL_FAILED"));
        OmiMessage.HealthStateReasonType.dbTransferWarningManualDBExportFailed.setTranslatedString(UtilLocale.getString("TXT_DB_EXPORT_MANUAL_FAILED"));
        OmiMessage.HealthStateReasonType.dbTransferWarningAutoDBExportFailed.setTranslatedString(UtilLocale.getString("TXT_DB_EXPORT_AUTO_FAILED"));
        OmiMessage.HealthStateReasonType.downloadWarningStartUp.setTranslatedString(UtilLocale.getString("TXT_DELAYED_DURING_STARTUP_PHASE"));
        OmiMessage.HealthStateReasonType.downloadWarningFileNotAvailableOrCorrupted.setTranslatedString(UtilLocale.getString("TXT_FILE_NOT_AVAILABLE_OR_CORRUPTED"));
        OmiMessage.HealthStateReasonType.imaErrorConnectionLost.setTranslatedString(UtilLocale.getString("TXT_OMM_CONNECTION_CANNOT_BE_ESTABLISHED_OR_CONNECTION_LOST"));
        OmiMessage.HealthStateReasonType.imaErrorReadConfirm.setTranslatedString(UtilLocale.getString("TXT_RECEIVING_CONFIGURATION_FILE_FAILED"));
        OmiMessage.HealthStateReasonType.imaWarningMessageQueueFull.setTranslatedString(UtilLocale.getString("TXT_HIGH_MESSAGE_QUEUE_LEVEL"));
        OmiMessage.HealthStateReasonType.imaWarningErrorSendMessage.setTranslatedString(UtilLocale.getString("TXT_SENDING_MESSAGES_FAILED"));
        OmiMessage.HealthStateReasonType.imaWarningErrorDeleteMessage.setTranslatedString(UtilLocale.getString("TXT_DELETING_MESSAGES_FAILED"));
        OmiMessage.HealthStateReasonType.imaWarningErrorSendMail.setTranslatedString(UtilLocale.getString("TXT_SENDING_EMAILS_FAILED"));
        OmiMessage.HealthStateReasonType.imaWarningErrorReceiveMail.setTranslatedString(UtilLocale.getString("TXT_RECEIVING_EMAILS_FAILED"));
        OmiMessage.HealthStateReasonType.imaWarningErrorDeleteMail.setTranslatedString(UtilLocale.getString("TXT_DELETING_EMAILS_FAILED"));
        OmiMessage.HealthStateReasonType.imaWarningErrorGetRssFeed.setTranslatedString(UtilLocale.getString("TXT_RECEIVING_RSS_FEEDS_FAILED"));
        OmiMessage.HealthStateReasonType.imaErrorParseConfigFile.setTranslatedString(UtilLocale.getString("TXT_CANNOT_PARSE_IMA_CONFIGURATION_FILE"));
        OmiMessage.HealthStateReasonType.umoWarningStartUp.setTranslatedString(UtilLocale.getString("TXT_DELAYED_DURING_STARTUP_PHASE"));
        OmiMessage.HealthStateReasonType.umoWarningTooManyUsers.setTranslatedString(UtilLocale.getString("TXT_TOO_MANY_USERS_CONFIGURED"));
        OmiMessage.HealthStateReasonType.umoErrorConnectionLost.setTranslatedString(UtilLocale.getString("TXT_OMM_CONNECTION_CANNOT_BE_ESTABLISHED_OR_CONNECTION_LOST"));
        OmiMessage.HealthStateReasonType.udsErrorCommonUserDataFileImportFailed.setTranslatedString(UtilLocale.getString("TXT_COMMON_USER_DATA_FILE_IMPORT_FAILED"));
        OmiMessage.HealthStateReasonType.udsErrorCommonUserDataFileInvalidConfig.setTranslatedString(UtilLocale.getString("TXT_COMMON_USER_DATA_FILE_INVALID"));
        OmiMessage.HealthStateReasonType.udsWarningUserDataFileImportFailed.setTranslatedString(UtilLocale.getString("TXT_USER_DATA_FILE_IMPORT_FAILED"));
        OmiMessage.HealthStateReasonType.udsWarningUserDataFileInvalidConfig.setTranslatedString(UtilLocale.getString("TXT_USER_DATA_FILE_INVALID"));
        OmiMessage.HealthStateReasonType.videoErrorDeviceFailed.setTranslatedString(UtilLocale.getString("TXT_FAILED_VIDEO_DEVICES_DETECTED"));
        OmiMessage.HealthStateReasonType.videoErrorDeviceUnplugged.setTranslatedString(UtilLocale.getString("TXT_ENABLED_BUT_UNPLUGGED_VIDEO_DEVICES_DETECTED"));
        OmiMessage.HealthStateReasonType.bluetoothErrorBeaconFailed.setTranslatedString(UtilLocale.getString("TXT_FAILED_BLUETOOTH_BEACONS_DETECTED"));
        OmiMessage.HealthStateReasonType.bluetoothErrorBeaconUnplugged.setTranslatedString(UtilLocale.getString("TXT_UNPLUGGED_BLUETOOTH_BEACONS_DETECTED"));
        OmiMessage.HealthStateReasonType.sipCertErrorHTTPTrustedCertificate.setTranslatedString(String.format(UtilLocale.getString("TXT_HTTP_ERROR_*"), UtilLocale.getString("TXT_TRUSTED_CERTIFICATES")));
        OmiMessage.HealthStateReasonType.sipCertErrorNotInDatabaseTrustedCertificate.setTranslatedString(UtilLocale.getString("TXT_IMPORTED_TRUSTED_CERTIFICATES_NOT_STORED_IN_DATABASE"));
        OmiMessage.HealthStateReasonType.sipCertErrorFileTransferTrustedCertificate.setTranslatedString(String.format(UtilLocale.getString("TXT_FILE_TRANSFER_ERROR_*"), UtilLocale.getString("TXT_TRUSTED_CERTIFICATES")));
        OmiMessage.HealthStateReasonType.sipCertErrorHTTPLocalCertificate.setTranslatedString(String.format(UtilLocale.getString("TXT_HTTP_ERROR_*"), UtilLocale.getString("TXT_LOCAL_CERTIFICATE_CHAIN")));
        OmiMessage.HealthStateReasonType.sipCertErrorNotInDatabaseLocalCertificate.setTranslatedString(UtilLocale.getString("TXT_IMPORTED_LOCAL_CERTIFICATE_CHAIN_NOT_STORED_IN_DATABASE"));
        OmiMessage.HealthStateReasonType.sipCertErrorFileTransferLocalCertificate.setTranslatedString(String.format(UtilLocale.getString("TXT_FILE_TRANSFER_ERROR_*"), UtilLocale.getString("TXT_LOCAL_CERTIFICATE_CHAIN")));
        OmiMessage.HealthStateReasonType.sipCertErrorHTTPPrivateKey.setTranslatedString(String.format(UtilLocale.getString("TXT_HTTP_ERROR_*"), UtilLocale.getString("TXT_PRIVATE_KEY")));
        OmiMessage.HealthStateReasonType.sipCertErrorNotInDatabasePrivateKey.setTranslatedString(UtilLocale.getString("TXT_IMPORTED_PRIVATE_KEY_NOT_STORED_IN_DATABASE"));
        OmiMessage.HealthStateReasonType.sipCertErrorFileTransferPrivateKey.setTranslatedString(String.format(UtilLocale.getString("TXT_FILE_TRANSFER_ERROR_*"), UtilLocale.getString("TXT_PRIVATE_KEY")));
        OmiMessage.HealthStateReasonType.axiCommandProcessingError.setTranslatedString(String.format(UtilLocale.getString("TXT_AXI_COMMAND_ERRORS_DURING_PROVISIONING_FILE_PROCESSING"), new Object[0]));
        OmiMessage.HealthStateReasonType.provisioningServerError.setTranslatedString(String.format(UtilLocale.getString("TXT_ACCESS_TO_PROVISIONING_SERVER_FAILED"), new Object[0]));
        OmiMessage.HealthStateReasonType.ppProfileErrorDefaultProfileRejected.setTranslatedString(String.format(UtilLocale.getString("TXT_PP_DEFAULT_PROFILE_ERROR"), new Object[0]));
        OmiMessage.HealthStateReasonType.ppProfileErrorProfileRejected.setTranslatedString(String.format(UtilLocale.getString("TXT_COA_PROFILE_ERROR"), new Object[0]));
        OmiMessage.HealthStateReasonType.dhcpServerInvalidIpAddressRange.setTranslatedString(String.format(UtilLocale.getString("TXT_INVALID_IP_ADDRESS_RANGE"), new Object[0]));
        OmiMessage.HealthStateReasonType.userDeviceSyncErrorCannotConnectToAXI.setTranslatedString(String.format(UtilLocale.getString("TXT_CANNOT_CONNECT_TO_AXI"), new Object[0]));
        OmiMessage.HealthStateReasonType.userDeviceSyncErrorDifferentAXIVersions.setTranslatedString(String.format(UtilLocale.getString("TXT_DIFFERENT_AXI_VERSIONS"), new Object[0]));
        OmiMessage.HealthStateReasonType.userDeviceSyncErrorRfpPcOmmConnection.setTranslatedString(String.format(UtilLocale.getString("TXT_CONNECTION_BETWEEN_RFP_AND_PC_OMM"), new Object[0]));
        OmiMessage.HealthStateReasonType.userDeviceSyncWarningDifferentSystemTimes.setTranslatedString(String.format(UtilLocale.getString("TXT_DIFFERENT_SYSTEM_TIMES"), new Object[0]));
        OmiMessage.HealthStateReasonType.userDeviceSyncErrorSyncActiveCentralOmm.setTranslatedString(String.format(UtilLocale.getString("TXT_SYNCHRONIZATION_ACTIVE_ON_CENTRAL_OMM"), new Object[0]));
        OmiMessage.HealthStateReasonType.userDeviceSyncErrorSARINotConfiguredCentralOmm.setTranslatedString(String.format(UtilLocale.getString("TXT_SARI_NOT_CONFIGURED_ON_CENTRAL_OMM"), new Object[0]));
        OmiMessage.HealthStateReasonType.ommCertServerErrorImport.setTranslatedString(UtilLocale.getString("TXT_IMPORT_OF_OMM_CERTIFICATES_FROM_SERVER_FAILED"));
        OmiMessage.HealthStateReasonType.provisioningCertServerErrorImport.setTranslatedString(UtilLocale.getString("TXT_IMPORT_OF_PROVISIONING_CERTIFICATES_FROM_SERVER_FAILED"));
        OmiMessage.HealthStateReasonType.supplicantCertServerErrorImport.setTranslatedString(UtilLocale.getString("TXT_IMPORT_OF_802_1X_CERTIFICATES_FROM_SERVER_FAILED"));
        OmiMessage.HealthStateReasonType.supplicantWarningEditModeActive.setTranslatedString(UtilLocale.getString("TXT_802_1X_EDIT_MODE_ACTIVE"));
    }

    private AastraPanel getTabRFP() {
        if (this.tabRFP == null) {
            this.tabRFP = new AastraPanel();
            this.tabRFP.setLayout(new BoxLayout(this.tabRFP, 1));
            this.tabRFP.add(Box.createRigidArea(new Dimension(0, 15)));
            this.tabRFP.add(this.getPanelRFPMain());
        }
        return this.tabRFP;
    }

    private AastraPanel getPanelRFPMain() {
        if (this.panelRFPMain == null) {
            Dimension dimension = new Dimension(700, 340);
            this.panelRFPMain = new AastraPanel();
            this.panelRFPMain.setAlignmentX(0.0f);
            this.panelRFPMain.setPreferredSize(dimension);
            this.panelRFPMain.setMinimumSize(dimension);
            this.panelRFPMain.setMaximumSize(dimension);
            this.panelRFPMain.setLayout(new BoxLayout(this.panelRFPMain, 0));
            this.panelRFPMain.add(Box.createRigidArea(new Dimension(15, 0)));
            this.panelRFPMain.add(this.getPanelRFPGeneral());
            this.panelRFPMain.add(Box.createRigidArea(new Dimension(15, 0)));
            this.panelRFPMain.add(this.getPanelRFPRight());
            this.panelRFPMain.add(Box.createRigidArea(new Dimension(10, 0)));
        }
        return this.panelRFPMain;
    }

    private AastraPanel getPanelRFPGeneral() {
        if (this.panelRFPGeneral == null) {
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(20, 30, 240, 16);
            aastraLabel.setText(UtilLocale.getString("TXT_TOTAL"));
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setBounds(20, 60, 240, 16);
            aastraLabel2.setText(UtilLocale.getString("TXT_CONNECTED"));
            AastraLabel aastraLabel3 = new AastraLabel();
            aastraLabel3.setBounds(20, 90, 240, 16);
            aastraLabel3.setText(UtilLocale.getString("TXT_INVALID_BRANDING"));
            AastraLabel aastraLabel4 = new AastraLabel();
            aastraLabel4.setBounds(20, 120, 240, 16);
            aastraLabel4.setText(UtilLocale.getString("TXT_STANDBY_MISCONFIGURED"));
            AastraLabel aastraLabel5 = new AastraLabel();
            aastraLabel5.setBounds(20, 150, 240, 16);
            aastraLabel5.setText(UtilLocale.getString("TXT_VERSION_MISMATCH"));
            AastraLabel aastraLabel6 = new AastraLabel();
            aastraLabel6.setBounds(20, 180, 240, 16);
            aastraLabel6.setText(UtilLocale.getString("TXT_SOFTWARE_UPDATE"));
            AastraLabel aastraLabel7 = new AastraLabel();
            aastraLabel7.setBounds(20, 210, 240, 16);
            aastraLabel7.setText(UtilLocale.getString("TXT_USB_OVERLOAD"));
            AastraLabel aastraLabel8 = new AastraLabel();
            aastraLabel8.setBounds(20, 240, 240, 16);
            aastraLabel8.setText(UtilLocale.getString("TXT_ENCRYPTION_NOT_SUPPORTED"));
            AastraLabel aastraLabel9 = new AastraLabel();
            aastraLabel9.setBounds(20, 270, 240, 31);
            aastraLabel9.setTextHtml(UtilLocale.getString("TXT_ADVANCED_FEATURES_NOT_SUPPORTED"));
            AastraLabel aastraLabel10 = new AastraLabel();
            aastraLabel10.setBounds(20, 300, 240, 31);
            aastraLabel10.setTextHtml(UtilLocale.getString("TXT_802_1X_CONFIGURATION_MISMATCH"));
            this.panelRFPGeneral = new AastraPanel();
            this.panelRFPGeneral.setAlignmentX(0.0f);
            this.panelRFPGeneral.setLayout(null);
            this.panelRFPGeneral.setPreferredSize(new Dimension(327, 290));
            this.panelRFPGeneral.setMinimumSize(new Dimension(327, 290));
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_GENERAL"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.panelRFPGeneral.setBorder(titledBorder);
            this.panelRFPGeneral.add(aastraLabel);
            this.panelRFPGeneral.add(this.getTextFieldTotalRFPs());
            this.panelRFPGeneral.add(aastraLabel2);
            this.panelRFPGeneral.add(this.getTextFieldConnected());
            this.panelRFPGeneral.add(aastraLabel3);
            this.panelRFPGeneral.add(this.getTextFieldBrandingMismatch());
            this.panelRFPGeneral.add(aastraLabel4);
            this.panelRFPGeneral.add(this.getTextFieldStandbyMisconfigured());
            this.panelRFPGeneral.add(aastraLabel5);
            this.panelRFPGeneral.add(this.getTextFieldSWVersionMismatch());
            this.panelRFPGeneral.add(aastraLabel6);
            this.panelRFPGeneral.add(this.getTextFieldNewSWAvailable());
            this.panelRFPGeneral.add(aastraLabel9);
            this.panelRFPGeneral.add(this.getTextFieldNoAdvancedFeatures());
            this.panelRFPGeneral.add(aastraLabel8);
            this.panelRFPGeneral.add(this.getTextFieldNoEncryption());
            this.panelRFPGeneral.add(aastraLabel7);
            this.panelRFPGeneral.add(this.getTextFieldUsbOverload());
            this.panelRFPGeneral.add(aastraLabel10);
            this.panelRFPGeneral.add(this.getTextFieldWrongSupplicantCfg());
        }
        return this.panelRFPGeneral;
    }

    private AastraTextField getTextFieldTotalRFPs() {
        if (this.textFieldTotalRFPs == null) {
            this.textFieldTotalRFPs = new AastraTextField();
            this.textFieldTotalRFPs.setBounds(270, 30, 35, 18);
            this.textFieldTotalRFPs.setEditable(false);
        }
        return this.textFieldTotalRFPs;
    }

    private AastraTextField getTextFieldConnected() {
        if (this.textFieldConnected == null) {
            this.textFieldConnected = new AastraTextField();
            this.textFieldConnected.setBounds(270, 60, 35, 18);
            this.textFieldConnected.setEditable(false);
        }
        return this.textFieldConnected;
    }

    private AastraTextField getTextFieldBrandingMismatch() {
        if (this.textFieldBrandingMismatch == null) {
            this.textFieldBrandingMismatch = new AastraTextField();
            this.textFieldBrandingMismatch.setBounds(270, 90, 35, 18);
            this.textFieldBrandingMismatch.setEditable(false);
        }
        return this.textFieldBrandingMismatch;
    }

    private AastraTextField getTextFieldStandbyMisconfigured() {
        if (this.textFieldStandbyMisconfigured == null) {
            this.textFieldStandbyMisconfigured = new AastraTextField();
            this.textFieldStandbyMisconfigured.setBounds(270, 120, 35, 18);
            this.textFieldStandbyMisconfigured.setEditable(false);
        }
        return this.textFieldStandbyMisconfigured;
    }

    private AastraTextField getTextFieldSWVersionMismatch() {
        if (this.textFieldSWVersionMismatch == null) {
            this.textFieldSWVersionMismatch = new AastraTextField();
            this.textFieldSWVersionMismatch.setBounds(270, 150, 35, 18);
            this.textFieldSWVersionMismatch.setEditable(false);
        }
        return this.textFieldSWVersionMismatch;
    }

    private AastraTextField getTextFieldNewSWAvailable() {
        if (this.textFieldNewSWAvailable == null) {
            this.textFieldNewSWAvailable = new AastraTextField();
            this.textFieldNewSWAvailable.setBounds(270, 180, 35, 18);
            this.textFieldNewSWAvailable.setEditable(false);
        }
        return this.textFieldNewSWAvailable;
    }

    private AastraTextField getTextFieldUsbOverload() {
        if (this.textFieldUsbOverload == null) {
            this.textFieldUsbOverload = new AastraTextField();
            this.textFieldUsbOverload.setBounds(270, 210, 35, 18);
            this.textFieldUsbOverload.setEditable(false);
        }
        return this.textFieldUsbOverload;
    }

    private AastraTextField getTextFieldNoEncryption() {
        if (this.textFieldNoEncryption == null) {
            this.textFieldNoEncryption = new AastraTextField();
            this.textFieldNoEncryption.setBounds(270, 240, 35, 18);
            this.textFieldNoEncryption.setEditable(false);
        }
        return this.textFieldNoEncryption;
    }

    private AastraTextField getTextFieldNoAdvancedFeatures() {
        if (this.textFieldNoAdvancedFeatures == null) {
            this.textFieldNoAdvancedFeatures = new AastraTextField();
            this.textFieldNoAdvancedFeatures.setBounds(270, 270, 35, 18);
            this.textFieldNoAdvancedFeatures.setEditable(false);
            this.textFieldNoAdvancedFeatures.setToolTipText(UtilLocale.getString("TXT_ADVANCED_FEATURES_NOT_SUPPORTED_HELP"));
        }
        return this.textFieldNoAdvancedFeatures;
    }

    private AastraTextField getTextFieldWrongSupplicantCfg() {
        if (this.textFieldWrongSupplicantCfg == null) {
            this.textFieldWrongSupplicantCfg = new AastraTextField();
            this.textFieldWrongSupplicantCfg.setBounds(270, 300, 35, 18);
            this.textFieldWrongSupplicantCfg.setEditable(false);
        }
        return this.textFieldWrongSupplicantCfg;
    }

    private AastraPanel getPanelRFPRight() {
        if (this.panelRFPRight == null) {
            this.panelRFPRight = new AastraPanel();
            this.panelRFPRight.setAlignmentX(0.0f);
            this.panelRFPRight.setPreferredSize(new Dimension(327, 290));
            this.panelRFPRight.setMinimumSize(new Dimension(327, 290));
            this.panelRFPRight.setLayout(new BoxLayout(this.panelRFPRight, 1));
            this.panelRFPRight.add(this.getPanelRFPDECT());
            this.panelRFPRight.add(Box.createRigidArea(new Dimension(0, 15)));
            this.panelRFPRight.add(this.getPanelRFPWLAN());
        }
        return this.panelRFPRight;
    }

    private AastraPanel getPanelRFPDECT() {
        if (this.panelRFPDECT == null) {
            this.labelDECTActivated = new AastraLabel();
            this.labelDECTActivated.setBounds(20, 30, 270, 31);
            this.labelDECTActivated.setText(UtilLocale.getString("TXT_DECT_SWITCHED_ON"));
            this.labelDECTCurrentlyActive = new AastraLabel();
            this.labelDECTCurrentlyActive.setBounds(20, 60, 270, 31);
            this.labelDECTCurrentlyActive.setText(UtilLocale.getString("TXT_DECT_RUNNING"));
            this.labelClusters = new AastraLabel();
            this.labelClusters.setBounds(20, 90, 240, 31);
            this.labelClusters.setText(UtilLocale.getString("TXT_USED_CLUSTERS"));
            this.labelPagingAreas = new AastraLabel();
            this.labelPagingAreas.setBounds(20, 120, 240, 31);
            this.labelPagingAreas.setText(UtilLocale.getString("TXT_USED_PAGING_AREAS"));
            this.panelRFPDECT = new AastraPanel();
            this.panelRFPDECT.setAlignmentX(0.0f);
            this.panelRFPDECT.setLayout(null);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), "DECT");
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.panelRFPDECT.setBorder(titledBorder);
            this.panelRFPDECT.setPreferredSize(new Dimension(370, 140));
            this.panelRFPDECT.setMinimumSize(new Dimension(370, 130));
            this.panelRFPDECT.add(this.labelDECTActivated);
            this.panelRFPDECT.add(this.getTextFieldDECTActivated());
            this.panelRFPDECT.add(this.labelDECTCurrentlyActive);
            this.panelRFPDECT.add(this.getTextFieldDECTCurrentlyActive());
            this.panelRFPDECT.add(this.labelClusters);
            this.panelRFPDECT.add(this.getTextFieldClusters());
            this.panelRFPDECT.add(this.labelPagingAreas);
            this.panelRFPDECT.add(this.getTextFieldPagingAreas());
        }
        return this.panelRFPDECT;
    }

    private AastraTextField getTextFieldDECTActivated() {
        if (this.textFieldDECTActivated == null) {
            this.textFieldDECTActivated = new AastraTextField();
            this.textFieldDECTActivated.setBounds(270, 30, 35, 18);
            this.textFieldDECTActivated.setEditable(false);
        }
        return this.textFieldDECTActivated;
    }

    private AastraTextField getTextFieldDECTCurrentlyActive() {
        if (this.textFieldDECTCurrentlyActive == null) {
            this.textFieldDECTCurrentlyActive = new AastraTextField();
            this.textFieldDECTCurrentlyActive.setBounds(270, 60, 35, 18);
            this.textFieldDECTCurrentlyActive.setEditable(false);
        }
        return this.textFieldDECTCurrentlyActive;
    }

    private AastraTextField getTextFieldClusters() {
        if (this.textFieldClusters == null) {
            this.textFieldClusters = new AastraTextField();
            this.textFieldClusters.setBounds(270, 90, 35, 18);
            this.textFieldClusters.setEditable(false);
        }
        return this.textFieldClusters;
    }

    private AastraTextField getTextFieldPagingAreas() {
        if (this.textFieldPagingAreas == null) {
            this.textFieldPagingAreas = new AastraTextField();
            this.textFieldPagingAreas.setBounds(270, 120, 35, 18);
            this.textFieldPagingAreas.setEditable(false);
        }
        return this.textFieldPagingAreas;
    }

    private AastraPanel getPanelRFPWLAN() {
        if (this.panelRFPWLAN == null) {
            this.labelWLANActivated = new AastraLabel();
            this.labelWLANActivated.setBounds(20, 30, 270, 31);
            this.labelWLANActivated.setText(UtilLocale.getString("TXT_WLAN_SWITCHED_ON"));
            this.labelWLANCurrentlyActive = new AastraLabel();
            this.labelWLANCurrentlyActive.setBounds(20, 60, 270, 31);
            this.labelWLANCurrentlyActive.setText(UtilLocale.getString("TXT_WLAN_RUNNING"));
            this.labelProfiles = new AastraLabel();
            this.labelProfiles.setBounds(20, 90, 240, 31);
            this.labelProfiles.setText(UtilLocale.getString("TXT_PROFILES"));
            this.panelRFPWLAN = new AastraPanel();
            this.panelRFPWLAN.setAlignmentX(0.0f);
            this.panelRFPWLAN.setLayout(null);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), "WLAN");
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.panelRFPWLAN.setBorder(titledBorder);
            this.panelRFPWLAN.setPreferredSize(new Dimension(370, 120));
            this.panelRFPWLAN.setMinimumSize(new Dimension(370, 120));
            this.panelRFPWLAN.add(this.labelWLANActivated);
            this.panelRFPWLAN.add(this.getTextFieldWLANActivated());
            this.panelRFPWLAN.add(this.labelWLANCurrentlyActive);
            this.panelRFPWLAN.add(this.getTextFieldWLANCurrentlyActive());
            this.panelRFPWLAN.add(this.labelProfiles);
            this.panelRFPWLAN.add(this.getTextFieldProfiles());
        }
        return this.panelRFPWLAN;
    }

    private AastraTextField getTextFieldWLANActivated() {
        if (this.textFieldWLANActivated == null) {
            this.textFieldWLANActivated = new AastraTextField();
            this.textFieldWLANActivated.setBounds(270, 30, 35, 18);
            this.textFieldWLANActivated.setEditable(false);
        }
        return this.textFieldWLANActivated;
    }

    private AastraTextField getTextFieldWLANCurrentlyActive() {
        if (this.textFieldWLANCurrentlyActive == null) {
            this.textFieldWLANCurrentlyActive = new AastraTextField();
            this.textFieldWLANCurrentlyActive.setBounds(270, 60, 35, 18);
            this.textFieldWLANCurrentlyActive.setEditable(false);
        }
        return this.textFieldWLANCurrentlyActive;
    }

    private AastraTextField getTextFieldProfiles() {
        if (this.textFieldProfiles == null) {
            this.textFieldProfiles = new AastraTextField();
            this.textFieldProfiles.setBounds(270, 90, 35, 18);
            this.textFieldProfiles.setEditable(false);
        }
        return this.textFieldProfiles;
    }

    private AastraPanel getTabPPUser() {
        if (this.tabPPUser == null) {
            this.tabPPUser = new AastraPanel();
            this.tabPPUser.setLayout(new BoxLayout(this.tabPPUser, 0));
            this.tabPPUser.add(Box.createRigidArea(new Dimension(15, 0)));
            this.tabPPUser.add(this.getPanelPPUser());
        }
        return this.tabPPUser;
    }

    private AastraPanel getPanelPPUser() {
        if (this.panelPPUser == null) {
            this.panelPPUser = new AastraPanel();
            this.panelPPUser.setLayout(new BoxLayout(this.panelPPUser, 1));
            this.panelPPUser.setAlignmentY(0.0f);
            this.panelPPUser.add(Box.createRigidArea(new Dimension(0, 15)));
            this.panelPPUser.add(this.getPanelPPUserGeneral());
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO)) {
                this.panelPPUser.add(Box.createRigidArea(new Dimension(0, 15)));
                this.panelPPUser.add(this.getPanelPPUserMonitoring());
            }
            this.panelPPUser.add(Box.createRigidArea(new Dimension(0, 15)));
            this.panelPPUser.add(this.getPanelSIPVisibilityCheck());
        }
        return this.panelPPUser;
    }

    private AastraPanel getPanelPPUserGeneral() {
        if (this.panelPPUserGeneral == null) {
            this.labelTotalPPUsers = new AastraLabel();
            this.labelTotalPPUsers.setBounds(20, 30, 240, 31);
            this.labelTotalPPUsers.setText(UtilLocale.getString("TXT_TOTAL"));
            this.labelSIPRegistered = new AastraLabel();
            this.labelSIPRegistered.setBounds(20, 60, 240, 31);
            this.labelSIPRegistered.setText(UtilLocale.getString("TXT_SIP_REGISTERED"));
            this.labelMonitoredActive = new AastraLabel();
            this.labelMonitoredActive.setBounds(20, 90, 240, 31);
            this.labelMonitoredActive.setText(UtilLocale.getString("TXT_MONITORED_ACTIVE"));
            this.labelMonitoredPassive = new AastraLabel();
            this.labelMonitoredPassive.setBounds(20, 120, 240, 31);
            this.labelMonitoredPassive.setText(UtilLocale.getString("TXT_MONITORED_PASSIVE"));
            this.labelSendingMessagesPermission = new AastraLabel();
            this.labelSendingMessagesPermission.setBounds(20, 150, 240, 31);
            this.labelSendingMessagesPermission.setText(UtilLocale.getString("TXT_SENDING_MESSAGES_PERMISSION"));
            this.labelDECTLocatable = new AastraLabel();
            this.labelDECTLocatable.setBounds(20, 180, 240, 31);
            this.labelDECTLocatable.setText(UtilLocale.getString("TXT_DECT_LOCATABLE"));
            this.panelPPUserGeneral = new AastraPanel();
            this.panelPPUserGeneral.setAlignmentX(0.0f);
            this.panelPPUserGeneral.setLayout(null);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_GENERAL"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.panelPPUserGeneral.setBorder(titledBorder);
            Dimension dimension = new Dimension(345, 220);
            this.panelPPUserGeneral.setPreferredSize(dimension);
            this.panelPPUserGeneral.setMaximumSize(dimension);
            this.panelPPUserGeneral.add(this.labelTotalPPUsers);
            this.panelPPUserGeneral.add(this.getTextFieldTotalPPUsers());
            this.panelPPUserGeneral.add(this.labelSIPRegistered);
            this.panelPPUserGeneral.add(this.getTextFieldSIPRegistered());
            this.panelPPUserGeneral.add(this.labelMonitoredActive);
            this.panelPPUserGeneral.add(this.getTextFieldMonitoredActive());
            this.panelPPUserGeneral.add(this.labelMonitoredPassive);
            this.panelPPUserGeneral.add(this.getTextFieldMonitoredPassive());
            this.panelPPUserGeneral.add(this.labelSendingMessagesPermission);
            this.panelPPUserGeneral.add(this.getTextFieldSendingMessagesPermission());
            this.panelPPUserGeneral.add(this.labelDECTLocatable);
            this.panelPPUserGeneral.add(this.getTextFieldDECTLocatable());
        }
        return this.panelPPUserGeneral;
    }

    private AastraTextField getTextFieldTotalPPUsers() {
        if (this.textFieldTotalPPUsers == null) {
            this.textFieldTotalPPUsers = new AastraTextField();
            this.textFieldTotalPPUsers.setBounds(280, 30, 40, 18);
            this.textFieldTotalPPUsers.setEditable(false);
        }
        return this.textFieldTotalPPUsers;
    }

    private AastraTextField getTextFieldSIPRegistered() {
        if (this.textFieldSIPRegistered == null) {
            this.textFieldSIPRegistered = new AastraTextField();
            this.textFieldSIPRegistered.setBounds(280, 60, 40, 18);
            this.textFieldSIPRegistered.setEditable(false);
        }
        return this.textFieldSIPRegistered;
    }

    private AastraTextField getTextFieldMonitoredActive() {
        if (this.textFieldMonitoredActive == null) {
            this.textFieldMonitoredActive = new AastraTextField();
            this.textFieldMonitoredActive.setBounds(280, 90, 40, 18);
            this.textFieldMonitoredActive.setEditable(false);
        }
        return this.textFieldMonitoredActive;
    }

    private AastraTextField getTextFieldMonitoredPassive() {
        if (this.textFieldMonitoredPassive == null) {
            this.textFieldMonitoredPassive = new AastraTextField();
            this.textFieldMonitoredPassive.setBounds(280, 120, 40, 18);
            this.textFieldMonitoredPassive.setEditable(false);
        }
        return this.textFieldMonitoredPassive;
    }

    private AastraTextField getTextFieldSendingMessagesPermission() {
        if (this.textFieldSendingMessagesPermission == null) {
            this.textFieldSendingMessagesPermission = new AastraTextField();
            this.textFieldSendingMessagesPermission.setBounds(280, 150, 40, 18);
            this.textFieldSendingMessagesPermission.setEditable(false);
        }
        return this.textFieldSendingMessagesPermission;
    }

    private AastraTextField getTextFieldDECTLocatable() {
        if (this.textFieldDECTLocatable == null) {
            this.textFieldDECTLocatable = new AastraTextField();
            this.textFieldDECTLocatable.setBounds(280, 180, 40, 18);
            this.textFieldDECTLocatable.setEditable(false);
        }
        return this.textFieldDECTLocatable;
    }

    private AastraPanel getPanelPPUserMonitoring() {
        if (this.panelPPUserMonitoring == null) {
            this.labelMonitoringStateWarning = new AastraLabel();
            this.labelMonitoringStateWarning.setBounds(20, 30, 240, 31);
            this.labelMonitoringStateWarning.setText(UtilLocale.getString("TXT_WARNING"));
            this.labelMonitoringStateUnavailable = new AastraLabel();
            this.labelMonitoringStateUnavailable.setBounds(20, 60, 240, 31);
            this.labelMonitoringStateUnavailable.setText(UtilLocale.getString("TXT_UNAVAILABLE"));
            this.labelMonitoringStateEscalated = new AastraLabel();
            this.labelMonitoringStateEscalated.setBounds(20, 90, 240, 31);
            this.labelMonitoringStateEscalated.setText(UtilLocale.getString("TXT_ESCALATED"));
            this.panelPPUserMonitoring = new AastraPanel();
            this.panelPPUserMonitoring.setAlignmentX(0.0f);
            this.panelPPUserMonitoring.setLayout(null);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_USER_MONITORING_STATES"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.panelPPUserMonitoring.setBorder(titledBorder);
            this.panelPPUserMonitoring.setPreferredSize(new Dimension(345, 130));
            this.panelPPUserMonitoring.setMaximumSize(new Dimension(345, 130));
            this.panelPPUserMonitoring.add(this.labelMonitoringStateWarning);
            this.panelPPUserMonitoring.add(this.getTextFieldMonitoringStateWarning());
            this.panelPPUserMonitoring.add(this.labelMonitoringStateUnavailable);
            this.panelPPUserMonitoring.add(this.getTextFieldMonitoringStateUnavailable());
            this.panelPPUserMonitoring.add(this.labelMonitoringStateEscalated);
            this.panelPPUserMonitoring.add(this.getTextFieldMonitoringStateEscalated());
        }
        return this.panelPPUserMonitoring;
    }

    private AastraTextField getTextFieldMonitoringStateWarning() {
        if (this.textFieldMonitoringStateWarning == null) {
            this.textFieldMonitoringStateWarning = new AastraTextField();
            this.textFieldMonitoringStateWarning.setBounds(280, 30, 40, 18);
            this.textFieldMonitoringStateWarning.setEditable(false);
        }
        return this.textFieldMonitoringStateWarning;
    }

    private AastraTextField getTextFieldMonitoringStateUnavailable() {
        if (this.textFieldMonitoringStateUnavailable == null) {
            this.textFieldMonitoringStateUnavailable = new AastraTextField();
            this.textFieldMonitoringStateUnavailable.setBounds(280, 60, 40, 18);
            this.textFieldMonitoringStateUnavailable.setEditable(false);
        }
        return this.textFieldMonitoringStateUnavailable;
    }

    private AastraTextField getTextFieldMonitoringStateEscalated() {
        if (this.textFieldMonitoringStateEscalated == null) {
            this.textFieldMonitoringStateEscalated = new AastraTextField();
            this.textFieldMonitoringStateEscalated.setBounds(280, 90, 40, 18);
            this.textFieldMonitoringStateEscalated.setEditable(false);
        }
        return this.textFieldMonitoringStateEscalated;
    }

    private AastraPanel getPanelSIPVisibilityCheck() {
        if (this.panelPPUserVisibilityCheck == null) {
            this.panelPPUserVisibilityCheck = new AastraPanel();
            this.panelPPUserVisibilityCheck.setAlignmentX(0.0f);
            this.panelPPUserVisibilityCheck.setLayout(null);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_NUMBER_USED_FOR_VISIBILITY_CHECK"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.panelPPUserVisibilityCheck.setBorder(titledBorder);
            Dimension dimension = new Dimension(345, 70);
            this.panelPPUserVisibilityCheck.setPreferredSize(dimension);
            this.panelPPUserVisibilityCheck.setMaximumSize(dimension);
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(20, 30, 100, 31);
            aastraLabel.setTextHtml(UtilLocale.getString("TXT_PHONE_NUMBER_/_SIP_USER_NAME"));
            this.panelPPUserVisibilityCheck.add(aastraLabel);
            this.panelPPUserVisibilityCheck.add(this.getTextFieldVisibilityCheckNumber());
        }
        return this.panelPPUserVisibilityCheck;
    }

    private AastraTextField getTextFieldVisibilityCheckNumber() {
        if (this.textFieldVisibilityCheckNumber == null) {
            this.textFieldVisibilityCheckNumber = new AastraTextField();
            this.textFieldVisibilityCheckNumber.setBounds(125, 30, 195, 18);
            this.textFieldVisibilityCheckNumber.setEditable(false);
            this.textFieldVisibilityCheckNumber.setToolTipText(UtilLocale.getString("TXT_VISIBILITY_CHECK_NUMBER_HELP"));
        }
        return this.textFieldVisibilityCheckNumber;
    }

    private AastraPanel getTabPPDevice() {
        if (this.tabPPDevice == null) {
            this.tabPPDevice = new AastraPanel();
            this.tabPPDevice.setLayout(new BoxLayout(this.tabPPDevice, 0));
            this.tabPPDevice.add(Box.createRigidArea(new Dimension(15, 0)));
            this.tabPPDevice.add(this.getPanelPPDevice());
        }
        return this.tabPPDevice;
    }

    private AastraPanel getPanelPPDevice() {
        if (this.panelPPDevice == null) {
            this.panelPPDevice = new AastraPanel();
            this.panelPPDevice.setLayout(new BoxLayout(this.panelPPDevice, 1));
            this.panelPPDevice.setAlignmentY(0.0f);
            this.panelPPDevice.add(Box.createRigidArea(new Dimension(0, 15)));
            this.panelPPDevice.add(this.getPanelPPDeviceGeneral());
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.havePPFirmwareUpdate)) {
                this.panelPPDevice.add(Box.createRigidArea(new Dimension(0, 15)));
                this.panelPPDevice.add(this.getPanelPPDeviceFirmwareDownload());
            }
        }
        return this.panelPPDevice;
    }

    private AastraPanel getPanelPPDeviceGeneral() {
        if (this.panelPPDeviceGeneral == null) {
            this.labelTotalPPDevices = new AastraLabel();
            this.labelTotalPPDevices.setBounds(20, 30, 240, 31);
            this.labelTotalPPDevices.setText(UtilLocale.getString("TXT_TOTAL"));
            this.labelSubscribed = new AastraLabel();
            this.labelSubscribed.setBounds(20, 60, 240, 31);
            this.labelSubscribed.setText(UtilLocale.getString("TXT_SUBSCRIBED"));
            this.panelPPDeviceGeneral = new AastraPanel();
            this.panelPPDeviceGeneral.setAlignmentX(0.0f);
            this.panelPPDeviceGeneral.setLayout(null);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_GENERAL"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.panelPPDeviceGeneral.setBorder(titledBorder);
            this.panelPPDeviceGeneral.setPreferredSize(new Dimension(345, 100));
            this.panelPPDeviceGeneral.setMaximumSize(new Dimension(345, 100));
            this.panelPPDeviceGeneral.add(this.labelTotalPPDevices);
            this.panelPPDeviceGeneral.add(this.getTextFieldTotalPPDevices());
            this.panelPPDeviceGeneral.add(this.labelSubscribed);
            this.panelPPDeviceGeneral.add(this.getTextFieldSubscribed());
        }
        return this.panelPPDeviceGeneral;
    }

    private AastraTextField getTextFieldTotalPPDevices() {
        if (this.textFieldTotalPPDevices == null) {
            this.textFieldTotalPPDevices = new AastraTextField();
            this.textFieldTotalPPDevices.setBounds(280, 30, 40, 18);
            this.textFieldTotalPPDevices.setEditable(false);
        }
        return this.textFieldTotalPPDevices;
    }

    private AastraTextField getTextFieldSubscribed() {
        if (this.textFieldSubscribed == null) {
            this.textFieldSubscribed = new AastraTextField();
            this.textFieldSubscribed.setBounds(280, 60, 40, 18);
            this.textFieldSubscribed.setEditable(false);
        }
        return this.textFieldSubscribed;
    }

    private AastraPanel getPanelPPDeviceFirmwareDownload() {
        if (this.panelPPDeviceFirmwareDownload == null) {
            this.labelFirmwareDownloadState = new AastraLabel();
            this.labelFirmwareDownloadState.setBounds(20, 30, 240, 31);
            this.labelFirmwareDownloadState.setText(UtilLocale.getString("TXT_STATUS"));
            this.labelFirmwareDownloadStateValue = new AastraLabel();
            this.labelFirmwareDownloadStateValue.setBounds(280, 30, 250, 31);
            this.labelFirmwareDownloadStateValue.setIconTextGap(13);
            this.labelFirmwareDownloadSource = new AastraLabel();
            this.labelFirmwareDownloadSource.setBounds(20, 60, 240, 31);
            this.labelFirmwareDownloadSource.setText(UtilLocale.getString("TXT_LOADING_FIRMWARE_FROM"));
            this.labelFirmwareVersion = new AastraLabel();
            this.labelFirmwareVersion.setBounds(20, 90, 240, 31);
            this.labelFirmwareVersion.setText(UtilLocale.getString("TXT_FIRMWARE_VERSION"));
            this.labelKnownPPDevices = new AastraLabel();
            this.labelKnownPPDevices.setBounds(20, 120, 240, 31);
            this.labelKnownPPDevices.setText(UtilLocale.getString("TXT_KNOWN_DOWNLOADABLE"));
            this.labelUpdatedPPDevices = new AastraLabel();
            this.labelUpdatedPPDevices.setBounds(20, 150, 240, 31);
            this.labelUpdatedPPDevices.setText(UtilLocale.getString("TXT_ALREADY_UPDATED"));
            this.labelWaitingPPDevices = new AastraLabel();
            this.labelWaitingPPDevices.setBounds(20, 180, 240, 31);
            this.labelWaitingPPDevices.setText(UtilLocale.getString("TXT_WAITING_FOR_DOWNLOAD"));
            this.labelDownloadingPPDevices = new AastraLabel();
            this.labelDownloadingPPDevices.setBounds(20, 210, 240, 31);
            this.labelDownloadingPPDevices.setText(UtilLocale.getString("TXT_CURRENTLY_DOWNLOADING"));
            this.labelBarredPPDevices = new AastraLabel();
            this.labelBarredPPDevices.setBounds(20, 240, 240, 31);
            this.labelBarredPPDevices.setText(UtilLocale.getString("TXT_BARRED"));
            this.labelErroredPPDevices = new AastraLabel();
            this.labelErroredPPDevices.setBounds(20, 270, 240, 31);
            this.labelErroredPPDevices.setText(UtilLocale.getString("TXT_DOWNLOAD_ERROR"));
            this.labelUnreachablePPDevices = new AastraLabel();
            this.labelUnreachablePPDevices.setBounds(20, 300, 240, 31);
            this.labelUnreachablePPDevices.setText(UtilLocale.getString("TXT_UNREACHABLE"));
            this.labelDetachedPPDevices = new AastraLabel();
            this.labelDetachedPPDevices.setBounds(20, 330, 240, 31);
            this.labelDetachedPPDevices.setText(UtilLocale.getString("TXT_DETACHED"));
            this.panelPPDeviceFirmwareDownload = new AastraPanel();
            this.panelPPDeviceFirmwareDownload.setAlignmentX(0.0f);
            this.panelPPDeviceFirmwareDownload.setLayout(null);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_DOWNLOADING_NEW_FIRMWARE_TO_PORTABLE_PARTS"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.panelPPDeviceFirmwareDownload.setBorder(titledBorder);
            this.panelPPDeviceFirmwareDownload.setPreferredSize(new Dimension(560, 370));
            this.panelPPDeviceFirmwareDownload.setMaximumSize(new Dimension(560, 370));
            this.panelPPDeviceFirmwareDownload.add(this.labelFirmwareDownloadState);
            this.panelPPDeviceFirmwareDownload.add(this.labelFirmwareDownloadStateValue);
            this.panelPPDeviceFirmwareDownload.add(this.labelFirmwareDownloadSource);
            this.panelPPDeviceFirmwareDownload.add(this.getTextFieldFirmwareDownloadSource());
            this.panelPPDeviceFirmwareDownload.add(this.labelFirmwareVersion);
            this.panelPPDeviceFirmwareDownload.add(this.getTextFieldFirmwareVersion());
            this.panelPPDeviceFirmwareDownload.add(this.labelKnownPPDevices);
            this.panelPPDeviceFirmwareDownload.add(this.getTextFieldKnownPPDevices());
            this.panelPPDeviceFirmwareDownload.add(this.labelUpdatedPPDevices);
            this.panelPPDeviceFirmwareDownload.add(this.getTextFieldUpdatedPPDevices());
            this.panelPPDeviceFirmwareDownload.add(this.labelWaitingPPDevices);
            this.panelPPDeviceFirmwareDownload.add(this.getTextFieldWaitingPPDevices());
            this.panelPPDeviceFirmwareDownload.add(this.labelDownloadingPPDevices);
            this.panelPPDeviceFirmwareDownload.add(this.getTextFieldDownloadingPPDevices());
            this.panelPPDeviceFirmwareDownload.add(this.labelBarredPPDevices);
            this.panelPPDeviceFirmwareDownload.add(this.getTextFieldBarredPPDevices());
            this.panelPPDeviceFirmwareDownload.add(this.labelErroredPPDevices);
            this.panelPPDeviceFirmwareDownload.add(this.getTextFieldErroredPPDevices());
            this.panelPPDeviceFirmwareDownload.add(this.labelUnreachablePPDevices);
            this.panelPPDeviceFirmwareDownload.add(this.getTextFieldUnreachablePPDevices());
            this.panelPPDeviceFirmwareDownload.add(this.labelDetachedPPDevices);
            this.panelPPDeviceFirmwareDownload.add(this.getTextFieldDetachedPPDevices());
        }
        return this.panelPPDeviceFirmwareDownload;
    }

    private AastraTextField getTextFieldFirmwareDownloadSource() {
        if (this.textFieldFirmwareDownloadSource == null) {
            this.textFieldFirmwareDownloadSource = new AastraTextField();
            this.textFieldFirmwareDownloadSource.setBounds(280, 60, 250, 18);
            this.textFieldFirmwareDownloadSource.setEditable(false);
        }
        return this.textFieldFirmwareDownloadSource;
    }

    private AastraTextField getTextFieldFirmwareVersion() {
        if (this.textFieldFirmwareVersion == null) {
            this.textFieldFirmwareVersion = new AastraTextField();
            this.textFieldFirmwareVersion.setBounds(280, 90, 250, 18);
            this.textFieldFirmwareVersion.setEditable(false);
        }
        return this.textFieldFirmwareVersion;
    }

    private AastraTextField getTextFieldKnownPPDevices() {
        if (this.textFieldKnownPPDevices == null) {
            this.textFieldKnownPPDevices = new AastraTextField();
            this.textFieldKnownPPDevices.setBounds(280, 120, 40, 18);
            this.textFieldKnownPPDevices.setEditable(false);
        }
        return this.textFieldKnownPPDevices;
    }

    private AastraTextField getTextFieldUpdatedPPDevices() {
        if (this.textFieldUpdatedPPDevices == null) {
            this.textFieldUpdatedPPDevices = new AastraTextField();
            this.textFieldUpdatedPPDevices.setBounds(280, 150, 40, 18);
            this.textFieldUpdatedPPDevices.setEditable(false);
        }
        return this.textFieldUpdatedPPDevices;
    }

    private AastraTextField getTextFieldWaitingPPDevices() {
        if (this.textFieldWaitingPPDevices == null) {
            this.textFieldWaitingPPDevices = new AastraTextField();
            this.textFieldWaitingPPDevices.setBounds(280, 180, 40, 18);
            this.textFieldWaitingPPDevices.setEditable(false);
        }
        return this.textFieldWaitingPPDevices;
    }

    private AastraTextField getTextFieldDownloadingPPDevices() {
        if (this.textFieldDownloadingPPDevices == null) {
            this.textFieldDownloadingPPDevices = new AastraTextField();
            this.textFieldDownloadingPPDevices.setBounds(280, 210, 40, 18);
            this.textFieldDownloadingPPDevices.setEditable(false);
        }
        return this.textFieldDownloadingPPDevices;
    }

    private AastraTextField getTextFieldBarredPPDevices() {
        if (this.textFieldBarredPPDevices == null) {
            this.textFieldBarredPPDevices = new AastraTextField();
            this.textFieldBarredPPDevices.setBounds(280, 240, 40, 18);
            this.textFieldBarredPPDevices.setEditable(false);
        }
        return this.textFieldBarredPPDevices;
    }

    private AastraTextField getTextFieldErroredPPDevices() {
        if (this.textFieldErroredPPDevices == null) {
            this.textFieldErroredPPDevices = new AastraTextField();
            this.textFieldErroredPPDevices.setBounds(280, 270, 40, 18);
            this.textFieldErroredPPDevices.setEditable(false);
        }
        return this.textFieldErroredPPDevices;
    }

    private AastraTextField getTextFieldUnreachablePPDevices() {
        if (this.textFieldUnreachablePPDevices == null) {
            this.textFieldUnreachablePPDevices = new AastraTextField();
            this.textFieldUnreachablePPDevices.setBounds(280, 300, 40, 18);
            this.textFieldUnreachablePPDevices.setEditable(false);
        }
        return this.textFieldUnreachablePPDevices;
    }

    private AastraTextField getTextFieldDetachedPPDevices() {
        if (this.textFieldDetachedPPDevices == null) {
            this.textFieldDetachedPPDevices = new AastraTextField();
            this.textFieldDetachedPPDevices.setBounds(280, 330, 40, 18);
            this.textFieldDetachedPPDevices.setEditable(false);
        }
        return this.textFieldDetachedPPDevices;
    }

    private AastraPanel getTabSite() {
        if (this.tabSite == null) {
            this.tabSite = new AastraPanel();
            this.tabSite.setLayout(new BoxLayout(this.tabSite, 0));
            this.tabSite.add(Box.createRigidArea(new Dimension(15, 0)));
            this.tabSite.add(this.getPanelSite());
        }
        return this.tabSite;
    }

    private AastraPanel getPanelSite() {
        if (this.panelSite == null) {
            this.panelSite = new AastraPanel();
            this.panelSite.setLayout(new BoxLayout(this.panelSite, 1));
            this.panelSite.setAlignmentY(0.0f);
            this.panelSite.add(Box.createRigidArea(new Dimension(0, 15)));
            this.panelSite.add(this.getPanelSiteGeneral());
        }
        return this.panelSite;
    }

    private AastraPanel getPanelSiteGeneral() {
        if (this.panelSiteGeneral == null) {
            this.panelSiteGeneral = new AastraPanel();
            this.panelSiteGeneral.setAlignmentX(0.0f);
            this.panelSiteGeneral.setLayout(null);
            Dimension dimension = new Dimension(345, 220);
            this.panelSiteGeneral.setPreferredSize(dimension);
            this.panelSiteGeneral.setMaximumSize(dimension);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_GENERAL"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.panelSiteGeneral.setBorder(titledBorder);
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(20, 30, 240, 31);
            aastraLabel.setText(UtilLocale.getString("TXT_TOTAL"));
            this.panelSiteGeneral.add(aastraLabel);
            this.panelSiteGeneral.add(this.getTextFieldSitesTotal());
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setBounds(20, 60, 240, 31);
            aastraLabel2.setText(UtilLocale.getString("TXT_CONTAINS_RFPS"));
            this.panelSiteGeneral.add(aastraLabel2);
            this.panelSiteGeneral.add(this.getTextFieldSitesWithRfp());
            AastraLabel aastraLabel3 = new AastraLabel();
            aastraLabel3.setBounds(20, 90, 240, 31);
            aastraLabel3.setText(UtilLocale.getString("TXT_HI-Q_AUDIO_TECHNOLOGY"));
            this.panelSiteGeneral.add(aastraLabel3);
            this.panelSiteGeneral.add(this.getTextFieldSitesHiQAudio());
            AastraLabel aastraLabel4 = new AastraLabel();
            aastraLabel4.setBounds(20, 120, 240, 31);
            aastraLabel4.setText(UtilLocale.getString("TXT_ENHANCED_DECT_SECURITY"));
            this.panelSiteGeneral.add(aastraLabel4);
            this.panelSiteGeneral.add(this.getTextFieldSitesEnhDECTSecure());
            AastraLabel aastraLabel5 = new AastraLabel();
            aastraLabel5.setBounds(20, 150, 240, 31);
            aastraLabel5.setText(UtilLocale.getString("TXT_SRTP"));
            this.panelSiteGeneral.add(aastraLabel5);
            this.panelSiteGeneral.add(this.getTextFieldSitesSRTP());
            AastraLabel aastraLabel6 = new AastraLabel();
            aastraLabel6.setBounds(20, 180, 240, 31);
            aastraLabel6.setText(UtilLocale.getString("TXT_TERMINAL_VIDEO"));
            this.panelSiteGeneral.add(aastraLabel6);
            this.panelSiteGeneral.add(this.getTextFieldSitesTerminalVideo());
        }
        return this.panelSiteGeneral;
    }

    private AastraTextField getTextFieldSitesTotal() {
        if (this.textFieldSitesTotal == null) {
            this.textFieldSitesTotal = new AastraTextField();
            this.textFieldSitesTotal.setBounds(270, 30, 35, 18);
            this.textFieldSitesTotal.setEditable(false);
        }
        return this.textFieldSitesTotal;
    }

    private AastraTextField getTextFieldSitesWithRfp() {
        if (this.textFieldSitesWithRfp == null) {
            this.textFieldSitesWithRfp = new AastraTextField();
            this.textFieldSitesWithRfp.setBounds(270, 60, 35, 18);
            this.textFieldSitesWithRfp.setEditable(false);
        }
        return this.textFieldSitesWithRfp;
    }

    private AastraTextField getTextFieldSitesHiQAudio() {
        if (this.textFieldSitesHiQAudio == null) {
            this.textFieldSitesHiQAudio = new AastraTextField();
            this.textFieldSitesHiQAudio.setBounds(270, 90, 35, 18);
            this.textFieldSitesHiQAudio.setEditable(false);
        }
        return this.textFieldSitesHiQAudio;
    }

    private AastraTextField getTextFieldSitesEnhDECTSecure() {
        if (this.textFieldSitesEnhDECTSecure == null) {
            this.textFieldSitesEnhDECTSecure = new AastraTextField();
            this.textFieldSitesEnhDECTSecure.setBounds(270, 120, 35, 18);
            this.textFieldSitesEnhDECTSecure.setEditable(false);
        }
        return this.textFieldSitesEnhDECTSecure;
    }

    private AastraTextField getTextFieldSitesSRTP() {
        if (this.textFieldSitesSRTP == null) {
            this.textFieldSitesSRTP = new AastraTextField();
            this.textFieldSitesSRTP.setBounds(270, 150, 35, 18);
            this.textFieldSitesSRTP.setEditable(false);
        }
        return this.textFieldSitesSRTP;
    }

    private AastraTextField getTextFieldSitesTerminalVideo() {
        if (this.textFieldSitesTerminalVideo == null) {
            this.textFieldSitesTerminalVideo = new AastraTextField();
            this.textFieldSitesTerminalVideo.setBounds(270, 180, 35, 18);
            this.textFieldSitesTerminalVideo.setEditable(false);
        }
        return this.textFieldSitesTerminalVideo;
    }

    private AastraPanel getTabConference() {
        if (this.tabConference == null) {
            this.tabConference = new AastraPanel();
            this.tabConference.setLayout(new BoxLayout(this.tabConference, 0));
            this.tabConference.add(Box.createRigidArea(new Dimension(15, 0)));
            this.tabConference.add(this.getPanelConference());
        }
        return this.tabConference;
    }

    private AastraPanel getPanelConference() {
        if (this.panelConference == null) {
            this.panelConference = new AastraPanel();
            this.panelConference.setLayout(new BoxLayout(this.panelConference, 1));
            this.panelConference.setAlignmentY(0.0f);
            this.panelConference.add(Box.createRigidArea(new Dimension(0, 15)));
            this.panelConference.add(this.getPanelConferenceChannels());
        }
        return this.panelConference;
    }

    private AastraPanel getPanelConferenceChannels() {
        if (this.panelConferenceChannels == null) {
            this.labelTotalConfChannels = new AastraLabel();
            this.labelTotalConfChannels.setBounds(20, 30, 240, 31);
            this.labelTotalConfChannels.setText(UtilLocale.getString("TXT_TOTAL"));
            this.labelAvailableConfChannels = new AastraLabel();
            this.labelAvailableConfChannels.setBounds(20, 60, 240, 31);
            this.labelAvailableConfChannels.setText(UtilLocale.getString("TXT_AVAILABLE"));
            this.panelConferenceChannels = new AastraPanel();
            this.panelConferenceChannels.setAlignmentX(0.0f);
            this.panelConferenceChannels.setLayout(null);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_CONFERENCE_CHANNELS"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.panelConferenceChannels.setBorder(titledBorder);
            this.panelConferenceChannels.setPreferredSize(new Dimension(340, 100));
            this.panelConferenceChannels.setMaximumSize(new Dimension(340, 100));
            this.panelConferenceChannels.add(this.labelTotalConfChannels);
            this.panelConferenceChannels.add(this.getTextFieldTotalConfChannels());
            this.panelConferenceChannels.add(this.labelAvailableConfChannels);
            this.panelConferenceChannels.add(this.getTextFieldAvailableConfChannels());
        }
        return this.panelConferenceChannels;
    }

    private AastraTextField getTextFieldTotalConfChannels() {
        if (this.textFieldTotalConfChannels == null) {
            this.textFieldTotalConfChannels = new AastraTextField();
            this.textFieldTotalConfChannels.setBounds(270, 30, 35, 18);
            this.textFieldTotalConfChannels.setEditable(false);
        }
        return this.textFieldTotalConfChannels;
    }

    private AastraTextField getTextFieldAvailableConfChannels() {
        if (this.textFieldAvailableConfChannels == null) {
            this.textFieldAvailableConfChannels = new AastraTextField();
            this.textFieldAvailableConfChannels.setBounds(270, 60, 35, 18);
            this.textFieldAvailableConfChannels.setEditable(false);
        }
        return this.textFieldAvailableConfChannels;
    }

    private AastraPanel getTabVideoDev() {
        if (this.tabVideoDev == null) {
            this.tabVideoDev = new AastraPanel();
            this.tabVideoDev.setLayout(new BoxLayout(this.tabVideoDev, 0));
            this.tabVideoDev.add(Box.createRigidArea(new Dimension(15, 0)));
            this.tabVideoDev.add(this.getPanelVideoDevSummary());
        }
        return this.tabVideoDev;
    }

    private AastraPanel getPanelVideoDevSummary() {
        if (this.panelVideoDevSummary == null) {
            this.panelVideoDevSummary = new AastraPanel();
            this.panelVideoDevSummary.setLayout(new BoxLayout(this.panelVideoDevSummary, 1));
            this.panelVideoDevSummary.setAlignmentY(0.0f);
            this.panelVideoDevSummary.add(Box.createRigidArea(new Dimension(0, 15)));
            this.panelVideoDevSummary.add(this.getPanelVideoDevSummaryGeneral());
            this.panelVideoDevSummary.add(Box.createRigidArea(new Dimension(0, 15)));
            this.panelVideoDevSummary.add(this.getPanelVideoDevSummaryState());
        }
        return this.panelVideoDevSummary;
    }

    private AastraPanel getPanelVideoDevSummaryGeneral() {
        if (this.panelVideoDevSummaryGeneral == null) {
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(20, 30, 240, 31);
            aastraLabel.setText(UtilLocale.getString("TXT_TOTAL"));
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setBounds(20, 60, 240, 31);
            aastraLabel2.setText(UtilLocale.getString("TXT_ENABLED"));
            this.panelVideoDevSummaryGeneral = new AastraPanel();
            this.panelVideoDevSummaryGeneral.setAlignmentX(0.0f);
            this.panelVideoDevSummaryGeneral.setLayout(null);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_GENERAL"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.panelVideoDevSummaryGeneral.setBorder(titledBorder);
            this.panelVideoDevSummaryGeneral.setPreferredSize(new Dimension(340, 100));
            this.panelVideoDevSummaryGeneral.setMaximumSize(new Dimension(340, 100));
            this.panelVideoDevSummaryGeneral.add(aastraLabel);
            this.panelVideoDevSummaryGeneral.add(this.getTextFieldVideoDevSumTotal());
            this.panelVideoDevSummaryGeneral.add(aastraLabel2);
            this.panelVideoDevSummaryGeneral.add(this.getTextFieldVideoDevSumEnabled());
        }
        return this.panelVideoDevSummaryGeneral;
    }

    private AastraTextField getTextFieldVideoDevSumTotal() {
        if (this.textFieldVideoDevSumTotal == null) {
            this.textFieldVideoDevSumTotal = new AastraTextField();
            this.textFieldVideoDevSumTotal.setBounds(270, 30, 35, 18);
            this.textFieldVideoDevSumTotal.setEditable(false);
        }
        return this.textFieldVideoDevSumTotal;
    }

    private AastraTextField getTextFieldVideoDevSumEnabled() {
        if (this.textFieldVideoDevSumEnabled == null) {
            this.textFieldVideoDevSumEnabled = new AastraTextField();
            this.textFieldVideoDevSumEnabled.setBounds(270, 60, 35, 18);
            this.textFieldVideoDevSumEnabled.setEditable(false);
        }
        return this.textFieldVideoDevSumEnabled;
    }

    private AastraPanel getPanelVideoDevSummaryState() {
        if (this.panelVideoDevSummaryState == null) {
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(20, 30, 240, 31);
            aastraLabel.setText(UtilLocale.getString("TXT_UNPLUGGED"));
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setBounds(20, 60, 240, 31);
            aastraLabel2.setText(UtilLocale.getString("TXT_INACTIVE"));
            AastraLabel aastraLabel3 = new AastraLabel();
            aastraLabel3.setBounds(20, 90, 240, 31);
            aastraLabel3.setText(UtilLocale.getString("TXT_ACTIVE"));
            AastraLabel aastraLabel4 = new AastraLabel();
            aastraLabel4.setBounds(20, 120, 240, 31);
            aastraLabel4.setText(UtilLocale.getString("TXT_FAILURE"));
            this.panelVideoDevSummaryState = new AastraPanel();
            this.panelVideoDevSummaryState.setAlignmentX(0.0f);
            this.panelVideoDevSummaryState.setLayout(null);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_STATE"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.panelVideoDevSummaryState.setBorder(titledBorder);
            Dimension dimension = new Dimension(340, 160);
            this.panelVideoDevSummaryState.setPreferredSize(dimension);
            this.panelVideoDevSummaryState.setMaximumSize(dimension);
            this.panelVideoDevSummaryState.add(aastraLabel);
            this.panelVideoDevSummaryState.add(this.getTextFieldVideoDevSumStateUnplugged());
            this.panelVideoDevSummaryState.add(aastraLabel2);
            this.panelVideoDevSummaryState.add(this.getTextFieldVideoDevSumStateInactive());
            this.panelVideoDevSummaryState.add(aastraLabel3);
            this.panelVideoDevSummaryState.add(this.getTextFieldVideoDevSumStateActive());
            this.panelVideoDevSummaryState.add(aastraLabel4);
            this.panelVideoDevSummaryState.add(this.getTextFieldVideoDevSumStateFailed());
        }
        return this.panelVideoDevSummaryState;
    }

    private AastraTextField getTextFieldVideoDevSumStateUnplugged() {
        if (this.textFieldVideoDevSumStateUnplugged == null) {
            this.textFieldVideoDevSumStateUnplugged = new AastraTextField();
            this.textFieldVideoDevSumStateUnplugged.setBounds(270, 30, 35, 18);
            this.textFieldVideoDevSumStateUnplugged.setEditable(false);
        }
        return this.textFieldVideoDevSumStateUnplugged;
    }

    private AastraTextField getTextFieldVideoDevSumStateInactive() {
        if (this.textFieldVideoDevSumStateInactive == null) {
            this.textFieldVideoDevSumStateInactive = new AastraTextField();
            this.textFieldVideoDevSumStateInactive.setBounds(270, 60, 35, 18);
            this.textFieldVideoDevSumStateInactive.setEditable(false);
        }
        return this.textFieldVideoDevSumStateInactive;
    }

    private AastraTextField getTextFieldVideoDevSumStateActive() {
        if (this.textFieldVideoDevSumStateStarted == null) {
            this.textFieldVideoDevSumStateStarted = new AastraTextField();
            this.textFieldVideoDevSumStateStarted.setBounds(270, 90, 35, 18);
            this.textFieldVideoDevSumStateStarted.setEditable(false);
        }
        return this.textFieldVideoDevSumStateStarted;
    }

    private AastraTextField getTextFieldVideoDevSumStateFailed() {
        if (this.textFieldVideoDevSumStateFailed == null) {
            this.textFieldVideoDevSumStateFailed = new AastraTextField();
            this.textFieldVideoDevSumStateFailed.setBounds(270, 120, 35, 18);
            this.textFieldVideoDevSumStateFailed.setEditable(false);
        }
        return this.textFieldVideoDevSumStateFailed;
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Link management event: " + omiManagementEventEnum.toString());
        block0 : switch (omiManagementEventEnum) {
            case LINK_READY: {
                this.lastAutoDBExportMsg = null;
                this.lastManualDBExportMsg = null;
            }
            case STANDBY_PARAMS_CHANGED: {
                if (this.omiManagement == null) break;
                String string = this.omiManagement.getOmmStbAddr();
                if (string != null) {
                    this.panelStandbyState.labelState.setTextHtml(UtilLocale.getString("TXT_STANDBY_OMM") + " (" + string + ")");
                } else {
                    this.panelStandbyState.labelState.setTextHtml(UtilLocale.getString("TXT_STANDBY_OMM"));
                }
                this.ommStbStateType = this.omiManagement.getOmmStbState();
                for (int i = 0; i < OmiMessage.HealthComponentType.values().length; ++i) {
                    if (OmiMessage.HealthComponentType.values()[i] != OmiMessage.HealthComponentType.standby) continue;
                    this.processStandbyState();
                    break block0;
                }
                break;
            }
            case RCV_OPEN_RESP: {
                this.startUpTimer();
                break;
            }
            case LINK_CLOSED: {
                this.stopUpTimer();
                break;
            }
        }
    }

    @Override
    public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
    }

    @Override
    public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data notification: " + dataNotificationEnum.toString() + "," + commonDataItemEnum.toString());
        switch (commonDataItemEnum) {
            case HealthState: {
                try {
                    this.healthState = (CommonDataHandler.HealthStateClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.HealthState);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.HealthState.toString());
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.HealthState.toString() + " failed");
                    return;
                }
                this.processHealthState();
                break;
            }
            case PPFirmwareUpdate: {
                try {
                    this.ppFirmwareUpdate = (CommonDataHandler.PPFirmwareUpdateClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.PPFirmwareUpdate);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PPFirmwareUpdate.toString() + ": enable='" + this.ppFirmwareUpdate.enable + "', source='" + this.ppFirmwareUpdate.name + "'");
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PPFirmwareUpdate.toString() + " failed");
                    return;
                }
                if (!this.ppFirmwareUpdateInitialized) {
                    this.ppFirmwareUpdateInitialized = true;
                }
                for (int i = 0; i < OmiMessage.HealthComponentType.values().length; ++i) {
                    if (OmiMessage.HealthComponentType.values()[i] != OmiMessage.HealthComponentType.download) continue;
                    this.processDOAState(i);
                    break;
                }
                this.getTextFieldFirmwareDownloadSource().setText(this.ppFirmwareUpdate.name);
                break;
            }
            case PPFirmwareUpdateOverview: {
                CommonDataHandler.PPFirmwareUpdateOverviewClass pPFirmwareUpdateOverviewClass = null;
                try {
                    pPFirmwareUpdateOverviewClass = (CommonDataHandler.PPFirmwareUpdateOverviewClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.PPFirmwareUpdateOverview);
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PPFirmwareUpdateOverview.toString() + " failed");
                    return;
                }
                switch (pPFirmwareUpdateOverviewClass.state) {
                    case startup: {
                        this.labelFirmwareDownloadStateValue.setIcon(GuiUtilIcon.getIconWait(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        this.labelFirmwareDownloadStateValue.setText(UtilLocale.getString("TXT_DELAYED_DURING_STARTUP_PHASE"));
                        this.labelFirmwareDownloadStateValue.setToolTipText(null);
                        break;
                    }
                    case disabled: {
                        this.labelFirmwareDownloadStateValue.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        this.labelFirmwareDownloadStateValue.setText(UtilLocale.getString("TXT_INACTIVE"));
                        break;
                    }
                    case running: {
                        this.labelFirmwareDownloadStateValue.setIcon(GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        this.labelFirmwareDownloadStateValue.setText(null);
                        this.labelFirmwareDownloadStateValue.setToolTipText(null);
                        break;
                    }
                    case error: {
                        this.labelFirmwareDownloadStateValue.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        this.labelFirmwareDownloadStateValue.setText(null);
                        break;
                    }
                    default: {
                        this.labelFirmwareDownloadStateValue.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        this.labelFirmwareDownloadStateValue.setText(null);
                    }
                }
                if (pPFirmwareUpdateOverviewClass.state == OmiMessage.PPFirmwareUpdateOverviewStateType.running) {
                    this.getTextFieldFirmwareVersion().setText(pPFirmwareUpdateOverviewClass.version);
                    this.getTextFieldKnownPPDevices().setText(String.valueOf(pPFirmwareUpdateOverviewClass.known));
                    this.getTextFieldUpdatedPPDevices().setText(String.valueOf(pPFirmwareUpdateOverviewClass.ready));
                    this.getTextFieldWaitingPPDevices().setText(String.valueOf(pPFirmwareUpdateOverviewClass.pending));
                    this.getTextFieldDownloadingPPDevices().setText(String.valueOf(pPFirmwareUpdateOverviewClass.active));
                    this.getTextFieldBarredPPDevices().setText(String.valueOf(pPFirmwareUpdateOverviewClass.barred));
                    this.getTextFieldErroredPPDevices().setText(String.valueOf(pPFirmwareUpdateOverviewClass.errored));
                    this.getTextFieldUnreachablePPDevices().setText(String.valueOf(pPFirmwareUpdateOverviewClass.notReachable));
                    this.getTextFieldDetachedPPDevices().setText(String.valueOf(pPFirmwareUpdateOverviewClass.detached));
                    break;
                }
                this.getTextFieldFirmwareVersion().setText("-");
                this.getTextFieldKnownPPDevices().setText("-");
                this.getTextFieldUpdatedPPDevices().setText("-");
                this.getTextFieldWaitingPPDevices().setText("-");
                this.getTextFieldDownloadingPPDevices().setText("-");
                this.getTextFieldBarredPPDevices().setText("-");
                this.getTextFieldErroredPPDevices().setText("-");
                this.getTextFieldUnreachablePPDevices().setText("-");
                this.getTextFieldDetachedPPDevices().setText("-");
                break;
            }
            case UserDataServer: {
                if (!this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveExternalUserData)) break;
                CommonDataHandler.UserDataServerClass userDataServerClass = null;
                try {
                    userDataServerClass = (CommonDataHandler.UserDataServerClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.UserDataServer);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.UserDataServer.toString() + "=" + userDataServerClass);
                    break;
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + (Object)((Object)CommonDataHandler.CommonDataItemEnum.UserDataServer) + " failed");
                    return;
                }
            }
            case DbTransferState: {
                CommonDataHandler.DbTransferStateClass dbTransferStateClass = null;
                try {
                    dbTransferStateClass = (CommonDataHandler.DbTransferStateClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.DbTransferState);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DbTransferState.toString() + "=" + dbTransferStateClass);
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + (Object)((Object)CommonDataHandler.CommonDataItemEnum.DbTransferState) + " failed");
                    return;
                }
                if (!(dbTransferStateClass.select != OmiMessage.DbTransferStateSelectType.automaticBackup && dbTransferStateClass.select != OmiMessage.DbTransferStateSelectType.manualBackup || dbTransferStateClass.state != OmiMessage.DbTransferStateType.finished || dbTransferStateClass.lastupd == null || dbTransferStateClass.lastupd.isEmpty())) {
                    if (dbTransferStateClass.select == OmiMessage.DbTransferStateSelectType.automaticBackup) {
                        this.lastAutoDBExportMsg = String.format(UtilLocale.getString("TXT_DB_EXPORT_AUTO_WRITTEN_SUCCESSFULLY_ON_*"), dbTransferStateClass.lastupd);
                    } else if (dbTransferStateClass.select == OmiMessage.DbTransferStateSelectType.manualBackup) {
                        this.lastManualDBExportMsg = String.format(UtilLocale.getString("TXT_DB_EXPORT_MANUAL_WRITTEN_SUCCESSFULLY_ON_*"), dbTransferStateClass.lastupd);
                    }
                    if (this.healthState != null && this.healthState.severity[OmiMessage.HealthComponentType.dbTransfer.ordinal()] == OmiMessage.SeverityType.OK) {
                        this.setDbTransferToolTipText();
                    }
                }
            }
            case BasicSIP: {
                try {
                    CommonDataHandler.BasicSIPClass basicSIPClass = (CommonDataHandler.BasicSIPClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.BasicSIP);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.BasicSIP.name() + ".sipRegisterCheckNum=" + basicSIPClass.sipRegisterCheckNum);
                    if (basicSIPClass.sipRegisterCheckNum == null) break;
                    this.textFieldVisibilityCheckNumber.setText(basicSIPClass.sipRegisterCheckNum.toString());
                    break;
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.BasicSIP.name() + " failed");
                    return;
                }
            }
            case SecureSIPCertificateServer: {
                this.processSipCertState();
                break;
            }
            case UserDeviceSyncOMM: {
                this.processUserDeviceSyncState();
                break;
            }
            case MOMControlState: {
                this.processMOMConnectionState();
                break;
            }
            case SecureOMMCertificateServer: {
                this.processOmmCertState();
                break;
            }
            case SecurePROVCertificateServer: {
                this.processProvisioningCertState();
                break;
            }
            case SupplicantCertificateServer: {
                this.processSupplicantCertState();
                break;
            }
            case Supplicant: 
            case SupplicantCertificate: {
                this.processSuplicantCertificate();
                break;
            }
        }
    }

    private void processSuplicantCertificate() {
        CommonDataHandler.CertificateClass certificateClass = null;
        Boolean bl = null;
        boolean bl2 = false;
        try {
            bl = (Boolean)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.Supplicant);
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            bl = false;
        }
        if (!bl.booleanValue()) {
            try {
                certificateClass = (CommonDataHandler.CertificateClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.SupplicantCertificate);
            }
            catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                // empty catch block
            }
            if (certificateClass != null && certificateClass.nTrustedCertificates > 0 && certificateClass.nLocalCertificates > 0 && certificateClass.nPrivateKeys > 0 && !certificateClass.identity.isEmpty()) {
                bl2 = true;
            }
        }
        if (bl.booleanValue() || bl2) {
            this.processDefaultState(OmiMessage.HealthComponentType.supplicant.ordinal());
        } else {
            this.panelSupplicantState.labelStateValue.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
            this.panelSupplicantState.labelStateValue.setToolTipText(UtilLocale.getString("TXT_NOT_CONFIGURED"));
        }
    }

    @Override
    public void processRfpSummaryNotification(RfpSummaryHandler.RfpSummaryClass rfpSummaryClass) {
        this.getTextFieldTotalRFPs().setText(String.valueOf(rfpSummaryClass.nRFPs));
        this.getTextFieldConnected().setText(String.valueOf(rfpSummaryClass.nConnected));
        this.getTextFieldBrandingMismatch().setText(String.valueOf(rfpSummaryClass.nWrongBranded));
        this.getTextFieldStandbyMisconfigured().setText(String.valueOf(rfpSummaryClass.nWrongStandby));
        this.getTextFieldSWVersionMismatch().setText(String.valueOf(rfpSummaryClass.nWrongSWVersion));
        this.getTextFieldNewSWAvailable().setText(String.valueOf(rfpSummaryClass.nNewSWAvailable));
        this.getTextFieldNoAdvancedFeatures().setText(String.valueOf(rfpSummaryClass.nAdvancedFeatError));
        this.getTextFieldNoEncryption().setText(String.valueOf(rfpSummaryClass.nNoEncryption));
        this.getTextFieldUsbOverload().setText(String.valueOf(rfpSummaryClass.nUsbOverloads));
        this.getTextFieldDECTActivated().setText(String.valueOf(rfpSummaryClass.nDECTActivated));
        this.getTextFieldDECTCurrentlyActive().setText(String.valueOf(rfpSummaryClass.nDECTRunning));
        this.getTextFieldClusters().setText(String.valueOf(rfpSummaryClass.nUsedDECTClusters));
        this.getTextFieldPagingAreas().setText(String.valueOf(rfpSummaryClass.nUsedPagingAreas));
        this.getTextFieldWLANActivated().setText(String.valueOf(rfpSummaryClass.nWLANActivated));
        this.getTextFieldWLANCurrentlyActive().setText(String.valueOf(rfpSummaryClass.nWLANRunning));
        this.getTextFieldProfiles().setText(String.valueOf(rfpSummaryClass.nUsedWLANProfiles));
        this.getTextFieldWrongSupplicantCfg().setText(String.valueOf(rfpSummaryClass.nWrongSupplicantCfg));
    }

    @Override
    public void processRfpSummaryErrorNotification(OmiMessage omiMessage) {
    }

    @Override
    public void processPpUserSummaryNotification(PpUserSummaryHandler.PpUserSummaryClass ppUserSummaryClass) {
        this.getTextFieldTotalPPUsers().setText(String.valueOf(ppUserSummaryClass.nRecords));
        this.getTextFieldSIPRegistered().setText(String.valueOf(ppUserSummaryClass.nSipRegistration));
        this.getTextFieldMonitoredActive().setText(String.valueOf(ppUserSummaryClass.nMonitoringModeActive));
        this.getTextFieldMonitoredPassive().setText(String.valueOf(ppUserSummaryClass.nMonitoringModePassive));
        if (ppUserSummaryClass.nMonitoringModeActive + ppUserSummaryClass.nMonitoringModePassive > 0) {
            this.panelOverviewFeatures.add(this.getPanelUMOState());
            this.panelOverviewFeatures.updateUI();
        } else {
            this.panelOverviewFeatures.remove(this.getPanelUMOState());
            this.panelOverviewFeatures.updateUI();
        }
        this.getTextFieldSendingMessagesPermission().setText(String.valueOf(ppUserSummaryClass.nMsgSend));
        this.getTextFieldDECTLocatable().setText(String.valueOf(ppUserSummaryClass.nLocatable));
        this.getTextFieldMonitoringStateWarning().setText(String.valueOf(ppUserSummaryClass.nMonitoringStateWarning));
        this.getTextFieldMonitoringStateUnavailable().setText(String.valueOf(ppUserSummaryClass.nMonitoringStateUnavailable));
        this.getTextFieldMonitoringStateEscalated().setText(String.valueOf(ppUserSummaryClass.nMonitoringStateEscalated));
    }

    @Override
    public void processPpUserSummaryErrorNotification(OmiMessage omiMessage) {
    }

    @Override
    public void processPpDevSummaryNotification(PpDevSummaryHandler.PpDevSummaryClass ppDevSummaryClass) {
        this.getTextFieldTotalPPDevices().setText(String.valueOf(ppDevSummaryClass.nRecords));
        this.getTextFieldSubscribed().setText(String.valueOf(ppDevSummaryClass.nSubscribed));
    }

    @Override
    public void processPpDevSummaryErrorNotification(OmiMessage omiMessage) {
    }

    @Override
    public void processFreeConferenceChannelsDataNotification(DataNotificationEnum dataNotificationEnum) {
        ConferenceRoomHandler.FreeConferenceChannels freeConferenceChannels = this.conferenceRoomHandler.getFreeConferenceChannels();
        this.getTextFieldTotalConfChannels().setText(String.valueOf(freeConferenceChannels.totalChannels));
        this.getTextFieldAvailableConfChannels().setText(String.valueOf(freeConferenceChannels.freeChannels));
    }

    @Override
    public void processFreeConferenceChannelsDataErrorNotification(DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        this.getTextFieldTotalConfChannels().setText("-");
        this.getTextFieldAvailableConfChannels().setText("-");
    }

    @Override
    public void processVideoDevSummaryNotification(VideoDevSummaryHandler.VideoDevSummaryClass videoDevSummaryClass) {
        if (!this.panelVideoDevHealthstateActive && videoDevSummaryClass.nRecords > 0) {
            this.panelVideoDevHealthstateActive = true;
            this.panelOverviewFeatures.add(this.getPanelVideoState());
            this.panelOverviewFeatures.updateUI();
        } else if (this.panelVideoDevHealthstateActive && videoDevSummaryClass.nRecords == 0) {
            this.panelVideoDevHealthstateActive = false;
            this.panelOverviewFeatures.remove(this.getPanelVideoState());
            this.panelOverviewFeatures.updateUI();
        }
        this.textFieldVideoDevSumTotal.setText(String.valueOf(videoDevSummaryClass.nRecords));
        this.textFieldVideoDevSumEnabled.setText(String.valueOf(videoDevSummaryClass.enabledNum));
        this.textFieldVideoDevSumStateUnplugged.setText(String.valueOf(videoDevSummaryClass.stateUnpluggedNum));
        this.textFieldVideoDevSumStateInactive.setText(String.valueOf(videoDevSummaryClass.stateInactiveNum));
        this.textFieldVideoDevSumStateStarted.setText(String.valueOf(videoDevSummaryClass.stateActiveNum));
        this.textFieldVideoDevSumStateFailed.setText(String.valueOf(videoDevSummaryClass.stateFailedNum));
    }

    @Override
    public void processVideoDevSummaryErrorNotification(OmiMessage omiMessage) {
    }

    @Override
    public void processSiteSummaryNotification(SiteSummaryHandler.SiteSummaryClass siteSummaryClass) {
        this.getTextFieldSitesTotal().setText(String.valueOf(siteSummaryClass.nRecords));
        this.getTextFieldSitesWithRfp().setText(String.valueOf(siteSummaryClass.rfpSiteNum));
        this.getTextFieldSitesHiQAudio().setText(String.valueOf(siteSummaryClass.g722SiteNum));
        this.getTextFieldSitesEnhDECTSecure().setText(String.valueOf(siteSummaryClass.dectSecuritySiteNum));
        this.getTextFieldSitesSRTP().setText(String.valueOf(siteSummaryClass.srtpSiteNum));
        this.getTextFieldSitesTerminalVideo().setText(String.valueOf(siteSummaryClass.videoStreamingSiteNum));
    }

    @Override
    public void processSiteSummaryErrorNotification(OmiMessage omiMessage) {
    }

    @Override
    public void componentActivated(Component component) {
        this.rfpSummaryHandler.activateRequest();
        this.ppUserSummaryHandler.activateRequest();
        this.ppDevSummaryHandler.activateRequest();
        this.siteSummaryHandler.activateRequest();
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo)) {
            this.videoDevSummaryHandler.activateRequest();
        }
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
            if (!this.panelSIPCertHealthstateActive) {
                this.panelSIPCertHealthstateActive = true;
                this.panelOverviewFeatures.add(this.getPanelSipCertState());
                this.panelOverviewFeatures.updateUI();
            }
        } else if (this.panelSIPCertHealthstateActive) {
            this.panelSIPCertHealthstateActive = false;
            this.panelOverviewFeatures.remove(this.getPanelSipCertState());
            this.panelOverviewFeatures.updateUI();
        }
    }

    @Override
    public void componentDeactivated() {
        this.rfpSummaryHandler.deactivateRequest();
        this.ppUserSummaryHandler.deactivateRequest();
        this.ppDevSummaryHandler.deactivateRequest();
        this.siteSummaryHandler.deactivateRequest();
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo)) {
            this.videoDevSummaryHandler.deactivateRequest();
        }
    }

    class UptimeTask
    extends TimerTask {
        UptimeTask() {
        }

        @Override
        public void run() {
            if (SystemStatusPanel.this.uptimeSeconds != null) {
                SystemStatusPanel.this.uptimeSeconds = SystemStatusPanel.this.uptimeSeconds + 60;
                SystemStatusPanel.this.showUptime();
            }
        }
    }

    private class HealthStatePanel
    extends AastraPanel {
        private static final long serialVersionUID = 1L;
        private AastraLabel labelState;
        private AastraLabel labelStateValue;

        private HealthStatePanel(String string, OmiMessage.HealthComponentType healthComponentType) {
            this.setLayout(null);
            this.setPreferredSize(dimensionHealthStatePanel);
            this.setMinimumSize(dimensionHealthStatePanel);
            this.setMaximumSize(dimensionHealthStatePanel);
            this.labelState = this.getLabelHealthState(string);
            this.labelStateValue = this.getLabelHealthStateValue(healthComponentType);
            this.add(this.labelState);
            this.add(this.labelStateValue);
        }

        private AastraLabel getLabelHealthState(String string) {
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(20, 20, 270, 31);
            aastraLabel.setTextHtml(string);
            return aastraLabel;
        }

        private AastraLabel getLabelHealthStateValue(OmiMessage.HealthComponentType healthComponentType) {
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(305, 20, 20, 16);
            aastraLabel.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
            aastraLabel.setToolTipText(null);
            SystemStatusPanel.this.mapLabel.put(healthComponentType, aastraLabel);
            return aastraLabel;
        }
    }
}

