/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.system;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.guiutil.GuiUtilCheckBox;
import com.aastra.oamp.guiutil.GuiUtilComboBox;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraComboBox;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraTabbedPane;
import com.aastra.style.AastraTextField;
import com.aastra.util.UtilSpy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;

public class SystemTimeZonePanel
extends AastraPanel
implements CommonDataHandler.CommonDataNotificationInterface,
GuiComponentActivationInterface {
    private static final long serialVersionUID = 1L;
    private static final int TAB_NONE = -1;
    private static final int TAB_GENERAL = 0;
    private static final int TAB_STD_TIME = 1;
    private static final int TAB_DS_TIME = 2;
    private CommonDataHandler commonDataHandler = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private AastraPanel panelButtonBar = null;
    private AastraButton buttonOK = null;
    private AastraButton buttonCancel = null;
    private AastraButton buttonDefault = null;
    private AastraTabbedPane tabbedPaneTZone = null;
    private boolean isEditable = true;
    CommonDataHandler.TimeZoneListClass tzoneList = null;
    private GuiUtilChangeHandler utilChangeHandler = null;
    private int errorTab = -1;
    private UtilErrorComp utilErrorComp = null;
    private boolean firstTimeZoneNotify = true;
    private AastraPanel panelGeneral = null;
    private AastraLabel labelTZoneName = null;
    private AastraComboBox comboBoxTZoneName = null;
    private AastraLabel labelTZoneID = null;
    private AastraTextField textFieldTZoneIDValue = null;
    private String tZoneName = null;
    private AastraPanel tabGeneral = null;
    private AastraLabel labelStdOffset = null;
    private GuiUtilTextField textFieldStdOffset = null;
    private AastraLabel labelUnitMinuteStdOffset = null;
    private GuiUtilCheckBox checkBoxDstActive = null;
    private AastraLabel labelDstActive = null;
    private AastraLabel labelDstOffset = null;
    private GuiUtilTextField textFieldDstOffset = null;
    private AastraLabel labelUnitMinuteDstOffset = null;
    private PanelTimeSettings tabStandardTime = null;
    private PanelTimeSettings tabDaylightSavingsTime = null;

    public SystemTimeZonePanel(GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, CommonDataHandler commonDataHandler) {
        this.commonDataHandler = commonDataHandler;
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.TimeZone, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.TimeZoneList, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.TimeZoneDetails, this);
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.setSize(new Dimension(780, 500));
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilChangeHandler = new GuiUtilChangeHandler(this.getButtonOK(), this.getButtonCancel());
            this.utilErrorComp = new UtilErrorComp();
        } else {
            this.isEditable = false;
        }
        this.add(this.getPanelGeneral());
        this.add(Box.createRigidArea(new Dimension(0, 15)));
        this.add(this.getTabbedPaneTimeZone());
        if (this.isEditable) {
            this.add(Box.createRigidArea(new Dimension(0, 15)));
            this.add(this.getPanelButtonBar());
        }
    }

    private AastraPanel getPanelGeneral() {
        if (this.panelGeneral == null) {
            this.panelGeneral = new AastraPanel();
            this.panelGeneral.setLayout(null);
            this.panelGeneral.setPreferredSize(new Dimension(700, 120));
            this.panelGeneral.setMaximumSize(new Dimension(700, 120));
            this.panelGeneral.setAlignmentX(0.0f);
            this.labelTZoneName = new AastraLabel();
            this.labelTZoneName.setBounds(30, 30, 91, 16);
            this.labelTZoneName.setText(UtilLocale.getString("TXT_NAME"));
            this.labelTZoneID = new AastraLabel();
            this.labelTZoneID.setBounds(30, 75, 93, 16);
            this.labelTZoneID.setText(UtilLocale.getString("TXT_ID"));
            this.panelGeneral.add((Component)this.labelTZoneName, null);
            this.panelGeneral.add((Component)this.getComboBoxTZoneName(), null);
            this.panelGeneral.add((Component)this.labelTZoneID, null);
            this.panelGeneral.add((Component)this.getTextFieldTZoneIDValue(), null);
            if (!this.isEditable) {
                UtilSetPanelEditable.setDisabled(this.panelGeneral);
            }
        }
        return this.panelGeneral;
    }

    private AastraComboBox getComboBoxTZoneName() {
        if (this.comboBoxTZoneName == null) {
            this.comboBoxTZoneName = new AastraComboBox();
            this.comboBoxTZoneName.setBounds(100, 30, 260, 20);
            this.comboBoxTZoneName.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (SystemTimeZonePanel.this.tzoneList != null) {
                        String string = SystemTimeZonePanel.this.tzoneList.list[((SystemTimeZonePanel)SystemTimeZonePanel.this).comboBoxTZoneName.getSelectedIndex()].id;
                        SystemTimeZonePanel.this.getTextFieldTZoneIDValue().setText(string);
                        SystemTimeZonePanel.this.commonDataHandler.requestTimeZoneDetails(string);
                    }
                }
            });
        }
        return this.comboBoxTZoneName;
    }

    private void fillComboBoxTZoneName() {
        ItemListener[] itemListenerArray;
        try {
            this.tzoneList = (CommonDataHandler.TimeZoneListClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.TimeZoneList);
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.TimeZoneList.toString() + " failed");
            return;
        }
        String string = this.getTextFieldTZoneIDValue().getText();
        int n = 0;
        if (this.tzoneList != null) {
            for (n = 0; n < this.tzoneList.list.length && !this.tzoneList.list[n].id.equals(string); ++n) {
            }
        }
        for (ItemListener itemListener : itemListenerArray = this.getComboBoxTZoneName().getItemListeners()) {
            this.getComboBoxTZoneName().removeItemListener(itemListener);
        }
        this.getComboBoxTZoneName().removeAllItems();
        for (int i = 0; i < this.tzoneList.list.length; ++i) {
            this.getComboBoxTZoneName().addItem(this.tzoneList.list[i].name);
        }
        if (n < this.tzoneList.list.length) {
            this.getComboBoxTZoneName().setSelectedIndex(n);
        } else {
            this.getComboBoxTZoneName().setSelectedIndex(0);
        }
        for (ItemListener itemListener : itemListenerArray) {
            this.getComboBoxTZoneName().addItemListener(itemListener);
        }
    }

    private void setComboBoxTZoneName() {
        String string = null;
        int n = 0;
        try {
            string = (String)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.TimeZone);
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.TimeZone.toString() + " failed");
            return;
        }
        if (this.tzoneList != null) {
            ItemListener[] itemListenerArray;
            for (n = 0; n < this.tzoneList.list.length && !this.tzoneList.list[n].id.equals(string); ++n) {
            }
            for (ItemListener itemListener : itemListenerArray = this.getComboBoxTZoneName().getItemListeners()) {
                this.getComboBoxTZoneName().removeItemListener(itemListener);
            }
            if (n < this.tzoneList.list.length) {
                this.getComboBoxTZoneName().setSelectedIndex(n);
            } else {
                this.getComboBoxTZoneName().setSelectedIndex(0);
            }
            for (ItemListener itemListener : itemListenerArray) {
                this.getComboBoxTZoneName().addItemListener(itemListener);
            }
        }
        this.getTextFieldTZoneIDValue().setText(string);
    }

    private void enableDSTSettings(boolean bl) {
        this.textFieldDstOffset.setEnabled(bl);
        this.tabbedPaneTZone.setFirstTab();
        this.tabbedPaneTZone.setEnabledAt(1, bl);
        this.tabbedPaneTZone.setEnabledAt(2, bl);
    }

    private AastraTextField getTextFieldTZoneIDValue() {
        if (this.textFieldTZoneIDValue == null) {
            this.textFieldTZoneIDValue = new AastraTextField();
            this.textFieldTZoneIDValue.setBounds(100, 75, 30, 20);
            this.textFieldTZoneIDValue.setEditable(false);
        }
        return this.textFieldTZoneIDValue;
    }

    private AastraTabbedPane getTabbedPaneTimeZone() {
        if (this.tabbedPaneTZone == null) {
            this.tabbedPaneTZone = new AastraTabbedPane();
            this.tabbedPaneTZone.setPreferredSize(new Dimension(390, 370));
            this.tabbedPaneTZone.setMaximumSize(new Dimension(390, 370));
            this.tabbedPaneTZone.setAlignmentX(0.0f);
            this.tabbedPaneTZone.addTab(UtilLocale.getString("TXT_GENERAL"), null, this.getTabGeneral(), null);
            this.tabbedPaneTZone.addTab(UtilLocale.getString("TXT_STANDARD_TIME"), null, this.getTabStandardTime().getPanelTimeSettings(), null);
            this.tabbedPaneTZone.addTab(UtilLocale.getString("TXT_DAYLIGHT_SAVINGS_TIME"), null, this.getTabDaylightSavingsTime().getPanelTimeSettings(), null);
        }
        return this.tabbedPaneTZone;
    }

    private AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            this.tabGeneral = new AastraPanel();
            this.tabGeneral.setLayout(null);
            this.labelStdOffset = new AastraLabel();
            this.labelStdOffset.setBounds(30, 30, 200, 32);
            this.labelStdOffset.setText("<html>" + UtilLocale.getString("TXT_DIFFERENCE_LOCAL_STANDARD_TIME_TO_UTC") + "</html>");
            this.labelUnitMinuteStdOffset = new AastraLabel();
            this.labelUnitMinuteStdOffset.setBounds(320, 30, 50, 16);
            this.labelUnitMinuteStdOffset.setText(UtilLocale.getString("TXT_UNIT_MINUTE"));
            this.labelDstActive = new AastraLabel();
            this.labelDstActive.setBounds(30, 70, 200, 16);
            this.labelDstActive.setText(UtilLocale.getString("TXT_DAYLIGHT_SAVINGS_TIME"));
            this.labelDstOffset = new AastraLabel();
            this.labelDstOffset.setBounds(30, 110, 200, 32);
            this.labelDstOffset.setText("<html>" + UtilLocale.getString("TXT_DIFFERENCE_DAYLIGHT_SAVINGS_TIME_TO_STANDARD_TIME") + "</html>");
            this.labelUnitMinuteDstOffset = new AastraLabel();
            this.labelUnitMinuteDstOffset.setBounds(320, 110, 50, 16);
            this.labelUnitMinuteDstOffset.setText(UtilLocale.getString("TXT_UNIT_MINUTE"));
            this.tabGeneral.add(this.labelStdOffset);
            this.tabGeneral.add(this.getTextFieldStdOffset());
            this.tabGeneral.add(this.labelUnitMinuteStdOffset);
            this.tabGeneral.add(this.labelDstActive);
            this.tabGeneral.add((Component)this.getCheckBoxDSTActive(), null);
            this.tabGeneral.add(this.labelDstOffset);
            this.tabGeneral.add(this.getTextFieldDstOffset());
            this.tabGeneral.add(this.labelUnitMinuteDstOffset);
            if (this.isEditable) {
                this.utilErrorComp.putWithTab(OmiMessage.TimeZoneType.stdOffset.toString(), this.labelStdOffset, this.textFieldStdOffset, 0);
                this.utilErrorComp.putWithTab(OmiMessage.TimeZoneType.dstOffset.toString(), this.labelDstOffset, this.textFieldDstOffset, 0);
            } else {
                UtilSetPanelEditable.setDisabled(this.tabGeneral);
            }
        }
        return this.tabGeneral;
    }

    private GuiUtilTextField getTextFieldStdOffset() {
        if (this.textFieldStdOffset == null) {
            this.textFieldStdOffset = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldStdOffset.setBounds(250, 30, 50, 20);
        }
        return this.textFieldStdOffset;
    }

    private GuiUtilCheckBox getCheckBoxDSTActive() {
        if (this.checkBoxDstActive == null) {
            this.checkBoxDstActive = new GuiUtilCheckBox(this.utilChangeHandler, 245, 70);
            this.checkBoxDstActive.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SystemTimeZonePanel.this.enableDSTSettings(SystemTimeZonePanel.this.checkBoxDstActive.isSelected());
                }
            });
        }
        return this.checkBoxDstActive;
    }

    private GuiUtilTextField getTextFieldDstOffset() {
        if (this.textFieldDstOffset == null) {
            this.textFieldDstOffset = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldDstOffset.setBounds(250, 110, 50, 20);
        }
        return this.textFieldDstOffset;
    }

    private PanelTimeSettings getTabStandardTime() {
        if (this.tabStandardTime == null) {
            this.tabStandardTime = new PanelTimeSettings();
        }
        return this.tabStandardTime;
    }

    private PanelTimeSettings getTabDaylightSavingsTime() {
        if (this.tabDaylightSavingsTime == null) {
            this.tabDaylightSavingsTime = new PanelTimeSettings();
        }
        return this.tabDaylightSavingsTime;
    }

    private AastraPanel getPanelButtonBar() {
        if (this.panelButtonBar == null) {
            this.panelButtonBar = new AastraPanel();
            this.panelButtonBar.setLayout(null);
            this.panelButtonBar.setPreferredSize(new Dimension(390, 65));
            this.panelButtonBar.setMaximumSize(new Dimension(390, 65));
            this.panelButtonBar.setAlignmentX(0.0f);
            this.panelButtonBar.add(this.getButtonOK());
            this.panelButtonBar.add(this.getButtonCancel());
            this.panelButtonBar.add(this.getButtonDefault());
        }
        return this.panelButtonBar;
    }

    private AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOK.setBounds(30, 15, 90, 25);
            this.buttonOK.setEnabled(false);
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SystemTimeZonePanel.this.utilChangeHandler.deactivate();
                    SystemTimeZonePanel.this.utilErrorComp.clearComponents();
                    if (!SystemTimeZonePanel.this.changeTimeZone() && SystemTimeZonePanel.this.errorTab != -1) {
                        SystemTimeZonePanel.this.tabbedPaneTZone.setSelectedIndex(SystemTimeZonePanel.this.errorTab);
                        SystemTimeZonePanel.this.errorTab = -1;
                    }
                }
            });
        }
        return this.buttonOK;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.setBounds(150, 15, 90, 25);
            this.buttonCancel.setEnabled(false);
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SystemTimeZonePanel.this.utilChangeHandler.deactivate();
                    String string = SystemTimeZonePanel.this.tzoneList.list[((SystemTimeZonePanel)SystemTimeZonePanel.this).comboBoxTZoneName.getSelectedIndex()].id;
                    SystemTimeZonePanel.this.commonDataHandler.requestTimeZoneDetails(string);
                    SystemTimeZonePanel.this.utilErrorComp.clearComponents();
                }
            });
        }
        return this.buttonCancel;
    }

    private AastraButton getButtonDefault() {
        if (this.buttonDefault == null) {
            this.buttonDefault = new AastraButton();
            this.buttonDefault.setText(UtilLocale.getString("TXT_DEFAULT_20"));
            this.buttonDefault.setBounds(270, 15, 90, 25);
            this.buttonDefault.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SystemTimeZonePanel.this.utilChangeHandler.deactivate();
                    SystemTimeZonePanel.this.commonDataHandler.resetTimeZoneDetails();
                    GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_SET_TIME_ZONES_BACK_TO_DEFAULT"), new Object[0]));
                    String string = SystemTimeZonePanel.this.tzoneList.list[((SystemTimeZonePanel)SystemTimeZonePanel.this).comboBoxTZoneName.getSelectedIndex()].id;
                    SystemTimeZonePanel.this.getTextFieldTZoneIDValue().setText(string);
                    SystemTimeZonePanel.this.commonDataHandler.requestTimeZoneDetails(string);
                    SystemTimeZonePanel.this.utilErrorComp.clearComponents();
                }
            });
        }
        return this.buttonDefault;
    }

    private void setTabs(CommonDataHandler.TimeZoneDetailsClass timeZoneDetailsClass) {
        this.tZoneName = timeZoneDetailsClass.name;
        if (this.tzoneList != null) {
            this.textFieldStdOffset.setText(String.valueOf(timeZoneDetailsClass.stdOffset));
            this.textFieldDstOffset.setText(String.valueOf(timeZoneDetailsClass.dstOffset));
            if (timeZoneDetailsClass.stdMonth > 0) {
                this.checkBoxDstActive.setSelected(true);
                this.enableDSTSettings(true);
            } else {
                this.checkBoxDstActive.setSelected(false);
                this.enableDSTSettings(false);
            }
            this.tabStandardTime.setCheckBoxSelect(timeZoneDetailsClass.stdDay == 0);
            this.tabStandardTime.setComboBoxMonth(timeZoneDetailsClass.stdMonth);
            this.tabStandardTime.setComboBoxDay(timeZoneDetailsClass.stdDay);
            this.tabStandardTime.setComboBoxDayOfWeek(timeZoneDetailsClass.stdDoW);
            this.tabStandardTime.setComboBoxWeek(timeZoneDetailsClass.stdWoM);
            this.tabStandardTime.setComboBoxHour(timeZoneDetailsClass.stdHour);
            this.tabStandardTime.setComboBoxMinute(timeZoneDetailsClass.stdMin);
            this.tabStandardTime.enableInputFields();
            this.tabDaylightSavingsTime.setCheckBoxSelect(timeZoneDetailsClass.dstDay == 0);
            this.tabDaylightSavingsTime.setComboBoxMonth(timeZoneDetailsClass.dstMonth);
            this.tabDaylightSavingsTime.setComboBoxDay(timeZoneDetailsClass.dstDay);
            this.tabDaylightSavingsTime.setComboBoxDayOfWeek(timeZoneDetailsClass.dstDoW);
            this.tabDaylightSavingsTime.setComboBoxWeek(timeZoneDetailsClass.dstWoM);
            this.tabDaylightSavingsTime.setComboBoxHour(timeZoneDetailsClass.dstHour);
            this.tabDaylightSavingsTime.setComboBoxMinute(timeZoneDetailsClass.dstMin);
            this.tabDaylightSavingsTime.enableInputFields();
        }
        if (this.utilChangeHandler != null) {
            this.utilChangeHandler.deactivate();
        }
    }

    public boolean changeTimeZone() {
        boolean bl = true;
        CommonDataHandler.TimeZoneDetailsClass timeZoneDetailsClass = new CommonDataHandler.TimeZoneDetailsClass();
        timeZoneDetailsClass.name = this.tZoneName;
        timeZoneDetailsClass.id = this.tzoneList.list[this.comboBoxTZoneName.getSelectedIndex()].id;
        if (this.textFieldStdOffset.getText().length() > 0) {
            try {
                timeZoneDetailsClass.stdOffset = Integer.parseInt(this.textFieldStdOffset.getText());
            }
            catch (NumberFormatException numberFormatException) {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_INPUT_FORMAT_INVALID"));
                this.indicateWrongInput(this.textFieldStdOffset, 0);
                bl = false;
            }
        } else {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_MISSING"), UtilLocale.getString("TXT_UTC_DIFFERENCE")));
            this.indicateWrongInput(this.textFieldStdOffset, 0);
            bl = false;
        }
        if (this.checkBoxDstActive.isSelected()) {
            timeZoneDetailsClass.stdMonth = this.tabStandardTime.getComboBoxMonth();
            timeZoneDetailsClass.stdDay = this.tabStandardTime.getComboBoxDay();
            timeZoneDetailsClass.stdDoW = this.tabStandardTime.getComboBoxDayOfWeek();
            timeZoneDetailsClass.stdWoM = this.tabStandardTime.getComboBoxWeek();
            timeZoneDetailsClass.stdHour = this.tabStandardTime.getComboBoxHour();
            timeZoneDetailsClass.stdMin = this.tabStandardTime.getComboBoxMinute();
            if (this.textFieldDstOffset.getText().length() > 0) {
                try {
                    timeZoneDetailsClass.dstOffset = Integer.parseInt(this.textFieldDstOffset.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    GuiInfoConsole.showError(UtilLocale.getString("TXT_INPUT_FORMAT_INVALID"));
                    this.indicateWrongInput(this.textFieldDstOffset, 0);
                    bl = false;
                }
            } else {
                GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_MISSING"), UtilLocale.getString("TXT_STANDARD_TIME_DIFFERENCE")));
                this.indicateWrongInput(this.textFieldDstOffset, 0);
                bl = false;
            }
            timeZoneDetailsClass.dstMonth = this.tabDaylightSavingsTime.getComboBoxMonth();
            timeZoneDetailsClass.dstDay = this.tabDaylightSavingsTime.getComboBoxDay();
            timeZoneDetailsClass.dstDoW = this.tabDaylightSavingsTime.getComboBoxDayOfWeek();
            timeZoneDetailsClass.dstWoM = this.tabDaylightSavingsTime.getComboBoxWeek();
            timeZoneDetailsClass.dstHour = this.tabDaylightSavingsTime.getComboBoxHour();
            timeZoneDetailsClass.dstMin = this.tabDaylightSavingsTime.getComboBoxMinute();
        } else {
            timeZoneDetailsClass.stdMonth = 0;
            timeZoneDetailsClass.stdDay = 0;
            timeZoneDetailsClass.stdDoW = 0;
            timeZoneDetailsClass.stdWoM = 0;
            timeZoneDetailsClass.stdHour = 0;
            timeZoneDetailsClass.stdMin = 0;
            timeZoneDetailsClass.dstOffset = 0;
            timeZoneDetailsClass.dstMonth = 0;
            timeZoneDetailsClass.dstDay = 0;
            timeZoneDetailsClass.dstDoW = 0;
            timeZoneDetailsClass.dstWoM = 0;
            timeZoneDetailsClass.dstHour = 0;
            timeZoneDetailsClass.dstMin = 0;
        }
        if (bl) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.TimeZoneDetails.toString() + "='" + timeZoneDetailsClass + "'");
            this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.TimeZoneDetails, timeZoneDetailsClass);
            this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.TimeZoneDetails);
        }
        return bl;
    }

    private void indicateWrongInput(JComponent jComponent, int n) {
        if (jComponent != null) {
            this.utilErrorComp.markComponent(jComponent);
            if (this.errorTab == -1) {
                this.errorTab = n;
            }
            this.buttonCancel.setEnabled(true);
        }
    }

    @Override
    public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        OmiMessage.errorCodes errorCodes2 = null;
        if (!this.isEditable || string == null) {
            return;
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data error notification: " + dataNotificationEnum.toString() + ",item=" + String.valueOf((Object)commonDataItemEnum) + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data error notification: Unknown errorCode=" + string);
        }
        String string4 = null;
        if (string2 != null) {
            string4 = this.utilErrorComp.getLabelText(string2);
        }
        if (errorCodes2 != null) {
            GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, string4, string3));
        } else {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
        }
        JComponent jComponent = null;
        if (string2 != null) {
            jComponent = this.utilErrorComp.getField(string2);
        }
        if (jComponent != null) {
            this.utilErrorComp.markComponent(jComponent);
            this.tabbedPaneTZone.setSelectedIndex(this.utilErrorComp.getTab(string2));
            this.buttonCancel.setEnabled(true);
        }
    }

    @Override
    public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data notification: " + dataNotificationEnum.toString() + "," + commonDataItemEnum.toString());
        switch (commonDataItemEnum) {
            case TimeZoneList: {
                this.fillComboBoxTZoneName();
                break;
            }
            case TimeZone: {
                if (!this.firstTimeZoneNotify) break;
                this.setComboBoxTZoneName();
                this.firstTimeZoneNotify = false;
                break;
            }
            case TimeZoneDetails: {
                CommonDataHandler.TimeZoneDetailsClass timeZoneDetailsClass = null;
                try {
                    timeZoneDetailsClass = (CommonDataHandler.TimeZoneDetailsClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.TimeZoneDetails);
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.TimeZoneDetails.toString() + " failed");
                    return;
                }
                this.setTabs(timeZoneDetailsClass);
                break;
            }
        }
    }

    @Override
    public void componentActivated(Component component) {
        if (this.isEditable) {
            this.getComboBoxTZoneName().requestFocusInWindow();
            this.utilChangeHandler.initRootPane(this.getRootPane());
            this.getRootPane().setDefaultButton(this.getButtonCancel());
        }
    }

    @Override
    public void componentDeactivated() {
    }

    private final class PanelTimeSettings {
        private AastraPanel panelTimeSettings = new AastraPanel();
        private AastraLabel labelSelect = null;
        private AastraLabel labelMonth = null;
        private AastraLabel labelDay = null;
        private AastraLabel labelDayOfWeek = null;
        private AastraLabel labelWeek = null;
        private AastraLabel labelHour = null;
        private AastraLabel labelMinute = null;
        private GuiUtilCheckBox checkBoxDayMode = null;
        private GuiUtilComboBox comboBoxMonth = null;
        private GuiUtilComboBox comboBoxDay = null;
        private GuiUtilComboBox comboBoxDayOfWeek = null;
        private GuiUtilComboBox comboBoxWeek = null;
        private GuiUtilComboBox comboBoxHour = null;
        private GuiUtilComboBox comboBoxMinute = null;
        private int valDay;
        private int valDayOfWeek;
        private int valWeek;

        private PanelTimeSettings() {
            this.panelTimeSettings.setLayout(null);
            this.labelSelect = new AastraLabel();
            this.labelSelect.setBounds(30, 15, 200, 16);
            this.labelSelect.setText(UtilLocale.getString("TXT_VARIABLE_DATE"));
            this.labelMonth = new AastraLabel();
            this.labelMonth.setBounds(30, 55, 200, 16);
            this.labelMonth.setText(UtilLocale.getString("TXT_MONTH"));
            this.labelDay = new AastraLabel();
            this.labelDay.setBounds(30, 95, 200, 16);
            this.labelDay.setText(UtilLocale.getString("TXT_DAY"));
            this.labelDayOfWeek = new AastraLabel();
            this.labelDayOfWeek.setBounds(30, 135, 200, 16);
            this.labelDayOfWeek.setText(UtilLocale.getString("TXT_DAY_OF_WEEK"));
            this.labelWeek = new AastraLabel();
            this.labelWeek.setBounds(30, 175, 200, 16);
            this.labelWeek.setText(UtilLocale.getString("TXT_WEEK"));
            this.labelHour = new AastraLabel();
            this.labelHour.setBounds(30, 215, 200, 16);
            this.labelHour.setText(UtilLocale.getString("TXT_HOUR"));
            this.labelMinute = new AastraLabel();
            this.labelMinute.setBounds(30, 255, 200, 16);
            this.labelMinute.setText(UtilLocale.getString("TXT_MINUTE"));
            this.panelTimeSettings.add(this.labelSelect);
            this.panelTimeSettings.add(this.createCheckBoxDayMode());
            this.panelTimeSettings.add(this.labelMonth);
            this.panelTimeSettings.add(this.createComboBoxMonth());
            this.panelTimeSettings.add(this.labelDay);
            this.panelTimeSettings.add(this.createComboBoxDay());
            this.panelTimeSettings.add(this.labelDayOfWeek);
            this.panelTimeSettings.add(this.createComboBoxDayOfWeek());
            this.panelTimeSettings.add(this.labelWeek);
            this.panelTimeSettings.add(this.createComboBoxWeek());
            this.panelTimeSettings.add(this.labelHour);
            this.panelTimeSettings.add(this.createComboBoxHour());
            this.panelTimeSettings.add(this.labelMinute);
            this.panelTimeSettings.add(this.createComboBoxMinute());
        }

        private AastraPanel getPanelTimeSettings() {
            return this.panelTimeSettings;
        }

        private GuiUtilCheckBox createCheckBoxDayMode() {
            if (this.checkBoxDayMode == null) {
                this.checkBoxDayMode = new GuiUtilCheckBox(SystemTimeZonePanel.this.utilChangeHandler, 245, 15);
                this.checkBoxDayMode.setToolTipText(UtilLocale.getString("TXT_DAY_MODE_HELP"));
                this.checkBoxDayMode.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PanelTimeSettings.this.enableInputFields();
                    }
                });
            }
            return this.checkBoxDayMode;
        }

        private void setCheckBoxSelect(boolean bl) {
            this.checkBoxDayMode.setSelected(bl);
        }

        private GuiUtilComboBox createComboBoxMonth() {
            if (this.comboBoxMonth == null) {
                this.comboBoxMonth = new GuiUtilComboBox(SystemTimeZonePanel.this.utilChangeHandler);
                this.comboBoxMonth.setBounds(250, 55, 50, 20);
                for (int i = 1; i <= 12; ++i) {
                    this.comboBoxMonth.addItem(String.valueOf(i));
                }
                this.comboBoxMonth.setToolTipText(UtilLocale.getString("TXT_MONTH_DAY_HELP"));
                this.comboBoxMonth.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                    }
                });
                this.comboBoxMonth.activateActionListener();
            }
            return this.comboBoxMonth;
        }

        private void setComboBoxMonth(int n) {
            this.comboBoxMonth.deactivateActionListener();
            if (n > 0) {
                this.comboBoxMonth.setSelectedItem(String.valueOf(n));
            } else {
                this.comboBoxMonth.setSelectedItem("1");
            }
            this.comboBoxMonth.activateActionListener();
        }

        private int getComboBoxMonth() {
            return new Integer(this.comboBoxMonth.getSelectedItem().toString());
        }

        private GuiUtilComboBox createComboBoxDay() {
            if (this.comboBoxDay == null) {
                this.comboBoxDay = new GuiUtilComboBox(SystemTimeZonePanel.this.utilChangeHandler);
                this.comboBoxDay.setBounds(250, 95, 50, 20);
                for (int i = 1; i <= 31; ++i) {
                    this.comboBoxDay.addItem(String.valueOf(i));
                }
                this.comboBoxDay.setToolTipText(UtilLocale.getString("TXT_MONTH_DAY_HELP"));
                this.comboBoxDay.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Object object = PanelTimeSettings.this.comboBoxDay.getSelectedItem();
                        if (object != null) {
                            PanelTimeSettings.this.valDay = new Integer(object.toString());
                        }
                    }
                });
                this.comboBoxDay.activateActionListener();
            }
            return this.comboBoxDay;
        }

        private void setComboBoxDay(int n) {
            this.valDay = n;
            this.comboBoxDay.deactivateActionListener();
            if (n == 0) {
                this.comboBoxDay.setSelectedItem(null);
            } else {
                this.comboBoxDay.setSelectedItem(String.valueOf(n));
            }
            this.comboBoxDay.activateActionListener();
        }

        private int getComboBoxDay() {
            Object object = this.comboBoxDay.getSelectedItem();
            if (object == null) {
                return 0;
            }
            return new Integer(object.toString());
        }

        private GuiUtilComboBox createComboBoxDayOfWeek() {
            if (this.comboBoxDayOfWeek == null) {
                this.comboBoxDayOfWeek = new GuiUtilComboBox(SystemTimeZonePanel.this.utilChangeHandler);
                this.comboBoxDayOfWeek.setBounds(250, 135, 50, 20);
                for (int i = 1; i <= 7; ++i) {
                    this.comboBoxDayOfWeek.addItem(String.valueOf(i));
                }
                this.comboBoxDayOfWeek.setToolTipText(UtilLocale.getString("TXT_DAY_OF_WEEK_HELP"));
                this.comboBoxDayOfWeek.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Object object = PanelTimeSettings.this.comboBoxDayOfWeek.getSelectedItem();
                        if (object != null) {
                            PanelTimeSettings.this.valDayOfWeek = new Integer(object.toString());
                        }
                    }
                });
                this.comboBoxDayOfWeek.activateActionListener();
            }
            return this.comboBoxDayOfWeek;
        }

        private void setComboBoxDayOfWeek(int n) {
            this.valDayOfWeek = n;
            this.comboBoxDayOfWeek.deactivateActionListener();
            if (n == 0) {
                this.comboBoxDayOfWeek.setSelectedItem(null);
            } else {
                this.comboBoxDayOfWeek.setSelectedItem(String.valueOf(n));
            }
            this.comboBoxDayOfWeek.activateActionListener();
        }

        private int getComboBoxDayOfWeek() {
            Object object = this.comboBoxDayOfWeek.getSelectedItem();
            if (object == null) {
                return 0;
            }
            return new Integer(object.toString());
        }

        private GuiUtilComboBox createComboBoxWeek() {
            if (this.comboBoxWeek == null) {
                this.comboBoxWeek = new GuiUtilComboBox(SystemTimeZonePanel.this.utilChangeHandler);
                this.comboBoxWeek.setBounds(250, 175, 50, 20);
                for (int i = 1; i <= 5; ++i) {
                    this.comboBoxWeek.addItem(String.valueOf(i));
                }
                this.comboBoxWeek.setToolTipText(UtilLocale.getString("TXT_WEEK_HELP"));
                this.comboBoxWeek.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Object object = PanelTimeSettings.this.comboBoxWeek.getSelectedItem();
                        if (object != null) {
                            PanelTimeSettings.this.valWeek = new Integer(object.toString());
                        }
                    }
                });
                this.comboBoxWeek.activateActionListener();
            }
            return this.comboBoxWeek;
        }

        private void setComboBoxWeek(int n) {
            this.valWeek = n;
            this.comboBoxWeek.deactivateActionListener();
            if (n == 0) {
                this.comboBoxWeek.setSelectedItem(null);
            } else {
                this.comboBoxWeek.setSelectedItem(String.valueOf(n));
            }
            this.comboBoxWeek.activateActionListener();
        }

        private int getComboBoxWeek() {
            Object object = this.comboBoxWeek.getSelectedItem();
            if (object == null) {
                return 0;
            }
            return new Integer(object.toString());
        }

        private GuiUtilComboBox createComboBoxHour() {
            if (this.comboBoxHour == null) {
                this.comboBoxHour = new GuiUtilComboBox(SystemTimeZonePanel.this.utilChangeHandler);
                this.comboBoxHour.setBounds(250, 215, 50, 20);
                for (int i = 0; i <= 23; ++i) {
                    this.comboBoxHour.addItem(String.valueOf(i));
                }
                this.comboBoxHour.activateActionListener();
            }
            return this.comboBoxHour;
        }

        private void setComboBoxHour(int n) {
            this.comboBoxHour.deactivateActionListener();
            this.comboBoxHour.setSelectedItem(String.valueOf(n));
            this.comboBoxHour.activateActionListener();
        }

        private int getComboBoxHour() {
            return this.comboBoxHour.getSelectedIndex();
        }

        private GuiUtilComboBox createComboBoxMinute() {
            if (this.comboBoxMinute == null) {
                this.comboBoxMinute = new GuiUtilComboBox(SystemTimeZonePanel.this.utilChangeHandler);
                this.comboBoxMinute.setBounds(250, 255, 50, 20);
                for (int i = 0; i <= 59; ++i) {
                    this.comboBoxMinute.addItem(String.valueOf(i));
                }
                this.comboBoxMinute.activateActionListener();
            }
            return this.comboBoxMinute;
        }

        private void setComboBoxMinute(int n) {
            this.comboBoxMinute.deactivateActionListener();
            this.comboBoxMinute.setSelectedItem(String.valueOf(n));
            this.comboBoxMinute.activateActionListener();
        }

        private int getComboBoxMinute() {
            return new Integer(this.comboBoxMinute.getSelectedItem().toString());
        }

        private void enableInputFields() {
            if (this.checkBoxDayMode.isSelected()) {
                this.comboBoxDay.setEditable(true);
                this.comboBoxDay.setSelectedItem(null);
                this.comboBoxDay.setEditable(false);
                this.comboBoxDay.setEnabled(false);
                if (this.valDayOfWeek == 0) {
                    this.valDayOfWeek = 1;
                }
                this.comboBoxDayOfWeek.setSelectedItem(String.valueOf(this.valDayOfWeek));
                this.comboBoxDayOfWeek.setEnabled(true);
                if (this.valWeek == 0) {
                    this.valWeek = 1;
                }
                this.comboBoxWeek.setSelectedItem(String.valueOf(this.valWeek));
                this.comboBoxWeek.setEnabled(true);
            } else {
                if (this.valDay == 0) {
                    this.valDay = 1;
                }
                this.comboBoxDay.setSelectedItem(String.valueOf(this.valDay));
                this.comboBoxDay.setEnabled(true);
                this.comboBoxDayOfWeek.setEditable(true);
                this.comboBoxDayOfWeek.setSelectedItem(null);
                this.comboBoxDayOfWeek.setEditable(false);
                this.comboBoxDayOfWeek.setEnabled(false);
                this.comboBoxWeek.setEditable(true);
                this.comboBoxWeek.setSelectedItem(null);
                this.comboBoxWeek.setEditable(false);
                this.comboBoxWeek.setEnabled(false);
            }
        }
    }
}

