/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.system;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraTextField;
import com.aastra.util.UtilSpy;

final class SystemUtil {
    SystemUtil() {
    }

    static final class SpySystemSip {
        private Object sipPanel = null;

        SpySystemSip(Object object) {
            this.sipPanel = object;
        }

        void spyBasicSipSetting(CommonDataHandler.BasicSIPClass basicSIPClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "Setting " + CommonDataHandler.CommonDataItemEnum.BasicSIP.toString() + ":");
            this.spyBasicSip(basicSIPClass);
        }

        void spyBasicSipReading(CommonDataHandler.BasicSIPClass basicSIPClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "Reading " + CommonDataHandler.CommonDataItemEnum.BasicSIP.toString() + ":");
            this.spyBasicSip(basicSIPClass);
        }

        private void spyBasicSip(CommonDataHandler.BasicSIPClass basicSIPClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  '" + basicSIPClass.proxyServer + "'," + basicSIPClass.proxyPort);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  '" + basicSIPClass.outboundProxyServer + "'," + basicSIPClass.outboundProxyPort);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  '" + basicSIPClass.regServer + "'," + basicSIPClass.regPort);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  " + basicSIPClass.regPeriod + ",");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  '" + (Object)((Object)basicSIPClass.transportProt) + "',");
        }

        void spyRegTrafficShapeSetting(CommonDataHandler.RegTrafficShapeClass regTrafficShapeClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "Setting " + CommonDataHandler.CommonDataItemEnum.RegTrafficShape.toString() + ":");
            this.spyRegTrafficShape(regTrafficShapeClass);
        }

        void spyRegTrafficShapeReading(CommonDataHandler.RegTrafficShapeClass regTrafficShapeClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "Reading " + CommonDataHandler.CommonDataItemEnum.RegTrafficShape.toString() + ":");
            this.spyRegTrafficShape(regTrafficShapeClass);
        }

        private void spyRegTrafficShape(CommonDataHandler.RegTrafficShapeClass regTrafficShapeClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  " + regTrafficShapeClass.maxRegistrations + "," + regTrafficShapeClass.timeout + "," + regTrafficShapeClass.spreadRegRenew + "," + regTrafficShapeClass.renewalTimer);
        }

        void spyAdvancedSipSetting(CommonDataHandler.AdvancedSIPClass advancedSIPClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "Setting " + CommonDataHandler.CommonDataItemEnum.AdvancedSIP.toString() + ":");
            this.spyAdvancedSip(advancedSIPClass);
        }

        void spyAdvancedSipReading(CommonDataHandler.AdvancedSIPClass advancedSIPClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "Reading " + CommonDataHandler.CommonDataItemEnum.AdvancedSIP.toString() + ":");
            this.spyAdvancedSip(advancedSIPClass);
        }

        private void spyAdvancedSip(CommonDataHandler.AdvancedSIPClass advancedSIPClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  " + advancedSIPClass.mwiSubscription + "," + advancedSIPClass.userAgentInfo + "," + advancedSIPClass.userAgentCompatibility + "," + advancedSIPClass.xAastraId);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  " + advancedSIPClass.dialTerminator + "," + advancedSIPClass.regTimeoutRetryTimer + "," + advancedSIPClass.regFailedRetryTimer + "," + advancedSIPClass.transactionTimer);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  " + advancedSIPClass.blacklistTimeout + "," + (Object)((Object)advancedSIPClass.callerDetermination));
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  " + advancedSIPClass.multipleRing + "," + advancedSIPClass.callRejectStateCodeUsr);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  " + advancedSIPClass.sessionTimer + "," + advancedSIPClass.incomingCallTimeout);
            if (GuiMain.getOmiManagementObject().getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSemiAttendedTransfer)) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  " + (Object)((Object)advancedSIPClass.sAttTransferMode) + "," + advancedSIPClass.referToWithReplaces);
            }
        }

        void spyBackupSipSetting(CommonDataHandler.BackupSIPClass backupSIPClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "Setting " + CommonDataHandler.CommonDataItemEnum.BackupSIP.toString() + ":");
            this.spyBackupSip(backupSIPClass);
        }

        void spyBackupSipReading(CommonDataHandler.BackupSIPClass backupSIPClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "Reading " + CommonDataHandler.CommonDataItemEnum.BackupSIP.toString() + ":");
            this.spyBackupSip(backupSIPClass);
        }

        private void spyBackupSip(CommonDataHandler.BackupSIPClass backupSIPClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  '" + backupSIPClass.secondaryProxyServer + "'," + backupSIPClass.secondaryProxyPort);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  '" + backupSIPClass.secondaryRegServer + "'," + backupSIPClass.secondaryRegPort);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  '" + backupSIPClass.secondaryOutboundProxyServer + "'," + backupSIPClass.secondaryOutboundProxyPort);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  '" + backupSIPClass.tertiaryProxyServer + "'," + backupSIPClass.tertiaryProxyPort);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  '" + backupSIPClass.tertiaryRegServer + "'," + backupSIPClass.tertiaryRegPort);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  '" + backupSIPClass.tertiaryOutboundProxyServer + "'," + backupSIPClass.tertiaryOutboundProxyPort);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  " + backupSIPClass.failoverActive + "," + backupSIPClass.failoverTime);
        }

        void spyRTPSipSetting(CommonDataHandler.RTPClass rTPClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "Setting " + CommonDataHandler.CommonDataItemEnum.RTP.toString() + ":");
            this.spyRTPSip(rTPClass);
        }

        void spyRTPSipReading(CommonDataHandler.RTPClass rTPClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "Reading " + CommonDataHandler.CommonDataItemEnum.RTP.toString() + ":");
            this.spyRTPSip(rTPClass);
        }

        private void spyRTPSip(CommonDataHandler.RTPClass rTPClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  " + rTPClass.portBase + "," + rTPClass.packetTime + "," + rTPClass.silenceSupp + "," + rTPClass.receiverPrecedence + "," + rTPClass.comfNoisePktElim + "," + rTPClass.singleCodecReplyInSDP);
            if (rTPClass.codecs != null) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  " + (Object)((Object)rTPClass.codecs[0]) + "," + (Object)((Object)rTPClass.codecs[1]) + "," + (Object)((Object)rTPClass.codecs[2]) + "," + (Object)((Object)rTPClass.codecs[3]));
            }
        }

        void spyDTMFSipSetting(CommonDataHandler.DTMFClass dTMFClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "Setting " + CommonDataHandler.CommonDataItemEnum.DTMF.toString() + ":");
            this.spyDTMFSip(dTMFClass);
        }

        void spyDTMFSipReading(CommonDataHandler.DTMFClass dTMFClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "Reading " + CommonDataHandler.CommonDataItemEnum.DTMF.toString() + ":");
            this.spyDTMFSip(dTMFClass);
        }

        private void spyDTMFSip(CommonDataHandler.DTMFClass dTMFClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  " + dTMFClass.outOfBand + "," + dTMFClass.payloadType + "," + (Object)((Object)dTMFClass.method));
        }

        void spySupplServSipSetting(CommonDataHandler.SuplServClass suplServClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "Setting " + CommonDataHandler.CommonDataItemEnum.SuplServ.toString() + ":");
            this.spySupplServSip(suplServClass);
        }

        void spySupplServSipReading(CommonDataHandler.SuplServClass suplServClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "Reading " + CommonDataHandler.CommonDataItemEnum.SuplServ.toString() + ":");
            this.spySupplServSip(suplServClass);
        }

        private void spySupplServSip(CommonDataHandler.SuplServClass suplServClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, String.format("  %s = %s", OmiMessage.SuplServType.callForwDiv.name(), suplServClass.callForwDiv));
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, String.format("  %s = %s", OmiMessage.SuplServType.locLineHndlg.name(), suplServClass.locLineHndlg));
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, String.format("  %s = %s", OmiMessage.SuplServType.callTransferByHook.name(), suplServClass.callTransferByHook));
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, String.format("  %s = %s", OmiMessage.SuplServType.uriSeparator.name(), suplServClass.uriSeparator));
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, String.format("  %s = %s", OmiMessage.SuplServType.reRegisterAfterFailOver.name(), suplServClass.reRegisterAfterFailOver));
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, String.format("  %s = %s", OmiMessage.SuplServType.ringingOnHold.name(), suplServClass.ringingOnHold));
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, String.format("  %s = %s", OmiMessage.SuplServType.transferByHook6xxd.name(), suplServClass.transferByHook6xxd));
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, String.format("  %s = %s", OmiMessage.SuplServType.callRejectOnSilentCharging.name(), suplServClass.callRejectOnSilentCharging));
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, String.format("  %s = %s sec", OmiMessage.SuplServType.releaseInfoTimerActiveCall.name(), suplServClass.releaseInfoTimerActiveCall));
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, String.format("  %s = %s sec", OmiMessage.SuplServType.releaseInfoTimerHoldCall.name(), suplServClass.releaseInfoTimerHoldCall));
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, String.format("  %s = %s sec", OmiMessage.SuplServType.releaseInfoTimerFailedCall.name(), suplServClass.releaseInfoTimerFailedCall));
        }

        void spySecureSipSetting(CommonDataHandler.SecureSIPClass secureSIPClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "Setting " + CommonDataHandler.CommonDataItemEnum.SecureSIP.toString() + ":");
            this.spySecureSip(secureSIPClass);
        }

        void spySecureSipReading(CommonDataHandler.SecureSIPClass secureSIPClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "Reading " + CommonDataHandler.CommonDataItemEnum.SecureSIP.toString() + ":");
            this.spySecureSip(secureSIPClass);
        }

        private void spySecureSip(CommonDataHandler.SecureSIPClass secureSIPClass) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  " + secureSIPClass.keepAliveTimeoutEnable + ", '" + secureSIPClass.timeout + "',");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "  " + secureSIPClass.sendSipsOverTLS + ", " + secureSIPClass.authenticationTLS + ", " + secureSIPClass.commonNameValidationTLS);
        }

        void spyCertsServerSipSetting(CommonDataHandler.CertificateServer certificateServer) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "Setting " + CommonDataHandler.CommonDataItemEnum.SecureSIPCertificateServer.toString() + ":");
            this.spyCertsServerSip(certificateServer);
        }

        void spyCertsServerSipReading(CommonDataHandler.CertificateServer certificateServer) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, "Reading " + CommonDataHandler.CommonDataItemEnum.SecureSIPCertificateServer.toString() + ":");
            this.spyCertsServerSip(certificateServer);
        }

        private void spyCertsServerSip(CommonDataHandler.CertificateServer certificateServer) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this.sipPanel, String.format("   %s='%s', %s='%s', %s='%s'\n   %s \n", OmiMessage.attribIds.trustedCertificates.name(), certificateServer.trustedCertsFileName, OmiMessage.attribIds.localCertificates.name(), certificateServer.localCertsFileName, OmiMessage.attribIds.privateKeys.name(), certificateServer.privateKeyFileName, certificateServer.url.getUrlParamsAsString()));
        }
    }

    static class ToolsSystemSettings
    extends ToolsSystem {
        ToolsSystemSettings(UtilErrorComp utilErrorComp) {
            super(utilErrorComp);
        }

        int getHourFromTextField(AastraTextField aastraTextField, String string) {
            return UtilMisc.getIntFromTextFieldRange(aastraTextField, string, this.utilErrorComp, 10, 0, 23);
        }

        int getMinuteFromTextField(AastraTextField aastraTextField, String string) {
            return UtilMisc.getIntFromTextFieldRange(aastraTextField, string, this.utilErrorComp, 10, 0, 59);
        }

        int getSecondsFromMinuteTextField(AastraTextField aastraTextField, String string) {
            int n = UtilMisc.getIntFromTextField(aastraTextField, string, this.utilErrorComp, 10);
            if (n != -1) {
                n *= 60;
            }
            return n;
        }

        int getDiffServFromTextField(AastraTextField aastraTextField, String string) {
            int n;
            block5: {
                n = -1;
                if (aastraTextField.getText().length() > 0) {
                    try {
                        int n2 = Integer.parseInt(aastraTextField.getText(), 10);
                        if (n2 < 0 || n2 > 63) {
                            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_INPUT_FORMAT_INVALID"), string));
                            this.utilErrorComp.markComponent(aastraTextField);
                            break block5;
                        }
                        n = n2 << 2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_INPUT_FORMAT_INVALID"), string));
                        this.utilErrorComp.markComponent(aastraTextField);
                    }
                } else {
                    GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_MISSING"), string));
                    this.utilErrorComp.markComponent(aastraTextField);
                }
            }
            return n;
        }
    }

    static class ToolsSystem {
        UtilErrorComp utilErrorComp = null;

        ToolsSystem(UtilErrorComp utilErrorComp) {
            this.utilErrorComp = utilErrorComp;
        }

        int getUnsignedDecimalIntFromTextField(AastraTextField aastraTextField, String string) {
            return UtilMisc.getIntFromTextField(aastraTextField, string, this.utilErrorComp, 10);
        }

        int getUnsignedHexIntFromTextField(AastraTextField aastraTextField, String string) {
            return UtilMisc.getIntFromTextField(aastraTextField, string, this.utilErrorComp, 16);
        }

        long getUnsignedDecimalLongFromTextField(AastraTextField aastraTextField, String string) {
            return UtilMisc.getLongFromTextField(aastraTextField, string, this.utilErrorComp, 10);
        }
    }
}

