/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.system;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.guiutil.GuiUtilButtonBar;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilElementCollection;
import com.aastra.oamp.guiutil.GuiUtilPasswordFieldNew;
import com.aastra.oamp.guiutil.GuiUtilTabbedPane;
import com.aastra.oamp.system.SystemAdvancedSettingsPanel;
import com.aastra.oamp.system.SystemCertificateNumberPanel;
import com.aastra.oamp.system.SystemPemFileImportPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraPanel;
import com.aastra.util.UtilSpy;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.border.TitledBorder;

public class SystemUtilCertificatePanel
extends AastraPanel {
    private static final long serialVersionUID = 1L;
    private static final int tabbedPaneWidth = 800;
    private SystemAdvancedSettingsPanel parent = null;
    private CommonDataHandler.CommonDataItemEnum itemCertificate;
    private CommonDataHandler.CommonDataItemEnum itemCertificateServer;
    private CommonDataHandler commonDataHandler = null;
    private SystemCertificateNumberPanel panelCertsKey = null;
    private boolean isEditable;
    private UtilErrorComp utilErrorCompOmmCertificate = null;
    private SystemPemFileImportPanel panelOmmCertImport = null;
    private boolean ommCertsKeyChangeStarted = false;
    private PrivateKeyInputPanel panelOmmCertPassword = null;
    private GuiUtilTabbedPane tabbedPaneSysSet = null;
    private String strInfo = null;
    private boolean trustedCerts = true;

    public SystemUtilCertificatePanel(SystemAdvancedSettingsPanel systemAdvancedSettingsPanel, CommonDataHandler commonDataHandler, boolean bl, GuiUtilTabbedPane guiUtilTabbedPane, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum2, String string, boolean bl2) {
        this.parent = systemAdvancedSettingsPanel;
        this.commonDataHandler = commonDataHandler;
        this.isEditable = bl;
        this.tabbedPaneSysSet = guiUtilTabbedPane;
        this.itemCertificate = commonDataItemEnum;
        this.itemCertificateServer = commonDataItemEnum2;
        this.strInfo = string;
        this.trustedCerts = bl2;
        CommonDataNotificationHandler commonDataNotificationHandler = new CommonDataNotificationHandler();
        this.commonDataHandler.registerDataNotificationListener(this.itemCertificate, commonDataNotificationHandler);
        if (this.isEditable) {
            this.commonDataHandler.registerDataNotificationListener(this.itemCertificateServer, commonDataNotificationHandler);
        }
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(this.getPanelOmmCertsKey());
        if (this.isEditable) {
            this.utilErrorCompOmmCertificate = new UtilErrorComp();
            this.add(Box.createRigidArea(new Dimension(0, 10)));
            this.add(this.getPanelOmmCertImport());
            this.add(Box.createRigidArea(new Dimension(0, 10)));
            this.add(this.getPanelOmmCertPassword());
        }
    }

    private SystemCertificateNumberPanel getPanelOmmCertsKey() {
        if (this.panelCertsKey == null) {
            this.panelCertsKey = new SystemCertificateNumberPanel(800, this.isEditable, this.trustedCerts);
            if (this.isEditable) {
                this.panelCertsKey.buttonSecurityDelete.setToolTipText(UtilLocale.getString("TXT_DELETE_CERTIFICATES_HELP"));
                this.panelCertsKey.buttonSecurityDelete.setEnabled(false);
                this.panelCertsKey.buttonSecurityDelete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        GuiUtilDialog guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_DELETE_CERTIFICATES_AND_PRIVATE_KEY_?"), true);
                        if (guiUtilDialog.getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
                            SystemUtilCertificatePanel.this.ommCertsKeyChangeStarted = true;
                            SystemUtilCertificatePanel.this.commonDataHandler.deleteOmmCertificates();
                        }
                    }
                });
            }
        }
        return this.panelCertsKey;
    }

    private SystemPemFileImportPanel getPanelOmmCertImport() {
        if (this.panelOmmCertImport == null) {
            class PemFileDataHandler
            implements SystemPemFileImportPanel.PemFileStringHandlerInterface {
                CommonDataHandler.CertificateClass certs = null;

                PemFileDataHandler() {
                }

                @Override
                public void certInit() {
                    this.certs = null;
                }

                @Override
                public void addCertifcate(OmiMessage.PEMCertificateListType pEMCertificateListType, String string) {
                    if (this.certs == null) {
                        this.certs = new CommonDataHandler.CertificateClass();
                    }
                    switch (pEMCertificateListType) {
                        case localCertificates: {
                            this.certs.localCertificates.add(string);
                            break;
                        }
                        case privateKey: {
                            this.certs.privateKey = string;
                        }
                    }
                }

                @Override
                public void sendCertificates() {
                    if (this.certs != null) {
                        SystemUtilCertificatePanel.this.ommCertsKeyChangeStarted = true;
                        SystemUtilCertificatePanel.this.commonDataHandler.setData(SystemUtilCertificatePanel.this.itemCertificate, this.certs);
                        SystemUtilCertificatePanel.this.commonDataHandler.commitChangesToOmm(SystemUtilCertificatePanel.this.itemCertificate);
                    }
                }
            }
            this.panelOmmCertImport = new SystemPemFileImportPanel(800, new PemFileDataHandler(), this.strInfo, this.trustedCerts);
        }
        return this.panelOmmCertImport;
    }

    private PrivateKeyInputPanel getPanelOmmCertPassword() {
        if (this.panelOmmCertPassword == null) {
            class ChangeHandler
            implements SystemAdvancedSettingsPanel.ChangePrivateKeyInterface {
                ChangeHandler() {
                }

                @Override
                public void changePrivateKey(String string) {
                    CommonDataHandler.CertificateClass certificateClass = new CommonDataHandler.CertificateClass();
                    certificateClass.privateKeyPassword = string;
                    SystemUtilCertificatePanel.this.commonDataHandler.setData(SystemUtilCertificatePanel.this.itemCertificate, certificateClass);
                    SystemUtilCertificatePanel.this.commonDataHandler.commitChangesToOmm(SystemUtilCertificatePanel.this.itemCertificate);
                }
            }
            this.panelOmmCertPassword = new PrivateKeyInputPanel(new ChangeHandler(), this.utilErrorCompOmmCertificate);
        }
        return this.panelOmmCertPassword;
    }

    private void updateOMMCertificatePanel(boolean bl) {
        this.panelCertsKey.buttonSecurityDelete.setEnabled(!bl);
        if (this.panelOmmCertImport != null) {
            this.panelOmmCertImport.setActive(!bl);
        }
    }

    private class PrivateKeyInputPanel
    extends AastraPanel {
        private static final long serialVersionUID = 1L;
        private SystemAdvancedSettingsPanel.ChangePrivateKeyInterface changeHandler;
        private GuiUtilButtonBar buttonBar = null;
        public GuiUtilPasswordFieldNew passwordField = null;
        public GuiUtilPasswordFieldNew passwordFieldConfirm = null;
        private UtilErrorComp errorComp = null;

        private PrivateKeyInputPanel(SystemAdvancedSettingsPanel.ChangePrivateKeyInterface changePrivateKeyInterface, UtilErrorComp utilErrorComp) {
            this.changeHandler = changePrivateKeyInterface;
            this.errorComp = utilErrorComp;
            this.setLayout(new BoxLayout(this, 1));
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_PRIVATE_KEY_PASSWORD"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.setBorder(titledBorder);
            this.setPreferredSize(new Dimension(780, 150));
            this.setMaximumSize(new Dimension(780, 150));
            this.setMinimumSize(new Dimension(780, 150));
            this.setAlignmentX(0.0f);
            AastraPanel aastraPanel = new AastraPanel();
            aastraPanel.setLayout(null);
            aastraPanel.setPreferredSize(new Dimension(760, 70));
            aastraPanel.setMaximumSize(new Dimension(760, 70));
            aastraPanel.setMinimumSize(new Dimension(760, 70));
            aastraPanel.setAlignmentX(0.0f);
            this.buttonBar = new GuiUtilButtonBar(800, SystemUtilCertificatePanel.this.tabbedPaneSysSet);
            this.buttonBar.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((PrivateKeyInputPanel)PrivateKeyInputPanel.this).buttonBar.utilChangeHandler.deactivate();
                    PrivateKeyInputPanel.this.errorComp.clearComponents();
                    String string = new String(PrivateKeyInputPanel.this.passwordField.getPassword());
                    String string2 = new String(PrivateKeyInputPanel.this.passwordFieldConfirm.getPassword());
                    if (PrivateKeyInputPanel.this.passwordField.isChanged() && PrivateKeyInputPanel.this.passwordFieldConfirm.isChanged() && string.equals(string2)) {
                        if (PrivateKeyInputPanel.this.changeHandler != null) {
                            PrivateKeyInputPanel.this.changeHandler.changePrivateKey(string);
                        }
                    } else {
                        GuiInfoConsole.showError(UtilLocale.getString("TXT_PASSWORD_CONFIRMATION_FAILED"));
                        PrivateKeyInputPanel.this.errorComp.markComponent(PrivateKeyInputPanel.this.passwordField);
                        PrivateKeyInputPanel.this.errorComp.markComponent(PrivateKeyInputPanel.this.passwordFieldConfirm);
                        PrivateKeyInputPanel.this.passwordField.setInitial();
                        PrivateKeyInputPanel.this.passwordFieldConfirm.setInitial();
                        ((PrivateKeyInputPanel)PrivateKeyInputPanel.this).buttonBar.utilChangeHandler.activateOnError();
                    }
                }
            });
            this.buttonBar.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((PrivateKeyInputPanel)PrivateKeyInputPanel.this).buttonBar.utilChangeHandler.deactivate();
                    PrivateKeyInputPanel.this.passwordField.setInitial();
                    PrivateKeyInputPanel.this.passwordFieldConfirm.setInitial();
                    PrivateKeyInputPanel.this.errorComp.clearComponents();
                }
            });
            GuiUtilElementCollection.setChangeHandler(this.buttonBar.utilChangeHandler);
            GuiUtilElementCollection.GuiElement guiElement = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_PRIVATE_KEY_PASSWORD"), 20, 180, GuiUtilPasswordFieldNew.class, 205, 240);
            guiElement.yDist = 15;
            this.passwordField = guiElement.getPasswordField();
            GuiUtilElementCollection.GuiElement guiElement2 = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_PASSWORD_CONFIRMATION"), 20, 180, GuiUtilPasswordFieldNew.class, 205, 240);
            this.passwordFieldConfirm = guiElement2.getPasswordField();
            GuiUtilElementCollection guiUtilElementCollection = new GuiUtilElementCollection();
            guiUtilElementCollection.addElement(guiElement);
            guiUtilElementCollection.addElement(guiElement2);
            guiUtilElementCollection.addToPanel(aastraPanel);
            this.errorComp.put(OmiMessage.URLType.privateKeyPassword.name(), guiElement.label, guiElement.elem);
            this.errorComp.put("pkwc", guiElement2.label, guiElement2.elem);
            this.add(aastraPanel);
            this.add(this.buttonBar);
        }

        private void activateOnError() {
            if (this.buttonBar != null && this.buttonBar.utilChangeHandler != null) {
                this.buttonBar.utilChangeHandler.activateOnError();
            }
        }
    }

    class CommonDataNotificationHandler
    implements CommonDataHandler.CommonDataNotificationInterface {
        CommonDataNotificationHandler() {
        }

        @Override
        public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
            if (commonDataItemEnum == SystemUtilCertificatePanel.this.itemCertificate) {
                CommonDataHandler.CertificateClass certificateClass = null;
                try {
                    certificateClass = (CommonDataHandler.CertificateClass)SystemUtilCertificatePanel.this.commonDataHandler.getData(SystemUtilCertificatePanel.this.itemCertificate);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + SystemUtilCertificatePanel.this.itemCertificate.toString() + ":");
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + certificateClass.nLocalCertificates + "'," + certificateClass.nPrivateKeys);
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + SystemUtilCertificatePanel.this.itemCertificate.toString() + " failed");
                    return;
                }
                if (SystemUtilCertificatePanel.this.panelCertsKey != null) {
                    SystemUtilCertificatePanel.this.panelCertsKey.setCertValues(certificateClass.nTrustedCertificates, certificateClass.nLocalCertificates, certificateClass.nPrivateKeys);
                }
                if (SystemUtilCertificatePanel.this.isEditable) {
                    ((SystemUtilCertificatePanel)SystemUtilCertificatePanel.this).panelOmmCertPassword.passwordField.setInitial();
                    ((SystemUtilCertificatePanel)SystemUtilCertificatePanel.this).panelOmmCertPassword.passwordFieldConfirm.setInitial();
                    if (SystemUtilCertificatePanel.this.ommCertsKeyChangeStarted) {
                        GuiInfoConsole.showInfo(UtilLocale.getString("TXT_CERTIFICATES_OR_PRIVATE_KEY_UPDATED_SUCCESSFULLY"));
                        SystemUtilCertificatePanel.this.ommCertsKeyChangeStarted = false;
                    }
                }
            } else if (commonDataItemEnum == SystemUtilCertificatePanel.this.itemCertificateServer && SystemUtilCertificatePanel.this.isEditable) {
                try {
                    CommonDataHandler.CertificateServer certificateServer = (CommonDataHandler.CertificateServer)SystemUtilCertificatePanel.this.commonDataHandler.getData(SystemUtilCertificatePanel.this.itemCertificateServer);
                    SystemUtilCertificatePanel.this.updateOMMCertificatePanel(certificateServer.url.enable);
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + SystemUtilCertificatePanel.this.itemCertificateServer.name() + " failed");
                }
            }
        }

        @Override
        public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
            if (commonDataItemEnum == SystemUtilCertificatePanel.this.itemCertificateServer) {
                return;
            }
            String string = SystemUtilCertificatePanel.this.parent.commonDataErrorNotificationHandler(dataNotificationEnum, commonDataItemEnum, omiMessage, SystemUtilCertificatePanel.this.utilErrorCompOmmCertificate);
            if (string != null && string.equals(OmiMessage.URLType.privateKeyPassword.name())) {
                SystemUtilCertificatePanel.this.utilErrorCompOmmCertificate.markComponent(((SystemUtilCertificatePanel)SystemUtilCertificatePanel.this).panelOmmCertPassword.passwordFieldConfirm);
            }
            if (SystemUtilCertificatePanel.this.panelOmmCertPassword != null) {
                SystemUtilCertificatePanel.this.panelOmmCertPassword.activateOnError();
            }
        }
    }
}

