/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.system;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.guiutil.GuiUtilButtonBar;
import com.aastra.oamp.guiutil.GuiUtilCheckBox;
import com.aastra.oamp.guiutil.GuiUtilComboBox;
import com.aastra.oamp.guiutil.GuiUtilPasswordFieldNew;
import com.aastra.oamp.guiutil.GuiUtilTabbedPane;
import com.aastra.oamp.guiutil.GuiUtilTextFieldFS;
import com.aastra.oamp.system.SystemUtil;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.util.UtilSpy;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SystemUtilCertificateServer
extends AastraPanel {
    private static final long serialVersionUID = 1L;
    private static final int xPosFieldsCertServer = 250;
    private CommonDataHandler.CommonDataItemEnum commonDataItemEnum = null;
    private CommonDataHandler commonDataHandler = null;
    private GuiUtilTabbedPane guiUtilTabbedPane = null;
    private boolean isEditable = true;
    private boolean trustedCert = true;
    private GuiUtilButtonBar buttonBar = null;
    private UtilErrorComp utilErrorComp = null;
    private SystemUtil.ToolsSystem toolsSystem = null;
    private AastraPanel panelCertificateServer = null;
    private GuiUtilCheckBox checkBoxUrlActive = null;
    private GuiUtilComboBox comboBoxUrlProtocol = null;
    private GuiUtilTextFieldFS textFieldUrlHost = null;
    private GuiUtilTextFieldFS textFieldUrlPort = null;
    private GuiUtilCheckBox checkBoxUrlDefaultPort = null;
    private GuiUtilTextFieldFS textFieldUrlUserName = null;
    private GuiUtilPasswordFieldNew passwordFieldUrlPassword = null;
    private GuiUtilPasswordFieldNew passwordFieldUrlPasswordConfirm = null;
    private GuiUtilCheckBox checkBoxUrlCommonCerts = null;
    private GuiUtilTextFieldFS textFieldUrlPath = null;
    private GuiUtilTextFieldFS textFieldFileTrustedCert = null;
    private GuiUtilTextFieldFS textFieldFileLocalCert = null;
    private GuiUtilTextFieldFS textFieldFilePrivateKey = null;

    public SystemUtilCertificateServer(CommonDataHandler.CommonDataItemEnum commonDataItemEnum, CommonDataHandler commonDataHandler, GuiUtilTabbedPane guiUtilTabbedPane, boolean bl) {
        this.commonDataItemEnum = commonDataItemEnum;
        this.commonDataHandler = commonDataHandler;
        this.guiUtilTabbedPane = guiUtilTabbedPane;
        this.isEditable = bl;
        this.initialize();
    }

    public SystemUtilCertificateServer(CommonDataHandler.CommonDataItemEnum commonDataItemEnum, CommonDataHandler commonDataHandler, GuiUtilTabbedPane guiUtilTabbedPane, boolean bl, boolean bl2) {
        this.commonDataItemEnum = commonDataItemEnum;
        this.commonDataHandler = commonDataHandler;
        this.guiUtilTabbedPane = guiUtilTabbedPane;
        this.isEditable = bl;
        this.trustedCert = bl2;
        this.initialize();
    }

    private void initialize() {
        this.commonDataHandler.registerDataNotificationListener(this.commonDataItemEnum, new CommonDataNotificationHandlerCertServer());
        if (this.isEditable) {
            this.utilErrorComp = new UtilErrorComp();
            this.toolsSystem = new SystemUtil.ToolsSystemSettings(this.utilErrorComp);
        }
        this.setLayout(new BoxLayout(this, 1));
        this.getButtonBar();
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(this.getPanelCertificateServer());
        if (this.isEditable) {
            this.add(Box.createRigidArea(new Dimension(0, 15)));
            this.add(this.buttonBar);
        }
    }

    private AastraPanel getPanelCertificateServer() {
        if (this.panelCertificateServer == null) {
            this.panelCertificateServer = new AastraPanel();
            this.panelCertificateServer.setLayout(null);
            this.panelCertificateServer.setAlignmentX(0.0f);
            Dimension dimension = new Dimension(780, 380);
            this.panelCertificateServer.setPreferredSize(dimension);
            this.panelCertificateServer.setMaximumSize(dimension);
            this.panelCertificateServer.setMinimumSize(dimension);
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setText(UtilLocale.getString("TXT_ACTIVE"));
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setText(UtilLocale.getString("TXT_PROTOCOL"));
            AastraLabel aastraLabel3 = new AastraLabel();
            aastraLabel3.setText(UtilLocale.getString("TXT_SERVER"));
            AastraLabel aastraLabel4 = new AastraLabel();
            AastraLabel aastraLabel5 = new AastraLabel();
            aastraLabel5.setText(UtilLocale.getString("TXT_PORT"));
            AastraLabel aastraLabel6 = new AastraLabel();
            aastraLabel6.setText(UtilLocale.getString("TXT_USE_DEFAULT_PORT"));
            aastraLabel4.setText(UtilLocale.getString("TXT_USER_NAME"));
            AastraLabel aastraLabel7 = new AastraLabel();
            aastraLabel7.setText(UtilLocale.getString("TXT_PASSWORD"));
            AastraLabel aastraLabel8 = new AastraLabel();
            aastraLabel8.setText(UtilLocale.getString("TXT_PASSWORD_CONFIRMATION"));
            AastraLabel aastraLabel9 = new AastraLabel();
            aastraLabel9.setText(UtilLocale.getString("TXT_PATH_WITHOUT_FILE_NAME"));
            AastraLabel aastraLabel10 = new AastraLabel();
            aastraLabel10.setText("<html>" + UtilLocale.getString("TXT_USE_COMMON_CERTIFICATES") + "</html>");
            AastraLabel aastraLabel11 = null;
            if (this.trustedCert) {
                aastraLabel11 = new AastraLabel();
                aastraLabel11.setText(UtilLocale.getString("TXT_TRUSTED_CERTIFICATES_FILE"));
            }
            AastraLabel aastraLabel12 = new AastraLabel();
            aastraLabel12.setText(UtilLocale.getString("TXT_LOCAL_CERTIFICATE_CHAIN_FILE"));
            AastraLabel aastraLabel13 = new AastraLabel();
            aastraLabel13.setText(UtilLocale.getString("TXT_PRIVATE_KEY_FILE"));
            aastraLabel.setBounds(20, 10, 220, 16);
            aastraLabel2.setBounds(20, 40, 220, 16);
            aastraLabel3.setBounds(20, 70, 220, 16);
            aastraLabel5.setBounds(20, 100, 220, 16);
            aastraLabel6.setHorizontalAlignment(4);
            aastraLabel6.setBounds(320, 100, 200, 16);
            aastraLabel4.setBounds(20, 130, 220, 16);
            aastraLabel7.setBounds(20, 160, 220, 16);
            aastraLabel8.setBounds(20, 190, 220, 16);
            aastraLabel9.setBounds(20, 220, 220, 16);
            aastraLabel10.setBounds(20, 250, 220, 16);
            int n = 280;
            if (this.trustedCert) {
                aastraLabel11.setBounds(20, n, 220, 16);
                n += 30;
            }
            aastraLabel12.setBounds(20, n, 220, 16);
            aastraLabel13.setBounds(20, n += 30, 220, 16);
            this.panelCertificateServer.add(aastraLabel);
            this.panelCertificateServer.add(this.getCheckBoxUrlActive());
            this.panelCertificateServer.add(aastraLabel2);
            this.panelCertificateServer.add(this.getComboBoxUrlProtocol());
            this.panelCertificateServer.add(aastraLabel3);
            this.panelCertificateServer.add(this.getTextFieldUrlHost());
            this.panelCertificateServer.add(aastraLabel5);
            this.panelCertificateServer.add(this.getTextFieldUrlPort());
            this.panelCertificateServer.add(aastraLabel6);
            this.panelCertificateServer.add(this.getCheckBoxUrlDefaultPort());
            this.panelCertificateServer.add(aastraLabel4);
            this.panelCertificateServer.add(this.getTextFieldUrlUserName());
            this.panelCertificateServer.add(aastraLabel7);
            this.panelCertificateServer.add(this.getPasswordFieldUrlPassword());
            this.panelCertificateServer.add(aastraLabel8);
            this.panelCertificateServer.add(this.getPasswordFieldUrlPasswordConfirm());
            this.panelCertificateServer.add(aastraLabel9);
            this.panelCertificateServer.add(this.getTextFieldUrlPath());
            this.panelCertificateServer.add(aastraLabel10);
            this.panelCertificateServer.add(this.getCheckBoxUrlCommonCerts());
            n = 280;
            if (this.trustedCert) {
                this.panelCertificateServer.add(aastraLabel11);
                this.panelCertificateServer.add(this.getTextFieldFileTrustedCert(n));
                n += 30;
            }
            this.panelCertificateServer.add(aastraLabel12);
            this.panelCertificateServer.add(this.getTextFieldFileLocalCert(n));
            this.panelCertificateServer.add(aastraLabel13);
            this.panelCertificateServer.add(this.getTextFieldFilePrivateKey(n += 30));
            if (this.isEditable) {
                this.utilErrorComp.put(OmiMessage.URLType.host.name(), aastraLabel3, this.textFieldUrlHost, this.buttonBar);
                this.utilErrorComp.put(OmiMessage.URLType.port.name(), aastraLabel5, this.textFieldUrlPort, this.buttonBar);
                this.utilErrorComp.put(OmiMessage.URLType.username.name(), aastraLabel4, this.textFieldUrlUserName, this.buttonBar);
                this.utilErrorComp.put(OmiMessage.URLType.password.name(), aastraLabel7, this.passwordFieldUrlPassword, this.buttonBar);
                this.utilErrorComp.put(OmiMessage.URLType.path.name(), aastraLabel9, this.textFieldUrlPath, this.buttonBar);
                if (this.trustedCert) {
                    this.utilErrorComp.put(OmiMessage.attribIds.trustedCertificates.name(), aastraLabel11, this.textFieldFileTrustedCert, this.buttonBar);
                }
                this.utilErrorComp.put(OmiMessage.attribIds.localCertificates.name(), aastraLabel12, this.textFieldFileLocalCert, this.buttonBar);
                this.utilErrorComp.put(OmiMessage.attribIds.privateKeys.name(), aastraLabel13, this.textFieldFilePrivateKey, this.buttonBar);
            } else {
                UtilSetPanelEditable.setDisabled(this.panelCertificateServer);
            }
        }
        return this.panelCertificateServer;
    }

    private GuiUtilCheckBox getCheckBoxUrlActive() {
        if (this.checkBoxUrlActive == null) {
            this.checkBoxUrlActive = new GuiUtilCheckBox(this.buttonBar.utilChangeHandler, 245, 10);
            if (this.isEditable) {
                this.checkBoxUrlActive.setToolTipText(UtilLocale.getString("TXT_CERTIFICATE_SERVER_ACTIVE_HELP"));
            }
        }
        return this.checkBoxUrlActive;
    }

    private GuiUtilComboBox getComboBoxUrlProtocol() {
        if (this.comboBoxUrlProtocol == null) {
            this.comboBoxUrlProtocol = new GuiUtilComboBox(this.buttonBar.utilChangeHandler);
            this.comboBoxUrlProtocol.setBounds(250, 40, 80, 20);
            for (int i = 0; i < OmiMessage.ProtType.getValidProtTypeNumber(); ++i) {
                this.comboBoxUrlProtocol.addItem(OmiMessage.ProtType.getValidProtTypes()[i]);
            }
            if (this.isEditable) {
                this.comboBoxUrlProtocol.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SystemUtilCertificateServer.this.comboBoxUrlProtocol.getSelectedItem() == OmiMessage.ProtType.TFTP) {
                            SystemUtilCertificateServer.this.textFieldUrlUserName.setEditable(false);
                            SystemUtilCertificateServer.this.passwordFieldUrlPassword.setEditable(false);
                            SystemUtilCertificateServer.this.passwordFieldUrlPasswordConfirm.setEditable(false);
                        } else {
                            SystemUtilCertificateServer.this.textFieldUrlUserName.setEditable(true);
                            SystemUtilCertificateServer.this.passwordFieldUrlPassword.setEditable(true);
                            SystemUtilCertificateServer.this.passwordFieldUrlPasswordConfirm.setEditable(true);
                        }
                    }
                });
                this.comboBoxUrlProtocol.activateActionListener();
            }
        }
        return this.comboBoxUrlProtocol;
    }

    private GuiUtilTextFieldFS getTextFieldUrlHost() {
        if (this.textFieldUrlHost == null) {
            this.textFieldUrlHost = new GuiUtilTextFieldFS(250, 70, AastraCommon.TextFieldSizeType.l, this.buttonBar.utilChangeHandler);
        }
        return this.textFieldUrlHost;
    }

    private GuiUtilTextFieldFS getTextFieldUrlPort() {
        if (this.textFieldUrlPort == null) {
            this.textFieldUrlPort = new GuiUtilTextFieldFS(250, 100, AastraCommon.TextFieldSizeType.xs, this.buttonBar.utilChangeHandler);
        }
        return this.textFieldUrlPort;
    }

    private GuiUtilCheckBox getCheckBoxUrlDefaultPort() {
        if (this.checkBoxUrlDefaultPort == null) {
            this.checkBoxUrlDefaultPort = new GuiUtilCheckBox(this.buttonBar.utilChangeHandler, 530, 100);
            if (this.isEditable) {
                this.checkBoxUrlDefaultPort.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        if (SystemUtilCertificateServer.this.checkBoxUrlDefaultPort.isSelected()) {
                            SystemUtilCertificateServer.this.textFieldUrlPort.setText("");
                            SystemUtilCertificateServer.this.textFieldUrlPort.setEnabled(false);
                        } else {
                            SystemUtilCertificateServer.this.textFieldUrlPort.setEnabled(true);
                        }
                    }
                });
            }
        }
        return this.checkBoxUrlDefaultPort;
    }

    private GuiUtilTextFieldFS getTextFieldUrlUserName() {
        if (this.textFieldUrlUserName == null) {
            this.textFieldUrlUserName = new GuiUtilTextFieldFS(250, 130, AastraCommon.TextFieldSizeType.l, this.buttonBar.utilChangeHandler);
        }
        return this.textFieldUrlUserName;
    }

    private GuiUtilPasswordFieldNew getPasswordFieldUrlPassword() {
        if (this.passwordFieldUrlPassword == null) {
            this.passwordFieldUrlPassword = new GuiUtilPasswordFieldNew(this.buttonBar.utilChangeHandler);
            this.passwordFieldUrlPassword.setBounds(250, 160, AastraCommon.TextFieldSizeType.l.width, 18);
            this.passwordFieldUrlPassword.setEditable(false);
        }
        return this.passwordFieldUrlPassword;
    }

    private GuiUtilPasswordFieldNew getPasswordFieldUrlPasswordConfirm() {
        if (this.passwordFieldUrlPasswordConfirm == null) {
            this.passwordFieldUrlPasswordConfirm = new GuiUtilPasswordFieldNew(this.buttonBar.utilChangeHandler);
            this.passwordFieldUrlPasswordConfirm.setBounds(250, 190, AastraCommon.TextFieldSizeType.l.width, 18);
            this.passwordFieldUrlPasswordConfirm.setEditable(false);
        }
        return this.passwordFieldUrlPasswordConfirm;
    }

    private GuiUtilTextFieldFS getTextFieldUrlPath() {
        if (this.textFieldUrlPath == null) {
            this.textFieldUrlPath = new GuiUtilTextFieldFS(250, 220, AastraCommon.TextFieldSizeType.xxl, this.buttonBar.utilChangeHandler);
        }
        return this.textFieldUrlPath;
    }

    private GuiUtilCheckBox getCheckBoxUrlCommonCerts() {
        if (this.checkBoxUrlCommonCerts == null) {
            this.checkBoxUrlCommonCerts = new GuiUtilCheckBox(this.buttonBar.utilChangeHandler, 245, 250);
        }
        return this.checkBoxUrlCommonCerts;
    }

    private GuiUtilTextFieldFS getTextFieldFileTrustedCert(int n) {
        if (this.textFieldFileTrustedCert == null) {
            this.textFieldFileTrustedCert = new GuiUtilTextFieldFS(250, n, AastraCommon.TextFieldSizeType.xxl, this.buttonBar.utilChangeHandler);
        }
        return this.textFieldFileTrustedCert;
    }

    private GuiUtilTextFieldFS getTextFieldFileLocalCert(int n) {
        if (this.textFieldFileLocalCert == null) {
            this.textFieldFileLocalCert = new GuiUtilTextFieldFS(250, n, AastraCommon.TextFieldSizeType.xxl, this.buttonBar.utilChangeHandler);
        }
        return this.textFieldFileLocalCert;
    }

    private GuiUtilTextFieldFS getTextFieldFilePrivateKey(int n) {
        if (this.textFieldFilePrivateKey == null) {
            this.textFieldFilePrivateKey = new GuiUtilTextFieldFS(250, n, AastraCommon.TextFieldSizeType.xxl, this.buttonBar.utilChangeHandler);
        }
        return this.textFieldFilePrivateKey;
    }

    private void setData(CommonDataHandler.CertificateServer certificateServer) {
        this.getCheckBoxUrlActive().setSelected(certificateServer.url.enable);
        this.getComboBoxUrlProtocol().deactivateActionListener();
        this.getComboBoxUrlProtocol().setSelectedItem((Object)certificateServer.url.protocol);
        this.getComboBoxUrlProtocol().activateActionListener();
        this.getTextFieldUrlHost().setText(certificateServer.url.host);
        if (certificateServer.url.port == null || certificateServer.url.port == 0) {
            this.checkBoxUrlDefaultPort.setSelected(true);
            this.textFieldUrlPort.setText("");
        } else {
            this.checkBoxUrlDefaultPort.setSelected(false);
            this.textFieldUrlPort.setText(String.valueOf(certificateServer.url.port));
        }
        this.getTextFieldUrlUserName().setText(certificateServer.url.username);
        this.getPasswordFieldUrlPassword().setInitial();
        this.getPasswordFieldUrlPasswordConfirm().setInitial();
        this.getTextFieldUrlPath().setText(certificateServer.url.path);
        if (certificateServer.url.useCommonCerts != null) {
            this.getCheckBoxUrlCommonCerts().setSelected(certificateServer.url.useCommonCerts);
        } else {
            this.getCheckBoxUrlCommonCerts().setSelected(false);
        }
        if (this.trustedCert && this.textFieldFileTrustedCert != null) {
            this.textFieldFileTrustedCert.setText(certificateServer.trustedCertsFileName);
        }
        if (this.textFieldFileLocalCert != null) {
            this.textFieldFileLocalCert.setText(certificateServer.localCertsFileName);
        }
        if (this.textFieldFilePrivateKey != null) {
            this.textFieldFilePrivateKey.setText(certificateServer.privateKeyFileName);
        }
    }

    private boolean getData(CommonDataHandler.CertificateServer certificateServer) {
        boolean bl = true;
        certificateServer.url.enable = this.checkBoxUrlActive.isSelected();
        certificateServer.url.protocol = (OmiMessage.ProtType)((Object)this.comboBoxUrlProtocol.getSelectedItem());
        certificateServer.url.host = this.textFieldUrlHost.getText();
        if (this.checkBoxUrlDefaultPort.isSelected()) {
            certificateServer.url.port = 0;
        } else {
            certificateServer.url.port = this.toolsSystem.getUnsignedDecimalIntFromTextField(this.textFieldUrlPort, UtilLocale.getString("TXT_PORT"));
            if (certificateServer.url.port == -1) {
                bl = false;
            }
        }
        certificateServer.url.username = this.textFieldUrlUserName.isEditable() ? this.textFieldUrlUserName.getText() : "";
        if (this.passwordFieldUrlPassword.isEditable()) {
            String string = new String(this.passwordFieldUrlPassword.getPassword());
            String string2 = new String(this.passwordFieldUrlPasswordConfirm.getPassword());
            if (this.passwordFieldUrlPassword.isChanged() || this.passwordFieldUrlPasswordConfirm.isChanged()) {
                if (string.equals(string2)) {
                    certificateServer.url.password = string;
                    certificateServer.url.passwordChanged = true;
                } else {
                    GuiInfoConsole.showError(UtilLocale.getString("TXT_PASSWORD_CONFIRMATION_FAILED"));
                    this.utilErrorComp.markComponent(this.passwordFieldUrlPassword);
                    this.utilErrorComp.markComponent(this.passwordFieldUrlPasswordConfirm);
                    this.passwordFieldUrlPassword.setInitial();
                    this.passwordFieldUrlPasswordConfirm.setInitial();
                    bl = false;
                }
            }
        }
        certificateServer.url.path = this.textFieldUrlPath.getText();
        certificateServer.url.useCommonCerts = this.checkBoxUrlCommonCerts.isSelected();
        if (this.trustedCert) {
            if (certificateServer.url.enable.booleanValue() && this.textFieldFileTrustedCert.getText().isEmpty() && this.textFieldFileLocalCert.getText().isEmpty() && this.textFieldFilePrivateKey.getText().isEmpty()) {
                GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_ALL_FILE_NAMES_EMPTY"), new Object[0]));
                this.utilErrorComp.markComponent(this.textFieldFileTrustedCert);
                this.utilErrorComp.markComponent(this.textFieldFileLocalCert);
                this.utilErrorComp.markComponent(this.textFieldFilePrivateKey);
                bl = false;
            } else {
                certificateServer.trustedCertsFileName = this.textFieldFileTrustedCert.getText();
                certificateServer.localCertsFileName = this.textFieldFileLocalCert.getText();
                certificateServer.privateKeyFileName = this.textFieldFilePrivateKey.getText();
            }
        } else if (certificateServer.url.enable.booleanValue() && this.textFieldFileLocalCert.getText().isEmpty() && this.textFieldFilePrivateKey.getText().isEmpty()) {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_ALL_FILE_NAMES_EMPTY"), new Object[0]));
            this.utilErrorComp.markComponent(this.textFieldFileLocalCert);
            this.utilErrorComp.markComponent(this.textFieldFilePrivateKey);
            bl = false;
        } else {
            certificateServer.localCertsFileName = this.textFieldFileLocalCert.getText();
            certificateServer.privateKeyFileName = this.textFieldFilePrivateKey.getText();
        }
        return bl;
    }

    private GuiUtilButtonBar getButtonBar() {
        if (this.buttonBar == null) {
            this.buttonBar = new GuiUtilButtonBar(800, this.guiUtilTabbedPane);
            this.buttonBar.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SystemUtilCertificateServer)SystemUtilCertificateServer.this).buttonBar.utilChangeHandler.deactivate();
                    SystemUtilCertificateServer.this.utilErrorComp.clearComponents();
                    SystemUtilCertificateServer.this.changeCertsServer();
                }
            });
            this.buttonBar.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SystemUtilCertificateServer)SystemUtilCertificateServer.this).buttonBar.utilChangeHandler.deactivate();
                    SystemUtilCertificateServer.this.utilErrorComp.clearComponents();
                    SystemUtilCertificateServer.this.commonDataHandler.sendGetReq(SystemUtilCertificateServer.this.commonDataItemEnum);
                }
            });
        }
        return this.buttonBar;
    }

    private void changeCertsServer() {
        CommonDataHandler.CertificateServer certificateServer = new CommonDataHandler.CertificateServer();
        boolean bl = this.getData(certificateServer);
        if (bl) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + (Object)((Object)this.commonDataItemEnum));
            this.commonDataHandler.setData(this.commonDataItemEnum, certificateServer);
            this.commonDataHandler.commitChangesToOmm(this.commonDataItemEnum);
        } else {
            this.buttonBar.utilChangeHandler.activateOnError();
        }
    }

    private class CommonDataNotificationHandlerCertServer
    implements CommonDataHandler.CommonDataNotificationInterface {
        private CommonDataNotificationHandlerCertServer() {
        }

        @Override
        public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
            if (commonDataItemEnum == SystemUtilCertificateServer.this.commonDataItemEnum) {
                try {
                    CommonDataHandler.CertificateServer certificateServer = (CommonDataHandler.CertificateServer)SystemUtilCertificateServer.this.commonDataHandler.getData(SystemUtilCertificateServer.this.commonDataItemEnum);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + SystemUtilCertificateServer.this.commonDataItemEnum.name());
                    SystemUtilCertificateServer.this.setData(certificateServer);
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + SystemUtilCertificateServer.this.commonDataItemEnum.name() + " failed");
                }
            } else {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Received " + commonDataItemEnum.name() + " not handled here");
            }
        }

        @Override
        public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
            String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
            String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
            String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
            OmiMessage.errorCodes errorCodes2 = null;
            JComponent jComponent = null;
            if (!SystemUtilCertificateServer.this.isEditable || string == null) {
                return;
            }
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data error notification: " + dataNotificationEnum.toString() + ",item=" + String.valueOf((Object)commonDataItemEnum) + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
            try {
                errorCodes2 = OmiMessage.errorCodes.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                errorCodes2 = null;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data error notification: Unknown errorCode=" + string);
            }
            if (errorCodes2 != null) {
                String string4 = null;
                if (string2 != null) {
                    string4 = SystemUtilCertificateServer.this.utilErrorComp.getLabelText(string2);
                }
                GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, string4, string3));
            } else {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
            }
            if (string2 != null && (jComponent = SystemUtilCertificateServer.this.utilErrorComp.getField(string2)) != null) {
                SystemUtilCertificateServer.this.utilErrorComp.markComponent(jComponent);
                ((SystemUtilCertificateServer)SystemUtilCertificateServer.this).buttonBar.utilChangeHandler.activateOnError();
            }
        }
    }
}

