/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.system;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.guiutil.GuiUtilBorderPanel;
import com.aastra.oamp.guiutil.GuiUtilButtonBar;
import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilPasswordFieldNew;
import com.aastra.oamp.guiutil.GuiUtilTabbedPane;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.system.SystemCertificateNumberPanel;
import com.aastra.oamp.system.SystemPemFileImportPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.util.UtilSpy;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;

public class SystemUtilSupplicantPanel
extends AastraPanel
implements GuiUtilChangeHandler.GuiUtilChangeHandlerActivatedInterface {
    private static final long serialVersionUID = 1L;
    private static final int panelWidth = 800;
    private static final int tabbedPaneWidth = 800;
    private static final int panelRigidAreaHight = 5;
    private CommonDataHandler commonDataHandler = null;
    private boolean isEditable = false;
    private GuiUtilTabbedPane tabbedPaneSysSet = null;
    private GuiUtilBorderPanel panelGeneral = null;
    private GuiUtilTextField textFieldIdentity = null;
    private SystemCertificateNumberPanel panelCertsKey = null;
    private SystemPemFileImportPanel panelCertImport = null;
    private boolean certsKeyChangeStarted = false;
    private GuiUtilBorderPanel panelCertPassword = null;
    private UtilErrorComp utilErrorCompCertificate = null;
    private Boolean isSupplicantEditable = null;
    private Boolean isCertServerEnabled = null;
    private AastraLabel labelPassword = null;
    private GuiUtilPasswordFieldNew pwFieldPassword = null;
    private AastraLabel labelPasswordConfirm = null;
    private GuiUtilPasswordFieldNew pwFieldPasswordConfirm = null;
    private GuiUtilButtonBar panelSupplicantButtonBar = null;
    CommonDataNotificationHandler handler = new CommonDataNotificationHandler();

    public SystemUtilSupplicantPanel(CommonDataHandler commonDataHandler, GuiUtilTabbedPane guiUtilTabbedPane, boolean bl) {
        this.commonDataHandler = commonDataHandler;
        this.tabbedPaneSysSet = guiUtilTabbedPane;
        this.isEditable = bl;
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.SupplicantCertificate, this.handler);
        if (this.isEditable) {
            this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.Supplicant, this.handler);
            this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.SupplicantCertificateServer, this.handler);
        }
        this.setLayout(new BoxLayout(this, 1));
        this.getPanelSupplicantButtonBar();
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(this.getPanelCertsKey());
        if (this.isEditable) {
            this.utilErrorCompCertificate = new UtilErrorComp();
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            this.add(this.getPanelCertImport());
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            this.add(this.getPanelCertPassword());
        }
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(this.getPanelSettingGenerals());
        if (this.isEditable) {
            this.add(this.panelSupplicantButtonBar);
        }
    }

    private SystemCertificateNumberPanel getPanelCertsKey() {
        if (this.panelCertsKey == null) {
            this.panelCertsKey = new SystemCertificateNumberPanel(800, this.isEditable);
            if (this.isEditable) {
                this.panelCertsKey.buttonSecurityDelete.setToolTipText(UtilLocale.getString("TXT_DELETE_CERTIFICATES_HELP"));
                this.panelCertsKey.buttonSecurityDelete.setEnabled(false);
                this.panelCertsKey.buttonSecurityDelete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        GuiUtilDialog guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_DELETE_CERTIFICATES_AND_PRIVATE_KEY_?"), true);
                        if (guiUtilDialog.getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
                            SystemUtilSupplicantPanel.this.certsKeyChangeStarted = true;
                            SystemUtilSupplicantPanel.this.commonDataHandler.deleteSupplicantCertificates();
                        }
                    }
                });
            }
        }
        return this.panelCertsKey;
    }

    private SystemPemFileImportPanel getPanelCertImport() {
        if (this.panelCertImport == null) {
            class PemFileDataHandler
            implements SystemPemFileImportPanel.PemFileStringHandlerInterface {
                CommonDataHandler.CertificateClass certificate = null;

                PemFileDataHandler() {
                }

                @Override
                public void certInit() {
                    this.certificate = null;
                }

                @Override
                public void addCertifcate(OmiMessage.PEMCertificateListType pEMCertificateListType, String string) {
                    if (this.certificate == null) {
                        this.certificate = new CommonDataHandler.CertificateClass();
                    }
                    switch (pEMCertificateListType) {
                        case trustedCertificates: {
                            this.certificate.trustedCertificates.add(string);
                            break;
                        }
                        case localCertificates: {
                            this.certificate.localCertificates.add(string);
                            break;
                        }
                        case privateKey: {
                            this.certificate.privateKey = string;
                        }
                    }
                }

                @Override
                public void sendCertificates() {
                    if (this.certificate != null) {
                        SystemUtilSupplicantPanel.this.certsKeyChangeStarted = true;
                        SystemUtilSupplicantPanel.this.setAndCommit(this.certificate);
                    }
                }
            }
            this.panelCertImport = new SystemPemFileImportPanel(800, new PemFileDataHandler(), UtilLocale.getString("TXT_802_1X_CERTIFICATE_SERVER"));
        }
        return this.panelCertImport;
    }

    private AastraPanel getPanelCertPassword() {
        if (this.panelCertPassword == null) {
            this.panelCertPassword = new GuiUtilBorderPanel(100, UtilLocale.getString("TXT_PRIVATE_KEY_PASSWORD"));
            this.panelCertPassword.setLayout(null);
            this.panelCertPassword.setAlignmentX(0.0f);
            this.labelPassword = new AastraLabel();
            this.labelPassword.setBounds(30, 25, 150, 20);
            this.labelPassword.setText(UtilLocale.getString("TXT_PASSWORD"));
            this.labelPasswordConfirm = new AastraLabel();
            this.labelPasswordConfirm.setTextHtml(UtilLocale.getString("TXT_PASSWORD_CONFIRMATION"));
            this.labelPasswordConfirm.setBounds(30, 55, 150, 36);
            this.panelCertPassword.add(this.labelPassword);
            this.panelCertPassword.add(this.getPasswordFieldPassword());
            this.panelCertPassword.add(this.labelPasswordConfirm);
            this.panelCertPassword.add(this.getPasswordFieldPasswordConfirm());
            this.utilErrorCompCertificate.put(OmiMessage.URLType.privateKeyPassword.name(), this.labelPassword, this.pwFieldPassword);
            this.utilErrorCompCertificate.put(OmiMessage.URLType.privateKeyPassword.name(), this.labelPasswordConfirm, this.pwFieldPasswordConfirm);
        }
        return this.panelCertPassword;
    }

    private GuiUtilPasswordFieldNew getPasswordFieldPassword() {
        if (this.pwFieldPassword == null) {
            this.pwFieldPassword = new GuiUtilPasswordFieldNew(this.panelSupplicantButtonBar.utilChangeHandler);
            this.pwFieldPassword.setBounds(210, 25, 240, 18);
        }
        return this.pwFieldPassword;
    }

    private GuiUtilPasswordFieldNew getPasswordFieldPasswordConfirm() {
        if (this.pwFieldPasswordConfirm == null) {
            this.pwFieldPasswordConfirm = new GuiUtilPasswordFieldNew(this.panelSupplicantButtonBar.utilChangeHandler);
            this.pwFieldPasswordConfirm.setBounds(210, 55, 240, 18);
        }
        return this.pwFieldPasswordConfirm;
    }

    private AastraPanel getPanelSettingGenerals() {
        if (this.panelGeneral == null) {
            this.panelGeneral = new GuiUtilBorderPanel(60, UtilLocale.getString("TXT_GENERAL"));
            this.panelGeneral.setLayout(null);
            this.panelGeneral.setAlignmentX(0.0f);
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(30, 25, 200, 31);
            aastraLabel.setText(UtilLocale.getString("TXT_CLIENT_IDENTITY"));
            this.panelGeneral.add(aastraLabel);
            this.panelGeneral.add(this.getTextFieldIdentity());
            if (this.isEditable) {
                this.utilErrorCompCertificate.put(OmiMessage.CertificateType.identity.name(), aastraLabel, this.textFieldIdentity);
            } else {
                UtilSetPanelEditable.setDisabled(this.panelGeneral);
            }
        }
        return this.panelGeneral;
    }

    private GuiUtilTextField getTextFieldIdentity() {
        if (this.textFieldIdentity == null) {
            this.textFieldIdentity = new GuiUtilTextField(this.panelSupplicantButtonBar.utilChangeHandler);
            this.textFieldIdentity.setBounds(210, 25, 240, 18);
        }
        return this.textFieldIdentity;
    }

    protected GuiUtilButtonBar getPanelSupplicantButtonBar() {
        if (this.panelSupplicantButtonBar == null) {
            this.panelSupplicantButtonBar = new GuiUtilButtonBar(800, this.tabbedPaneSysSet, UtilLocale.getString("TXT_START_EDIT"));
            this.panelSupplicantButtonBar.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SystemUtilSupplicantPanel)SystemUtilSupplicantPanel.this).panelSupplicantButtonBar.utilChangeHandler.deactivate();
                    SystemUtilSupplicantPanel.this.utilErrorCompCertificate.clearComponents();
                    SystemUtilSupplicantPanel.this.changeSupplicantSettings();
                }
            });
            this.panelSupplicantButtonBar.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SystemUtilSupplicantPanel)SystemUtilSupplicantPanel.this).panelSupplicantButtonBar.utilChangeHandler.deactivate();
                    SystemUtilSupplicantPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.SupplicantCertificate);
                    SystemUtilSupplicantPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.SupplicantCertificateServer);
                    SystemUtilSupplicantPanel.this.utilErrorCompCertificate.clearComponents();
                }
            });
            this.panelSupplicantButtonBar.buttonOptional.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SystemUtilSupplicantPanel.this.isSupplicantEditable != null) {
                        SystemUtilSupplicantPanel.this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.Supplicant, SystemUtilSupplicantPanel.this.isSupplicantEditable == false);
                        SystemUtilSupplicantPanel.this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.Supplicant);
                    }
                }
            });
            this.panelSupplicantButtonBar.utilChangeHandler.registerActivatedListener(this);
            this.panelSupplicantButtonBar.buttonOptional.setEnabled(true);
            this.panelSupplicantButtonBar.buttonOptional.setToolTipText("<html>" + UtilLocale.getString("TXT_START_EDIT_HELP") + "</html>");
        }
        return this.panelSupplicantButtonBar;
    }

    private void changeSupplicantSettings() {
        CommonDataHandler.CertificateClass certificateClass = new CommonDataHandler.CertificateClass();
        if (this.pwFieldPassword.isChanged() || this.pwFieldPasswordConfirm.isChanged()) {
            String string = new String(this.pwFieldPassword.getPassword());
            String string2 = new String(this.pwFieldPasswordConfirm.getPassword());
            if (this.pwFieldPassword.isChanged() && this.pwFieldPasswordConfirm.isChanged() && string.equals(string2)) {
                certificateClass.privateKeyPassword = string;
            } else {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_PASSWORD_CONFIRMATION_FAILED"));
                this.utilErrorCompCertificate.markComponent(this.pwFieldPassword);
                this.utilErrorCompCertificate.markComponent(this.pwFieldPasswordConfirm);
                this.pwFieldPassword.setInitial();
                this.pwFieldPasswordConfirm.setInitial();
                this.activateOnError();
                return;
            }
        }
        certificateClass.identity = this.textFieldIdentity.getText();
        this.setAndCommit(certificateClass);
    }

    private void setAndCommit(CommonDataHandler.CertificateClass certificateClass) {
        this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.SupplicantCertificate, certificateClass);
        this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.SupplicantCertificate);
    }

    private void configureButtonOptional() {
        if (this.panelSupplicantButtonBar.buttonOptional != null) {
            if (this.isSupplicantEditable.booleanValue()) {
                this.panelSupplicantButtonBar.buttonOptional.setText(UtilLocale.getString("TXT_STOP_EDIT"));
                this.panelSupplicantButtonBar.buttonOptional.setToolTipText("<html>" + UtilLocale.getString("TXT_STOP_EDIT_HELP") + "</html>");
            } else {
                this.panelSupplicantButtonBar.buttonOptional.setText(UtilLocale.getString("TXT_START_EDIT"));
                this.panelSupplicantButtonBar.buttonOptional.setToolTipText("<html>" + UtilLocale.getString("TXT_START_EDIT_HELP") + "</html>");
            }
        }
    }

    private void updateCertificatePanel() {
        if (this.isSupplicantEditable != null && this.isCertServerEnabled != null) {
            if (this.isSupplicantEditable.booleanValue()) {
                this.panelCertsKey.buttonSecurityDelete.setEnabled(this.isCertServerEnabled == false);
                if (this.panelCertImport != null) {
                    this.panelCertImport.setActive(this.isCertServerEnabled == false, this.isCertServerEnabled);
                }
            } else {
                this.panelCertsKey.buttonSecurityDelete.setEnabled(false);
                if (this.panelCertImport != null) {
                    this.panelCertImport.setActive(false, this.isCertServerEnabled);
                }
            }
            this.pwFieldPassword.setEditable(this.isSupplicantEditable);
            this.pwFieldPasswordConfirm.setEditable(this.isSupplicantEditable);
            this.textFieldIdentity.setEditable(this.isSupplicantEditable);
        }
    }

    private String commonDataErrorNotificationHandler(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage, UtilErrorComp utilErrorComp) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        String string4 = omiMessage.getAttribVal(OmiMessage.attribIds.info.name());
        OmiMessage.errorCodes errorCodes2 = null;
        if (!this.isEditable || string == null) {
            return null;
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data error notification: " + dataNotificationEnum.toString() + ",item=" + String.valueOf((Object)commonDataItemEnum) + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        if (string4 != null) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "   info=" + string4);
        }
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data error notification: Unknown errorCode=" + string);
        }
        String string5 = null;
        if (string2 != null) {
            string5 = utilErrorComp.getLabelText(string2);
        }
        if (errorCodes2 != null) {
            GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, string5, string3));
        } else {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
        }
        JComponent jComponent = null;
        if (string2 != null) {
            jComponent = utilErrorComp.getField(string2);
            if (jComponent != null) {
                utilErrorComp.markComponent(jComponent);
            }
            this.activateOnError();
        }
        return string2;
    }

    private void activateOnError() {
        this.panelSupplicantButtonBar.utilChangeHandler.activateOnError();
        this.panelSupplicantButtonBar.buttonOptional.setEnabled(false);
    }

    @Override
    public void isActivated(boolean bl) {
        this.panelSupplicantButtonBar.buttonOptional.setEnabled(!bl);
    }

    private class CommonDataNotificationHandler
    implements CommonDataHandler.CommonDataNotificationInterface {
        private CommonDataNotificationHandler() {
        }

        @Override
        public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
            switch (commonDataItemEnum) {
                case SupplicantCertificate: {
                    CommonDataHandler.CertificateClass certificateClass = null;
                    try {
                        certificateClass = (CommonDataHandler.CertificateClass)SystemUtilSupplicantPanel.this.commonDataHandler.getData(commonDataItemEnum);
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + commonDataItemEnum.name() + ":");
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + certificateClass.nLocalCertificates + "'," + certificateClass.nPrivateKeys);
                    }
                    catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + commonDataItemEnum.name() + " failed");
                        return;
                    }
                    if (SystemUtilSupplicantPanel.this.panelGeneral != null) {
                        SystemUtilSupplicantPanel.this.textFieldIdentity.setText(certificateClass.identity.toString());
                    }
                    if (SystemUtilSupplicantPanel.this.panelCertsKey != null) {
                        SystemUtilSupplicantPanel.this.panelCertsKey.setCertValues(certificateClass.nTrustedCertificates, certificateClass.nLocalCertificates, certificateClass.nPrivateKeys);
                    }
                    if (!SystemUtilSupplicantPanel.this.isEditable) break;
                    ((SystemUtilSupplicantPanel)SystemUtilSupplicantPanel.this).panelSupplicantButtonBar.utilChangeHandler.deactivate();
                    SystemUtilSupplicantPanel.this.pwFieldPassword.setInitial();
                    SystemUtilSupplicantPanel.this.pwFieldPasswordConfirm.setInitial();
                    if (!SystemUtilSupplicantPanel.this.certsKeyChangeStarted) break;
                    GuiInfoConsole.showInfo(UtilLocale.getString("TXT_CERTIFICATES_OR_PRIVATE_KEY_UPDATED_SUCCESSFULLY"));
                    SystemUtilSupplicantPanel.this.certsKeyChangeStarted = false;
                    break;
                }
                case Supplicant: {
                    try {
                        SystemUtilSupplicantPanel.this.isSupplicantEditable = (Boolean)SystemUtilSupplicantPanel.this.commonDataHandler.getData(commonDataItemEnum);
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + commonDataItemEnum.name() + ":");
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + SystemUtilSupplicantPanel.this.isSupplicantEditable);
                        SystemUtilSupplicantPanel.this.configureButtonOptional();
                        SystemUtilSupplicantPanel.this.updateCertificatePanel();
                    }
                    catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                        SystemUtilSupplicantPanel.this.isSupplicantEditable = false;
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + commonDataItemEnum.name() + " failed");
                    }
                    break;
                }
                case SupplicantCertificateServer: {
                    try {
                        CommonDataHandler.CertificateServer certificateServer = (CommonDataHandler.CertificateServer)SystemUtilSupplicantPanel.this.commonDataHandler.getData(commonDataItemEnum);
                        SystemUtilSupplicantPanel.this.isCertServerEnabled = certificateServer.url.enable;
                        SystemUtilSupplicantPanel.this.updateCertificatePanel();
                    }
                    catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + commonDataItemEnum.name() + " failed");
                    }
                    break;
                }
            }
        }

        @Override
        public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
            if (commonDataItemEnum == CommonDataHandler.CommonDataItemEnum.SupplicantCertificateServer) {
                return;
            }
            String string = SystemUtilSupplicantPanel.this.commonDataErrorNotificationHandler(dataNotificationEnum, commonDataItemEnum, omiMessage, SystemUtilSupplicantPanel.this.utilErrorCompCertificate);
            if (string != null && string.equals(OmiMessage.URLType.privateKeyPassword.name())) {
                SystemUtilSupplicantPanel.this.utilErrorCompCertificate.markComponent(SystemUtilSupplicantPanel.this.pwFieldPasswordConfirm);
            }
        }
    }
}

