/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.systemfeatures;

import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.guiutil.GuiUtilDetailPanel;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.systemfeatures.SysFeatAlarmTriggerMainPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.AlarmTriggerHandler;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraTextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class SysFeatAlarmTriggerDetailPanel
extends GuiUtilDetailPanel {
    private static final long serialVersionUID = 1L;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private SysFeatAlarmTriggerMainPanel alarmTriggerMainPanel = null;
    private AlarmTriggerHandler.AlarmTrigger alarmTrigger = null;
    private GuiUtilChangeHandler utilChangeHandler = null;
    private UtilErrorComp utilErrorComp = null;
    private int selectedAlarmTrigger = -1;
    private AastraButton buttonOK = null;
    private AastraButton buttonCancel = null;
    private AastraPanel tabGeneral = null;
    private AastraLabel labelPrefix = null;
    private AastraTextField textFieldPrefix = null;
    private AastraLabel labelTriggerID = null;
    private GuiUtilTextField textFieldTriggerID = null;
    private AastraLabel labelFAC = null;
    private GuiUtilTextField textFieldFAC = null;
    private AastraLabel labelComment = null;
    private GuiUtilTextField textFieldComment = null;
    private AastraLabel labelNumber = null;
    private GuiUtilTextField textFieldNumber = null;
    private boolean isEditable = true;
    private ActionModeEnum actionMode;

    public SysFeatAlarmTriggerDetailPanel(SysFeatAlarmTriggerMainPanel sysFeatAlarmTriggerMainPanel, GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, UtilErrorComp utilErrorComp) {
        super(200, 100);
        this.alarmTriggerMainPanel = sysFeatAlarmTriggerMainPanel;
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.utilErrorComp = utilErrorComp;
        this.initialize();
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilChangeHandler = new GuiUtilChangeHandler(this.getButtonOK(), this.getButtonCancel(), false);
            this.panelButtonBar.add(this.getButtonOK());
        } else {
            this.isEditable = false;
        }
        this.panelTabbed.addTab(UtilLocale.getString("TXT_GENERAL"), this.getTabGeneral());
        this.panelButtonBar.add(this.getButtonCancel());
    }

    private GuiUtilTextField getTextFieldTriggerID() {
        if (this.textFieldTriggerID == null) {
            this.textFieldTriggerID = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldTriggerID.setBounds(165, 15, 150, 18);
        }
        return this.textFieldTriggerID;
    }

    private GuiUtilTextField getTextFieldFAC() {
        if (this.textFieldFAC == null) {
            this.textFieldFAC = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldFAC.setBounds(165, 45, 230, 18);
        }
        return this.textFieldFAC;
    }

    private GuiUtilTextField getTextFieldComment() {
        if (this.textFieldComment == null) {
            this.textFieldComment = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldComment.setBounds(165, 75, 230, 18);
        }
        return this.textFieldComment;
    }

    private AastraTextField getTextFieldPrefix() {
        if (this.textFieldPrefix == null) {
            this.textFieldPrefix = new AastraTextField();
            this.textFieldPrefix.setBounds(165, 105, 230, 18);
            this.textFieldPrefix.setEditable(false);
        }
        return this.textFieldPrefix;
    }

    private GuiUtilTextField getTextFieldNumber() {
        if (this.textFieldNumber == null) {
            this.textFieldNumber = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldNumber.setBounds(165, 135, 230, 18);
        }
        return this.textFieldNumber;
    }

    private AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            this.buttonOK.setBounds(70, 15, 90, 25);
            this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOK.setEnabled(false);
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SysFeatAlarmTriggerDetailPanel.this.utilChangeHandler.deactivate();
                    SysFeatAlarmTriggerDetailPanel.this.utilErrorComp.clearComponents();
                    if (SysFeatAlarmTriggerDetailPanel.this.actionMode == ActionModeEnum.CHANGE) {
                        SysFeatAlarmTriggerDetailPanel.this.alarmTriggerMainPanel.changeAlarmTrigger();
                    } else {
                        SysFeatAlarmTriggerDetailPanel.this.alarmTriggerMainPanel.createAlarmTrigger();
                    }
                }
            });
        }
        return this.buttonOK;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            if (this.isEditable) {
                this.buttonCancel.setBounds(230, 15, 90, 25);
            } else {
                this.buttonCancel.setBounds(150, 15, 90, 25);
            }
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SysFeatAlarmTriggerDetailPanel.this.isEditable) {
                        SysFeatAlarmTriggerDetailPanel.this.utilChangeHandler.deactivate();
                    }
                    SysFeatAlarmTriggerDetailPanel.this.alarmTriggerMainPanel.removeAlarmTriggerDetailPanel();
                }
            });
        }
        return this.buttonCancel;
    }

    private AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            this.labelTriggerID = new AastraLabel();
            this.labelTriggerID.setBounds(30, 15, 120, 16);
            this.labelTriggerID.setText(UtilLocale.getString("TXT_TRIGGER_ID"));
            this.labelFAC = new AastraLabel();
            this.labelFAC.setBounds(30, 45, 120, 16);
            this.labelFAC.setText(UtilLocale.getString("TXT_FEATURE_ACCESS_CODE"));
            this.labelComment = new AastraLabel();
            this.labelComment.setBounds(30, 75, 120, 16);
            this.labelComment.setText(UtilLocale.getString("TXT_COMMENT"));
            this.labelPrefix = new AastraLabel();
            this.labelPrefix.setBounds(30, 105, 120, 16);
            this.labelPrefix.setText(UtilLocale.getString("TXT_PREFIX"));
            this.labelNumber = new AastraLabel();
            this.labelNumber.setBounds(30, 135, 120, 32);
            this.labelNumber.setText(UtilLocale.getString("TXT_PHONE_NUMBER"));
            this.tabGeneral = new AastraPanel();
            this.tabGeneral.setLayout(null);
            this.tabGeneral.add(this.labelTriggerID);
            this.tabGeneral.add(this.getTextFieldTriggerID());
            this.tabGeneral.add(this.labelFAC);
            this.tabGeneral.add(this.getTextFieldFAC());
            this.tabGeneral.add(this.labelComment);
            this.tabGeneral.add(this.getTextFieldComment());
            this.tabGeneral.add(this.labelPrefix);
            this.tabGeneral.add(this.getTextFieldPrefix());
            this.tabGeneral.add(this.labelNumber);
            this.tabGeneral.add(this.getTextFieldNumber());
            if (this.isEditable) {
                this.utilErrorComp.put(OmiMessage.AlarmTriggerType.triggerId.toString(), this.labelTriggerID, this.textFieldTriggerID);
                this.utilErrorComp.put(OmiMessage.AlarmTriggerType.fac.toString(), this.labelFAC, this.textFieldFAC);
                this.utilErrorComp.put(OmiMessage.AlarmTriggerType.comment.toString(), this.labelComment, this.textFieldComment);
                this.utilErrorComp.put(OmiMessage.AlarmTriggerType.num.toString(), this.labelNumber, this.textFieldNumber);
            } else {
                UtilSetPanelEditable.setDisabled(this.tabGeneral);
            }
        }
        return this.tabGeneral;
    }

    public void setAlarmTriggerDetailData(AlarmTriggerHandler.AlarmTrigger alarmTrigger, String string) {
        if (alarmTrigger != null) {
            this.alarmTrigger = (AlarmTriggerHandler.AlarmTrigger)alarmTrigger.clone();
            this.selectedAlarmTrigger = this.alarmTrigger.id;
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_ALARM_TRIGGER") + " #" + this.alarmTrigger.id);
            String string2 = this.alarmTrigger.triggerId;
            this.textFieldTriggerID.setText(string2);
            String string3 = this.alarmTrigger.fac;
            this.textFieldFAC.setText(string3);
            if (this.isEditable) {
                if (string2.compareTo(OmiMessage.SpecialAlarmTriggerType.SOS.name()) == 0 || string2.compareTo(OmiMessage.SpecialAlarmTriggerType.MANDOWN.name()) == 0) {
                    this.textFieldTriggerID.setEditable(false);
                    this.textFieldFAC.setEditable(false);
                    this.textFieldComment.requestFocusInWindow();
                } else {
                    this.textFieldTriggerID.setEditable(true);
                    this.textFieldFAC.setEditable(true);
                    this.textFieldTriggerID.requestFocusInWindow();
                }
            }
            this.textFieldComment.setText(this.alarmTrigger.comment);
            if (string != null) {
                this.textFieldPrefix.setText(string);
            }
            this.textFieldNumber.setText(this.alarmTrigger.num);
            this.actionMode = ActionModeEnum.CHANGE;
        } else {
            this.alarmTrigger = null;
            this.selectedAlarmTrigger = -1;
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_NEW_ALARM_TRIGGER"));
            this.textFieldTriggerID.setText("");
            this.textFieldTriggerID.setEditable(true);
            this.textFieldFAC.setText("");
            this.textFieldFAC.setEditable(true);
            this.textFieldComment.setText("");
            if (string != null) {
                this.textFieldPrefix.setText(string);
            }
            this.textFieldNumber.setText("");
            this.textFieldTriggerID.requestFocusInWindow();
            this.actionMode = ActionModeEnum.CREATE;
        }
        if (this.isEditable) {
            this.utilChangeHandler.initRootPane(this.getRootPane());
        } else {
            this.getButtonCancel().requestFocusInWindow();
        }
        this.getRootPane().setDefaultButton(this.getButtonCancel());
    }

    public AlarmTriggerHandler.AlarmTrigger getAlarmTriggerDetailData() {
        if (this.alarmTrigger == null) {
            this.alarmTrigger = new AlarmTriggerHandler.AlarmTrigger();
        }
        this.alarmTrigger.triggerId = this.textFieldTriggerID.getText();
        this.alarmTrigger.fac = this.textFieldFAC.getText();
        this.alarmTrigger.comment = this.textFieldComment.getText();
        this.alarmTrigger.num = this.textFieldNumber.getText();
        return this.alarmTrigger;
    }

    public void markErrorComponent(String string) {
        JComponent jComponent = this.utilErrorComp.getField(string);
        if (jComponent != null) {
            this.utilErrorComp.markComponent(jComponent);
        }
    }

    public String getErrorLabelText(String string) {
        if (string == null) {
            return null;
        }
        return this.utilErrorComp.getLabelText(string);
    }

    public int getSelectedAlarmTrigger() {
        return this.selectedAlarmTrigger;
    }

    private static enum ActionModeEnum {
        CREATE,
        CHANGE;

    }
}

