/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.systemfeatures;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.guiutil.GuiUtilCheckBox;
import com.aastra.oamp.guiutil.GuiUtilComboBox;
import com.aastra.oamp.guiutil.GuiUtilDetailPanel;
import com.aastra.oamp.guiutil.GuiUtilPasswordFieldNew;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.systemfeatures.SysFeatCorpDirMainPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.CorpDirDataHandler;
import com.aastra.omilib.LDAPDataHandler;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.XMLApplicationHandler;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SysFeatCorpDirDetailPanel
extends GuiUtilDetailPanel {
    private static final long serialVersionUID = 1L;
    private static final int TAB_GENERAL = 0;
    private static final int TAB_LDAP = 1;
    private static final int TAB_XML = 2;
    static final String LDAP_PASSWORD = "ldapPassword";
    static final String XML_PASSWORD = "xmlPassword";
    private CorpDirDataHandler corpDirDataHandler = null;
    private SysFeatCorpDirMainPanel corpDirMainPanel = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private GuiUtilChangeHandler utilChangeHandler = null;
    private UtilErrorComp utilErrorComp = null;
    private XMLApplicationHandler.XMLApplRec xmlApplRec = null;
    private LDAPDataHandler.LDAPRecord ldapRecord = null;
    private int selectedCorpDirRecord = -1;
    private AastraButton buttonOK = null;
    private AastraButton buttonCancel = null;
    private boolean isEditable = true;
    private AastraPanel tabGeneral = null;
    private AastraLabel labelType = null;
    private GuiUtilComboBox comboBoxType = null;
    private boolean actionListenerTypeActive = false;
    private AastraLabel labelActive = null;
    private GuiUtilCheckBox checkBoxActive = null;
    private AastraLabel labelOrder = null;
    private GuiUtilComboBox comboBoxOrder = null;
    private AastraLabel labelName = null;
    private GuiUtilTextField textFieldName = null;
    private AastraPanel tabLDAP = null;
    private AastraLabel labelLDAPSearchBase = null;
    private GuiUtilTextField textFieldLDAPSearchBase = null;
    private AastraLabel labelLDAPSearchType = null;
    private GuiUtilComboBox comboBoxLDAPSearchType = null;
    private AastraLabel labelLDAPDisplayType = null;
    private GuiUtilComboBox comboBoxLDAPDisplayType = null;
    private AastraLabel labelLDAPServer = null;
    private GuiUtilTextField textFieldLDAPServer = null;
    private AastraLabel labelLDAPPort = null;
    private GuiUtilTextField textFieldLDAPPort = null;
    private AastraLabel labelLDAPUserName = null;
    private GuiUtilTextField textFieldLDAPUserName = null;
    private AastraLabel labelLDAPPassword = null;
    private GuiUtilPasswordFieldNew passwordFieldLDAPPassword = null;
    private AastraLabel labelLDAPPasswordConfirm = null;
    private GuiUtilPasswordFieldNew passwordFieldLDAPPasswordConfirm = null;
    private AastraLabel labelLDAPTimeout = null;
    private AastraLabel labelLDAPUnitSecond = null;
    private GuiUtilTextField textFieldLDAPTimeout = null;
    private AastraPanel tabXML = null;
    private AastraLabel labelXMLProtocol = null;
    private GuiUtilComboBox comboBoxXMLProtocol = null;
    private AastraLabel labelXMLPort = null;
    private GuiUtilTextField textFieldXMLPort = null;
    private AastraLabel labelXMLUseDefaultPort = null;
    private GuiUtilCheckBox checkBoxXMLDefaultPort = null;
    private AastraLabel labelXMLServer = null;
    private GuiUtilTextField textFieldXMLServer = null;
    private AastraLabel labelXMLUserName = null;
    private GuiUtilTextField textFieldXMLUserName = null;
    private AastraLabel labelXMLPassword = null;
    private GuiUtilPasswordFieldNew passwordFieldXMLPassword = null;
    private AastraLabel labelXMLPasswordConfirm = null;
    private GuiUtilPasswordFieldNew passwordFieldXMLPasswordConfirm = null;
    private AastraLabel labelXMLPath = null;
    private GuiUtilTextField textFieldXMLPath = null;
    private ActionModeEnum actionMode;

    public SysFeatCorpDirDetailPanel(SysFeatCorpDirMainPanel sysFeatCorpDirMainPanel, GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, CorpDirDataHandler corpDirDataHandler, UtilErrorComp utilErrorComp) {
        super(300, 210);
        this.corpDirMainPanel = sysFeatCorpDirMainPanel;
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.corpDirDataHandler = corpDirDataHandler;
        this.utilErrorComp = utilErrorComp;
        this.initialize();
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilChangeHandler = new GuiUtilChangeHandler(this.getButtonOK(), this.getButtonCancel(), false);
            this.panelButtonBar.add(this.getButtonOK());
        } else {
            this.isEditable = false;
        }
        this.panelTabbed.addTab(UtilLocale.getString("TXT_GENERAL_20"), this.getTabGeneral());
        this.panelTabbed.addTab(UtilLocale.getString("TXT_LDAP_20"), this.getTabLDAP());
        this.panelTabbed.addTab(UtilLocale.getString("TXT_XML_APPLICATION_20"), this.getTabXML());
        this.panelButtonBar.add(this.getButtonCancel());
    }

    private AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            this.labelType = new AastraLabel();
            this.labelType.setBounds(30, 15, 120, 16);
            this.labelType.setText(UtilLocale.getString("TXT_TYPE"));
            this.labelActive = new AastraLabel();
            this.labelActive.setBounds(30, 45, 120, 16);
            this.labelActive.setText(UtilLocale.getString("TXT_ACTIVE"));
            this.labelOrder = new AastraLabel();
            this.labelOrder.setBounds(30, 75, 120, 16);
            this.labelOrder.setText(UtilLocale.getString("TXT_ORDER"));
            this.labelName = new AastraLabel();
            this.labelName.setBounds(30, 105, 120, 16);
            this.labelName.setText(UtilLocale.getString("TXT_NAME"));
            this.tabGeneral = new AastraPanel();
            this.tabGeneral.setLayout(null);
            this.tabGeneral.add(this.labelType);
            this.tabGeneral.add(this.getComboBoxType());
            this.tabGeneral.add(this.labelActive);
            this.tabGeneral.add(this.getCheckBoxActive());
            this.tabGeneral.add(this.labelOrder);
            this.tabGeneral.add(this.getComboBoxOrder());
            this.tabGeneral.add(this.labelName);
            this.tabGeneral.add(this.getTextFieldName());
            if (this.isEditable) {
                this.utilErrorComp.putWithTab(OmiMessage.LDAPNewType.name.toString(), this.labelName, this.textFieldName, 0);
            } else {
                UtilSetPanelEditable.setDisabled(this.tabGeneral);
            }
        }
        return this.tabGeneral;
    }

    private GuiUtilComboBox getComboBoxType() {
        if (this.comboBoxType == null) {
            this.comboBoxType = new GuiUtilComboBox();
            this.comboBoxType.setBounds(195, 15, 70, 20);
            for (int i = 0; i < CorpDirDataHandler.CorpDirTypeType.values().length; ++i) {
                this.comboBoxType.addItem(CorpDirDataHandler.CorpDirTypeType.values()[i]);
            }
            this.comboBoxType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SysFeatCorpDirDetailPanel.this.actionListenerTypeActive) {
                        CorpDirDataHandler.CorpDirTypeType corpDirTypeType = (CorpDirDataHandler.CorpDirTypeType)((Object)SysFeatCorpDirDetailPanel.this.comboBoxType.getSelectedItem());
                        if (corpDirTypeType == CorpDirDataHandler.CorpDirTypeType.LDAP) {
                            SysFeatCorpDirDetailPanel.this.panelTabbed.setEnabledAt(1, true);
                            SysFeatCorpDirDetailPanel.this.panelTabbed.setEnabledAt(2, false);
                        } else {
                            SysFeatCorpDirDetailPanel.this.panelTabbed.setEnabledAt(1, false);
                            SysFeatCorpDirDetailPanel.this.panelTabbed.setEnabledAt(2, true);
                        }
                        SysFeatCorpDirDetailPanel.this.utilChangeHandler.activate();
                    }
                }
            });
            this.actionListenerTypeActive = true;
        }
        return this.comboBoxType;
    }

    private GuiUtilCheckBox getCheckBoxActive() {
        if (this.checkBoxActive == null) {
            this.checkBoxActive = new GuiUtilCheckBox(this.utilChangeHandler, 190, 45);
        }
        return this.checkBoxActive;
    }

    private GuiUtilComboBox getComboBoxOrder() {
        if (this.comboBoxOrder == null) {
            this.comboBoxOrder = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxOrder.setBounds(195, 75, 50, 20);
        }
        return this.comboBoxOrder;
    }

    private void rebuiltComboBoxOrder(int n) {
        if (this.comboBoxOrder != null && this.comboBoxOrder.getItemCount() != n) {
            this.comboBoxOrder.removeAllItems();
            for (int i = 1; i <= n; ++i) {
                this.comboBoxOrder.addItem(Integer.toString(i));
            }
        }
    }

    private GuiUtilTextField getTextFieldName() {
        if (this.textFieldName == null) {
            this.textFieldName = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldName.setBounds(195, 105, 160, 18);
        }
        return this.textFieldName;
    }

    private AastraPanel getTabLDAP() {
        if (this.tabLDAP == null) {
            this.labelLDAPSearchBase = new AastraLabel();
            this.labelLDAPSearchBase.setBounds(30, 15, 150, 16);
            this.labelLDAPSearchBase.setText(UtilLocale.getString("TXT_SEARCH_BASE"));
            this.labelLDAPSearchType = new AastraLabel();
            this.labelLDAPSearchType.setBounds(30, 45, 120, 16);
            this.labelLDAPSearchType.setText(UtilLocale.getString("TXT_SEARCH_TYPE"));
            this.labelLDAPDisplayType = new AastraLabel();
            this.labelLDAPDisplayType.setBounds(30, 75, 120, 16);
            this.labelLDAPDisplayType.setText(UtilLocale.getString("TXT_DISPLAY_TYPE"));
            this.labelLDAPServer = new AastraLabel();
            this.labelLDAPServer.setBounds(30, 105, 120, 16);
            this.labelLDAPServer.setText(UtilLocale.getString("TXT_SERVER"));
            this.labelLDAPPort = new AastraLabel();
            this.labelLDAPPort.setBounds(30, 135, 120, 16);
            this.labelLDAPPort.setText(UtilLocale.getString("TXT_PORT"));
            this.labelLDAPUserName = new AastraLabel();
            this.labelLDAPUserName.setBounds(30, 165, 120, 16);
            this.labelLDAPUserName.setText(UtilLocale.getString("TXT_USER_NAME"));
            this.labelLDAPPassword = new AastraLabel();
            this.labelLDAPPassword.setBounds(30, 195, 120, 16);
            this.labelLDAPPassword.setText(UtilLocale.getString("TXT_PASSWORD"));
            this.labelLDAPPasswordConfirm = new AastraLabel();
            this.labelLDAPPasswordConfirm.setBounds(30, 225, 150, 31);
            this.labelLDAPPasswordConfirm.setText("<html>" + UtilLocale.getString("TXT_PASSWORD_CONFIRMATION") + "</html>");
            this.labelLDAPTimeout = new AastraLabel();
            this.labelLDAPTimeout.setBounds(30, 255, 150, 31);
            this.labelLDAPTimeout.setText("<html>" + UtilLocale.getString("TXT_SERVER_SEARCH_TIMEOUT") + "</html>");
            this.labelLDAPUnitSecond = new AastraLabel();
            this.labelLDAPUnitSecond.setBounds(265, 255, 45, 16);
            this.labelLDAPUnitSecond.setText(UtilLocale.getString("TXT_UNIT_SECOND"));
            this.tabLDAP = new AastraPanel();
            this.tabLDAP.setLayout(null);
            this.tabLDAP.add(this.labelLDAPSearchBase);
            this.tabLDAP.add(this.getTextFieldLDAPSearchBase());
            this.tabLDAP.add(this.labelLDAPSearchType);
            this.tabLDAP.add(this.getComboBoxLDAPSearchType());
            this.tabLDAP.add(this.labelLDAPDisplayType);
            this.tabLDAP.add(this.getComboBoxLDAPDisplayType());
            this.tabLDAP.add(this.labelLDAPServer);
            this.tabLDAP.add(this.getTextFieldLDAPServer());
            this.tabLDAP.add(this.labelLDAPPort);
            this.tabLDAP.add(this.getTextFieldLDAPPort());
            this.tabLDAP.add(this.labelLDAPUserName);
            this.tabLDAP.add(this.getTextFieldLDAPUserName());
            this.tabLDAP.add(this.labelLDAPPassword);
            this.tabLDAP.add(this.getPasswordFieldLDAPPassword());
            this.tabLDAP.add(this.labelLDAPPasswordConfirm);
            this.tabLDAP.add(this.getPasswordFieldLDAPPasswordConfirm());
            this.tabLDAP.add(this.labelLDAPTimeout);
            this.tabLDAP.add(this.getTextFieldLDAPTimeout());
            this.tabLDAP.add(this.labelLDAPUnitSecond);
            if (this.isEditable) {
                this.utilErrorComp.putWithTab(OmiMessage.LDAPNewType.searchBase.toString(), this.labelLDAPSearchBase, this.textFieldLDAPSearchBase, 1);
                this.utilErrorComp.putWithTab(OmiMessage.LDAPNewType.server.toString(), this.labelLDAPServer, this.textFieldLDAPServer, 1);
                this.utilErrorComp.putWithTab(OmiMessage.LDAPNewType.port.toString(), this.labelLDAPPort, this.textFieldLDAPPort, 1);
                this.utilErrorComp.putWithTab(OmiMessage.LDAPNewType.username.toString(), this.labelLDAPUserName, this.textFieldLDAPUserName, 1);
                this.utilErrorComp.putWithTab(LDAP_PASSWORD, this.labelLDAPPassword, this.passwordFieldLDAPPassword, 1);
                this.utilErrorComp.putWithTab(OmiMessage.LDAPNewType.timeout.toString(), this.labelLDAPTimeout, this.textFieldLDAPTimeout, 1);
            } else {
                UtilSetPanelEditable.setDisabled(this.tabLDAP);
            }
        }
        return this.tabLDAP;
    }

    private GuiUtilTextField getTextFieldLDAPSearchBase() {
        if (this.textFieldLDAPSearchBase == null) {
            this.textFieldLDAPSearchBase = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldLDAPSearchBase.setBounds(195, 15, 400, 18);
        }
        return this.textFieldLDAPSearchBase;
    }

    private GuiUtilComboBox getComboBoxLDAPSearchType() {
        if (this.comboBoxLDAPSearchType == null) {
            this.comboBoxLDAPSearchType = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxLDAPSearchType.setBounds(195, 45, 170, 20);
            this.comboBoxLDAPSearchType.addItem(UtilLocale.getString("TXT_SURNAME"));
            this.comboBoxLDAPSearchType.addItem(UtilLocale.getString("TXT_GIVEN_NAME"));
            this.comboBoxLDAPSearchType.activateActionListener();
        }
        return this.comboBoxLDAPSearchType;
    }

    private GuiUtilComboBox getComboBoxLDAPDisplayType() {
        if (this.comboBoxLDAPDisplayType == null) {
            this.comboBoxLDAPDisplayType = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxLDAPDisplayType.setBounds(195, 75, 170, 20);
            this.comboBoxLDAPDisplayType.addItem(UtilLocale.getString("TXT_SURNAME_GIVEN_NAME"));
            this.comboBoxLDAPDisplayType.addItem(UtilLocale.getString("TXT_GIVEN_NAME_AND_SURNAME"));
            this.comboBoxLDAPDisplayType.activateActionListener();
        }
        return this.comboBoxLDAPDisplayType;
    }

    private GuiUtilTextField getTextFieldLDAPServer() {
        if (this.textFieldLDAPServer == null) {
            this.textFieldLDAPServer = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldLDAPServer.setBounds(195, 105, 230, 18);
        }
        return this.textFieldLDAPServer;
    }

    private GuiUtilTextField getTextFieldLDAPPort() {
        if (this.textFieldLDAPPort == null) {
            this.textFieldLDAPPort = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldLDAPPort.setBounds(195, 135, 60, 18);
        }
        return this.textFieldLDAPPort;
    }

    private GuiUtilTextField getTextFieldLDAPUserName() {
        if (this.textFieldLDAPUserName == null) {
            this.textFieldLDAPUserName = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldLDAPUserName.setBounds(195, 165, 400, 18);
        }
        return this.textFieldLDAPUserName;
    }

    private GuiUtilPasswordFieldNew getPasswordFieldLDAPPassword() {
        if (this.passwordFieldLDAPPassword == null) {
            this.passwordFieldLDAPPassword = new GuiUtilPasswordFieldNew(this.utilChangeHandler);
            this.passwordFieldLDAPPassword.setBounds(195, 195, 230, 18);
        }
        return this.passwordFieldLDAPPassword;
    }

    private GuiUtilPasswordFieldNew getPasswordFieldLDAPPasswordConfirm() {
        if (this.passwordFieldLDAPPasswordConfirm == null) {
            this.passwordFieldLDAPPasswordConfirm = new GuiUtilPasswordFieldNew(this.utilChangeHandler);
            this.passwordFieldLDAPPasswordConfirm.setBounds(195, 225, 230, 18);
        }
        return this.passwordFieldLDAPPasswordConfirm;
    }

    private GuiUtilTextField getTextFieldLDAPTimeout() {
        if (this.textFieldLDAPTimeout == null) {
            this.textFieldLDAPTimeout = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldLDAPTimeout.setBounds(195, 255, 60, 18);
        }
        return this.textFieldLDAPTimeout;
    }

    private AastraPanel getTabXML() {
        if (this.tabXML == null) {
            this.labelXMLProtocol = new AastraLabel();
            this.labelXMLProtocol.setBounds(30, 15, 120, 16);
            this.labelXMLProtocol.setText(UtilLocale.getString("TXT_PROTOCOL"));
            this.labelXMLPort = new AastraLabel();
            this.labelXMLPort.setBounds(30, 45, 120, 16);
            this.labelXMLPort.setText(UtilLocale.getString("TXT_PORT"));
            this.labelXMLUseDefaultPort = new AastraLabel();
            this.labelXMLUseDefaultPort.setBounds(250, 45, 145, 16);
            this.labelXMLUseDefaultPort.setText(UtilLocale.getString("TXT_USE_DEFAULT_PORT"));
            this.labelXMLUseDefaultPort.setHorizontalAlignment(4);
            this.labelXMLServer = new AastraLabel();
            this.labelXMLServer.setBounds(30, 75, 120, 16);
            this.labelXMLServer.setText(UtilLocale.getString("TXT_SERVER"));
            this.labelXMLUserName = new AastraLabel();
            this.labelXMLUserName.setBounds(30, 105, 120, 16);
            this.labelXMLUserName.setText(UtilLocale.getString("TXT_USER_NAME"));
            this.labelXMLPassword = new AastraLabel();
            this.labelXMLPassword.setBounds(30, 135, 120, 16);
            this.labelXMLPassword.setText(UtilLocale.getString("TXT_PASSWORD"));
            this.labelXMLPasswordConfirm = new AastraLabel();
            this.labelXMLPasswordConfirm.setBounds(30, 165, 120, 32);
            this.labelXMLPasswordConfirm.setText("<html>" + UtilLocale.getString("TXT_PASSWORD_CONFIRMATION") + "</html>");
            this.labelXMLPath = new AastraLabel();
            this.labelXMLPath.setBounds(30, 195, 120, 32);
            this.labelXMLPath.setText("<html>" + UtilLocale.getString("TXT_PATH_AND_PARAMETERS") + "</html>");
            this.tabXML = new AastraPanel();
            this.tabXML.setLayout(null);
            this.tabXML.add(this.labelXMLProtocol);
            this.tabXML.add(this.getComboBoxXMLProtocol());
            this.tabXML.add(this.labelXMLPort);
            this.tabXML.add(this.getTextFieldXMLPort());
            this.tabXML.add(this.labelXMLUseDefaultPort);
            this.tabXML.add(this.getCheckBoxXMLDefaultPort());
            this.tabXML.add(this.labelXMLServer);
            this.tabXML.add(this.getTextFieldXMLServer());
            this.tabXML.add(this.labelXMLUserName);
            this.tabXML.add(this.getTextFieldXMLUserName());
            this.tabXML.add(this.labelXMLPassword);
            this.tabXML.add(this.getPasswordFieldXMLPassword());
            this.tabXML.add(this.labelXMLPasswordConfirm);
            this.tabXML.add(this.getPasswordFieldXMLPasswordConfirm());
            this.tabXML.add(this.labelXMLPath);
            this.tabXML.add(this.getTextFieldXMLPath());
            if (this.isEditable) {
                this.utilErrorComp.putWithTab(OmiMessage.URLType.port.toString(), this.labelXMLPort, this.textFieldXMLPort, 2);
                this.utilErrorComp.putWithTab(OmiMessage.URLType.host.toString(), this.labelXMLServer, this.textFieldXMLServer, 2);
                this.utilErrorComp.putWithTab(OmiMessage.URLType.username.toString(), this.labelXMLUserName, this.textFieldXMLUserName, 2);
                this.utilErrorComp.putWithTab(XML_PASSWORD, this.labelXMLPassword, this.passwordFieldXMLPassword, 2);
                this.utilErrorComp.putWithTab(OmiMessage.URLType.path.toString(), this.labelXMLPath, this.textFieldXMLPath, 2);
            } else {
                UtilSetPanelEditable.setDisabled(this.tabXML);
            }
        }
        return this.tabXML;
    }

    private GuiUtilComboBox getComboBoxXMLProtocol() {
        if (this.comboBoxXMLProtocol == null) {
            this.comboBoxXMLProtocol = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxXMLProtocol.setBounds(170, 15, 90, 20);
            if (OmiMessage.ProtType.HTTP.isValid().booleanValue()) {
                this.comboBoxXMLProtocol.addItem(OmiMessage.ProtType.HTTP);
            }
            if (OmiMessage.ProtType.HTTPS.isValid().booleanValue()) {
                this.comboBoxXMLProtocol.addItem(OmiMessage.ProtType.HTTPS);
            }
            this.comboBoxXMLProtocol.activateActionListener();
        }
        return this.comboBoxXMLProtocol;
    }

    private GuiUtilTextField getTextFieldXMLPort() {
        if (this.textFieldXMLPort == null) {
            this.textFieldXMLPort = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldXMLPort.setBounds(170, 45, 70, 18);
        }
        return this.textFieldXMLPort;
    }

    private GuiUtilCheckBox getCheckBoxXMLDefaultPort() {
        if (this.checkBoxXMLDefaultPort == null) {
            this.checkBoxXMLDefaultPort = new GuiUtilCheckBox(this.utilChangeHandler, 395, 42);
            if (this.isEditable) {
                this.checkBoxXMLDefaultPort.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        if (SysFeatCorpDirDetailPanel.this.checkBoxXMLDefaultPort.isSelected()) {
                            SysFeatCorpDirDetailPanel.this.textFieldXMLPort.setText("");
                            SysFeatCorpDirDetailPanel.this.textFieldXMLPort.setEnabled(false);
                        } else {
                            SysFeatCorpDirDetailPanel.this.textFieldXMLPort.setEnabled(true);
                        }
                    }
                });
            }
        }
        return this.checkBoxXMLDefaultPort;
    }

    private GuiUtilTextField getTextFieldXMLServer() {
        if (this.textFieldXMLServer == null) {
            this.textFieldXMLServer = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldXMLServer.setBounds(170, 75, 400, 18);
        }
        return this.textFieldXMLServer;
    }

    private GuiUtilTextField getTextFieldXMLUserName() {
        if (this.textFieldXMLUserName == null) {
            this.textFieldXMLUserName = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldXMLUserName.setBounds(170, 105, 240, 18);
        }
        return this.textFieldXMLUserName;
    }

    private GuiUtilPasswordFieldNew getPasswordFieldXMLPassword() {
        if (this.passwordFieldXMLPassword == null) {
            this.passwordFieldXMLPassword = new GuiUtilPasswordFieldNew(this.utilChangeHandler);
            this.passwordFieldXMLPassword.setBounds(170, 135, 240, 18);
        }
        return this.passwordFieldXMLPassword;
    }

    private GuiUtilPasswordFieldNew getPasswordFieldXMLPasswordConfirm() {
        if (this.passwordFieldXMLPasswordConfirm == null) {
            this.passwordFieldXMLPasswordConfirm = new GuiUtilPasswordFieldNew(this.utilChangeHandler);
            this.passwordFieldXMLPasswordConfirm.setBounds(170, 165, 240, 18);
        }
        return this.passwordFieldXMLPasswordConfirm;
    }

    private GuiUtilTextField getTextFieldXMLPath() {
        if (this.textFieldXMLPath == null) {
            this.textFieldXMLPath = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldXMLPath.setBounds(170, 195, 400, 18);
        }
        return this.textFieldXMLPath;
    }

    private AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            this.buttonOK.setBounds(70, 15, 90, 25);
            this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOK.setEnabled(false);
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SysFeatCorpDirDetailPanel.this.utilChangeHandler.deactivate();
                    SysFeatCorpDirDetailPanel.this.utilErrorComp.clearComponents();
                    if (SysFeatCorpDirDetailPanel.this.actionMode == ActionModeEnum.CHANGE) {
                        SysFeatCorpDirDetailPanel.this.corpDirMainPanel.changeCorpDirRecord();
                    } else {
                        SysFeatCorpDirDetailPanel.this.corpDirMainPanel.createCorpDirRecord();
                    }
                }
            });
        }
        return this.buttonOK;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            if (this.isEditable) {
                this.buttonCancel.setBounds(230, 15, 90, 25);
            } else {
                this.buttonCancel.setBounds(150, 15, 90, 25);
            }
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SysFeatCorpDirDetailPanel.this.isEditable) {
                        SysFeatCorpDirDetailPanel.this.utilChangeHandler.deactivate();
                    }
                    SysFeatCorpDirDetailPanel.this.corpDirMainPanel.removeCorpDirDetailPanel();
                }
            });
        }
        return this.buttonCancel;
    }

    public void setCorpDirRecordDetailData(CorpDirDataHandler.CorpDirRecord corpDirRecord) {
        this.comboBoxOrder.deactivateActionListener();
        if (corpDirRecord != null) {
            int n = corpDirRecord.relatedId;
            CorpDirDataHandler.CorpDirTypeType corpDirTypeType = corpDirRecord.type;
            this.selectedCorpDirRecord = corpDirRecord.id;
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_DIRECTORY_ENTRY"));
            this.panelTabbed.setFirstTab();
            if (corpDirTypeType == CorpDirDataHandler.CorpDirTypeType.LDAP) {
                this.panelTabbed.setEnabledAt(1, true);
                this.panelTabbed.setEnabledAt(2, false);
            } else {
                this.panelTabbed.setEnabledAt(1, false);
                this.panelTabbed.setEnabledAt(2, true);
            }
            this.actionListenerTypeActive = false;
            this.comboBoxType.setSelectedItem((Object)corpDirTypeType);
            this.comboBoxType.setEnabled(false);
            this.rebuiltComboBoxOrder(this.corpDirDataHandler.getNumberOfCorpDirEntries());
            if (corpDirTypeType == CorpDirDataHandler.CorpDirTypeType.LDAP) {
                LDAPDataHandler.LDAPRecord lDAPRecord = this.corpDirDataHandler.getLDAPRecordByLDAPId(n);
                if (lDAPRecord != null) {
                    this.ldapRecord = (LDAPDataHandler.LDAPRecord)lDAPRecord.clone();
                    this.checkBoxActive.setSelected(this.ldapRecord.active);
                    this.comboBoxOrder.setSelectedItem(Integer.toString(this.ldapRecord.order));
                    this.textFieldName.setText(this.ldapRecord.name);
                    this.textFieldLDAPSearchBase.setText(this.ldapRecord.searchBase);
                    this.comboBoxLDAPSearchType.deactivateActionListener();
                    if (this.ldapRecord.searchType == OmiMessage.SearchNewType.SN) {
                        this.comboBoxLDAPSearchType.setSelectedIndex(0);
                    } else {
                        this.comboBoxLDAPSearchType.setSelectedIndex(1);
                    }
                    this.comboBoxLDAPSearchType.activateActionListener();
                    this.comboBoxLDAPDisplayType.deactivateActionListener();
                    if (this.ldapRecord.displayType == OmiMessage.DisplayNewType.SN_GN) {
                        this.comboBoxLDAPDisplayType.setSelectedIndex(0);
                    } else {
                        this.comboBoxLDAPDisplayType.setSelectedIndex(1);
                    }
                    this.comboBoxLDAPDisplayType.activateActionListener();
                    this.textFieldLDAPServer.setText(this.ldapRecord.server);
                    this.textFieldLDAPPort.setText(String.valueOf(this.ldapRecord.port));
                    this.textFieldLDAPUserName.setText(this.ldapRecord.username);
                    this.passwordFieldLDAPPassword.setInitial();
                    this.passwordFieldLDAPPasswordConfirm.setInitial();
                    this.textFieldLDAPTimeout.setText(String.valueOf(this.ldapRecord.timeout));
                }
            } else {
                XMLApplicationHandler.XMLApplRec xMLApplRec = this.corpDirDataHandler.getXMLRecordByXMLId(n);
                if (xMLApplRec != null) {
                    this.xmlApplRec = xMLApplRec.clone();
                    this.checkBoxActive.setSelected(this.xmlApplRec.enable);
                    this.comboBoxOrder.setSelectedItem(Integer.toString(this.xmlApplRec.corpDirOrder));
                    this.textFieldName.setText(this.xmlApplRec.name);
                    if (this.isEditable) {
                        this.checkBoxActive.requestFocusInWindow();
                    }
                    this.comboBoxXMLProtocol.deactivateActionListener();
                    this.comboBoxXMLProtocol.setSelectedItem((Object)this.xmlApplRec.url.protocol);
                    this.comboBoxXMLProtocol.activateActionListener();
                    if (this.xmlApplRec.url.port != null) {
                        if (this.xmlApplRec.url.port == 0) {
                            this.textFieldXMLPort.setText("");
                            this.checkBoxXMLDefaultPort.setSelected(true);
                        } else {
                            this.textFieldXMLPort.setText("" + this.xmlApplRec.url.port);
                            this.checkBoxXMLDefaultPort.setSelected(false);
                        }
                    } else {
                        this.textFieldXMLPort.setText("");
                        this.checkBoxXMLDefaultPort.setSelected(true);
                    }
                    this.textFieldXMLServer.setText(this.xmlApplRec.url.host);
                    this.textFieldXMLUserName.setText(this.xmlApplRec.url.username);
                    this.textFieldXMLPath.setText(this.xmlApplRec.url.path);
                    this.passwordFieldXMLPassword.setInitial();
                    this.passwordFieldXMLPasswordConfirm.setInitial();
                }
            }
            this.actionMode = ActionModeEnum.CHANGE;
        } else {
            this.selectedCorpDirRecord = -1;
            this.ldapRecord = null;
            this.xmlApplRec = null;
            this.panelTabbed.setFirstTab();
            this.panelTabbed.setEnabledAt(1, true);
            this.panelTabbed.setEnabledAt(2, false);
            this.actionListenerTypeActive = false;
            this.comboBoxType.setSelectedItem((Object)CorpDirDataHandler.CorpDirTypeType.LDAP);
            this.comboBoxType.setEnabled(true);
            this.actionListenerTypeActive = true;
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_NEW_DIRECTORY_ENTRY"));
            this.checkBoxActive.setSelected(false);
            this.rebuiltComboBoxOrder(this.corpDirDataHandler.getNumberOfCorpDirEntries() + 1);
            this.comboBoxOrder.setSelectedItem("1");
            this.textFieldName.setText("");
            this.textFieldLDAPSearchBase.setText("");
            this.comboBoxLDAPSearchType.deactivateActionListener();
            this.comboBoxLDAPSearchType.setSelectedIndex(0);
            this.comboBoxLDAPSearchType.activateActionListener();
            this.comboBoxLDAPDisplayType.deactivateActionListener();
            this.comboBoxLDAPDisplayType.setSelectedIndex(0);
            this.comboBoxLDAPDisplayType.activateActionListener();
            this.textFieldLDAPServer.setText("");
            this.textFieldLDAPPort.setText("389");
            this.textFieldLDAPUserName.setText("");
            this.passwordFieldLDAPPassword.setText("");
            this.passwordFieldLDAPPasswordConfirm.setText("");
            this.textFieldLDAPTimeout.setText("10");
            this.xmlApplRec = null;
            this.comboBoxXMLProtocol.setSelectedIndex(0);
            this.textFieldXMLPort.setText("");
            this.checkBoxXMLDefaultPort.setSelected(true);
            this.textFieldXMLServer.setText("");
            this.textFieldXMLUserName.setText("");
            this.passwordFieldXMLPassword.setText("");
            this.passwordFieldXMLPasswordConfirm.setText("");
            this.textFieldXMLPath.setText("");
            this.checkBoxActive.requestFocusInWindow();
            this.actionMode = ActionModeEnum.CREATE;
        }
        if (this.isEditable) {
            this.utilChangeHandler.initRootPane(this.getRootPane());
        } else {
            this.getButtonCancel().requestFocusInWindow();
        }
        this.getRootPane().setDefaultButton(this.getButtonCancel());
        this.comboBoxOrder.activateActionListener();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getCorpDirRecordDetailData() {
        CorpDirDataHandler.CorpDirTypeType corpDirTypeType = (CorpDirDataHandler.CorpDirTypeType)((Object)this.comboBoxType.getSelectedItem());
        if (corpDirTypeType == CorpDirDataHandler.CorpDirTypeType.LDAP) {
            block17: {
                if (this.ldapRecord == null) {
                    this.ldapRecord = new LDAPDataHandler.LDAPRecord();
                }
                this.ldapRecord.active = this.checkBoxActive.isSelected();
                this.ldapRecord.order = new Integer(this.comboBoxOrder.getSelectedItem().toString());
                this.ldapRecord.name = this.textFieldName.getText();
                this.ldapRecord.searchBase = this.textFieldLDAPSearchBase.getText();
                this.ldapRecord.searchType = this.comboBoxLDAPSearchType.getSelectedIndex() == 0 ? OmiMessage.SearchNewType.SN : OmiMessage.SearchNewType.GN;
                this.ldapRecord.displayType = this.comboBoxLDAPDisplayType.getSelectedIndex() == 0 ? OmiMessage.DisplayNewType.SN_GN : OmiMessage.DisplayNewType.CN;
                this.ldapRecord.server = this.textFieldLDAPServer.getText();
                if (this.textFieldLDAPPort.getText().length() <= 0) {
                    GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_MISSING"), UtilLocale.getString("TXT_PORT")));
                    this.markErrorComponent(OmiMessage.LDAPNewType.port.toString());
                    return null;
                }
                try {
                    this.ldapRecord.port = Integer.parseInt(this.textFieldLDAPPort.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    GuiInfoConsole.showError(UtilLocale.getString("TXT_INPUT_FORMAT_INVALID"));
                    this.markErrorComponent(OmiMessage.LDAPNewType.port.toString());
                    return null;
                }
                this.ldapRecord.username = this.textFieldLDAPUserName.getText();
                if (this.passwordFieldLDAPPassword.isChanged() || this.passwordFieldLDAPPasswordConfirm.isChanged()) {
                    String string = new String(this.passwordFieldLDAPPassword.getPassword());
                    String string2 = new String(this.passwordFieldLDAPPasswordConfirm.getPassword());
                    if (this.passwordFieldLDAPPassword.isChanged() && this.passwordFieldLDAPPasswordConfirm.isChanged() && string.equals(string2)) {
                        this.ldapRecord.password = string;
                        break block17;
                    } else {
                        GuiInfoConsole.showError(UtilLocale.getString("TXT_PASSWORD_CONFIRMATION_FAILED"));
                        this.markErrorComponent(LDAP_PASSWORD);
                        return null;
                    }
                }
                this.ldapRecord.password = null;
            }
            if (this.textFieldLDAPTimeout.getText().length() <= 0) {
                GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_MISSING"), UtilLocale.getString("TXT_SERVER_SEARCH_TIMEOUT")));
                this.markErrorComponent(OmiMessage.LDAPNewType.timeout.toString());
                return null;
            }
            try {
                this.ldapRecord.timeout = Integer.parseInt(this.textFieldLDAPTimeout.getText());
                return this.ldapRecord;
            }
            catch (NumberFormatException numberFormatException) {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_INPUT_FORMAT_INVALID"));
                this.markErrorComponent(OmiMessage.LDAPNewType.timeout.toString());
                return null;
            }
        }
        if (this.xmlApplRec == null) {
            this.xmlApplRec = new XMLApplicationHandler.XMLApplRec();
            this.xmlApplRec.type = OmiMessage.XMLApplicationTypeType.CorpDir;
            this.xmlApplRec.url = new CommonDataHandler.UrlClass();
        }
        this.xmlApplRec.enable = this.checkBoxActive.isSelected();
        this.xmlApplRec.corpDirOrder = new Integer(this.comboBoxOrder.getSelectedItem().toString());
        this.xmlApplRec.name = this.textFieldName.getText();
        this.xmlApplRec.url.protocol = (OmiMessage.ProtType)((Object)this.comboBoxXMLProtocol.getSelectedItem());
        this.xmlApplRec.url.host = this.textFieldXMLServer.getText();
        this.xmlApplRec.url.username = this.textFieldXMLUserName.getText();
        this.xmlApplRec.url.path = this.textFieldXMLPath.getText();
        if (this.checkBoxXMLDefaultPort.isSelected()) {
            this.xmlApplRec.url.port = 0;
        } else {
            int n = 0;
            n = UtilMisc.getIntFromTextField(this.textFieldXMLPort, UtilLocale.getString("TXT_PORT"), this.utilErrorComp, 10);
            if (n == -1) {
                this.markErrorComponent(UtilLocale.getString("TXT_PORT"));
                return null;
            }
            this.xmlApplRec.url.port = n;
        }
        if (!this.passwordFieldXMLPassword.isChanged() && !this.passwordFieldXMLPasswordConfirm.isChanged()) {
            this.xmlApplRec.url.password = null;
            return this.xmlApplRec;
        }
        String string = new String(this.passwordFieldXMLPassword.getPassword());
        String string3 = new String(this.passwordFieldXMLPasswordConfirm.getPassword());
        if (this.passwordFieldXMLPassword.isChanged() && this.passwordFieldXMLPasswordConfirm.isChanged() && string.equals(string3)) {
            this.xmlApplRec.url.password = string;
            return this.xmlApplRec;
        }
        GuiInfoConsole.showError(UtilLocale.getString("TXT_PASSWORD_CONFIRMATION_FAILED"));
        this.markErrorComponent(XML_PASSWORD);
        return null;
    }

    public void markErrorComponent(String string) {
        JComponent jComponent = this.utilErrorComp.getField(string);
        if (jComponent != null) {
            this.panelTabbed.setSelectedIndex(this.utilErrorComp.getTab(string));
            this.utilErrorComp.markComponent(jComponent);
            if (string.equals(LDAP_PASSWORD)) {
                this.utilErrorComp.markComponent(this.passwordFieldLDAPPasswordConfirm);
                this.passwordFieldLDAPPassword.setInitial();
                this.passwordFieldLDAPPasswordConfirm.setInitial();
            } else if (string.equals(XML_PASSWORD)) {
                this.utilErrorComp.markComponent(this.passwordFieldXMLPasswordConfirm);
                this.passwordFieldXMLPassword.setInitial();
                this.passwordFieldXMLPasswordConfirm.setInitial();
            }
        }
    }

    public String getErrorLabelText(String string) {
        if (string == null) {
            return null;
        }
        return this.utilErrorComp.getLabelText(string);
    }

    public void setDefaultTab() {
        this.panelTabbed.setFirstTab();
    }

    public int getSelectedCorpDirRecord() {
        return this.selectedCorpDirRecord;
    }

    private static enum ActionModeEnum {
        CREATE,
        CHANGE;

    }
}

