/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.systemfeatures;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilMainPanel;
import com.aastra.oamp.systemfeatures.SysFeatCorpDirDetailPanel;
import com.aastra.oamp.systemfeatures.SysFeatCorpDirTaskPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.CorpDirDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.LDAPDataHandler;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.XMLApplicationHandler;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;

public class SysFeatCorpDirMainPanel
extends GuiUtilMainPanel
implements CorpDirDataHandler.CorpDirDataNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface {
    private static final long serialVersionUID = 1L;
    protected static final int xSizeDetailPanelSurcharge = 300;
    protected static final int ySizeDetailPanelSurcharge = 210;
    private static final int ySizeDetailPanel = 420;
    private CorpDirDataHandler corpDirDataHandler = null;
    private GuiUtilDetailSplitPanel corpDirDetailSplitPanel = null;
    private AastraScrollPane corpDirTablePanel = null;
    private SysFeatCorpDirDetailPanel corpDirDetailPanel = null;
    private SysFeatCorpDirTaskPanel corpDirTaskPanel = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private boolean detailPanelPending = false;
    private int idPending = -1;
    private int idCurrentMonitorPanel = -1;
    private int dividerLocation = 0;
    private UtilErrorComp utilErrorComp = null;
    private boolean isEditable = true;

    public SysFeatCorpDirMainPanel(GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, CorpDirDataHandler corpDirDataHandler) {
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.corpDirDataHandler = corpDirDataHandler;
        this.corpDirDataHandler.registerDataNotificationListener(this);
        this.initialize();
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilErrorComp = new UtilErrorComp();
        } else {
            this.isEditable = false;
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.getCorpDirSplitPanel(), "Center");
        this.add((Component)this.getCorpDirTaskPanel(), "East");
    }

    private GuiUtilDetailSplitPanel getCorpDirSplitPanel() {
        if (this.corpDirDetailSplitPanel == null) {
            this.corpDirDetailSplitPanel = new GuiUtilDetailSplitPanel(420);
            this.corpDirDetailSplitPanel.setTopComponent(this.getCorpTablePanel());
            this.corpDirDetailSplitPanel.setBottomComponent(null);
        }
        return this.corpDirDetailSplitPanel;
    }

    private AastraPanel getCorpDirTaskPanel() {
        if (this.corpDirTaskPanel == null) {
            this.corpDirTaskPanel = new SysFeatCorpDirTaskPanel(this, this.guiNavPanelType);
        }
        return this.corpDirTaskPanel;
    }

    private AastraScrollPane getCorpTablePanel() {
        if (this.corpDirTablePanel == null) {
            this.corpDirTablePanel = new AastraScrollPane(this.getCorpDirTable());
            this.dividerLocation = this.corpDirDetailSplitPanel.getHeight() - 420;
            this.corpDirTablePanel.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.corpDirTablePanel;
    }

    private JTable getCorpDirTable() {
        if (this.table == null) {
            int[] nArray = new int[]{3, 1, 2, 4, 5};
            this.table = this.isEditable ? new GuiUtilConfiguratorTable((Object)this, this.corpDirDataHandler.getDb(), nArray, UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthCorpDirConfig, true) : new GuiUtilConfiguratorTable((Object)this, this.corpDirDataHandler.getDb(), nArray, UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthCorpDirMonitor, 0, true);
            this.table.setIconArray(2, GuiUtilIcon.getIconArrayInactiveActive());
        }
        return this.table;
    }

    public void configureShowCorpDirRecord() {
        int n;
        CorpDirDataHandler.CorpDirRecord corpDirRecord;
        int n2 = this.table.getSelectedRow();
        if (n2 >= 0 && (corpDirRecord = this.corpDirDataHandler.getCorpDirRecordByTableIdx(n = this.table.convertRowIndexToModel(n2))) != null) {
            this.createCorpDirDetailPanel(corpDirRecord, false);
        }
    }

    private AastraPanel getCorpDirDetailPanel() {
        if (this.corpDirDetailPanel == null) {
            this.corpDirDetailPanel = new SysFeatCorpDirDetailPanel(this, this.guiNavPanelType, this.corpDirDataHandler, this.utilErrorComp);
        }
        return this.corpDirDetailPanel;
    }

    public void createCorpDirDetailPanel(CorpDirDataHandler.CorpDirRecord corpDirRecord, boolean bl) {
        if (bl) {
            this.table.removeRowSelectionAll();
        }
        if (this.corpDirDetailSplitPanel.getBottomComponent() != null) {
            if (this.isEditable) {
                this.detailPanelPending = false;
                this.utilErrorComp.clearComponents();
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating corp dir config detail panel");
            }
            this.dividerLocation = this.corpDirDetailSplitPanel.getDividerLocation();
            if (corpDirRecord == null) {
                this.corpDirDetailPanel.setDefaultTab();
            }
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating corp dir config detail panel");
            this.corpDirDetailSplitPanel.setBottomComponent(this.getCorpDirDetailPanel());
            this.corpDirDetailPanel.setDefaultTab();
        }
        if (corpDirRecord != null) {
            if (!this.isEditable) {
                this.idCurrentMonitorPanel = corpDirRecord.id;
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading corp dir entry[" + corpDirRecord.id + "]:");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + corpDirRecord.order + "','" + corpDirRecord.name + "','" + corpDirRecord.server + "'");
            this.corpDirDetailPanel.setCorpDirRecordDetailData(corpDirRecord);
        } else {
            this.corpDirDetailPanel.setCorpDirRecordDetailData(null);
        }
        this.corpDirDetailSplitPanel.setDividerLocation(this.dividerLocation);
        this.corpDirDetailSplitPanel.validate();
        this.corpDirTaskPanel.setTaskButtonConfigureShow(false);
    }

    public void removeCorpDirDetailPanel() {
        if (this.corpDirDetailSplitPanel.getBottomComponent() != null) {
            if (this.isEditable) {
                this.detailPanelPending = false;
                this.idPending = -1;
                this.utilErrorComp.clearComponents();
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing corp dir config detail panel");
            } else {
                this.idCurrentMonitorPanel = -1;
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing corp dir monitor detail panel");
            }
            this.dividerLocation = this.corpDirDetailSplitPanel.getDividerLocation();
            this.corpDirDetailSplitPanel.setBottomComponent(null);
            if (this.table.getSelectedRowCount() == 1) {
                this.corpDirTaskPanel.setTaskButtonConfigureShow(true);
            }
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Tried to remove corp dir detail panel, but there is none");
        }
    }

    public void createCorpDirRecord() {
        Object object = this.corpDirDetailPanel.getCorpDirRecordDetailData();
        if (object == null) {
            return;
        }
        this.pendingRemoveDetailPanel(-1);
        if (object instanceof LDAPDataHandler.LDAPRecord) {
            LDAPDataHandler.LDAPRecord lDAPRecord = (LDAPDataHandler.LDAPRecord)object;
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating (corp dir) LDAP record:");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + lDAPRecord.order + "','" + lDAPRecord.name + "','" + lDAPRecord.server + "'','" + lDAPRecord + "'");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + lDAPRecord.username + "','" + lDAPRecord.searchBase + "','" + (Object)((Object)lDAPRecord.searchType) + "'");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + (Object)((Object)lDAPRecord.displayType) + "','" + lDAPRecord.timeout + "','" + lDAPRecord.active + "'");
            this.corpDirDataHandler.sendCreateLDAP(lDAPRecord);
            return;
        }
        if (object instanceof XMLApplicationHandler.XMLApplRec) {
            XMLApplicationHandler.XMLApplRec xMLApplRec = (XMLApplicationHandler.XMLApplRec)object;
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating (corp dir) XML appl record:");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + xMLApplRec.enable + ",'" + xMLApplRec.type.name() + ",'" + xMLApplRec.name + "'");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + (Object)((Object)xMLApplRec.url.protocol) + ",'" + xMLApplRec.url.host + "','" + xMLApplRec.url.username + "'");
            if (xMLApplRec.url.passwordChanged) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + xMLApplRec.url.password + "'");
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + xMLApplRec.url.path + "'");
            this.corpDirDataHandler.sendCreateXMLAppl(xMLApplRec);
            return;
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "createCorpDirRecord returns invalid object");
    }

    public void changeCorpDirRecord() {
        Object object = this.corpDirDetailPanel.getCorpDirRecordDetailData();
        if (object == null) {
            return;
        }
        if (object instanceof LDAPDataHandler.LDAPRecord) {
            LDAPDataHandler.LDAPRecord lDAPRecord = (LDAPDataHandler.LDAPRecord)object;
            this.pendingRemoveDetailPanel(this.corpDirDataHandler.getCorpDirIdByLDAPId(lDAPRecord.id));
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Changing LDAP record[" + lDAPRecord.id + "]:");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + lDAPRecord.order + "','" + lDAPRecord.name + "','" + lDAPRecord.server + "'','" + lDAPRecord.port + "'");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + lDAPRecord.username + "','" + lDAPRecord.searchBase + "','" + (Object)((Object)lDAPRecord.searchType) + "'");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + (Object)((Object)lDAPRecord.displayType) + "','" + lDAPRecord.timeout + "','" + lDAPRecord.active + "'");
            this.corpDirDataHandler.sendSetLDAP(lDAPRecord);
            return;
        }
        if (object instanceof XMLApplicationHandler.XMLApplRec) {
            XMLApplicationHandler.XMLApplRec xMLApplRec = (XMLApplicationHandler.XMLApplRec)object;
            this.pendingRemoveDetailPanel(this.corpDirDataHandler.getCorpDirIdByXMLId(xMLApplRec.id));
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Changing (corp dir) XML application[" + xMLApplRec.id + "]:");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + xMLApplRec.enable + ",'" + xMLApplRec.type.name() + ",'" + xMLApplRec.name + "'");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + (Object)((Object)xMLApplRec.url.protocol) + ",'" + xMLApplRec.url.host + "','" + xMLApplRec.url.username + "'");
            if (xMLApplRec.url.passwordChanged) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + xMLApplRec.url.password + "'");
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + xMLApplRec.url.path + "'");
            this.corpDirDataHandler.sendSetXMLAppl(xMLApplRec);
            return;
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "changeCorpDirRecord returns invalid object");
    }

    public void deleteCorpDirRecords() {
        GuiUtilDialog guiUtilDialog;
        int n = this.table.getSelectedRowCount();
        if (n > 0 && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_DELETE_SELECTED_DIRECTORY_ENTRIES_?"), true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            int[] nArray = this.table.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = this.table.convertRowIndexToModel(nArray[i]);
                CorpDirDataHandler.CorpDirRecord corpDirRecord = this.corpDirDataHandler.getCorpDirRecordByTableIdx(n2);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Deleting corp dir record[" + corpDirRecord.id + "]");
                if (corpDirRecord.type == CorpDirDataHandler.CorpDirTypeType.LDAP) {
                    this.corpDirDataHandler.sendDeleteLDAP(corpDirRecord.relatedId);
                } else {
                    this.corpDirDataHandler.sendDeleteXMLAppl(corpDirRecord.relatedId);
                }
                if (this.corpDirDetailSplitPanel.getBottomComponent() == null || this.corpDirDetailPanel.getSelectedCorpDirRecord() != corpDirRecord.id) continue;
                this.pendingRemoveDetailPanel(corpDirRecord.id);
            }
        }
    }

    public void pendingRemoveDetailPanel(int n) {
        this.detailPanelPending = true;
        this.idPending = n;
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        CorpDirDataHandler.CorpDirRecord corpDirRecord = (CorpDirDataHandler.CorpDirRecord)dataRecord;
        this.createCorpDirDetailPanel(corpDirRecord, false);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    private void processTableEvent(DataRecord dataRecord) {
        int n = this.table.getSelectedRowCount();
        if (this.corpDirDetailSplitPanel.getBottomComponent() != null) {
            if (dataRecord != null) {
                CorpDirDataHandler.CorpDirRecord corpDirRecord = (CorpDirDataHandler.CorpDirRecord)dataRecord;
                this.createCorpDirDetailPanel(corpDirRecord, false);
            } else {
                this.removeCorpDirDetailPanel();
            }
        } else if (n == 1) {
            this.corpDirTaskPanel.setTaskButtonConfigureShow(true);
        } else {
            this.corpDirTaskPanel.setTaskButtonConfigureShow(false);
        }
        if (this.isEditable) {
            if (n >= 1) {
                this.corpDirTaskPanel.setTaskButtonDelete(true);
            } else {
                this.corpDirTaskPanel.setTaskButtonDelete(false);
            }
        }
        this.updateTableInfo();
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        if (this.corpDirDetailSplitPanel.getBottomComponent() != null && this.table.getSelectedRowCount() > 1) {
            this.removeCorpDirDetailPanel();
        }
        this.corpDirTaskPanel.setTaskButtonConfigureShow(false);
    }

    @Override
    public void processCorpDirDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        block18: {
            block17: {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Corp dir data notification: " + dataNotificationEnum.toString() + "," + n);
                if (!this.isEditable) break block17;
                switch (dataNotificationEnum) {
                    case NEW_DATA: {
                        if (this.table.getRowCount() < 5) {
                            this.corpDirTaskPanel.setTaskButtonCreate(true);
                        } else {
                            this.corpDirTaskPanel.setTaskButtonCreate(false);
                        }
                        if (this.detailPanelPending && (dataNotificationEnum == DataNotificationEnum.NEW_DATA || dataNotificationEnum == DataNotificationEnum.DATA_CHANGED && this.idPending == n)) {
                            this.removeCorpDirDetailPanel();
                            break;
                        }
                        break block18;
                    }
                    case DATA_CHANGED: {
                        if (this.detailPanelPending && (dataNotificationEnum == DataNotificationEnum.NEW_DATA || dataNotificationEnum == DataNotificationEnum.DATA_CHANGED && this.idPending == n)) {
                            this.removeCorpDirDetailPanel();
                            break;
                        }
                        break block18;
                    }
                    case DATA_DELETED: {
                        if (this.table.getRowCount() < 5) {
                            this.corpDirTaskPanel.setTaskButtonCreate(true);
                        } else {
                            this.corpDirTaskPanel.setTaskButtonCreate(false);
                        }
                        if (this.detailPanelPending && this.idPending == n) {
                            this.removeCorpDirDetailPanel();
                            break;
                        }
                        break block18;
                    }
                }
                break block18;
            }
            if (n == this.idCurrentMonitorPanel) {
                switch (dataNotificationEnum) {
                    case NEW_DATA: 
                    case DATA_CHANGED: {
                        CorpDirDataHandler.CorpDirRecord corpDirRecord = this.corpDirDataHandler.getCorpDirRecordById(n);
                        if (corpDirRecord == null) break;
                        this.createCorpDirDetailPanel(corpDirRecord, false);
                        break;
                    }
                    case DATA_DELETED: {
                        this.removeCorpDirDetailPanel();
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void processCorpDirErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        String string4 = omiMessage.getAttribVal(OmiMessage.attribIds.info.name());
        OmiMessage.errorCodes errorCodes2 = null;
        if (string == null || this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_MONITOR || !this.componentActivated) {
            return;
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Corp dir error notification: " + dataNotificationEnum.toString() + ",id=" + n + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Corp dir error notification: Unknown errorCode=" + string);
        }
        switch (dataNotificationEnum) {
            case NEW_DATA: 
            case DATA_CHANGED: {
                if (errorCodes2 != null) {
                    String string5 = null;
                    if (string2 != null) {
                        string5 = this.corpDirDetailPanel.getErrorLabelText(string2);
                    }
                    GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, string5, string3));
                } else {
                    GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
                }
                if (string2 == null) break;
                if (string2.equals(OmiMessage.URLType.password.name())) {
                    string2 = string4.contains("ldap") ? "ldapPassword" : "xmlPassword";
                }
                this.corpDirDetailPanel.markErrorComponent(string2);
                break;
            }
            case DATA_DELETED: {
                if (errorCodes2 != null) {
                    GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, null, null));
                    break;
                }
                GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
                break;
            }
        }
    }
}

