/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.systemfeatures;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilMainPanel;
import com.aastra.oamp.systemfeatures.SysFeatDigitTreatmentDetailPanel;
import com.aastra.oamp.systemfeatures.SysFeatDigitTreatmentTaskPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.DigitTreatmentHandlerExpanded;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.SiteDataHandler;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

public class SysFeatDigitTreatmentMainPanel
extends GuiUtilMainPanel
implements DigitTreatmentHandlerExpanded.DigitTreatmentDataNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface {
    private static final long serialVersionUID = 1L;
    protected static final int xSizeDetailPanelSurcharge = 240;
    protected static final int ySizeDetailPanelSurcharge = 120;
    private static final int ySizeDetailPanel = 330;
    private DigitTreatmentHandlerExpanded digitTreatmentHandler = null;
    private SiteDataHandler siteDataHandler = null;
    private SysFeatDigitTreatmentTaskPanel taskPanel = null;
    private SysFeatDigitTreatmentDetailPanel detailPanel = null;
    private GuiUtilDetailSplitPanel detailSplitPane = null;
    private AastraScrollPane tablePane = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType;
    private int dividerLocation = 0;
    private int idCurrentMonitorPanel = -1;
    private int idPending = -1;
    private boolean detailPanelPending = false;
    private UtilErrorComp utilErrorComp = null;
    private boolean isEditable = true;

    public SysFeatDigitTreatmentMainPanel(GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, DigitTreatmentHandlerExpanded digitTreatmentHandlerExpanded, SiteDataHandler siteDataHandler) {
        this.digitTreatmentHandler = digitTreatmentHandlerExpanded;
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.siteDataHandler = siteDataHandler;
        this.digitTreatmentHandler.registerDataNotificationListener(this);
        this.initialize();
    }

    public SysFeatDigitTreatmentMainPanel(GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, DigitTreatmentHandlerExpanded digitTreatmentHandlerExpanded) {
        this.digitTreatmentHandler = digitTreatmentHandlerExpanded;
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.digitTreatmentHandler.registerDataNotificationListener(this);
        this.initialize();
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilErrorComp = new UtilErrorComp();
        } else {
            this.isEditable = false;
        }
        DigitTreatmentHandlerExpanded.setStrAllSites(UtilLocale.getString("TXT_ALL"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getDetailSplitPane(), "Center");
        this.add((Component)this.getTaskPanel(), "East");
    }

    private void enableTableAccess() {
        this.table.setActive(true);
        if (this.isEditable) {
            this.taskPanel.setTaskButtonCreate(true);
        }
    }

    private void disableTableAccess() {
        this.table.setActive(false);
        this.taskPanel.setTaskButtonConfigureShow(false);
        if (this.isEditable) {
            this.taskPanel.setTaskButtonCreate(false);
            this.taskPanel.setTaskButtonDelete(false);
        }
    }

    private AastraPanel getTaskPanel() {
        if (this.taskPanel == null) {
            this.taskPanel = new SysFeatDigitTreatmentTaskPanel(this, this.guiNavPanelType);
        }
        return this.taskPanel;
    }

    private AastraPanel getDetailPanel() {
        if (this.detailPanel == null) {
            this.detailPanel = new SysFeatDigitTreatmentDetailPanel(this, this.guiNavPanelType, this.siteDataHandler, this.utilErrorComp);
        }
        return this.detailPanel;
    }

    public void createDetailPanel(DigitTreatmentHandlerExpanded.DigitTreatment digitTreatment, boolean bl) {
        if (bl) {
            this.table.removeRowSelectionAll();
        }
        if (this.detailSplitPane.getBottomComponent() != null) {
            if (this.isEditable) {
                this.detailPanelPending = false;
                this.utilErrorComp.clearComponents();
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating digit treatment config detail panel");
            }
            this.dividerLocation = this.detailSplitPane.getDividerLocation();
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating digit treatment config detail panel");
            this.detailSplitPane.setBottomComponent(this.getDetailPanel());
        }
        if (digitTreatment != null) {
            if (!this.isEditable) {
                this.idCurrentMonitorPanel = digitTreatment.id;
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading digit treatment[" + digitTreatment.id + "]:");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + digitTreatment.extPattern + "','" + digitTreatment.intPattern + "','" + digitTreatment.directory + (Object)((Object)digitTreatment.direction) + digitTreatment.sites + "'");
            this.detailPanel.setDetailData(digitTreatment);
        } else {
            this.detailPanel.setDetailData(null);
        }
        this.detailSplitPane.setDividerLocation(this.dividerLocation);
        this.detailSplitPane.validate();
        this.taskPanel.setTaskButtonConfigureShow(false);
    }

    public void removeDetailPanel() {
        if (this.detailSplitPane.getBottomComponent() != null) {
            if (this.isEditable) {
                this.detailPanelPending = false;
                this.idPending = -1;
                this.utilErrorComp.clearComponents();
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing digit treatment config detail panel");
            } else {
                this.idCurrentMonitorPanel = -1;
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing digit treatment monitor detail panel");
            }
            this.dividerLocation = this.detailSplitPane.getDividerLocation();
            this.detailSplitPane.setBottomComponent(null);
            if (this.table.getSelectedRowCount() == 1) {
                this.taskPanel.setTaskButtonConfigureShow(true);
            }
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Tried to remove digit treatment detail panel, but there is none");
        }
    }

    public void configureShowDigitTreatment() {
        int n;
        DigitTreatmentHandlerExpanded.DigitTreatment digitTreatment;
        int n2 = this.table.getSelectedRow();
        if (n2 >= 0 && (digitTreatment = this.digitTreatmentHandler.getDigitTreatmentByTableIdx(n = this.table.convertRowIndexToModel(n2))) != null) {
            this.createDetailPanel(digitTreatment, false);
        }
    }

    private void processTableEvent(DataRecord dataRecord) {
        int n = this.table.getSelectedRowCount();
        if (this.detailSplitPane.getBottomComponent() != null) {
            if (dataRecord != null) {
                int n2 = (Integer)dataRecord.getField(0);
                DigitTreatmentHandlerExpanded.DigitTreatment digitTreatment = this.digitTreatmentHandler.getDigitTreatmentByDigitTreatmentId(n2);
                this.createDetailPanel(digitTreatment, false);
            } else {
                this.removeDetailPanel();
            }
        } else if (n == 1) {
            this.taskPanel.setTaskButtonConfigureShow(true);
        } else {
            this.taskPanel.setTaskButtonConfigureShow(false);
        }
        if (this.isEditable) {
            if (n >= 1) {
                this.taskPanel.setTaskButtonDelete(true);
            } else {
                this.taskPanel.setTaskButtonDelete(false);
            }
        }
        this.updateTableInfo();
    }

    public void createDigitTreatment() {
        DigitTreatmentHandlerExpanded.DigitTreatment digitTreatment = this.detailPanel.getDetailData();
        this.pendingRemoveDetailPanel(-1);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating digit treatment:");
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + digitTreatment.extPattern + "','" + digitTreatment.extPattern + "','" + digitTreatment.directory + "'" + digitTreatment.direction.name() + "'" + digitTreatment.sites + "'");
        this.digitTreatmentHandler.sendCreateDigitTreatment(digitTreatment);
    }

    public void changeDigitTreatment() {
        DigitTreatmentHandlerExpanded.DigitTreatment digitTreatment = this.detailPanel.getDetailData();
        this.pendingRemoveDetailPanel(digitTreatment.id);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Changing digit treatment[" + digitTreatment.id + "]:");
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + digitTreatment.extPattern + "','" + digitTreatment.extPattern + "','" + digitTreatment.directory + "'" + digitTreatment.direction.name() + "'" + digitTreatment.sites + "'");
        this.digitTreatmentHandler.sendSetDigitTreatment(digitTreatment);
    }

    public void pendingRemoveDetailPanel(int n) {
        this.detailPanelPending = true;
        this.idPending = n;
    }

    public void deleteDigitTreatment() {
        GuiUtilDialog guiUtilDialog;
        int n = this.table.getSelectedRowCount();
        if (n > 0 && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_DELETE_SELECTED_DIGIT_TREATMENT_ENTRIES_?"), true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            int[] nArray = this.table.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = this.table.convertRowIndexToModel(nArray[i]);
                DigitTreatmentHandlerExpanded.DigitTreatment digitTreatment = this.digitTreatmentHandler.getDigitTreatmentByTableIdx(n2);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Deleting digit treatment entry[" + digitTreatment.id + "]");
                this.digitTreatmentHandler.sendDeleteDigitTreatment(digitTreatment.id);
                if (this.detailSplitPane.getBottomComponent() == null || this.detailPanel.getSelectedDigitTreatment() != digitTreatment.id) continue;
                this.detailPanelPending = true;
                this.idPending = digitTreatment.id;
            }
        }
    }

    private GuiUtilDetailSplitPanel getDetailSplitPane() {
        if (this.detailSplitPane == null) {
            this.detailSplitPane = new GuiUtilDetailSplitPanel(330);
            this.detailSplitPane.setTopComponent(this.getTablePane());
            this.detailSplitPane.setBottomComponent(null);
        }
        return this.detailSplitPane;
    }

    private AastraScrollPane getTablePane() {
        if (this.tablePane == null) {
            this.tablePane = new AastraScrollPane(this.getTable());
            this.dividerLocation = this.detailSplitPane.getHeight() - 330;
            this.tablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.tablePane;
    }

    private GuiUtilConfiguratorTable getTable() {
        if (this.table == null) {
            int[] nArray = new int[]{0, 1, 2, 3, 4, 5};
            this.table = this.isEditable ? new GuiUtilConfiguratorTable((Object)this, this.digitTreatmentHandler.getDb(), nArray, UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthDigitTreatmentConfig, true) : new GuiUtilConfiguratorTable((Object)this, this.digitTreatmentHandler.getDb(), nArray, UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthDigitTreatmentMonitor, 0, true);
            this.table.setIconArray(3, GuiUtilIcon.getIconArrayDigitTreatmentDirection());
            this.table.setIconArray(4, GuiUtilIcon.getIconArrayInactiveActive());
        }
        return this.table;
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        int n = (Integer)dataRecord.getField(0);
        DigitTreatmentHandlerExpanded.DigitTreatment digitTreatment = this.digitTreatmentHandler.getDigitTreatmentByDigitTreatmentId(n);
        this.createDetailPanel(digitTreatment, false);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        if (this.detailSplitPane.getBottomComponent() != null && this.table.getSelectedRowCount() > 1) {
            this.removeDetailPanel();
        }
        this.taskPanel.setTaskButtonConfigureShow(false);
    }

    @Override
    public void processDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Digit treatment data notification: " + dataNotificationEnum.toString() + "," + n);
        block0 : switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                break;
            }
            default: {
                if (this.isEditable) {
                    switch (dataNotificationEnum) {
                        case NEW_DATA: 
                        case DATA_CHANGED: {
                            if (!this.detailPanelPending || dataNotificationEnum != DataNotificationEnum.NEW_DATA && (dataNotificationEnum != DataNotificationEnum.DATA_CHANGED || this.idPending != n)) break block0;
                            this.removeDetailPanel();
                            break;
                        }
                        case DATA_DELETED: {
                            if (!this.detailPanelPending || this.idPending != n) break block0;
                            this.removeDetailPanel();
                            break;
                        }
                    }
                    break;
                }
                if (n != this.idCurrentMonitorPanel) break;
                switch (dataNotificationEnum) {
                    case NEW_DATA: 
                    case DATA_CHANGED: {
                        DigitTreatmentHandlerExpanded.DigitTreatment digitTreatment = this.digitTreatmentHandler.getDigitTreatmentByDigitTreatmentId(n);
                        if (digitTreatment != null) {
                            this.createDetailPanel(digitTreatment, false);
                            break block0;
                        }
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading digit treatment[" + n + "] failed");
                        break block0;
                    }
                    case DATA_DELETED: {
                        this.removeDetailPanel();
                        break block0;
                    }
                }
            }
        }
    }

    @Override
    public void processErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        String string4 = omiMessage.getAttribVal(OmiMessage.attribIds.seq.name());
        OmiMessage.errorCodes errorCodes2 = null;
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_MONITOR || string == null) {
            return;
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Digit treatment error notification: " + dataNotificationEnum.toString() + ",id=" + n + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3 + ",seq=" + string4);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Digit treatment error notification: Unknown errorCode=" + string);
        }
        switch (dataNotificationEnum) {
            case NEW_DATA: 
            case DATA_CHANGED: {
                if (errorCodes2 != null) {
                    String string5 = null;
                    if (string2 != null) {
                        string5 = this.detailPanel.getErrorLabelText(string2);
                    }
                    GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, string5, string3));
                } else {
                    GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
                }
                if (string2 == null) break;
                this.detailPanel.markErrorComponent(string2);
                break;
            }
            case DATA_DELETED: {
                if (errorCodes2 != null) {
                    GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, null, null));
                    break;
                }
                GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
                break;
            }
        }
    }
}

