/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.systemfeatures;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.guiutil.GuiUtilCheckBox;
import com.aastra.oamp.guiutil.GuiUtilComboBox;
import com.aastra.oamp.guiutil.GuiUtilDetailPanel;
import com.aastra.oamp.guiutil.GuiUtilPasswordFieldNew;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.systemfeatures.SysFeatDirectoryMainPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.CorporateDirectoryHandler;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SysFeatDirectoryDetailPanel
extends GuiUtilDetailPanel {
    private static final long serialVersionUID = 1L;
    private static final int TAB_GENERAL = 0;
    private static final int TAB_URL = 1;
    SysFeatDirectoryMainPanel directoryMainPanel = null;
    GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    CorporateDirectoryHandler corporateDirectoryHandler = null;
    UtilErrorComp utilErrorComp = null;
    private GuiUtilChangeHandler utilChangeHandler = null;
    private int selectedDirectoryRecordId = 0;
    private String lastType = null;
    private AastraButton buttonOK = null;
    private AastraButton buttonCancel = null;
    private boolean isEditable = false;
    private AastraPanel tabGeneral = null;
    private GuiUtilComboBox comboBoxType = null;
    private boolean actionListenerTypeActive = false;
    private GuiUtilCheckBox checkBoxActive = null;
    private GuiUtilTextField textFieldName = null;
    private GuiUtilTextField textFieldLDAPSearchBase = null;
    private GuiUtilComboBox comboBoxLDAPSearchType = null;
    private GuiUtilComboBox comboBoxLDAPDisplayType = null;
    private GuiUtilTextField textFieldLDAPTimeout = null;
    private AastraPanel tabUrl = null;
    private GuiUtilComboBox comboBoxProtocol = null;
    private GuiUtilTextField textFieldPort = null;
    private GuiUtilCheckBox checkBoxUseDefaultPort = null;
    private GuiUtilTextField textFieldServer = null;
    private GuiUtilTextField textFieldUserName = null;
    private GuiUtilPasswordFieldNew passwordFieldPassword = null;
    private GuiUtilPasswordFieldNew passwordFieldPasswordConfirm = null;
    private GuiUtilTextField textFieldPath = null;
    private GuiUtilCheckBox checkBoxUseCommonCerts = null;

    public SysFeatDirectoryDetailPanel(SysFeatDirectoryMainPanel sysFeatDirectoryMainPanel, GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, CorporateDirectoryHandler corporateDirectoryHandler, UtilErrorComp utilErrorComp) {
        super(300, 210);
        this.directoryMainPanel = sysFeatDirectoryMainPanel;
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.corporateDirectoryHandler = corporateDirectoryHandler;
        this.utilErrorComp = utilErrorComp;
        this.initialize();
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.isEditable = true;
            this.utilChangeHandler = new GuiUtilChangeHandler(this.getButtonOK(), this.getButtonCancel(), false);
            this.panelButtonBar.add(this.getButtonOK());
        }
        this.panelTabbed.addTab(UtilLocale.getString("TXT_GENERAL_20"), this.getTabGeneral());
        this.panelTabbed.addTab(UtilLocale.getString("TXT_URL"), this.getTabUrl());
        this.panelButtonBar.add(this.getButtonCancel());
    }

    private AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            this.buttonOK.setBounds(70, 15, 90, 25);
            this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOK.setEnabled(false);
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SysFeatDirectoryDetailPanel.this.utilChangeHandler.deactivate();
                    SysFeatDirectoryDetailPanel.this.utilErrorComp.clearComponents();
                    SysFeatDirectoryDetailPanel.this.directoryMainPanel.changeDirectoryRecord();
                }
            });
        }
        return this.buttonOK;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            if (this.isEditable) {
                this.buttonCancel.setBounds(230, 15, 90, 25);
            } else {
                this.buttonCancel.setBounds(150, 15, 90, 25);
            }
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SysFeatDirectoryDetailPanel.this.isEditable) {
                        SysFeatDirectoryDetailPanel.this.utilChangeHandler.deactivate();
                    }
                    SysFeatDirectoryDetailPanel.this.directoryMainPanel.removeDirectoryDetailPanel();
                }
            });
        }
        return this.buttonCancel;
    }

    private AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            this.tabGeneral = new AastraPanel();
            this.tabGeneral.setLayout(null);
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(30, 15, 120, 16);
            aastraLabel.setText(UtilLocale.getString("TXT_TYPE"));
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setBounds(30, 45, 120, 16);
            aastraLabel2.setText(UtilLocale.getString("TXT_ACTIVE"));
            AastraLabel aastraLabel3 = new AastraLabel();
            aastraLabel3.setBounds(30, 75, 120, 16);
            aastraLabel3.setText(UtilLocale.getString("TXT_NAME"));
            AastraLabel aastraLabel4 = new AastraLabel();
            aastraLabel4.setBounds(30, 105, 120, 16);
            aastraLabel4.setText(UtilLocale.getString("TXT_SEARCH_BASE"));
            AastraLabel aastraLabel5 = new AastraLabel();
            aastraLabel5.setBounds(30, 135, 120, 16);
            aastraLabel5.setText(UtilLocale.getString("TXT_SEARCH_TYPE"));
            AastraLabel aastraLabel6 = new AastraLabel();
            aastraLabel6.setBounds(30, 165, 120, 16);
            aastraLabel6.setText(UtilLocale.getString("TXT_DISPLAY_TYPE"));
            AastraLabel aastraLabel7 = new AastraLabel();
            aastraLabel7.setBounds(30, 195, 120, 31);
            aastraLabel7.setTextHtml(UtilLocale.getString("TXT_SERVER_SEARCH_TIMEOUT"));
            AastraLabel aastraLabel8 = new AastraLabel();
            aastraLabel8.setBounds(240, 195, 45, 16);
            aastraLabel8.setText(UtilLocale.getString("TXT_UNIT_SECOND"));
            this.tabGeneral.add(aastraLabel);
            this.tabGeneral.add(this.getComboBoxType());
            this.tabGeneral.add(aastraLabel2);
            this.tabGeneral.add(this.getCheckBoxActive());
            this.tabGeneral.add(aastraLabel3);
            this.tabGeneral.add(this.getTextFieldName());
            this.tabGeneral.add(aastraLabel4);
            this.tabGeneral.add(this.getTextFieldLDAPSearchBase());
            this.tabGeneral.add(aastraLabel5);
            this.tabGeneral.add(this.getComboBoxLDAPSearchType());
            this.tabGeneral.add(aastraLabel6);
            this.tabGeneral.add(this.getComboBoxLDAPDisplayType());
            this.tabGeneral.add((Component)aastraLabel7, null);
            this.tabGeneral.add((Component)this.getTextFieldLDAPTimeout(), null);
            this.tabGeneral.add((Component)aastraLabel8, null);
            if (this.isEditable) {
                this.utilErrorComp.putWithTab(OmiMessage.CorporateDirectoryType.name.name(), aastraLabel3, this.textFieldName, 0);
                this.utilErrorComp.putWithTab(OmiMessage.CorporateDirectoryType.searchBase.name(), aastraLabel4, this.textFieldLDAPSearchBase, 0);
                this.utilErrorComp.putWithTab(OmiMessage.CorporateDirectoryType.timeout.name(), aastraLabel7, this.textFieldLDAPTimeout, 0);
            } else {
                UtilSetPanelEditable.setDisabled(this.tabGeneral);
            }
        }
        return this.tabGeneral;
    }

    private GuiUtilComboBox getComboBoxType() {
        if (this.comboBoxType == null) {
            this.comboBoxType = new GuiUtilComboBox();
            this.comboBoxType.setBounds(170, 15, 170, 20);
            for (int i = 0; i < OmiMessage.CorporateDirectoryTypeType.values().length; ++i) {
                this.comboBoxType.addItem(OmiMessage.CorporateDirectoryTypeType.values()[i].getText());
            }
            this.comboBoxType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SysFeatDirectoryDetailPanel.this.actionListenerTypeActive) {
                        String string = (String)((GuiUtilComboBox)actionEvent.getSource()).getSelectedItem();
                        if (string.equals(OmiMessage.CorporateDirectoryTypeType.LDAP.getText())) {
                            SysFeatDirectoryDetailPanel.this.comboBoxProtocol.setSelectedItem(null);
                            SysFeatDirectoryDetailPanel.this.comboBoxProtocol.setEnabled(false);
                        } else if (SysFeatDirectoryDetailPanel.this.lastType.equals(OmiMessage.CorporateDirectoryTypeType.LDAP.getText())) {
                            SysFeatDirectoryDetailPanel.this.comboBoxProtocol.setSelectedItem((Object)OmiMessage.ProtType.HTTP);
                            SysFeatDirectoryDetailPanel.this.comboBoxProtocol.setEnabled(true);
                        }
                        SysFeatDirectoryDetailPanel.this.lastType = string;
                        SysFeatDirectoryDetailPanel.this.utilChangeHandler.activate();
                    }
                }
            });
            this.actionListenerTypeActive = true;
        }
        return this.comboBoxType;
    }

    private GuiUtilCheckBox getCheckBoxActive() {
        if (this.checkBoxActive == null) {
            this.checkBoxActive = new GuiUtilCheckBox(this.utilChangeHandler, 165, 45);
        }
        return this.checkBoxActive;
    }

    private GuiUtilTextField getTextFieldName() {
        if (this.textFieldName == null) {
            this.textFieldName = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldName.setBounds(170, 75, 160, 18);
        }
        return this.textFieldName;
    }

    private GuiUtilTextField getTextFieldLDAPSearchBase() {
        if (this.textFieldLDAPSearchBase == null) {
            this.textFieldLDAPSearchBase = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldLDAPSearchBase.setBounds(170, 105, 400, 18);
        }
        return this.textFieldLDAPSearchBase;
    }

    private GuiUtilComboBox getComboBoxLDAPSearchType() {
        if (this.comboBoxLDAPSearchType == null) {
            this.comboBoxLDAPSearchType = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxLDAPSearchType.setBounds(170, 135, 170, 20);
            this.comboBoxLDAPSearchType.addItem(UtilLocale.getString("TXT_SURNAME"));
            this.comboBoxLDAPSearchType.addItem(UtilLocale.getString("TXT_GIVEN_NAME"));
            this.comboBoxLDAPSearchType.activateActionListener();
        }
        return this.comboBoxLDAPSearchType;
    }

    private GuiUtilComboBox getComboBoxLDAPDisplayType() {
        if (this.comboBoxLDAPDisplayType == null) {
            this.comboBoxLDAPDisplayType = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxLDAPDisplayType.setBounds(170, 165, 170, 20);
            this.comboBoxLDAPDisplayType.addItem(UtilLocale.getString("TXT_SURNAME_GIVEN_NAME"));
            this.comboBoxLDAPDisplayType.addItem(UtilLocale.getString("TXT_GIVEN_NAME_AND_SURNAME"));
            this.comboBoxLDAPDisplayType.activateActionListener();
        }
        return this.comboBoxLDAPDisplayType;
    }

    private GuiUtilTextField getTextFieldLDAPTimeout() {
        if (this.textFieldLDAPTimeout == null) {
            this.textFieldLDAPTimeout = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldLDAPTimeout.setBounds(170, 195, 60, 18);
        }
        return this.textFieldLDAPTimeout;
    }

    private AastraPanel getTabUrl() {
        if (this.tabUrl == null) {
            this.tabUrl = new AastraPanel();
            this.tabUrl.setLayout(null);
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(30, 15, 130, 16);
            aastraLabel.setText(UtilLocale.getString("TXT_PROTOCOL"));
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setBounds(30, 45, 130, 16);
            aastraLabel2.setText(UtilLocale.getString("TXT_PORT"));
            AastraLabel aastraLabel3 = new AastraLabel();
            aastraLabel3.setBounds(250, 45, 145, 16);
            aastraLabel3.setText(UtilLocale.getString("TXT_USE_DEFAULT_PORT"));
            aastraLabel3.setHorizontalAlignment(4);
            AastraLabel aastraLabel4 = new AastraLabel();
            aastraLabel4.setBounds(30, 75, 130, 16);
            aastraLabel4.setText(UtilLocale.getString("TXT_SERVER"));
            AastraLabel aastraLabel5 = new AastraLabel();
            aastraLabel5.setBounds(30, 105, 130, 16);
            aastraLabel5.setText(UtilLocale.getString("TXT_USER_NAME"));
            AastraLabel aastraLabel6 = new AastraLabel();
            aastraLabel6.setBounds(30, 135, 130, 16);
            aastraLabel6.setText(UtilLocale.getString("TXT_PASSWORD"));
            AastraLabel aastraLabel7 = new AastraLabel();
            aastraLabel7.setBounds(30, 165, 130, 32);
            aastraLabel7.setText("<html>" + UtilLocale.getString("TXT_PASSWORD_CONFIRMATION") + "</html>");
            AastraLabel aastraLabel8 = new AastraLabel();
            aastraLabel8.setBounds(30, 195, 130, 32);
            aastraLabel8.setText("<html>" + UtilLocale.getString("TXT_PATH_AND_PARAMETERS") + "</html>");
            AastraLabel aastraLabel9 = new AastraLabel();
            aastraLabel9.setBounds(30, 225, 130, 48);
            aastraLabel9.setText("<html>" + UtilLocale.getString("TXT_USE_COMMON_CERTIFICATES") + "</html>");
            this.tabUrl.add(aastraLabel);
            this.tabUrl.add(this.getComboBoxProtocol());
            this.tabUrl.add(aastraLabel2);
            this.tabUrl.add(this.getTextFieldPort());
            this.tabUrl.add(aastraLabel3);
            this.tabUrl.add(this.getCheckBoxUseDefaultPort());
            this.tabUrl.add(aastraLabel4);
            this.tabUrl.add(this.getTextFieldServer());
            this.tabUrl.add(aastraLabel5);
            this.tabUrl.add(this.getTextFieldUserName());
            this.tabUrl.add(aastraLabel6);
            this.tabUrl.add(this.getPasswordFieldPassword());
            this.tabUrl.add(aastraLabel7);
            this.tabUrl.add(this.getPasswordFieldPasswordConfirm());
            this.tabUrl.add(aastraLabel8);
            this.tabUrl.add(this.getTextFieldPath());
            this.tabUrl.add(aastraLabel9);
            this.tabUrl.add((Component)this.getCheckBoxUseCommonCerts(), null);
            if (this.isEditable) {
                this.utilErrorComp.putWithTab(OmiMessage.URLType.port.name(), aastraLabel2, this.textFieldPort, 1);
                this.utilErrorComp.putWithTab(OmiMessage.URLType.host.name(), aastraLabel4, this.textFieldServer, 1);
                this.utilErrorComp.putWithTab(OmiMessage.URLType.username.name(), aastraLabel5, this.textFieldUserName, 1);
                this.utilErrorComp.putWithTab(OmiMessage.URLType.password.name(), aastraLabel6, this.passwordFieldPassword, 1);
                this.utilErrorComp.putWithTab(OmiMessage.URLType.path.name(), aastraLabel8, this.textFieldPath, 1);
            } else {
                UtilSetPanelEditable.setDisabled(this.tabUrl);
            }
        }
        return this.tabUrl;
    }

    private GuiUtilComboBox getComboBoxProtocol() {
        if (this.comboBoxProtocol == null) {
            this.comboBoxProtocol = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxProtocol.setBounds(170, 15, 90, 20);
            if (OmiMessage.ProtType.HTTP.isValid().booleanValue()) {
                this.comboBoxProtocol.addItem(OmiMessage.ProtType.HTTP);
            }
            if (OmiMessage.ProtType.HTTPS.isValid().booleanValue()) {
                this.comboBoxProtocol.addItem(OmiMessage.ProtType.HTTPS);
            }
            if (this.isEditable) {
                this.comboBoxProtocol.activateActionListener();
            } else {
                this.comboBoxProtocol.setEnabled(false);
            }
        }
        return this.comboBoxProtocol;
    }

    private GuiUtilTextField getTextFieldPort() {
        if (this.textFieldPort == null) {
            this.textFieldPort = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldPort.setBounds(170, 45, 70, 18);
        }
        return this.textFieldPort;
    }

    private GuiUtilCheckBox getCheckBoxUseDefaultPort() {
        if (this.checkBoxUseDefaultPort == null) {
            this.checkBoxUseDefaultPort = new GuiUtilCheckBox(this.utilChangeHandler, 395, 42);
            if (this.isEditable) {
                this.checkBoxUseDefaultPort.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        if (SysFeatDirectoryDetailPanel.this.checkBoxUseDefaultPort.isSelected()) {
                            SysFeatDirectoryDetailPanel.this.textFieldPort.setText("");
                            SysFeatDirectoryDetailPanel.this.textFieldPort.setEnabled(false);
                        } else {
                            SysFeatDirectoryDetailPanel.this.textFieldPort.setEnabled(true);
                        }
                    }
                });
            }
        }
        return this.checkBoxUseDefaultPort;
    }

    private GuiUtilTextField getTextFieldServer() {
        if (this.textFieldServer == null) {
            this.textFieldServer = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldServer.setBounds(170, 75, 400, 18);
        }
        return this.textFieldServer;
    }

    private GuiUtilTextField getTextFieldUserName() {
        if (this.textFieldUserName == null) {
            this.textFieldUserName = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldUserName.setBounds(170, 105, 240, 18);
        }
        return this.textFieldUserName;
    }

    private GuiUtilPasswordFieldNew getPasswordFieldPassword() {
        if (this.passwordFieldPassword == null) {
            this.passwordFieldPassword = new GuiUtilPasswordFieldNew(this.utilChangeHandler);
            this.passwordFieldPassword.setBounds(170, 135, 240, 18);
        }
        return this.passwordFieldPassword;
    }

    private GuiUtilPasswordFieldNew getPasswordFieldPasswordConfirm() {
        if (this.passwordFieldPasswordConfirm == null) {
            this.passwordFieldPasswordConfirm = new GuiUtilPasswordFieldNew(this.utilChangeHandler);
            this.passwordFieldPasswordConfirm.setBounds(170, 165, 240, 18);
        }
        return this.passwordFieldPasswordConfirm;
    }

    private GuiUtilTextField getTextFieldPath() {
        if (this.textFieldPath == null) {
            this.textFieldPath = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldPath.setBounds(170, 195, 400, 18);
        }
        return this.textFieldPath;
    }

    private GuiUtilCheckBox getCheckBoxUseCommonCerts() {
        if (this.checkBoxUseCommonCerts == null) {
            this.checkBoxUseCommonCerts = new GuiUtilCheckBox(this.utilChangeHandler, 165, 225);
        }
        return this.checkBoxUseCommonCerts;
    }

    protected void setDirectoryRecordDetailData(CorporateDirectoryHandler.CorporateDirectoryRecord corporateDirectoryRecord) {
        this.selectedDirectoryRecordId = corporateDirectoryRecord.id;
        this.panelTabbed.setFirstTab();
        this.labelHeaderBar.setText(String.format("%s #%d", UtilLocale.getString("TXT_DIRECTORY_ENTRY"), corporateDirectoryRecord.id));
        this.actionListenerTypeActive = false;
        this.comboBoxType.setSelectedItem(corporateDirectoryRecord.type);
        this.actionListenerTypeActive = true;
        this.checkBoxActive.setSelected(corporateDirectoryRecord.active);
        this.textFieldName.setText(corporateDirectoryRecord.name);
        this.comboBoxLDAPSearchType.setSelectedItem((Object)corporateDirectoryRecord.searchType);
        this.comboBoxLDAPDisplayType.setSelectedItem((Object)corporateDirectoryRecord.displayType);
        this.textFieldLDAPSearchBase.setText(corporateDirectoryRecord.searchBase);
        this.textFieldLDAPTimeout.setText(String.valueOf(corporateDirectoryRecord.timeout));
        if (this.isEditable) {
            this.comboBoxProtocol.deactivateActionListener();
            if (corporateDirectoryRecord.type.equals(OmiMessage.CorporateDirectoryTypeType.LDAP.getText())) {
                this.comboBoxProtocol.setSelectedItem(null);
                this.comboBoxProtocol.setEnabled(false);
            } else {
                this.comboBoxProtocol.setSelectedItem((Object)corporateDirectoryRecord.url.protocol);
                this.comboBoxProtocol.setEnabled(true);
            }
            this.lastType = corporateDirectoryRecord.type;
            this.comboBoxProtocol.activateActionListener();
        } else if (corporateDirectoryRecord.type.equals(OmiMessage.CorporateDirectoryTypeType.LDAP.getText())) {
            this.comboBoxProtocol.setSelectedItem(null);
        } else {
            this.comboBoxProtocol.setSelectedItem((Object)corporateDirectoryRecord.url.protocol);
        }
        if (corporateDirectoryRecord.url.port != null) {
            if (corporateDirectoryRecord.url.port == 0) {
                this.textFieldPort.setText("");
                this.checkBoxUseDefaultPort.setSelected(true);
            } else {
                this.textFieldPort.setText(String.valueOf(corporateDirectoryRecord.url.port));
                this.checkBoxUseDefaultPort.setSelected(false);
            }
        } else {
            this.textFieldPort.setText("");
            this.checkBoxUseDefaultPort.setSelected(true);
        }
        this.textFieldServer.setText(corporateDirectoryRecord.url.host);
        this.textFieldUserName.setText(corporateDirectoryRecord.url.username);
        this.textFieldPath.setText(corporateDirectoryRecord.url.path);
        this.passwordFieldPassword.setInitial();
        this.passwordFieldPasswordConfirm.setInitial();
        if (corporateDirectoryRecord.url.useCommonCerts != null) {
            this.checkBoxUseCommonCerts.setSelected(corporateDirectoryRecord.url.useCommonCerts);
        } else {
            this.checkBoxUseCommonCerts.setSelected(false);
        }
        if (this.isEditable) {
            this.utilChangeHandler.initRootPane(this.getRootPane());
        } else {
            this.getButtonCancel().requestFocusInWindow();
        }
        this.getRootPane().setDefaultButton(this.getButtonCancel());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CorporateDirectoryHandler.CorporateDirectoryRecord getDirectoryRecordDetailData() {
        CorporateDirectoryHandler.CorporateDirectoryRecord corporateDirectoryRecord;
        block9: {
            corporateDirectoryRecord = new CorporateDirectoryHandler.CorporateDirectoryRecord();
            corporateDirectoryRecord.id = this.selectedDirectoryRecordId;
            corporateDirectoryRecord.type = (String)this.comboBoxType.getSelectedItem();
            corporateDirectoryRecord.active = this.checkBoxActive.isSelected();
            corporateDirectoryRecord.name = this.textFieldName.getText();
            corporateDirectoryRecord.searchBase = this.textFieldLDAPSearchBase.getText();
            corporateDirectoryRecord.searchType = this.comboBoxLDAPSearchType.getSelectedIndex() == 0 ? OmiMessage.SearchNewType.SN : OmiMessage.SearchNewType.GN;
            corporateDirectoryRecord.displayType = this.comboBoxLDAPDisplayType.getSelectedIndex() == 0 ? OmiMessage.DisplayNewType.SN_GN : OmiMessage.DisplayNewType.CN;
            if (this.textFieldLDAPTimeout.getText().length() <= 0) {
                GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_MISSING"), UtilLocale.getString("TXT_SERVER_SEARCH_TIMEOUT")));
                this.markErrorComponent(OmiMessage.CorporateDirectoryType.timeout.toString());
                return null;
            }
            try {
                corporateDirectoryRecord.timeout = Integer.parseInt(this.textFieldLDAPTimeout.getText());
            }
            catch (NumberFormatException numberFormatException) {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_INPUT_FORMAT_INVALID"));
                this.markErrorComponent(OmiMessage.CorporateDirectoryType.timeout.toString());
                return null;
            }
            corporateDirectoryRecord.url.protocol = (OmiMessage.ProtType)((Object)this.comboBoxProtocol.getSelectedItem());
            corporateDirectoryRecord.url.host = this.textFieldServer.getText();
            corporateDirectoryRecord.url.username = this.textFieldUserName.getText();
            corporateDirectoryRecord.url.path = this.textFieldPath.getText();
            if (this.checkBoxUseDefaultPort.isSelected()) {
                corporateDirectoryRecord.url.port = 0;
            } else {
                int n = 0;
                n = UtilMisc.getIntFromTextField(this.textFieldPort, UtilLocale.getString("TXT_PORT"), this.utilErrorComp, 10);
                if (n == -1) {
                    this.markErrorComponent(UtilLocale.getString("TXT_PORT"));
                    return null;
                }
                corporateDirectoryRecord.url.port = n;
            }
            if (this.passwordFieldPassword.isChanged() || this.passwordFieldPasswordConfirm.isChanged()) {
                String string = new String(this.passwordFieldPassword.getPassword());
                String string2 = new String(this.passwordFieldPasswordConfirm.getPassword());
                if (this.passwordFieldPassword.isChanged() && this.passwordFieldPasswordConfirm.isChanged() && string.equals(string2)) {
                    corporateDirectoryRecord.url.password = string;
                    corporateDirectoryRecord.url.passwordChanged = true;
                    break block9;
                } else {
                    GuiInfoConsole.showError(UtilLocale.getString("TXT_PASSWORD_CONFIRMATION_FAILED"));
                    this.markErrorComponent(OmiMessage.URLType.password.name());
                    return null;
                }
            }
            corporateDirectoryRecord.url.password = null;
            corporateDirectoryRecord.url.passwordChanged = false;
        }
        corporateDirectoryRecord.url.useCommonCerts = this.checkBoxUseCommonCerts.isSelected();
        return corporateDirectoryRecord;
    }

    public void markErrorComponent(String string) {
        JComponent jComponent = this.utilErrorComp.getField(string);
        if (jComponent != null) {
            this.panelTabbed.setSelectedIndex(this.utilErrorComp.getTab(string));
            this.utilErrorComp.markComponent(jComponent);
            if (string.equals(OmiMessage.URLType.password.name())) {
                this.utilErrorComp.markComponent(this.passwordFieldPasswordConfirm);
                this.passwordFieldPassword.setInitial();
                this.passwordFieldPasswordConfirm.setInitial();
            }
        }
    }

    protected void setDefaultTab() {
        this.panelTabbed.setFirstTab();
    }

    public String getErrorLabelText(String string) {
        if (string == null) {
            return null;
        }
        return this.utilErrorComp.getLabelText(string);
    }
}

