/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.systemfeatures;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilMainPanel;
import com.aastra.oamp.systemfeatures.SysFeatDirectoryDetailPanel;
import com.aastra.oamp.systemfeatures.SysFeatDirectoryTaskPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.CorporateDirectoryHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

public class SysFeatDirectoryMainPanel
extends GuiUtilMainPanel
implements CorporateDirectoryHandler.CorporateDirectoryDataNotificationInterface,
ConfiguratorTableEventInterface {
    private static final long serialVersionUID = 1L;
    protected static final int xSizeDetailPanelSurcharge = 300;
    protected static final int ySizeDetailPanelSurcharge = 210;
    private static final int ySizeDetailPanel = 420;
    private CorporateDirectoryHandler directoryHandler = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private UtilErrorComp utilErrorComp = null;
    private boolean isEditable = true;
    private GuiUtilDetailSplitPanel directoryDetailSplitPanel = null;
    private SysFeatDirectoryTaskPanel directoryTaskPanel = null;
    private SysFeatDirectoryDetailPanel directoryDetailPanel = null;
    private AastraScrollPane directoryTablePanel = null;
    private int dividerLocation = 0;
    private boolean detailPanelPending = false;
    private int idPending = -1;
    private int idCurrentMonitorPanel = -1;

    public SysFeatDirectoryMainPanel(GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, CorporateDirectoryHandler corporateDirectoryHandler) {
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.directoryHandler = corporateDirectoryHandler;
        this.directoryHandler.registerDataNotificationListener(this);
        this.initialize();
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilErrorComp = new UtilErrorComp();
        } else {
            this.isEditable = false;
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.getDirectorySplitPanel(), "Center");
        this.add((Component)this.getDirectoryTaskPanel(), "East");
    }

    private GuiUtilDetailSplitPanel getDirectorySplitPanel() {
        if (this.directoryDetailSplitPanel == null) {
            this.directoryDetailSplitPanel = new GuiUtilDetailSplitPanel(420);
            this.directoryDetailSplitPanel.setTopComponent(this.getDirectoryTablePanel());
            this.directoryDetailSplitPanel.setBottomComponent(null);
        }
        return this.directoryDetailSplitPanel;
    }

    private AastraScrollPane getDirectoryTablePanel() {
        if (this.directoryTablePanel == null) {
            this.directoryTablePanel = new AastraScrollPane(this.getDirectoryTable());
            this.dividerLocation = this.directoryDetailSplitPanel.getHeight() - 420;
            this.directoryTablePanel.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.directoryTablePanel;
    }

    private GuiUtilConfiguratorTable getDirectoryTable() {
        if (this.table == null) {
            int[] nArray = new int[]{0, 1, 2, 3, 9};
            UtilPreferences.TableColumnsWidthKeyTypeEnum tableColumnsWidthKeyTypeEnum = this.isEditable ? UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthDirectoryConfig : UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthDirectoryMonitor;
            this.table = new GuiUtilConfiguratorTable((Object)this, (Database)this.directoryHandler.getDb(), nArray, tableColumnsWidthKeyTypeEnum, 0, true);
            this.table.setIconArray(2, GuiUtilIcon.getIconArrayInactiveActive());
        }
        return this.table;
    }

    private AastraPanel getDirectoryTaskPanel() {
        if (this.directoryTaskPanel == null) {
            this.directoryTaskPanel = new SysFeatDirectoryTaskPanel(this, this.guiNavPanelType);
        }
        return this.directoryTaskPanel;
    }

    protected void configureShowDirectoryRecord() {
        int n = this.table.getSelectedRow();
        if (n >= 0) {
            int n2 = this.table.convertRowIndexToModel(n);
            CorporateDirectoryHandler.CorporateDirectoryRecord corporateDirectoryRecord = this.directoryHandler.getDirectoryRecordByTableIdx(n2);
            this.createDirectoryDetailPanel(corporateDirectoryRecord);
        }
    }

    protected void createDirectoryDetailPanel(CorporateDirectoryHandler.CorporateDirectoryRecord corporateDirectoryRecord) {
        if (this.directoryDetailSplitPanel.getBottomComponent() != null) {
            if (this.isEditable) {
                this.detailPanelPending = false;
                this.utilErrorComp.clearComponents();
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating directory config detail panel");
            }
            this.dividerLocation = this.directoryDetailSplitPanel.getDividerLocation();
            if (corporateDirectoryRecord == null) {
                this.directoryDetailPanel.setDefaultTab();
            }
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating directory detail panel");
            this.directoryDetailSplitPanel.setBottomComponent(this.getDirectoryDetailPanel());
            this.directoryDetailPanel.setDefaultTab();
        }
        if (corporateDirectoryRecord != null) {
            if (!this.isEditable) {
                this.idCurrentMonitorPanel = corporateDirectoryRecord.id;
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading directory entry[" + corporateDirectoryRecord.id + "]:");
            this.directoryDetailPanel.setDirectoryRecordDetailData(corporateDirectoryRecord);
        } else {
            this.directoryDetailPanel.setDirectoryRecordDetailData(null);
        }
        this.directoryDetailSplitPanel.setDividerLocation(this.dividerLocation);
        this.directoryDetailSplitPanel.validate();
        this.directoryTaskPanel.setTaskButtonConfigureShow(false);
        if (this.isEditable) {
            this.directoryTaskPanel.setTaskButtonOrderIncrement(false);
            this.directoryTaskPanel.setTaskButtonOrderDecrement(false);
        }
    }

    protected void removeDirectoryDetailPanel() {
        if (this.directoryDetailSplitPanel.getBottomComponent() != null) {
            if (this.isEditable) {
                this.detailPanelPending = false;
                this.idPending = -1;
                this.utilErrorComp.clearComponents();
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing directory config detail panel");
            } else {
                this.idCurrentMonitorPanel = -1;
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing directory monitor detail panel");
            }
            this.dividerLocation = this.directoryDetailSplitPanel.getDividerLocation();
            this.directoryDetailSplitPanel.setBottomComponent(null);
            if (this.table.getSelectedRowCount() == 1) {
                this.directoryTaskPanel.setTaskButtonConfigureShow(true);
                if (this.isEditable) {
                    this.setTaskButtonOrderBySelectedRow();
                }
            }
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Tried to remove directory detail panel, but there is none");
        }
    }

    private SysFeatDirectoryDetailPanel getDirectoryDetailPanel() {
        if (this.directoryDetailPanel == null) {
            this.directoryDetailPanel = new SysFeatDirectoryDetailPanel(this, this.guiNavPanelType, this.directoryHandler, this.utilErrorComp);
        }
        return this.directoryDetailPanel;
    }

    protected void changeDirectoryRecord() {
        CorporateDirectoryHandler.CorporateDirectoryRecord corporateDirectoryRecord = this.directoryDetailPanel.getDirectoryRecordDetailData();
        if (corporateDirectoryRecord != null) {
            this.pendingRemoveDetailPanel(corporateDirectoryRecord.id);
            this.directoryHandler.sendSetCorporateDirectory(corporateDirectoryRecord);
        }
    }

    public void pendingRemoveDetailPanel(int n) {
        this.detailPanelPending = true;
        this.idPending = n;
    }

    protected void changeOrder(boolean bl) {
        int n = this.table.getSelectedRow();
        int n2 = this.table.convertRowIndexToModel(n);
        int n3 = this.directoryHandler.getDirectoryRecordByTableIdx((int)n2).id;
        this.directoryHandler.requestChangeOrder(n3, bl);
    }

    private void setTaskButtonOrderBySelectedRow() {
        int n = this.table.getSelectedRow();
        int n2 = this.table.convertRowIndexToModel(n);
        int n3 = this.directoryHandler.getDirectoryRecordByTableIdx((int)n2).order;
        this.directoryTaskPanel.setTaskButtonOrderIncrement(n3 < 5);
        this.directoryTaskPanel.setTaskButtonOrderDecrement(n3 > 1);
    }

    private void processTableEvent(DataRecord dataRecord) {
        int n = this.table.getSelectedRowCount();
        if (this.directoryDetailSplitPanel.getBottomComponent() != null) {
            if (dataRecord != null) {
                this.createDirectoryDetailPanel((CorporateDirectoryHandler.CorporateDirectoryRecord)dataRecord);
            } else {
                this.removeDirectoryDetailPanel();
            }
        } else if (n == 1) {
            this.directoryTaskPanel.setTaskButtonConfigureShow(true);
            if (this.isEditable) {
                this.setTaskButtonOrderBySelectedRow();
            }
        } else {
            this.directoryTaskPanel.setTaskButtonConfigureShow(false);
            if (this.isEditable) {
                this.directoryTaskPanel.setTaskButtonOrderIncrement(false);
                this.directoryTaskPanel.setTaskButtonOrderDecrement(false);
            }
        }
        this.updateTableInfo();
    }

    @Override
    public void processCorporateDirectoryDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        CorporateDirectoryHandler.CorporateDirectoryRecord corporateDirectoryRecord;
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Directory data notification: " + dataNotificationEnum.toString() + "," + n);
        if (this.isEditable) {
            if (this.detailPanelPending && this.idPending == n) {
                this.removeDirectoryDetailPanel();
            }
        } else if (n == this.idCurrentMonitorPanel && (corporateDirectoryRecord = this.directoryHandler.getDirectoryRecordById(n)) != null) {
            this.createDirectoryDetailPanel(corporateDirectoryRecord);
        }
    }

    @Override
    public void processCorporateDirectoryErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        OmiMessage.errorCodes errorCodes2 = null;
        if (string == null || !this.isEditable || !this.componentActivated) {
            return;
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "directory error notification: " + dataNotificationEnum.toString() + ",id=" + n + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Corp dir error notification: Unknown errorCode=" + string);
        }
        if (errorCodes2 != null) {
            String string4 = null;
            if (string2 != null) {
                string4 = string2.equals(OmiMessage.CorporateDirectoryOrderType.order.name()) ? UtilLocale.getString("TXT_ORDER") : this.directoryDetailPanel.getErrorLabelText(string2);
            }
            GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, string4, string3));
        } else {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
        }
        if (string2 != null && !string2.equals(OmiMessage.CorporateDirectoryOrderType.order.name())) {
            this.directoryDetailPanel.markErrorComponent(string2);
        }
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        this.createDirectoryDetailPanel((CorporateDirectoryHandler.CorporateDirectoryRecord)dataRecord);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }
}

