/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.systemfeatures;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilBorderPanel;
import com.aastra.oamp.guiutil.GuiUtilButtonBar;
import com.aastra.oamp.guiutil.GuiUtilCheckBox;
import com.aastra.oamp.guiutil.GuiUtilText;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraTabbedPane;
import com.aastra.style.AastraTextField;
import com.aastra.util.UtilSpy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class SysFeatFACPanel
extends AastraPanel
implements CommonDataHandler.CommonDataNotificationInterface,
GuiComponentActivationInterface {
    private static final long serialVersionUID = 1L;
    private static final int panelHeight = 410;
    private static final int panelWidth = 800;
    private static final int tabbedPaneHeight = 410;
    private static final int tabbedPaneWidth = 800;
    private GuiUtilButtonBar panelButtonBar = null;
    private AastraTabbedPane tabbedPaneFAC = null;
    private AastraPanel tabFAC = null;
    private AastraPanel panelFAC = null;
    private AastraTextField textFieldFACNumber = null;
    private int activeFACNumber;
    private FACCodeEditorClass[] activeFACArray = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private CommonDataHandler commonDataHandler = null;
    private UtilErrorComp utilErrorComp = null;
    private boolean isEditable = true;
    private OmiManagement omiManagement = null;

    public SysFeatFACPanel(GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, CommonDataHandler commonDataHandler) {
        this.commonDataHandler = commonDataHandler;
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.FACPrefix, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.FACList, this);
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.omiManagement = GuiMain.getOmiManagementObject();
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.setSize(new Dimension(800, 410));
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilErrorComp = new UtilErrorComp();
        } else {
            this.isEditable = false;
        }
        this.add(this.getTabbedPaneFAC());
    }

    private AastraTabbedPane getTabbedPaneFAC() {
        if (this.tabbedPaneFAC == null) {
            this.tabbedPaneFAC = new AastraTabbedPane();
            this.tabbedPaneFAC.setPreferredSize(new Dimension(800, 410));
            this.tabbedPaneFAC.setMaximumSize(new Dimension(800, 410));
            this.tabbedPaneFAC.setAlignmentX(0.0f);
            this.tabbedPaneFAC.addTab(UtilLocale.getString("TXT_FEATURE_ACCESS_CODES"), null, this.getTabFAC(), null);
        }
        return this.tabbedPaneFAC;
    }

    private AastraPanel getTabFAC() {
        if (this.tabFAC == null) {
            this.tabFAC = new AastraPanel();
            this.tabFAC.setLayout(new BoxLayout(this.tabFAC, 1));
            this.tabFAC.add(Box.createRigidArea(new Dimension(0, 10)));
            this.getPanelButtonBar();
            this.tabFAC.add(this.getPanelFAC());
            if (this.isEditable) {
                this.tabFAC.add(this.panelButtonBar);
            }
        }
        return this.tabFAC;
    }

    private GuiUtilButtonBar getPanelButtonBar() {
        if (this.panelButtonBar == null) {
            this.panelButtonBar = new GuiUtilButtonBar(800);
            this.panelButtonBar.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SysFeatFACPanel)SysFeatFACPanel.this).panelButtonBar.utilChangeHandler.deactivate();
                    SysFeatFACPanel.this.utilErrorComp.clearComponents();
                    SysFeatFACPanel.this.changeFAC();
                }
            });
            this.panelButtonBar.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SysFeatFACPanel)SysFeatFACPanel.this).panelButtonBar.utilChangeHandler.deactivate();
                    SysFeatFACPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.FACList);
                    SysFeatFACPanel.this.utilErrorComp.clearComponents();
                }
            });
        }
        return this.panelButtonBar;
    }

    private AastraPanel getPanelFAC() {
        if (this.panelFAC == null) {
            GuiUtilText.setFACFeatureTypeGuiValues();
            this.panelFAC = new GuiUtilBorderPanel(320);
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(30, 30, 190, 31);
            aastraLabel.setText("<html>" + UtilLocale.getString("TXT_FAC_NUMBER") + "</html>");
            this.panelFAC.add((Component)aastraLabel, null);
            this.panelFAC.add((Component)this.getTextFieldFACNumber(), null);
            this.activeFACNumber = OmiMessage.FACFeatureType.values().length;
            if (!this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) {
                this.activeFACNumber -= 2;
            }
            this.activeFACArray = new FACCodeEditorClass[this.activeFACNumber];
            for (int i = 0; i < this.activeFACNumber; ++i) {
                this.activeFACArray[i] = new FACCodeEditorClass(OmiMessage.FACFeatureType.values()[i]);
            }
            if (!this.isEditable) {
                UtilSetPanelEditable.setDisabled(this.panelFAC);
            }
        }
        return this.panelFAC;
    }

    private AastraTextField getTextFieldFACNumber() {
        if (this.textFieldFACNumber == null) {
            this.textFieldFACNumber = new AastraTextField();
            this.textFieldFACNumber.setBounds(260, 30, 230, 18);
            this.textFieldFACNumber.setEditable(false);
        }
        return this.textFieldFACNumber;
    }

    public void changeFAC() {
        CommonDataHandler.FACListClass fACListClass = new CommonDataHandler.FACListClass();
        for (int i = 0; i < this.activeFACNumber; ++i) {
            fACListClass.FACArr[i] = new CommonDataHandler.FACListClass.FACClass();
            fACListClass.FACArr[i].feature = OmiMessage.FACFeatureType.values()[i];
            fACListClass.FACArr[i].enable = this.activeFACArray[i].checkBox.isSelected();
            fACListClass.FACArr[i].fac = this.activeFACArray[i].textField.getText();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting FAC '" + fACListClass.FACArr[i].feature.name() + "' = " + fACListClass.FACArr[i].enable + ",'" + fACListClass.FACArr[i].fac + "'");
        }
        this.commonDataHandler.sendSetFAC(fACListClass);
        this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.FACList);
    }

    private void cleanFACControls() {
        for (int i = 0; i < this.activeFACNumber; ++i) {
            this.activeFACArray[i].checkBox.setSelected(false);
            this.activeFACArray[i].textField.setText("");
        }
    }

    @Override
    public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        String string4 = null;
        OmiMessage.errorCodes errorCodes2 = null;
        if (!this.isEditable || string == null) {
            return;
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data error notification: " + dataNotificationEnum.toString() + ",item=" + commonDataItemEnum.toString() + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data error notification: Unknown errorCode=" + string);
        }
        if (string2 != null) {
            JComponent jComponent;
            if (string2.equals(OmiMessage.attribIds.prefix.name())) {
                return;
            }
            if (errorCodes2 == OmiMessage.errorCodes.EExist) {
                for (int i = 0; i < OmiMessage.FACFeatureType.values().length; ++i) {
                    if (!string2.equals(OmiMessage.FACFeatureType.values()[i].name())) continue;
                    errorCodes2 = OmiMessage.errorCodes.InternalEExistNotUnique;
                    break;
                }
            }
            if ((jComponent = this.utilErrorComp.getField(string2)) != null) {
                this.utilErrorComp.markComponent(jComponent);
                this.panelButtonBar.buttonCancel.setEnabled(true);
            }
            string4 = this.utilErrorComp.getLabelText(string2);
        }
        if (errorCodes2 != null) {
            GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, string4, string3));
        } else {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
        }
    }

    @Override
    public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
        CommonDataHandler.FACListClass fACListClass = null;
        String string = null;
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data notification: " + dataNotificationEnum.toString() + "," + commonDataItemEnum.toString());
        if (commonDataItemEnum == CommonDataHandler.CommonDataItemEnum.FACList) {
            if (dataNotificationEnum == DataNotificationEnum.DATA_DELETED_ALL) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Delete all FAC entries");
                this.cleanFACControls();
            } else {
                try {
                    fACListClass = (CommonDataHandler.FACListClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.FACList);
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + (Object)((Object)CommonDataHandler.CommonDataItemEnum.FACList) + " failed");
                    return;
                }
                for (int i = 0; i < fACListClass.FACArr.length; ++i) {
                    if (fACListClass.FACArr[i] == null) continue;
                    GuiUtilCheckBox guiUtilCheckBox = this.activeFACArray[i].checkBox;
                    GuiUtilTextField guiUtilTextField = this.activeFACArray[i].textField;
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading FAC '" + fACListClass.FACArr[i].feature.name() + "'=" + fACListClass.FACArr[i].enable + ",'" + fACListClass.FACArr[i].fac + "'");
                    if (guiUtilCheckBox != null) {
                        guiUtilCheckBox.setSelected(fACListClass.FACArr[i].enable);
                    }
                    if (guiUtilTextField == null) continue;
                    ((JTextComponent)guiUtilTextField).setText(String.valueOf(fACListClass.FACArr[i].fac));
                }
            }
        } else if (commonDataItemEnum == CommonDataHandler.CommonDataItemEnum.FACPrefix) {
            try {
                string = (String)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.FACPrefix);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + (Object)((Object)CommonDataHandler.CommonDataItemEnum.FACPrefix) + "='" + string + "'");
            }
            catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + (Object)((Object)CommonDataHandler.CommonDataItemEnum.FACPrefix) + " failed");
                return;
            }
            this.getTextFieldFACNumber().setText(string);
        }
    }

    @Override
    public void componentActivated(Component component) {
        if (this.isEditable) {
            this.activeFACArray[0].checkBox.requestFocusInWindow();
            this.panelButtonBar.utilChangeHandler.initRootPane(this.getRootPane());
            this.getRootPane().setDefaultButton(this.panelButtonBar.buttonCancel);
        }
    }

    @Override
    public void componentDeactivated() {
    }

    private class FACCodeEditorClass {
        private static final int xPosLabel = 30;
        private static final int yStartLabel = 65;
        private static final int yDiffLabel = 35;
        private static final int xSizeLabel = 190;
        private static final int ySizeLabel = 31;
        private static final int xPosCheckBox = 227;
        private static final int xPosTextField = 260;
        private static final int xSizeTextField = 230;
        private static final int ySizeTextField = 18;
        private int yPos;
        private AastraLabel label;
        private GuiUtilCheckBox checkBox;
        private GuiUtilTextField textField;

        private FACCodeEditorClass(OmiMessage.FACFeatureType fACFeatureType) {
            this.yPos = 65 + 35 * fACFeatureType.ordinal();
            this.label = new AastraLabel("<html>" + fACFeatureType.toString() + "</html>", 30, this.yPos, 190, 31);
            this.checkBox = new GuiUtilCheckBox(((SysFeatFACPanel)SysFeatFACPanel.this).panelButtonBar.utilChangeHandler, 227, this.yPos - 3);
            this.textField = new GuiUtilTextField(((SysFeatFACPanel)SysFeatFACPanel.this).panelButtonBar.utilChangeHandler);
            this.textField.setBounds(260, this.yPos, 230, 18);
            SysFeatFACPanel.this.panelFAC.add(this.label);
            SysFeatFACPanel.this.panelFAC.add(this.checkBox);
            SysFeatFACPanel.this.panelFAC.add(this.textField);
            if (SysFeatFACPanel.this.isEditable) {
                SysFeatFACPanel.this.utilErrorComp.put(fACFeatureType.name(), this.label, this.textField);
            }
        }
    }
}

