/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.systemfeatures;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilMainPanel;
import com.aastra.oamp.systemfeatures.SysFeatXMLApplicationDetailPanel;
import com.aastra.oamp.systemfeatures.SysFeatXMLApplicationTaskPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.XMLApplicationHandler;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;

public class SysFeatXMLApplicationMainPanel
extends GuiUtilMainPanel
implements XMLApplicationHandler.XMLApplDataNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface {
    private static final long serialVersionUID = 1L;
    protected static final int xSizeDetailPanelSurcharge = 285;
    protected static final int ySizeDetailPanelSurcharge = 210;
    private static final int ySizeDetailPanel = 420;
    private XMLApplicationHandler xmlApplicationHandler = null;
    private GuiUtilDetailSplitPanel xmlApplicationDetailSplitPane = null;
    private AastraScrollPane xmlApplicationTablePane = null;
    private SysFeatXMLApplicationDetailPanel xmlApplicationDetailPanel = null;
    private SysFeatXMLApplicationTaskPanel xmlApplicationTaskPanel = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private boolean detailPanelPending = false;
    private int idPending = -1;
    private int idCurrentMonitorPanel = -1;
    private int dividerLocation = 0;
    private UtilErrorComp utilErrorComp = null;
    private boolean isEditable = true;

    public SysFeatXMLApplicationMainPanel(GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, XMLApplicationHandler xMLApplicationHandler) {
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.xmlApplicationHandler = xMLApplicationHandler;
        this.xmlApplicationHandler.registerDataNotificationListener(this);
        this.initialize();
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilErrorComp = new UtilErrorComp();
        } else {
            this.isEditable = false;
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.getXMLApplicationDetailSplitPane(), "Center");
        this.add((Component)this.getXMLApplicationTaskPanel(), "East");
    }

    private void processTableEvent(DataRecord dataRecord) {
        int n = this.table.getSelectedRowCount();
        if (this.xmlApplicationDetailSplitPane.getBottomComponent() != null) {
            if (dataRecord != null) {
                XMLApplicationHandler.XMLApplRec xMLApplRec = (XMLApplicationHandler.XMLApplRec)dataRecord;
                this.createXMLApplicationDetailPanel(xMLApplRec, false);
            } else {
                this.removeXMLApplicationDetailPanel();
            }
        } else if (n == 1) {
            this.xmlApplicationTaskPanel.setTaskButtonConfigureShow(true);
        } else {
            this.xmlApplicationTaskPanel.setTaskButtonConfigureShow(false);
        }
        if (this.isEditable) {
            boolean bl = false;
            int[] nArray = this.table.getSelectedRows();
            for (int i = 0; i < n; ++i) {
                int n2 = this.table.convertRowIndexToModel(nArray[i]);
                XMLApplicationHandler.XMLApplRec xMLApplRec = this.xmlApplicationHandler.getXMLApplRecordByTableIdx(n2);
                OmiMessage.XMLApplicationTypeType xMLApplicationTypeType = xMLApplRec.type;
                if (xMLApplicationTypeType == OmiMessage.XMLApplicationTypeType.Dynamic) continue;
                bl = true;
                break;
            }
            if (n >= 1 && !bl) {
                this.xmlApplicationTaskPanel.setTaskButtonDelete(true);
            } else {
                this.xmlApplicationTaskPanel.setTaskButtonDelete(false);
            }
        }
        this.updateTableInfo();
    }

    public void configureShowXMLApplication() {
        int n;
        XMLApplicationHandler.XMLApplRec xMLApplRec;
        int n2 = this.table.getSelectedRow();
        if (n2 >= 0 && (xMLApplRec = this.xmlApplicationHandler.getXMLApplRecordByTableIdx(n = this.table.convertRowIndexToModel(n2))) != null) {
            this.createXMLApplicationDetailPanel(xMLApplRec, false);
        }
    }

    private GuiUtilDetailSplitPanel getXMLApplicationDetailSplitPane() {
        if (this.xmlApplicationDetailSplitPane == null) {
            this.xmlApplicationDetailSplitPane = new GuiUtilDetailSplitPanel(420);
            this.xmlApplicationDetailSplitPane.setTopComponent(this.getXMLApplicationTablePane());
            this.xmlApplicationDetailSplitPane.setBottomComponent(null);
        }
        return this.xmlApplicationDetailSplitPane;
    }

    private JTable getXMLApplicationTable() {
        if (this.table == null) {
            int[] nArray = new int[]{0, 1, 6, 2};
            this.table = this.isEditable ? new GuiUtilConfiguratorTable(this, this.xmlApplicationHandler.getXMLApplDb(), nArray, UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthXmlApplConfig) : new GuiUtilConfiguratorTable((Object)this, this.xmlApplicationHandler.getXMLApplDb(), nArray, UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthXmlApplMonitor, 0);
            this.table.setIconArray(2, GuiUtilIcon.getIconArrayInactiveActive());
            OmiMessage.BuiltInApplicationType.callerList.setTxt(UtilLocale.getString("TXT_CALLER_LIST"));
            OmiMessage.BuiltInApplicationType.redialList.setTxt(UtilLocale.getString("TXT_REDIAL_LIST"));
            OmiMessage.BuiltInApplicationType.userPresence.setTxt(UtilLocale.getString("TXT_PRESENCE"));
            OmiMessage.BuiltInApplicationType.systemApplMenu.setTxt(UtilLocale.getString("TXT_SERVER_MENU"));
            OmiMessage.BuiltInApplicationType.eventActions.setTxt(UtilLocale.getString("TXT_ACTION_URI"));
            OmiMessage.BuiltInApplicationType.admin.setTxt(UtilLocale.getString("TXT_ADMINISTRATION"));
            OmiMessage.BuiltInApplicationType.featureAccessCodes.setTxt(UtilLocale.getString("TXT_FEATURE_ACCESS_CODES"));
            OmiMessage.BuiltInApplicationType.callCompletion.setTxt(UtilLocale.getString("TXT_CALL_COMPLETION"));
            OmiMessage.BuiltInApplicationType.parkCall.setTxt(UtilLocale.getString("TXT_PARK_CALL"));
            OmiMessage.BuiltInApplicationType.unparkCall.setTxt(UtilLocale.getString("TXT_UNPARK_CALL"));
            OmiMessage.BuiltInApplicationType.pickup.setTxt(UtilLocale.getString("TXT_PICKUP"));
            OmiMessage.BuiltInApplicationType.take.setTxt(UtilLocale.getString("TXT_TAKE"));
            OmiMessage.BuiltInApplicationType.callForward.setTxt(UtilLocale.getString("TXT_CALL_FORWARD"));
            OmiMessage.BuiltInApplicationType.callRouting.setTxt(UtilLocale.getString("TXT_CALL_ROUTING"));
            OmiMessage.BuiltInApplicationType.callProtection.setTxt(UtilLocale.getString("TXT_CALL_PROTECTION"));
            OmiMessage.BuiltInApplicationType.voiceBox.setTxt(UtilLocale.getString("TXT_VOICE_BOX"));
        }
        return this.table;
    }

    private AastraScrollPane getXMLApplicationTablePane() {
        if (this.xmlApplicationTablePane == null) {
            this.xmlApplicationTablePane = new AastraScrollPane(this.getXMLApplicationTable());
            this.dividerLocation = this.xmlApplicationTablePane.getHeight() - 420;
            this.xmlApplicationTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.xmlApplicationTablePane;
    }

    private void enableTableAccess() {
        this.table.setActive(true);
        if (this.isEditable && GuiMain.getOmiManagementObject().getOmmAttribBool(OmiMessage.OpenRespAttribType.haveXMLDynamic)) {
            this.xmlApplicationTaskPanel.setTaskButtonCreate(true);
        }
    }

    private void disableTableAccess() {
        this.table.setActive(false);
        this.xmlApplicationTaskPanel.setTaskButtonConfigureShow(false);
        if (this.isEditable) {
            this.xmlApplicationTaskPanel.setTaskButtonCreate(false);
            this.xmlApplicationTaskPanel.setTaskButtonDelete(false);
        }
    }

    private AastraPanel getXMLApplicationDetailPanel() {
        if (this.xmlApplicationDetailPanel == null) {
            this.xmlApplicationDetailPanel = new SysFeatXMLApplicationDetailPanel(this, this.guiNavPanelType, this.utilErrorComp);
        }
        return this.xmlApplicationDetailPanel;
    }

    private AastraPanel getXMLApplicationTaskPanel() {
        if (this.xmlApplicationTaskPanel == null) {
            this.xmlApplicationTaskPanel = new SysFeatXMLApplicationTaskPanel(this, this.guiNavPanelType);
        }
        return this.xmlApplicationTaskPanel;
    }

    public void createXMLApplicationDetailPanel(XMLApplicationHandler.XMLApplRec xMLApplRec, boolean bl) {
        if (bl) {
            this.table.removeRowSelectionAll();
        }
        if (this.xmlApplicationDetailSplitPane.getBottomComponent() != null) {
            if (this.isEditable) {
                this.detailPanelPending = false;
                this.utilErrorComp.clearComponents();
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating XML application config detail panel");
            }
            this.dividerLocation = this.xmlApplicationDetailSplitPane.getDividerLocation();
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating XML application config detail panel");
            this.xmlApplicationDetailSplitPane.setBottomComponent(this.getXMLApplicationDetailPanel());
        }
        if (xMLApplRec != null) {
            if (!this.isEditable) {
                this.idCurrentMonitorPanel = xMLApplRec.id;
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading XML application[" + xMLApplRec.id + "]:");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + xMLApplRec.enable + ",'" + xMLApplRec.name + "'");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + (Object)((Object)xMLApplRec.url.protocol) + ",'" + xMLApplRec.url.host + "','" + xMLApplRec.url.username + "'");
            if (xMLApplRec.url.passwordChanged) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + xMLApplRec.url.password + "'");
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + xMLApplRec.url.path + "'");
            this.xmlApplicationDetailPanel.setXMLApplicationDetailData(xMLApplRec);
        } else {
            this.xmlApplicationDetailPanel.setXMLApplicationDetailData(null);
        }
        this.xmlApplicationDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.xmlApplicationDetailSplitPane.validate();
        this.xmlApplicationTaskPanel.setTaskButtonConfigureShow(false);
    }

    public void removeXMLApplicationDetailPanel() {
        if (this.xmlApplicationDetailSplitPane.getBottomComponent() != null) {
            if (this.isEditable) {
                this.detailPanelPending = false;
                this.idPending = -1;
                this.utilErrorComp.clearComponents();
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing XML application config detail panel");
            } else {
                this.idCurrentMonitorPanel = -1;
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing XML application monitor detail panel");
            }
            this.dividerLocation = this.xmlApplicationDetailSplitPane.getDividerLocation();
            this.xmlApplicationDetailSplitPane.setBottomComponent(null);
            if (this.table.getSelectedRowCount() == 1) {
                this.xmlApplicationTaskPanel.setTaskButtonConfigureShow(true);
            }
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Tried to remove XML application detail panel, but there is none");
        }
    }

    public void createXMLApplication() {
        XMLApplicationHandler.XMLApplRec xMLApplRec = this.xmlApplicationDetailPanel.getXMLApplicationDetailData();
        if (xMLApplRec == null) {
            return;
        }
        this.pendingRemoveDetailPanel(-1);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating XML dynamic application:");
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + xMLApplRec.enable + ",'" + xMLApplRec.type.name() + ",'" + xMLApplRec.name + "'");
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + (Object)((Object)xMLApplRec.url.protocol) + ",'" + xMLApplRec.url.host + "','" + xMLApplRec.url.username + "'");
        if (xMLApplRec.url.passwordChanged) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + xMLApplRec.url.password + "'");
        }
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + xMLApplRec.url.path + "'");
        this.xmlApplicationHandler.sendCreateXMLAppl(xMLApplRec);
    }

    public void changeXMLApplication() {
        XMLApplicationHandler.XMLApplRec xMLApplRec = this.xmlApplicationDetailPanel.getXMLApplicationDetailData();
        if (xMLApplRec == null) {
            return;
        }
        this.pendingRemoveDetailPanel(xMLApplRec.id);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Changing XML application[" + xMLApplRec.id + "]:");
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + xMLApplRec.enable + ",'" + xMLApplRec.type.name() + ",'" + xMLApplRec.name + "'");
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + (Object)((Object)xMLApplRec.url.protocol) + ",'" + xMLApplRec.url.host + "','" + xMLApplRec.url.username + "'");
        if (xMLApplRec.url.passwordChanged) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + xMLApplRec.url.password + "'");
        }
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + xMLApplRec.url.path + "'");
        this.xmlApplicationHandler.sendSetXMLAppl(xMLApplRec);
    }

    public void deleteXMLApplication() {
        GuiUtilDialog guiUtilDialog;
        int n = this.table.getSelectedRowCount();
        if (n > 0 && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_DELETE_SELECTED_XML_APPLICATIONS_?"), true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            int[] nArray = this.table.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = this.table.convertRowIndexToModel(nArray[i]);
                XMLApplicationHandler.XMLApplRec xMLApplRec = this.xmlApplicationHandler.getXMLApplRecordByTableIdx(n2);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Deleting XML application[" + xMLApplRec.id + "]");
                this.xmlApplicationHandler.sendDeleteXMLAppl(xMLApplRec.id);
                if (this.xmlApplicationDetailSplitPane.getBottomComponent() == null || this.xmlApplicationDetailPanel.getSelectedXMLApplication() != xMLApplRec.id) continue;
                this.detailPanelPending = true;
                this.idPending = xMLApplRec.id;
            }
        }
    }

    public void pendingRemoveDetailPanel(int n) {
        this.detailPanelPending = true;
        this.idPending = n;
    }

    @Override
    public void processXMLApplDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "XML application data notification: " + dataNotificationEnum.toString() + "," + n);
        block0 : switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                break;
            }
            default: {
                if (this.isEditable) {
                    switch (dataNotificationEnum) {
                        case NEW_DATA: 
                        case DATA_CHANGED: {
                            if (!this.detailPanelPending || dataNotificationEnum != DataNotificationEnum.NEW_DATA && (dataNotificationEnum != DataNotificationEnum.DATA_CHANGED || this.idPending != n)) break block0;
                            this.removeXMLApplicationDetailPanel();
                            break;
                        }
                        case DATA_DELETED: {
                            if (!this.detailPanelPending || this.idPending != n) break block0;
                            this.removeXMLApplicationDetailPanel();
                            break;
                        }
                    }
                    break;
                }
                if (n != this.idCurrentMonitorPanel) break;
                switch (dataNotificationEnum) {
                    case NEW_DATA: 
                    case DATA_CHANGED: {
                        XMLApplicationHandler.XMLApplRec xMLApplRec = this.xmlApplicationHandler.getXMLApplRecordById(n);
                        if (xMLApplRec == null) break block0;
                        this.createXMLApplicationDetailPanel(xMLApplRec, false);
                        break block0;
                    }
                    case DATA_DELETED: {
                        this.removeXMLApplicationDetailPanel();
                        break block0;
                    }
                }
            }
        }
    }

    @Override
    public void processXMLApplErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        OmiMessage.errorCodes errorCodes2 = null;
        if (string == null || this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_MONITOR || !this.componentActivated) {
            return;
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "XML application error notification: " + dataNotificationEnum.toString() + ",id=" + n + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "XML application error notification: Unknown errorCode=" + string);
        }
        switch (dataNotificationEnum) {
            case NEW_DATA: 
            case DATA_CHANGED: {
                if (errorCodes2 != null) {
                    String string4 = null;
                    if (string2 != null) {
                        string4 = this.xmlApplicationDetailPanel.getErrorLabelText(string2);
                    }
                    GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, string4, string3));
                } else {
                    GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
                }
                if (string2 == null) break;
                this.xmlApplicationDetailPanel.markErrorComponent(string2);
                break;
            }
            case DATA_DELETED: {
                if (errorCodes2 != null) {
                    GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, null, null));
                    break;
                }
                GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
                break;
            }
        }
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        XMLApplicationHandler.XMLApplRec xMLApplRec = (XMLApplicationHandler.XMLApplRec)dataRecord;
        this.createXMLApplicationDetailPanel(xMLApplRec, false);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        if (this.xmlApplicationDetailSplitPane.getBottomComponent() != null && this.table.getSelectedRowCount() > 1) {
            this.removeXMLApplicationDetailPanel();
        }
        this.xmlApplicationTaskPanel.setTaskButtonConfigureShow(false);
    }
}

