/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.util;

import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;

public class UtilFilterTable {
    public static boolean setFilterItems(GuiUtilConfiguratorTable guiUtilConfiguratorTable, TableFilter tableFilter) {
        boolean bl = false;
        for (int i = 0; i < 3; ++i) {
            if (tableFilter.isFilterItemSet(i)) {
                bl = true;
                guiUtilConfiguratorTable.setFilter(tableFilter.getFilterItem((int)i).col, tableFilter.getFilterItem((int)i).val, i);
                continue;
            }
            guiUtilConfiguratorTable.setFilter(null, null, i);
        }
        return bl;
    }

    public static class TableFilter {
        public static final int MAX_FILTER = 3;
        UtilFilterItem[] utilFilterItem = new UtilFilterItem[3];

        public void deleteFilterItem() {
            for (int i = 0; i < 3; ++i) {
                this.utilFilterItem[i] = null;
            }
        }

        public boolean setFilterItem(int n, int n2, String string) {
            if (n < 0 || n >= 3) {
                return false;
            }
            if (this.utilFilterItem[n] == null) {
                this.utilFilterItem[n] = new UtilFilterItem(n2, string);
            }
            return true;
        }

        public UtilFilterItem getFilterItem(int n) {
            if (n < 0 || n >= 3) {
                return null;
            }
            return this.utilFilterItem[n];
        }

        public boolean isFilterItemSet(int n) {
            return this.utilFilterItem[n] != null;
        }

        public boolean isFilterAllColumns() {
            if (this.utilFilterItem[0] == null) {
                return false;
            }
            return this.utilFilterItem[0].col == 65535;
        }

        protected String buildKeyVal() {
            String string = "";
            for (int i = 0; i < 3; ++i) {
                if (this.utilFilterItem[i] == null) continue;
                if (i > 0) {
                    string = string.concat(",");
                }
                string = string.concat(String.format("%04x:%s", this.utilFilterItem[i].col, this.utilFilterItem[i].val));
            }
            return string;
        }

        protected String buildSingleKeyVal(int n) {
            String string = "";
            if (n < 3 && this.utilFilterItem[n] != null) {
                string = string.concat(String.format("%04x:%s", this.utilFilterItem[n].col, this.utilFilterItem[n].val));
            }
            return string;
        }

        protected void parseSingleKeyVal(int n, String string) {
            if (string == null) {
                return;
            }
            int n2 = Integer.parseInt(string.substring(0, 4), 16);
            String string2 = string.substring(5);
            this.utilFilterItem[n] = new UtilFilterItem(n2, string2);
        }

        protected void parseKeyVal(String string) {
            if (string == null) {
                return;
            }
            try {
                String[] stringArray = string.split(",");
                if (stringArray == null) {
                    return;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].length() < 6) continue;
                    int n = Integer.parseInt(stringArray[i].substring(0, 4), 16);
                    String string2 = stringArray[i].substring(5);
                    if (n == 65535) {
                        return;
                    }
                    this.utilFilterItem[i] = new UtilFilterItem(n, string2);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.deleteFilterItem();
            }
        }
    }

    public static class UtilFilterItem {
        public static final int FILTER_ALL_COLUMNS = 65535;
        public Integer col = null;
        public String val = null;

        public UtilFilterItem() {
        }

        public UtilFilterItem(int n, String string) {
            this.col = n;
            this.val = string;
        }
    }
}

