/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.util;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.guiutil.GuiUtilTristateCheckBox;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraTextField;
import com.aastra.style.AastraTristateCheckbox;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;

public class UtilMisc {
    private static final Pattern patternPari = Pattern.compile("^[1]{1}[B-Fb-f]{1}[A-Fa-f0-9]{8}$");
    private static final Pattern patternColon = Pattern.compile("^[A-Fa-f0-9]{2}:[A-Fa-f0-9]{2}:[A-Fa-f0-9]{2}:[A-Fa-f0-9]{2}:[A-Fa-f0-9]{2}:[A-Fa-f0-9]{2}$");
    private static final Pattern patternHyphon = Pattern.compile("^[A-Fa-f0-9]{2}-[A-Fa-f0-9]{2}-[A-Fa-f0-9]{2}-[A-Fa-f0-9]{2}-[A-Fa-f0-9]{2}-[A-Fa-f0-9]{2}$");

    public static void addToFieldMap(Map<String, JComponent> map, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, String string, JComponent jComponent) {
        String string2 = commonDataItemEnum.name() + string;
        map.put(string2, jComponent);
    }

    public static JComponent getFromFieldMap(Map<String, JComponent> map, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, String string) {
        String string2 = commonDataItemEnum.name() + string;
        return map.get(string2);
    }

    public static AastraTristateCheckbox.State getRecordsFieldState(DataRecord[] dataRecordArray, int n) {
        AastraTristateCheckbox.State state = AastraTristateCheckbox.DONT_CARE;
        Object object = dataRecordArray[0].getField(n);
        if (object == null) {
            return state;
        }
        boolean bl = (Boolean)object;
        state = bl ? AastraTristateCheckbox.SELECTED : AastraTristateCheckbox.NOT_SELECTED;
        for (int i = 1; i < dataRecordArray.length; ++i) {
            object = dataRecordArray[i].getField(n);
            if (object == null) {
                return AastraTristateCheckbox.DONT_CARE;
            }
            if (bl == (Boolean)object) continue;
            state = AastraTristateCheckbox.DONT_CARE;
            break;
        }
        return state;
    }

    public static Object getRecordsFieldObject(DataRecord[] dataRecordArray, int n) {
        Object object = dataRecordArray[0].getField(n);
        object = object != null && object.getClass() == Integer.class ? new Integer(0) : AastraCommon.AastraTriStateText;
        return UtilMisc.getRecordsFieldObject(dataRecordArray, n, object);
    }

    public static Object getRecordsFieldObject(DataRecord[] dataRecordArray, int n, Object object) {
        Object object2 = dataRecordArray[0].getField(n);
        for (int i = 1; i < dataRecordArray.length; ++i) {
            if (object2 != null && object2.equals(dataRecordArray[i].getField(n))) continue;
            object2 = object;
            break;
        }
        return object2;
    }

    public static void setRecordFromTristateCheckbox(DataRecord dataRecord, GuiUtilTristateCheckBox guiUtilTristateCheckBox, int n) {
        if (guiUtilTristateCheckBox.isEnabled() && guiUtilTristateCheckBox.getState() != GuiUtilTristateCheckBox.DONT_CARE) {
            dataRecord.setField(n, guiUtilTristateCheckBox.isSelected());
        }
    }

    public static void setRecordFromTristateCheckbox(DataRecord dataRecord, GuiUtilTristateCheckBox guiUtilTristateCheckBox, int n, boolean bl) {
        if ((bl || guiUtilTristateCheckBox.isEnabled()) && guiUtilTristateCheckBox.getState() != GuiUtilTristateCheckBox.DONT_CARE) {
            dataRecord.setField(n, guiUtilTristateCheckBox.isSelected());
        }
    }

    public static boolean getPermission(OmiMessage.PermissionType[] permissionTypeArray, OmiMessage.PermissionType permissionType) {
        boolean bl = false;
        if (permissionTypeArray != null) {
            for (int i = 0; i < permissionTypeArray.length; ++i) {
                if (permissionTypeArray[i] != permissionType) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean validateIPAddress(String string) {
        if (string == null || string.length() <= 0) return false;
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 4) return false;
        for (String string2 : stringArray) {
            int n;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n >= 0 && n <= 255) continue;
            return false;
        }
        return true;
    }

    public static boolean validatePari(String string) {
        Matcher matcher = patternPari.matcher(string);
        return matcher.matches();
    }

    public static boolean validateMACAddress(String string) {
        Matcher matcher = patternColon.matcher(string);
        if (matcher.matches()) {
            return true;
        }
        matcher = patternHyphon.matcher(string);
        return matcher.matches();
    }

    public static int getIntFromTextField(AastraTextField aastraTextField, String string, UtilErrorComp utilErrorComp, int n) {
        return UtilMisc.getIntFromTextField(aastraTextField, string, utilErrorComp, n, 0, null);
    }

    public static int getIntFromTextFieldNotNull(AastraTextField aastraTextField, String string, UtilErrorComp utilErrorComp, int n) {
        return UtilMisc.getIntFromTextField(aastraTextField, string, utilErrorComp, n, 1, null);
    }

    public static int getIntFromTextFieldRange(AastraTextField aastraTextField, String string, UtilErrorComp utilErrorComp, int n, int n2, int n3) {
        return UtilMisc.getIntFromTextField(aastraTextField, string, utilErrorComp, n, n2, n3);
    }

    private static int getIntFromTextField(AastraTextField aastraTextField, String string, UtilErrorComp utilErrorComp, int n, Integer n2, Integer n3) {
        int n4 = -1;
        if (aastraTextField.getText().length() > 0) {
            try {
                n4 = Integer.parseInt(aastraTextField.getText(), n);
                if (n2 != null && n4 < n2 || n3 != null && n4 > n3) {
                    n4 = -1;
                    GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_INVALID"), string));
                    utilErrorComp.markComponent(aastraTextField);
                }
            }
            catch (NumberFormatException numberFormatException) {
                GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_INPUT_FORMAT_INVALID"), string));
                utilErrorComp.markComponent(aastraTextField);
            }
        } else {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_MISSING"), string));
            utilErrorComp.markComponent(aastraTextField);
        }
        return n4;
    }

    public static long getLongFromTextField(AastraTextField aastraTextField, String string, UtilErrorComp utilErrorComp, int n) {
        return UtilMisc.getLongFromTextField(aastraTextField, string, utilErrorComp, n, 0L, null);
    }

    private static long getLongFromTextField(AastraTextField aastraTextField, String string, UtilErrorComp utilErrorComp, int n, Long l, Long l2) {
        long l3 = -1L;
        if (aastraTextField.getText().length() > 0) {
            try {
                l3 = Long.parseLong(aastraTextField.getText(), n);
                if (l != null && l3 < l || l2 != null && l3 > l2) {
                    l3 = -1L;
                    GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_INVALID"), string));
                    utilErrorComp.markComponent(aastraTextField);
                }
            }
            catch (NumberFormatException numberFormatException) {
                GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_INPUT_FORMAT_INVALID"), string));
                utilErrorComp.markComponent(aastraTextField);
            }
        } else {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_MISSING"), string));
            utilErrorComp.markComponent(aastraTextField);
        }
        return l3;
    }
}

