/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.videodev;

import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.guiutil.GuiUtilComboBox;
import com.aastra.oamp.guiutil.GuiUtilTextFieldFS;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.videodev.VideoDevConfigMainPanel;
import com.aastra.oamp.videodev.VideoDevDetailPanel;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.VideoDevHandler;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;

public class VideoDevConfigDetailPanel
extends VideoDevDetailPanel {
    private static final long serialVersionUID = 1L;
    private static final int TAB_GENERAL = 0;
    private VideoDevConfigMainPanel videoDevMainPanel = null;
    private VideoDevHandler.VideoDevRec[] videoDevRecords = null;
    private int selectedVideoDev = -1;
    private UtilErrorComp utilErrorComp = null;
    private ActionModeEnum actionMode;

    public VideoDevConfigDetailPanel(VideoDevConfigMainPanel videoDevConfigMainPanel, UtilErrorComp utilErrorComp) {
        this.videoDevMainPanel = videoDevConfigMainPanel;
        this.utilErrorComp = utilErrorComp;
        this.initialize();
    }

    private void initialize() {
        this.utilChangeHandler = new GuiUtilChangeHandler(this.getButtonOK(), this.getButtonCancel(), false);
        this.panelTabbed.addTab(UtilLocale.getString("TXT_GENERAL"), this.getTabGeneral());
        this.panelTabbed.addTab(UtilLocale.getString("TXT_VIDEO"), this.getTabVideo());
        this.panelButtonBar.add(this.getButtonOK());
        this.panelButtonBar.add(this.getButtonCancel());
    }

    @Override
    protected AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            super.getButtonOK();
            this.buttonOK.setBounds(70, 15, 90, 25);
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VideoDevConfigDetailPanel.this.utilChangeHandler.deactivate();
                    VideoDevConfigDetailPanel.this.utilErrorComp.clearComponents();
                    if (VideoDevConfigDetailPanel.this.actionMode == ActionModeEnum.CHANGE) {
                        VideoDevConfigDetailPanel.this.videoDevMainPanel.changeVideoDev();
                    } else {
                        VideoDevConfigDetailPanel.this.videoDevMainPanel.createVideoDev();
                    }
                }
            });
        }
        return this.buttonOK;
    }

    @Override
    protected AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            super.getButtonCancel();
            this.buttonCancel.setBounds(230, 15, 90, 25);
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VideoDevConfigDetailPanel.this.utilChangeHandler.deactivate();
                    VideoDevConfigDetailPanel.this.videoDevMainPanel.removeVideoDevDetailPanel();
                }
            });
        }
        return this.buttonCancel;
    }

    public void setVideoDevDetailData(DataRecord[] dataRecordArray) {
        if (dataRecordArray != null) {
            Object object;
            OmiMessage.VideoDevStateType videoDevStateType = null;
            this.videoDevRecords = new VideoDevHandler.VideoDevRec[dataRecordArray.length];
            for (int i = 0; i < this.videoDevRecords.length; ++i) {
                this.videoDevRecords[i] = (VideoDevHandler.VideoDevRec)dataRecordArray[i].clone();
            }
            this.selectedVideoDev = (Integer)dataRecordArray[0].getField(0);
            if (dataRecordArray.length == 1) {
                this.labelHeaderBar.setText(String.format(UtilLocale.getString("TXT_VIDEO_DEVICE") + " #0x%03X", (Integer)dataRecordArray[0].getField(0)));
                videoDevStateType = (OmiMessage.VideoDevStateType)((Object)dataRecordArray[0].getField(5));
                String string = (String)dataRecordArray[0].getField(9);
                if (string.length() <= 0) {
                    this.textFieldBuilding.setText("");
                    this.disableTextFieldFloor();
                    this.disableTextFieldRoom();
                } else {
                    this.textFieldBuilding.setText(string);
                    this.textFieldFloor.setEditable(true);
                    object = (String)dataRecordArray[0].getField(10);
                    if (((String)object).length() <= 0) {
                        this.textFieldFloor.setText("");
                        this.disableTextFieldRoom();
                    } else {
                        this.textFieldFloor.setText((String)object);
                        this.textFieldRoom.setEditable(true);
                        this.textFieldRoom.setText((String)dataRecordArray[0].getField(11));
                    }
                }
            } else if (dataRecordArray.length > 1) {
                int n;
                String string = " ";
                for (n = 0; n < dataRecordArray.length; ++n) {
                    string = string + String.format("#0x%03X ", (Integer)dataRecordArray[n].getField(0));
                    if (n <= 3) continue;
                    string = string + " ...";
                    break;
                }
                for (n = 0; n < dataRecordArray.length && (videoDevStateType = (OmiMessage.VideoDevStateType)((Object)dataRecordArray[n].getField(5))) != OmiMessage.VideoDevStateType.active; ++n) {
                }
                this.labelHeaderBar.setText(UtilLocale.getString("TXT_VIDEO_DEVICES") + string);
                this.textFieldBuilding.setText((String)UtilMisc.getRecordsFieldObject(dataRecordArray, 9));
                this.disableTextFieldFloor();
                this.disableTextFieldRoom();
            }
            this.checkBoxActive.setState(UtilMisc.getRecordsFieldState(dataRecordArray, 4));
            this.textFieldName.setText((String)UtilMisc.getRecordsFieldObject(dataRecordArray, 6));
            this.textFieldSiteName.setText((String)UtilMisc.getRecordsFieldObject(dataRecordArray, 8));
            String string = null;
            object = UtilMisc.getRecordsFieldObject(dataRecordArray, 13, AastraCommon.AastraTriStateText);
            string = object instanceof String ? (String)object : object.toString();
            this.comboBoxResolution.setEditable(true);
            this.comboBoxResolution.setSelectedItem(string);
            this.comboBoxResolution.setEditable(false);
            if (videoDevStateType == OmiMessage.VideoDevStateType.active) {
                this.comboBoxResolution.setEnabled(false);
            } else {
                this.comboBoxResolution.setEnabled(true);
            }
            object = UtilMisc.getRecordsFieldObject(dataRecordArray, 14, AastraCommon.AastraTriStateText);
            string = object instanceof String ? (String)object : object.toString();
            this.comboBoxFrameRate.setEditable(true);
            this.comboBoxFrameRate.setSelectedItem(string);
            this.comboBoxFrameRate.setEditable(false);
            if (videoDevStateType == OmiMessage.VideoDevStateType.active) {
                this.comboBoxFrameRate.setEnabled(false);
            } else {
                this.comboBoxFrameRate.setEnabled(true);
            }
            this.actionMode = ActionModeEnum.CHANGE;
        } else {
            this.videoDevRecords = new VideoDevHandler.VideoDevRec[1];
            this.videoDevRecords[0] = new VideoDevHandler.VideoDevRec();
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_NEW_VIDEO_DEVICE"));
            this.textFieldName.setText("");
            this.textFieldSiteName.setText("");
            this.textFieldBuilding.setText("");
            this.disableTextFieldFloor();
            this.disableTextFieldRoom();
            this.checkBoxActive.setSelected(false);
            this.comboBoxResolution.setEditable(true);
            this.comboBoxResolution.setSelectedItem((Object)OmiMessage.VideoDevResolutionType.SVGA);
            this.comboBoxResolution.setEditable(false);
            this.comboBoxResolution.setEnabled(true);
            this.comboBoxFrameRate.setEditable(true);
            this.comboBoxFrameRate.setSelectedItem(OmiMessage.VideoDevFrameRateType.FR_10.getAxiVal());
            this.comboBoxFrameRate.setEditable(false);
            this.comboBoxFrameRate.setEnabled(true);
            this.actionMode = ActionModeEnum.CREATE;
        }
        this.utilChangeHandler.initRootPane(this.getRootPane());
        this.utilChangeHandler.deactivate();
    }

    public DataRecord[] getVideoDevDetailData() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!this.textFieldName.getText().equals(AastraCommon.AastraTriStateText)) {
            bl = true;
        }
        bl2 = this.textFieldBuilding.isChange();
        String string = this.textFieldBuilding.getText();
        if (!string.equals(AastraCommon.AastraTriStateText)) {
            if (bl2) {
                bl3 = true;
                bl4 = true;
            }
            if (this.textFieldFloor.isChange()) {
                bl3 = true;
                bl4 = true;
            }
            if (this.textFieldRoom.isChange()) {
                bl4 = true;
            }
        }
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (bl2 && (string = this.textFieldBuilding.getText()) != null) {
            string2 = string;
        }
        if (bl3 && (string = this.textFieldFloor.getText()) != null) {
            string3 = string;
        }
        if (bl4 && (string = this.textFieldRoom.getText()) != null) {
            string4 = string;
        }
        for (int i = 0; i < this.videoDevRecords.length; ++i) {
            if (bl) {
                this.videoDevRecords[i].setField(6, this.textFieldName.getText());
            }
            if (bl2) {
                this.videoDevRecords[i].setField(9, string2);
            }
            if (bl3) {
                this.videoDevRecords[i].setField(10, string3);
            }
            if (bl4) {
                this.videoDevRecords[i].setField(11, string4);
            }
            UtilMisc.setRecordFromTristateCheckbox(this.videoDevRecords[i], this.checkBoxActive, 4);
            this.videoDevRecords[i].setField(13, (Object)OmiMessage.VideoDevResolutionType.guiValueToEnum((String)this.comboBoxResolution.getSelectedItem()));
            this.videoDevRecords[i].setField(14, (Object)OmiMessage.VideoDevFrameRateType.guiValueToEnum((String)this.comboBoxFrameRate.getSelectedItem()));
        }
        return this.videoDevRecords;
    }

    public int getSelectedVideoDev() {
        return this.selectedVideoDev;
    }

    @Override
    protected AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            super.getTabGeneral();
            this.utilErrorComp.putWithTab(OmiMessage.VideoDevType.name.toString(), this.labelName, this.textFieldName, 0);
            this.utilErrorComp.putWithTab(OmiMessage.VideoDevType.hierarchy1.toString(), this.labelBuilding, this.textFieldBuilding, 0);
            this.utilErrorComp.putWithTab(OmiMessage.VideoDevType.hierarchy2.toString(), this.labelFloor, this.textFieldFloor, 0);
            this.utilErrorComp.putWithTab(OmiMessage.VideoDevType.hierarchy3.toString(), this.labelRoom, this.textFieldRoom, 0);
        }
        return this.tabGeneral;
    }

    @Override
    protected GuiUtilTextFieldFS getTextFieldBuilding() {
        if (this.textFieldBuilding == null) {
            super.getTextFieldBuilding();
            this.textFieldBuilding.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    char c = keyEvent.getKeyChar();
                    if (c != '\n' && VideoDevConfigDetailPanel.this.utilChangeHandler != null) {
                        VideoDevConfigDetailPanel.this.utilChangeHandler.activate();
                    }
                    if (VideoDevConfigDetailPanel.this.textFieldBuilding.isSet()) {
                        VideoDevConfigDetailPanel.this.textFieldFloor.setEditable(true);
                    } else {
                        VideoDevConfigDetailPanel.this.disableTextFieldFloor();
                        VideoDevConfigDetailPanel.this.disableTextFieldRoom();
                    }
                }
            });
        }
        return this.textFieldBuilding;
    }

    @Override
    protected GuiUtilTextFieldFS getTextFieldFloor() {
        if (this.textFieldFloor == null) {
            super.getTextFieldFloor();
            this.textFieldFloor.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    char c = keyEvent.getKeyChar();
                    if (c != '\n' && VideoDevConfigDetailPanel.this.utilChangeHandler != null) {
                        VideoDevConfigDetailPanel.this.utilChangeHandler.activate();
                    }
                    if (VideoDevConfigDetailPanel.this.textFieldFloor.isSet()) {
                        VideoDevConfigDetailPanel.this.textFieldRoom.setEditable(true);
                    } else {
                        VideoDevConfigDetailPanel.this.disableTextFieldRoom();
                    }
                }
            });
        }
        return this.textFieldFloor;
    }

    @Override
    protected GuiUtilTextFieldFS getTextFieldRoom() {
        if (this.textFieldRoom == null) {
            super.getTextFieldRoom();
            this.textFieldRoom.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    char c = keyEvent.getKeyChar();
                    if (c != '\n' && VideoDevConfigDetailPanel.this.utilChangeHandler != null) {
                        VideoDevConfigDetailPanel.this.utilChangeHandler.activate();
                    }
                }
            });
        }
        return this.textFieldRoom;
    }

    @Override
    protected GuiUtilComboBox getComboBoxResolution() {
        if (this.comboBoxResolution == null) {
            super.getComboBoxResolution();
            this.comboBoxResolution.activateActionListener();
        }
        return this.comboBoxResolution;
    }

    @Override
    protected GuiUtilComboBox getComboBoxFrameRate() {
        if (this.comboBoxFrameRate == null) {
            super.getComboBoxFrameRate();
            this.comboBoxFrameRate.activateActionListener();
        }
        return this.comboBoxFrameRate;
    }

    public void markErrorComponent(String string) {
        JComponent jComponent = this.utilErrorComp.getField(string);
        if (jComponent != null) {
            this.panelTabbed.setSelectedIndex(this.utilErrorComp.getTab(string));
            this.utilErrorComp.markComponent(jComponent);
        }
    }

    public String getErrorLabelText(String string) {
        if (string == null) {
            return null;
        }
        return this.utilErrorComp.getLabelText(string);
    }

    public void requestDefaultFocusInWindow() {
        this.checkBoxActive.requestFocusInWindow();
    }

    private void disableTextFieldFloor() {
        this.textFieldFloor.setText("");
        this.textFieldFloor.setEditable(false);
        this.utilErrorComp.clearComponent(this.textFieldFloor);
    }

    private void disableTextFieldRoom() {
        this.textFieldRoom.setText("");
        this.textFieldRoom.setEditable(false);
        this.utilErrorComp.clearComponent(this.textFieldRoom);
    }

    private static enum ActionModeEnum {
        CREATE,
        CHANGE;

    }
}

