/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.videodev;

import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.oamp.videodev.VideoDevDetailPanel;
import com.aastra.oamp.videodev.VideoDevMonitorMainPanel;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.VideoDevHandler;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class VideoDevMonitorDetailPanel
extends VideoDevDetailPanel {
    private static final long serialVersionUID = 1L;
    private VideoDevMonitorMainPanel videoDevMainPanel = null;

    public VideoDevMonitorDetailPanel(VideoDevMonitorMainPanel videoDevMonitorMainPanel) {
        this.videoDevMainPanel = videoDevMonitorMainPanel;
        this.panelTabbed.addTab(UtilLocale.getString("TXT_STATUS"), this.getTabStatus());
        this.panelTabbed.addTab(UtilLocale.getString("TXT_GENERAL"), this.getTabGeneral());
        this.panelTabbed.addTab(UtilLocale.getString("TXT_VIDEO"), this.getTabVideo());
        this.panelButtonBar.add(this.getButtonCancel());
    }

    @Override
    protected AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            super.getButtonCancel();
            this.buttonCancel.setBounds(120, 15, 90, 25);
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (VideoDevMonitorDetailPanel.this.videoDevMainPanel != null) {
                        VideoDevMonitorDetailPanel.this.videoDevMainPanel.removeVideoDevDetailPanel();
                    }
                }
            });
        }
        return this.buttonCancel;
    }

    public void setVideoDevDetailData(VideoDevHandler.VideoDevRec videoDevRec) {
        if (videoDevRec != null) {
            this.labelHeaderBar.setText(String.format(UtilLocale.getString("TXT_VIDEO_DEVICE") + " #0x%03X", (Integer)videoDevRec.getField(0)));
            this.textFieldTag.setText((String)videoDevRec.getField(1));
            this.textFieldRfpId.setText(String.format("0x%03X", (Integer)videoDevRec.getField(2)));
            this.textFieldUsbPath.setText((String)videoDevRec.getField(3));
            OmiMessage.VideoDevStateType videoDevStateType = (OmiMessage.VideoDevStateType)((Object)videoDevRec.getField(5));
            if (videoDevStateType != null) {
                this.labelStateIcon.setIcon(GuiUtilIcon.getIconArray_Disconnect_OK_Eye_Error()[videoDevStateType.ordinal()]);
                this.labelStateIcon.setToolTipText(videoDevStateType.toString());
            } else {
                this.labelStateIcon.setIcon(null);
                this.labelStateIcon.setToolTipText(null);
            }
            int n = (Integer)videoDevRec.getField(15);
            this.textFieldPPNCount.setText(String.valueOf(n));
            if (n > 0) {
                int[] nArray = videoDevRec.getPPNList();
                this.labelPPNList.setVisible(true);
                for (int i = 0; i < 10; ++i) {
                    this.textFieldPPNList[i].setVisible(true);
                    if (i < n) {
                        this.textFieldPPNList[i].setText(String.format("0x%03X", nArray[i]));
                        continue;
                    }
                    this.textFieldPPNList[i].setText("");
                }
            } else {
                this.labelPPNList.setVisible(false);
                for (int i = 0; i < 10; ++i) {
                    this.textFieldPPNList[i].setVisible(false);
                    this.textFieldPPNList[i].setText("");
                }
            }
            this.textFieldName.setText((String)videoDevRec.getField(6));
            this.textFieldSiteName.setText((String)videoDevRec.getField(8));
            this.textFieldBuilding.setText((String)videoDevRec.getField(9));
            this.textFieldFloor.setText((String)videoDevRec.getField(10));
            this.textFieldRoom.setText((String)videoDevRec.getField(11));
            this.checkBoxActive.setSelected((Boolean)videoDevRec.getField(4));
            this.comboBoxResolution.setEditable(true);
            this.comboBoxResolution.setSelectedItem(((OmiMessage.VideoDevResolutionType)((Object)videoDevRec.getField(13))).toString());
            this.comboBoxResolution.setEditable(false);
            this.comboBoxFrameRate.setEditable(true);
            this.comboBoxFrameRate.setSelectedItem(((OmiMessage.VideoDevFrameRateType)((Object)videoDevRec.getField(14))).toString());
            this.comboBoxFrameRate.setEditable(false);
        } else {
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_RECORD_INVALID"));
            this.textFieldTag.setText("");
            this.textFieldRfpId.setText("");
            this.textFieldUsbPath.setText("");
            this.labelStateIcon.setIcon(null);
            this.labelStateIcon.setToolTipText(null);
            this.textFieldBuilding.setText("");
            this.textFieldFloor.setText("");
            this.textFieldRoom.setText("");
            this.checkBoxActive.setSelected(false);
            this.comboBoxResolution.setSelectedItem(OmiMessage.VideoDevResolutionType.SVGA.toString());
            this.comboBoxFrameRate.setSelectedItem(OmiMessage.VideoDevFrameRateType.FR_10.toString());
        }
        if (this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(this.getButtonCancel());
            this.getButtonCancel().requestFocusInWindow();
        }
    }

    @Override
    protected AastraPanel getTabStatus() {
        if (this.tabStatus == null) {
            super.getTabStatus();
            UtilSetPanelEditable.setDisabled(this.tabStatus);
        }
        return this.tabStatus;
    }

    @Override
    protected AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            super.getTabGeneral();
            UtilSetPanelEditable.setDisabled(this.tabGeneral);
        }
        return this.tabGeneral;
    }

    @Override
    protected AastraPanel getTabVideo() {
        if (this.tabVideo == null) {
            super.getTabVideo();
            UtilSetPanelEditable.setDisabled(this.tabVideo);
        }
        return this.tabVideo;
    }
}

